#!/bin/bash
DES_BASE_PATH="/home/omuser"
DES_OWNER="root:root"
DES_MOD_PERM="740"
LOG_FILE="/var/log/remote_exec.log"
#1MB
g_logSizeThreshold=1000000
LOG_DEL_LINENR=10000
RUN_SCRIPT="clusterid_tool.sh"

function LOG()
{
    local logFile=${LOG_FILE}
    echo [$(date "+%4Y%2m%2d%2H%2M%2S")][$0][$$][${FUNCNAME[1]}]"$@" >> ${logFile}
}

function LOG_WITH_RC()
{
    local rc=$1
    shift 1
    local logFile=${LOG_FILE}
    echo [$(date "+%4Y%2m%2d%2H%2M%2S")][$0][$$][${FUNCNAME[1]}]"$@" >> ${logFile}
    return $rc
}

function adjLogSize()
{
    local rc=0
    if [ -f ${LOG_FILE} ];then
        local cur_size=$(stat ${LOG_FILE} | grep "Size:" | awk '{print $2}')
        if [ ${cur_size} -gt ${g_logSizeThreshold} ];then
            local cut_nr=${LOG_DEL_LINENR}
            sed -i "1,${cut_nr}d" ${LOG_FILE} 
            rc=$?
            if [ 0 -ne ${rc} ];then
                LOG "sed -i "1,${cut_nr}d" ${LOG_FILE} fail with ${rc}!"
                return ${rc}
            fi
        fi
    fi
    return 0
}

function encode()
{
    local strencode=$(echo $* | base64 -i)
    if [ "X" != "${strencode}" ];then
        echo ${strencode}
        return 0
    fi
    strencode=0
    return 1    
}

function decode()
{
    local strdecode=$(echo $* | base64 -d)
    if [ "X" != "${strdecode}" ];then
        echo ${strdecode}
        return 0
    fi
    strdecode=0
    return 1 
}

function do_execute()
{
    local cur_path=$(dirname $0)
    local cmd="$*"
    local rc=0
    sh ${cur_path} ${cmd}
    rc=$?
    if [ 0 -eq ${rc} ];then
        LOG "[$LINENO]INFO: sh ${cur_path} ${cmd} execute ok"
        echo "execute successfully."
    else
        LOG "[$LINENO]Warning: sh ${cur_path} ${cmd} execute FAIL with ${rc}"
        echo "execute FAIL!"
    fi
    return ${rc}
}
