#!/bin/bash
trap 'stty echo; echo -e "\nQuit!"; exit 1' SIGHUP
trap 'stty echo; echo -e "\nQuit!"; exit 1' SIGINT
trap 'stty echo; echo -e "\nQuit!"; exit 1' SIGQUIT
trap 'stty echo; echo -e "\nQuit!"; exit 1' SIGABRT
trap 'stty echo; echo -e "\nQuit!"; exit 1' SIGTERM

CUR_PATH="$(dirname $0)"
if [ "." = "${CUR_PATH}" ];then
    CUR_PATH=${PWD}
fi

TMP_PATH="${CUR_PATH}/temp"
g_node_info="${TMP_PATH}/_nas_node_list_"
g_remote_exec_ret="${TMP_PATH}/.remote.exec.result"
g_check_install_retf="${TMP_PATH}/.check.install.redirect"
g_install_result="${TMP_PATH}/.install.result"
g_scp_output="${TMP_PATH}/.scp.output"
g_exec_output="${TMP_PATH}/.exec.output"
g_tmp_nodelist="${TMP_PATH}/.tmp.nodelist"

LOC_FILES=""
OMUSER_PASSWD_ENCODED=
ROOT_PASSWD_ENCODED=
g_row_num=0
g_my_nid=0

. ${CUR_PATH}/local_exec/exec_utility.sh
UTILITY_SCRIPT="exec_utility.sh"


function encode()
{
    local strencode=$(echo $* | base64 -i)
    if [ "X" != "${strencode}" ];then
        echo ${strencode}
        return 0
    fi
    strencode=0
    return 1    
}

function decode()
{
    local strdecode=$(echo $* | base64 -d)
    if [ "X" != "${strdecode}" ];then
        echo ${strdecode}
        return 0
    fi
    strdecode=0
    return 1 
}

#parameters:
#   scp
#   exec cmd 

#each_node_do "./scp.expect" "/home/omuser/.patch_script_tmp $nip /home/omuser/.patch_script_tmp "$password_om"
# ./exec.expect $nip "$password_om" "$password_root" "cd /home/omuser/.patch_script_tmp/;cp -f crontask.sh /opt/huawei/snas/bin/crontask.sh;cp -f checkpatchactive.sh cluster_patch.sh node_patch.sh patch_utility.sh /opt/huawei/snas/upd/patch_script/;cp -f localexec2.py /opt/huawei/deploy/script/;cp -f localexec2.py /opt/huawei/deploy/script/local_bak_exec;rm -rf /home/omuser/.patch_script_tmp;sh /opt/huawei/deploy/script/localexec_start.sh >/dev/null 2>&1" 30

function each_node_do()
{
    local exp_type=$1
    shift 1
    local cmd="$*"    
    local node_info="${g_node_info}"
    
    local nid_nip=0
    local i=1
    local tmp_nid=0
    local password_om=""
    local password_root=""
    local all_ok=0
    local mynid=0
    local myip=0
    local fail_ips=""
    local outfile=""

    if [ "X" = "${OMUSER_PASSWD_ENCODED}" ] || [ "X" = "${ROOT_PASSWD_ENCODED}" ];then
        LOG "[$LINENO]ERROR: omuser or root's password are null!"
        return 1
    fi    
    if [ "X" = "X${g_row_num}" ] || [ 0 -eq ${g_row_num} ];then
        LOG "[$LINENO]ERROR: node list is invalid, line number:${g_row_num}!"
        return 1
    fi
    if [ "X" = "X${g_my_nid}" ] || [ 0 -eq ${g_my_nid} ];then
        LOG "[$LINENO]ERROR: my nid is invalid, nid:${g_my_nid}!"
        return 1
    fi
    if [ ! -f ${node_info} ];then
        LOG "[$LINENO]ERROR: node list file ${node_info} not exist!"
        return 1
    fi
 
    password_om=$(decode ${OMUSER_PASSWD_ENCODED} || LOG_WITH_RC "$? [$LINENO]ERROR: decode omuser fail with $?" || return $? )
    password_root=$(decode ${ROOT_PASSWD_ENCODED})
    if [ 0 -ne $? ] || [ "X" = "X${password_root}" ];then
        LOG "[$LINENO]ERROR: get password of root fail!"
        return 1
    fi
    
    while [ ${i} -le ${g_row_num} ]
    do
        
        nid_nip=$(awk "NR==$i" ${node_info})
        LOG "[$LINENO]----------------${nid_nip}------------------------"
        let i=${i}+1
        
        nid=$(echo ${nid_nip}|awk -F '|' '{print $1}')
        nip=$(echo ${nid_nip}|awk -F '|' '{print $2}')

        if [[ ${nid} -eq ${tmp_nid} ]];then
            LOG "[$LINENO]read nid=$nid, nip=$nip, continue....."
            continue
        fi
        
        tmp_nid=${nid}
        LOG "[$LINENO]read nid=${nid}, nip=${nip}, tmp_nid=${tmp_nid}"
        
        if [ "X" = "X${exp_type}" ];then
            LOG "[$LINENO]ERROR: invalid parameters, type is null"
            return 1
        elif [ "scp" = "${exp_type}" ];then
            ./scp.expect ${CUR_PATH}/local_exec.tar.gz $nip /home/omuser/ "${password_om}" 
            if [ $? -eq 123 ]; then
                LOG "[$LINENO]ERROR: Incorrect password!"
                echo "ERR: Incorrect password!"
                exit 1
            fi
        elif [ "exec" = "${exp_type}" ];then
            ./exec.expect $nip "$password_om" "$password_root" "${cmd}" 900
            if [ $? -eq 123 ]; then
                LOG "[$LINENO]ERROR: Incorrect password! when exec ${cmd}"
                echo "ERR: Incorrect password!"
                exit 1
            fi
        else
            LOG "[$LINENO]ERROR: invalid parameters, type is: ${exp_type}"
            return 1
        fi
        let j+=1
    done    

    if [ 0 -eq ${all_ok} ];then
        LOG "[$LINENO]INFO:All Successfully!"
        echo "All Successfully!"
    else
        echo "Fail nodes: ${fail_ips}"
        LOG "[$LINENO]Warning: nodes execute fail. nodes:${fail_ips}"
        return 1
    fi
    return 0
}

#配合each_node_do使用. 判断各节点执行是否ok。0:ok 1:fail
#注意传入的str_of_ok为成功的标识，而且一个节点只能有一条。会从结果文件过滤该字符串用于判断是否每个节点都成功了
#eg1: each_node_do scp将/home/omuser/local_exec.tar.gz
#        分发到所有节点的/home/omuser下。执行后需要执行each_node_do exec中的file /var/log/local_exec/exec_utility.sh来判断远端是否执行成功了。即可以参考eg2
#        
#eg2: each_node_do exec "mv /home/omuser/local_exec.tar.gz /var/log/; cd /var/log/; tar xvf local_exec.tar.gz; file /var/log/local_exec/exec_utility.sh" > /home/omuser/remote_do/.exec_mv.ret
#       is_all_node_exec_ok /home/omuser/remote_do/.exec_mv.ret "shell script"
#           file /var/log/local_exec/exec_utility.sh的输出为:local_exec/exec_utility.sh: Bourne-Again shell script text。所以可以用"shell script"来判断你是否执行成功了
function is_all_node_exec_ok()
{
    local ret_file=$1
    local ret_ofile=$2
    shift 2
    local str_of_ok="$*"
    local linenr=0
    local nodenr=0
    local tmp_ofile="${TMP_PATH}/.tmp.remote.result"
    local tmp_iplistfile="${TMP_PATH}/.tmp.nodelist.result"
    local rec=""
    local ret_str=""
    local ret_ip=""
    
    if [ "X" = "X${ret_file}" ] || [ ! -f ${ret_file} ] || [ "X" = "X${str_of_ok}" ];then
        LOG "[$LINENO]ERROR: return record file ${ret_file} not exist! or result string(${str_of_ok}) is null!"
        return 1
    fi
    linenr=$(grep "${str_of_ok}" ${ret_file} | wc -l)
    nodenr=$(/usr/bin/sqlite3 /opt/huawei/snas/etc/cm_conf.db "select * from CM_NODE_T" | wc -l)
    if [ 0 -ne ${linenr} ] && [ 0 -ne ${nodenr} ] && [ ${linenr} -ge ${nodenr} ];then
        LOG "[$LINENO]INFO: all node check ok(${linenr}/${nodenr})!"
        return 0
    fi
    #there are some nodes, execute fail. find out them.
    if [ -f ${tmp_ofile} ];then
        rm ${tmp_ofile}
    fi
    if [ -f ${ret_ofile} ];then
        rm ${ret_ofile}
    fi
    if [ -f ${tmp_iplistfile} ];then
        rm ${tmp_iplistfile}
    fi
    
    egrep "spawn|${str_of_ok}" ${ret_file} > ${tmp_ofile} ||  LOG_WITH_RC "$? [$LINENO]ERROR: egrep 'spawn|${str_of_ok}' ${ret_file} | sort -n -k 1 > ${tmp_ofile} fail with $?" || return $?
    awk -v key="${str_of_ok}" 'BEGIN{begin=1;end=0;last=""}{ if($0~"spawn"){ if(begin==0){ if(end==1){print "FAIL: "last} else{print "Success: "last}  }  ; end=1; begin=0; last=$0 } else{ if($0~key){end=0} }  }END{if(end==1){print "FAIL: "last} }' ${tmp_ofile} |sort -n -k 1 > ${tmp_iplistfile} ||  LOG_WITH_RC "$? [$LINENO]ERROR: cat ${tmp_ofile} and get result > ${tmp_iplistfile} fail with $?" || return $?
    #in ret_ofile:
        #FAIL :spawn ssh omuser@xx.xx.xx.xx
        #FAIL :omuser@S3-62-206:~> spawn ssh omuser@xx.xx.xx.xx
        #Success: omuser@Node62-7:~> spawn ssh omuser@xx.xx.xx.xx
        #Success: omuser@Node62-8:~> spawn ssh omuser@xx.xx.xx.xx
        #Success: omuser@S3-62-212:~> spawn ssh omuser@xx.xx.xx.xx
        #FAIL: omuser@Node72-1:~> spawn ssh omuser@xx.xx.xx.xx
    if [ -f ${tmp_iplistfile} ];then
        linenr=$(cat ${tmp_iplistfile} | wc -l)
        if [ 0 -lt ${linenr} ];then
            while read rec
            do
                if [ "X" = "X${rec}" ];then
                    continue
                fi
                ret_str=$(echo ${rec} | awk -F ":" '{print $1}')
                ret_ip=${rec##*@}
                if [ "X" != "X${ret_str}" ] && [ "X" != "X${ret_ip}" ];then
                    echo "${ret_str}: ${ret_ip}" >> ${ret_ofile} || LOG_WITH_RC "$? [$LINENO]ERROR: echo ${ret_str}: ${str_ip} > ${ret_ofile} fail with $?" || return $?
                else
                    LOG "[$LINENO]ERROR: get result:${ret_str} or ip:${ret_ip} fail from record:${rec}"
                    return 1
                fi
            done < ${tmp_iplistfile}
            LOG "[$LINENO]INFO: get fail and successful list of nodes ok."
            return 0
        fi
    fi    
    
    LOG "[$LINENO]ERROR: get fail and successful list of nodes fail!"
    return 1
}

function let_myselt_to_end()
{
    local mynid=$1
    local nodelist=$2
    if [ -z "${mynid}" ] || [ -z "${nodelist}" ] || [ ! -f ${nodelist} ];then
        LOG "[$LINENO]ERROR: input nid:${mynid} is null or file ${nodelist} not exist!"
        return 1
    fi
    local tmp_file=${g_tmp_nodelist}
    if [ -z "${tmp_file}" ];then
        LOG "[$LINENO]ERROR: temp file ${tmp_file} is null!"
        return 1
    fi
    grep -nw ${mynid} ${nodelist} | sort -n -k 1 -r > ${tmp_file}  || LOG_WITH_RC "$? [$LINENO]ERROR: grep -nw ${mynid} ${nodelist} | sort -n -k 1 -r > ${tmp_file} fail with $?" || return $?
    local record=""
    while read record
    do
        #record  1:15878|xx.xx.xx.xx
        local linenr=$(echo ${record} | awk -F ':' '{print $1}')
        local content=$(echo ${record} | awk -F ':' '{print $2}')
        sed -i ${linenr}d ${nodelist}
        echo "${content}" >> ${nodelist}
        LOG "[$LINENO]INFO: update ${record} to end of ${nodelist}"
    done < ${tmp_file}
    LOG "[$LINENO]INFO: update ${mynid} of ${nodelist} ok."
    return 0    
}

function prepare()
{
    local node_info="${g_node_info}"
    if [ ! -f ${CUR_PATH}/scp.expect ] || [ ! -f ${CUR_PATH}/exec.expect ];then
        LOG "[$LINENO]ERROR: ${CUR_PATH}/scp.expect or ${CUR_PATH}/exec.expect not exist!"
        return 1
    fi
    
    if [ ! -d ${TMP_PATH} ];then
        mkdir -p ${TMP_PATH}
    fi
    
    chmod 700 ./scp.expect
    chmod 700 ./exec.expect
    > /var/log/scp_result.log

    /usr/bin/sqlite3 /opt/huawei/snas/etc/cm_conf.db "select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID" > ${node_info} || LOG_WITH_RC "$? [$LINENO]ERROR: get node info to ${node_info} fail with $?" || return $?
    g_row_num=$(cat $node_info|wc -l)
    g_my_nid=$(cat /opt/huawei/snas/etc/cm.ini | grep "NID=" | awk -F= '{print $2}')
    let_myselt_to_end ${g_my_nid} ${node_info} || LOG_WITH_RC "$? [$LINENO]ERROR: let_myselt_to_end ${g_my_nid} ${node_info} fail with $?" || return $?

    local des_base_path=$(grep DES_BASE_PATH ${CUR_PATH}/local_exec/${UTILITY_SCRIPT} | awk -F '=' '{print $2}' | sed 's/"//g')
    local des_owner=$(grep DES_OWNER ${CUR_PATH}/local_exec/${UTILITY_SCRIPT} | awk -F '=' '{print $2}' | sed 's/"//g')
    local des_chmod_perm=$(grep DES_MOD_PERM ${CUR_PATH}/local_exec/${UTILITY_SCRIPT} | awk -F '=' '{print $2}' | sed 's/"//g')
    if [ "X" = "X${des_base_path}" ] || [ "X" == "X${des_owner}" ] || [ "X" == "X${des_chmod_perm}" ];then
        LOG "[$LINENO]ERROR: get path , owner chmod permit fail!"
        echo "ERROR: get path , owner chmod permit fail!"
        return 1
    fi
    
    local rc=0
    local f=""
    pushd ${PWD} > /dev/null 2>&1 || LOG_WITH_RC "$? [$LINENO]ERROR:pushd ${PWD} fail with $?" || return $?
    chown ${des_owner} ${CUR_PATH}/local_exec || LOG_WITH_RC "$? [$LINENO]ERROR: chown ${CUR_PATH}/local_exec fail with $?" || return $?
    chmod ${des_chmod_perm} ${CUR_PATH}/local_exec ||  LOG_WITH_RC "$? [$LINENO]ERROR: chmod ${CUR_PATH}/local_exec fail with $?" || return $?
    cd ${CUR_PATH}/local_exec
    LOC_FILES=$(ls | grep -v ${UTILITY_SCRIPT})
    for f in ${LOC_FILES}
    do
        chown ${des_owner} ${f} || LOG_WITH_RC "$? [$LINENO]ERROR: chown ${des_owner} ${f} fail with $?" || return $?
        chmod ${des_chmod_perm} ${f} ||  LOG_WITH_RC "$? [$LINENO]ERROR: chmod ${des_chmod_perm} ${f} fail with $?" ||  return $?
    done
    chmod +x ${CUR_PATH}/local_exec/${UTILITY_SCRIPT}
        
    if [ -f ${CUR_PATH}/local_exec.tar.gz ];then
        rm ${CUR_PATH}/local_exec.tar.gz
    fi
    cd ${CUR_PATH}
    tar zcvf local_exec.tar.gz local_exec > /dev/null || LOG_WITH_RC "$? [$LINENO]ERROR: tar zcvf local_exec.tar.gz local_exec fail with $?" || return $?
    chown omuser:group9000 ${CUR_PATH}/local_exec.tar.gz || LOG_WITH_RC "$? [$LINENO]ERROR: chown omuser:group9000 ${CUR_PATH}/local_exec.tar.gz fail with $?" || return $?
    chmod 640 ${CUR_PATH}/local_exec.tar.gz ||  LOG_WITH_RC "$? [$LINENO]ERROR: chmod 640 ${CUR_PATH}/local_exec.tar.gz fail with $?" || return $?
    popd > /dev/null 2>&1 || LOG "[$LINENO]Warning(ignored): popd > /dev/null 2>&1 fail with $?"
 
    return 0
}

function get_passwd()
{
    local password_om=""
    local password_root=""
    
    echo "Please Input Password[omuser]:"
    stty -echo
    read -r password_om
    stty echo
    OMUSER_PASSWD_ENCODED=$(encode ${password_om} || LOG_WITH_RC "$? [$LINENO]ERROR: encode omuser fail with $?" || return $?)
    password_om="1234567890"

    echo "Please Input Password[root]:"
    stty -echo
    read -r password_root
    stty echo
    ROOT_PASSWD_ENCODED=$(encode ${password_root} || LOG_WITH_RC "$? [$LINENO]ERROR: encode root fail with $?" || return $?)
    password_root="1234567890"
    if [ "X" = "${OMUSER_PASSWD_ENCODED}" ] || [ "X" = "X${ROOT_PASSWD_ENCODED}" ];then
        LOG "[$LINENO]ERROR: encode pwd of omuser or root fail!"
        OMUSER_PASSWD_ENCODED=""
        ROOT_PASSWD_ENCODED=""
        return 1
    fi
    return 0
}

function install()
{
    local tarfile="${CUR_PATH}/local_exec.tar.gz"
    local password_om=""
    local password_root=""
    local rc=0
    local ret_linenr=0
    local nodenr=$(/usr/bin/sqlite3 /opt/huawei/snas/etc/cm_conf.db "select * from CM_NODE_T" | wc -l)
    local check_install_retf="${g_check_install_retf}"
    local ins_result_ofile="${g_install_result}"
    local ins_result_file="${TMP_PATH}/.install.result"
    local rm_ofile="${TMP_PATH}/.rm.output"
    local scp_ofile="${TMP_PATH}/.scp.output"
    local rc=0
    
    if [ ! -f ${tarfile} ];then
        LOG "[$LINENO]ERROR: ${tarfile} not exist!"
        return 1
    fi
    if [ -f ${rm_ofile} ];then
        rm ${rm_ofile}
    fi
    if [ -f ${scp_ofile} ];then
        rm ${scp_ofile}
    fi
    
    #clean old ones , if exist.
    each_node_do exec "rm /home/omuser/local_exec.tar.gz" > ${rm_ofile}
    #copy to /home/omuser
    each_node_do scp > ${scp_ofile}
    rc=$?
    if [ 0 -ne ${rc} ];then
        LOG "[$LINENO]ERROR: each_node_do scp fail with ${rc}!"
        return ${rc}
    fi
    local des_base_path=$(grep DES_BASE_PATH ${CUR_PATH}/local_exec/${UTILITY_SCRIPT} | awk -F '=' '{print $2}' | sed 's/"//g')
    if [ "X" = "X${des_base_path}" ];then
        LOG "[$LINENO]ERROR: get destination path fail!"
        echo "ERROR: get destination path fail!"
        return 1
    fi
    LOG "[$LINENO]INFO: each_node_do scp ok."
    each_node_do exec "mkdir -p ${des_base_path} ; mv /home/omuser/local_exec.tar.gz ${des_base_path}; cd ${des_base_path}; tar xvf local_exec.tar.gz ; file ${des_base_path}/local_exec/${UTILITY_SCRIPT}" > ${check_install_retf}
    is_all_node_exec_ok ${check_install_retf} ${ins_result_ofile} "shell script text"
    rc=$?
    if [ 0 -eq ${rc} ];then
        LOG "[$LINENO]INFO: all nodes execute ok."
        echo "All nodes install ok."
    else
        LOG "[$LINENO]ERROR: there are some node install fail."
        echo "ERROR: there are some node install fail!"
        return 1
    fi
    
    return 0
}

function execute()
{
    local cmd="$*"
    local tarfile="${CUR_PATH}/local_exec.tar.gz"
    local password_om=""
    local password_root=""
    local rc=0
    local exec_ofile="${TMP_PATH}/.exec.output"
    
    if [ ! -f ${tarfile} ];then
        LOG "[$LINENO]ERROR: ${tarfile} not exist!"
        return 1
    fi
    if [ -f ${exec_ofile} ];then
        rm ${exec_ofile}
    fi
    echo "Will execute on remote nodes ..."
    each_node_do exec /home/omuser/local_exec/${RUN_SCRIPT} ${cmd} >> ${exec_ofile}
    rc=$?
    if [ 0 -ne ${rc} ];then
        LOG "[$LINENO]ERROR: each_node_do exec /home/omuser/local_exec/${RUN_SCRIPT} ${cmd} fail with ${rc}!"
        echo "There are some nodes who executing fail!"
        return ${rc}
    fi
    LOG "[$LINENO]INFO: each_node_do exec /home/omuser/local_exec/${RUN_SCRIPT} ${cmd} ok."
    egrep -v "exit|Authorized users only|Last login:|Password:|Welcome to Euler Linux|su root" ${exec_ofile}
    #echo "All nodes execute ok!"
    return 0
}

function show_result()
{
    dos2unix ${g_exec_output}
    local tmpinfo=$(cat ${g_exec_output} | grep "Error:" )
    if [[ "${tmpinfo}" == "" ]];then
        LOG "[$LINENO]INFO: all nodes execute ok."
        echo "Success: All nodes ok."
    else
        LOG "[$LINENO]ERROR: there are some node fail."
        echo "$tmpinfo"
        echo "Error: there are some node fail!"
    fi
    return 0
}

function main()
{
    local rc=0
    adjLogSize
    prepare || LOG_WITH_RC "$? [$LINENO]ERROR: prepare return $?" || return $?
    get_passwd || LOG_WITH_RC "$? [$LINENO]ERROR: get_passwd return $?" || return $?
    
    echo "Will install on remote nodes ..."
    install || LOG_WITH_RC "$? [$LINENO]ERROR: install return $?" || return $?
    execute Show || LOG_WITH_RC "$? [$LINENO]ERROR: execute $* $?" || return $?
    dos2unix ${g_exec_output}
    local tmpinfo=$(cat ${g_exec_output} | grep "@ver=1" | head -n 1 | tr -d ' ')
    if [ "$tmpinfo" == "" ];then
        tmpinfo=$(cat ${g_exec_output} | grep "@ver=2" | head -n 1 | tr -d ' ')
        if [ "$tmpinfo" == "" ];then
            tmpinfo=$(cat ${g_exec_output} | grep "@ver=3" | head -n 1 | tr -d ' ')
        fi
    fi
    execute "Repair ${tmpinfo}" || LOG_WITH_RC "$? [$LINENO]ERROR: execute $* $?" || return $?
    show_result || LOG_WITH_RC "$? [$LINENO]ERROR: show_result return $?" || return $?
    return 0
}

function ut_get_retlist()
{
    local check_install_retf="${g_check_install_retf}"
    local nodelist="./.exec_result"
    is_all_node_exec_ok ${check_install_retf} ${nodelist} "shell script text"
}

main $*
exit $?

