#!/bin/sh
#ʹ/bin/shִУҪ/bin/bashִУӰsingleThreadִн
COLLECT_DIR="/var/log/cm"
CM_Master_LogDir="/var/log/cm/DataCollect/System_log/"
CM_Master_LogDir_tmp="/var/log/cm/System_log/"
CM_Cluster_CliDir="/var/log/cm/DataCollect/CLI_command_info/"
IP_ROLE_FILE="/tmp/tmp_ip_role"
ZipFileName="DataCollect_OceanStor9000.zip"
LOG_FILE="/var/log/collect/master.log"
orderFile="/home/omuser/orderListTemp.ini"
BMC_LogDir="/var/log/cm/DataCollect/System_log/BMC/"
CMD_TOOL_PATH="/opt/huawei/snas/bin/snas_CmdTool"
OMGROUP="omgroup"
#ļ
CONFIG_FILE="/var/log/cm/DataCollect/Config.txt"
#Ϣ
ErrorInfoFlag="CollectErrorInfo:"

#ʱļ
G_TMP_FILE="/tmp/sys_info.txt"
G_TMP_FILE_DOS="/tmp/sys_info_dos.txt"
G_TMP_INFO_FILE="/tmp/collect_node_info.txt"

#ռڵipļ
VALID_IP_FILE="/tmp/tmp_datacollect_ip"

#Զ˵ѹļ͵ص
DATA_REMOTE="/var/log/cm/Local_DataCollect.zip"
DATA_LOCAL="Local_DataCollect_N9000.zip"

#mmlļ·
G_MML_PATH="/opt/huawei/snas/script/inspect_mml"
#IPMIϢļ
G_IPMI_FILE="/tmp/collect_ipmi_info_$$.txt"
G_IPMI_FILE_TMP="/tmp/collect_ipmi_$$.txt"
G_IPMI_MAX_PROC=10

#ڵ(cm)ĺip
MasterCM_NID=""
MasterCM_BACK_IP=""
LocalBackIp=""

. /opt/node_type_recognize.sh
. /opt/node_devicename.sh

THRESHOLD_COLLECT=80
THRESHOLD_COLLECTING=90
RepeatTimes=(1 2 3 4 5 6 7 8 9)
#ĬϲռϢ
IsCollectDisk=1
#ĬϲռHardwareϢ
IsCollectHardware=1

log()
{
    echo -e "[$(date "+%F %T")][$$] ${@:1}" >> "${LOG_FILE}"
    return 0
}

#ԶִͬУip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
    /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        log "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}
function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
        local iRet=$?
        if [ $iRet -eq 101 ]; then
            LOG "[$FUNCNAME] download ($remote_file) from ($remote_ip) to ($local_file) iRet:($iRet) time:$time"
            sleep 10
        else
            break
        fi
    done
    if [ $iRet -ne 0 ]; then
        log "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time"
    fi
    return $iRet
}

###################################################################################
##ȡڵĺip
function GetLocalIp()
{
    local count=0
    LocalBackIp=""
    for time in ${RepeatTimes[*]}; do
        LocalIpList=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 and NID=${MasterCM_NID};")
        if [ "X${LocalIpList}" == "X" ];then
            log "[$FUNCNAME][$LINENO]time=${time},Failed get master ip from DB"
            sleep 2
        else
            break
        fi
    done
    log "[$FUNCNAME][$LINENO]LocalIpList=${LocalIpList},MasterCM_NID=[${MasterCM_NID}]!"
    #pingһ¼Ƿͨ
    for line in ${LocalIpList[*]}; do
        if [ -z "${line}" ];then
            continue
        fi
        ItemIp=$(echo ${line} | awk -F'|' '{print $2}')
        log "[$FUNCNAME][$LINENO]line=${line},ItemIp(${ItemIp})!"
        for time in ${RepeatTimes[*]}; do
            count=$(ping -q -c 1 ${ItemIp}  | grep "1 received" | wc -l)
            if [ ${count} -eq 0 ]; then
                log "[$FUNCNAME][$LINENO]time=${time} ip(${ItemIp}) can not access!"
                sleep 5
            else
                LocalBackIp=${ItemIp}
                break
            fi
        done
        if [ -z "${LocalBackIp}" ];then
            continue
        else
            break
        fi
    done
    log "[$FUNCNAME][$LINENO]LocalBackIp=[${LocalBackIp}],MasterCM_NID=[${MasterCM_NID}]!"
}
#ȡȺекip
function GetIPAndRoleFromDB()
{
    local lineinfo=""
    local numCnt=1
    local tempnumCnt=1
    local lastNID=""
    local localNID=""
    local templocalNID=""
    local totalline=0

    > $IP_ROLE_FILE

    #ȡڵĺip
    MasterCM_NID=`grep NID /opt/huawei/snas/etc/cm.ini | awk -F"=" '{print $2}'`
    log "[GetIPAndRoleFromDB]MasterCM_NID:$MasterCM_NID"

    ##ȡؽڵĺip
    GetLocalIp

    #ݿȡнڵĺIP
    #set_ifs
    for time in ${RepeatTimes[*]}; do
        JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
        if [ "X${JavaId}" == "X" ];then
            log "[GetIPAndRoleFromDB]Failed get ip from DB"
            sleep 2
        else
            break
        fi
    done
    totalline=`echo "$JavaId" | wc -l`
    log "[GetIPAndRoleFromDB]JavaId:$JavaId,totalline:$totalline"

    while [ "${numCnt}" -le "${totalline}" ]; do

        lineinfo=`echo $JavaId | awk '{print $'$numCnt'}'`

        ItemIp=`echo $lineinfo | awk -F'|' '{print $2}'`
        localNID=`echo $lineinfo | awk -F'|' '{print $1}'`

        log "[GetIPAndRoleFromDB]numCnt:$numCnt,localNID:$localNID,lastNID:$lastNID"
        if [ "$localNID" == "$lastNID" ];then
            #ͬһڵ㣬һѭ
            numCnt=$((numCnt+1))

            log "[GetIPAndRoleFromDB]the same node,get next"
            continue
        fi

        #ռָڵ㣬ڵ
        if [ "$NODE" != "null" ]; then
            for time in ${RepeatTimes[*]}; do
                nodeName=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select HOSTNAME from CM_NODE_T where NID=$localNID;"`
                if [ "X${nodeName}" == "X" ];then
                    log "[GetIPAndRoleFromDB]Failed to get nodeName from DB"
                    sleep 2
                else
                    break
                fi
            done
            echo "$NODE" | grep -w "${nodeName}" >> /dev/null
            if [ $? -ne 0 ]; then
                numCnt=$((numCnt+1))
                log "FILTER NODE $nodeName($localNID),get next"
                continue;
            fi
        fi

        #pingһ¼Ƿͨ
        for time in ${RepeatTimes[*]}; do
        tempStr_ping=`ping -q -c 1 $ItemIp  | grep received | awk '{print $4}'`
            local iRet=$?
            if [ $iRet -ne 0 ]; then
                sleep 10
            else
                break
            fi
        done

        log "[GetIPAndRoleFromDB]$localNID,$ItemIp,tempStr_ping:$tempStr_ping"

        #
        numCnt=$((numCnt+1))
        lastNID=$localNID

        if [ "$tempStr_ping" -le 0 ];then

            #Եڶip
            templocalNID=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $1}'`

            #жǷͬһڵ
            if [ "$localNID" == "$templocalNID" ];then
                ItemIp=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $2}'`
                for time in ${RepeatTimes[*]}; do
                tempStr_ping=`ping -q -c 2 $ItemIp  | grep received | awk '{print $4}'`
                    local iRet=$?
                    if [ $iRet -ne 0 ]; then
                        sleep 10
                    else
                        break
                    fi
                done

                log "[GetIPAndRoleFromDB]numCnt:$numCnt,$templocalNID,$ItemIp ,tempStr_ping:$tempStr_ping"

                #
                numCnt=$((numCnt+1))
                lastNID=$localNID

                if [ "$tempStr_ping" -le 0 ];then
                    #ڶҲͨһѭ
                    log "[GetIPAndRoleFromDB]Node:$localNID,$ItemIp ping fail"
                    continue
                fi
            else
               #ͬһڵ㣬һѭ
               continue
            fi
        fi

        #жϽڵǷúͶ
        Status_info=`remote_exec $ItemIp 10 "cat /opt/huawei/snas/etc/snas.ini | grep "status="|head -1"`
        iRet=$?
        log "[GetIPAndRoleFromDB]node:$ItemIp,Status_info:$Status_info,iRet:$iRet."
        if [ "$iRet" -eq "0" ] && [ "$Status_info" != "" ];then
            Status_value=`echo $Status_info | awk -F= '{print $2}'`
            if [ "$Status_value" == "0" ];then
                echo "$ItemIp" >> $IP_ROLE_FILE

                echo "MasterCM_NID:$MasterCM_NID,localNID:$localNID"
                if [ "$MasterCM_NID" == "$localNID" ];then
                    MasterCM_BACK_IP="$ItemIp"
                fi
                log "[GetIPAndRoleFromDB]add $ItemIp"
            fi
        fi
    done

    log "[GetIPAndRoleFromDB]MasterCM_BACK_IP:$MasterCM_BACK_IP,MasterCM_NID:$MasterCM_NID"
    #restore_ifs
    #IPļ߻ȡڵ
    cp -f $IP_ROLE_FILE /home/omuser/datacollect_tmp_ip_role
    chown omuser:$OMGROUP -R /home/omuser/datacollect_tmp_ip_role
}

#Ŀ¼
function CreateCollectDir()
{
    rm -rf /var/log/cm/*
    ALLIp=`cat $IP_ROLE_FILE`
    local repeatResult=0
    rm -rf ${G_TMP_INFO_FILE}
    touch ${G_TMP_INFO_FILE}
    log "ALLIp:$ALLIp"
    if [ -d "$CM_Master_LogDir" ];then
        rm -rf "$CM_Master_LogDir""*"
        log "start del dir $CM_Master_LogDir"
    else
        mkdir -p "$CM_Master_LogDir"
        log "mkdir $CM_Master_LogDir"
    fi

    #create Cluster CLI info dir
    if [ -d "$CM_Cluster_CliDir" ];then
        rm -rf "$CM_Cluster_CliDir""*"
        log "start del dir $CM_Cluster_CliDir"
    else
        mkdir -p "$CM_Cluster_CliDir"
        log "mkdir $CM_Cluster_CliDir"
    fi

    export IFS=$'\n'
    for Item in $ALLIp
    do
        #ȡݿӦԱʹãֻҪһݻȡʧռӦڵ־
        for time in ${RepeatTimes[*]}; do
            node_id=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select NID from CM_NODE_IP_T where SUBNET_ID=1 and IP_ADDR=\"${Item}\";"`
            if [ "X${node_id}" == "X" ];then
                log "[CreateCollectDir]Failed to get node_id from DB"
                repeatResult=1
                sleep 2
            else
                repeatResult=0
                break
            fi
        done
        if [ ${repeatResult} -eq 1 ];then
           continue
        fi
        for time in ${RepeatTimes[*]}; do
            node_name=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select HOSTNAME from CM_NODE_T where NID=$node_id;"`
            if [ "X${node_name}" == "X" ];then
                log "[CreateCollectDir]Failed to get node_name from DB"
                repeatResult=1
                sleep 2
            else
                repeatResult=0
                break
            fi
        done
        if [ ${repeatResult} -eq 1 ];then
           continue
        fi
        for time_local in ${RepeatTimes[*]}; do
            version_type=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select strNODEVERSION from CM_NODE_T where NID=${node_id};"`
            if [ "X${version_type}" == "X" ];then
                log "[DataCollect] Failed to get version_type from DB"
                repeatResult=1
                sleep 2
            else
                repeatResult=0
                break
            fi
        done
        if [ ${repeatResult} -eq 1 ];then
           continue
        fi
        echo "${Item} ${node_id} ${node_name} ${version_type}" >>${G_TMP_INFO_FILE}
        if [ "$Item" == "$MasterCM_BACK_IP" ];then
            TmpDir="$CM_Master_LogDir""$node_name""_MAIN"
            mkdir -p "$TmpDir"
            mkdir -p "$TmpDir""/Config"
            mkdir -p "$TmpDir""/Event"
            mkdir -p "$TmpDir""/Messages"
            mkdir -p "$TmpDir""/Other"

        else
            TmpDir="$CM_Master_LogDir""$node_name"
            mkdir -p "$TmpDir"
        fi
    done
}

MapHealthStatus()
{
    case $1 in
    0)
        echo "UNKNOWN"
        ;;
    1)
        echo "NORMAL"
        ;;
    2)
        echo "FAULT"
        ;;
    3)
        echo "PRE_FAIL"
        ;;
    4)
        echo "PART_BROKEN"
        ;;
    5)
        echo "DEGRADE"
        ;;
    6)
        echo "HAS_BAD_BLOCK"
        ;;
    7)
        echo "HAS_ERROR_CODE"
        ;;
    8)
        echo "CONSISTENT"
        ;;
    9)
        echo "INCONSISTENT"
        ;;
    10)
        echo "BUSY"
        ;;
    11)
        echo "POWER_NO_INPUT"
        ;;
    12)
        echo "POWER_NOT_ENOUGH"
        ;;
    13)
        echo "SINGLE_LINK_FAULT"
        ;;
         *)
        echo "No this type"
        ;;
    esac
}

MapRunningStatus()
{
    case $1 in
    0)
        echo "UNKNOWN"
        ;;
    1)
        echo "NORMAL"
        ;;
    2)
        echo "RUNNING"
        ;;
    3)
        echo "NOT_RUNNING"
        ;;
    4)
        echo "NOT_EXIST"
        ;;
    5)
        echo "HIGH_TEMPERATURE_SLEEP"
        ;;
    6)
        echo "STARTING"
        ;;
    7)
        echo "POWER_FAILURE_PROTECTING"
        ;;
    8)
        echo "SLEEPING"
        ;;
    9)
        echo "SPINGUP"
        ;;
    10)
        echo "LINK_UP"
        ;;
    11)
        echo "LINK_DOWN"
        ;;
    12)
        echo "POWER_ON"
        ;;
    13)
        echo "POWER_OFF"
        ;;
    14)
        echo "PRE_COPY"
        ;;
    15)
        echo "COPYBACK"
        ;;
    16)
        echo "RECONSTRUCTION"
        ;;
    17)
        echo "EXPANSION"
        ;;
    18)
        echo "NOT_FORMAT"
        ;;
    19)
        echo "FORMATTING"
        ;;
    20)
        echo "UNMAPPING"
        ;;
    21)
        echo "INITIAL_SYNCHRONIZING"
        ;;
    22)
        echo "CONSISTENT"
        ;;
    23)
        echo "SYNCHRONIZING"
        ;;
    24)
        echo "SYNCHRONIZED"
        ;;
    25)
        echo "NOT_SYNCHRONIZED"
        ;;
    26)
        echo "SPLIT"
        ;;
    27)
        echo "ONLINE"
        ;;
    28)
        echo "OFFLINE"
        ;;
    29)
        echo "LOCKED"
        ;;
    30)
        echo "ENABLE"
        ;;
    31)
        echo "DISABLED"
        ;;
    32)
        echo "LEVELING"
        ;;
    33)
        echo "TO_BE_RECOVERD"
        ;;
    34)
        echo "INTERRUPTED"
        ;;
    35)
        echo "INVALID"
        ;;
    36)
        echo "NOSTART"
        ;;
    37)
        echo "QUEUING"
        ;;
    38)
        echo "STOP"
        ;;
    39)
        echo "COPYING"
        ;;
    40)
        echo "COMPLETED"
        ;;
    41)
        echo "PAUSE"
        ;;
    42)
        echo "REVSYNCHRONIZING"
        ;;
    43)
        echo "ACTIVATED"
        ;;
    44)
        echo "ROLLBACK"
        ;;
    45)
        echo "INACTIVATED"
        ;;
    46)
        echo "IDLE"
        ;;
    47)
        echo "POWERING_OFF"
        ;;
    48)
        echo "CHARGING"
        ;;
    49)
        echo "CHARGED"
        ;;
    50)
        echo "DISCHARGING"
        ;;
    51)
        echo "UPGRADING"
        ;;
    *)
        echo "No this type"
        ;;
    esac
}

MapDiskType()
{
    case $1 in
    0)
        echo "FC"
        ;;
    1)
        echo "SAS"
        ;;
    2)
        echo "SATA"
        ;;
    3)
        echo "SAS_SSD"
        ;;
    4)
        echo "NL_SAS"
        ;;
    5)
        echo "SLC_SSD"
        ;;
    6)
        echo "MLC_SSD"
        ;;
    15)
        echo "SMR_SATA"
        ;;
    16)
        echo "NVME_SSD"
        ;;
    17)
        echo "SATA_SSD"
        ;;
    *)
        echo "No this type"
        ;;
    esac
}

MapPowerType()
{
    case $1 in
        0)
        echo "DC"
        ;;
    1)
        echo "AC"
        ;;
        *)
        echo "No this type"
        ;;
    esac
}

MapUserLevel()
{
    case $1 in
    1)
        echo "super_admin"
        ;;
    2)
        echo "admin"
        ;;
    3)
        echo "readonly"
        ;;
    4)
        echo "resource_admin"
        ;;
    5)
        echo "device_admin"
        ;;
        *)
        echo "No this type"
        ;;
    esac
}

MapUserScope()
{
    case $1 in
        0)
            echo "local"
            ;;
        1)
            echo "LDAP"
            ;;
        2)
            echo "LDAP_GROUP"
            ;;
        *)
            echo "No this type"
        ;;
    esac
}

MapBoolType()
{
    case $1 in
        0)
            echo "false"
            ;;
        1)
            echo "true"
            ;;
        *)
        echo "No this type"
        ;;
    esac
}

MapSNMPVersion()
{
    case $1 in
        1)
            echo "v1"
        ;;
        2)
            echo "v2c"
            ;;
        3)
            echo "v3"
            ;;
        *)
            echo "No this type"
            ;;
    esac
}

MapSNMPType()
{
    case $1 in
        1)
            echo "Parsed"
            ;;
        2)
            echo "Original"
            ;;
        3)
            echo "all"
            ;;
        *)
            echo "No this type"
        ;;
    esac
}

#####################################collect config start####################

function GetSystemGeneral_MML()
{
    BackIP=$MasterCM_BACK_IP

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm system" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=$(cat ${G_TMP_FILE} | sed -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g')
        Result="${Info}"
        echo "$Result"
    else
        cat $G_TMP_FILE | tr -cd [:print:][\\r\\n\\t] > $G_TMP_FILE_DOS 2>&1
        mv $G_TMP_FILE_DOS $G_TMP_FILE
        dos2unix $G_TMP_FILE
        sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' ${G_TMP_FILE} >/dev/null 2>&1
        Version=`cat $G_TMP_FILE|grep "Cluster_Version"|awk -F: '{print $2}'`
        echo "    Cluster_Version:$Version"
        Health=`cat $G_TMP_FILE|grep "Cluster_Health_Status"|awk -F: '{print $2}'`
        Health=`MapHealthStatus $Health`
        echo "    Cluster_Health_Status:$Health"
        Running=`cat $G_TMP_FILE|grep "Cluster_Running_Status"|awk -F: '{print $2}'`
        Running=`MapRunningStatus $Running`
        echo "    Cluster_Running_Status:$Running"
        Capacity=`cat $G_TMP_FILE|grep "Cluster_Capacity"|awk -F: '{print $2}' | egrep -o "^[0-9]+"`
        echo "    Cluster_Capacity(MB):$Capacity"
        Used=`cat $G_TMP_FILE|grep "Cluster_Used_Capacity"|awk -F: '{print $2}' | egrep -o "^[0-9]+"`
        echo "    Cluster_Used_Capacity(MB):$Used"
    fi
}
function DiskInfoHeadCreate()
{
    local filename=$1

    if [ ! -f "${filename}" ];then
        log "[DiskInfoTailCreate]:file not exist."
        return 1
    fi
    >$filename
    local omip=$(grep -w omip /opt/huawei/snas/etc/cm.ini |awk -F= '{print $2}')
    local cluster_name=$(grep cluster_name /opt/huawei/snas/etc/snas.ini |awk -F= '{print $2}')
    local SN=$(grep "SN=" /opt/huawei/snas/etc/cm.ini |awk -F= '{print $2}')
    local ProductName=$(ipmitool fru |grep "Product Name" |awk -F: '{print $2}' |awk -F " " '{print $1" "$2}')
    local ProductVersion=$(grep ExternalVersion /opt/huawei/deploy/package/version |awk -F= '{print $2}')
    local Time=$(date "+%Y-%m-%d %H:%M:%S")
    local productType=`cat /opt/huawei/snas/etc/snas.ini| grep  "productType"| awk -F= '{print $2}' | sed 's/ //g'`
    if [ "$productType" == "48" ]; then
        ProductName=$ProductName" Series"
        deployScen=$(cat /opt/huawei/snas/etc/snas.ini |grep -w deployScene |awk -F= '{printf $2}')
        if [ "$deployScen" == "2" ];then
            ProductName="FusionStorage File"
        elif [ "$deployScen" == "3" ];then
            ProductName="FusionStorage Swift"
        fi
    fi

    echo "smart analyzelog device ip : $omip" >> $filename
    echo "******************** " >> $filename
    echo "show system general" >> $filename
    echo "System Name         : $cluster_name" >> $filename
    echo "SN                  : $SN" >> $filename
    echo "Product Model       : $ProductName" >> $filename
    echo "Product Version     : $ProductVersion" >> $filename
    echo "Time                : $Time" >> $filename
    echo "admin:/> " >> $filename
    echo "********************" >> $filename
    echo "show disk general |filterColumn include columnList=ID,Serial\sNumber,Type,Manufacturer" >> $filename
    return 0
}
#нڵռDiskInfoϢΪһ壬Ȼڵļĸʽ
function DiskInfoSort()
{
    local diskinfo_path="/var/log/cm/DataCollect/disksmartinfo/"
    local maxlen=""
    local maxlength_Name=10
    local maxlength_type=12
    local maxlength_man=14
    local maxlength_SN=20
    local smartHisFile="smart0_history.txt"
    local smartHisDir="${diskinfo_path}history_smart/"
    >${diskinfo_path}smart0.txt
    >${diskinfo_path}summary.ini
    >${diskinfo_path}basicinfo_tmp.txt
    >${diskinfo_path}disk_kmm_info.txt
    if [ -f ${diskinfo_path}basicinfo.txt ];then
        rm ${diskinfo_path}basicinfo.txt
    fi
    #history_smartĿ¼,ʷsmartϢ
    mkdir -p "${smartHisDir}"
    successnumber=0
    totalmumber=0
    echo "sedkey statistic info:" > ${diskinfo_path}disk_kmm_info.txt
    /usr/local/bin/MmlBatch 4092 "kmms stats show" |grep InitailNum | sed -e 's/\x1B\[0;[3-4][0-9]m//g' >> ${diskinfo_path}disk_kmm_info.txt 2>&1
    echo "******************** " >> ${diskinfo_path}disk_kmm_info.txt
    echo "sedkey basic info:" >> ${diskinfo_path}disk_kmm_info.txt
    ValidIP=`cat $IP_ROLE_FILE`
    log "all ip is $ValidIP"
    for Item in $ValidIP;do
        if [ ! -d "${diskinfo_path}DiskInfo$Item" ];then
            log "[$FUNCNAME][$LINENO]:get the diskinfo from ${Item} failed."
            continue
        fi
        cd ${diskinfo_path}DiskInfo$Item
        tar -zxf *.tar.gz
        if [ 0 -ne $? ];then
            log "[$FUNCNAME]:tar -vzxf from $Item failed,get the diskinfo from $Item failed."
            continue
        fi
        cat basicinfo.txt >>${diskinfo_path}basicinfo_tmp.txt
        cat smart0.txt >> ${diskinfo_path}smart0.txt
        #ϲÿڵhistory_smartϢڵ
        cat "history_smart/${smartHisFile}" >> ${smartHisDir}${smartHisFile}
        cat disk_kmm_info.txt |sed -e 's/\x1B\[0;[3-4][0-9]m//g' >> ${diskinfo_path}disk_kmm_info.txt
        tmpsuccnum=$(grep -w success summary.ini|cut -d "=" -f 2)
        tmptotalnum=$(grep -w total summary.ini|cut -d "=" -f 2)
        if [ "X" != "X${tmpsuccnum}" ];then
            successnumber=$((successnumber+${tmpsuccnum}))
        fi
        if [ "X" != "X${tmpsuccnum}" ];then
            totalmumber=$((totalmumber+${tmptotalnum}))
        fi 
        log "[$FUNCNAME]:get the diskinfo from $Item;success=$tmpsuccnum,total=$tmptotalnum ,date=$(date)."
    done
    >${diskinfo_path}basicinfo.txt
    DiskInfoHeadCreate ${diskinfo_path}basicinfo.txt
    #ʱļȡÿֶε󳤶ȣȻиʽbasicinfo.txt
    maxlen=$(awk -v maxlength_Name=$maxlength_Name \
            -v maxlength_type=$maxlength_type \
            -v maxlength_man=$maxlength_man \
            -v maxlength_SN=$maxlength_SN ' { \
            if(length($1)>maxlength_Name)maxlength_Name=length($1); \
            if(length($2)>maxlength_type)maxlength_type=length($2); \
            if(length($3)>maxlength_man)maxlength_man=length($3); \
            if(length($4)>maxlength_SN)maxlength_SN=length($4)}  \
            END{printf("%4d %4d %4d %4d",maxlength_Name,maxlength_type,maxlength_man,maxlength_SN)} \
            ' \
            ${diskinfo_path}basicinfo_tmp.txt \
            )
    maxlength_Name=$(echo $maxlen|awk '{print $1+2}')
    maxlength_type=$(echo $maxlen|awk '{print $2+2}')
    maxlength_man=$(echo $maxlen|awk '{print $3+2}')
    maxlength_SN=$(echo $maxlen|awk '{print $4+2}')
    log "maxlength_Name=$maxlength_Name;maxlength_type=$maxlength_type;maxlength_man=$maxlength_man;maxlength_SN=$maxlength_SN"
    #װϢǰ"--"Ϣ
    printf "  %-${maxlength_Name}s%-${maxlength_type}s%-${maxlength_man}s%-${maxlength_SN}s\n" ID TYPE Manufacturer "Serial Number" >> ${diskinfo_path}basicinfo.txt
    tmpcontxt=($maxlength_Name $maxlength_type $maxlength_man $maxlength_SN)
    tmpprintf="  "
    tmpprintf1="-"
    tmpprintf2="  "
    for time in ${tmpcontxt[*]};do
        for((i=0;i<$time-2;i++));do
            tmpprintf="$tmpprintf$tmpprintf1"
        done
        tmpprintf="$tmpprintf$tmpprintf2"
    done
    echo "$tmpprintf" >> ${diskinfo_path}basicinfo.txt
    #Ϣ
    awk -v maxlength_Name=$maxlength_Name \
        -v maxlength_type=$maxlength_type \
        -v maxlength_man=$maxlength_man   \
        -v maxlength_SN=$maxlength_SN '{  \
        printf("  %-"maxlength_Name"s%-"maxlength_type"s%-"maxlength_man"s%-"maxlength_SN"s\n",$1,$2,$3,$4) } \
        ' ${diskinfo_path}basicinfo_tmp.txt >>${diskinfo_path}basicinfo.txt
    rm -rf ${diskinfo_path}basicinfo_tmp.txt
    #ڵϢ󣬽NL_SAS滻Ŀ̽ߣ
    sed -i 's/ NL_SAS / NL SAS /g' ${diskinfo_path}basicinfo.txt
    #ڵϢ󣬽NVME_SSD滻Ŀ̽ߣ
    sed -i 's/ NVME_SSD / NVMe SSD /g' ${diskinfo_path}basicinfo.txt
    #β
    echo "admin:/> " >> ${diskinfo_path}basicinfo.txt
    echo "********************" >> ${diskinfo_path}basicinfo.txt
    rm -rf ${diskinfo_path}DiskInfo*
    echo "total=$totalmumber" >> ${diskinfo_path}summary.ini
    echo "success=$successnumber" >> ${diskinfo_path}summary.ini
    Time=$(date "+%Y-%m-%d %H:%M:%S")
    echo "date=${Time}" >> ${diskinfo_path}summary.ini
    log "begin to zip file"
    cd ${diskinfo_path}
    if [ -f basicinfo.txt ];then
        log "get basicinfo.txt success."
    else
        log "get basicinfo.txt failed!"
    fi
    sed -i'' "s/$/\r/" basicinfo.txt

    sed -i '/smart/s#\r##g' basicinfo.txt
    sed -i '/admin/s#\r##g' basicinfo.txt
    sed -i '2s#\r##g' basicinfo.txt
    sed -i '10s#\r##g' basicinfo.txt
    linenum=$(cat basicinfo.txt|wc -l)
    comd="sed -i '${linenum}s#\r##g' basicinfo.txt"
    eval $comd
    log "collect Diskinfo success."
}
function GetPowerNum_MML()
{
    BackIP=$MasterCM_BACK_IP

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm power" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result"
    else
        cat $G_TMP_FILE | tr -cd [:print:][\\r\\n\\t] > $G_TMP_FILE_DOS 2>&1
        mv $G_TMP_FILE_DOS $G_TMP_FILE
        dos2unix $G_TMP_FILE
        PowerNumber=`cat $G_TMP_FILE | grep "Health_Status: 1"|grep "Running_Status: 1"|sed 's/^ *//g'|sed "/^$/d" | wc -l`
        echo "    PowerNumber:$PowerNumber"
    fi
}

function GetLicenseInfo_MML()
{
    echo "License information--------------------------------"
    LicenseSerialNo=`cat /opt/huawei/snas/license/license_active.dat | grep  "LicenseSerialNo"`
    echo "    $LicenseSerialNo"
    BackIP=$MasterCM_BACK_IP

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm licensecfg" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result"
    else
        export IFS=$'\n'
        cat $G_TMP_FILE | tr -cd [:print:][\\r\\n\\t] > $G_TMP_FILE_DOS 2>&1
        mv $G_TMP_FILE_DOS $G_TMP_FILE
        dos2unix $G_TMP_FILE
        javaID=`cat $G_TMP_FILE |grep "acFeatureName"|sed 's/^ *//g'|sed "/^$/d"`

        for line in $javaID
        do
            if [ "${line}" = "" ];then
                continue;
            fi

            FeatureID=`echo $line |awk '{print $3}'`
            echo "    FeatureID:$FeatureID"
            TrialDays=60
            echo "    Trial Days:$TrialDays"
            Deadline=`echo $line |awk '{print $7}'`
        date1=`expr $Deadline \/ 1000`
            Deadline=`date --date "1970-01-01 UTC $date1 seconds" +"%Y-%m-%d %T %z"`
            echo "    Running Deadline:$Deadline"
            Number=`echo $line |awk '{print $11}'|sed 's/\./ /g'`
            echo "    Maximal Resource Number:$Number"
        done
    fi
}

function GetSummaryInfo()
{
    local node_name=""
    echo "SUMMARY--------------------------------"

    ipmitool fru > /tmp/system_info.txt
    top -b -n 1 |grep Cpu | cut -d "," -f 1 >> /tmp/system_info.txt

    node_name=`cat ${G_TMP_INFO_FILE} | grep -w "${Item}" | awk '{print $3}'`
    cp -f /tmp/system_info.txt "$CM_Master_LogDir""$node_name"_MAIN/Other/

    if [ $? != 0 ];then
        echo "$Item: Get system info file failed."
    fi

    result=`cat /tmp/system_info.txt|sed 's/^ *//g'|sed "/^$/d"| grep -w "Board Mfg Date"`
    echo "    $result"
    result=`cat /tmp/system_info.txt|sed 's/^ *//g'|sed "/^$/d"| grep -w "Board Mfg "`
    echo "    $result"
    result=`cat /tmp/system_info.txt|sed 's/^ *//g'|sed "/^$/d"| grep -w "Board Product"`
    echo "    $result"
    result=`cat /tmp/system_info.txt|sed 's/^ *//g'|sed "/^$/d"| grep -w "Product Manufacturer"`
    echo "    $result"
    result=`cat /tmp/system_info.txt|sed 's/^ *//g'|sed "/^$/d"| grep -w "Product Name"`
    echo "    $result"
    result=`cat /tmp/system_info.txt|sed 's/^ *//g'|sed "/^$/d"| grep -w "Product Part Number "`
    echo "    $result"
    result=`cat /tmp/system_info.txt|sed 's/^ *//g'|sed "/^$/d"| grep -w "Product Serial"`
    echo "    $result"
    result=`cat /tmp/system_info.txt|sed 's/^ *//g'|sed "/^$/d"| grep -w "Product Asset Tag"`
    echo "    $result"

    GetSystemGeneral_MML

    result=`cat /opt/Runtime/version.properties| grep "version.name"`
    echo "    $result"
    #Number of Power
    GetPowerNum_MML
    #MemTotal
    result=`cat /proc/meminfo | grep "MemTotal"`
    echo "    $result"
    #MemFree
    result=`cat /proc/meminfo | grep "MemFree"`
    echo "    $result"
    #ȡĬ
    result=`cat /opt/huawei/snas/etc/mons.ini | grep "^DefaultProtection"`
    result=$(echo $result | sed 's/=/:/g')
    echo "    $result"
    #ȡ
    result=`cat /opt/huawei/snas/etc/mons.ini | grep "^MaxProtection"`
    result=$(echo $result | sed 's/=/:/g')
    echo "    $result"
    #CPU Using:
    #ϵͳLicenseϢ
    GetLicenseInfo_MML
}

function GetUserInfo_INI()
{
    echo "User--------------------------------"

    #ûStatus !!!
    UserNumber=0
    cat /opt/huawei/snas/etc/cm_aum_man_user.ini > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result"
    else
        cat $G_TMP_FILE | tr -cd [:print:][\\r\\n\\t] > $G_TMP_FILE_DOS 2>&1
        mv $G_TMP_FILE_DOS $G_TMP_FILE
        dos2unix $G_TMP_FILE
        UserNumber=`cat $G_TMP_FILE | sed 's/^ *//g'|sed "/^$/d" | grep "\[USER"|wc -l`
        echo "    Number of users:$UserNumber"
        echo "    User info--------------------------------"

        export IFS=$'\n'
        count=1
        while [ "${count}" -le "${UserNumber}" ]
        do
            cat $G_TMP_FILE|grep -A10 "\[USER $count\]" > userinfo
                Name=`cat userinfo |grep "UserName"|awk -F= '{print $2}'`
                echo "            Name:$Name"
                Level=`cat userinfo |grep "UserLevel"| awk -F= '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
                Level=`MapUserLevel $Level`
                echo "        Level:$Level"
                CreateTime=`cat userinfo |grep "UserCreateTime"| awk -F= '{print $2}'`
                CreateTime=`date --date "1970-01-01 UTC $CreateTime seconds" +"%Y-%m-%d %T %z"`
                echo "        CreateTime:$CreateTime"
                Scope=`cat userinfo |grep "UserScope"|awk -F= '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
                Scope=`MapUserScope $Scope`
                echo "        Scope:$Scope"
                count=`expr $count + 1`
        done
    fi
    rm userinfo
}

function GetAlarmInfo_DB()
{
    echo "Alarm Config--------------------------------"
    echo "Alarm email config--------------------------------"

    sqlite3 /opt/huawei/snas/etc/alarmcfg1.db "select smtpserver,sender,isneedcheck,issend,username,receiver,isssl,port from CM_ALM_EMAIL;" >  $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result"
    else
        SMTPServer=`cat $G_TMP_FILE|sed 's/^ *//g'|sed "/^$/d"|awk -F\| '{print $1}'`
        echo "    SMTPServer:$SMTPServer"
        Sender=`cat $G_TMP_FILE|sed 's/^ *//g'|sed "/^$/d"|awk -F\| '{print $2}'`
        echo "    Sender:$Sender"
        Authentication=`cat $G_TMP_FILE|sed 's/^ *//g'|sed "/^$/d"|awk -F\| '{print $3}'`
        if [ "$Authentication" != "" ];then
            Authentication=`MapBoolType $Authentication`
        fi
        echo "    Authentication:$Authentication"
        Send=`cat $G_TMP_FILE|sed 's/^ *//g'|sed "/^$/d"|awk -F\| '{print $4}'`
        if [ "$Send" != "" ];then
            Send=`MapBoolType $Send`
        fi
        echo "    Send:$Send"
        User=`cat $G_TMP_FILE|sed 's/^ *//g'|sed "/^$/d"|awk -F\| '{print $5}'`
        echo "    User:$User"
        Receiver=`cat $G_TMP_FILE|sed 's/^ *//g'|sed "/^$/d"|awk -F\| '{print $6}'`
        echo "    Receiver:$Receiver"
        SSL=`cat $G_TMP_FILE|sed 's/^ *//g'|sed "/^$/d"|awk -F\| '{print $7}'`

    if [ "$Send" != "" ];then
        SSL=`MapBoolType $SSL`
        fi
        echo "    Enable SSL:$SSL"
        ServerPort=`cat $G_TMP_FILE|sed 's/^ *//g'|sed "/^$/d"|awk -F\| '{print $8}'`
        echo "    ServerPort:$ServerPort"
    fi

    echo "Alarm sms config--------------------------------"

    sqlite3 /opt/huawei/snas/etc/alarmcfg1.db "select issend,sendcountry,receiver,smscnumber from CM_ALM_SMS;" >  $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "    $Result"
    else
        Send=`cat $G_TMP_FILE|sed 's/^ *//g'|sed "/^$/d"|awk -F\| '{print $1}'`
        if [ "$Send" != "" ];then
            Send=`MapBoolType $Send`
        fi
        echo "    Send:$Send"
        SendCountry=`cat $G_TMP_FILE|sed 's/^ *//g'|sed "/^$/d"|awk -F\| '{print $2}'`
        echo "    SendCountry:$SendCountry"
        Receiver=`cat $G_TMP_FILE|sed 's/^ *//g'|sed "/^$/d"|awk -F\| '{print $3}'`
        echo "    Receiver:$Receiver"
        ServerCenter=`cat $G_TMP_FILE|sed 's/^ *//g'|sed "/^$/d"|awk -F\| '{print $4}'`
        echo "    ServerCenter:$ServerCenter"
    fi
    echo "Alarm trap config--------------------------------"

    sqlite3 /opt/huawei/snas/etc/snmpcfg.db "select uiVersion,uiType,acId,acIp,uiPort from CM_TRAPADDR_T;" >  $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result"
    else
        export IFS=$'\n'
        javaID=`cat $G_TMP_FILE`
        for line in $javaID
        do
            if [ "${line}" = "" ];then
                continue;
            fi

            TrapVersion=`echo $line |awk -F\| '{print $1}'`
            TrapVersion=`MapSNMPVersion $TrapVersion`
            echo "    TrapVersion:$TrapVersion"
            ServerIP=`echo $line |awk -F\| '{print $4}'`
            echo "    ServerIP:$ServerIP"
            ServerPort=`echo $line |awk -F\| '{print $5}'`
            echo "    ServerPort:$ServerPort"
            TrapType=`echo $line |awk -F\| '{print $2}'`
            TrapType=`MapSNMPType $TrapType`
            echo "    TrapType:$TrapType"
        done
    fi
}

function GetDiskInfo_MML()
{
    local DiskNodeID=""
    echo "Disk--------------------------------"
    BackIP=$MasterCM_BACK_IP
    local tmp=""
    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm diskinfo" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result"
    else
        cat $G_TMP_FILE | tr -cd [:print:][\\r\\n\\t] > $G_TMP_FILE_DOS 2>&1
        mv $G_TMP_FILE_DOS $G_TMP_FILE
        dos2unix $G_TMP_FILE
        tmp=$(cat $G_TMP_FILE | sed 's/^ *//g'|sed "/^$/d" | grep -Po "/tmp/snas_debug[0-9]*")
        if [ "X${tmp}" != "X" ];then
            cat $tmp > $G_TMP_FILE
        fi
        DiskNumber=`cat $G_TMP_FILE | sed 's/^ *//g'|sed "/^$/d" |grep Disk_ID|grep -v "Running_Status: 4"| wc -l`
        echo "    Number of disks:$DiskNumber"
        echo "    DISK Physical Info--------------------------------"

        export IFS=$'\n'
        javaID=`cat $G_TMP_FILE | sed 's/^ *//g'|sed "/^$/d" |grep Disk_ID|grep -v "Running_Status: 4"`
        for line in $javaID
        do
            if [ "${line}" = "" ];then
                continue;
            fi
            DISK=`echo $line |awk '{print $2}'`
            echo "        DISK ID:$DISK"
            DiskNodeID=`echo $line |awk '{print $5}'`
            echo "        NodeID:${DiskNodeID}"
            Location=`echo $line |awk '{print $8}'`
            echo "        Location:$Location"
            HealthStatus=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`
            HealthStatus=`MapHealthStatus $HealthStatus`
            echo "        HealthStatus:$HealthStatus"
            RunningStatus=`echo $line |awk '{print $14}'|sed 's/^ *//g'|sed "/^$/d"`
            RunningStatus=`MapRunningStatus $RunningStatus`
            echo "        RunningStatus:$RunningStatus"
            Type=`echo $line |awk '{print $17}'`
            Type=`MapDiskType $Type`
            echo "        Type:$Type"
            Capacity=`echo $line |awk -F: '{print $15}'|sed 's/|| RunTime//'`
            echo "        Capacity(MB):$Capacity"
            Speed=`echo $line |awk '{print $23}'`
            echo "        Speed:$Speed"
            Temperature=`echo $line |awk '{print $26}'`
            echo "        Temperature:$Temperature"
            Model=`echo $line |awk -F: '{print $11}'|sed 's/|| Version//'`
            echo "        Model:$Model"
            FirmwareVersion=`echo $line |awk -F: '{print $12}'|sed 's/|| Manufacture//'`
            echo "        FirmwareVersion:$FirmwareVersion"
            Vendor=`echo $line |awk -F: '{print $13}'|sed 's/|| SN//'`
            echo "        Vendor:$Vendor"
            SerialNumber=`echo $line |awk -F: '{print $14}'|sed 's/|| Size//'`
            echo "        SerialNumber:$SerialNumber"
            RunningDays=`echo $line | awk -F: '{print $16}' |sed 's/|| DiskNeedUpg//'`
            echo "        RunningDays:$RunningDays"
            echo ""
        done
    fi
}

function GetControllersInfo()
{
    echo "Controllers--------------------------------"
    echo "    Number of Controllers:1"

    ipmitool lan print > /tmp/ipmitool_info.txt
    dmidecode -s bios-version > /tmp/bios_info.txt

    if [ $? != 0 ];then
        echo "$Item: Get Controllers info file failed."
    fi

    BackIP=$MasterCM_BACK_IP

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm system" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result"
    else
        Version=`cat $G_TMP_FILE|grep "Cluster_Version"|awk -F: '{print $2}'`
        echo "    Cluster_Version:$Version"
    fi
    #BIOS汾ţ
    result=`cat /tmp/bios_info.txt| sed 's/^ *//g'|sed "/^$/d"`
    echo "    BIOS Version:$result"

    #Ϣ,MACַáIPַ롢ipmitool lan print

    result=`cat /tmp/ipmitool_info.txt| grep -w "IP Address "`
    echo "    $result"
    result=`cat /tmp/ipmitool_info.txt| grep -w "Subnet Mask"`
    echo "    $result"
    result=`cat /tmp/ipmitool_info.txt| grep -w "MAC Address"`
    echo "    $result"
    result=`cat /tmp/ipmitool_info.txt| grep -w "SNMP Community String"`
    echo "    $result"
    result=`cat /tmp/ipmitool_info.txt| grep -w "IP Header "`
    echo "    $result"
    result=`cat /tmp/ipmitool_info.txt| grep -w "BMC ARP Control"`
    echo "    $result"
    result=`cat /tmp/ipmitool_info.txt| grep -w "Gratituous ARP Intrvl"`
    echo "    $result"
    result=`cat /tmp/ipmitool_info.txt| grep -w "Default Gateway IP"`
    echo "    $result"
}

function GetNodeInfo_MML()
{
    local ID=""
    echo "Node--------------------------------"
    BackIP=$MasterCM_BACK_IP

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm node" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result"
    else
        cat $G_TMP_FILE | tr -cd [:print:][\\r\\n\\t] > $G_TMP_FILE_DOS 2>&1
        mv $G_TMP_FILE_DOS $G_TMP_FILE
        dos2unix $G_TMP_FILE

        Node=`cat $G_TMP_FILE | sed 's/^ *//g'|sed "/^$/d" | grep Node_ID|wc -l`
        echo "    Number of Node:$Node"
        echo "    Node info--------------------------------"

        export IFS=$'\n'
        javaID=`cat $G_TMP_FILE |grep "Node_ID"|sed 's/^ *//g'|sed "/^$/d"`
        for line in $javaID
        do
            if [ "${line}" = "" ];then
                continue;
            fi

            Name=`echo $line |awk '{print $5}'`
            echo "        Name:$Name"
            ID=`echo $line |awk '{print $2}'`
            echo "        ID:${ID}"
            Fram=`echo $line |awk '{print $14}'`
            echo "        Fram Number:$Fram"
            Slot=`echo $line |awk '{print $17}'`
            echo "        Slot Number:$Slot"
            SN=`echo $line |awk '{print $20}'`
            echo "        Device SN :$SN"

            typeid=$(echo $line |grep -Po '(?<=Function_Type: )[0-9]*' |tr -d ' ')
            type=$(MapNodeType "${typeid}")
            echo "        Device Type : ${type}"
            echo ""
        done
    fi

    echo "    Fs_service--------------------------------"

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm fsservice" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result"
    else
        cat $G_TMP_FILE | tr -cd [:print:][\\r\\n\\t] > $G_TMP_FILE_DOS 2>&1
        mv $G_TMP_FILE_DOS $G_TMP_FILE
        dos2unix $G_TMP_FILE
        export IFS=$'\n'
        javaID=`cat $G_TMP_FILE |sed 's/^ *//g'|sed "/^$/d" | grep Node_ID`
        for line in $javaID
        do
            if [ "${line}" = "" ];then
                continue;
            fi

            ID=`echo $line |awk -F: '{print $2}'|sed 's/|| Node_Name//'`
            echo "        ID:$ID"
            Version=`echo $line |awk -F: '{print $7}'|sed 's/|| Total_Cap//'`
            echo "        FS Service Version:$Version"
            Running=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`
            Running=`MapRunningStatus $Running`
            echo "        Running Status:$Running"
            Health=`echo $line |awk '{print $8}'|sed 's/^ *//g'|sed "/^$/d"`
            Health=`MapHealthStatus $Health`
            echo "        Health Status:$Health"
            echo ""
        done
    fi

    echo "    Node Capacity--------------------------------"

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm fsservice" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result"
    else
        cat $G_TMP_FILE | tr -cd [:print:][\\r\\n\\t] > $G_TMP_FILE_DOS 2>&1
        mv $G_TMP_FILE_DOS $G_TMP_FILE
        dos2unix $G_TMP_FILE
        export IFS=$'\n'
        javaID=`cat $G_TMP_FILE |sed 's/^ *//g'|sed "/^$/d" | grep Node_ID`
        for line in $javaID
        do
            if [ "${line}" = "" ];then
                continue;
            fi

            Name=`echo $line |awk -F: '{print $3}'|sed 's/|| Health_Status//'`
            echo "        Name:$Name"
            Capacity=`echo $line |awk -F: '{print $8}'|sed 's/|| Used_Cap//'`
            echo "        Node Capacity(MB):$Capacity"
            Used=`echo $line |awk -F: '{print $9}'`
            echo "        Node Used Capacity(MB):$Used"
        done
    fi
}

function GetFrameInfo_MML()
{
    echo "Frame--------------------------------"

    BackIP=$1

    $G_MML_PATH/CollectDataMml $BackIP 4016 "cm node" > $G_TMP_FILE 2>&1
    if [ $? -ne 0 ]; then
        Info=`cat $G_TMP_FILE`
        Result="${Info}"
        echo "$Result"
    else
        rm -rf ${G_IPMI_FILE}
        touch ${G_IPMI_FILE}
        cat $G_TMP_FILE | tr -cd [:print:][\\r\\n\\t] > $G_TMP_FILE_DOS 2>&1
        mv $G_TMP_FILE_DOS $G_TMP_FILE
        dos2unix $G_TMP_FILE
        export IFS=$'\n'
        javaID=`cat $G_TMP_FILE | grep Node_ID|sed 's/^ *//g'|sed "/^$/d"`
        for line in $javaID
        do
            if [ "${line}" = "" ];then
                continue;
            fi

            Number=`echo $line |awk '{print $14}'`
            echo "        Frame Number:$Number"
            SlotNum=`echo $line |awk '{print $17}'`
            echo "        Slot Number:$SlotNum"
            ID=`echo $line |awk '{print $2}'`
            echo "        Node ID:$ID"
            Name=`echo $line |awk '{print $5}'`
            echo "        Node Name:$Name"
            BIP=`echo $line |awk -F "Bussiness_IP:" '{print $2}'|awk -F "[||]" '{print $1}'`
            echo "        Bussiness IP:$BIP"
            MIP_Ipv4=`echo $line |awk -F "Manage_Ipv4:" '{print $2}'|awk -F "[||]" '{print $1}'`
            echo "        Manage_Ipv4 IP:$MIP_Ipv4"
            MIP_Ipv6=`echo $line |awk -F "Manage_Ipv6:" '{print $2}'|awk -F "[||]" '{print $1}'`
            echo "        Manage_Ipv6 IP:$MIP_Ipv6"
            DevMgrIP_Ipv4=`echo $line |awk -F "DevMgrIpv4:" '{print $2}'|awk -F "[||]" '{print $1}' | tr -d ' '`
            echo "        DevMgrIP_Ipv4:$DevMgrIP_Ipv4"
            DevMgrIP_Ipv6=`echo $line |awk -F "DevMgrIpv6:" '{print $2}'|awk -F "[||]" '{print $1}' | tr -d ' '`
            echo "        DevMgrIP_Ipv6:$DevMgrIP_Ipv6"
            echo ""
            if [ "X${DevMgrIP_Ipv4}" == "X" ];then
                DevMgrIP_Ipv4="null"
            fi
            if [ "X${DevMgrIP_Ipv6}" == "X" ];then
                DevMgrIP_Ipv6="null"
            fi
            echo "${Name} ${DevMgrIP_Ipv4} ${DevMgrIP_Ipv6}" >>${G_IPMI_FILE}
        done
    fi
}

function GetCongigInfo()
{
    log "start get config info"
    touch ${CONFIG_FILE} #һConfig.txtļ
    #ļ˵
    nowtime=`date "+%Y-%m-%d %H:%M:%S"`
    echo "PROFILE FOR MASSIVE STORAGE($nowtime)" > $CONFIG_FILE
    #Name:
    result=`cat /opt/huawei/snas/etc/snas.ini| grep  "cluster_name"`
    echo "    $result">> $CONFIG_FILE
    result=`cat /opt/huawei/snas/etc/snas.ini| grep  "cluster_id"`
    echo "    $result" >> $CONFIG_FILE
    #RUN TIME

    #Ϣ
    GetSummaryInfo >> $CONFIG_FILE

    sed -i 's/version.name/ISM version/g' $CONFIG_FILE
    sed -i 's/Cpu(s)/CPU Using/g'  $CONFIG_FILE
    #ûϢ
    GetUserInfo_INI >> $CONFIG_FILE
    #澯Ϣ
    GetAlarmInfo_DB >> $CONFIG_FILE
    #Ϣ
    GetControllersInfo >> $CONFIG_FILE
    #ڵϢ
    GetNodeInfo_MML >> $CONFIG_FILE
    #Ϣ
    GetFrameInfo_MML ${MasterCM_BACK_IP} >> $CONFIG_FILE
    #ӲϢ
    GetDiskInfo_MML >> $CONFIG_FILE
    #ռdiskpool
    GetDiskPoolUsage

    log "end get config info"
}

function GetDiskPoolUsage()
{
    local totalCap=0
    local freeCap=0
    local MaxOnePercentage=0
    local MinOnePercentage=0
    local diskPoolAll=""
    local node_name=""

    #ȡеdiskPoolId
    diskPoolAll=`grep DiskPool /proc/monc_dsmap|awk '{print $6}'|sort|uniq`
    iRet=$?
    if [ "$iRet" -ne 0 ] || [ "$diskPoolAll" == "" ];then
        log "get diskpooid failed."
        return 0
    fi

    for poolId in $diskPoolAll
    do
        diskSize=`grep "DiskPool $poolId" /proc/monc_dsmap`
        allDiskSize=0
        allFreeSize=0
        AllDiskUsed=0
        AvePercentage=0

        #ƽʹ
        for line in $diskSize
        do
            totalCap=`echo $line|awk '{print $10}'`
            freeCap=`echo $line|awk '{print $12}'`

            #λֽתGB expr $totalCap / 1073741824
            allDiskSize=`expr $allDiskSize \+ $totalCap`
            allFreeSize=`expr $allFreeSize \+ $freeCap`

            log "allDiskSize:$allDiskSize,allFreeSize:$allFreeSize,totalCap:$totalCap,freeCap:$freeCap"
        done

        #ȡʹʵİٷֱ AvePercentage
        AllDiskUsed=`expr $allDiskSize \- $allFreeSize`

        if [ $allDiskSize -eq 0 ];then
            AvePercentage=0
            continue
        else
            AvePercentage=`echo $AllDiskUsed*100/$allDiskSize|bc -l`
        fi

        log "allDiskSize(BYTE):$allDiskSize,allFreeSize(BYTE):$allFreeSize,AllDiskUsed(BYTE):$AllDiskUsed,AvePercentage:$AvePercentage"

        #Ƚÿһİٷֱ,ȡСʹ
        MaxOnePercentage=0
        MinOnePercentage=100

        for line in $diskSize
        do
            OneTotalCap=`echo $line|awk '{print $10}'`
            OneFreeCap=`echo $line|awk '{print $12}'`
            OneUserCap=`expr $OneTotalCap \- $OneFreeCap`

            if [ $OneTotalCap -eq 0 ];then
                OnePercentage=0
                continue
            else
                OnePercentage=`echo $OneUserCap*100/$OneTotalCap|bc -l`
            fi

            if [ $(echo "$OnePercentage > $MaxOnePercentage"|bc) -eq 1 ];then
                MaxOnePercentage=$OnePercentage;
            fi

            if [ $(echo "$MinOnePercentage > $OnePercentage"|bc) -eq 1 ];then
                MinOnePercentage=$OnePercentage;
            fi

            log "OneTotalCap:$OneTotalCap,OneFreeCap:$OneFreeCap,OneUserCap:$OneUserCap,OnePercentage:$OnePercentage,MaxOnePercentage:$MaxOnePercentage,MinOnePercentage:$MinOnePercentage."
        done

        result="DiskPool(ID):$poolId || AvePercentage:$AvePercentage || MaxPercentage:$MaxOnePercentage || MinPercentage:$MinOnePercentage"
        node_name=`cat ${G_TMP_INFO_FILE} | grep -w "${Item}" | awk '{print $3}'`
        echo ${result} > "$CM_Master_LogDir""$node_name"_MAIN/Other/diskpool_usage_info
    done
}

function printMsg()
{
    msg=$1
    msg_file="/tmp/result.txt"
    > ${msg_file}
    chown omuser:$OMGROUP ${msg_file}
    echo ${msg} > ${msg_file}
}

#####################################collect config end#############################
function killAll()
{
    for Item in $ValidIP
    do
        remote_exec $Item 100 "/opt/huawei/snas/bin/datacollect_local.sh kill 2>&1"
        log "$Item: kill collecting proc ret($?)."
    done
    if [ -d ${COLLECT_DIR} ];then
        rm -rf ${COLLECT_DIR}/*
    fi
    rm -f ${orderFile}
    log "clean ${COLLECT_DIR}/*"
}

#ȡָڵһIP
function GetBackIp
{
    local nid=$1
    local temp=1
    local iRet=0
    local IpNum=0
    local BackendIp=""
    IpNum=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select COUNT(*) from (select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID);"`
    if [ "$IpNum" -eq 0 ]; then
        LOG "[$FUNCNAME]There is no back subnet IP of $nid in db"
        return 1
    fi

    while [ "$temp" -le "$IpNum" ];
    do
        BackendIp=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID limit $((temp - 1)), $temp;"`
        if [ "$BackendIp" = "" ]; then
            LOG "[$FUNCNAME] Get back ip of $nid failed"
            temp=$((temp + 1))
            continue
        else
            #try ping
            ping "${BackendIp}" -f -c 2 -w 2 >/dev/null 2>&1
            if [ $? -ne 0 ]; then
                temp=$((temp + 1))
                continue
            else
                break
            fi
        fi
    done
    echo ${BackendIp}
}

#ȡȺIMPIIP
function GetIPMIIP()
{
    local ipv4=""
    local ipv6=""
    local iRet=""
    local node_name=""
    local tmpinfo=""
    local IFS_OLD=""
    local backIp=""
    local user=""
    local user_pass=""
    local nodeId=""

    rm -rf ${G_IPMI_FILE_TMP}
    touch ${G_IPMI_FILE_TMP}

    #ȡIPMI ipַͽڵ,ڵnid
    tmpinfo=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select NID,IPMI,IPMI_V6,HOSTNAME from CM_NODE_T where (Reserved2 = 0 OR Reserved2 = 1)")
    if [ $? -ne 0 ]; then
        log "[$FUNCNAME][$LINENO]exec sqlite cmd fail"
        return 0
    fi

    IFS_OLD=$IFS
    IFS=$'\n'
    for line in ${tmpinfo};do
        node_name=$(echo $line |awk -F "|" '{printf $4}')
        #ָڵռ
        if [ "$NODE" != "null" ]; then
            echo "$NODE" | grep -w "${node_name}" >> /dev/null
            if [ $? -ne 0 ];then
                log "IPMI FILTER NODE $node_name,get next"
                continue
            fi
        fi
        
        #ȡnid
        nodeId=`echo $line |awk -F "|" '{printf $1}'`
        #ͨidȡһõĺip
        backIp=$(GetBackIp "${nodeId}")
        if [ "{$backIp}X" == "X" ]; then
            log "nodeId=${nodeId}, backIp is null"
            continue
        fi
		
        #ʹlockexecļ/opt/huawei/snas/etc/ipmi_info.iniڵ㣬/tmp/tmp_ipmi_info.iniסɾ
        local info=$(/opt/huawei/deploy/script/localexec.py cmd ${backIp} 120 false "cat /opt/huawei/snas/etc/ipmi_info.ini")
        iRet=$?
        if [ iRet -ne 0 -o "X$info" == "X" ]; then
            log 'cmd failed: /opt/huawei/deploy/script/localexec.py cmd ${backIp} 120 false "cat /opt/huawei/snas/etc/ipmi_info.ini"'
            continue
        fi
        #ȡuserpassword
        user=$(echo $info |awk -F' ' '{print $2}' |awk -F'RHIpmiName=' '{print $2}' | tr -d ' ')
        user_pass=$(echo $info |awk -F' ' '{print $3}' |awk -F'RHIpmiInfo=' '{print $2}' | tr -d ' ')
        
        if [ "X${user}" == "X" -o "X${user_pass}" == "X" ]; then
            log "ipmi_info is empty"
            continue
        fi
        
        ipv4=`echo $line |awk -F "|" '{printf $2}'`
        ipv6=`echo $line |awk -F "|" '{printf $3}'`
        if [ "X{$ipv4}" == "X" ];then
            ipv4="null"
        fi
        if [ "X{$ipv6}" == "X" ];then
            ipv6="null"
        fi

        if [ "X${ipv4}" == "Xnull" -a "X${ipv6}" == "Xnull" ];then
            continue
        fi
        if [ "X${ipv4}" != "Xnull" ];then
            for time in ${RepeatTimes[*]}; do
                tempStr_ping=`ping -q -c 1 $ipv4  | grep received | awk '{print $4}'`
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    log "ipmi ipv4 is not connect $ipv4."
                    sleep 2
                else
                    #userpasswordԼnode nameipضG_IPMI_FILE_TMP
                    echo "${node_name} ${ipv4} ${user} ${user_pass}" >>${G_IPMI_FILE_TMP}
                    break
                fi
            done
        fi
        if [ "X${ipv6}" != "Xnull" ];then
            if [ "$tempStr_ping" -le 0 ];then
                for time in ${RepeatTimes[*]}; do
                    tempStr_ping=`ping6 -q -c 1 $ipv6  | grep received | awk '{print $4}'`
                    iRet=$?
                    if [ $iRet -ne 0 ]; then
                    log "ipmi ipv6 is not connect $ipv6."
                        sleep 2
                    else
                        echo "${node_name} ${ipv6} ${user} ${user_pass}" >>${G_IPMI_FILE_TMP}
                        break
                    fi
                done
            fi
        fi
    done
    IFS=${IFS_OLD}
}

#ռBMC־
function GetIPMIInfo()
{
    local TmpDir=""
    local node_name=""
    local log_name=""
    local log_pass_tmp=""
    local ipmi_ip=""

    #ȡIPMIõIPͶӦû
    GetIPMIIP

    while read lines
    do
        #Ŀ¼
        node_name=`echo ${lines} | awk '{print $1}' | tr -d ' '`
        ipmi_ip=`echo ${lines} | awk '{print $2}' | tr -d ' '`
        log_name=`echo ${lines} | awk '{print $3}' | tr -d ' '`
        log_pass_tmp=`echo ${lines} | awk '{print $4}' | tr -d ' '`
        TmpDir="$BMC_LogDir""$node_name"
        mkdir -p "$TmpDir"
        echo ${log_pass_tmp} |
        ${CMD_TOOL_PATH} -D "echo \"${log_name} InputUserName <<placeholder>> InputPassword ${ipmi_ip} InputIpAddr ${TmpDir}/ InputLogPath\" | /opt/huawei/snas/bin/CollectiBMCLog 2>/dev/null 1>/dev/null" &
        sleep 5
    done < ${G_IPMI_FILE_TMP}
}

#ѯBMC־Ƿռ
function pollingTask()
{
    local node_name=""
    local log_name=""
    local log_pass_tmp=""
    local ipmi_ip=""
    local psResult=0
    local tarNum=0
    local tmpDir=""

    while [ 1 ]
    do
        while read lines
        do
            node_name=`echo ${lines} | awk '{print $1}' | tr -d ' '`
            ipmi_ip=`echo ${lines} | awk '{print $2}' | tr -d ' '`
            log_name=`echo ${lines} | awk '{print $3}' | tr -d ' '`
            log_pass_tmp=`echo ${lines} | awk '{print $4}' | tr -d ' '`
            tmpDir="$BMC_LogDir""$node_name"

            log "[$FUNCNAME][$LINENO]start get BMC log,ipmi_ip=[${ipmi_ip}],node_name=[${node_name}]"

            echo ${log_pass_tmp} |
            ${CMD_TOOL_PATH} -D "echo \"${log_name} InputUserName <<placeholder>> InputPassword ${ipmi_ip} InputIpAddr ${tmpDir}/ InputLogPath\" | /opt/huawei/snas/bin/GetiBMCLog 2>/dev/null 1>/dev/null"
            sleep 5

            log "[$FUNCNAME][$LINENO]end get BMC log,ipmi_ip=[${ipmi_ip}],node_name=[${node_name}]"
        done < ${G_IPMI_FILE_TMP}
        #һѯûPID

        #ж־Ƿɹ
        while read lines
        do
            node_name=`echo ${lines} | awk '{print $1}'`
            ipmi_ip=`echo ${lines} | awk '{print $2}'`
            tmpDir="$BMC_LogDir""$node_name"

            tarNum=`ls ${tmpDir}/*.tar.gz | wc -l`
            if [ ${tarNum} -ne 0 ];then
                sed -i "/${ipmi_ip}/d" ${G_IPMI_FILE_TMP}
                #־
                if [ -d ${tmpDir} ];then
                    cd ${BMC_LogDir}
                    tar zcvf ${node_name}.tar.gz ${node_name} >/dev/null 2>&1
                    log "[$FUNCNAME][$LINENO]BMC tar file done,ipmi_ip=[${ipmi_ip}],node_name=[${node_name}],ret=[$?]"
                    rm -rf ${tmpDir}
                fi
            fi
        done <${G_IPMI_FILE_TMP}

        #־ȫȫ
        psResult=`cat ${G_IPMI_FILE_TMP} | wc -l`
        if [ ${psResult} -eq 0 ];then
            log "[$FUNCNAME][$LINENO]all BMC finish."
            break
        fi
    done
}

function execWithTimeout()
{
    #timeout error code
    local err_timeout=125
    #command to be executed
    local command=$1
    #timeout for executing
    local timeout=$2
    #checking interval
    local interval=$3
    #execute command
    local alive_count=0
    eval "${command} &"
    sub_pid=$!
    #check sub-process
    local timeOut=$timeout
    while ((timeOut > 0)); do
        kill -0 $sub_pid 2>/dev/null
        if [ $? -ne 0 ]; then
            #get exit code of sub-process
            wait $sub_pid
            return $?
        fi
        ((timeOut -= interval))
        sleep $interval
        if [ ${alive_count} -eq 12 ];then
            echo -e "keep alive"
            alive_count=0
        fi
        alive_count=$((${alive_count} + 1))
    done
    #kill sub-process
    kill -9 $sub_pid 2>/dev/null
    return $err_timeout
}

function DataCollect()
{
    ALLIp=`cat $IP_ROLE_FILE`

    log "[DataCollect]start DataCollect function ${ALLIp}"
    local version_type=""
    local node_id=""
    local SUB_TYPE_OTHER="snas,os,operate,platform,ism,oss"
    local alive_count=0
    local diskinfo_path="/var/log/cm/DataCollect/disksmartinfo/"
    local configPID=""
    local BMCPid=""

    > ${VALID_IP_FILE}
    for Item in $ALLIp
    do
        log "[DataCollect]DataCollect log from ${Item}"
        #cm⴦
        if [ "$Item" == "$MasterCM_BACK_IP" ];then

            #ռϵͳļ
            GetCongigInfo &
            configPID=$!
            log "$Item: Get SNAS config file ret($?)."
        fi
        #Զ̷Ϣ豸Ͽʼռ־
        #startʱendʱܻգΪʱ첽ִֻܴdatacollect_local.shűȡĲֻipsubtype
        #յdatacollect_local.shнsubtypeΪգռϢڿʼʱstartendΪ""Ϊnull
        for time in ${RepeatTimes[*]}; do
            version_type=`cat ${G_TMP_INFO_FILE} | grep -w "${Item}" | awk '{print $4}'`
            echo ${version_type} | grep -E "V300R006C00|V300R006C10|V100R006|V300R006C20|V500R007"
            if [ $? -eq 0 ];then
               /opt/huawei/deploy/script/localexec.py async $Item getdatacollect 10800 true "/opt/huawei/snas/bin/datacollect_local.sh "${Item}" "${TIME_START}" "${TIME_END}" "${SUB_TYPE}" > /dev/null"
               iRet=$?
            else
                /opt/huawei/deploy/script/localexec.py async $Item getdatacollect 10800 true "/opt/huawei/snas/bin/datacollect_local.sh "${Item}" "${TIME_START}" "${TIME_END}" "${SUB_TYPE_OTHER}" > /dev/null"
                iRet=$?
            fi
            log "[$FUNCNAME]:IP:$Item,return:$iRet,time:$time"
            if [ $iRet -eq 101 ]; then
                sleep 10
            else
                break
            fi
        done

        log "send start colect data to $Item,ret($iRet)"
        if [ "${iRet}" -eq 0 ]; then
            echo "$Item" >> ${VALID_IP_FILE}
        fi
    done

    #ռBMC־,BMC־Hardwareģ
    #RHִ־ռ
    {
        IsRHNode
        is_RHNode=$?
        IsTSNode
        isTS=$?
        if [ ${is_RHNode} -eq 0 -o ${isTS} -eq 0 ] && [ ${IsCollectHardware} -eq 0 ];then
            GetIPMIInfo >/dev/null 2>&1
            #ѯBMC־,ʱΪ15
            #RHִ־ռ
            execWithTimeout pollingTask 3600 5 2>/dev/null
        fi
    } &
    BMCPid=$!
    #ʼռ豸ϵ־
    ValidIP=`cat ${VALID_IP_FILE}`
    while [[ "${ValidIP}" != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            sleep 5
            log "[DataCollect] start collect log from ${Item}"
            if [ ${alive_count} -eq 12 ];then
	        echo -e "keep alive"
                alive_count=0
            fi
            alive_count=$((${alive_count} + 1))
            node_name=`cat ${G_TMP_INFO_FILE} | grep -w "${Item}" | awk '{print $3}'`
            if [ $(getUsed) -ge "${THRESHOLD_COLLECTING}" ];then

                log "The use% of /var is greater than ${THRESHOLD_COLLECTING}%,exit collecting."
                killAll
                printMsg  "The use% of /var is greater than ${THRESHOLD_COLLECTING}%."
                log "exit collect master proc"
                chmod 640 ${LOG_FILE}
                exit 1
            fi

            #Ϊ100%֮ļ,н
            for time in ${RepeatTimes[*]}; do
                proresult=`/opt/huawei/deploy/script/localexec.py progress $Item getdatacollect`
                iRet=$?
                log "[$FUNCNAME]:IP:$Item,return:$iRet,time:$time"
                if [ $iRet -eq 101 -o $iRet -eq 107 ]; then
                    sleep 10
                else
                    break
                fi
            done

            log "get data IP:$Item,proresult:$proresult"
            process=`echo $proresult | awk '{print $1}'`
            errno=`echo $proresult | awk '{print $4}'`

            if [[ "${iRet}" -eq 0 && "$process" != "100" && "$process" != "" ]];then
                echo "$Item" >> ${VALID_IP_FILE}
                continue;
            elif [ "${iRet}" -ne 0 ] || [ $errno -ne 0 ] || [ "$process" == "" ];then
                log "get data from $Item fail"
                continue;
            fi

            #ѡDIskinfoϢռôҪ־
            if [ $IsCollectDisk -eq 0 ];then
                mkdir -p ${diskinfo_path}DiskInfo$Item
                remote_download $Item ${diskinfo_path}DiskInfo$Item/DiskInfo$Item.tar.gz /var/log/cm/Diskinfo.tar.gz
            fi

            #cm⴦
            if [ "$Item" == "$MasterCM_BACK_IP" ];then

                #ݵ
                for time in ${RepeatTimes[*]}; do
                /opt/huawei/deploy/script/localexec.py download $Item "$CM_Master_LogDir""$node_name"_MAIN/$DATA_LOCAL $DATA_REMOTE
                iret=$?
                    log "[$FUNCNAME]:IP:$Item,return:$iRet,time:$time"
                    if [ $iRet -eq 101 ]; then
                        sleep 10
                    else
                        break
                    fi
                done

                log "$Item: download zip file ,ret($?)."
                if [ "${configPID}X" != "X" ];then
                    wait ${configPID}
                    log "wait master collect config info done"
                fi
                log "merge master info"
                #ڵǰĿ¼½ѹ
                #unzip "$CM_Master_LogDir""$node_name"_MAIN/$DATA_LOCAL -d "$CM_Master_LogDir""$node_name"_MAIN/ >/dev/null 2>&1
                tar -xf "$CM_Master_LogDir""$node_name"_MAIN/$DATA_LOCAL -C "$CM_Master_LogDir""$node_name"_MAIN/ >/dev/null 2>&1
                rm "$CM_Master_LogDir""$node_name"_MAIN/$DATA_LOCAL
                log "[DataCollect]Unzip master file OK"
                
                cd "$CM_Master_LogDir""$node_name"_MAIN/"$node_name"/
                tar -xzf Config.tar.gz
                
                #ļӦļ
                cat "$CM_Master_LogDir""$node_name"_MAIN/"$node_name"/Config/Config.txt >> $CONFIG_FILE
                mv $CONFIG_FILE "$CM_Master_LogDir""$node_name"_MAIN/"$node_name"/Config/
                log "$Item: Get SNAS config file ret($?)."

                #´tar.gz
                tar -czf Config.tar.gz Config
                rm -rf "$CM_Master_LogDir""$node_name"_MAIN/"$node_name"/Config
                
                #ÿڵѹΪһСtgz
                cd "$CM_Master_LogDir""$node_name"_MAIN
                mv -f "$node_name" "$node_name"_MAIN >/dev/null 2>&1
                #zip -qr "$node_name"_MAIN.tgz "$node_name"_MAIN >/dev/null 2>&1
                tar -cf "$node_name"_MAIN.tgz "$node_name"_MAIN >/dev/null 2>&1
                mv -f "$node_name"_MAIN.tgz "$CM_Master_LogDir" >/dev/null 2>&1
                cd "$CM_Master_LogDir"
                rm -rf "$node_name"_MAIN
                log "$Item: zip OK ."
                if [[ "${SmartKitVersion}" == "1.0" ]];then
                    if [ ! -d "$CM_Master_LogDir_tmp" ];then
                        mkdir -p "$CM_Master_LogDir_tmp"
                        chown omuser:$OMGROUP -R /var/log/cm
                        log "mkdir $CM_Master_LogDir_tmp"
                    fi
                    mv -f "$CM_Master_LogDir"/"$node_name"_MAIN.tgz "$CM_Master_LogDir_tmp"
                    chown omuser:$OMGROUP -R "${CM_Master_LogDir_tmp}"
                fi
                
                #ɾļ
                rm $DATA_REMOTE
            else
                #ݵ
                for time in ${RepeatTimes[*]}; do
                /opt/huawei/deploy/script/localexec.py download $Item "$CM_Master_LogDir""$node_name"/$DATA_LOCAL $DATA_REMOTE
                    local iRet=$?
                    log "[$FUNCNAME]:IP:$Item,return:$iRet,time:$time"
                    if [ $iRet -eq 101 ]; then
                        sleep 10
                    else
                        break
                    fi
                done
                log "[DataCollect]download file success"
                ##ڵǰĿ¼½ѹ
                mv "$CM_Master_LogDir""$node_name"/$DATA_LOCAL "$CM_Master_LogDir""$node_name".tgz
                cd "$CM_Master_LogDir"
                rm -rf "$CM_Master_LogDir""$node_name"
                log "[DataCollect]deal file success"
                for time in ${RepeatTimes[*]}; do
                    /opt/huawei/deploy/script/localexec.py async $Item getdatacollect 1200 true "/opt/huawei/snas/bin/datacollect_local.sh clean 2>&1"
                    local iRet=$?
                    log "[$FUNCNAME]:IP:$Item,return:$iRet,time:$time"
                    if [ $iRet -eq 101 ]; then
                        sleep 10
                    else
                        break
                    fi
                done
                if [[ "${SmartKitVersion}" == "1.0" ]];then
                    if [ ! -d "$CM_Master_LogDir_tmp" ];then
                        mkdir -p "$CM_Master_LogDir_tmp"
                        chown omuser:$OMGROUP -R /var/log/cm
                        log "mkdir $CM_Master_LogDir_tmp"
                    fi
                    mv -f "$CM_Master_LogDir"/"$node_name".tgz "$CM_Master_LogDir_tmp"
                    chown omuser:$OMGROUP -R "${CM_Master_LogDir_tmp}"
                fi
                log "$Item: clean all files ret($?)."
            fi
            log "get data form $Item finish"
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    if [ $IsCollectDisk -eq 0 ];then
        #нڵdiskifo־һļ
        DiskInfoSort
        #ɾڵdiskinfoѹ
        rm /var/log/cm/Diskinfo.tar.gz
    fi

    if [ "${BMCPid}" != "X" ];then
        log "start wait BMC process log"
        wait ${BMCPid}
        log "end wait BMC process log"
    fi
    log "end DataCollect function"
}

#Collect Cluster cli info
function DataClosterCluCli()
{
    log "DataClosterCluCli begin"
    CLUSTER_FILE="$CM_Cluster_CliDir"clicmd.txt
    echo "Cluster Info --------------------------------" > $CLUSTER_FILE

    result=`cat /opt/huawei/snas/etc/snas.ini| grep  "cluster_id"| awk -F= '{print $2}'`
    echo "  SN : $result" >> $CLUSTER_FILE
    result=`cat /opt/huawei/snas/etc/snas.ini| grep  "cluster_name"| awk -F= '{print $2}'`
    echo "  System Name: $result">> $CLUSTER_FILE
    result=`cat /opt/huawei/deploy/package/version | grep ExternalVersion |awk -F= '{print $2}'`
    echo "  Product Version : $result" >> $CLUSTER_FILE

    #prod_list
    result=`cat /opt/huawei/snas/etc/snas.ini| grep  "productType"| awk -F= '{print $2}' | sed 's/ //g'`

    if [ "$result" == "80" ]; then
        echo "  Product Model :FusionStorage Object" >> $CLUSTER_FILE
    elif [ "$result" == "48" ]; then
        ProductName=$(ipmitool fru |grep "Product Name" |awk -F: '{print $2}' |awk -F " " '{print $1" "$2}')
        ProductName=$ProductName" Series"
        deployScen=$(cat /opt/huawei/snas/etc/snas.ini |grep -w deployScene |awk -F= '{printf $2}')
        if [ "$deployScen" == "2" ];then
            ProductName="FusionStorage File"
        elif [ "$deployScen" == "3" ];then
            ProductName="FusionStorage Swift"
        fi
        echo "  Product Model :$ProductName" >> $CLUSTER_FILE
    else
        result=`cat /opt/huawei/snas/etc/snas.ini| grep "runninguderfs" | awk -F= '{print $2}' | sed 's/ //g'`
        if [ "$result" == "1" ]; then
            echo "  Product Model :FusionStorage File/Object Node" >>  $CLUSTER_FILE
        else
            echo "  Product Model :OceanStor 9000 Series" >> $CLUSTER_FILE
        fi
    fi

    log "DataClosterCluCli end"
}

function DataTar()
{
    local errorFlag=""
    local BMCerrorFlag=""
    local tmpNode=""

    errorFlag=$(ls /var/log/cm/DataCollect/System_log/ 2>/dev/null| grep -v "\.tgz$" | grep -v "BMC")
    for index in ${errorFlag}
    do
        tmpNode="${tmpNode} ${index}"
    done
    if [ ! -z "${errorFlag}" ];then
        echo "${ErrorInfoFlag}Collect log info from (${tmpNode}) Failed!"
    fi
    BMCerrorFlag=$(ls /var/log/cm/DataCollect/System_log/BMC/ 2>/dev/null | grep -v "\.tar\.gz$")
    for index in ${BMCerrorFlag}
    do
        tmpNode="${tmpNode} ${index}"
    done
    if [ ! -z "${BMCerrorFlag}" ];then
        echo "${ErrorInfoFlag}Collect BMC log info from (${tmpNode}) Failed!"
    fi
    cd /var/log/cm/
    zip -qr "$ZipFileName" DataCollect/* >/dev/null 2>&1

    log "rm $CM_Master_LogDir"
    rm -rf $CM_Master_LogDir
    rm -rf $CM_Cluster_CliDir
    rm -rf /var/log/cm/DataCollect
    chown omuser:$OMGROUP -R /var/log/cm
    log "proc OceanStor9000_datacollect.sh success."
}

function getUsed()
{
    local used=`df /var/log |grep -w '/var' | awk '{print $5}'|awk -F% '{print $1}'`
    echo ${used}
}

function  check()
{
    used=$(getUsed)
    if [ "${used}" -ge "${THRESHOLD_COLLECT}" ]; then
        log "The use% of /var is greater than ${THRESHOLD_COLLECT}%,exit collect."
        printMsg "The use% of /var is greater than ${THRESHOLD_COLLECT}%."
        echo "var.Log.reach.80"
        return 1
    fi
}

function logCheck()
{
    mkdir -p $(dirname ${LOG_FILE})
    touch ${LOG_FILE}
    tail -n5000 ${LOG_FILE} > ${LOG_FILE}.tmp
    mv ${LOG_FILE}.tmp ${LOG_FILE}
}

#ڵֵĺϷ
#ڵֻΪСдĸ֡-ĸͷԡ-ڵ֮Զŷָ
function CheckNodeName()
{
   echo "${NODE}" | sed "s/^ *//" | sed "s/ *$//" | grep  "^\([0-9a-zA-Z\-]\+,\?\)\+$" >/dev/null
   if [ $? -ne 0 ];then
       return 1
   fi
   local nodelist=($(echo "${NODE}" | sed "s/,/ /g"))
   for item in ${nodelist[*]};do
       echo "${item}" | egrep "^[a-zA-Z]$|^[a-zA-Z][0-9a-zA-Z-]*[0-9a-zA-Z]$" >/dev/null
       if [ $? -ne 0 ];then
           return 1
       fi
   done
   return 0
}

#ʱתUTCʱ
function getTimeZoneDiffSeconds()
{
    timeSeconds=$1
    curTimeZone="$(date +%z)"
    curTimeZoneSign="${curTimeZone:0:1}"
    curTimeZoneHour="${curTimeZone:1:2}"
    curTimeZoneMin="${curTimeZone:3:2}"
    diffSeconds=$(echo "${curTimeZoneHour} * 3600 + ${curTimeZoneMin} * 60" | bc)
    if [ "X${curTimeZoneSign}" == "X+" ];then
        timeSeconds=$(($timeSeconds - $diffSeconds))
    else
        timeSeconds=$(($timeSeconds + $diffSeconds))
    fi
    echo "${timeSeconds}"
}

function argsCheck()
{
    : ${4?"args error"}
    log "args :${@:1}"

    TIME_START=$1
    TIME_END=$2
    NODE=$3
    SUB_TYPE=$4

    if [ "${TIME_START}" != "null" ];then
        #2018-07-04 18:58:58
        #֤start timeʱʽǷȷ
        echo "${TIME_START}" | sed "s/^ *//" | sed "s/ *$//" | egrep "^2[0-9]{3}[.-](0?[1-9]|1[0-2])[.-](0?[1-9]|[1-2][0-9]|3[0-1]) +(0?[0-9]|1[0-9]|2[0-3]):(0?[0-9]|[1-5][0-9]):(0?[0-9]|[1-5][0-9])$" >/dev/null
        if [ $? -eq 0 ];then
            TIME_START=$(date -d "$1" +%s)
            # ʹʱĵڵʱʱһ޷תʱתUTCʱ䣬ڸݵʱ
            if [ $? -ne 0 ]; then
                log "[$FUNCNAME] Fail! Time start para is $1"
                TIME_START=$(date -u -d "$1" +%s)
                TIME_START=$(getTimeZoneDiffSeconds "${TIME_START}")
            fi
        else
            log "[$FUNCNAME][$LINENO]start time(${TIME_START}) format error,should be xxxx-xx-xx xx:xx:xx"
            TIME_START="null"
        fi
    fi

    if [ "${TIME_END}" != "null" ];then
        #֤end timeʱʽǷȷ
        echo "${TIME_END}" | sed "s/^ *//" | sed "s/ *$//" | egrep "^2[0-9]{3}[.-](0?[1-9]|1[0-2])[.-](0?[1-9]|[1-2][0-9]|3[0-1]) +(0?[0-9]|1[0-9]|2[0-3]):(0?[0-9]|[1-5][0-9]):(0?[0-9]|[1-5][0-9])$" >/dev/null
        if [ $? -eq 0 ];then
            TIME_END=$(date -d "$2" +%s)
            if [ $? -ne 0 ]; then
                log "[$FUNCNAME] Fail! Time end para is $2"
                TIME_END=$(date -u -d "$2" +%s)
                TIME_END=$(getTimeZoneDiffSeconds "${TIME_END}")
            fi
        else
            log "[$FUNCNAME][$LINENO]start time(${TIME_END}) format error,should be xxxx-xx-xx xx:xx:xx"
            TIME_END="null"
        fi
    fi
    ##򵥵һmoduleеַ
    echo "${SUB_TYPE}" | sed "s/^[ \t]*//g" | sed "s/[ \t]*$//g" | egrep "^[a-zA-Z0-9 ,;_]+$"  >/dev/null
    if [ $? -ne 0 ];then
        log "[$FUNCNAME][$LINENO]module name format error(${SUB_TYPE})"
        SUB_TYPE="DeviceManager_ToolKit,OceanStorOS,OM,MON_BJM,DFS_OBS,OSS,RPCUser,Hardware,OS,WorkLoad,DiskInfo"
    fi

    echo "$SUB_TYPE" | grep -w DiskInfo >/dev/null
    IsCollectDisk=$?

    echo "$SUB_TYPE" | grep -w Hardware >/dev/null
    IsCollectHardware=$?

    #򵥵һ½ڵеַ
    if [ "${NODE}" != "null" ]; then
    #The format of the node names is incorrect. A node name can contain only uppercase letters, lowercase letters, digits, and hyphens (-). It must start with a letter and cannot end with a hyphen (-). The node names must be separated by comma.
        CheckNodeName
        if [ $? -ne 0 ];then
            log "[$FUNCNAME][$LINENO]The format of the node names is incorrect. A node name can contain only uppercase letters, lowercase letters, digits, and hyphens (-). It must start with a letter and cannot end with a hyphen (-). The node names must be separated by comma."
            echo "${ErrorInfoFlag}The format of the node names is incorrect. A node name can contain only uppercase letters, lowercase letters, digits, and hyphens (-). It must start with a letter and cannot end with a hyphen (-). The node names must be separated by comma."
            echo "node.name.format.err"
            exit 1
        fi
    fi

    log "start :$TIME_START"
    log "end   :$TIME_END"
    log "node  :$NODE"
    log "subsys:$SUB_TYPE"
}
function cmMonCheck()
{
    local cm_master_ip=$(/opt/huawei/snas/script/getCmMaster.sh)
    if [ -z "${cm_master_ip}" ];then
        log "ERROR: Get leader IP of cm fail!"
        return 1
    fi
    local mon_leader=$(cat /proc/monc_leader | grep -Po '(?<=Mon leader: )[0-9.]*')
    if [ -z "${mon_leader}" ];then
        log "ERROR: get leader of mon fail!"
        return 1
    fi
    echo ${cm_master_ip} | grep -wFq ${mon_leader}
    if [ $? -eq 0 ];then
        log "ERROR: cm and mon's leader are on the same node!"
        return 1
    else
        log "OK: cm and mon's leader are on the different node!"
    fi
    return 0
}
function singleThread()
{
    local numThread1=$(ps -ef|grep -v grep|grep OceanStor9000_datacollect.sh|grep sudo|wc -l)
    local numThread2=$(ps -ef|grep -v grep|grep OceanStor9000_datacollect.sh|grep "/bin/sh"|wc -l)

    if [ "$numThread1" -ne 1 -o "$numThread2" -ne 2 ]; then
        log "forbid multiple users to collect informations"
        echo "multi.user.collect"
        exit 1
    fi
}
#ϢռԼļ
function CleanAllEnv()
{
    local proccFlag=0
    local procList="datacollect_local.sh|datacollect_Disklog.sh"
    local Item=""
    if [ -f "${IP_ROLE_FILE}" ];then
        proccFlag=1
    fi
    pid=$(ps -efww | egrep "${procList}" | grep -v grep | grep -v kill |  grep -v $$ | grep -v '/bin/sh -c' | grep -v "localexec" |awk '{print $2}')

    if [ ${proccFlag} -eq 0 -a "X${pid}" == "X" ];then
        log "not need to clean!"
        return 0
    fi
    if [ -f "${IP_ROLE_FILE}" ];then
        ValidIP=`cat ${IP_ROLE_FILE}`
    else
        GetIPAndRoleFromDB
        ValidIP=`cat ${IP_ROLE_FILE}`
    fi
    for Item in ${ValidIP}
    do
        /opt/huawei/deploy/script/localexec.py async ${Item} cleandatacollect 10 true "/opt/huawei/snas/bin/datacollect_local.sh kill 2>&1"
    done
    rm -rf ${IP_ROLE_FILE}
}
###############################################
# main
###############################################
#òΪãüв
if [ "$1" == "clean" ];then
    log "exec clean"
    CleanAllEnv
    exit 0
fi
#cm&mon
cmMonCheck
if [ $? -ne 0 ]; then
    echo "CmMonLeader.same.node"
    chmod 640 ${LOG_FILE}
    exit 1
fi
singleThread
logCheck
check
if [ $? -ne 0 ]; then
    log "check fail."
    chmod 640 ${LOG_FILE}
    exit 1
fi

if [ ! -f "${orderFile}" ]; then
    log "${orderFile} not exists."
    echo "order.ini.missing"
    chmod 640 ${LOG_FILE}
    exit 1
fi
dos2unix ${orderFile}

infoStartTime=$(grep "startTime" ${orderFile}|awk -F "=" '{print $2}')
infoEndTime=$(grep "endTime" ${orderFile}|awk -F "=" '{print $2}')
infoNodeID=$(grep "nodeID" ${orderFile} | sed 's/\[nodeID\]=//g')
infoType=$(grep "mode" ${orderFile}|awk -F "=" '{print $2}')
SmartKitVersion=$(grep "version" ${orderFile}|awk -F "=" '{print $2}')

argsCheck "${infoStartTime}" "${infoEndTime}" "${infoNodeID}" "${infoType}"

#get ip from DB
GetIPAndRoleFromDB

#create all log dir
CreateCollectDir

#collect all log
DataCollect

#collect Cluster CLI info
DataClosterCluCli

#last tar
DataTar

rm -f ${orderFile}
rm -rf ${IP_ROLE_FILE}
rm -rf ${G_IPMI_FILE}
rm -rf ${G_IPMI_FILE_TMP}
chmod 640 ${LOG_FILE}
exit 0

