#!/bin/bash
# ********************************************** ***************************** #
# File Name: cm_fault_disk_log_collect.sh
# Description: 盘下电前收集该盘的日志
# Input: none
# Output: none
# Created: 2017-7-17
# Function List：
# History
# **************************************************************************** #

disktool=/usr/local/bin/disktool
FAULT_DISK_LOG_PATH=/OSM/coffer_data/fault_disklog/cm_fault_disklog

DISKTYPE=$1
DISKSN=$2
DEVNAME=$3
MANUFACT=$4
MODEL=$5

function Get_disk_vendor()
{
    #首先匹配厂商字段
    if [ -n "$(echo "$MANUFACT" | grep -i "Toshiba")" ]; then
        echo "TB"
        return
    elif [ -n "$(echo "$MANUFACT" | grep -i "Seagate")" ]; then
        echo "ST"
        return
    elif [ -n "$(echo "$MANUFACT" | grep -iw "WD")" ]; then
        echo "WD"
        return
    elif [ -n "$(echo "$MANUFACT" | grep -i "HUASY")" -o -n "$(echo "$MANUFACT" | grep -i "HUASAI")" -o -n "$(echo "$MANUFACT" | grep -i "HUAWEI")" ]; then
        echo "HW"
        return
    elif [ -n "$(echo "$MANUFACT" | grep -i "Hitachi")" -o -n "$(echo "$MANUFACT" | grep -i "HGST")" -o -n "$(echo "$MANUFACT" | grep -iw "WDC")" ]; then
        echo "HG"
        return
    elif [ -n "$(echo "$MANUFACT" | grep -i "SanDisk")" ]; then
        echo "SD"
        return
    fi

    echo "UNKNOWN"
    return
}

#华为SSD
function SSD_Huawei_collect()
{
    disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -t ${DISKSN}_log3.txt -A o -z log3 $DEVNAME &>/dev/null
    disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -t ${DISKSN}_log1.txt -A o -z log $DEVNAME  &>/dev/null
    disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -t ${DISKSN}_log2.txt -A o -z log2 $DEVNAME &>/dev/null
    disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -t ${DISKSN}_log4.txt -A o -z log4 $DEVNAME &>/dev/null

    if [ -n "$(echo "$MODEL" |grep -i "HSSD-D5")" ];then
        disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -t ${DISKSN}_ExtendLog.txt  -A o -z getExtendLog $DEVNAME &>/dev/null
    fi

    Timeout_handle 300 $DEVNAME
}

#日立SSD
function SSD_Hitachi_collect()
{
    disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -A E $DEVNAME
}

#SanDisk SSD
function SSD_Sd_collect()
{
    disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -A D $DEVNAME
}

#希捷HDD
function HDD_Seagate_collect()
{
    if [ $DISKTYPE -eq 2 ];then
        #STAT
        disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -S M $DEVNAME &>/dev/null
        disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -S U $DEVNAME &>/dev/null
    else
        #SAS/NL_SAS/FC
        disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -A m $DEVNAME &>/dev/null
        disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -A u $DEVNAME &>/dev/null
    fi

    Timeout_handle 300 $DEVNAME
}

#日立HDD
function HDD_Hitachi_collect()
{
    if [ $DISKTYPE -eq 2 ];then
        #STAT
        disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -S H $DEVNAME
    else
        #SAS/NL_SAS/FC
        disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -A E $DEVNAME
    fi
}

#西数HDD
function HDD_Hg_collect()
{
    disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -S R $DEVNAME
}

#东芝HDD
function SSD_Sd_collect()
{
    if [ $DISKTYPE -eq 2 ];then
        #STAT
        disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -A T $DEVNAME
    else
        #SAS/NL_SAS
        disktool -D ${FAULT_DISK_LOG_PATH}/${DISKSN} -A F $DEVNAME
    fi
}

function SSD_Collect()
{
    case $VENDOR in
        HW)
            #华为
            SSD_Huawei_collect
            ;;
        HG)
            #日立
            SSD_Hitachi_collect
            ;;
        SD)
            #SanDisk
            SSD_Sd_collect
            ;;
        *)
            echo "UNKNOWN MANUFACT"
            exit 1
            ;;
    esac
    return 0
}

function HDD_Collect()
{
    case $VENDOR in
        ST)
            #希捷
            HDD_Seagate_collect
            ;;
        HG)
            #日立
            HDD_Hitachi_collect
            ;;
        WD)
            #西数
            HDD_Hg_collect
            ;;
        TB)
            #东芝
            HDD_Toshiba_collect
            ;;
        *)
            echo "UNKNOWN MANUFACT"
            exit 1
            ;;
    esac
    return 0
}

#判断cm_fault_disklog日志是否超过60M，超过则删除最旧的压缩文件
function CHECK_log()
{
    cd $FAULT_DISK_LOG_PATH
    while true
	do
		log_total_size="$(du -sm | awk '{print $1}')"
		if [ $log_total_size -gt 60 ]; then
			OLDDIR=`ls -tr |head -1`
			rm -rf $OLDDIR
		else
			break
		fi
	done
}

function Timeout_handle()
{
    max_time=$1
    devname=$2

    declare -i time_passed=0
    while true
    do
        sleep 1
        pid="$(ps -elf | grep "disktool -D" | grep "$devname" | grep -v grep | awk '{print $4}')"
        if [ -z "$pid" ]; then
            return 0
        fi

        #超时后杀进程并退出
        time_passed=time_passed+1
        if [ $time_passed -ge $max_time ]; then
            kill -9 $pid
            return 1
        fi
    done

    return 0
}

# collect disktool info and nofs-snas info
function CollectInfo()
{
    local info_file="${FAULT_DISK_LOG_PATH}/${DISKSN}_info.log"
    local cmd_getpoolinfo="/opt/huawei/snas/sbin/nofs-snas getpoolinfo"
    local cmd_diskinfo="${disktool} -s"
    
    if [ -f ${info_file} ];then
        /bin/bash/rm -f ${info_file}
    fi
    
    
    echo "excute ${cmd_getpoolinfo} result: " >> ${info_file}
    $(${cmd_getpoolinfo}) >> ${info_file}
    echo "------------------------------" >> ${info_file}
    echo "excute ${cmd_diskinfo} result: " >> ${info_file}
    $(${cmd_diskinfo}) >> ${info_file}
    
    return
}

#***********************start************************#

if [ ! -d ${FAULT_DISK_LOG_PATH}/${DISKSN} ];then
    mkdir -p ${FAULT_DISK_LOG_PATH}/${DISKSN}
fi

VENDOR=`Get_disk_vendor`

if [ $DISKTYPE -eq 3 ] || [ $DISKTYPE -eq 5 ] || [ $DISKTYPE -eq 6 ];then
    SSD_Collect
else
    HDD_Collect
fi

CollectInfo

CHECK_log

#***********************end************************#