#!/bin/sh
set +x
CM_DB="/opt/huawei/snas/etc/cm_conf.db"
LOG_FILE="/var/log/inspect.log"
G_TMP_INSPECT_PATH="/tmp/"

function LOG 
{
    time=$(date)
    echo [${time}][$$]$@ >> $LOG_FILE
}

#获取后端可以ping通的后端ip
GetLocalIp()
{
    local snas_ini_file="/opt/huawei/snas/etc/snas.ini"
    local IpIndex=1
    local subnetwork_id
    local BackendIp
    local IpNum
    IpNum=`cat ${snas_ini_file} | grep "ipaddr_" | wc -l`

    while [ "$IpIndex" -le "$IpNum" ]; do
        subnetwork_id=`grep "subnetwork_id_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
        if [ -z "${subnetwork_id}" ]; then
            continue
        fi

        if [ ${subnetwork_id} -eq 1 ]; then
            BackendIp=`grep "ipaddr_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
            ping "${BackendIp}" -f -c 2 -w 2 >/dev/null 2>&1
            if [ $? -ne 0 ]; then
                IpIndex=$((IpIndex + 1))
                continue
            else
                echo ${BackendIp}
                break
            fi
        fi

        IpIndex=$((IpIndex + 1))
    done
}

#获取后端ip,但是并不判断ip是否可以ping通
GetLocalIpNoPing()
{
    local snas_ini_file="/opt/huawei/snas/etc/snas.ini"
    local IpIndex=1
    local subnetwork_id
    local BackendIp
    local IpNum
    IpNum=`cat ${snas_ini_file} | grep "ipaddr_" | wc -l`

    while [ "$IpIndex" -le "$IpNum" ]; do
        subnetwork_id=`grep "subnetwork_id_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
        if [ -z "${subnetwork_id}" ]; then
            continue
        fi

        if [ ${subnetwork_id} -eq 1 ]; then
            BackendIp=`grep "ipaddr_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
            if [ -z "${BackendIp}" ] || [ "${BackendIp}" == '""' ]; then
                IpIndex=$((IpIndex + 1))
                continue
            else
                echo ${BackendIp}
                break
            fi
        fi

        IpIndex=$((IpIndex + 1))
    done
}

#===================================================
# º¯ÊýÃû³Æ£º»ñÈ¡cm_conf.dbÖÐ½Úµã¶ÔÓ¦µÄ·þÎñÀàÐÍ
# º¯Êý¹¦ÄÜ£º
# ÃèÊö£º
#===================================================
# 函数名称：获取cm_conf.db中节点对应的服务类型
# 函数功能：
# 描述：
#===================================================
function get_service_type_from_db()
{
    local temp=1
    local ip=$1
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    local service_type=$(/usr/bin/sqlite3 ${CM_DB} "select Reserved2 from CM_NODE_T where NID='${nid}'" | tr -d ' ')
    while [[ "${service_type}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get service_type from db ,temp=$temp"
        service_type=$(/usr/bin/sqlite3 ${CM_DB} "select Reserved2 from CM_NODE_T where NID='${nid}'" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done

    echo ${service_type}
}

#获取OFED版本
function GetOFEDVersion()
{
    local ofedVer="NULL"
    local tmpInfo=""
    local iRet=0
    tmpInfo=$(ofed_info -s)
    iRet=$?
    if [ $? -ne 0 ];then
        LOG "[$FUNCNAME][$LINENO]get ofed info fail,iRet=${iRet},tmpInfo=${tmpInfo}"
        echo ${ofedVer}
        return 0
    fi
    
    if [[ "${tmpInfo}" =~ "MLNX_OFED_LINUX-3.2" ]];then
        ofedVer="3.2"
    elif [[ "${tmpInfo}" =~ "MLNX_OFED_LINUX-4.2" ]];then
        ofedVer="4.2"
    elif [[ "${tmpInfo}" =~ "OFED-internal-4.4" ]];then
        ofedVer="4.4"
    elif [[ "${tmpInfo}" =~ "OFA-LINUX-4.17" ]];then
        ofedVer="4.17"
    else
        ofedVer="NULL"
        LOG "[$FUNCNAME][$LINENO]no match ofed info,tmpInfo=${tmpInfo}"
    fi

    echo ${ofedVer}
    return 0
}

#判断CM主返回1：CM主  0：非主
function isMaster()
{
    local tmpInfo=""
    local masterNodeName=""
    local localnodeName=$(hostname)
    tmpInfo=$(/usr/local/bin/MmlBatch 4016 "cm master" | grep "Node Name" | sed -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g')
    masterNodeName=$(echo "${tmpInfo}" | sed 's/Node Name: //')
    if [ "${masterNodeName}" = "${localnodeName}" ];then
        return  0
    else
        return  1
    fi
}

#===================================================
# º¯ÊýÃû³Æ£º
# º¯Êý¹¦ÄÜ£º»ñÈ¡µ±Ç°toolkitÊÇ·ñÊÇ´óÂ½°æ±¾
# ÃèÊö£ºÊÇ·µ»Øtrue£¬²»ÊÇ·µ»Øfalse
#===================================================
function GetAreaKey()
{
    local areaKeyFile="/opt/inspect/toolkit.app.zh.version"
    local resultInfo=""
    if [ -f ${areaKeyFile} ];then
        resultInfo=$(cat ${areaKeyFile})
    fi 
    
    resultInfo=${resultInfo:-false}
    echo ${resultInfo}
}

#===================================================
# º¯ÊýÃû³Æ£º
# º¯Êý¹¦ÄÜ£º±È½ÏÁ½¸ö°æ±¾ºÅµÄ¹ØÏµ(xx.xx.xx.xx)¸ñÊ½µÄ°æ±¾ºÅ
# ÃèÊö£º´óÓÚ·µ»Øgreater,Ð¡ÓÚ·µ»Øless,µÈÓÚ·µ»Øequal
#===================================================
function CheckRecommendVerVersion()
{
    local localVer=$(echo "$1" |  grep -Po '(?<=)[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+')
    local recommendVer=$(echo "$2" |  grep -Po '(?<=)[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+')
    if [[ "${localVer}" == "" ]] || [[ "${recommendVer}" == "" ]];then
        #ver格式不对
        echo "Err"
        return
    fi
    
    for((index=1; index<5; index++))
    do
        local lVer=$(echo "$localVer" | awk -F'.' '{print $'"${index}"'}')
        local rVer=$(echo "$recommendVer" | awk -F'.' '{print $'"${index}"'}')
        if [ $lVer -gt $rVer ];then
            echo "greater"
            return
        elif [ $lVer -lt $rVer ];then
            echo "less"
            return
        fi
    done
    echo "equal"
    
}

#ERR错误格式打印,只能用于巡检mml的脚本里面
function ErrInfoCommon()
{
    local input="$1"
    local filepath="$2"
    echo "[ERR]${input}" >> ${filepath} 2>&1
}
