# -*- coding: UTF-8 -*-
from cbb.frame.cli import cliUtil
from cbb.frame.base.exception import UnCheckException
from cbb.frame.base.baseUtil import is_special_patch

class DiskDomainSmoCheck:
    def __init__(self, cli, lang, logger, p_version, p_patch, p_model):
        self.cli = cli
        self.lang = lang
        self.logger = logger
        self.p_version = p_version
        self.p_patch = p_patch
        self.p_model = p_model
        self.all_cli_ret = []
        self.patch_version_dict = {
            "V300R006C10SPC100": "V300R006C10SPH108",
            "V500R007C00SPC100": "V500R007C00SPH108",
            "V300R006C50SPC100": "V300R006C50SPH116",
            "V500R007C30SPC100": "V500R007C30SPH116",
        }

        self.risk_model_list = [
            "18500 V3",
            "18500F V3",
            "18800F V3",
            "18800 V3",
            "18500 V5",
            "18500F V5",
            "18800 V5",
            "18800F V5",
        ]

    def is_risk_model(self):
        """
        检查是否风险型号
        :return:True:风险，False:非风险
        """
        return self.p_model in self.risk_model_list

    def is_risk_version(self):
        """
        检查是否风险版本
        :return:True:风险，False:非风险
        """
        return self.p_version in self.patch_version_dict

    def execute_check(self):
        """
        如果非风险版本和型号 True
        不存在fs和thin lun ：True
        :return:非风险版本和型号 True, 不存在fs和thin lun ：True
        """
        if not self.is_risk_model():
            return True

        if self.is_current_version_no_risk():
            return True

        if not self.is_exist_fs() and not self.is_exist_thin_lun():
            return True

        return False

    def is_exist_fs(self):
        """
        是否存在文件系统
        :return:
        """
        cmd = "show file_system general"
        return self.is_exist_record(cmd)

    def is_exist_thin_lun(self):
        """
        是否存在thin LUN
        :return:
        """
        cmd = (
            "show lun general |filterRow column=Type predict="
            "equal_to value=Thin"
        )
        return self.is_exist_record(cmd)

    def is_exist_record(self, cmd):
        """
        是否存在记录
        :param cmd: 命令
        :return: True: 存在记录，False: 不存在记录
        """
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(
            self.cli, cmd, False, self.lang
        )
        self.all_cli_ret.append(cli_ret)
        if flag is not True:
            raise UnCheckException(err_msg)

        if cliUtil.queryResultWithNoRecord(cli_ret):
            return False

        return len(cliUtil.getHorizontalCliRet(cli_ret)) > 0

    def is_current_version_no_risk(self):
        """
        检查是否风险版本。
        1. 不在版本范围内
        2. 安装了高于推荐的补丁
        :return: True: 无风险。Flase：存在风险
        """
        return any(
            [
                not self.is_risk_version(),
                self.p_patch >= self.patch_version_dict.get(self.p_version)
             ]
        )
