# coding=UTF-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
"""
融合存储高端整柜新增框位置算法，支持UT
"""
from cbb.common.conf.v5HighEnd.fullBayConf import START_LOC_SAS_2U_LIST
from cbb.common.conf.v5HighEnd.fullBayConf import START_LOC_SAS_4U_LIST
from cbb.common.conf.v5HighEnd.fullBayConf import START_LOC_SAS_2U_SPE_BAY
from cbb.common.conf.v5HighEnd.fullBayConf import START_LOC_IP_2U_LIST
from cbb.common.conf.v5HighEnd.fullBayConf import START_LOC_IP_2U_SPE_BAY
from cbb.common.conf.v5HighEnd.fullBayConf import AREA_NVME_2U_LIST
from cbb.common.conf.v5HighEnd.fullBayConf import START_LOC_NVME_2U_LIST


def get_available_location(cabinet_name, height, dae_enc_type,
                           is_f_series_pdt, **kwargs):
    """获取所选柜上可扩框的位置列表

    :param cabinet_name: 机柜名
    :param height: 选择框的高度
    :param dae_enc_type: 后端组网类型
    :param is_f_series_pdt: 是否是F系列产品
    :param kwargs: 可变参数
    :return:
    """
    ori_enc_2u_list = kwargs.get("ori_enc_2u_list", [])
    ori_enc_4u_list = kwargs.get("ori_enc_4u_list", [])
    new_2u_list = kwargs.get("new_2u_list", [])
    support_sas_nvme_mix = kwargs.get("support_sas_nvme_mix", False)
    available_slots_num = kwargs.get("available_slots_num", 0)

    # 2U框起始位置列表，区分SAS后端组网、IP后端组网
    if dae_enc_type == "SAS":
        start_loc_2u_list = START_LOC_SAS_2U_LIST[:]
        # F系列特殊柜位置列表
        if is_f_series_pdt and cabinet_name in START_LOC_SAS_2U_SPE_BAY.get(
                "special_dkb"):
            start_loc_2u_list = START_LOC_SAS_2U_SPE_BAY.get("loc_list")[:]
    else:
        start_loc_2u_list = START_LOC_IP_2U_LIST[:]
        # 如果选择的是特殊柜，则获取对应位置列表
        key = "f_series" if is_f_series_pdt else "non_f_series"
        if cabinet_name in START_LOC_IP_2U_SPE_BAY.get(key, {}).get(
                "special_dkb", []):
            start_loc_2u_list = START_LOC_IP_2U_SPE_BAY.get(key, {}).get(
                available_slots_num, [])[:]

    # 先排除已有的2U框位置
    for ori_enc in ori_enc_2u_list:
        start_u = get_start_u(ori_enc)
        if ori_enc.startswith(cabinet_name) and start_u in start_loc_2u_list:
            start_loc_2u_list.remove(start_u)

    # 再排除已有的4U框位置
    for ori_enc in ori_enc_4u_list:
        start_u = get_start_u(ori_enc)
        if ori_enc.startswith(cabinet_name) and start_u in start_loc_2u_list:
            # 一个4U框占2个2U框位置
            near_2u_loc = start_u + 2
            start_loc_2u_list.remove(start_u)
            start_loc_2u_list.remove(near_2u_loc)

    # 如果在NVMe情况下，需要空出引擎柜上方区域（17-42）
    if support_sas_nvme_mix and cabinet_name.startswith("SMB"):
        for loc in AREA_NVME_2U_LIST:
            if loc in start_loc_2u_list:
                start_loc_2u_list.remove(loc)

    # 选择2U框配置，直接返回
    if str(height) == "2":
        return start_loc_2u_list

    # 选择4U或2U NVMe框配置，需排除已选择的本柜新扩2U框位置
    for new_2u_enc in new_2u_list:
        if new_2u_enc[3] == cabinet_name:
            start_loc_2u_list.remove(new_2u_enc[2])

    # 选择2UNVMe框混插配置，需在剩余列表中观察几个特殊位置
    if str(height) == "3":
        if cabinet_name.startswith("SMB"):
            nvme_area = AREA_NVME_2U_LIST
            for ori_enc in ori_enc_2u_list:
                start_u = get_start_u(ori_enc)
                if ori_enc.startswith(cabinet_name) and start_u in nvme_area:
                    nvme_area.remove(start_u)
            res = list(set(START_LOC_NVME_2U_LIST)
                       .intersection(set(nvme_area)))
            res.sort()
            return res
        else:
            return []

    # 剩余空闲的4U框起始位置列表
    start_loc_4u_list = []
    for start_u in START_LOC_SAS_4U_LIST:
        if (start_u in start_loc_2u_list
                and start_u + 2 in start_loc_2u_list):
            start_loc_4u_list.append(start_u)
    return start_loc_4u_list


def get_start_u(enc_location):
    """获取硬盘框的起始位置x，SMB0.xU, DKB0_0.xU

    :param enc_location: 硬盘框location
    :return:
    """
    if "." in enc_location:
        return int(enc_location.split(".")[1].replace("U", ""))
    return enc_location
