# -*- coding: UTF-8 -*-
import traceback

from cbb.frame.base import baseUtil
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.frame.context import contextUtil
from cbb.frame.cli import cliUtil

from cbb.business.checkitems.disk_domain_smo_check import DiskDomainSmoCheck
from cbb.frame.base.exception import UnCheckException


def execute(context):
    """硬盘域空间图对象检查
    :param context:
    :return:
    """
    lang = contextUtil.getLang(context)
    logger = baseUtil.getLogger(contextUtil.getLogger(context), __file__)

    try:
        cli = contextUtil.getCli(context)
        p_model = str(context.get("dev").get("type")).strip()
        __, p_version, p_patch = cliUtil.getSystemVersion(cli, lang)
        dd_smo_check = DiskDomainSmoCheck(
            cli, lang, logger, p_version, p_patch, p_model
        )
        logger.logInfo(
            "The product is model:{},version:{} ".format(p_model, p_version)
        )
        risk_flag = dd_smo_check.execute_check()
        # 检查通过
        if risk_flag:
            BaseFactory.result.setResultPass(context)
            return
        # 检查不通过
        sug_patch = dd_smo_check.patch_version_dict.get(p_version)
        BaseFactory.result.setResultFailByKey(
            context,
            FuncFactory.LangKey.DISK_DOMAIN_SMO_NOT_PASS,
            errParamTuple=(sug_patch),
            sugParamTuple=(p_version, sug_patch)
        )
        return
    except (UnCheckException, Exception):
        logger.logInfo(
            "error :{} ".format(traceback.format_exc())
        )
        BaseFactory.result.setResultFailByKey(
            context, FuncFactory.LangKey.FUNC_GET_INFO_Y_FAIL, None, None
        )
