﻿# -*- coding: UTF-8 -*-
import json
import time

from cbb.business.operate.fru.common import common
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil

'''
运行状态检查
检查已更换硬盘的运行状态是否正常。
'''

CHECK_DISK_TIMEOUT = 100
CHECK_INTERVAL = 3
PROGRESS_INTERVAL = 1


def execute(context, select_id):
    """
    :param context: 上下文
    :param select_id: 保持数据的ID
    :return:
    """

    lang = contextUtil.getLang(context)
    logger = baseUtil.getLogger(contextUtil.getLogger(context), __file__)
    common.threadUpProcess(context, CHECK_DISK_TIMEOUT, PROGRESS_INTERVAL)
    disks = json.loads(context.get(select_id))
    start_time = time.time()
    sug_list = []
    normal_disks = set()
    while True:
        baseUtil.safeSleep(CHECK_INTERVAL)

        if (time.time() - start_time) > CHECK_DISK_TIMEOUT:
            err_msg, _ = common.getMsg(lang, "disk.running.status.abnormal")
            suggestion = "\n".join(sug_list)
            contextUtil.setResult(context, False, err_msg, suggestion)
            break

        rest = contextUtil.getRest(context)
        result = True
        for disk in disks:
            disk_id = disk.get("id")
            if disk_id in normal_disks:
                continue

            flag, sug = check_one_disk(rest, lang, logger, disk)
            result = result and flag
            if not flag:
                sug_list.append(sug)
                continue
            normal_disks.add(disk_id)
        if result:
            contextUtil.setResult(context, True, "", "")
            break

    common.finishProcess(context)
    return


def check_one_disk(rest, lang, logger, disk):
    disk_id = disk.get("id")
    disk_loc = disk.get("location")
    try:
        rec = restUtil.CommonRest.getDiskById(rest, disk_id)
        rs = restUtil.CommonRest.getRecordValue(rec, restData.RestCfg.
                                                Disk.RUNNING_STATUS)
        if rs not in [restData.RestCfg.RunningStatusEnum.ONLINE,
                      restData.RestCfg.RunningStatusEnum.LEVELING]:
            _, sug = common.getMsg(lang, "one.disk.running.status.abnormal",
                                   suggestionArgs=disk_loc)
            return False, sug
        return True, ""
    except Exception as ex:
        logger.logInfo("get disk exception:%s" % str(ex))
        _, sug = common.getMsg(lang, "get.disk.info.error",
                               suggestionArgs=disk_loc)
        return False, sug
