# coding:utf-8
""" 
@version: Toolkit V200R005C00
@time: 2018/08/13 
@file: showtrace.py.py
@function: 
@modify: 
"""
import copy
import threading
import time

import FuncFactory
from BaseFactory import log
from BaseFactory import result
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil


def getRemindInfo(context, errKey, errMsgArgs="", suggestionArgs=""):
    errMsg, suggestion = result.getMsg(context, errKey, "", errMsgArgs, suggestionArgs)
    errMsg = errMsg[0:100]
    return "<html><font color='blue'>%s</font></html>" % errMsg


class DisplayTraceThread(threading.Thread):
    def __init__(self, context, timeout, traceType="11", qryIntervalSec=30):
        super(DisplayTraceThread, self).__init__()
        self.context = context
        self.timeout = timeout
        self.traceType = traceType
        self.running = True
        self.queryInterval = qryIntervalSec

    def run(self):
        """检查新集群的控制器数量是否满足要求

        :return: 以字典形式返回结果
               flag:
                True: 检查通过
                False: 检查不通过
            errMsg: 错误消息
            suggestion: 修复建议
        """
        context = self.context
        timeOut = self.timeout
        lang = contextUtil.getLang(context)
        startTime = time.time()
        while self.running:
            elapsedTime = time.time() - startTime
            if elapsedTime >= timeOut:
                log.info(context, "query system trace time out, break now.")
                break

            retDict = qrySysTraceInfo(context)
            stepFlowList = retDict.get('stepFlowList', [])[:]
            stepFlowShowList = retDict.get('stepFlowShowList', [])

            # 上下文中写入最后一个进度的信息
            if stepFlowList:
                stepInfo = stepFlowList[-1].split(":")[0].strip()
                # 由于Step信息过于内部，将加工处理后的Step信息记录到stepFlowShowList
                stepFlowShowList.append(stepInfo)
                remindInfo = getRemindInfo(context, FuncFactory.LangKey.CTRL_POWER_ON_TRACE_NOTICE, stepInfo)
                log.info(context, u"remindInfo=%s" % remindInfo)
                context["detailInfo"] = remindInfo

            log.info(context, "stepFlowShowList=%s" % str(stepFlowShowList))

            time.sleep(self.queryInterval)

    def stop(self):
        log.info(self.context, 'stoping show trace thread.')
        self.running = False


def showPowerOnTrace(context, timeOut):
    """检查新集群的控制器数量是否满足要求

    :param context:
    :param timeOut:
    :return: 以字典形式返回结果
           flag:
            True: 检查通过
            False: 检查不通过
        errMsg: 错误消息
        suggestion: 修复建议
    """
    lang = contextUtil.getLang(context)

    startTime = time.time()
    while True:
        elapsedTime = time.time() - startTime
        if elapsedTime >= timeOut:
            log.info(context, "query system trace time out. break now.")
            break

        retDict = qrySysTraceInfo(context)
        stepFlowList = retDict.get('stepFlowList', [])[:]
        log.info(context, "stepFlowList is: %s" % str(stepFlowList))

        # 上下文中写入最后一个进度的信息
        stepFlowShowList = []
        if stepFlowList:
            stepInfo = stepFlowList[-1].split(":")[0].strip()
            # 由于Step信息过于内部，将加工处理后的Step信息记录到stepFlowShowList
            stepFlowShowList.append(stepInfo)
            log.info(context, u"stepInfo=%s" % str(stepInfo))
            detailInfo = getRemindInfo(lang, FuncFactory.LangKey.CTRL_POWER_ON_TRACE_NOTICE, stepInfo)
            log.info(context, u"detailInfo=%s" % str(detailInfo))
            context["detailInfo"] = detailInfo


def getLastSameItemCnt(itemList):
    '''
    @summary: 在给定的集合中查找与最后一个元素相同的相邻元素个数
    @param itemList: 给定的集合
    @return: 相邻元素个数
    @example: 当给定的集合为["x","y","z","x","x","x"]时，返回3
    '''
    if itemList is None or len(itemList) == 0 or type(itemList) != list:
        return 0

    lastItem = itemList[-1]
    idx = 0
    for idx, item in enumerate(reversed(itemList)):
        if item != lastItem:
            break
    return idx


def qrySysTraceInfo(context):
    # 克隆上下文使用新SN新建链接，查询Node Recovery流程状态
    trace_context = copy.copy(context)
    trace_context["conn_sn_suffix"] = "showtraceconn"
    dev_obj = contextUtil.getDevObj(trace_context)
    cli = None
    lang = contextUtil.getLang(context)
    from com.huawei.ism.tool.obase.exception import ToolException
    cli_ret = ""
    try:
        # 临时后台查询不走cliFactory缓存cli连接，新建连接即可，用完即关，不影响整体主线程流程
        connector_factory = contextUtil.getConnectorFactoryObj(trace_context)
        cli = connector_factory.createSshForwardConnector(dev_obj).getConnectionNoException()
        cmd = "show system trace"
        cmdFlg, cmdRet, _ = cliUtil.execCmdInDeveloperModePrompt(cli, cmd, isHasLog=True, lang=lang, prompt="y")
        if not cmdFlg:
            log.info(context, 'query system trace record failed.')
            return {}

        for line in cmdRet.splitlines():
            if 'Running' in line and ('NODE_RECOVERY' in line  # For V3
                                      or 'FLOW_CLS_NODE_RECOVERY' in line):  # For Dorado
                traceType = line.split()[2].strip()
                break
        else:
            return {}
        cmd = "show system trace_with_type trace_type=%s" % traceType
        checkRet = cliUtil.execCmdInDeveloperMode(cli, cmd, True, lang)
        cli_ret = checkRet[1]
        log.info(context, "system trace:%s" % str(cli_ret))
    except (ToolException, Exception) as e:
        log.error(context, "show trace exception:{}".format(str(e)))
        return {}
    finally:
        if cli:
            cli.close()
    if "Current Trace".lower() not in cli_ret.lower():
        # 未执行到具体Step时，不刷新流程信息
        return {}

    sysTraceList = cli_ret.splitlines()
    # 将所有的Step涉及的Trace加入到stepFlowList
    return get_ret_dict(context, sysTraceList)


def get_ret_dict(context, sysTraceList):
    # 记录最后一次StepFlow的集合
    last_fail_action = []
    # 记录最后一次Trace的状态集合
    last_trace_status = []
    # 记录最后一次Run Cnt的结果集合
    last_trace_run_cnt = []
    fail_action = "--"
    node_result = "--"
    step_flow = []
    trace_status_idx = 0
    trace_cnt_idx = 0
    trace_status = ""
    for i in range(0, len(sysTraceList)):
        sysTrace = sysTraceList[i].strip()
        firstWord = sysTrace.split("  ")[0].strip()
        # 获取Status
        if trace_status_idx == 0 and str(firstWord).lower() == "status" and "Total Run Count" in sysTrace:
            # Status的值在Status表头的第二行
            trace_status_idx = i + 2
            trace_cnt_idx = sysTraceList[i].index("Total Run Count")

        # 获取Step
        if firstWord.isdigit():
            stepFlow = sysTrace.split("  ")[-1]
            # Steplist中记录Step原始值，用于逻辑判断Step是否执行失败，原始值不可更改
            step_flow.append(stepFlow)

        # 获取Fail Action
        if "Fail Action".lower() in sysTrace.lower():
            fail_action = sysTrace.replace("  ", "")
        # 获取Fail Information
        if "Fail Information".lower() in sysTrace.lower():
            failInfo = sysTrace.replace("  ", "")
        # 获取Node Result
        if "Node Result".lower() in sysTrace.lower():
            node_result = sysTrace.replace("  ", "")
    log.info(context, "step_flow=%s" % str(step_flow))
    if trace_status_idx < len(sysTraceList):
        line = sysTraceList[trace_status_idx]
        trace_status = line.strip().split("  ")[0]
        if trace_cnt_idx > 0:
            traceCnt = line[trace_cnt_idx:trace_cnt_idx + len("Total Run Count")].strip()
            if traceCnt.isdigit() and traceCnt != "0":
                traceCnt = int(traceCnt)
                # 最后一次Run Cnt的结果记录到集合中
                last_trace_run_cnt.append(traceCnt)
                # 流程最后执行状态记录到集合中
                last_trace_status.append(trace_status)
                # Fail Action结果记录到集合中
                last_fail_action.append(fail_action)
    log.info(context, "last_trace_status=%s" % str(last_trace_status))
    log.info(context, "last_fail_action=%s" % str(last_fail_action))
    log.info(context, "last_trace_run_cnt=%s" % str(last_trace_run_cnt))
    log.info(context, "step_flow=%s" % str(step_flow))
    retDict = {
        'stepFlowList': step_flow,
        'lastTraceRunCntList': last_trace_run_cnt,
        'lastTraceStatusList': last_trace_status,
        'failAction': fail_action,
        'nodeResult': node_result,
        'traceStatus': trace_status
    }
    return retDict
