# -*- coding: UTF-8 -*-
"""
Created on 2017年7月28日
"""

import os
from defusedxml import ElementTree


def xml2dict(configFile):
    """根据XML的文件路径，解析XML

    :param configFile:XML文件路径
    :return: 返回字典类型的列表信息
    """
    listInfo = []
    root = ElementTree.parse(configFile)

    versionItems = root.getiterator("diskModels")
    for versionItem in versionItems:
        items = versionItem.getchildren()
        for item in items:
            tempDict = {}
            name = item.attrib["name"]
            value = item.text
            tempDict[name] = value
            listInfo.append(tempDict)
    return listInfo


def getModelInfo(diskInfoList):
    """获取硬盘model列表信息

    :param diskInfoList: 硬盘信息列表
    :return: 返回硬盘model的列表信息
    """
    diskModels = []
    modelList = []
    for diskInfo in diskInfoList:
        modelInfo = diskInfo.get("model")
        modelList.append(modelInfo)
    for model in modelList:
        diskModels.append(model.strip())
    return modelList


def getDiskInfo():
    """获取硬盘信息

    :return:
    """
    configFile = "diskInfo.xml"
    configPath = os.path.split(os.path.realpath(__file__))[0]
    configPath = configPath[:configPath.rfind("script")]
    configPath = os.path.join(configPath, configFile)
    return getModelInfo(xml2dict(configPath))
