# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import traceback
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion import common


def is_domain_or_performance_layer_encryption_type(context, cmd):
    """
    判断硬盘域或性能层是否为加密类型
    @param context: 上下文
    @param cmd: cmd
    @return: True: 加密类型 False：非加密类型
    """
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    records = cliUtil.getVerticalCliRet(cli_ret)
    return any([record
                for record in records
                if record.get("Disk Encryption Switch") == "On"])
