# coding:utf-8
from expparser import Suppress, Group, Literal, ZeroOrMore

from cbb.frame.dsl.common import DslException
from cbb.frame.dsl.adapter import get_logger, get_sn


class BaseOperator:
    def __init__(self, dsl_context, data=None):
        self.dsl_context = dsl_context

        # 是否需要将结果保存到原始信息中
        self.record = False

        # 表达式要处理的数据支持从外部传入，默认取上一步的结果
        self.data = data

        self.logger = get_logger(dsl_context.context)
        self.sn = get_sn(dsl_context.context)

    def get(self):
        raise NotImplementedError

    def base_action(self, *args):

        # 初始化处理数据，支持传入
        if not self.data:
            self.data = self.dsl_context.last_data

        # 调用action方法
        self.dsl_context.last_data = self.action(*args)
        if self.dsl_context.last_data is None:
            raise DslException("no.data")

        # 将结果保存至原始信息中
        if self.record:
            self.dsl_context.origin_info.append(self.dsl_context.last_data)
        self.logger.info("last data: {}".
                         format(str(self.dsl_context.last_data)))

    def action(self, s, loc, toks):
        """
        表达式命中后触发的事件，由各个操作符自己实现
        :param s: 字符串
        :param loc: loc
        :param toks: 拆解后的信息
        :return:
        """
        raise NotImplementedError

    @staticmethod
    def get_param(key, value=None):
        """
        用于生成提取参数的表达式
        :param key: 参数key
        :param value: 参数格式
        :return: 表达式
        """
        start_key = Suppress("-")
        if value:
            pattern = Group(
                start_key
                + Literal(key).setResultsName("key")
                + ZeroOrMore(Suppress("=") + value.setResultsName("value")))\
                .setResultsName(key)
        else:
            pattern = Group(start_key + Literal(key).setResultsName("key"))\
                .setResultsName(key)
        return pattern
