# -*- coding: UTF-8 -*-
import expparser
from cbb.frame.dsl.base_operator import BaseOperator
from cbb.frame.dsl import adapter
from cbb.frame.dsl import offline_adapter


class ExecOnAllDsl(BaseOperator):
    def __init__(self, dsl_context):
        BaseOperator.__init__(self, dsl_context)

    def get(self):
        """
        exec_on_all {}
        :return:
        """
        key = expparser.Literal("exec_on_all").setResultsName("type")
        pattern = key
        pattern.setParseAction(self.base_action)
        return pattern

    def action(self, s, loc, toks):
        self.logger.info("enter {} action ".format(toks.type))

        # 参数只能通过context带进去，执行结果放在context中返回
        self.dsl_context.context["ctrl_results"] = {}
        self.dsl_context.context["args"] = self.dsl_context.args
        if self.dsl_context.context.get("diagnoseType") == "offline":
            return offline_adapter.exec_on_all(self.dsl_context)
        return adapter.exec_on_all(self.dsl_context)
