# -*- coding: UTF-8 -*-
import ast
from cbb.frame.base import jsonUtil

def getJsonStr(obj):
    """
    将字典或集合类型数据结构转成json字符串

    Args:
        obj(dict): 字典或集合类型数据结构

    Returns:
        str: json 字符串
    """
    if type(obj) == dict:
        return dict2JsonStr(obj)

    if type(obj) == list:
        strObj = "["
        metFirst = False
        for index in range(0, len(obj)):
            strDict = dict2JsonStr(obj[index])
            if True == metFirst:
                strObj = strObj + ', ' + strDict
            else:
                strObj = strObj + strDict
                metFirst = True
        strObj = strObj + ']'
        return strObj

    return ""


def dict2JsonStr(obj):
    """
    将字典类型数据结构转成json字符串

    Parameters:
      obj(dict): 字典类型数据

    Returns:
      str: json字符串

    """
    return jsonUtil.dict2JsonStr(obj)


def jsonStr2Dict(strJson):
    """将json字符串转成字典数据结构

    Args:
        strJson(str): json字符串

    Returns:
        dict: 返回字段数据
    """
    return ast.literal_eval(unicode(strJson))


def dictList2JsonArray(portsInfoList):
    """将字典的集合转换为json数组

    Args:
        portsInfoList(dict): 端口的字典列表集合

    Returns:
        str: 端口信息对应的json数组
    """
    jsonArray = []
    for portsInfoDict in portsInfoList:
        jsonArray.append(
            "{%s}" % ",".join(['"%s":"%s"' % (key, portsInfoDict.get(key)) for key in portsInfoDict.keys()]))
    return "[%s]" % ",".join(jsonArray)


def jsonArray2DictList(jsonArray):
    """将json数组转换为字典的集合

    Args:
        jsonArray: json数组

    Returns:
        list: json数组对应的字典的集合
    """
    if jsonArray is None or len(jsonArray) <= 2:
        return None
    jsonArray = jsonArray[1:-1]
    resultDictList = []
    for items in jsonArray.split("},{"):
        resultDict = {}
        for item in items.split("\",\""):
            kv = item.replace("{", "").replace("}", "").replace("\"", "").split(":")
            if len(kv) != 2:
                return resultDictList
            resultDict[kv[0]] = kv[1]
        if len(resultDict.keys()) > 0:
            resultDictList.append(resultDict.copy())

    return resultDictList
