#!/bin/bash

function GetIPAndRoleFromDB()
{
    local lineinfo=""
    local num_cnt=0
    local max_cnt=0
    local lastNID=""
    local localNID=""
    local local_nid=""
    local node_id_ip=""
    local ret=0
    local node_ip=""
    export g_auto_node_list="/tmp/node_list_for_cert_update"
    export g_local_ip=""

    if [ -L ${g_auto_node_list} ];then
        rm -f ${g_auto_node_list}
    fi
    >${g_auto_node_list}

    local_nid=$(grep ^NID /opt/huawei/snas/etc/cm.ini | awk -F'=' '{print $2}')
    num_cnt=0
    max_cnt=5
    while [ ${num_cnt} -lt ${max_cnt} ]; do
        node_id_ip=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID' 2>/dev/null)
        if [ ! -z "${node_id_ip}" ];then
            break
        fi
        num_cnt=$((num_cnt+1))
        sleep 1
    done
    if [ ${num_cnt} -ge ${max_cnt} ];then
        echo "Get cluster info from cm_conf.db failed!"
        exit 1
    fi
    
    num_cnt=1
    max_cnt=$(echo "${node_id_ip}" | wc -l)
    while [ ${num_cnt} -le ${max_cnt} ]; do
        lineinfo=$(echo ${node_id_ip} | awk '{print $'$num_cnt'}')
        node_ip=$(echo "${lineinfo}" | awk -F'|' '{print $2}')
        localNID=$(echo "${lineinfo}" | awk -F'|' '{print $1}')
        if [ "x${localNID}" = "x${lastNID}" ];then
            num_cnt=$((num_cnt+1))
            continue
        fi
        tempStr_ping=$(ping -q -c 1 "${node_ip}"  | grep "received" | awk '{print $4}')
        num_cnt=$((num_cnt+1))
        lastNID="${localNID}"
        if [ "${tempStr_ping}" -le 0 ];then
            localNID=$(echo "${node_id_ip}"| sed -n ''$num_cnt'p'| awk -F'|' '{print $1}')
            if [ "x${localNID}" = "x${lastNID}" ];then
                node_ip=$(echo "${node_id_ip}" | sed -n ''$num_cnt'p'| awk -F'|' '{print $2}')
                tempStr_ping=$(ping -q -c 2 "${node_ip}"  | grep "received" | awk '{print $4}')
                num_cnt=$((num_cnt+1))
                lastNID="${localNID}"
                if [ "${tempStr_ping}" -le 0 ];then
                    ret=1
                    break
                fi
            else
                ret=1
                break
            fi
        fi

        if [ "x${localNID}" = "x${local_nid}" ];then
            g_local_ip=${node_ip}
        fi
        
        echo "${node_ip}" >> ${g_auto_node_list}
    done

    if [ ${ret} -ne 0 ];then
        echo "${localNID}: The backend network of the node is abnormal!"
        exit ${ret}
    fi
    return 0
}

function encode()
{
    local strencode=$(echo $@ | base64 -i)
    if [ "X" != "${strencode}" ];then
        echo ${strencode}
        strencode=""
        return 0
    fi
    return 1    
}

function decode()
{
    local strdecode=$(echo $@ | base64 -d)
    if [ "X" != "${strdecode}" ];then
        echo ${strdecode}
        strdecode=""
        return 0
    fi
    return 1 
}

function GetCertList()
{
    #Same as dir-name in Certificate package
    echo "Management emailAlarm emailPass emailEmui DeployServer DeviceManager ToolkitHttps"
}

function RestartSnasDeploy()
{
    /opt/huawei/deploy/bin/daemon -s /opt/huawei/deploy/bin/snas_deploy
    sleep 2
    /opt/huawei/deploy/bin/daemon /opt/huawei/deploy/bin/snas_deploy
}

function UpdateManagementCert()
{
    local iret=0
    local strret=""
    strret=$(PATH=$PATH:/usr/local/bin/;sh /opt/huawei/snas/script/updateCertificate.sh <<<"$(decode $@)")
    echo ${strret} | grep "update certificate ok" >/dev/null
    iret=$?
    return ${iret}
}

function RestartDeviceManager()
{
    local iret=0
    local idx=0
    local strRet=""
    if [ -f /opt/deviceManager/bin/restart.sh ]; then
        for idx in 1 2 3; do
            strRet=$(sh /opt/deviceManager/bin/restart.sh 2>&1)
            iret=$?
            if [ ${iret} -eq 0 ]; then
                break
            fi
        done
    fi
    echo "${strRet}"
    return ${iret}
}

function UpdateDeviceManagerCert()
{
    local iret=0
    local cert="DeviceManager"
    local key=$2
    local tmpDir="/tmp/Certificate$$"
    local createFlag=0
    local tmpCertDir=${tmpDir}/Certificate/${cert}

    if [ ! -f /opt/inspect/Certificate.tar.gz ]; then
        return 1
    fi
    if [ ! -d ${tmpDir} ]; then
        mkdir -p ${tmpDir} || return 1
        createFlag=1
    fi
    tar zxf /opt/inspect/Certificate.tar.gz -C ${tmpDir} 
    iret=$?
    if [ ${iret} -ne 0 ]; then
        [ ${createFlag} -eq 1 ] && rm -rf ${tmpDir}
        return 1
    fi
    CertBackup ${cert} ${tmpCertDir}
    iret=$?
    if [ ${iret} -ne 0 ]; then
        [ ${createFlag} -eq 1 ] && rm -rf ${tmpDir}
        return 1
    fi

    cd /opt/deviceManager/bin
    sh importKey.sh << INPUT
y
${tmpCertDir}/key_en.pem
${tmpCertDir}/cert_en.pem
$(decode ${key})
n
INPUT
    iret=$?
    [ ${createFlag} -eq 1 ] && rm -rf ${tmpDir}
    if [ ${iret} -ne 0 ]; then
        return ${iret}
    fi

    sleep 5 #wait sync
    local iplist=$(cat ${g_auto_node_list})
    for node in ${iplist}; do
        echo "Restart Device Manager on ${node}..."
        remote_exec ${node} 60 "/opt/huawei/snas/script/inspect_mml/CheckItems updateCert ${cert}"
        iret=$?
        if [ ${iret} -ne 0 ]; then
            echo "Execute 'sh /opt/deviceManager/bin/startSystem.sh' on ${node} mannually."
        fi
    done
}
function GetCertType()
{
    local certName=$1
    if [ "${certName}" = "/opt/huawei/snas/etc/sslcert.pem" -o "${certName}" = "/opt/huawei/snas/etc/sslkey.pem" -o "${certName}" = "" ]; then 
        echo "Management"
    elif [ "${certName}" = "/opt/deviceManager/apache/conf/cert_en.pem" -o "${certName}" = "/opt/deviceManager/apache/conf/key_en.pem" -o "${certName}" = "/opt/deviceManager/apache/conf/ca.crt" ]; then 
        echo "DeviceManager"
    elif [ "${certName}" = "/opt/huawei/snas/etc/cert/alarm/cacert.pem" -o "${certName}" = "/opt/huawei/snas/etc/cert/alarm/crl.pem" ]; then
        echo "emailAlarm"
    elif [ "${certName}" = "/opt/huawei/snas/etc/cert/password/cacert.pem" -o "${certName}" = "/opt/huawei/snas/etc/cert/password/crl.pem" ]; then
        echo "emailPass"
    elif [ "${certName}" = "/opt/huawei/snas/etc/cert/emui/cacert.pem" -o "${certName}" = "/opt/huawei/snas/etc/cert/emui/crl.pem" ]; then
        echo "emailEmui"
    elif [ "${certName}" = "/opt/huawei/deploy/etc/cluster_cert.pem" -o "${certName}" = "/opt/huawei/deploy/etc/cluster_key.pem" -o "${certName}" = "/opt/huawei/deploy/etc/cluster_ca.cer" ]; then
        echo "LocalExec"
    elif [ "${certName}" = "/opt/huawei/deploy/etc/toolkit_dep_key.pem" -o "${certName}" = "/opt/huawei/deploy/etc/toolkit_dep_cert.pem" ]; then
        echo "DeployServer"
    elif [ "${certName}" = "/opt/Runtime/tomcat7/conf/server.keystore" ]; then
        echo "ToolkitHttps"
    fi
}
function GetCertInfo()
{
    local certName=$1
    if [ "${certName}" = "Management" ]; then 
        echo "/opt/huawei/snas/etc/sslcert.pem\
              /opt/huawei/snas/etc/sslkey.pem"   #No CA
    elif [ "${certName}" = "DeviceManager" ]; then
        echo "/opt/deviceManager/apache/conf/cert_en.pem\
              /opt/deviceManager/apache/conf/key_en.pem\
              /opt/deviceManager/apache/conf/ca.crt"
    elif [ "${certName}" = "emailAlarm" ]; then
        echo "/opt/huawei/snas/etc/cert/alarm/cacert.pem\
              /opt/huawei/snas/etc/cert/alarm/crl.pem"
    elif [ "${certName}" = "emailPass" ]; then
        echo "/opt/huawei/snas/etc/cert/password/cacert.pem\
              /opt/huawei/snas/etc/cert/password/crl.pem"
    elif [ "${certName}" = "emailEmui" ]; then
        echo "/opt/huawei/snas/etc/cert/emui/cacert.pem\
              /opt/huawei/snas/etc/cert/emui/crl.pem"
    elif [ "${certName}" = "LocalExec" ]; then
        echo "/opt/huawei/deploy/etc/cluster_cert.pem\
              /opt/huawei/deploy/etc/cluster_key.pem\
              /opt/huawei/deploy/etc/cluster_ca.cer"
    elif [ "${certName}" = "DeployServer" ]; then
        echo "/opt/huawei/deploy/etc/toolkit_dep_cert.pem\
              /opt/huawei/deploy/etc/toolkit_dep_key.pem"
    elif [ "${certName}" = "ToolkitHttps" ]; then
        echo "/opt/Runtime/tomcat7/conf/server.keystore"
    fi
}

#param1 cert-name, param2 dir(end without '/') of target cert
function CertBackup()
{
    local iret=0
    local cert=$1
    local tarCertDir=$2
    local certFileList=$(GetCertInfo ${cert})
    local backupDir="/opt/inspect/Certificate/Backup/${cert}"
    if [ ! -d ${tarCertDir} ]; then
        echo "Not find target file of ${cert}."
        return 1
    fi
    if [ ! -d ${backupDir} ]; then
        mkdir -p ${backupDir}
    fi
    local fname=""
    local shaSrc=""
    local shaDst=""
    for file in ${certFileList}; do
        if [ -f ${file} ]; then
            fname=$(basename ${file})
            if [ -f ${backupDir}/${fname} ]; then #already backup
                shaSrc=$(sha256sum ${tarCertDir}/${fname} 2>/dev/null | awk '{print $1}')
                shaDst=$(sha256sum ${file} 2>/dev/null | awk '{print $1}')
                if [ "${shaDst}" != "${shaSrc}" ]; then
                    cp -f ${file} ${backupDir}/
                    iret=$?
                fi
            else
                cp -f ${file} ${backupDir}/
                iret=$?
            fi
        fi
        if [ ${iret} -ne 0 ]; then
           break
        fi
    done
    return ${iret}
}

function CertReplace()
{
    local iret=0
    local cert=$1
    local tarCertDir=$2
    local key=$3
    local certFileList=$(GetCertInfo ${cert})
    if [ ! -d ${tarCertDir} ]; then
        echo "Not find target file of ${cert}."
        return 1
    fi
    local fname=""
    for file in ${certFileList}; do
        if [ -f ${file} ]; then
            fname=$(basename ${file})
            if [ -f ${tarCertDir}/${fname} ]; then
                cp -f ${tarCertDir}/${fname} ${file}
                iret=$?
            fi
        fi
        if [ ${iret} -ne 0 ]; then
           return ${iret}
        fi
    done
    if [ "${cert}" = "DeployServer" ]; then
        RestartSnasDeploy
        return 0
    fi
    if [ "${cert}" = "Management" ]; then
        UpdateManagementCert ${key}
        return $?
    fi
    return 0
}

function CertRestore()
{
    local cert=$1
    local tarCertDir=$2
    local key=$3
    local certFileList=$(GetCertInfo ${cert})
    local backupDir="/opt/inspect/Certificate/Backup/${cert}"
    local fname=""
    for file in ${certFileList}; do
        if [ -f ${file} ]; then
            fname=$(basename ${file})
            [ -f ${backupDir}/${fname} ] && cp -f ${backupDir}/${fname} ${file}
        fi
    done
    if [ "${cert}" = "DeployServer" ]; then
        RestartSnasDeploy
        return 0
    fi
    if [ "${cert}" = "Management" ]; then
        UpdateManagementCert ${key}
        return $?
    fi
    return 0
}

function GetAndSaveCertStatus()
{
    rm -f /tmp/tmpResultCheckAllCertificate
    if [ -e /opt/huawei/snas/script/inspect_mml/CheckAllCertificate ]; then
        sh /opt/huawei/snas/script/inspect_mml/CheckAllCertificate
    fi
    if [ -f /tmp/tmpResultCheckAllCertificate ]; then
        return 0
    else
        return 1
    fi
}

function UploadCertPkg()
{
    local iret=0
    local iplist=$(cat ${g_auto_node_list})
    for node in ${iplist}; do
        /opt/huawei/deploy/script/localexec.py upload ${node} "/opt/inspect/Certificate.tar.gz" "/var/log/Certificate.tar.gz"
        iret=$?
        if [ ${iret} -ne 0 ]; then
            echo "Upload Certificate.tar.gz to ${node} failed."
            exit 1
        fi
    done
}

function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    local iret=0
    for times in $(seq 1 3); do
        /opt/huawei/deploy/script/localexec.py cmd ${remote_ip} ${time_out} false "${cmd}"
        iret=$?
        if [ ${iret} -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return ${iret}
}

function DoCertUpdate()
{
    local cert=$1
    local key=$2
    local iret=0
    local iplist=$(cat ${g_auto_node_list})
    local ippassed=""
    if [ "${cert}" = "DeviceManager" ]; then
        UpdateDeviceManagerCert ${cert} ${key}
        iret=$?
        if [ ${iret} -ne 0 ]; then
            echo "Failed to update ${cert}"
        fi
        return ${iret}
    fi
    for node in ${iplist}; do
        remote_exec ${node} 180 "/opt/huawei/snas/script/inspect_mml/CheckItems updateCert ${cert} ${key}"
        iret=$?
        if [ ${iret} -ne 0 ]; then
            echo "Failed to update ${cert} on ${node}."
            break
        fi
        ippassed="${ippassed} ${node}"
    done
    if [ ${iret} -eq 0 ]; then
        return 0
    fi
    
    #restore
    for node in ${ippassed}; do
        remote_exec ${node} 180 "/opt/huawei/snas/script/inspect_mml/CheckItems restoreCert ${cert} ${key}"
        iret=$?
        if [ ${iret} -ne 0 ]; then
            echo "Failed to restore ${cert} on ${node}."
        fi
    done
    return 1
}


function updateSingleCert()
{
    local outtimeFlag=""
    local defaultCert=""
    local forceNoDefault=$1
    local forceNoOuttime=$2
    local cert=$3
    local key=$4
    local certPubFile=""
    local certFileList=""
    local certInfo=""
    local isFail=0
    
    certFileList=$(GetCertInfo ${cert})
    if [ "${certFileList}" = "" ]; then
        echo "Do not support updating ${cert}."
        return 0
    fi
    certPubFile=$(echo ${certFileList} | awk '{print $1}')
    certInfo=$(grep "${certPubFile}" /tmp/tmpResultCheckAllCertificate 2>/dev/null)
    if [ "${certInfo}" = "" ]; then
        echo "Failed to get ${cert} status."
        return 1
    fi

    outtimeFlag=$(echo "${certInfo}" | awk -F'|' '{print $3}' | awk -F':' '{print $2}')
    defaultCert=$(echo "${certInfo}" | awk -F'|' '{print $7}' | awk -F':' '{print $2}')
    if [ "${defaultCert}" = "YES" -o "${forceNoDefault}" = "YES" ]; then
        if [ "${outtimeFlag}" = "YES" -o "${forceNoOuttime}" = "YES" ]; then
            DoCertUpdate ${cert} "${key}"
            isFail=$?
            if [ ${isFail} -ne 0 ]; then
                echo "Failed to update ${cert}."
                return 1
            else
                echo "${cert} is update."
                return 0
            fi
        else
            echo "${cert} is non outtime."
        fi
    else
        echo "${cert} is non default."
    fi
    return 0
}     

