#!/bin/bash

MapHealthStatus()
{
    case $1 in
        0)
            echo "UNKNOWN"
            ;;
        1)
            echo "NORMAL"
            ;;
        2)
            echo "FAULT"
            ;;
        3)
            echo "PRE_FAIL"
            ;;
        4)
            echo "PART_BROKEN"
            ;;
        5)
            echo "DEGRADE"
            ;;
        6)
            echo "HAS_BAD_BLOCK"
            ;;
        7)
            echo "HAS_ERROR_CODE"
            ;;
        8)
            echo "CONSISTENT"
            ;;
        9)
            echo "INCONSISTENT"
            ;;
        10)
            echo "BUSY"
            ;;
        11)
            echo "POWER_NO_INPUT"
            ;;
        12)
            echo "POWER_NOT_ENOUGH"
            ;;
        13)
            echo "SINGLE_LINK_FAULT"
            ;;
         *)
            echo "No this type"
            ;;
    esac
}

MapNodeServiceType()
{
    case $1 in
    1)
        echo "DFS"
        ;;
    2)
        echo "S3"
        ;;
    3)
        echo "SWIFT"
        ;;
    *)
        echo "UNKNOWN"
        ;;
    esac  
}

MapRunningStatus()
{
    case $1 in
        0)
            echo "UNKNOWN"
            ;;
        1)
            echo "NORMAL"
            ;;
        2)
            echo "RUNNING"
            ;;
        3)
            echo "NOT_RUNNING"
            ;;
        4)
            echo "NOT_EXIST"
            ;;
        5)
            echo "HIGH_TEMPERATURE_SLEEP"
            ;;
        6)
            echo "STARTING"
            ;;
        7)
            echo "POWER_FAILURE_PROTECTING"
            ;;
        8)
            echo "SLEEPING"
            ;;
        9)
            echo "SPINGUP"
            ;;
        10)
            echo "LINK_UP"
            ;;
        11)
            echo "LINK_DOWN"
            ;;
        12)
            echo "POWER_ON"
            ;;
        13)
            echo "POWER_OFF"
            ;;
        14)
            echo "PRE_COPY"
            ;;
        15)
            echo "COPYBACK"
            ;;
        16)
            echo "RECONSTRUCTION"
            ;;
        17)
            echo "EXPANSION"
            ;;
        18)
            echo "NOT_FORMAT"
            ;;
        19)
            echo "FORMATTING"
            ;;
        20)
            echo "UNMAPPING"
            ;;
        21)
            echo "INITIAL_SYNCHRONIZING"
            ;;
        22)
            echo "CONSISTENT"
            ;;
        23)
            echo "SYNCHRONIZING"
            ;;
        24)
            echo "SYNCHRONIZED"
            ;;
        25)
            echo "NOT_SYNCHRONIZED"
            ;;
        26)
            echo "SPLIT"
            ;;
        27)
            echo "ONLINE"
            ;;
        28)
            echo "OFFLINE"
            ;;
        29)
            echo "LOCKED"
            ;;
        30)
            echo "ENABLE"
            ;;
        31)
            echo "DISABLED"
            ;;
        32)
            echo "LEVELING"
            ;;
        33)
            echo "TO_BE_RECOVERD"
            ;;
        34)
            echo "INTERRUPTED"
            ;;
        35)
            echo "INVALID"
            ;;
        36)
            echo "NOSTART"
            ;;
        37)
            echo "QUEUING"
            ;;
        38)
            echo "STOP"
            ;;
        39)
            echo "COPYING"
            ;;
        40)
            echo "COMPLETED"
            ;;
        41)
            echo "PAUSE"
            ;;
        42)
            echo "REVSYNCHRONIZING"
            ;;
        43)
            echo "ACTIVATED"
            ;;
        44)
            echo "ROLLBACK"
            ;;
        45)
            echo "INACTIVATED"
            ;;
        46)
            echo "IDLE"
            ;;
        47)
            echo "POWERING_OFF"
            ;;
        48)
            echo "CHARGING"
            ;;
        49)
            echo "CHARGED"
            ;;
        50)
            echo "DISCHARGING"
            ;;
        51)
            echo "UPGRADING"
            ;;
        55)
            echo "ONLINE_DISABLED"
            ;;
        56)
            echo "OFFLINE_DISABLED"
            ;;
        57)
            echo "ONLINE_FROZEN"
            ;;
        58)
            echo "OFFLINE_FROZEN"
            ;;
        59)
            echo "SHUTDOWN"
            ;;
        98)
            echo "LOADING"
            ;;
        99)
            echo "INSTALLING"
            ;;
        *)
            echo "No this type"
            ;;
    esac
}

MapDeviceType()
{
    case $1 in
        33)
            echo "P25 Node"
            ;;
        34)
            echo "P36|C36 Node"
            ;;
        65)
            echo "P12 Node"
            ;;
        74)
            echo "C72 Node"
            ;;

        *)
            echo "No this node type"
            ;;
    esac
}

InspectIsRHNode()
{
    #12:P12E 13:P25E 14:P36E 15:C36E 16:C36E_H 17:FS_OBJ 21:P12X 22:P25X 23:P36X 24:P36X_H 25:C36X 26:C36X_H 27:FS_F12X 28:FS_F25X 29:FS_F36X 30:S25A 31:S25B
    RHtypelist="12 13 14 15 16 17 21 22 23 24 25 26 27 28 29 30 31"
    echo "${RHtypelist}" | grep -w $1 >/dev/null
    return $?
}

MapNodeType()
{
    case $1 in
    0)
        echo "P Node"
        ;;
    1)
        echo "C Node"
        ;;
    2)
        echo "B Node"
        ;;
    3)
        echo "M Node"
        ;;
    4)
        echo "C72 Node"
        ;;
    5)
        echo "P25 Node"
        ;;
    6)
        echo "P36 Node"
        ;;
    7)
        echo "C36 Node"
        ;;
    8)
        echo "P12 Node"
        ;;
    12)
        echo "P12E Node"
        ;;
    13)
        echo "P25E Node"
        ;;
    14)
        echo "P36E Node"
        ;;
    15)
        echo "C36E Node"
        ;;
    16)
        echo "C36E-H Node"
        ;;
    17)
        echo "FS_OBJ Node"
        ;;
    21)
        echo "P12X Node"
        ;;
    22)
        echo "P25X Node"
        ;;
    23)
        echo "P36X Node"
        ;;
    24)
        echo "P36X-H Node"
        ;;
    25)
        echo "C36X Node"
        ;;
    26)
        echo "C36X-H Node"
        ;;
    27)
        echo "F12B Node"
        ;;
    28)
        echo "F25B Node"
        ;;
    29)
        echo "F36B Node"
        ;;
    30)
        echo "S25A Node"
        ;;
    31)
        echo "S25B Node"
        ;;
    40)
        echo "F12B-H Node"
        ;;
    46)
        echo "F36B-L Node"
        ;;
    47)
        echo "F36B-C Node"
        ;;
    48)
        echo "F36B-CH Node"
        ;;
    *)
        echo "No this node type"
        ;;
    esac
}

MapDiskType()
{
    case $1 in
        0)
            echo "FC"
            ;;
        1)
            echo "SAS"
            ;;
        2)
            echo "SATA"
            ;;
        3)
            echo "SAS_SSD"
            ;;
        4)
            echo "NL_SAS"
            ;;
        5)
            echo "SLC_SSD"
            ;;
        6)
            echo "MLC_SSD"
            ;;
        16)
            echo "NVME_SSD"
            ;;
        17)
            echo "SATA_SSD"
            ;;
        *)
            echo "No this type"
            ;;
    esac
}

MapPowerType()
{
    case $1 in
        0)
            echo "DC"
            ;;
        1)
            echo "AC"
            ;;
        *)
            echo "No this type"
            ;;
    esac
}
BusModeStatus()
{
    case $1 in
	0)
	    echo  "IDE"
		;;
	1)
	    echo  "VIRTIO"
		;;
	*)
        echo "No this type"
       ;;
	esac
}
StatModeStatus()
{
	case $1 in
	0)
            echo "HD"
		;;

	1)
	    echo "CD"
		 ;;
	*)
        echo "No this type"
         ;;
	esac

}

###addѲӳ
GetInspectType()
{
    case $1 in
        100)
            #1.Check Disk Usage
            echo "checkDiskUsage"
            ;;
        101)
            #2.Check CPU Usage
            echo "checkCPUUsage"
            ;;
        103)
            #4.Check Disk Status
            echo "checkDiskStatus_MML"
            ;;
        106)
            #7.Check Netport Status
            echo "ShowNIC"
            ;;
        109)
            #10.Check disk verify error
            echo "checkDiskVerify"
            ;;
        110)
            #ڵ()¶
            echo "checkCardTemp"
            ;;
        111)
            #ڴü
            echo "checkMemCfg"
            ;;
        113)
            #check SSD
            echo "GetSSDInfo"
            ;;
        114)
            #check RAID
            echo "Checksysdisk"
            ;;
        117)
            #check ARP
            echo "checkArpErr_MML"
            ;;
        130)
            #PHY
            echo "CheckDiskPhy"
            ;;
        133)
            #ڴ
            echo "CheckPhyMem"
            ;;
        134)
            echo "checkNodeNCQ"
            ;;
        136)
            #豸ڵǷʱԴ쳣
            echo "checkClockSourceRisk"
            ;;
        139)
            # rmbg񲢷
            echo "checkRMGB"
            ;;
        140)
            #Ϣ
            echo "checkVmstatus"
            ;;
        143)
            #S3ݿЧռ
            echo "checkDBAvailableSpace"
            ;;
        144)
            #PCIEЭ
            echo "CheckPcieSpeed"
            ;;
        145)
            #SES̼汾
            echo "GetSesFwVersion"
            ;;
        146)
            #д
            echo "checkDiskWriteCache"
            ;;
        147)
            #SAS̼汾
            echo "checkSASVersion"
            ;;
        148)
            #SMR״̬
            echo "CheckSMRdiskinfo"
            ;;
        149)
            #ڵMTUǷһ¡֡
            echo "checkNetportBitErrandJumboframe"
            ;;
        150)
            #̿ؼ
            echo "checkKicksSwitch"
            ;;
        151)
            #̼汾
            echo "checkNetAdapterVersion"
            ;;
        157)
            #ڵӱǩ
            echo "CheckElecLabel"
            ;;
        171)
            # ES3000V6
            echo "CheckHssdV6DiskLifeRisk"
            ;;
        202)
            #4.Check Node IO Perform
            echo "ShowNodeIO"
            ;;
        203)
            #4.Check Watchdog Status
            echo "checkWatchdogStatus_Async"
            ;;
        204)
            #4.MON connection Status with each subsystem
            echo "MonConStatuswithEachSubsys"
            ;;
        205)
            #6.Check NTP Service
            echo "checkNTPService"
            ;;
        206)
            #7.Check CM master
            echo "checkCMMaster"
            ;;
        209)
            #10.Check File operationļ
            echo "ShowFileOperation"
            ;;
        210)
            #11.Check NAS client
            echo "checkALLClient"
            ;;
        211)
            #12.Check NAS Cluster Status
            echo "checkNASClusterStatus"
            ;;
        213)
            #14.Check Communication Link (ڵϵͨѶ·)
            echo "checkCommuLink"
            ;;
        214)
            #14.Check memory pool usage
            echo "checkMemPoolUsage_Async"
            ;;
        215)
            #Check data consistentһ
            echo "checkDataConsistent_Async"
            ;;
        218)
            #linuxϵͳ򿪵ļ
            #Check system file opened
            echo "checkSystemFileOpened"
            ;;
        221)
            #Check LDAP ط״̬
            echo "ShowLdapServer"
            ;;
        222)
            #Check IPMIַǷ
            echo "checkIPMI"
            ;;
        225)
            #ҵڵ״̬  mon mds pip
            echo "checkMasterStatus"
            ;;
        226)
            #MON Serverڵ
            echo "checkMonServer"
            ;;
        227)
            #Nvdimmڴصʹ
            echo "checkNvdimmPool"
            ;;
        231)
            #MONǷƵѡ
            echo "checkMonHealth"
            ;;
        233)
            #Ƿcoreļ
            echo "checkCoreFile"
            ;;
        234)
            #ntp״̬
            echo "checkNtpConn"
            ;;
        236)
            #дNOFSǷгʱ
            echo "CheckWrtNofsTimeout"
            ;;
        242)
            #һɨ赼µعʧ
            echo "CheckRecovFailForDSC"
            ;;
        244)
            #ɾ
            echo "checkDelTask"
            ;;
        245)
            #1.Check Replication Link
            echo "checkReplicationLink"
            ;;
        246)
            #1.Check Replication Process
            echo "checkReplicationProcess"
            ;;
        247)
            #1.Check ReplicationZone Status
            echo "checkReplicationZoneStatus"
            ;;
        248)
            #1.Check Replication Pair Status
            echo "checkReplicationPairStatus"
            ;;
        249)
            #1.Check ReplicationZone Version
            echo "checkReplicationVersion"
            ;;
        253)
            #check default log print level
            echo "CheckLogPrintLvl"
            ;;
        254)
            #洢״̬
            echo "checkObjsServiceStat"
            ;;
        260)
            #check ad connection
            echo "nas_checkADdomainControllerStatus"
            ;;
        261)
            #ʱ
            echo "checkDelayReimportDisk"
            ;;
        264)
            #check s3 s3fs service
            echo "checkS3FSService"
            ;;
        265)
            #check ufp database backup service
            echo "checkUPFDBBackup"
            ;;
        266)
            #check s3 key service
            echo "checkS3KeySerStatus"
            ;;
        268)
            #check s3 dns service
            echo "checkS3DNSservice"
            ;;
        269)
            #check bill service
            echo "checkBillService"
            ;;
        270)
            echo "CheckNodeState"
            ;;
        274)
            echo "CheckCertificate"
            ;;
        276)
            echo "accountCheck"
            ;;
        278)
            echo "check_gateway"
            ;;
        280)
            echo "checkdomainname"
            ;;
        282)
            #Ȳ״̬
            echo "checkHPatchstatus"
            ;;
        285)
            #ȡvfsͳ
            echo "checkVfsPerformance"
            ;;
        286)
            #ؼļȨ޼
            echo "checkKeyFileAuthority"
            ;;
        288)
            #ȺIDһУ
            echo "checkClusterId"
            ;;
        289)
            #DLMȺ״̬
            echo "checkDLMstatus"
            ;;
        290)
            #check ds report preslow info
            echo "CheckDsReportPreSlow"
            ;;
        291)
            #check nofs report preslow info
            echo "CheckNofsReportPreSlow"
            ;;
        292)
            #omuserͬ
            echo "checkOSUserInfoSync"
            ;;
        294)
            echo "checkDiskNokickStatus"
            ;;
        299)
            #ȺڵS3һԼ
            echo "checkS3Configuration"
            ;;
        302)
            #ϵͳ
            echo "CheckEnvironVarPath"
            ;;
        305)
            #ȺSMRһԼ
            echo "checkNodeSMRConfig"
            ;;
        306)
            #viid server״̬
            echo "checkViidServerStatus"
            ;;
        307)
            #viid ͷ״̬
            echo "checkViidIpcStatus"
            ;;
        309)
            #viid wal״̬һԼ
            echo "checkNodeWALSwitch"
            ;;
        310)
            #ǷNFSӾ̬ipĿͻ
            echo "nascheck_static_mount"
            ;;
        311)
            #Կݷͨ
            echo "CheckAKBackServer"
            ;;
        312)
            echo "CheckBirthTime"
            ;;
        313)
            echo "CheckDepXML"
            ;;
        314)
            #ڴƬ̶ȼ
            echo "CheckMemoryFragmentation"
            ;;
        316)
            #ЭIO״̬
            echo "CheckNasIOStatus"
            ;;
        318)
            #ڵü
            echo "CheckMasterSpecialConfig"
            ;;
        319)
            #ֵԿؼ
            echo "CheckValueaddedfeatures"
            ;;
        320)
            #ü
            echo "CheckALLNodeSpecialConf"
            ;;
        321)
            echo "DeepCheckHardDriveFirmware"
            ;;
        322)
            echo "CheckZoneMount"
            ;;
        323)
            echo "CheckBMCDataAcquisitionSwitch"
            ;;
        326)
            echo "CheckRouteConfigured"
            ;;
        327)
            echo "CheckCCDBDBConsistency"
            ;;
        328)
            echo "checkDiskModePage"
            ;;
        331)
            echo "CheckStripeCfg"
            ;;
        334)
            echo "CheckStaticCfg"
            ;;
        335)
            echo "CheckUpdFile"
            ;;
        338)
            echo "CheckNofsWriteMagnify"
            ;;
        339)
            echo "CheckConcomitantLogs"
            ;;
        340)
            echo "CheckV5NvdimmFirmware"
            ;;
        341)
            echo "CheckIfUpgradeInterfaceCardAndChipCard"
            ;;
        342)
            echo "CheckDiskNofsSpaceContinuity"
            ;;
        346)
            #ǰü
            echo "CheckALLNodeSpecialConfPreUpgrade"
            ;;
        347)
            #ü
            echo "CheckALLNodeSpecialConfExpand"
            ;;
        348)
            #ü
            echo "CheckALLNodeSpecialConfPatch"
            ;;
        350)
            echo "CheckStorageVersion"
            ;;
        351)
            echo "CheckHardWareVersion"
            ;;
        352)
            echo "CheckFrontAndBackPort"
            ;;
        353)
            echo "CheckFrontIPNumber"
            ;;
        354)
            echo "CheckBackNetworkIPaddr"
            ;;
        355)
            echo "CheckClusterRedundancyRatio"
            ;;
        356)
            echo "CheckClusterNodeNumber"
            ;;
        357)
            echo "CheckNodePoolDiskConsistency"
            ;;
        358)
            echo "CheckManagerNet"
            ;;
        359)
            echo "CheckCMiniFile"
            ;;
        360)
            echo "CheckCtnrGcConfigured"
            ;;
        361)
            echo "CheckLDBLoadMessage"
            ;;
        407)
            echo "CheckConfigurationCompatibility"
            ;;
        501)
            echo "certUpdate"
            ;;
        502)
            echo "ConfigurationCompatibilityRepair"
            ;;
        504)
            echo "HPatchStatusRepair"
            ;;
        505)
            echo "EnvironVarPathRepair"
            ;;
        *)
            echo ""
            ;;
    esac
}

NID_ROLE_FILE="/tmp/tmp_nid_role"
IP_ROLE_FILE="/tmp/tmp_ip_role"

#??3?2??DD???ip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        LOG "[${FUNCNAME}]IP:$remote_ip,item:${G_CHECK_IDLIST},Return:$iRet,TryTimes:$time,CMD:${cmd}"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#ȥڵĺIP
function GetIPAndRoleFromDB()
{
    local lineinfo=""
    local numCnt=1
    local lastNID=""
    local localNID=""
    local templocalNID=""
    local totalline=0
    local count=1
    local iRet=0
    local ItemIp=""
    local ItemIp2=""
    #0:not ok, 1:ok
    local ipIsok=0    

    > $IP_ROLE_FILE
    > $NID_ROLE_FILE
    #ݿȡнڵĺIP
    LOG "[$FUNCNAME]start get all nid from cm_conf.db"
    JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
    while [[ "${JavaId}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get all nid from db ,count=$count"
        JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
        count=$((count + 1))
        if [ $count -gt 5 ];then
            break
        fi
    done
    totalline=`echo "$JavaId" | wc -l`

    while [ $numCnt -le $totalline ]; do
        ipIsok=0
        lineinfo=`echo $JavaId | awk '{print $'$numCnt'}'`
        ItemIp=`echo $lineinfo | awk -F'|' '{print $2}'`
        localNID=`echo $lineinfo | awk -F'|' '{print $1}'`

        #жǷͬһڵ
        if [ "${localNID}" == "${lastNID}" ];then
            numCnt=$((numCnt+1))
            continue
        fi

        for time in ${RepeatTimes[*]};do
            iRet=$(ping -q -c 1 $ItemIp  | grep received | awk '{print $4}')
            if [ "${iRet}" == "1" ]; then
                ipIsok=1
                break
            else
                numCnt2=$((numCnt+1))
                templocalNID=$(echo $JavaId | awk '{print $'$numCnt2'}'| awk -F'|' '{print $1}')
                LOG "[$FUNCNAME][$LINENO]Node:${localNID},tmpNode:${templocalNID}, ${ItemIp} ping fail"
                if [ "${localNID}" == "${templocalNID}" ];then
                    ItemIp2=$(echo ${JavaId} | awk '{print $'$numCnt2'}'| awk -F'|' '{print $2}')
                    iRet=$(ping -q -c 2 ${ItemIp2}  | grep received | awk '{print $4}')
                    if [ $iRet -eq 2 ]; then
                        ipIsok=1
                        ItemIp=${ItemIp2}
                        break
                    else
                        sleep 10
                        LOG "[$FUNCNAME][$LINENO]Node:${localNID}, ItemIp2:${ItemIp2} ping fail"
                    fi
                else
                    sleep 10
                    LOG "[$FUNCNAME][$LINENO]Node:${localNID}, ItemIp:${ItemIp} ping fail"
                fi
            fi
        done

        lastNID=$localNID
        numCnt=$((numCnt+1))
        if [ ${ipIsok} -eq 0 ];then
        #ڶҲͨһѭһڵ
            LOG "[$FUNCNAME]Node:$localNID,ip:$ItemIp ping fail"
            continue
        fi

        Status_info=`remote_exec $ItemIp 30 "cat /opt/huawei/snas/etc/snas.ini | grep "status=""`
        iRet=$?
        if [ "$iRet" -eq "0" ] && [ "${Status_info}" != "" ];then
            Status_values=`echo $Status_info | awk -F= '{print $2}'`
            Status_value=`echo $Status_values | awk '{print $1}'`
            if [ "$Status_value" == "0" ];then
                echo -n "$ItemIp " >> $IP_ROLE_FILE
                echo -n "$localNID " >> $NID_ROLE_FILE
                LOG "[$FUNCNAME]add $ItemIp,$localNID"
            fi
        else
            LOG "[$FUNCNAME]node:$ItemIp,Status_info:$Status_info,iRet:$iRet."
        fi
    done
}
