#!/bin/bash

# *************************************************************************** #
# File Name: inspect_hardware.sh
# Description: ѲĿеӲ.
# Input:
# Output:
# Author:
# Created:
# Function List
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #

dos2unix $G_SCRIPT_PATH/inspect_lib.sh > /dev/null 2>&1
dos2unix $G_SCRIPT_PATH/inspect_map.sh > /dev/null 2>&1

. /opt/node_type_recognize.sh
. $G_SCRIPT_PATH/inspect_lib.sh
. $G_SCRIPT_PATH/inspect_map.sh

G_TMP_FILE="$G_SCRIPT_PATH/tmpfile$$"
G_REMOTE_TMP_FILE="/tmp/tmpfile$$"

VALID_IP_FILE="/tmp/tmp_valid_ip$$"

NID_ROLE_FILE="/tmp/tmp_nid_role"

IP_ROLE_FILE="/tmp/tmp_ip_role"

G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"

LOG_FILE="/var/log/inspect.log"

LOG_FILE_BAK="/var/log/inspect_1.log"

SWITCH_TOPO_FILE="/opt/huawei/snas/etc/switchTopo.ini"
REPLACE_HWDIR_SEDSTR="s/\/opt\/huawei\//\/opt\/product\//g"
RepeatTimes=(1 2 3)

FIFO_OPERATE_ID=758
FIFO_THREAD_NUM_MAX=60

G_SEPARATOR="-----------------------------------------------------------------------------"

function LOG
{
    echo [`date`][$$]$@ >> $LOG_FILE
}

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

#ʹfifoܵ, ʵֶ̲, Ҫ׼ VALID_IP_FILE
function fifo_start
{
    trap "exec $FIFO_OPERATE_ID>&-;exec $FIFO_OPERATE_ID<&-;exit 0" 2

    mkfifo remoteFifo
    eval "exec $FIFO_OPERATE_ID<>remoteFifo"
    rm -rf remoteFifo

    local num=0
    for Item in $VALID_IP_FILE; do
        num=$((num+1))
    done

    local threadNum=$FIFO_THREAD_NUM_MAX
    if [ $threadNum -gt $num ]; then
        threadNum=$num
    fi

    for ((i=0;i<$threadNum;i++))
    do
        eval "echo >& $FIFO_OPERATE_ID"
    done
}

function fifo_finish
{
    eval "exec $FIFO_OPERATE_ID>&-"
    eval "exec $FIFO_OPERATE_ID<&-"
}

function check_pass()
{
    local list=(["2"]=0 ["1"]=1 ["4"]=2 ["0"]=3 ["3"]=4) #δ(2)>ͨ(1)>Ż(4)>ͨ(0)>漰(3)
    local isPass=$1   #Ⱥ
    local tmpIsPass=$2 #ǰ

    if [ ${list[$tmpIsPass]} -lt ${list[$isPass]} ];then
        isPass=$tmpIsPass
    fi
    echo $isPass
}


#ȡڵһõĺIP
function get_backnet_ip
{
    local snas_ini_file="/opt/huawei/snas/etc/snas.ini"
    local IpIndex=1
    local subnetwork_id
    local BackendIp
    local IpNum
    IpNum=`cat ${snas_ini_file} | grep "ipaddr_" | wc -l`

    while [ "$IpIndex" -le "$IpNum" ]; do
        subnetwork_id=`grep "subnetwork_id_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
        if [ -z "${subnetwork_id}" ]; then
            break
        fi

        if [ ${subnetwork_id} -eq 1 ]; then
            BackendIp=`grep "ipaddr_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
            ping "${BackendIp}" -f -c 2 -w 2 >/dev/null 2>&1
            if [ $? -ne 0 ]; then
                IpIndex=$((IpIndex + 1))
                continue
            else
                echo ${BackendIp}
                break
            fi
        fi

        IpIndex=$((IpIndex + 1))
    done
}

#ȡָڵһIP
function get_node_backnet_ip
{
    local nid=$1
    local temp=1
    local iRet=0
    local IpNum=0
    local BackendIp=""
    IpNum=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select COUNT(*) from (select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID);"`
    if [ "$IpNum" -eq 0 ]; then
        LOG "[$FUNCNAME]There is no back subnet IP of $nid in db"
        return 1
    fi

    while [ "$temp" -le "$IpNum" ];
    do
        BackendIp=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID limit $((temp - 1)), $temp;"`
        if [ $BackendIp = "" ]; then
            LOG "[$FUNCNAME] Get back ip of $nid failed"
            temp=$((temp + 1))
            continue
        else
            #try ping
            ping "${BackendIp}" -f -c 2 -w 2 >/dev/null 2>&1
            if [ $? -ne 0 ]; then
                temp=$((temp + 1))
                continue
            else
                break
            fi
        fi
    done
    if [ ${temp} -gt ${IpNum} ]; then
        LOG "[${FUNCNAME[@]}] back ip of $nid ping fail"
    fi
    echo ${BackendIp}
}

#ԶִͬУip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        LOG "[${FUNCNAME}]IP:$remote_ip,item:${G_CHECK_IDLIST},Return:$iRet,TryTimes:$time,CMD:${cmd}"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#Զ첽ִУip/pid/timeout/cmd
function remote_exec_async
{
    local remote_ip=$1
    local le_pid="$$$2"
    local time_out=$3
    local cmd=$4
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py async $remote_ip $le_pid $time_out true "$cmd"
        local iRet=$?
        LOG "[${FUNCNAME}]IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},Return:$iRet,TryTimes:$time,CMD:${cmd}"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#ӡڵ汾
function print_NodeVersion
{
    local FILE=$1
    local IP=$2
    local exp_u=""
    local clusterversion=0
    netcard=`cat $FILE|grep netcard|awk -F: '{print $2}'`
    nvdimm=`cat $FILE|grep nvdimm|awk -F: '{print $2}'`
    ibcard=`cat $FILE|grep ibcard|awk -F: '{print $2}'`
    sascard=`cat $FILE|grep sascard|awk -F: '{print $2}'`
    bmc=`cat $FILE|grep BMC|awk -F: '{print $2}'`
    bios=`cat $FILE|grep BIOS|awk -F: '{print $2}'`
    mb_cpld=`cat $FILE|grep MB_CPLD|awk -F: '{print $2}'`
    bootrom=`cat $FILE|grep BOOTROM|awk -F: '{print $2}'`
    exp=`cat $FILE|grep EXP|grep "CPLD:"|awk -F: '{print $2}'`
    exp_u=`cat $FILE|grep EXP|grep 4U|awk -F: '{print $2}'`
    pangeaver=`cat $FILE|grep PANGEA_Version|awk -F: '{print $2}'`
    productver=`cat $FILE|grep ExternalVersion|awk -F: '{print $2}'`
    compver=`cat $FILE|grep ComponentVersion|awk -F: '{print $2}'`
    sphver=`cat $FILE|grep SphVersion|awk -F: '{print $2}'`
    funcversion=`cat $FILE|grep FuncVersion|awk -F: '{print $2}'`
    clusterversion=`cat $FILE|grep ClusterVersion|awk -F: '{print $2}'`
    if [ $ProductType -eq 80 ] || [ $ProductType -eq 91 ];then
        #UDSSFSʹõͨ÷ BOOTROM EXP_CPLD PANGEA_Version汾
        Result="Node:$IP||NodeVersion:$funcversion ||ClusterVersion:$clusterversion || Netcard:$netcard|| Nvdimm:$nvdimm||Ibcard:$ibcard|| Sascard:$sascard|| BMC:$bmc|| BIOS:$bios|| MB_CPLD:$mb_cpld||ProductVersion:$productver||SphVersion:$sphver|| EXP_CPLD(4U):$exp_u||ComponentVersion:$compver"
    else
        Result="Node:$IP||NodeVersion:$funcversion ||ClusterVersion:$clusterversion || Netcard:$netcard|| Nvdimm:$nvdimm||Ibcard:$ibcard|| Sascard:$sascard|| BMC:$bmc|| BIOS:$bios|| MB_CPLD:$mb_cpld|| BOOTROM:$bootrom|| EXP_CPLD:$exp||ProductVersion:$productver||EXP_CPLD(4U):$exp_u||SphVersion:$sphver||PANGEA_Version:$pangeaver||ComponentVersion:$compver"
    fi
    WRITE_XML_COMMON 0 "$Result"
    LOG "$Result"
    if [ "${funcversion}" != "${clusterversion}" ];then
        WRITE_XML_ERROR 0 "Node:$IP||INFO:NodeVersion($funcversion) is not equal ClusterVersion($clusterversion)."
        LOG "[$FUNCNAME][$LINENO]IP:$IP NodeVersion:$funcversion is not equal ClusterVersion:$clusterversion."
        return 1
    fi
    return 0
}
#ԶִǷ
function remote_exec_checkfini
{
    local remote_ip=$1
    local le_pid="$$$2"
    local exe_cmd=$3
    for time in ${RepeatTimes[*]}; do
        local proresult=`/opt/huawei/deploy/script/localexec.py progress $remote_ip $le_pid`
        local iRet=$?
        if [ $iRet -eq 101 ]; then
            LOG "[${FUNCNAME}]IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:{$le_pid},Return:$iRet,TryTimes:$time"
            sleep 10
        else
            break
        fi
    done

    local process=`echo $proresult | awk '{print $1}'`
    local errno=`echo $proresult | awk '{print $4}'`

    if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
        return 0    #ѯִгɹԶû
    elif [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid},exec(get progress) failed.iRet($iRet)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to query. if command(${exe_cmd}) was finished or not. Error(${iRet})."
        return 1    #ѯִʧ
    elif [ $iRet -eq 0 ] && [ "$process" = "100" ] && [ "$errno" = "0" ] ;then
        LOG "[$FUNCNAME] IP:$remote_ip,le_pid:${le_pid}, exec(get progress) success.iRet($iRet),errno($errno),process($process)"
        return 2    #ɹɣ˴Ҫ0Ϊɹ
    elif [ "$errno" != "0" ] && [ "$errno" != "" ];then
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid}, exec(get progress) failed.iRet($iRet) errno($errno)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to query. if command(${exe_cmd}) was finished or not. Errno(${errno})."
        return 3    #Զִʧ
    elif [ "$process" = "" ] && [ "$errno" = "" ];then
        LOG "[$FUNCNAME]IP:$remote_ip,le_pid:${le_pid}, exec(get progress) failed.process(null), ip not accessed"
        return 5    #ʱ
    elif [ "$process" = "" ] || [ "$errno" = "" ];then
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid}, exec(get progress) failed.process(null)"
        return 0    #ݴ
    else
        LOG "[$FUNCNAME]IP:$remote_ip, le_pid:${le_pid}, exec(get progress) failed. Undefined error info"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to query. if command(${exe_cmd}) was finished or not. Progress(${process})."
        return 4    #δ
    fi
}

#һѽڵ첽ִУҪ׼ REMOTE_IP_S
function remote_exec_async_batch
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}

    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$3"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command ($4). Error(${iRet})."
            ret=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}

#Զ̵MML
function remote_exec_async_batch_mml
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}
    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$G_MML_FILE_PATH/$3 $Item > $G_REMOTE_TMP_FILE$4 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command ($3)."
            ret=1
        else
            cat $G_REMOTE_TMP_FILE$FUNCNAME | sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}

function remote_download_sync
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
        iRet=$?
        LOG "[$FUNCNAME] download $remote_file from $remote_ip to $local_file item:${G_CHECK_IDLIST} Return:($iRet) TryTimes:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $local_file 2>&1
            break
        fi
    done

    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get execute result."
    fi

    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        LOG "[$FUNCNAME] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi
    return $iRet
}

function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    eval "read -u $FIFO_OPERATE_ID"
    {
        for time in ${RepeatTimes[*]}; do
            /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
            iRet=$?
            LOG "[$FUNCNAME] download $remote_file from $remote_ip to $local_file item:${G_CHECK_IDLIST} Return:$iRet TryTimes:$time"
            if [ $iRet -eq 101 ]; then
                sleep 10
            else
                sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $local_file 2>&1
                break
            fi
        done

        eval "echo >& $FIFO_OPERATE_ID"
    }

    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        LOG "[$FUNCNAME] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi

    return $iRet
}

#Զ˷أ[ERR]ʶ
handle_remote_result()
{
    local line=$1
    echo "$line" |grep "\[ERR\]" > /dev/null
    if [ $? -eq 0 ]; then
        echo "$line" | awk -F] '{print $2}'
        return 1
    fi

    echo "$line"
    return 0
}

##############################################################################

#102. ڴ
checkMemUsage()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local Result=""
    local errResult=""
    local tmpline=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    for Item in $REMOTE_IP_S; do

        set_ifs
        free_result=`remote_exec $Item 30 "free"`
        iRet=$?
        if [ $iRet -ne 0 ]; then
            errResult="Node:$Item||INFO:Failed to execute(free) command.iRet($iRet)."
            LOG "[$FUNCNAME] $Item Failed to execute(free) command.iRet($iRet)"
            isPass=1
            WRITE_XML_ERROR 0 "${errResult}"
            restore_ifs
            continue
        fi

        MemTotal=`echo "$free_result" |grep "Mem:"|awk '{print $2}'`
        MemUsed=`echo "$free_result" |grep "Mem:"|awk '{print $3}'`
        Percentage=`expr 100 \* $MemUsed`
        Percentage=`expr $Percentage / $MemTotal`

        #ռڴ5̵Ϣ
        info=`remote_exec $Item 30 "ps auxww|head -1"`
        top_5=`remote_exec $Item 30 "ps auxww | sort -k 4nr | head -5|sed 's/</(lt)/g'"`

        Result=""

        for line in $top_5; do
            tmpline=$(echo ${line} | sed "${REPLACE_HWDIR_SEDSTR}")
            if [ "" != "${Result}" ];then
                Result="$Result||Memory Usage:$tmpline"
            else
                Result="Memory Usage:$tmpline"
            fi
        done
        restore_ifs

        Result="Memory Usage:${G_SEPARATOR}||Memory Usage:$Item||Memory Usage:TotalMem:$MemTotal
                ||Memory Usage:UsedMem:$MemUsed||Memory Usage:Percentage(%):$Percentage
                ||Memory Usage:--------------detail--------------||Memory Usage:$info||${Result}"
        WRITE_XML_COMMON 0 "<![CDATA[$Result]]>"

        if [ $Percentage -gt 97 ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Memory Usage $Percentage is greater than 97."
        fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#104. Դ״̬
checkPowerStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local iRet=0

    #ʽPower_ID: %s || parent_ID: %s || Health_Status: %d || Running_Status: %d || Power_type: %d || Vendor: %s || Model: %s || Version: %s || ProduceDate: %s || SN: %s
    #ʽPower_Count:2

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:$(hostname)||INFO:Can't get backend IP."
            isPass=1
            break
        fi

        #״̬
        IsStandardNode
        if [ $? -eq 0 ];then
            WRITE_XML_COMMON 0 "Node:${back_ip}||INFO:This is VM. Do not involve to inspect."
            isPass=3
            break
        fi

        #ִmml cm power
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm power"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]$Info"
            errResult="Node:$back_ip||INFO:Failed to execute command(MmlBatch 4016 'cm power'). Error(${iRet})."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Power_ID"|sed 's/^ *//g'|sed "/^$/d"`

        if [ "$javaID" = "" ];then
            errResult="Node:$back_ip||INFO:Get Power information from command(MmlBatch 4016 'cm power') failed."
            isPass=1
            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi

        set_ifs
        for line in $javaID; do
            if [ "$line" = "" ];then
                continue
            fi

            ID=`echo $line |awk '{print $2}'`
            parentID=`echo $line |awk '{print $5}'`

            cat $NID_ROLE_FILE | grep -wq $parentID >>/dev/null
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]iRet=$iRet,parentID=$parentID is not OK"
                continue
            fi
            parentIP=`get_node_backnet_ip $parentID`

            healthStatus=`echo $line |awk '{print $8}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`

            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`

            powerType=`echo $line |awk '{print $14}'`
            powerType=`MapPowerType $powerType`

            if [ "$runningStatus" = "NOT_EXIST" ];then
                powerType="--"
            fi

            vendor=`echo $line | awk -F: '{print $7}'|sed 's/|| Model//'`
            echo "$vendor"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                vendor="--"
            fi
            model=`echo $line |awk -F: '{print $8}'|sed 's/|| Version//'`
            echo "$model"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                model="--"
            fi
            version=`echo $line |awk -F: '{print $9}'|sed 's/|| ProduceDate//'`
            echo "$version"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                version="--"
            fi
            produceDate=`echo $line |awk -F\| '{print $17}'|awk '{print $2,$3,$4,$5,$6,$7 }'`
            echo "$produceDate"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                produceDate="--"
            fi
            SN=`echo $line |awk -F\| '{print $19}' |awk '{print $2}'`
            echo "$SN"|grep -E "[A-Za-z0-9]" > /dev/null
            if [ $? -ne 0 ];then
                SN="--"
            fi

            Result="ID:$ID||parentID:$parentID||nodeIP:$parentIP||healthStatus:$healthStatus||runningStatus:$runningStatus||powerType:$powerType||vendor:$vendor||model:$model||version:$version||produceDate:$produceDate||SN:$SN"
            WRITE_XML_COMMON 0 "$Result"
            if [ "$runningStatus" != "ONLINE" -a "$runningStatus" != "NORMAL" ] || [ "$healthStatus" != "NORMAL" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$parentIP||INFO:$ID Power runningStatus(${runningStatus}) or healthStatus(${healthStatus}) is not NORMAL!"
            fi
        done

        #жϱ׼нڵ붼˫Դ
        #жÿڵĵԴǷ2
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Power_Count"|sed 's/^ *//g'|sed "/^$/d"`
        for line in $javaID; do
            if [ $line = "" ];then
                continue
            fi

            count=`echo $line |awk -F: '{print $2}'`
            if [ "$count" != "2" ];then
                isPass=1
                errResult="Node:--||INFO:Power number count is not 2 ($line)."
            fi
        done

        restore_ifs
        break
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#105. ״̬
checkFanStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""
    local FirstString=""
    local line=""
    local new_line=""
    local iRet=0
    local allnid=""

    #ʽFan_ID: 15496.1 || Fan_Name: FAN1 || parent_ID: 15496 || Health_Status: 1 || Running_Status: 1 || Running_Level: 1 || Elabel: 02G098Z0C2000101 || Speed: 5029
    #ʽFan_ID: 15496.2 || Fan_Name: FAN2 || parent_ID: 15496 || Health_Status: 1 || Running_Status: 1 || Running_Level: 1 || Elabel: 02G098Z0C2000101 || Speed: 5076
    #ʽFan_Count:2
    allnid=$(cat $NID_ROLE_FILE)
    LOG "[$FUNCNAME][$LINENO]allnid=$allnid"
    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:$(hostname)||INFO:Can't get backend IP."
            isPass=1
            break
        fi

        #״̬
        IsStandardNode
        if [ $? -eq 0 ];then
            WRITE_XML_COMMON 0 "This is VM. Do not involve to inspect."
            isPass=3
            break
        fi
        #ִmmlcm fan
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm fan"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME]$Info"
            errResult="Node:$back_ip||INFO:Failed to execute command(MmlBatch 4016 'cm fan'). Error(${iRet})."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Fan_ID"|sed 's/^ *//g'|sed "/^$/d"`

        if [ "$javaID" = "" ];then
            errResult="Node:$back_ip||INFO:Get fan information from command(MmlBatch 4016 'cm fan') failed."
            isPass=1

            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi

        set_ifs
        for line in $javaID; do
            if [ $line = "" ];then
                continue
            fi

            #жϵһַǲǡFan_IDstart/time:08:13:35.277086 | clock:58435.277136Fan_ID: 14087.1 || Fan_Name:
            FirstString=`echo $line | awk '{print $1}'`
            if [ "$FirstString" != "Fan_ID:" ]; then
               new_line=`echo $line | awk -F"Fan_ID" '{print $2}'`
               LOG "[$FUNCNAME]:old_line:($line), new_line:($new_line)"
               line=$new_line
            fi
            ID=`echo $line |awk '{print $2}'`


            NAME=$(echo "${line}" | awk -F'\\|\\|' '{print $2}' | awk -F':' '{print $2}' | tr -d ' ')
            parentID=$(echo "${line}" | awk -F'\\|\\|' '{print $3}' | awk -F':' '{print $2}' | tr -d ' ')
            cat $NID_ROLE_FILE | grep -wq $parentID >>/dev/null
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]iRet=$iRet,parentID=$parentID is not OK"
                continue
            fi
            #parentIDIP
            parentIP=`get_node_backnet_ip $parentID`

            healthStatus=$(echo "${line}" | awk -F'\\|\\|' '{print $4}' | awk -F':' '{print $2}' | tr -d ' ')
            runningStatus=$(echo "${line}" | awk -F'\\|\\|' '{print $5}' | awk -F':' '{print $2}' | tr -d ' ')

            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`

            level=$(echo "${line}" | awk -F'\\|\\|' '{print $6}' | awk -F':' '{print $2}' | tr -d ' ')
            elabel=$(echo "${line}" | awk -F'\\|\\|' '{print $7}' | awk -F':' '{print $2}' | tr -d ' ')
            speed=$(echo "${line}" | awk -F'\\|\\|' '{print $8}' | awk -F':' '{print $2}' | tr -d ' ')
            Result="ID:$ID||name:$NAME||parentID:$parentID||nodeIP:$parentIP||healthStatus:$healthStatus||runningStatus:$runningStatus||level:$level||elabel:$elabel||speed(RPM):$speed"
            WRITE_XML_COMMON 0 "$Result"
            if [ "$runningStatus" != "NORMAL" ] || [ "$healthStatus" != "NORMAL" ];then
                WRITE_XML_ERROR 0 "Node:$parentIP||INFO:$ID Fan runningStatus(${runningStatus}) or healthStatus(${healthStatus}) is not NORMAL!"
                LOG "[$FUNCNAME] ${parentIP}-$ID runningStatus(${runningStatus}) or healthStatus(${healthStatus}) is not NORMAL!"
                isPass=1
            fi

        done
        restore_ifs
        #жÿڵķǷ2511
        for nid in $allnid ; do
            if [ $nid = "" ];then
                continue
            fi
            count=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Fan_ID"|sed 's/^ *//g'|sed "/^$/d" | grep -w "parent_ID: $nid"|wc -l)

            if [ "$count" != "2" ] && [ "$count" != "5" ] && [ "$count" != "11" ] && [ "$count" != "8" ] && [ "$count" != "4" ]; then
                errResult="Node:$nid(NID)||INFO: FAN number($count) is not 2, 4, 5, 8 or 11!||${errResult}"
                LOG "[$FUNCNAME] $nid Error: FAN number($count) is not 2, 4, 5, 8 or 11!"
                isPass=1
            fi
        done

        break
    done

    #жϱ׼ȫȣ2511λ
    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#107. CPU״̬
checkCPUStatus()
{
    #ipmitool sdr|grep CPU
    #ʽCPU0_Core_temp   | -55 degrees C     | ok
    #ʽCPU1_Core_temp   | -50 degrees C     | ok
    #ʽCPU0_Status      | 0x80              | ok
    #ʽCPU1_Status      | 0x80              | ok
    #ʽVTT_CPU0         | 1.05 Volts        | ok
    #ʽVTT_CPU1         | 1.06 Volts        | ok
    #ʽVDDQ_DDR_CPU0    | 1.51 Volts        | ok
    #ʽVDDQ_DDR_CPU1    | 1.51 Volts        | ok
    #ʽVCCP_CPU0        | 0.85 Volts        | ok
    #ʽVCCP_CPU1        | 0.94 Volts        | ok

    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local errResult=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    remote_exec_async_batch $TASK_ID 300 "$G_MML_FILE_PATH/ShowCpuState > $G_REMOTE_TMP_FILE$FUNCNAME" "ShowCpuState"
    if [ 0 -ne $? ];then
        isPass=1
    fi
    #cpuҪ60S˴ȴֹ첽
    sleep 60

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "ShowCpuState"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:Failed to download file from command(ShowCpuState)."
                continue
            fi
        done

        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            set_ifs
            while read line; do
                info=`handle_remote_result "$line"`
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node: $Item||INFO: $info||${errResult}"
                    LOG "[$FUNCNAME] Error: $info"
                else
                    WRITE_XML_COMMON 0 "Node:$Item||$info"
                fi
            done < $G_TMP_FILE$Item
            restore_ifs
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#108. ڵ״̬
checkNodeStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local isPass=0
    local iRet=0
    #ʽNode_ID: 15425 || Node_Name: node65 || Health_Status: 1 || Running_Status: 2 || Frame: a1 || Slot: 1 || SN: 210235G78PZ0C8000011 || Device_Type: 33 || Manufacture: Huawei Technologies Co., Ltd. || Firmware_Version: V100R001C00 || Bussiness_IP: ["xx.xx.xx.xx","xx.xx.xx.xx"] || Manage_IP: xx.xx.xx.xx || Function_Type: 0 || Time: 0 || Time_zone:  || DevMgrIP: xx.xx.xx.xx || Tier_ID: 1

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:$(hostname)||INFO:Can't get backend IP."
            isPass=1
            break
        fi

        #ִmmlcm node
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm node"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ ${iRet} -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            errResult="Node:$back_ip||INFO:Failed to execute command(MmlBatch 4016 'cm node').Error(${iRet})."
            LOG "[$FUNCNAME] $back_ip:Can not get information.exec(cm node) failed!Info($Info)"

            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "Node_ID"|sed 's/^ *//g'|sed "/^$/d"`

        if [ "$javaID" = "" ];then
            errResult="Node:$back_ip||INFO:Get node information from command(MmlBatch 4016 'cm node') failed.||${errResult}"
            LOG "[$FUNCNAME] $back_ip get javaID(javaID) failed!"
            isPass=1

            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi

        set_ifs
        for line in $javaID; do
            if [ $line = "" ];then
                continue
            fi

            ID=`echo $line |awk '{print $2}'`
            if [[ ! "${ID}" =~ ^[0-9]+$ ]]; then
                continue
            fi
            NAME=`echo $line |awk '{print $5}'`
            healthStatus=`echo $line |awk '{print $8}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo $line |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`
            parentIP=$(get_node_backnet_ip $ID)
            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`

            frame=`echo $line |awk '{print $14}'`
            slot=`echo $line |awk '{print $17}'`
            SN=`echo $line |awk '{print $20}'`
            typeid=`echo $line |awk '{print $23}'`
            nodeTypeid=`echo $line |grep -Po '(?<=Function_Type: )[0-9]*' |tr -d ' '`
            type=$(MapNodeType  $nodeTypeid)
            Result="ID:$ID||name:$NAME||parentIP:$parentIP||healthStatus:$healthStatus||runningStatus:$runningStatus||Frame:$frame||Slot:$slot||SN:$SN||Type:$type"
            LOG "[$FUNCNAME] $Result||typeid:$typeid"

            WRITE_XML_COMMON 0 "$Result"
            if [ "$runningStatus" != "ONLINE" ] || [ "$healthStatus" != "NORMAL" ];then
                isPass=1
                errResult="Node:$ID||INFO:HealthStatus($healthStatus) is not NORMAL or runningStatus($runningStatus) is not ONLINE.||${errResult}"
                LOG "[$FUNCNAME] $ID healthStatus($healthStatus) is not NORMAL or runningStatus($runningStatus) is not ONLINE."
            fi
        done

        restore_ifs
        break
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#112. ģ״̬⹦쳣㲻ͨʵֲμ澯
checkFiber_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local errResult=""
    local isPass=0
    local fiberInfo=""
    local iRet=0

    #ʽFiber_ID: %s || parent_ID: %s || location: %s || Health_Status: %d || Running_Status: %d || ModeType: %d || Identifier: %d  || WaveLen: %d || RX_Power: [%d %d %d %d] || TX_Power: [%d %d %d %d] || Speed(MB/s): %d || Temperature: %d || Voltage: %d || Vendor: %s || Model: %s || SN: %s || Node_Type: %s || NetCard_Manufacturer: %s
    #ʽFiber_Count: %d || Node_ID: %s || Node_Type: %s || NetCard_Manufacturer: %s

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="Node:$(hostname)||INFO:Can't get backend IP."
            isPass=1
            break
        fi

        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm fiberinfo show" >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | sed -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g'`
            errResult="Node:$back_ip||INFO:Failed to execute command(MmlBatch 4016 'cm fiberinfo show').Error(${iRet})!||${errResult}"
            LOG "[$FUNCNAME]$back_ip:Failed to execute command(MmlBatch 4016 'cm fiberinfo show').Error(${iRet})!Info($Info)."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME >/dev/null 2>&1
        sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' ${G_REMOTE_TMP_FILE}$FUNCNAME >/dev/null 2>&1
        #Fiber_Count: 0 || Node_ID: 124 || Node_Type: C36 || NetCard_Manufacturer: Intel
        fiberInfo=`grep "Fiber_Count" $G_REMOTE_TMP_FILE$FUNCNAME |sed 's/^ *//g'|sed "/^$/d"`

        if [ "$fiberInfo" = "" ];then
            errResult="Node:$back_ip||INFO:Get fiber count from command(MmlBatch 4016 'cm fiberinfo show') failed.||${errResult}"
            LOG "[$FUNCNAME]$back_ip:get Fiber_Count failed!"
            isPass=1
            #
            cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            break
        fi

        set_ifs
        for line in $fiberInfo; do
            if [ "$line" = "" ];then
                continue
            fi
            count=`echo "$line" |awk '{print $2}'`
            nodeID=`echo "$line" |awk '{print $5}'`
            cat $NID_ROLE_FILE | grep -wq $nodeID >>/dev/null
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]iRet=$iRet,nodeID=$nodeID is not OK"
                continue
            fi
            nodeType=`echo "$line" |awk '{print $8}'`
            netCardManufacturer=`echo "$line" |awk '{print $11}'`
            nodeIP=`get_node_backnet_ip $nodeID`
            if [ "$count" = "0" ];then
                Result="Node:$nodeIP(Node type: $nodeType node, network card: $netCardManufacturer)||ID:No optical module ||parentID:--||location:--||healthStatus:--||runningStatus:--||modeType:--||waveLen:--||RX_Power:--||TX_Power:--||Speed(Gb/s):--||Temperature:--||Voltage:--||Vendor:--||Model:--||SN:--"
                WRITE_XML_COMMON 0 "$Result"
                LOG "[$FUNCNAME]-:no Fiber exists!count($count)."
            fi
        done

        fiberInfo=`grep "Fiber_ID" $G_REMOTE_TMP_FILE$FUNCNAME |sed 's/^ *//g'|sed "/^$/d"`

        for line in $fiberInfo; do
            if [ "$line" = "" ];then
                continue
            fi

            ID=`echo "$line" |awk '{print $2}'`
            parentID=`echo "$line" |awk '{print $5}'`
            cat $NID_ROLE_FILE | grep -wq $parentID >>/dev/null
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][$LINENO]iRet=$iRet,parentIP=$parentIP is not OK"
                continue
            fi
            #parentIDIP
            parentIP=`get_node_backnet_ip $parentID`
            location=`echo "$line" |awk '{print $8}'`
            healthStatus=`echo "$line" |awk '{print $11}'|sed 's/^ *//g'|sed "/^$/d"`
            runningStatus=`echo "$line" |awk '{print $14}'|sed 's/^ *//g'|sed "/^$/d"`

            healthStatus=`MapHealthStatus $healthStatus`
            runningStatus=`MapRunningStatus $runningStatus`

            modeType=`echo "$line" |awk '{print $17}'`
            Identifier=`echo "$line" |awk '{print $20}'`  #ģЭ1 SFP, 3 QSFP+

            waveLen=`echo "$line" |awk '{print $23}'`
            Vendor=`echo "$line" |awk '{print $51}'`
            Speed=`echo "$line" |awk '{print $42}'`

            Voltage=`echo "$line" |awk '{print $48}'`
            Temperature=`echo "$line" |awk '{print $45}'`
            #շ⹦Ϊ4ֵͨ
            RX_Power1=`echo "$line" |awk '{print $27}'`
            RX_Power2=`echo "$line" |awk '{print $28}'`
            RX_Power3=`echo "$line" |awk '{print $29}'`
            RX_Power4=`echo "$line" |awk '{print $30}'`

            TX_Power1=`echo "$line" |awk '{print $35}'`
            TX_Power2=`echo "$line" |awk '{print $36}'`
            TX_Power3=`echo "$line" |awk '{print $37}'`
            TX_Power4=`echo "$line" |awk '{print $38}'`

            if [ $Voltage = "0" -a $Temperature = "0"];then
                Voltage="--"
                Temperature="--"
            fi

            Model=`echo "$line" | awk -F'Model:' '{print $2}'|awk '{print $1}'`
            SN=`echo "$line" | awk -F'SN:' '{print $2}'|awk '{print $1}'`
            nodeType=`echo "$line" | awk -F'Node_Type:' '{print $2}'|awk '{print $1}'`
            netCardManufacturer=`echo "$line" | awk -F'NetCard_Manufacturer:' '{print $2}'|awk '{print $1}'`

            Result="Node:$parentIP(Node type: $nodeType node, network card: $netCardManufacturer)||ID:$ID||parentID:$parentID||location:$location||healthStatus:$healthStatus||runningStatus:$runningStatus||modeType:$modeType||waveLen:$waveLen||RX_Power:[$RX_Power1 $RX_Power2 $RX_Power3 $RX_Power4]||TX_Power:[$TX_Power1 $TX_Power2 $TX_Power3 $TX_Power4]||Speed(Gb/s):$Speed||Temperature:$Temperature||Voltage:$Voltage||Vendor:$Vendor||Model:$Model||SN:$SN"

            WRITE_XML_COMMON 0 "$Result"
            if [ "$runningStatus" != "NORMAL" ] ||[ "$healthStatus" != "NORMAL" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$parentIP||INFO:ID($ID) RunningStatus($runningStatus) or HealthStatus($healthStatus) is not NORMAL."
            fi
        done

        restore_ifs
        break
    done

    if [ "" != "${errResult}" ];then
        WRITE_XML_ERROR 0 "$errResult"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#115nvdimm״̬
checkNvdimmStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    >${VALID_IP_FILE}
    for Item in ${REMOTE_IP_S}; do
        remote_exec ${Item} 30 "cat /opt/huawei/deploy/etc/deploy.ini | grep devicename | grep \"9000 C72 Node\" >> /dev/null 2>&1"
        if [ $? -ne 0 ];then
            echo -n "$Item " >> ${VALID_IP_FILE}
            continue
        fi
	#ܿڵ
        WRITE_XML_COMMON 0 "Node:$Item(C72 node)||NVDIMM NAME:--||NVDIMM_STATUS:--||SAVE MODE:--||CAP TEMPERATUER(centigrade):--||CAP PRESENCE:--||FLASH_STATUS:--||CAP FULL CHARGE:--||CAP LIFE END:--"
    done

    REMOTE_IP_S=$(cat "${VALID_IP_FILE}")

    #ļжǷܿϢ
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/nvdimm_status_record > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1" "nvdimm_status_record"
    isPass=$?

    ValidIP=$(cat "${VALID_IP_FILE}")
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "nvdimm_status_record"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:Failed to download file from command(nvdimm_status_record)."
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        #UVP
        IsStandardNode
        if [ $? -eq 0 ];then
            WRITE_XML_COMMON 0 "Node:$Item(not involve)||NVDIMM NAME:--||NVDIMM_STATUS:--||SAVE MODE:--||CAP TEMPERATUER(centigrade):--||CAP PRESENCE:--||FLASH_STATUS:--||CAP FULL CHARGE:--||CAP LIFE END:--"
            isPass=3
            break
        fi
        fifoContext=`cat $G_TMP_FILE$Item`
        if [ "$fifoContext" = "" ];then
            continue
        fi

        NoNvdimmInfo=`cat $G_TMP_FILE$Item | grep "NO NVDIMM FOUND"`
        if [ "$NoNvdimmInfo" != "" ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||INFO:There is no Nvdimm."
            continue
        fi

        ErrInfo=`cat $G_TMP_FILE$Item | grep "some wrong during Recording NVDIMM Status"`
        if [ "$ErrInfo" != "" ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Get Nvdimm Info from output(${fun}) failed."

            #
            cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            continue
        fi

        #ȡnvdimmĸ
        set_ifs
        Nvdimm_NUM=`cat $G_TMP_FILE$Item | grep "There are" | grep "found under system" |  awk '{print $3}'`
        if [ "$Nvdimm_NUM" -le 0 ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||INFO:the NUM of Nvdimm is $Nvdimm_NUM."
            restore_ifs
            #
            cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            continue
        fi

        #ѭʾnvdimmϢ
        index=1
        while [[ "$index" -le "$Nvdimm_NUM" ]]
        do
            echo "$index"

            #ȡNAME
            NVDIMM_NAME=`cat $G_TMP_FILE$Item | grep "NVDIMM NAME" | awk NR==$index | awk '{print $3}'`

            #ȡģʽ
            SAVE_MODE=`cat $G_TMP_FILE$Item | grep "SAVE MODE" | awk NR==$index | awk '{print $3}'`

            #ȡ¶
            TEMPERATUER=`cat $G_TMP_FILE$Item | grep "CAP TEMPERATUER" | awk NR==$index | awk '{print $3}'`

            #ȡǷλ
            PRESENCE=`cat $G_TMP_FILE$Item | grep "CAP PRESENCE" | awk NR==$index | awk '{print $3}'`

            #FLASH״̬
            FLASH_STATUS=`cat $G_TMP_FILE$Item | grep "FLASH STATUS OK" | awk NR==$index | awk '{print $3}'| awk -F: '{print $2}'`

            #Ƿ
            FULL_CHARGE=`cat $G_TMP_FILE$Item | grep "CAP FULL CHARGE" | awk NR==$index | awk '{print $4}'`

            #Ƿﵽʹ
            LIFE_END=`cat $G_TMP_FILE$Item | grep "CAP LIFE END" | awk NR==$index | awk '{print $3}' | awk -F: '{print $2}'`

            if [ "$SAVE_MODE" != "CKE_MODE" ] || [ "$TEMPERATUER" -gt "60" ] || [ "$PRESENCE" != "TRUE" ] || [ "$FLASH_STATUS" != "TRUE" ] || [ "$FULL_CHARGE" != "TRUE" ] || [ "$LIFE_END" != "FALSE" ]; then
                NVDIMM_STAT="FAULT"
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:The status of nvdimm(${NVDIMM_NAME}) is FAULT."
            else
                NVDIMM_STAT="NORMAL"
            fi

            Result="Node:$Item||NVDIMM NAME:$NVDIMM_NAME||NVDIMM_STATUS:$NVDIMM_STAT||SAVE MODE:$SAVE_MODE||CAP TEMPERATUER(centigrade):$TEMPERATUER||CAP PRESENCE:$PRESENCE||FLASH_STATUS:$FLASH_STATUS||CAP FULL CHARGE:$FULL_CHARGE||CAP LIFE END:$LIFE_END"

            LOG "[$FUNCNAME]:Result:$Result"

            WRITE_XML_COMMON 0 "$Result"

            #һѭ
            index=$((index + 1 ))
        done

        restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#ÿڵECCϢ
function checkEcc_result()
{
    local isOK=0
    local ip=$1
    local info=$2

    LOG "ecc IP:$ip||$info"

    if [ "$info" = "" ];then
        #ʾ
        Result="Info:No Ecc errors"
        #Itemֱⲿֵ
        WRITE_XML_COMMON 0 "Node:$ip||${Result}"
        return 0
    fi

    # get DIMM countȡDIMMĸ
    uiDiMMCnt=`echo "$info" | grep "DIMM" | wc -l`
    LOG "bit ecc Dimm num:$uiDiMMCnt"

    #parse 
    uiLine=0
    uiErrCount=0
    uiLoop=0
    Result="Info:bit ecc ok"
    while [ $uiLoop -lt $uiDiMMCnt ]; do
        uiLine=`echo "5+$uiLoop*8"|bc`
        LOG "bit ecc: $uiLoop,line: $uiLine"

        uiErrCount=`echo "$info" | awk NR==$uiLine| awk '{print $1}'`
        LOG "bit ecc:out $uiErrCount"

        #threshold ֵΪ 25K
        if [ $uiErrCount -gt 25000 ];then
            isOK=1
            Result="Info:bit ecc too much"
            WRITE_XML_ERROR 0 "Node:${ip}||INFO:The bit ecc is greater than 25000."
        fi

        #uiLoop++ ȡһ
        uiLoop=$((uiLoop+1))
    done
    WRITE_XML_COMMON 0 "Node:$ip||${Result}"

    #ݽϸϢӡ
    Result=""
    set_ifs
    WRITE_XML_COMMON 0 "Node:${ip}||Info:--------------detail-------------- "
    for line in $info; do
        Result="Info:${line}"
        WRITE_XML_COMMON 0 "Node:${ip}||${Result}"
    done
    restore_ifs

    return $isOK
}

#116 Bit ECCĴ mcelog --client
function checkBitEcc()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""
    ALLIp=`cat $IP_ROLE_FILE`

    for Item in $ALLIp; do
        info=`remote_exec $Item 120 "mcelog --client"`

        iRet=$?
        if [ $iRet -ne 0 ]; then
            errResult="Node:$Item||INFO:Failed to execute command(remote_exec $Item 120 'mcelog --client')||$errResult"
            isPass=1
            continue
        fi

        checkEcc_result $Item "$info"
        if [ $? -ne 0 ]; then
            isPass=1
        fi
    done

    if [ "" != "${errResult}" ];then
        WRITE_XML_ERROR 0 "$errResult"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

 #119 汾һ
 checkNodeVersion()
 {
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""
    local Result=""
    local TASK_ID=0
    local ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')
    local cmpFlag=0
    local funcversion=0
    local clusterversion=0
    local iRet=0
    local othernodeversion=0
    #T3000C72֮ĽڵҪӷ֧
    local RHtypeChecklist=""
    local upgradeFlag=0
    ALLIp=`cat $IP_ROLE_FILE`

    #ȡڵİ汾
    master_version_file=/tmp/tmpcmmaster_version
    master_version_filetmp=/tmp/tmpcmmaster_versiontmp
    typelistfile=/tmp/tmptypelistfiletmp
    [ -f ${master_version_file} ] && rm -f ${master_version_file}
    $G_MML_FILE_PATH/GetNodeVersion > $master_version_file
    netcard=`cat $master_version_file|grep netcard|awk -F: '{print $2}'`
    nvdimm=`cat $master_version_file|grep nvdimm|awk -F: '{print $2}'`
    ibcard=`cat $master_version_file|grep ibcard|awk -F: '{print $2}'`
    sascard=`cat $master_version_file|grep sascard|awk -F: '{print $2}'`
    bmc=`cat $master_version_file|grep BMC|awk -F: '{print $2}'`
    bios=`cat $master_version_file|grep BIOS|awk -F: '{print $2}'`
    mb_cpld=`cat $master_version_file|grep MB_CPLD|awk -F: '{print $2}'`
    bootrom=`cat $master_version_file|grep BOOTROM|awk -F: '{print $2}'`
    exp=`cat $master_version_file|grep EXP|grep "CPLD:"|awk -F: '{print $2}'`
    exp_u=`cat $master_version_file|grep EXP|grep 4U|awk -F: '{print $2}'`
    pangeaver=`cat $master_version_file|grep PANGEA_Version|awk -F: '{print $2}'`
    productver=`cat $master_version_file|grep ExternalVersion|awk -F: '{print $2}'`
    compver=`cat $master_version_file|grep ComponentVersion|awk -F: '{print $2}'`
    sphver=`cat $master_version_file|grep SphVersion|awk -F: '{print $2}'`
    funcversion=`cat $master_version_file|grep FuncVersion|awk -F: '{print $2}'`
    clusterversion=`cat $master_version_file|grep ClusterVersion|awk -F: '{print $2}'`

    local tmpUpgradeFlag=$(cat $master_version_file | grep UpgradeFlag | awk -F: '{print $2}')
    if [ "X$tmpUpgradeFlag" != "X" ] && [ $tmpUpgradeFlag -gt $upgradeFlag ];then
        upgradeFlag=$tmpUpgradeFlag
    fi
    #ʱ
    sed -i '/UpgradeFlag/d' $master_version_file

    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        isPass=1
        LOG "[$FUNCNAME]:INFO: Can't get local ip"
        WRITE_XML_ERROR 0 "Node:${hostname}||INFO:Get backend IP failed"
    fi
    if [ $ProductType -eq 80 ] || [ $ProductType -eq 91 ];then
        #UDSSFSʹõͨ÷ BOOTROM EXP_CPLD PANGEA_Version汾
        Result="Node:$back_ip||NodeVersion:$funcversion ||ClusterVersion:$clusterversion || Netcard:$netcard|| Nvdimm:$nvdimm||Ibcard:$ibcard|| Sascard:$sascard|| BMC:$bmc|| BIOS:$bios|| MB_CPLD:$mb_cpld||ProductVersion:$productver|| EXP_CPLD(4U):$exp_u||SphVersion:$sphver||ComponentVersion:$compver"
    else
        Result="Node:$back_ip||NodeVersion:$funcversion ||ClusterVersion:$clusterversion || Netcard:$netcard|| Nvdimm:$nvdimm||Ibcard:$ibcard|| Sascard:$sascard|| BMC:$bmc|| BIOS:$bios|| MB_CPLD:$mb_cpld|| BOOTROM:$bootrom|| EXP_CPLD:$exp||ProductVersion:$productver||EXP_CPLD(4U):$exp_u||SphVersion:$sphver||PANGEA_Version:$pangeaver||ComponentVersion:$compver"
    fi
    WRITE_XML_COMMON 0 "$Result"
    LOG "$Result"
    if [ $funcversion != $clusterversion ];then
        isPass=$(check_pass $isPass 4)
        LOG "master funcversion:$funcversion not equal clusterversion:$clusterversion."
        WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:The master funcversion:$funcversion not equal clusterversion:$clusterversion."
    fi
	#޳4uı
    cat $master_version_file |grep -v "EXP & CPLD(4U)" | grep -v "devicetype:" > $master_version_filetmp
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/GetNodeVersion > $G_REMOTE_TMP_FILE$FUNCNAME" "GetNodeVersion"
    if [ 0 -ne $? ];then
        isPass=$(check_pass $isPass 1)
    fi
    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "GetNodeVersion"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=$(check_pass $isPass 1)
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=$(check_pass $isPass 1)
                LOG "Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:Failed to download file from command(GetNodeVersion)."
                echo "FlagDownfail" >> $G_TMP_FILE$Item 2>&1
                continue;
            fi

            tmpUpgradeFlag=$(cat $G_TMP_FILE$Item | grep UpgradeFlag | awk -F: '{print $2}')
            if [ "X$tmpUpgradeFlag" != "X" ] && [ $tmpUpgradeFlag -gt $upgradeFlag ];then
                upgradeFlag=$tmpUpgradeFlag
            fi
            ClusterUpdStatus=$(cat $G_TMP_FILE$Item | grep ClusterUpdStatus | awk -F: '{print $2}')
            if [ "X$ClusterUpdStatus" != "X0" ];then
                isPass=$(check_pass $isPass 1)
                LOG "[$FUNCNAME][$LINENO]IP:$Item ClusterUpdStatus:$ClusterUpdStatus is not equal 0."
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:ClusterUpdStatus $ClusterUpdStatus is not equal 0."
            fi
            #ʱ
            sed -i '/UpgradeFlag/d' $G_TMP_FILE$Item
            sed -i '/ClusterUpdStatus/d' $G_TMP_FILE$Item
			#޳4uı
            cat $G_TMP_FILE$Item |grep -v "EXP & CPLD(4U)" | grep -v "devicetype:" > $G_TMP_FILE$Item"tmp"
            if [ "$back_ip" != "$Item" ];then
                print_NodeVersion $G_TMP_FILE$Item $Item
                iRet=$?
                if [ 0 -eq $iRet ];then
                    othernodeversion=$(cat $G_TMP_FILE$Item|grep ClusterVersion|awk -F: '{print $2}')
                    if [ $othernodeversion != $clusterversion ];then
                        isPass=$(check_pass $isPass 4)
                        LOG "[$FUNCNAME][$LINENO]IP:$Item ClusterVersion:$othernodeversion is not equal $clusterversion."
                        WRITE_XML_ERROR 0 "Node:${Item}||INFO:ClusterVersion $othernodeversion is not equal $clusterversion."
                    fi
                else
                    isPass=$(check_pass $isPass 4)
                fi
            fi

            #߳ڵ㣬Ƚ
            devicetype=`cat $G_TMP_FILE$Item | grep devicetype | awk -F: '{sub("^[ \t]*","",$2);print $2}'`
            LOG "devicetype=[$devicetype]"

            InspectIsRHNode ${devicetype}
            isRH=$?
            if [ 0 -eq ${isRH} ];then
                echo ${RHtypeChecklist} |grep -w "${devicetype}"
                isFind=$?
                if [ 0 -ne ${isFind} ];then
                    RHtypeChecklist="${RHtypeChecklist}"" ${devicetype}"
                fi
                echo "devicetype=$devicetype;IP=$Item"  >> $typelistfile
                LOG "devicetype=$devicetype;IP=$Item"
                cmpFlag=1
                continue
            fi

			diff $master_version_filetmp $G_TMP_FILE$Item"tmp" > /dev/null
	    	if [ 0 -ne $? ];then
	    		isPass=$(check_pass $isPass 4)
                LOG "[$FUNCNAME] $master_version_filetmp, $G_TMP_FILE$Item,."
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:The version file is different from others."
	    	else
                exp_u_tmp=$(cat $G_TMP_FILE$Item|grep EXP|grep 4U|awk -F: '{print $2}')
                if [ "$exp_u" == "" ] && [ "$exp_u_tmp" != "" ];then
                	exp_u=$exp_u_tmp
                    LOG "[$FUNCNAME] exp_u:$exp_u, exp_u_tmp:$exp_u_tmp"
				fi

				if [ "$exp_u" != "" -a "$exp_u_tmp" != "" -a "$exp_u" != "$exp_u_tmp" ];then
                    isPass=$(check_pass $isPass 4)
                    LOG "[$FUNCNAME] Get EXP_CPLD(4U) of nodes are not the same."
                    WRITE_XML_ERROR 0 "Node:${Item}||INFO:Get EXP_CPLD(4U)(${exp_u}) is different with ${exp_u_tmp}."
                fi
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    if [ $upgradeFlag -eq 1 ];then
        isPass=$(check_pass $isPass 1)
        WRITE_XML_ERROR 0 "Node:master||INFO:The cluster version in the memory is not updated."
    fi

    if [ $cmpFlag -eq 1 ];then
        for Tmptype in ${RHtypeChecklist};do
            filter="devicetype=$Tmptype"
            mastFlag=0
            mastIP=""
            mastefile=""
            for line in `cat $typelistfile | grep $filter` ;do
                LOG "[$FUNCNAME] rh compare line info[line=$line]."
                tmpIP=`echo $line | awk -F ";" '{print $2}' | awk -F "=" '{print $2}'`
                if [ $mastFlag -eq 0 ];then
                    mastefile=$G_TMP_FILE$tmpIP
                    mastIP=$tmpIP
                    mastFlag=1
                    LOG "master file=$mastefile"
                    continue
                fi
                diff $mastefile $G_TMP_FILE$tmpIP > /dev/null
                if [ 0 -ne $? ];then
                    isPass=$(check_pass $isPass 4)
                    LOG "[$FUNCNAME] Some hardware version is not same between $mastIP and $tmpIP."
                    WRITE_XML_ERROR 0 "Node:${tmpIP}||INFO:Some hardware version is not same with $mastIP."
                fi
            done
        done
    fi

    rm -rf /tmp/tmpcmmaster_versiontmp
    rm -rf /tmp/tmpcmmaster_version
    rm -rf $typelistfile


    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
 }

#120. Modmem״̬
checkModmemtatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local index=0

    local iRet=0
    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            WRITE_XML_ERROR 0 "Node:$(hostname)||INFO:Can't get backend IP."
            isPass=1
            break
        fi

        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm modemstat" |sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            WRITE_XML_ERROR 0 "Node:$back_ip||INFO:Failed to execute command(MmlBatch 4016 'cm modemstat'). Error(${iRet})."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #mml>>>NodeID:xxx
        NodeIDs=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep NodeID |awk '{print $1}'|sed 's/^.*NodeID://g'|tr -d " "`
        if [ "X${NodeIDs}" = "X" ];then
            index=$((index + 1))
            if [ $index -gt 10 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:Get ModemStatus from command(MmlBatch 4016 'cm modemstat') failed."
                break
            fi
            continue
        fi
        for nodeid in $NodeIDs
        do
            parentIP=`get_node_backnet_ip $nodeid`
            Result=$(grep -w $nodeid $G_REMOTE_TMP_FILE$FUNCNAME |grep -Po '(?<=ModemStatus:)[a-zA-Z]*' |tr -d ' ')
            if [ $? -eq 0 ]; then
                if [ "$Result" == "Running" ]; then
                    Status="Running"
                elif [ "$Result" == "NotRunning" ]; then
                    isPass=1
                    Status="NotRunning"
                    WRITE_XML_ERROR 0 "Node:$parentIP||INFO:$nodeid Status is NotRunning."
                elif [ "$Result" == "NotExisted" ]; then
                    Status="NotExisted"
                else
                    isPass=1
                    Status="Unknown"
                    WRITE_XML_ERROR 0 "Node:$parentIP||INFO:$nodeid Status is Unknown."
                fi
            else
                isPass=1
                Status="Unknown"
                WRITE_XML_ERROR 0 "Node:$parentIP||INFO:$nodeid Status is Unknown."
            fi
            Result="Node:$parentIP||NodeID:$nodeid||Status:$Status"
            WRITE_XML_COMMON 0 "$Result"
        done
        break

    done

    if [ "$isPass" != "0" ];then
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#121. ڵʱͬ
checkNodeTime()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local Result=""
    local errResult=""
    local tmpMax=0
    local tmpMin=0
    local tmpdiff=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    index=0;
    for Item in $REMOTE_IP_S; do
        localTime=`date +%s`
        set_ifs
        remoteResult=`remote_exec $Item 30 "date +%s"`
        iRet=$?

        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] $Item Failed to execute(checkNodeTime) command.iRet($iRet)"
            isPass=1
            Result="NodeIp:$Item||INFO:Failed to execute command(date +%s)."
            WRITE_XML_ERROR 0 "$Result"
        else
            timeDelta=`expr $remoteResult - $localTime`
            if [ ${timeDelta} -gt 10 ];then
                isPass=1
                WRITE_XML_ERROR 0 "NodeIp:$Item||INFO:DiffTime(s)$timeDelta is great than 10."
            fi
            if [ ${timeDelta} -lt -10 ];then
                isPass=1
                WRITE_XML_ERROR 0 "NodeIp:$Item||INFO:DiffTime(s)$((0-$timeDelta)) is great than 10."
            fi
            #get the biggest diff
            if [ ${timeDelta} -gt ${tmpMax} ];then
                tmpMax=${timeDelta}
            fi
            #get the smallest diff
            if [ ${timeDelta} -lt ${tmpMin} ];then
                tmpMin=${timeDelta}
            fi
            Result="NodeIp:$Item||DiffTime(s):$timeDelta"
            WRITE_XML_COMMON 0 "$Result"
        fi
        restore_ifs

        done

    tmpdiff=`expr ${tmpMax} - ${tmpMin}`
    if [ ${tmpdiff} -gt 10 ];then
        isPass=1
        WRITE_XML_ERROR 0 "INFO:DiffTime(s) between max(${tmpMax}) and min(${tmpMin}) is great than 10."
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}
#122 syslog״̬
checkSysLog()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""

    ALLIp=`cat $IP_ROLE_FILE`

    for Item in $ALLIp; do
        info=`remote_exec $Item 30 "systemctl status rsyslog | grep running | wc -l"`

        iRet=$?
        if [ $iRet -ne 0 ]; then
            errResult="Node:$Item||INFO:Failed to execute(systemctl status rsyslog | grep running)."
            WRITE_XML_ERROR 0 "$errResult"
            isPass=1
            continue
        fi

        if [ $info -ne 1 ]; then
            errResult="Node:$Item||INFO:Service syslog is not running"
            WRITE_XML_ERROR 0 "$errResult"
            isPass=1
        else
            WRITE_XML_COMMON 0 "Node:$Item||INFO:service syslog is running"
        fi

    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#126.⼶״̬
checkExpBoardStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=$(cat ${IP_ROLE_FILE})

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        remote_exec ${Item} 30 "cat /opt/huawei/deploy/etc/deploy.ini | grep devicename | grep \"9000 C72 Node\" >> /dev/null 2>&1"
        if [ $? -ne 0 ];then
            WRITE_XML_COMMON 0 "Node:$Item(Not C72 node)||INFO:No need to check."
            continue
        fi
        echo -n "$Item " >> ${VALID_IP_FILE}
    done

    REMOTE_IP_S=$(cat "${VALID_IP_FILE}")

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $TASK_ID 300 "$G_MML_FILE_PATH/ShowInspectMml $Item 4016 'cm hardwareinfo show' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1;sleep 3;ipmitool fru >> $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:Failed to execute command(MmlBatch 4016 'cm hardwareinfo show'),iRet(${iRet})"
            isPass=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "MmlBatch 4016 'cm hardwareinfo show'"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:Failed to download file from command(MmlBatch 4016 'cm hardwareinfo show')."
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        fifoContext=`cat $G_TMP_FILE$Item`
        if [ "$fifoContext" = "" ];then
            continue
        fi

        set_ifs
        dos2unix $G_TMP_FILE$Item

        cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1

        #޼
        info=`cat $G_TMP_FILE$Item | grep "ExpBoard:no"`
        if [ "$info" != "" ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:There is no ExpBoard."
            restore_ifs
            continue
        fi

        #ȡưλ
        ControlBoardID=`cat $G_TMP_FILE$Item | grep "Board Slot ID" | awk '{print $5}'`
        #ȡӦϢ
        ExpBoardInfo=`cat $G_TMP_FILE$Item | grep -A2 "ExpBoard:" | grep "Board_ID: $ControlBoardID"`
        if [ "$ExpBoardInfo" == "" ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:There is no ExpBoard."
        else
            healthStatus=`echo $ExpBoardInfo | awk '{print $5}'`
            runningStatus=`echo $ExpBoardInfo | awk '{print $8}'`
            if [ "$healthStatus" = "1" ] && [ "$runningStatus" = "1" -o "$runningStatus" = "2" ]; then
                WRITE_XML_COMMON 0 "Node:$Item(C72 node)||$ExpBoardInfo"
            else
                isPass=1
                ExpBoardErrorInfo="BoardID:${ControlBoardID}, healthStatus:${healthStatus}, runningStatus:${runningStatus}"
                WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:${ExpBoardErrorInfo}"
            fi
        fi

        restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#127.ⳬ״̬
checkCBUStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        remote_exec ${Item} 30 "cat /opt/huawei/deploy/etc/deploy.ini | grep devicename | grep \"9000 C72 Node\" >> /dev/null 2>&1"
        if [ $? -ne 0 ];then
            WRITE_XML_COMMON 0 "Node:$Item(Not C72 node)||Board_id:No need to check.||Health_Status:${healthStatus}||Running_Status:${runningStatus}"
            continue
        fi
        echo -n "$Item " >> ${VALID_IP_FILE}
    done

    REMOTE_IP_S=$(cat "${VALID_IP_FILE}")

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $TASK_ID 300 "$G_MML_FILE_PATH/ShowInspectMml $Item 4016 'cm hardwareinfo show' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1;sleep 3;ipmitool fru >> $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:Failed to execute command(MmlBatch 4016 'cm hardwareinfo show'),iRet(${iRet})."
            isPass=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=`cat ${VALID_IP_FILE}`
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "MmlBatch 4016 'cm hardwareinfo show'"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:Failed to download file from command(MmlBatch 4016 'cm hardwareinfo show')."
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        fifoContext=`cat $G_TMP_FILE$Item`
        if [ "$fifoContext" = "" ];then
            continue
        fi

        set_ifs
        dos2unix $G_TMP_FILE$Item

        cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1

        #CBU
        info=`cat $G_TMP_FILE$Item | grep "CBU:no"`
        if [ "$info" != "" ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:There is no CBU."
            restore_ifs
            continue
        fi

        #CBUΪ2
        CBUCount=`cat $G_TMP_FILE$Item | grep "CBU:" | awk -F: '{print $2}'`
        if [ "$CBUCount" != "2" ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:CBU number $CBUCount is not 2"
            restore_ifs
            continue
        fi

        #жCBU״̬(뼶岻ͬCBUǹõ)
        info=`cat $G_TMP_FILE$Item | grep -A2 "CBU:" | grep -v "CBU:"`
        if [ "$info" == "" ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:Failed to get CBU info."
            restore_ifs
            continue
        fi
        for loop in 1 2
        do
            CBUInfo=`cat $G_TMP_FILE$Item | grep -A2 "CBU:" | grep -v "CBU:" | sed -n "${loop}p"`
            if [ "$CBUInfo" == "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item(C72 node)||INFO:Failed to get CBU info."
                break
            fi
            ID=$(echo "${CBUInfo}" | awk -F'\\|\\|' '{print $1}' | awk -F':' '{print $2}' | tr -d ' ')
            healthStatus=$(echo "${CBUInfo}" | awk -F'\\|\\|' '{print $2}' | awk -F':' '{print $2}' | tr -d ' ')
            runningStatus=$(echo "${CBUInfo}" | awk -F'\\|\\|' '{print $3}' | awk -F':' '{print $2}' | tr -d ' ')
            if [ "$healthStatus" = "1" ] \
            && [ "$runningStatus" = "1" -o "$runningStatus" = "2" -o "$runningStatus" = "27" ];then
                WRITE_XML_COMMON 0 "Node:$Item(C72 node)||Board_id:${ID}||Health_Status:${healthStatus}||Running_Status:${runningStatus}"
            else
                isPass=1
                WRITE_XML_COMMON 0 "Node:$Item(C72 node)||Board_id:${ID}||Health_Status:${healthStatus}||Running_Status:${runningStatus}"
                WRITE_XML_ERROR 0 "Node:${Item}||INFO:Board_id(${ID})Health_Status or Running_Status is abnormal."
            fi
        done

        restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#128FW汾
checkFwVersion()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""

    ALLIp=$(cat ${IP_ROLE_FILE})
    for Item in ${ALLIp}; do
        #ֻC72ڵ
        remote_exec ${Item} 30 "cat /opt/huawei/deploy/etc/deploy.ini | grep devicename | grep \"9000 C72 Node\" >> /dev/null 2>&1"
        if [ $? -ne 0 ];then
            WRITE_XML_COMMON 0 "Node:${Item}(Not C72 node)||INFO:No need to check."
            continue
        fi

        remote_exec ${Item} 30 "echo > /var/log/hdfw_precheck.flag"
        if [ $? -ne 0 ]; then
            errResult="Node:${Item}(C72 node)||INFO:Failed to execute command(echo > /var/log/hdfw_precheck.flag)."
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
            continue
        fi

        remote_exec ${Item} 30 "/opt/huawei/snas/bin/snas_cm_cmd updfw 10303 0"
        if [ $? -ne 0 ]; then
            errResult="Node:${Item}(C72 node)||INFO:Failed to execute command(/opt/product/snas/bin/snas_cm_cmd updfw 10303 0)."
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
            continue
        fi

        info=$(remote_exec ${Item} 30 "cat /var/log/hdfw_precheck.flag")
        if [ $? -ne 0 ]; then
            errResult="Node:${Item}(C72 node)||INFO:Failed to execute command(cat /var/log/hdfw_precheck.flag)."
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
            continue
        fi

        if [ "${info}" == "matched" ];then
            WRITE_XML_COMMON 0 "Node:${Item}(C72 node)||INFO:${info}"
        elif [ "${info}" == "unmatched" ];then
            if [ "${isPass}" -ne 1 ];then
                isPass=4
                WRITE_XML_ERROR 0 "Node:${Item}(C72 node)||INFO:${info}"
            fi
            WRITE_XML_COMMON 0 "Node:${Item}(C72 node)||INFO:${info}"
        else
            isPass=1
            WRITE_XML_ERROR 0 "Node:${Item}(C72 node)||INFO:${info}"
        fi
    done

    WRITE_XML_JUDGE ${isPass}
    WRITE_XML_SUBCMD_TAIL
}

#129ӲFW汾
checkDiskFwVersion()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local errResult=""
    local isPass=0
    local ShowFlag=0
    local diskModel=""
    local diskFW=""
    local numDiskFW=0
    local iRet=0

    while true;do
        local back_ip=$(get_backnet_ip)
        if [ "${back_ip}" = "" ]; then
            errResult="INFO: Can't get local ip"
            LOG "[$FUNCNAME]:${errResult}"
            isPass=1
            WRITE_XML_ERROR 0 "Node:${hostname}||INFO:Get backend IP failed."
            break
        fi

        #ִmml cm diskinfo show
        ${G_MML_FILE_PATH}/ShowInspectMml ${back_ip} 4016 "cm diskinfo"  > ${G_REMOTE_TMP_FILE}${FUNCNAME} 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=$(cat ${G_REMOTE_TMP_FILE}${FUNCNAME})
            LOG "[${FUNCNAME}]${Info}"
            WRITE_XML_ERROR 0 "Node:${hostname}||INFO:Failed to execute command(MmlBatch 4016 'cm diskinfo')."
            isPass=1
            break
        fi

        lines=$(cat ${G_REMOTE_TMP_FILE}${FUNCNAME} | grep "Disk_ID" | sed 's/^ *//g' | sed "/^$/d" | tr -d "\r")
        if [ "${lines}" == "" ];then
            errResult="INFO:Can not get disk information."
            isPass=1
            LOG "[${FUNCNAME}]:${errResult}"
            WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:Can not get disk information from command(MmlBatch 4016 'cm diskinfo')."
            cat ${G_REMOTE_TMP_FILE}${FUNCNAME} >> ${LOG_FILE} 2>&1
            break
        fi

        set_ifs
        for line in ${lines}; do
            ShowFlag=0
            if [ "${line}" = "" ];then
                continue
            fi
            ID=$(echo "${line}" | awk -F'\\|\\|' '{print $1}' | awk -F':' '{print $2}' | tr -d ' ')
            diskModel=$(echo "${line}" | awk -F'\\|\\|' '{print $10}' | awk -F':' '{print $2}' | tr -d ' ')
            diskFW=$(echo "${line}" | awk -F'\\|\\|' '{print $11}' | awk -F':' '{print $2}' | tr -d ' ')
            diskNeedUpg=$(echo ${line} | awk -F'\\|\\|' '{print $16}' | awk -F':' '{print $2}' | tr -d ' ')
            diskUpgStrategy=$(echo ${line} | awk -F'\\|\\|' '{print $17}' | awk -F':' '{print $2}' | tr -d ' ')

            Running_Status=$(echo ${line} | awk -F'\\|\\|' '{print $5}' | awk -F':' '{print $2}' | tr -d ' ')
            if [ "4" = "${Running_Status}" ]; then
                continue
            fi

            #Disk that Models are ST1200MM0129,ST1800MM0129,ST2400MM0129 and FWversions are C001,C0B1,C003 need upgrade
            if [ "${diskModel}" = "ST1200MM0129" -o "${diskModel}" = "ST1800MM0129" -o "${diskModel}" = "ST2400MM0129" ]; then
                if [ "${diskFW}" = "C001" -o "${diskFW}" = "C0B1" -o "${diskFW}" = "C003" ]; then
                    diskNeedUpg="YES"
                    diskUpgStrategy="BLACK"
                    Result="ID:${ID}||DiskNeedUpg:${diskNeedUpg}||DiskUpgStrategy:${diskUpgStrategy}||DiskModel:${diskModel}||FWVersion:${diskFW}"
                    isPass=1
                    WRITE_XML_COMMON 0 "${Result}"
                    WRITE_XML_ERROR 0 "Node:${ID}||INFO:DiskModel:${diskModel},FWVersion:${diskFW} need upgrade."
                    continue
                fi
            fi
            #Disk that Models are LT1800RO,LT0900RO and FWversions less equal than H506 need replace
            if [ "${diskModel}" = "LT1800RO" -o "${diskModel}" = "LT0900RO" ]; then
                numDiskFW=$(echo "${diskFW}" | sed 's/[^0-9]//g')
                if [ ${numDiskFW:-0} -le 506 ]; then
                    diskNeedUpg="YES"
                    diskUpgStrategy="BLACK"
                    Result="ID:${ID}||DiskNeedUpg:${diskNeedUpg}||DiskUpgStrategy:${diskUpgStrategy}||DiskModel:${diskModel}||FWVersion:${diskFW}"
                    isPass=1
                    WRITE_XML_COMMON 0 "${Result}"
                    WRITE_XML_ERROR 0 "Node:${ID}||INFO:DiskModel:${diskModel},FWVersion:${diskFW} less equal than H506,need replace."
                    continue
                fi
            fi
            #Disk that Models start with HSSD-D7,HWE6 and FWversions less than 6222 need replace
            if [[ "${diskModel}" =~ ^HSSD-D7 || "${diskModel}" =~ ^HWE6 ]]; then
                numDiskFW=$(echo "${diskFW}" | sed 's/[^0-9]//g')
                if [ ${numDiskFW:-0} -lt 6222 ]; then
                    diskNeedUpg="YES"
                    diskUpgStrategy="BLACK"
                    Result="ID:${ID}||DiskNeedUpg:${diskNeedUpg}||DiskUpgStrategy:${diskUpgStrategy}||DiskModel:${diskModel}||FWVersion:${diskFW}"
                    isPass=1
                    WRITE_XML_COMMON 0 "${Result}"
                    WRITE_XML_ERROR 0 "Node:${ID}||INFO:DiskModel:${diskModel},FWVersion:${diskFW} is less than 6222,need replace."
                    continue
                fi
            fi

            if [ "$diskNeedUpg" = "--" ] && [ "$diskUpgStrategy" = "--" ];then
                continue;
            fi

            Result="ID:${ID}||DiskNeedUpg:${diskNeedUpg}||DiskUpgStrategy:${diskUpgStrategy}||DiskModel:${diskModel}||FWVersion:${diskFW}"

            if [ "${diskUpgStrategy}" != "BLACK" -a "${diskUpgStrategy}" != "RED" ];then
                WRITE_XML_COMMON 0 "${Result}"
                continue
            fi

            if [ "${diskUpgStrategy}" == "BLACK" -a "${diskNeedUpg}" == "YES" ];then
                if [ "${isPass}" -ne 1 ];then
                    isPass=4
                fi
                ShowFlag=1
            fi

            if [ "${diskUpgStrategy}" == "RED" -a "${diskNeedUpg}" == "YES" ];then
                if [ "${isPass}" -ne 1 ];then
                    isPass=4
                fi
                ShowFlag=1
            fi
            WRITE_XML_COMMON 0 "${Result}"
            if [ "${ShowFlag}" == "1" ];then
                WRITE_XML_ERROR 0 "Node:${ID}||INFO:DiskUpgStrategy:${diskUpgStrategy},DiskModel:${diskModel},FWVersion:${diskFW} need upgrade."
            fi
        done
        break
        restore_ifs
    done

    WRITE_XML_JUDGE ${isPass}
    WRITE_XML_SUBCMD_TAIL
}

#131Ӳ
checkDisk()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        errResult="INFO:Can't get backend IP."
        LOG "[$FUNCNAME]:$errResult"
        isPass=1
        WRITE_XML_ERROR 0 "Node:$(hostname)||INFO:Can't get backend IP."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    local devicetypenum=$(cat /opt/huawei/deploy/etc/deploy.ini | grep devicetype |awk -F= '{print $2}')
    local devicetype=$(MapNodeType $devicetypenum)

    $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm diskinfo" | sed 's/||/,/g' | awk -F ',' -v devicetypetmp="$devicetype" '
    function printDiskType(type)
    {
        diskTypeName[0] = "FC"
        diskTypeName[1] = "SAS"
        diskTypeName[2] = "SATA"
        diskTypeName[3] = "SAS_SSD"
        diskTypeName[4] = "NL_SAS"
        diskTypeName[5] = "SLC_SSD"
        diskTypeName[6] = "MLC_SSD"
        diskTypeName[7] = "SATA_SSD"
        if (type>=0&&type<=6)
            printf("diskTpye=%s ", diskTypeName[type])
        else
            printf("%d ", type)
    }
    function printOneDiskResult()  #ӡһڵĽ
    {
        if (nodeID == -1 )
            return
        printf("nodeID=%d ",nodeID)
        printf("slotID=%s ",slotid)
        printDiskType(type)
        printf("diskSize=%d ",size)
        printf("diskFactory=%s ",facture)
        printf("\n")
    }
    function printOneNodeResult()  #ӡһڵĽ
    {
        if (nodeID == -1 )
	    return
        printf("BLAG ")
	printf("nodeID=%d ",nodeID)
	printf("diskTypePass=%d ",length(diskType))
	printf("diskSizePass=%d ",length(diskSize))
	printf("diskManuFactoryPass=%d ",length(manuFacture))
	printf("\n")
    }
    function addVal2Array(val, arr)
    {
        for(i in arr)
	{
	    if (arr[i] == val)
	        return
	}
	printf("")
	arr[length(arr)] = val
    }
    BEGIN{nodeID=-1; slotid=""; type=-1; size=-1; facture=""; diskType[0]=-1; diskSize[0]=-1;manuFacture[0]="";}
    {
        do
	{
	    if (!match($1, "Disk_ID:"))
                break;
	    split($2, val, ":")   #parent_ID: xx
	    nid = int(val[2])
	    split($5, val, ":")   #Running_Status: x
	    run = int(val[2])
	    if (nid != nodeID)    #ʼһ½ڵ
	    {
	        if (nodeID!=-1)
		    printOneNodeResult();   #ӡһڵĽ
		nodeID = nid
		delete diskType   #
		delete diskSize
		delete manuFacture
	    }
	    if (run == 4 || run == 0) #״̬Ϊںunknown
	        break;

	    split($6, val, ":")
	    type = int(val[2])
            split($3, val, ":")
            slotid=val[2]
	    split($14, val, ":")
	    size = int(val[2])
            size = int(size/1024/1024/1024)
	    split($12, val, ":")
	    facture=val[2]
	    if ((type == 3 || type == 17) && devicetypetmp != "S25B Node") #ȫ滷SSD
	        break;
	    if (type == 16) #NVME_SSDڴ˼
	        break;
	    #жͺʹСǷڣ
	    addVal2Array(type, diskType)
	    addVal2Array(size, diskSize)
	    addVal2Array(facture, manuFacture)
            printOneDiskResult()
	    } while(0)
    }
    END{
            printOneNodeResult()
        }' >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1


    dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
    set_ifs
    col=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "BLAG" |wc -l)
    if [ $col -eq 0 ]; then
        isPass=1
        WRITE_XML_ERROR 0 "Node:$back_ip||INFO:Get disk information from command(MmlBatch 4016 'cm diskinfo') failed."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        restore_ifs
        return
    fi

    for ((i=1; i<=${col}; i++ ))
    do
        nid=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "BLAG" | awk "NR==$i" | awk -F= '{print $2}' |awk '{print $1}')
        disktype=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "BLAG" | awk "NR==$i" | awk -F= '{print $3}' |awk '{print $1}')
        disksize=$(cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "BLAG" | awk "NR==$i" | awk -F= '{print $4}' |awk '{print $1}')
        if [ "$disktype" -gt 1 ] || [ "$disksize" -gt 1 ]; then
            isPass=4
        fi
    done
    if [ ${isPass} -eq 4 ];then
        WRITE_XML_ERROR 0 "INFO:DiskType or DiskSize number is great than 1."
    fi
    cat $G_REMOTE_TMP_FILE$FUNCNAME |grep -v "BLAG" |while read line
    do
        nid=$(echo $line |grep "nodeID" | awk -F= '{print $2}' |awk '{print $1}' )
        slotid=$(echo $line |grep "nodeID" | awk -F= '{print $3}' |awk '{print $1}' )
        type=$(echo $line |grep "nodeID"| awk -F= '{print $4}' |awk '{print $1}')
        size=$(echo $line |grep "nodeID" | awk -F= '{print $5}' |awk '{print $1}' )
        factory=$(echo $line |grep "nodeID" | awk -F= '{print $6}' |awk '{print $1}')
        Result="NodeID:$nid||SlotID:$slotid||DiskType:$type||DiskSize:$size(GB)||ManuFactory:$factory"
        WRITE_XML_COMMON 0 "$Result"
    done

    restore_ifs

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#ûдѲΪ
noInspectItem()
{
    WRITE_XML_SUBCMD_HEADER $1
    WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
    WRITE_XML_JUDGE 2
    WRITE_XML_SUBCMD_TAIL
}

#137 diskpoolʹǷ
checkDiskPoolUsage()
{
    local totalCap=0
    local freeCap=0
    local Result=""
    local MaxOnePercentage=0
    local MinOnePercentage=0
    local diskPoolAll=""
    local iRet=0

    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local diskpool_rc=""

    #ȡеdiskPoolId
    diskPoolAll=`cat /proc/monc_dsmap|grep DiskPool|awk '{print $6}'|sort|uniq`
    iRet=$?
    if [ "$iRet" -ne 0 ] || [ "$diskPoolAll" == "" ];then
        WRITE_XML_COMMON 0 "INFO:/proc/monc_dsmap is null. Error($iRet)."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL

        LOG "[$FUNCNAME]:err out,iRet($iRet),diskPoolAll($diskPoolAll)."
        return 0
    fi

    set_ifs
    for poolId in $diskPoolAll
    do
        diskSize=`cat /proc/monc_dsmap | grep "DiskPool $poolId"`
        allDiskSize=0
        allFreeSize=0
        AllDiskUsed=0
        AvePercentage=0

        #ƽʹ
        for line in $diskSize
        do
            totalCap=`echo $line|awk '{print $10}'`
            freeCap=`echo $line|awk '{print $12}'`

            #λֽתGB expr $totalCap / 1073741824
            allDiskSize=`expr $allDiskSize \+ $totalCap`
            allFreeSize=`expr $allFreeSize \+ $freeCap`

            LOG "[$FUNCNAME]:allDiskSize:$allDiskSize,allFreeSize:$allFreeSize,totalCap:$totalCap,freeCap:$freeCap"

        done

        #ȡʹʵİٷֱ AvePercentage
        AllDiskUsed=`expr $allDiskSize \- $allFreeSize`

        if [ $allDiskSize -eq 0 ];then
            AvePercentage=0
            continue
        else
            AvePercentage=$(printf "%.2f\n" `echo "scale=2;$AllDiskUsed*100/$allDiskSize"|bc -l`)
        fi

        LOG "$FUNCNAME]allDiskSize(BYTE):$allDiskSize,allFreeSize(BYTE):$allFreeSize,AllDiskUsed(BYTE):$AllDiskUsed,AvePercentage:$AvePercentage"
        Result=

        #Ƚÿһİٷֱ,ȡСʹ
        MaxOnePercentage=0
        MinOnePercentage=100
        ratio=0
        ratio_min=100
        ratio_max=0
        ratio_diff=0

        for line in $diskSize
        do
            OneTotalCap=`echo $line|awk '{print $10}'`
            OneFreeCap=`echo $line|awk '{print $12}'`
            OneUserCap=`expr $OneTotalCap \- $OneFreeCap`

            if [ $OneTotalCap -eq 0 ];then
                OnePercentage=0
                continue
            else
                OnePercentage=$(printf "%.2f\n" `echo "scale=2;$OneUserCap*100/$OneTotalCap"|bc -l`)
                ratio=$(($OneUserCap*100/$OneTotalCap))
            fi

            if [ $(echo "$OnePercentage > $MaxOnePercentage"|bc) -eq 1 ];then
                MaxOnePercentage=$OnePercentage;
            fi

            if [ $(echo "$MinOnePercentage > $OnePercentage"|bc) -eq 1 ];then
                MinOnePercentage=$OnePercentage;
            fi

            if [ $ratio -gt $ratio_max ]; then
                ratio_max=$ratio
            fi

            if [ $ratio -lt $ratio_min ]; then
                ratio_min=$ratio
            fi

            LOG "[$FUNCNAME]:OneTotalCap:$OneTotalCap,OneFreeCap:$OneFreeCap,OneUserCap:$OneUserCap,OnePercentage:$OnePercentage,MaxOnePercentage:$MaxOnePercentage,MinOnePercentage:$MinOnePercentage."
            LOG "[$FUNCNAME]:ratio($ratio), ratio_min($ratio_min), ratio_max($ratio_max)"
        done

        ratio_diff=$(($ratio_max-$ratio_min))
        if [ $ratio_diff -gt 10 ] || [ $ratio_max -ge 80 ]; then
            LOG "DiskPool(ID):$poolId || diskpool($poolId) max ratio is larger than min ratio 10%(ratio_diff: $ratio_diff), or max ratio is more than 80%(ratio_max: $ratio_max)"
            diskpool_rc="fail"
            isPass=4
            WRITE_XML_ERROR 0 "DiskPool(ID):$poolId ||INFO: Max ratio is larger than min ratio 10%(ratio_diff($ratio_diff)), or max ratio is more than 80%(ratio_max($ratio_max))"
        else
            diskpool_rc="pass"
        fi

        Result="DiskPool(ID):$poolId || AvePercentage:$AvePercentage || MaxPercentage:$MaxOnePercentage || MinPercentage:$MinOnePercentage || Result:$diskpool_rc"
        WRITE_XML_COMMON 0 "${Result}"
    done

    restore_ifs

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


function CompareIp()
{
    local iRet=0
    numa=$1
    numb=$2
    numa=$(echo $numa | sed 's/\.//g')
    numb=$(echo $numb | sed 's/\.//g')
    #ڵĵһIPСڵڶ1
    if [ $numa -lt $numb ];then
        iRet=1
    fi

    return $iRet
}

#142. ߼
checkEthNetLine()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local iRet=0
    local switchArray=()
    local IpArray=()
    local arraySize=0
    local count=0
    local TASK_ID=0
    local switch_big_Array=()
    local port_type_Array=()
    local cm_db="/opt/huawei/snas/etc/cm_swm_conf.db"

    LOG "[$FUNCNAME][$LINENO]start!"
    SWITCH_SMALL_FILE="/tmp/switch_small_file"
    ALL_SWITCH_IFNO="/tmp/tmpfileallswitchinfo"
    if [ -L "${SWITCH_SMALL_FILE}" ];then
        rm -f "${SWITCH_SMALL_FILE}"
    fi
    rm -f /tmp/switch_small_file*
    if [ -L "${ALL_SWITCH_IFNO}" ];then
	    rm -f "${ALL_SWITCH_IFNO}"
    fi
    >$ALL_SWITCH_IFNO

    SWITCH_TOPO_FILE="/opt/huawei/snas/etc/switchTopo.ini"
    dos2unix $SWITCH_TOPO_FILE > /dev/null 2>&1


    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            LOG "[$FUNCNAME][$LINENO]Can't get master ip"
            isPass=1
            WRITE_XML_ERROR 0 "Node:${hostname}||INFO:Can't get backend IP."
            break
        fi
        cp $SWITCH_TOPO_FILE /tmp/tmpfileswitchTopo
        if [ $? -ne 0 ];then
           LOG "[$FUNCNAME][$LINENO]Can't get the switch info"
           isPass=2
           WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:Get switch information from config(/opt/product/snas/etc/switchTopo.ini)."
           break
        fi
        REMOTE_IP_S=`cat $IP_ROLE_FILE`
        remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/CheckNetLine $back_ip 2>&1" "CheckNetLine"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            isPass=$iRet
        fi
        ValidIP=`cat ${VALID_IP_FILE}`
        ValidIPResult=$ValidIP

        LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
        fifo_start
        while [ "${ValidIP}" != "" ]; do
            >${VALID_IP_FILE}

            for Item in $ValidIP; do
                #Ϊ100%֮ļأн
                remote_exec_checkfini $Item $TASK_ID "CheckNetLine"
                iRet=$?
                if [ $iRet -eq 0 ]; then
                    echo -n "$Item " >> ${VALID_IP_FILE}
                    continue
                elif [ $iRet -ne 2 -a $iRet -ne 5 ]; then
                    isPass=1
                fi

                remote_download $Item $G_TMP_FILE$Item /tmp/tmpfilecheckswitchinfo
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command(CheckNetLine), Error(${iRet}).||${errResult}"
                    LOG "[$FUNCNAME][$LINENO] $Item exec(tmpfilecheckswitchinfo) failed.iRet($iRet),errno($errno),process(&process)"
                    isPass=1
                    continue
                fi
            done

            ValidIP=`cat ${VALID_IP_FILE}`
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi
            echo "" >> $G_TMP_FILE$Item
            cat $G_TMP_FILE$Item >> $ALL_SWITCH_IFNO 2>&1
        done
        tmp=$(cat $ALL_SWITCH_IFNO | grep "switchName\:NULL")
        if [ "$tmp" != "" ]; then
            local switchIdArray=$(/usr/bin/sqlite3 "${cm_db}" "select szSwId from CM_SWM_T")
            if [ -z "${switchIdArray}" ]; then
                isPass=3
                WRITE_XML_COMMON 0 "INFO:The switch is not configured so No switch info. Do not involve."
                WRITE_XML_JUDGE $isPass
                WRITE_XML_SUBCMD_TAIL
                [ -f "${SWITCH_SMALL_FILE}" ] && rm -f "${SWITCH_SMALL_FILE}"
                [ -f "${ALL_SWITCH_IFNO}" ] && rm -f "${ALL_SWITCH_IFNO}"
                rm -f /tmp/tmpfileswitchTopo*
                return
            fi
        fi
        while read line; do
            arraySize=0
            for oneRec in $line;do
                isNode=$(echo $oneRec | awk -F ':' '{printf $1}')
                if [ "$isNode" = "nodeFunType" ]; then
                    nodeFunType=$(echo $oneRec | awk -F ',' '{printf $1}'| awk -F ':' '{printf $2}')
                    nodeName=$(echo $oneRec | awk -F ',' '{printf $2}'| awk -F ':' '{printf $2}')
                else
                    netPort=$(echo $oneRec | awk -F ',' '{printf $1}'| awk -F ':' '{printf $2}')
                    NodeIP=$(echo $oneRec | awk -F ',' '{printf $2}'| awk -F ':' '{printf $2}')
                    switchName=$(echo $oneRec | awk -F ',' '{printf $3}'| awk -F ':' '{printf $2}')
                    oneline="nodeName: $nodeName||nodeFunType: $nodeFunType||netPort: $netPort||IP: $NodeIP||switchName: $switchName"
                    LOG "$oneline"
                    WRITE_XML_COMMON 0 "$oneline"
                    switchArray[$arraySize]=$switchName
                    IpArray[$arraySize]=$NodeIP
                    arraySize=$((arraySize+1))
                fi
            done
            #ֻһIP.ж
            if [ $arraySize -eq 1 ];then
                continue
            fi
            CompareIp ${IpArray[0]} ${IpArray[1]}
            iRet=$?
            #СIPһʱļIPʱ
            if [ $iRet -eq 1 ]; then
                echo ${switchArray[0]} >>${SWITCH_SMALL_FILE}_${netPort} 2>&1
                switch_big_Array[count]=${switchArray[1]}
            else
                echo ${switchArray[1]} >>${SWITCH_SMALL_FILE}_${netPort} 2>&1
                switch_big_Array[count]=${switchArray[0]}
            fi
            port_type_Array[count]=$netPort
            count=$((count+1))
        done < $ALL_SWITCH_IFNO
        LOG "[$FUNCNAME][$LINENO] isPass=$isPass"
        if [ $isPass -ne 2 ];then
            for ((i=0; i<count; i=i+1))
            do
                #ôIPӦ ȥļƥ䣬ҵ˵нڵСIPӷʽڵ㲻ͬͨ
                grep -q ${switch_big_Array[i]} ${SWITCH_SMALL_FILE}_${port_type_Array[i]} >>/dev/null
                iRet=$?
                if [ $iRet -eq 0 ];then
                    isPass=1
                    LOG "[$FUNCNAME][$LINENO] ${switch_big_Array[i]} the same of switchName"
                fi

            done
        fi
        break
    done


    LOG "[$FUNCNAME][$LINENO]finish!"
    [ -f "${SWITCH_SMALL_FILE}" ] && rm -f "${SWITCH_SMALL_FILE}"
    [ -f "${ALL_SWITCH_IFNO}" ] && rm -f "${ALL_SWITCH_IFNO}"
    rm -f /tmp/tmpfileswitchTopo*
    rm -f /tmp/switch_small_file*
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#ûдѲΪ漰
noInspectItem()
{
    WRITE_XML_SUBCMD_HEADER $1
    WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
    WRITE_XML_JUDGE 3
    WRITE_XML_SUBCMD_TAIL
}

# **************************************************************************** #
# Function Name: checkHardwareStatus
# Description: Ӳ״̬ м.
# Parameter: $1 cmditemID
# Return:
# **************************************************************************** #
checkHardwareStatus()
{
    local checkid=$1
    local startTime=0
    local endTime=0
    touch /opt/inspect/check_thread_count$$
    startTime=$(date +%s)
    LOG "[${FUNCNAME}]Enter ${REMOTE_IP} inspect item ${checkid}, result file $G_CHECK_RESULT_FILE"

    WRITE_XML_CMD_HEADER $1
    #GetIPAndRoleFromDB

    rm -rf /opt/inspect/tmpfile$$*
    rm -rf /tmp/tmpfile$$*

    LOG "[$FUNCNAME] param = ($1)"
    case ${checkid} in
        102)
        #3.Check Memory Usage
        checkMemUsage "0"
        ;;
        104)
        #5.Check Power Status
        checkPowerStatus_MML "0"
        ;;
        105)
        #6.Check Fan Status
        checkFanStatus_MML "0"
        ;;
        107)
        #8.Check CPU Status
        checkCPUStatus "0"
        ;;
        108)
        #9.Check Node Status
        checkNodeStatus_MML "0"
        ;;
        112)
        #ģ
        checkFiber_MML "0"
        ;;
        115)
        #check nvdimm
        checkNvdimmStatus "0"
        ;;
        116)
        #bit ECC
        checkBitEcc "0"
        ;;
        119)
        #汾һ¼
        checkNodeVersion "0"
        ;;
        120)
        #è״̬
        checkModmemtatus "0"
        ;;
        121)
        #ѯ豸ʱ
        checkNodeTime "0"
        ;;
        122)
        #syslog״̬
        checkSysLog "0"
        ;;
        126)
        #⼶״̬
        checkExpBoardStatus "0"
        ;;
        127)
        #ⳬ״̬
        checkCBUStatus "0"
        ;;
        128)
        #FW汾
        checkFwVersion "0"
        ;;
        129)
        #ӲFW汾
        checkDiskFwVersion "0"
        ;;
        131)
        #Ӳ
        checkDisk "0"
        ;;
        137)
        #diskpoolʹǷ
        checkDiskPoolUsage "0"
        ;;
        142)
        #߼
        checkEthNetLine "0"
        ;;
        *)
        noInspectItem "0"
        ;;
    esac
    chmod 640 $LOG_FILE
    WRITE_XML_CMD_TAIL
    endTime=$(date +%s)
    LOG "[${FUNCNAME}]Exit ${REMOTE_IP} inspect item ${checkid}, elapsed time $((endTime-startTime))"
    rm -f /opt/inspect/check_thread_count$$
}

