#!/bin/bash

. ./diag_lib.sh

LOCK_CA_LOG='.*BASE.ERR.*R(.*DLMC_SendAndWaitLock'

function LOCK_Diagnosis4PRO()
{
	local rq2SrvTmoutNum=0
	local bk2srvTmoutNum=0

	info=$(ALI_GetProOmniLockInfo | egrep -i 'Request To Server Timeout|Break Timeout')
	rq2SrvTmoutNum=$(echo "$info"  | awk -F":" '{if($1 ~ /Request To Server Timeout/){print $2}}' |sed -r 's/\s+//g')
	bk2srvTmoutNum=$(echo "$info"  | awk -F":" '{if($1 ~ /Break Timeout/){print $2}}' | sed -r 's/\s+//g')

	if COMM_NumComp 0 "${rq2SrvTmoutNum}" "gt"|| COMM_NumComp 0 "${bk2SrvTmoutNum}" "gt";then
		ret="E"
	else
		ret="I"
	fi

	COMM_CPrint "LOCK#PRO#INF|Req2SrvTmoutNum/BkTmoutNum(${rq2SrvTmoutNum}/${bk2srvTmoutNum})"  "$ret"
	return $E_PASS
}

function LOCK_Diagnosis4CA()
{ 
	COMM_SearchLog4Module   ${SNAS_DLM_LOG}  "${LOCK_CA_LOG}" "LOCK#CA"
}
	
function LOCK_Diagnosis4MDS()
{
	local zNumX=0
	local zNumY=0
	
	zNumX=$(ALI_GetMDSLockInfo | grep -oP 'zombienum\(\d+\)' | grep -oP '\d+')
	sleep $INTERVAL
	zNumY=$(ALI_GetMDSLockInfo | grep -oP 'zombienum\(\d+\)' | grep -oP '\d+')
	
	let  'zNum=zNumY - zNumX '
	COMM_NumComp 0 $zNum "gt" && ret="E" || ret="I"
	COMM_CPrint "LOCK#MDS#CMP|ZombieNum/IncreasedNum(${zNumY}/${zNum})"  "$ret"	
}

function LOCK_Diagnosis4OBS()
{	
	return $E_PASS
}

function LOCK_Diagnosis4DS()
{
	return $E_PASS
}

function LOCK_Diagnosis4NOFS()
{
	return $E_PASS 
}

function LOCK_Diagnosis4DLM()
{
	local zoneStatus=""
	local vnidNum=0
	local nodeNum=0
	
	# Zone
	zoneStatus=$(ALI_GetDLMZoneInfo  | grep -v '^$' | tail -n 1 | awk '{print $3}')
	 [ -z "$zoneStatus" -o  $zoneStatus -ne 1  ] && ret="E" || ret="I"
	COMM_CPrint "LOCK#DLM#INF|ZoneStatus($zoneStatus)"  "$ret"
	
	# Dlm status 
	info=$(ALI_GetDLMLockInfo  |  grep  '^UUID:'  | awk -F'=' '{if($2 !="NORMAL."){print $0}}')
	[ -n "$info" ] && ret="E" || ret="I"
	COMM_CPrint "LOCK#DLM#INF|AbnormalMAP(${DLM_INFO##*/}|${info})" "${ret}"
	
	vnidNum=$(ALI_GetDLMLockInfo | grep  '^UUID:'  | wc -l  )
	nodeNum=$(grep '^Node:' $NODE_MAP | wc -l )
	let "Num=$nodeNum * 2"
	[  $vnidNum -ne $Num ] && ret="E" || ret="I"
	COMM_CPrint "LOCK#DLM#CMP|VnidNum/NodeNum(${vnidNum}/${nodeNum})" "${ret}"
}

function LOCK_Diagnosis()
{
	(LOCK_Diagnosis4CA) &
	(LOCK_Diagnosis4MDS) &
	(LOCK_Diagnosis4PRO)&
	#LOCK_Diagnosis4DS
	#LOCK_Diagnosis4NOFS
	(LOCK_Diagnosis4DLM) &
	wait
}
