#!/bin/bash

. ./diag_lib.sh

MEM_OBS_LOG='.*OBS_IsPageMemPoolEnough'
MEM_DS_LOG='.*Alloc Fail'
MEM_TRNS_LOG='.*Trns_LocalIfNvdimmEnough4Del'
MEM_OBS_PCT=90
MEM_NOFS_PCT=95
MEM_DSNV_THRESHOLD='1073741824'


function MEM_Diagnosis4PRO()
{
	echo -n
}

function MEM_Diagnosis4CA()
{
	echo  -n 
}
	
function MEM_Diagnosis4MDS()
{
	local memLeftVal=0
	local memYelVal=0
	local memRedVal=0
	local memKeyInfo=""
	local index=0
	declare -a freearea=()

	memKeyInfo=$(COMM_GetMDSKeyMem 	| awk -F'='  '{print $1}')
	memLeftVal=$(echo "$memKeyInfo" | awk '{print $1}')
	memYelVal=$(echo "$memKeyInfo"  | awk '{print $2}')
	memRedVal=$(echo "$memKeyInfo" 	| awk '{print $3}')

	if COMM_NumComp  $memLeftVal  $memRedVal "ge";then
		COMM_CPrint "MEM#MDS#CMP|MemFree/MemRed(${memLeftVal}MB/${memRedVal}MB)" "E" 
	elif COMM_NumComp $memLeftVal $memYelVal "ge"; then
		COMM_CPrint "MEM#MDS#CMP|MemFree|MemYell(${memLeftVal}MB/${memYelVal}MB)" "E" 
	else
		COMM_CPrint "MEM#MDS#CMP|MemLeft/MemRed/MemYell(${memLeftVal}MB/${memRedVal}MB/${memYelVal}MB)" "I" 
	fi
	
	# 10^N *4K space block.
	#freearea=($(ALI_GetMDSMemFragInfo | sed -n -r '/Pool\[mds\.0/,/Freearea\[10/p' | grep Freearea | awk '{print $2}'))
	#for (( i=0 ;i<${#freearea};i++));do
	#done
}

function MEM_Diagnosis4OBS()
{
	local memUsedPct=""
	
	COMM_SearchLog4Module ${SNAS_MSG_LOG} "${MEM_OBS_LOG}" "MEM#OBS"
	
	memUsedPct=$(ALI_GetOBSMemInfo | grep 'PooId 0' | grep -oP 'Percent\s+\d+' |awk '{print $2}')
	COMM_NumComp $MEM_OBS_PCT $memUsedPct "ge" && ret="E" || ret="I"
	COMM_CPrint "MEM#OBS#CMP|MemUsePct/MemWarnPct(${memUsedPct}%/${MEM_OBS_PCT}%)" "${ret}"
} 

function MEM_Diagnosis4DSNV()
{
	local memFree=0
	local data=$(COMM_GetLocalTime)
	
	COMM_SearchLog4Module ${SNAS_MSG_LOG} "${MEM_DS_LOG}" "MEM#DS"
	
	memFree=$(ALI_GetOBSMemInfo | grep 'PooId 0' |grep -oP 'Free\s+\d+' | awk '{print $2}')
	COMM_NumComp  $memFree $MEM_DSNV_THRESHOLD "ge" && ret="W" || ret="I"
	COMM_CPrint "MEM#DSNV#CMP|MemFree/MemWarn(${memFree}B/${MEM_DSNV_THRESHOLD}B)" "${ret}"
}


function MEM_Diagnosis4NOFS()
{
	local Freearea=""
	
	#memUsedVal=$(ALI_GetOBSMemInfo | grep 'PooId 6' | grep -oP 'Percent\s+\d+') |awk '{print $2}'
	#COMM_NumComp $MEM_NOFS_PCT $memUsedPct "ge" && status=W || status=I
	#COMM_CPrint "MEM#NOFS#Memory UsedPct/WarnPct(${memUsedPct}%/${MEM_NOFS_PCT}%)" "${status}"

	Freearea=$(ALI_GetNOFSMemInfo | sed -r -n  '/Pool\[nofs.6\]:total size/,/Freearea\[10\]/p'  | \
	grep Freearea |awk '{totalcnt+=$NF*(2^NR);if(NR==1){area0=$NF}}END{if(totalcnt !=0 && area0/totalcnt > 0.9){printf "High:%d %d %f", area0, totalcnt, area0/totalcnt;exit 1}else{printf "Low:%d %d %f", area0,totalcnt,area0/totalcnt;exit 0}}')
	[ $? -eq  0 ] && ret=I || ret=E
	
	COMM_CPrint "MEM#NOFS#CMP|MemFreearea(${Freearea})" "${ret}"
}

function MEM_Diagnosis4DLM()
{
	local used=0
	local num=0
	
	ALI_GetDLMMemInfo | egrep -v -i  '(^$|DLM offline ctx Pool|DLM plugin Pool|DLM zone PoolDLM CCDB record POOL)' | \
	awk '{if(FNR>3){print $0}}' | while read line;do
		entry=$(echo "$line" | awk '{for(i=7;i<=NF;i++){print $i}}' |xargs)
		used=$(echo "$line"  | awk '{print $4}')
		num=$(echo "$line"   | awk '{print $3}')
		if COMM_NumComp  $num $used "ge" ;then
			COMM_CPrint "MEM#DLM#CMP|Entry/MemUsed/MemNum(${DLM_INFO##*/}/${entry}|$used/$num)" "E"
			return $E_MEM
		fi
	done
	COMM_CPrint "MEM#DLM#CMP|Entry/MemUsed/MemNum(${DLM_INFO##*/}|Normal)" "I"

	return $E_PASS
}

function MEM_Diagnosis()
{
	#MEM_Diagnosis4CA
	( MEM_Diagnosis4MDS )&
	( MEM_Diagnosis4OBS )&
	( MEM_Diagnosis4DSNV)&
	( MEM_Diagnosis4NOFS)&
	( MEM_Diagnosis4DLM )&
	wait
}
