#!/bin/bash

. ./diag_lib.sh

CA_NET_LOG='.*changing import.*RPC_ImportConnect'
FS_NET_LOG='.*Obd fail'
RPC_TMOUT_LOG='.*\[RPC.ERR\]\[Timed out tx.*KIBND_CheckTxsLocked'
RPC_NORPLY_LOG='.*\[RPC.ERR\]\[Des.*RPC_BulkAbort'
RPC_NOMEM_LOG=".*\[RPC.ERR\]\[Can't create QP: -12.*KIBND_CreateConn"

function NET_Diagnosis4CA2NV()
{
	local time=""
	

	# The map does not need to be checked for broad matching.
	( 
	time=$(COMM_GetLocalTime)
	times=$(egrep -v 'MDS|mml' $SNAS_MSG_LOG | grep  '\['"${time}${CA_NET_LOG}"  | wc -l)

	[ $times -ne 0 ] && ret="E" || ret="I"
	COMM_CPrint "NET#CA#LOG(${SNAS_MSG_LOG##*/}|${CA_NET_LOG}|${times})" "${ret}"
    	)&
		
	( 
	COMM_SearchLog4Module $SNAS_MSG_LOG "$FS_NET_LOG" "NET#OBS2NV"
 	)&
		
	wait
}

function NET_Diagnosis4RPC()
{	
	(
		COMM_SearchLog4Module $SNAS_MSG_LOG "$RPC_TMOUT_LOG" "NET#RPC"
	)&
	
	(
		COMM_SearchLog4Module $SNAS_MSG_LOG "$RPC_NORPLY_LOG" "NET#RPC"
    	)&
	
	(
		COMM_SearchLog4Module $SNAS_MSG_LOG "$RPC_NOMEM_LOG" "NET#RPC"
    	)&
	
	wait
}

function NET_Diagnosis()
{
	
	NET_Diagnosis4CA2NV
	NET_Diagnosis4RPC
}

