#!/bin/bash

. ./diag_lib.sh

# Threshold of packet(/s)
PFC_TX_PAUSE_THRESHOLD=5000
PFC_RX_PAUSE_THRESHOLD=5000
PFC_TX_PKG_THRESHOLD=512
PFC_RX_PKG_THRESHOLD=512

FILTER_HINIC='tx_packets|mac_tx_pause_num|rx_packets|mac_rx_pause_num'
FILTER_CXGB4='TxFramesOK|TxPauseFrames|RxFramesOK|RxPauseFrames'
FILTER_IXGBE='tx_packets|tx_flow_control_xoff|rx_packets|rx_flow_control_xoff'

# OFED 3.2/4.2 with different flags
FILTER_MLX5='tx_packets|pause_ctrl_tx|rx_packets|pause_ctrl_rx|tx_packets_phy|rx_packets_phy' 
FILTER_TXPKT='tx_packets|TxFramesOK'
FILTER_TXPSE='mac_tx_pause_num|TxPauseFrames|tx_flow_control_xoff|pause_ctrl_tx|tx_packets_phy'
FILTER_RXPKT='rx_packets|RxFramesOK'
FILTER_RXPSE='mac_rx_pause_num|RxPauseFrames|rx_flow_control_xoff|pause_ctrl_rx|rx_packets_phy'


function PFC_ArrayProcess()
{
	local group="$1"
	declare -a atgroup=()
	
	#TX Packet/TX Pause/RX pause/RX Pause
	atgroup[0]=$(echo "$group" | grep -oP  "(${FILTER_TXPKT}):\d+" | awk -F':' '{print $2}')
	atgroup[1]=$(echo "$group" | grep -oP  "(${FILTER_TXPSE}):\d+" | awk -F':' '{print $2}')
	atgroup[2]=$(echo "$group" | grep -oP  "(${FILTER_RXPKT}):\d+" | awk -F':' '{print $2}')
	atgroup[3]=$(echo "$group" | grep -oP  "(${FILTER_RXPSE}):\d+" | awk -F':' '{print $2}')
	
	echo "${atgroup[@]}"
}

function PFC_Diagnosis4Port()
{
	local port="$1"
	local driver="$2"
	local interval=1
	local retry=3
	local str=""
	local filter=""
	declare -a group=()
	declare -a tmpgroup=()
	local jumper=0
	
	case "$driver" in
        cxgb4)
            filter="$FILTER_CXGB4"
        ;;
        mlx5_core)
            filter="$FILTER_MLX5"
        ;;
        ixgbe)
            filter="$FILTER_IXGBE"
        ;;
        hinic)
            filter="$FILTER_HINIC"
        ;;
     	esac	

	
	tmpgroup=($($ETHTOOL_CMD -S $port | egrep "$filter" |sed -r 's/\s+//g' ))
	str="$(echo ${tmpgroup[@]})"
	tmpgroup=($(PFC_ArrayProcess "$str"))
	
	while [ $retry -gt 0 ];do	
		 sleep $interval		
		group=($($ETHTOOL_CMD -S $port | egrep "$filter" |sed -r 's/\s+//g' ))
		str="$(echo ${group[@]})"
		group=($(PFC_ArrayProcess "$str"))
		
		# TX
		if [ $((${group[3]} - ${tmpgroup[3]} )) -ge $PFC_RX_PAUSE_THRESHOLD  ] && \
		   [ $((${group[0]} - ${tmpgroup[0]} )) -lt $PFC_TX_PKG_THRESHOLD ]; then
			COMM_CPrint "PFC/FC#RX#CMP|PORT/TXPACKETS/RXPAUSE(${port}/${tmpgroup[0]}:${group[0]}/${tmpgroup[3]}:${group[3]})" "E"
			jumper=1
		else
            COMM_CPrint "PFC/FC#RX#CMP|PORT/TXPACKETS/RXPAUSE(${port}/${tmpgroup[0]}:${group[0]}/${tmpgroup[3]}:${group[3]})" "I"
		fi	
		
		# RX
		if [ $((${group[1]} - ${tmpgroup[1]} )) -ge $PFC_TX_PAUSE_THRESHOLD  ] && \
		   [ $((${group[2]} - ${tmpgroup[2]} )) -lt $PFC_RX_PKG_THRESHOLD ]; then
           COMM_CPrint "PFC/FC#TX#CMP|PORT/RXPACKETS/TXPAUSE(${port}/${tmpgroup[2]}:${group[2]}/${tmpgroup[1]}:${group[1]})" "E"
		   jumper=1
		else
			COMM_CPrint "PFC/FC#TX#CMP|PORT/RXPACKETS/TXPAUSE(${port}/${tmpgroup[2]}:${group[2]}/${tmpgroup[1]}:${group[1]})" "I"
		fi
		[ $jumper -eq 1 ] && break 

        tmpgroup=(${group[@]})
		let 'retry -=1'
	done 

	 #[ $retry -eq 0 ] && COMM_CPrint "PFC#${port}#RX/TX Pause/PFC in normal status." "I"
}

function PFC_Diagnosis()
{
	local driver=""
	
	while read port; do	
	(
		port=${port%%.*}	
		driver=$(COMM_GetPortDriver "$port")
		PFC_Diagnosis4Port "$port" "$driver"
		
	) &
	
	# Please don't use sh shell to execute this scripts, 
	# or which will report fauty information.
	done< <(COMM_GetBackendPort)   
	wait 
}



