#!/bin/bash

# ********************************************** ***************************** #
# File Name: inspect.sh
# Description: Ѳ칤.
# Input:
# Output:
# Author:
# Created:
# Function:
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #
IP_ROLE_FILE="/tmp/tmp_ip_role"
NID_ROLE_FILE="/tmp/tmp_nid_role"
RepeatTimes=(1 2 3)
LOG_FILE="/var/log/inspect.log"
Valid_IP_FILE="/tmp/tmp_value_ip$!"
version=$(cat /opt/huawei/deploy/package/version |grep "ProductVersion"|awk -F= '{print $2}')

function LOG
{
    echo [`date`][$$][$!]$@ >> $LOG_FILE
}

G_SCRIPT_PATH=""
L_TMP=$0
TMP_G_SCRIPT_PATH=$1
CHECK_ID=$3
G_SCRIPT_PATH=$(dirname "$0")

function execWithTimeout()
{
    #timeout error code
    local err_timeout=125
    #command to be executed
    local command=$1
    #timeout for executing
    local timeout=$2
    #checking interval
    local interval=$3
    #delay for kill -SIGKILL
    local delay=$4
    #execute command
    eval "${command} &"
    sub_pid=$!
    #check sub-process
    local t=$timeout
    while ((t > 0)); do
        kill -0 $sub_pid 2>/dev/null
        if [ $? -ne 0 ]; then
            #get exit code of sub-process
            wait $sub_pid
            return $?
        fi
        ((t -= interval))
        sleep $interval
    done
    #kill sub-process
    kill -15 $sub_pid 2>/dev/null && kill -0 $sub_pid 2>/dev/null || return $err_timeout
    sleep $delay
    kill -0 $sub_pid 2>/dev/null && kill -9 $sub_pid 2>/dev/null
    return $err_timeout
}


function tryagain()
{
    checkfunc=$1
    checkid=$2
    command="$checkfunc $checkid"

    LOG "[$FUNCNAME][$LINENO]try again checkid=${checkid}"
    WRITE_XML_HEADER >/dev/null
    execWithTimeout "$command" 600 2 2 2>/dev/null
    rc=$?
    WRITE_XML_TAIL $checkid >/dev/null
    if [ "$rc" -eq 125 ];then
        WRITE_XML_HEADER >/dev/null
        WRITE_XML_CMD_HEADER $checkid >/dev/null
        WRITE_XML_SUBCMD_HEADER 0
        WRITE_XML_ERROR 0 "The item is over time and The result might not complete,Please check again!" >/dev/null
        WRITE_XML_JUDGE 1 >/dev/null
        WRITE_XML_SUBCMD_TAIL >/dev/null
        WRITE_XML_CMD_TAIL >/dev/null
        WRITE_XML_TAIL $checkid >/dev/null
    fi

}


function execOneCheck()
{
    . $G_SCRIPT_PATH/inspect_lib.sh
    local starttime=0
    local endtime=0
    checkfunc=$1
    checkid=$2
    command="$checkfunc $checkid"
    starttime=$(date +%s)
    LOG "[$FUNCNAME][$LINENO]start process checkid=${checkid}"
    if [ "$command" != "" ];then
        InspectBeginTime=$(date +%s)
        WRITE_XML_HEADER >/dev/null
        execWithTimeout "$command" 1000 2 2 2>/dev/null
        rc1=$?
        grep -q "<judge>1<\/judge>" "$G_CHECK_RESULT_FILE"
        rc2=$?
        WRITE_XML_TAIL $checkid >/dev/null
        InspectEndTime=$(date +%s)
        difftime=$(($InspectEndTime - $InspectBeginTime))
        if [ "$rc1" -eq 125 ];then
            WRITE_XML_HEADER >/dev/null
            WRITE_XML_CMD_HEADER $checkid >/dev/null
            WRITE_XML_SUBCMD_HEADER 0
            WRITE_XML_ERROR 0 "The item is over time and The result might not complete,Please check again!" >/dev/null
            WRITE_XML_JUDGE 1 >/dev/null
            WRITE_XML_SUBCMD_TAIL >/dev/null
            WRITE_XML_CMD_TAIL >/dev/null
            WRITE_XML_TAIL $checkid >/dev/null
        elif [ "$rc2" -eq 0 ] && [ $difftime -lt 250 ];then
            tryagain $checkfunc $checkid
        fi
    fi
    endtime=$(date +%s)
    LOG "[$FUNCNAME][$LINENO]end process checkid=${checkid},total use time:$(expr ${endtime} - ${starttime})s"
}
function GetIDparts()
{
    hardtaskids=`cat inspect_hardware.sh |grep "1[0-9][0-9])"|awk -F\) '{print $1}'|tr -d " "`
    #ֻcheckSoftwareStatusid
    #softtaskids=`cat inspect_software.sh |sed "0,/^checkSoftwareStatus(/d" | sed "/^    rm -rf \/tmp\/tmp_valid_ip/,\$d" | grep "[2-3][0-9][0-9])"|awk -F\) '{print $1}'|tr -d " "`
    softtaskids=$( cat inspect_software.sh | sed -n '/^checkSoftwareStatus(/,/^    rm -rf \/tmp\/tmp_valid_ip/p' | grep "[2-3][0-9][0-9])"|awk -F\) '{print $1}'|tr -d " " )
    alltasks=($hardtaskids $softtaskids)
    allcounts=${#alltasks[*]}

    #Ѳз顣25Ϊһ
    loop=`expr $allcounts % 25`
    parts=`expr $allcounts / 25`

    if [ $loop -eq 0 ];then
        Maxparts=$parts
    else
        Maxparts=$((parts+1))
    fi

    for((count=0;count<$Maxparts;count++))
    do
        step=$((count*25))
        part=${alltasks[@]:$step:25}
        for item in $part
        do
            if [ $1 -eq $item ];then
                alltaskids=$part
                return 0
            fi
        done
    done
    alltaskids=$1
    return 0
}
function deltmpfile()
{
    LOG "cleanup temp file $(ls /tmp/tmpfile[0-9]*\
                                /tmp/tmpfilex[0-9]*\
                                /tmp/tmpResult*\
                                /tmp/InfoInspect/*\
                                /tmp/inspect_tmp_bak*\
                                /tmp/disktool_log*\
                                /opt/inspect/tmpfile*\
                                /opt/inspect/tmpfilex*\
                                /tmp/tmpfileRemoteResult*\
                                /tmp/tmpfileLocalResult*\
                                /tmp/inspect_downloadfile*\
                                /tmp/tmp_valid_ip*\
                                /tmp/CheckMsgFile* 2>/dev/null)"
    rm -f /tmp/tmpfileRemoteResult* > /dev/null 2>&1
    rm -f /tmp/tmpfileLocalResult* > /dev/null 2>&1
    rm -f /tmp/inspect_downloadfile* > /dev/null 2>&1
    #ɾһЩʱļЩļѲԽԽ
    rm -f /opt/inspect/tmpfile* > /dev/null 2>&1
    rm -f /opt/inspect/tmpfilex* > /dev/null 2>&1
    rm -f /tmp/tmp_valid_ip* > /dev/null 2>&1
    rm -f /tmp/tmpfile[0-9]* > /dev/null 2>&1
    rm -f /tmp/tmpfilex[0-9]* > /dev/null 2>&1
    rm -f /tmp/tmpResult* > /dev/null 2>&1
    rm -f /tmp/CheckMsgFile* > /dev/null 2>&1
    [ -d "/tmp/InfoInspect" ] && rm -rf "/tmp/InfoInspect"
    [ -f "/tmp/inspect_tmp_bak" ] && rm -rf "/tmp/inspect_tmp_bak"
    #ʹdisktool߲ʱļ
    [ -f "/tmp/disktool_log" ] && rm -f "/tmp/disktool_log"
    LOG "********delete inspect tmpfiles iRet=$?  ********"
    cd - 1>/dev/null
}

function entry_main()
{
    local sessionstarttime=0
    local sessionendtime=0
    #ɾʱļ
    rm -f /tmp/tmpfile* > /dev/null 2>&1
    rm -f $G_SCRIPT_PATH/check_thread_file* > /dev/null 2>&1
    cp -f $TMP_G_SCRIPT_PATH/inspect.sh $G_SCRIPT_PATH/
    cp -f $TMP_G_SCRIPT_PATH/inspect_expand.sh $G_SCRIPT_PATH/
    cp -f $TMP_G_SCRIPT_PATH/expand_config.conf $G_SCRIPT_PATH/
    if [ -f $TMP_G_SCRIPT_PATH/check_cfg_before_upd.zip ]; then
        cp -f $TMP_G_SCRIPT_PATH/check_cfg_before_upd.zip $G_SCRIPT_PATH/
    fi
    chmod 550 $G_SCRIPT_PATH/inspect.sh
    chmod 550 $G_SCRIPT_PATH/inspect_expand.sh
    chmod 640 $G_SCRIPT_PATH/expand_config.conf

    dos2unix $G_SCRIPT_PATH/inspect_lib.sh > /dev/null 2>&1
    dos2unix $G_SCRIPT_PATH/inspect_hardware.sh > /dev/null 2>&1
    dos2unix $G_SCRIPT_PATH/inspect_software.sh > /dev/null 2>&1
    dos2unix $G_SCRIPT_PATH/inspect_map.sh > /dev/null 2>&1

    source $G_SCRIPT_PATH/inspect_lib.sh
    source $G_SCRIPT_PATH/inspect_map.sh

    cd $G_SCRIPT_PATH 1>/dev/null


    rm -rf "$G_CHECK_RESULT_FILE"

    if [ "$CHECK_ID" != "" ]; then
        IsExist=$(ls $G_SCRIPT_PATH/inspect_expand.sh)
        if [ "${IsExist}""X" = "X" ]; then
            WRITE_XML_HEADER >/dev/null
            WRITE_XML_CMD_HEADER $checkid >/dev/null
            WRITE_XML_SUBCMD_HEADER 0
            WRITE_XML_ERROR 0 "Can not find the expand script!"
            WRITE_XML_JUDGE 1
            WRITE_XML_SUBCMD_TAIL
            WRITE_XML_CMD_TAIL
            WRITE_XML_TAIL $CHECK_ID >/dev/null
        else
            dos2unix $G_SCRIPT_PATH/inspect_expand.sh > /dev/null 2>&1
            . $G_SCRIPT_PATH/inspect_expand.sh
            [ ! -f ${IP_ROLE_FILE} ] && GetIPAndRoleFromDB
            isExpandSupported $CHECK_ID
            if [ $? -eq 0 ]; then
                execOneCheck "checkExpandItemStatus" $CHECK_ID
            else
                taskpart=`expr $CHECK_ID / 10`
                if [ $CHECK_ID -eq 119 ]; then
                    alltaskids="119 199 205 206 207 215 218 225 226 231 238 257 258 262 263 292 299"
                elif [ $CHECK_ID -eq 103 ]; then
                    alltaskids="103 100 114 115 119 127 199 204 206 213 215 218 222 225 226 228 230 231 237 240 252 286 293 299 402 403"
                else
                    GetIDparts $CHECK_ID
                fi

                entrynodecnt=0
                entrynodes=`cat /tmp/tmp_ip_role`
                for Item in $entrynodes; do
                    entrynodecnt=$((entrynodecnt+1))
                done

                if [ $entrynodecnt -le 12 ]; then
                    maxthreadcount=10
                elif [ $entrynodecnt -le 24 ];then
                    maxthreadcount=8
                elif [ $entrynodecnt -le 36 ]; then
                    maxthreadcount=6
                else
                    maxthreadcount=5
                fi
                taskinterval=3
                taskcount=0
                #alltaskids="270 $alltaskids"
		#put list to map,avoid change this shell everytime
                #allneedCheckSofeWareEx="270 273 274 275 294 311 312 313 314 315 316 317 350 351 352 353 354 355 356 357 358"
                IsCheckSoftWareEx=0
		IsCheckSoftWareItemEx=0
                threadcount=0
                sessionstarttime=$(date +%s)
                LOG "[$FUNCNAME][$LINENO]start process alltaskids=[${alltaskids}],entrynodecnt=[${entrynodecnt}]"
                for taskid in $alltaskids
                do

                    threadcount=$(ls /opt/inspect |grep "check_thread_file"|wc -l)
                    LOG "[$FUNCNAME] the counts of task is taskid=$taskid ,threadcount=$threadcount"
                    while [ $threadcount -gt $maxthreadcount ]
                    do
                        threadcount=$(ls /opt/inspect |grep "check_thread_file"|wc -l)
                        LOG "[$FUNCNAME]wait: threadcount=$threadcount,taskid=$taskid,"
                        sleep 3
                    done

                    if [[ ${allneedCheckSofeWareEx} =~ ${taskid} ]] && [ $IsCheckSoftWareEx -eq 0 ];then
                       $G_SCRIPT_PATH/inspect_software_ex.sh "${taskid}"
                       IsCheckSoftWareEx=1
                       continue
                    fi
                    #¿ܵIDҪ checkSoftwareStatusExѾ
                      echo "${allneedCheckSofeWareEx}" |grep "${taskid}" >/dev/null 2>&1
                      if [ $? -eq 0 ];then
                          IsCheckSoftWareItemEx=1
                      fi

                      if [ ${IsCheckSoftWareItemEx} -eq 1 -a ${IsCheckSoftWareEx} -eq 1 ];then
                          LOG "[$FUNCNAME] taskid=$taskid already check."
                          continue
                      fi
                    {
                        local highnum=$(echo $RANDOM)
                        local lownum=$(date +%N | cut -c 1-4)
                        export G_CHECK_RESULT_FILE="/opt/inspect/check_thread_file${highnum}${lownum}_${taskid}"
                        case $taskid in
                        1*)
                            execOneCheck "$G_SCRIPT_PATH/inspect_hardware_nomal.sh" $taskid
                        ;;
                        2*|3*|4*|5*)
                            execOneCheck "$G_SCRIPT_PATH/inspect_software_nomal.sh" $taskid
                        ;;
                        *)
                        ;;
                        esac
                    }&
                sleep $taskinterval
                done
                wait
                sessionendtime=$(date +%s)
                LOG "[$FUNCNAME][$LINENO]end process alltaskids=[${alltaskids}],block total use time:$(expr ${sessionendtime} - ${sessionstarttime})s"
            fi
        fi
    fi
    #ɾһЩʱļЩļѲԽԽ
    rm -f /opt/inspect/tmpfile* > /dev/null 2>&1
    rm -f /tmp/tmp_valid_ip* > /dev/null 2>&1
    LOG "********delete inspect tmpfiles iRet=$?  ********"


    cd - 1>/dev/null
}

. $G_SCRIPT_PATH/inspect_map.sh

#preinspect.pyãÿѲ쿪ʼǰһΣɺIPбļ
if [ "$TMP_G_SCRIPT_PATH" == "ipcfg" ];then
    #ϴѲļ
    rm -f /opt/inspect/check_id_file*
    rm -f /tmp/check_result_file*
    rm -f /tmp/check_thread_file*
    rm -f /tmp/check_thread_count*
    GetIPAndRoleFromDB
    exit 0
fi
#ѲѼ豸Ϣ:Ĳinspectcollect,ʾѼ
if [ "$TMP_G_SCRIPT_PATH" == "inspectcollect" ];then
    LOG "inspect_entry.sh start inspectcollect ********"
    sh /opt/inspect/inspect_collect_systeminfo.sh > /dev/null 2>&1
    deltmpfile
    exit 0
fi

checkfile="/opt/inspect/check_id_file$CHECK_ID"
needcheck=1

if [ -f "$checkfile" ];then
    curttime="`date +%s`"
    filedate="`stat $checkfile | grep -i Modify |grep -i Modify | awk -F. '{print $1}' | awk '{print $2" "$3}'`"
    filetime="`date -d "$filedate" +%s`"
    passtime=`expr $curttime - $filetime`
    if [ $passtime -le 2000 ];then
        needcheck=0
    fi
fi

if [ -f "$G_SCRIPT_PATH/inspect_expand.sh" ];then
    . $G_SCRIPT_PATH/inspect_expand.sh
    isExpandSupported $CHECK_ID
    if [ $? -eq 0 ]; then
        needcheck=1
    fi
fi
if [ $needcheck -eq 1 ];then
    entry_main
fi
# checkfileʹúļ´ʹ
cat $checkfile
LOG "User end inspect item ${CHECK_ID}."
exit 0

