#!/bin/bash

source /opt/huawei/snas/script/inspect_mml/certUpdateLib.sh

function main()
{
    local param=$1
    local forceNoDefault="NO"
    local forceNoOuttime="NO"
    local cert=""
    local key=""
    local certList=$(GetCertList)

    while [[ "${param}" = "--force" ]]; do
        forceNoDefault="YES"
        forceNoOuttime="YES"
        shift
        param=$1
    done
    if [[ "${param}" != "" && "${certList}" =~ "${param}" ]]; then
        cert="${param}"
        if [ "$2" != "" ]; then
            key=$(encode $2)
        fi
    else
        echo -e "Usage:\n\
    certUpdate.sh [--force] cert-name private-key --Update appointed cert[Management|emailAlarm|emailPass|emailEmui|DeployServer|DeviceManager|ToolkitHttps];"
        return 0
    fi

    GetIPAndRoleFromDB
    GetAndSaveCertStatus
    if [ $? -ne 0 ]; then
        echo "Failed to get certs status."
        return 1
    fi
    updateSingleCert ${forceNoDefault} ${forceNoOuttime} ${cert} "${key}"
}

main $@
