#!/bin/sh
set +x
ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh
#ű־ֻڵӡ
LOG_FILE="/var/log/collect/master.log"
SCRIPTNAME=$(basename $0)

function singleThread()
{
    local numThread1=$(ps -ef|grep -v grep|grep ${SCRIPTNAME} |grep sudo|wc -l)
    local numThread2=$(ps -ef|grep -v grep|grep ${SCRIPTNAME} |grep "/bin/sh"|wc -l)
    local grepinfo=$(ps -ef|grep -v grep|grep ${SCRIPTNAME})
    if [ "$numThread1" -gt 1 -o "$numThread2" -gt 3 ]; then
        log "[$FUNCNAME][$LINENO]forbid multiple users to collect informations,numThread1=${numThread1},numThread2=${numThread2},name=${SCRIPTNAME},grepinfo:$grepinfo"
        echo "multi.user.collect"
        return $RET_ERROR
    fi
    
    return $RET_OK
}

##########################################################
#ڵѯȺ˵нڵĴϢ
#룺
#      
#
#ʵqueryDiskLog
##########################################################
function queryDiskLog()
{
    local tmpinfo=""
    local tmpfie=""
    local nodename=""
    local nodeid=""
    local slotid=""
    local vendor=""
    local SN=""
    local diskType=""
    local Model=""
    local tmptype=""
    local tmpdiskfile="/tmp/tmp_disklogfile$$"
    local tmpmmlfile="/tmp/tmp_nodename_mmlfile$$"

    tmpinfo="$(/usr/local/bin/MmlBatch 4016 "cm diskinfo")"
    /usr/local/bin/MmlBatch 4016 "cm node" | sed -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g'| grep "Node_ID" >${tmpmmlfile} 2>/dev/null
    tmpfie=$(echo "${tmpinfo}" | grep -Po "/tmp/snas_debug[0-9]*")
    #ڵʱʱļ
    if [ "${tmpfie}X" != "X" ];then
        tmpinfo="$(cat ${tmpfie})"
    fi
    
    #״̬Ϊ0(δ֪) 4(λ)඼ʾ (Cһ)
    echo "${tmpinfo}" | grep "Disk_ID" |grep -v "Running_Status: 4" | grep -v "Running_Status: 0" | sed -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' > ${tmpdiskfile}
    #node,nodeid,slotid,vendor,SN,diskType,Modelʽ
    awk -F '\\|\\|' '
    function getDiskType(type)
    {
        diskTypeName[0] = "FC"
        diskTypeName[1] = "SAS"
        diskTypeName[2] = "SATA"
        diskTypeName[3] = "SAS_SSD"
        diskTypeName[4] = "NL_SAS"
        diskTypeName[5] = "SLC_SSD"
        diskTypeName[6] = "MLC_SSD"
        diskTypeName[15] = "SMR_SATA"
        diskTypeName[16] = "NVME_SSD"
        diskTypeName[17] = "SATA_SSD"
        if (type>=0&&type<=17)
            return diskTypeName[type]
        else
            return "NULL"
    }
    BEGIN {namelist[0]="";}
    {
       if (NR==FNR)
       {
        split($1,aid," ")
        split($2,aname," ")
        namelist[aid[2]]=aname[2]
        delete aid
        delete aname
       }
       
       if(NR!=FNR)
       {
           split($2,aid," ")
           split($3,aslotid," ")
           split($12,avendor," ")
           split($13,aSN," ")
           split($6,atype," ")
           split($10,amodel," ")
           nodename=namelist[aid[2]]
           nodeid=aid[2]
           slotid=aslotid[2]
           vendor=avendor[2]
           SN=aSN[2]
           diskType=getDiskType(atype[2])
           Model=amodel[2]
           printf("node,%s,%s,%s,%s,%s,%s,%s\n",nodename,nodeid,slotid,vendor,SN,diskType,Model)
           delete aid
           delete aslotid
           delete avendor
           delete aSN
           delete atype
           delete amodel
       }

    }' ${tmpmmlfile} ${tmpdiskfile}
    
    [ -f "${tmpdiskfile}" ] && rm -f "${tmpdiskfile}"
    [ -f "${tmpmmlfile}" ] && rm -f "${tmpmmlfile}"
    
    return $RET_OK
}

#DiskLog
function DiskLogParamCheck()
{
    local parmErrFlag=0
    local tmpinfo=""
    local diskfile="$1"
    if [ "${diskfile}X" != "${G_DISKLOG_PARM_FILE}X" ] || [ ! -s "${diskfile}" ];then
        log "[$FUNCNAME][$LINENO]disk param err,diskfile=(${diskfile})"
        return $RET_ERROR
    fi    
    
    dos2unix ${diskfile} >/dev/null 2>&1
    #У飬ÿһеĲʽ(ڵID1=SN1:SN2:SN3 )Կոβ
    set_ifs
    for line in $(cat "${diskfile}");do
        echo "${line}" | egrep  "^[-_a-z0-9A-Z.]{1,127}=[^\s]{1,64}(:[^\s]{1,64})* $" >/dev/null
        if [ $? -ne 0 ];then
            parmErrFlag=1
            tmpinfo="${line}"
            break
        fi
    done
    restore_ifs
    
    if [ ${parmErrFlag} -ne 0 ];then
        log "[$FUNCNAME][$LINENO]disk param err,line info=(${tmpinfo})"
        return $RET_ERROR
    fi
    return $RET_OK
}

##########################################################
#Ϣ
#룺Param1:ڵбļ
#      
#
#ʵgetDiskLogInfo
##########################################################
function getDiskLogInfo()
{
    local diskLogPath="/var/log/cm/DiskLog"  
    local ValidIP=""
    local allip=""
    local command=""
    local exec_taskid="getDiskLogInfo"
    local pid=$$
    local remotefile="/var/log/cm/DiskLog.tar.gz"
    local nodeid=""
    local nodeip=""
    local localdisklist=""
    local iRet=0
    local filename="$1"
    local nodenamelist=""
    local nodename=""
    local nodenum=0
    local resnum=0
    local tmpinfo=""
    local diskList=""
    local totalNum=0 #` cat ${filename} | wc -l `
    local cnt=0
    local percent=0
    local sumValue=0
    local process=""
    local curPercent=0
    local unfinished=''
    local iRet=$RET_OK
    
    #У鴫ļǷϷ
    DiskLogParamCheck "${filename}"
    if [ $? -ne 0 ];then
        log "[$FUNCNAME][$LINENO]coll.param.error"
        echo "coll.param.error"
        return $RET_ERROR
    fi
    
    if [ -d "/var/log/cm/" ];then
        rm -rf /var/log/cm/*
    fi
    mkdir -p "${diskLogPath}"
    

    > ${VALID_IP_FILE}
    > ${CollectProgressFile} 2>/dev/null
    chmod 650 ${CollectProgressFile}
    updateProgress ${CollectProgressFile} "CollectProgress:0"
    
    #·ӦĽڵִ
    diskList="$(cat ${filename})"
    set_ifs
    for item in ${diskList};do
        nodeid=$(echo "${item}" | awk -F'=' '{print $1}')
        localdisklist=$(echo "${item}" | awk -F'=' '{print $2}')
        command="${G_COLL_SCRIPT_PATH}/datacollect_Disklog.sh collect ${localdisklist}"
        nodeip=$(get_node_backnet_ip "${nodeid}")
        let nodenum=nodenum+1
        if [ "${nodeip}X" == "X" ];then
            totalNum=$[totalNum-1]
            log "[$FUNCNAME][$LINENO]get node ip fail,nodeid=${nodeid}"
            continue
        fi
        #72̣ÿ̼2
        remote_exec_async ${nodeip} ${exec_taskid} 10800 "${command}"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            totalNum=$[totalNum-1]
            log "[$FUNCNAME][$LINENO] Node: $nodeip||Error: ${iRet}"
            continue
        fi
        echo "${nodeip}" >> ${VALID_IP_FILE}
    done
    restore_ifs
    allip=$(cat ${VALID_IP_FILE})
    log "[$FUNCNAME][$LINENO]:allip:(${allip})" 
    ValidIP="${allip}"
    totalNum=$(cat ${VALID_IP_FILE} | wc -l)
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            #1ȴlocalexec·,2̫Ƶ
            sleep 5
            #Ϊ100%֮ļ,н
            for time in ${RepeatTimes[*]}; do
                proresult=`/opt/huawei/deploy/script/localexec.py progress $Item ${pid}${exec_taskid}`
                iRet=$?
                log "[$FUNCNAME][$LINENO]:IP:$Item,return:$iRet,time:$time"
                if [ $iRet -eq 101 -o $iRet -eq 107 ]; then
                    sleep 10
                else
                    process=`echo $proresult | awk '{print $1}'`
                    if [ "$process" != "" ] && [ "$process" != "0" ];then
                        break
                    fi
                    sleep 5
                fi
            done

            log "[$FUNCNAME][$LINENO]get data IP:$Item,iRet=${iRet},proresult:$proresult"
            process=`echo $proresult | awk '{print $1}'`
            errno=`echo $proresult | awk '{print $4}'`

            if [[ "${iRet}" -eq 0 && "$process" != "100" && "$process" != "" ]];then
                if [ "$process" == "0" ];then
                    percent=$(expr $[percent+1])
                else
                    sumValue=$[sumValue+process]
                    curPercent=$(expr $[sumValue*90/100] / $totalNum) #ΰٷֱΪ50% ==50/100
                    if [ $curPercent -gt $percent ];then
                        percent=$curPercent
                    fi
                fi
                if [ $percent -gt 90 ];then
                    percent=90
                fi
                updateProgress ${CollectProgressFile} "CollectProgress:${percent}"
                
                echo "$Item" >> ${VALID_IP_FILE}
                continue;
            elif [[ "${iRet}" -ne 0 ]] || ([[ $errno -ne 0 ]] && [[ $errno -ne 2 ]]) || [[ "$process" == "" ]];then
                log "[$FUNCNAME][$LINENO]get data from $Item fail"
                continue;
            fi
            cnt=$[cnt+1] #ɵĽڵͳ
            sumValue=$[sumValue+process]
            curPercent=$(expr $[sumValue*90/100] / $totalNum) #ΰٷֱΪ50% ==50/100
            if [ $curPercent -gt $percent ];then
                percent=$curPercent
            fi
            if [ $percent -gt 90 ];then
                percent=90
            fi
            updateProgress ${CollectProgressFile} "CollectProgress:${percent}"
            
            nodeName=$(get_node_hostname_from_db "${Item}")
            mkdir -p ${diskLogPath}/${nodeName}
            unfinished="$unfinished"" $(echo "$proresult" | cut -d ' ' -f 5-)"
            remote_download ${Item} "${diskLogPath}/${nodeName}/DiskLog.tar.gz" "${remotefile}"
            iRet=$?
            if [ $iRet -ne 0 ];then
                log "[$FUNCNAME][$LINENO]iRet=${iRet},ip:${Item},down err"
                continue
            fi
        done
        sumValue=$[cnt*100] #ɵĽڵ ڶβٲѯ  processΪ100%
        ValidIP=$(cat ${VALID_IP_FILE})
    done
    
    #Ƿռ
    tmpinfo="$(/usr/local/bin/MmlBatch 4016 "cm node" | grep Node_ID)"
    for item in ${allip};do
        nodeName=$(echo "${tmpinfo}" | grep Node_ID |grep -w "${item}" | awk -F'\\|\\|' '{print $2}' | awk '{print $2}')
        if [ ! -s "${diskLogPath}/${nodeName}/DiskLog.tar.gz" ];then
            log "[$FUNCNAME][$LINENO]coll disk error,nodeName=${nodeName},item=${item}"
            continue
        fi
        nodenamelist="${nodeName} ${nodenamelist}"
        let resnum=resnum+1
    done
    
    if [ ${resnum} -eq 0 ];then
        log "[$FUNCNAME][$LINENO]Collect Disk log err resnum=$resnum. ret($RET_ERROR)"
        echo "coll.disk.error"
        iRet=$RET_ERROR
    elif [ ${resnum} -gt 0 ] && [ ${resnum} -lt ${nodenum} ];then
        log "[$FUNCNAME][$LINENO]Collect Disk log info from (${nodenamelist}) Success,nodenum=${nodenum},resnum=${resnum}. ret($RET_INCOMPLETE)"
        echo "${ErrorInfoFlag}coll.node.partially.success:${nodenamelist}"
        iRet=$RET_INCOMPLETE
    fi
    unfinished=$(echo "$unfinished" | tr -s ' ')
    if [[ -n "$unfinished" ]] && [[ "$unfinished" != ' ' ]]; then
        log "[$FUNCNAME][$LINENO]The information collection on some hard drives is not complete, and their SN are: ${unfinished}. ret($RET_INCOMPLETE)"
        echo "${ErrorInfoFlag}coll.disk.partially.success:${unfinished}"
        iRet=$RET_INCOMPLETE
    fi

    #ɺѹɰDiskLog.zip,˴ɵļҪsmartKitһõһ
    cd /var/log/cm/ 
    zip -qr "${G_DISKLOG_PATH}" ./* >/dev/null 2>&1
    [ -f "${VALID_IP_FILE}" ] && rm -f "${VALID_IP_FILE}"
    [ -f "${G_DISKLOG_PARM_FILE}" ] && rm -f "${G_DISKLOG_PARM_FILE}"
    [ -d "${diskLogPath}" ] && rm -rf "${diskLogPath}"
    chown omuser:$OMGROUP -R /var/log/cm
    updateProgress ${CollectProgressFile} "CollectProgress:100"
    log "[$FUNCNAME][$LINENO]proc DiskLog done."
    return $iRet
}

##########################################################
#Ϣ
#룺Param1:coll ռϢ   query:ѯȺϢ
#      Param2:̲ϢʽΪ(ڵ:)
#
#ʵcollDiskLog "coll"
##########################################################
function collDiskLog()
{
    local action="$1"
    local diskfile="$2"
    local echo_text=''
    local iRet=$RET_OK
    
    if [ "${action}" == "collect" ];then
        #ռ־Ϣ
        echo_text=$(getDiskLogInfo "${diskfile}")
        iRet=$?
        log "[$FUNCNAME][$LINENO]collDiskLog echo ($echo_text)"
        echo "$echo_text"
    elif [ "${action}" == "query" ];then
        #ѯϢ
        queryDiskLog
    else
        #pythonĴԴļ
        echo "coll.param.error"
        return $RET_ERROR
    fi
    
    return $iRet
}

function CollectMain()
{
    local moduleType="$1"
    local action="$2"
    local echo_text=''
    local iRet=$RET_OK
    
    singleThread
    if [ $? -ne $RET_OK ];then
        return $RET_ERROR
    fi
    
    if [ ! -d "/var/log/collect" ];then
        mkdir -p "/var/log/collect"
    fi
    log "[$FUNCNAME][$LINENO]start moduleType=${moduleType},action=$action,other=$3"
    if [ "${moduleType}" != "DiskLog" ];then
        #pythonĴԴļ
        echo "coll.param.error"
        return $RET_ERROR
    fi
    
    echo_text=$(collDiskLog "${action}" "$3")
    iRet=$?
    log "[$FUNCNAME][$LINENO]CollectMain echo ($echo_text)"
    echo "$echo_text"
    return $iRet
}

tmpstr=$(CollectMain "$1" "$2" "$3")
iRet=$?
log "[$FUNCNAME][$LINENO]Just before ModuleEntry exits. ret($iRet) ercho($tmpstr)"
echo "$tmpstr"
exit $iRet
