#!/bin/bash
set +x

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh

sub_path="${CMLogDir}Disklog"
normal_path="${sub_path}/Normal/"
abnormal_path="${sub_path}/Abnormal/"

G_DISK_NAMESN=${sub_path}/diskname_sn
G_DISK_MML_NAMESN=${sub_path}/diskname_mml_sn
. /opt/node_type_recognize.sh
. /opt/install_os_common_func.sh
start_time=$(date +%s) # seconds since epoch when start
time_timeout=10200
disktoolcmd=()

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

# 获取当前环境是否是全SAS SSD节点, 参考c代码LNM_GetAllSSDFlag
function IsAllSSDNode()
{
    TMP_NODE_INFO_FILE="/tmp/node_info.txt"
    /usr/local/bin/MmlBatch 4016 "cm node"> $TMP_NODE_INFO_FILE 2>&1
    backIP=$(grep "/opt/huawei/snas/sbin/mml" $TMP_NODE_INFO_FILE | awk -F' ' '{print $3}')
    log "[$FUNCNAME][$LINENO]backIP=${backIP}"
    
    OLD_IFS="$IFS"
    IFS=$'\n'
    nodeInfo=$(grep "Node_ID" $TMP_NODE_INFO_FILE | sed 's/^ *//g'|sed "/^$/d")
    rm -rf $TMP_NODE_INFO_FILE
    # Function_Type从0开始，-1表示没有查找到真正的Function_Type
    devFunType=-1

    for line in $nodeInfo
    do
        currentNodeInfo=$(echo "${line}" | grep "${backIP}")
        if [ "${currentNodeInfo}" = "" ];then
            continue
        else
            devFunType=$(echo "$line" |grep -Po '(?<=Function_Type: )[0-9]*' |tr -d ' ')
            break
        fi
    done
    IFS="$OLD_IFS"

    # NODE_S25A              = 30, /* V3全闪 */
    # NODE_S25B              = 31,
    # NODE_9000_S25X         = 41, /* 2288H V5-2U25全闪存 */
    # NODE_9000_S12A         = 42,
    # NODE_9000_S25A         = 43, /* Taishan 2280 V2-2U25全闪 */
    # NODE_9000_S36A         = 45, /* TaiShan 5280 V2-4U36 全闪 */
    if [ "${devFunType}" -eq 30 ] || [ "${devFunType}" -eq 31 ] || [ "${devFunType}" -eq 41 ] || [ "${devFunType}" -eq 42 ] || [ "${devFunType}" -eq 43 ] || [ "${devFunType}" -eq 45 ];then
        log "[$FUNCNAME][$LINENO]Function_Type:${devFunType}, current node's disk should be all ssd."
        return 0
    else
        log "[$FUNCNAME][$LINENO]Function_Type:${devFunType}, current node's disk should not be all ssd."
        return 1
    fi
}

#获取盘符和SN号，T3000用disktool，服务器用lsscsi和disktool组合
function Get_DISKMap()
{
    local isRH=0
    local isTS=0
    
    set_ifs
    diskDevice=$(/usr/local/bin/disktool -s)
    for line in $diskDevice;do
        diskname=$(echo $line | awk '{printf $1}')
    #排除sda，sdb的系统盘
        echo "$diskname" | grep "/dev/sd-" >/dev/null 2>&1
        if [ $? -eq 0 ];then
            if [ "$diskname" != "/dev/sd-56a" -a "$diskname" != "/dev/sd-57a" ];then
                disk_SN=$(/usr/local/bin/disktool -f i $diskname | grep "Serial Number" | tr -d " " | awk -F":" '{print $2}')
                echo "$diskname $disk_SN" >>$G_DISK_NAMESN
            fi
        else
            log "[$FUNCNAME][$LINENO]$diskname is system disk ,no need to collect."
        fi
    done
    restore_ifs
    
    # NVME需要单独查询
    IsRHV5Node
    isRHV5Node=$?
    IsAllSSDNode
    isAllSSDNode=$?

    if ([ ${isRHV5Node} -eq 0 ] || [ ${isTS} -eq 0 ]) && [ ${isAllSSDNode} -ne 0 ];then
        TMP_NVME_INFO_FILE="/tmp/nvmeinfo.txt"
        # NVME 指定槽位是44~47，最多4块，但是盘符会飘，参数c代码CM_Dev_DiskGetDiskInfo4Nvme遍历0~7
        for i in $(seq 0 7)
        do
            nvme id-ctrl "/dev/nvme${i}" > $TMP_NVME_INFO_FILE 2>&1
            if [ $? -ne 0 ]; then
                continue
            fi

            diskname="/dev/nvme${i}n1"
            disk_SN=$(grep 'sn' "$TMP_NVME_INFO_FILE" | awk '{print $3}')
            log "[$FUNCNAME][$LINENO]i=${i}, find nvme, diskname=${diskname}, disk_SN=${disk_SN}."
            echo "$diskname $disk_SN" >> "$G_DISK_NAMESN"
        done
        
        rm "${TMP_NVME_INFO_FILE}"
    fi
}
#通过cm localdiskinfo show来查询本节点所以正常磁盘的信息
function Get_DISK_MML_MAP()
{
    rm -f /tmp/tmpfilelocaldiskinfo
    /usr/local/bin/MmlBatch 4016 "cm localdiskinfo show" >/dev/null 2>&1
    for i in $(seq 1 15)
    do
        sleep 10
        if [ -f "/tmp/tmpfilelocaldiskinfo" ];then
            break
        else
            log "[$FUNCNAME][$LINENO]times($i) no file(/tmp/tmpfilelocaldiskinfo)."
        fi
    done
    #除了状态为0(未知) 和4(不在位)，其余都显示 (与C代码一致)
    if [ -L $G_DISK_MML_NAMESN ]
    then
        log "[$FUNCNAME][$LINENO]There are security risks, exit -1"
        rm -rf $G_DISK_MML_NAMESN
    fi
    grep -v "Running_Status: 4" /tmp/tmpfilelocaldiskinfo | grep -v "Running_Status: 0"  >$G_DISK_MML_NAMESN
}

get_disk_MANUFACT()
{
    local diskManu=$1

    if [ -n "$(echo "$diskManu" | grep -i "Toshiba")" ]; then
        echo "TB"
        return
    elif [ -n "$(echo "$diskManu" | grep -i "Seagate")" ]; then
        echo "ST"
        return
    elif [ -n "$(echo "$diskManu" | grep -iw "WD")" ]; then
        echo "WD"
        return
    elif [ -n "$(echo "$diskManu" | grep -i "HUASY")" -o -n "$(echo "$diskManu" | grep -i "HUASAI")" -o -n "$(echo "$diskManu" | grep -i "HUAWEI")" ]; then
        echo "HW"
        return
    elif [ -n "$(echo "$diskManu" | grep -i "Hitachi")" -o -n "$(echo "$diskManu" | grep -i "HGST")" -o -n "$(echo "$diskManu" | grep -iw "WDC")" ]; then
        echo "HG"
        return
    elif [ -n "$(echo "$diskManu" | grep -i "SanDisk")" -o -n "$(echo "$diskManu" | grep -i "Samsung")" ]; then
        echo "SD"
        return
    fi

    echo "UNKNOWN"
    return
}

get_disk_MANUFACT_COMM()
{
    local diskManu=$1
    local diskname=$2
    local diskType=$3
    local diskWwn
    #首先匹配厂商字段
    if [ "$diskType" = "SATA" -o "$diskType" = "SMR_SATA" ];then
        diskWwn=`smartctl -a $diskname |grep -w WWN |awk '{print $6}'`
        if [ "X${diskWwn}" == "X000039" ]; then
            echo "TB"
            return
        elif [ "X${diskWwn}" == "X000c50" ]; then
            echo "ST"
            return
        elif [ "X${diskWwn}" == "X0014ee" ]; then
            echo "WD"
            return
        elif [ "X${diskWwn}" == "X000cca" ]; then
            echo "HG"
            return
        fi
    else
        echo `get_disk_MANUFACT $diskManu`
        return
    fi

    echo "UNKNOWN"
    return
}
function getBlockSize
{
    diskname=$1
    /usr/local/bin/disktool -f C $diskname |awk -F= '{print $2}' |awk -F'.' '{print $1}'
}

function collect_HDD()
{
    local diskManu=$1
    local diskname=$2
    local diskType=$3
    local disksn=$4
    local is3416Card
    local blocksize
    is3416SasCard
    is3416Card=$?
    disktoolcmd=()

    if [ "$diskType" = "SATA" -o "$diskType" = "SMR_SATA" ] && [ ${is3416Card} -eq 0 ];then
        blocksize=$(getBlockSize "$diskname")
        if [ "X${blocksize}" = "X512" ];then
            log "[$FUNCNAME][$LINENO]no need collect. $diskManu,$diskname,$diskType,$disksn, is3416Card=${is3416Card}, blocksize=${blocksize}"
            return
        fi
    fi
    log "[$FUNCNAME][$LINENO]:$diskManu,$diskname,$diskType,$disksn"
    mkdir ${normal_path}${disksn}
    cd ${normal_path}${disksn}
    diskManu=$(get_disk_MANUFACT_COMM "$diskManu" "${diskname}" "${diskType}")
    if [ "$diskManu" = "ST" ];then
        if [ "$diskType" = "SATA" -o "$diskType" = "SMR_SATA" ];then
            disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -S M $diskname")
            disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -S U $diskname")
        else
            disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -A m $diskname")
            disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -A u $diskname")
        fi
    elif [ "$diskManu" = "HG" ];then
        if [ "$diskType" = "SATA" -o "$diskType" = "SMR_SATA" ];then
            disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -S H $diskname")
        else
            disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -A E $diskname")
        fi
    elif [ "$diskManu" = "WD" ];then
            disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -S R $diskname")
    elif [ "$diskManu" = "TB" ];then
        if [ "$diskType" = "SATA" -o "$diskType" = "SMR_SATA" ];then
            disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -A T $diskname")
        else
            disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -A F $diskname")
        fi
    else
        log "[$FUNCNAME][$LINENO]no this type.diskManu=${diskManu}"
    fi
}

function collect_SSD()
{
    local diskManu=$1
    local diskModel=$2
    local diskname=$3
    local disksn=$4
    disktoolcmd=()
    diskManu=$(get_disk_MANUFACT "$diskManu")
    log "[$FUNCNAME][$LINENO]$diskManu,$diskModel,$diskname,$disksn"
    mkdir ${normal_path}${disksn}
    cd ${normal_path}${disksn}
    if [ "$diskManu" = "HW" ];then
        if [ "$diskType" = "NVME_SSD" ];then
            disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -f I -b NVME -z HW $diskname")
        fi
        # ${disksn^^}： convert all lowercase characters in disksn to uppercase.
        disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn^^}_log.txt -A o -z log $diskname")
        disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn^^}_log2.txt -A o -z log2 $diskname")
        disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn^^}_log3.txt -A o -z log3 $diskname")
        disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn^^}_log4.txt -A o -z log4 $diskname")
        echo "$diskModel" |grep "HSSD-D5"  >/dev/null 2>&1
        if [ $? -eq 0 ];then
            disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn^^}_ExtendLog.txt  -A o -z getExtendLog $diskname")
        fi
    elif [ "$diskManu" = "HG" ];then
        #日立SSD
        disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -A E $diskname")
    elif [ "$diskManu" = "SD" ];then
        #sandisk SSD
        disktoolcmd+=("/usr/local/bin/disktool -D ${normal_path}${disksn} -A D $diskname")
    else
        log "[$FUNCNAME][$LINENO]no this SSD,diskManu=${diskManu}"
    fi
}



#查询本地节点的磁盘信息
function getLocalDiskLogInfo()
{
    local filename="/var/log/cm/DiskLog.tar.gz"
    local DataCollectFile="datacollect_DiskLog$$"
    local disklist="$(echo "$1" | sed 's/:/ /g')"
    local disklist_cp="$disklist"
    local diskSn=""
    local diskname=""
    local diskinfo=""
    local disktype=""
    local diskModel=""
    local diskManu=""
    local tmptype=""
    local diskmmlino=""
    local thread_count=0
    local time_left=0
    local finished='no'
    local iRet=0
    local disktool_msg=''
    local workingdir
    local allSuccess

    if [ -d "${CMLogDir}" ];then
        rm -rf ${CMLogDir}
    fi
    mkdir -p "${sub_path}"
    mkdir -p "${normal_path}"
    mkdir -p "${abnormal_path}"
    
    log "[$FUNCNAME][$LINENO]start collect Disklog"
    Get_DISKMap
    Get_DISK_MML_MAP
    >/tmp/$DataCollectFile
    
    #保存磁盘盘符和sn
    diskinfo="$(cat $G_DISK_NAMESN)"
    diskmmlino="$(cat ${G_DISK_MML_NAMESN})"
    
    for item in ${disklist}
    do
        diskname=$(echo "${diskinfo}" | grep -w "${item}" | awk '{print $1}')
        if [ "${diskname}X" == "X" ];then
            log "[$FUNCNAME][$LINENO]miss sn=${item}."
        fi
        disksn=${item}
        tmptype=$(echo "${diskmmlino}" | grep -w "${disksn}" | awk -F'\\|\\|' '{print $6}' | awk '{print $2}')
        disktype=$(MapDiskType $tmptype)
        diskModel=$(echo "${diskmmlino}" | grep -w "${disksn}" | awk -F'\\|\\|' '{print $10}' | awk '{print $2}')
        diskManu=$(echo "${diskmmlino}" | grep -w "${disksn}" | awk -F'\\|\\|' '{print $12}' | awk '{print $2}')
        echo "$disksn begin" >>/tmp/${DataCollectFile}
        echo "$disktype" |grep "SSD" >/dev/null 2>&1
        # ${disksn,,}： convert all uppercase characters in disksn to lowercase.
        if [ $? -eq 0 ];then
            collect_SSD "$diskManu" "$diskModel" "$diskname" "${disksn,,}"
        else
            collect_HDD "$diskManu" "$diskname" "$disktype" "${disksn,,}"
        fi
        if [[ ${#disktoolcmd[@]} -eq 0 ]]; then
            continue
        fi
        time_left=$[time_timeout-($(date +%s)-start_time)]
        if [[ $time_left -le 0 ]]; then
            log "[$FUNCNAME][$LINENO]There is no more time left."
            break
        fi
        allSuccess=0
        for commed in "${disktoolcmd[@]}"
        do
            disktool_msg=$( (/usr/bin/timeout $time_left ${commed}) 2>&1)
            iRet=$?
            if [[ $iRet == 0 ]]; then
                if [[ "$disktool_msg" =~ '-h for help!' ]]; then
                    allSuccess=1
                    log "[$FUNCNAME][$LINENO]collect $disksn error. ERRMSG($disktool_msg). CMD(/usr/bin/timeout $time_left ${commed})"
                elif [[ -z "$(ls -A ${normal_path}${disksn,,})" ]]; then
                    allSuccess=1
                    log "[$FUNCNAME][$LINENO]collect $disksn error. directory(${normal_path}${disksn}) is empty."
                fi
            elif [[ $iRet == 124 ]]; then
                allSuccess=1
                log "[$FUNCNAME][$LINENO]collect $disksn timeout."
                break
            else
                allSuccess=1
                log "[$FUNCNAME][$LINENO]collect $disksn error. ERRCODE($iRet). CMD(/usr/bin/timeout $time_left ${commed})"
            fi
        done
        if [[ ${allSuccess} -eq 0 ]]; then
            disklist_cp=$(echo "$disklist_cp" | sed "s/\b${disksn}\b//g" | tr -s ' ')
            log "[$FUNCNAME][$LINENO]collect $disksn end."
        fi
        
        [[ -d "${normal_path}${disksn,,}" ]] && mv "${normal_path}${disksn,,}" "${normal_path}${disksn}"
        time_left=$[time_timeout-($(date +%s)-start_time)]
        if [[ $time_left -le 120 ]]; then
            log "[$FUNCNAME][$LINENO]There is no more time left."
            break
        fi
        #收集时每个磁盘间隔120s，防止影响业务
        sleep 120
    done 
    
    rm -rf /tmp/${DataCollectFile}
    rm -rf $G_DISK_MML_NAMESN
    rm -rf $G_DISK_NAMESN

    #收集故障盘的日志
    cd ${sub_path}
    cp -fr /OSM/coffer_data/fault_disklog/* $abnormal_path >/dev/null 2>&1
    tar zcvf ${filename} ./* >/dev/null 2>&1
    if [ -d "${CMLogDir}" ];then
        rm -rf  ${CMLogDir}
    fi
    log "[$FUNCNAME][$LINENO]end collect Disklog"
    if [[ -n "$disklist_cp" ]]; then
        echo "$disklist_cp"
        return $RET_INCOMPLETE
    else
        return $RET_OK
    fi
}

function collect_log()
{
    local action="$1"
    local disklist=""
    local remianlist=""
    local iRet=$RET_OK
    if [ "${action}" == "collect" ];then
        #收集磁盘日志信息
        disklist="$2"
        remianlist=$(getLocalDiskLogInfo "${disklist}")
        iRet=$?
    else
        log "[$FUNCNAME][$LINENO]DiskLog param error"
    fi
    echo "$remianlist"
    return $iRet
}

if [ ! -d "$(dirname ${LOG_FILE})" ];then
    mkdir -p $(dirname ${LOG_FILE})
fi 

remianlist=$(collect_log "$1" "$2")
iRet=$?
echo "$remianlist"
exit $iRet


