#!/bin/bash

tmp_file="/tmp/tmpfile$!CheckKeyFileAuthority"
tmp_permission="/tmp/tmpfile$!Permission"
LOG_FILE="/var/log/inspect.log"
function LOG
{
   time=$(date)
   echo [${time}][$!]$@ >> $LOG_FILE
}
function checkcontext()
{
    context=$(cat $tmp_file)
    for line in $context;do
        echo $line |grep Uid
        if [ $? -eq 0 ];then
            continue
        fi
        messageFile=$(echo $line | awk -F ":" '{print $2}')
        #cat $tmp_permission | grep "$messageFile$" | grep -v "\>$messageFile" >/dev/null
        cat $tmp_permission | grep -v ">$messageFile" |grep -w "$messageFile$" >/dev/null
        if [ $? -ne 0 ];then
            LOG "[$FUNCNAME]: $messageFile is not in /opt/permission.log"
            continue
        fi
        #messageUid=$(cat $tmp_file | grep -w "$messageFile" -A1 | grep -v $messageFile | awk -F ":" '{print $2}' | tr -d "a-zA-Z()/-")
        #logUid=$(cat /opt/permission.log | grep -w "$messageFile$" -A1 | grep -v $messageFile | awk -F ":" '{print $2}' | tr -d "a-zA-Z()/-" | tr -d " ")
        messageUid=$(cat $tmp_file | grep -v ">$messageFile"|grep -w "$messageFile$" -A1 |  grep -v $messageFile | awk -F ":" '{print $2}' | tr -d "a-zA-Z()/-")
        logUid=$(cat $tmp_permission | grep -v "vi>$messageFile" |grep -w "$messageFile$" -A1 | grep -v $messageFile | awk -F ":" '{print $2}' | tr -d "a-zA-Z()/-")
        if [ "X${logUid}" == "X" ];then
            LOG "[$FUNCNAME]: $messageFile is not in /opt/permission.log"
            continue
        fi
        if [ "$logUid" != "$messageUid" ];then
            echo "filename0:$messageFile||realmod:$messageUid||logmod:$logUid"
        else
            echo "filename1:$messageFile||realmod:$messageUid||logmod:$logUid"
        fi
    done
}

ls /opt/huawei/deploy/script/ |grep -w Record_os_permission.sh >/dev/null
if [ $? -eq 1 ]; then
    echo "S30_get_os_permission.sh not exist,pass."
    exit 0
fi

ls /opt/ |grep -w permission.log >/dev/null
if [ $? -eq 1 ];then
    sh /opt/huawei/deploy/script/Record_os_permission.sh nocheck_ds
    echo "create permission.log success."
    exit 0
fi
#对比cluster_service_type
real_cluster_service_type=$(cat /opt/huawei/snas/etc/snas.ini | grep cluster_service_type | awk -F "=" '{print $2}')
log_cluster_service_type=$(cat /opt/permission.log | grep cluster_service_type | awk -F "=" '{print $2}')
if [ $real_cluster_service_type -ne $log_cluster_service_type ];then
    #不相等则刷新日志文件在匹配
    sh /opt/huawei/deploy/script/Record_os_permission.sh nocheck_ds
fi

cat /opt/permission.log |tr -d "\`"|tr -d "'"|tr -d " " >$tmp_permission
iRet=$?
if [ "$iRet" != "0" ];then
    sleep 1
    cat /opt/permission.log |tr -d "\`"|tr -d "'"|tr -d " " >$tmp_permission
    iRet=$?
    if [ "$iRet" != "0" ];then
        LOG "Get infomation failed.[CheckKeyFileAuthority.sh]"
        exit 1
    fi
fi
#对比permission.log中记录的目录或者文件的权限是否与环境上的匹配
#检查/opt/huawei/deploy/package/snas_set_permission.sh权限
stat /opt/huawei/deploy/package/snas_set_permission.sh | egrep "File:|Uid:"| tr -d "\`"|tr -d "'"|tr -d " " >$tmp_file
checkcontext

#检查/bin目录及其子文件
find /bin/ | xargs -i stat {} | egrep "File:|Uid:"| tr -d "\`"|tr -d "'"|tr -d " " >$tmp_file
checkcontext

#检查/sbin目录及其子文件
find /sbin/ | xargs -i stat {} | egrep "File:|Uid:"| tr -d "\`"|tr -d "'"|tr -d " " >$tmp_file
checkcontext

#检查/etc目录及其子文件
find /etc/init.d/ | xargs -i stat {} | egrep "File:|Uid:"| tr -d "\`"|tr -d "'"|tr -d " " >$tmp_file
checkcontext

#检查/var目录
stat /var | egrep "File:|Uid:"| tr -d "\`"|tr -d "'"|tr -d " " >$tmp_file
checkcontext

#检查log目录下是否有软连接snassh
context=$(find /var/log/ -name snassh)
if [ "X${context}" != "X" ];then
    for line in $context;do
        echo "snassh:$line"
    done
fi
rm $tmp_file
rm $tmp_permission
[ -e /opt/huawei/snas/script/inspect_mml/CheckExpFileAuthority.sh ] && /opt/huawei/snas/script/inspect_mml/CheckExpFileAuthority.sh
exit 0




