#!/bin/bash
###
#功    能：系统用户密码即将过期巡检项
#输入参数：无
#标准输出：打印信息显示
#          user:user password info
#          Result:${res} 0:通过； 1：不通过  4：建议优化
###
G_INSPECT_MMLPATH="/opt/huawei/snas/script/inspect_mml"
source $G_INSPECT_MMLPATH/CheckItems

LOG_FILE="/var/log/inspect.log"
function LOG 
{
   time=$(date)
   echo [${time}][$$]$@ >> $LOG_FILE
}

#node_service_type 1 DFS 2 S3 3 Swift
#Result取值：0(通过),1(不通过),4(建议优化)
user_list=""
######################################################################
#   FUNCTION   : init_user_list
#   DESCRIPTION: 初始化账户列表
#   INPUT      : 无
#   OUTPUT     : 无
######################################################################
function init_user_list()
{
	local node_service_type=$(egrep '[[]|^'node_service_type'=' /opt/huawei/snas/etc/snas.ini | tr -d '\n' | grep -Po '(?<=[[]'NODE'[]]'node_service_type'=)[0-9]+')
	if [ "X$node_service_type" == "X2" -o "X$node_service_type" == "X3" ];then
		user_list=("root" "snasuser" "omuser" "gaussdba" "obs" "obsbilling")
	elif [ "X$node_service_type" == "X1" ];then
		user_list=("root" "snasuser" "omuser")
	fi
    LOG "user_list:${user_list}"
}
function getTimeZoneDiffSeconds()
{
    timeSeconds=$1
    curTimeZone="$(date +%z)"
    curTimeZoneSign="${curTimeZone:0:1}"
    curTimeZoneHour="${curTimeZone:1:2}"
    curTimeZoneMin="${curTimeZone:3:2}"
    diffSeconds=$(echo "${curTimeZoneHour} * 3600 + ${curTimeZoneMin} * 60" | bc)
    if [ "X${curTimeZoneSign}" == "X+" ];then
        timeSeconds=$(($timeSeconds - $diffSeconds))
    else
        timeSeconds=$(($timeSeconds + $diffSeconds))
    fi
    echo "${timeSeconds}"
}
######################################################################
#   FUNCTION   : judge_expiring_account
#   DESCRIPTION: 系统用户密码即将过期判断
#   INPUT      : 无
#   OUTPUT     : 无
######################################################################
function judge_expiring_account()
{
    local isPass=0
    local lasttime=0
    local pswd_expires_date=0
    local now_date=0
    local day_before_overdue=0
    
    for ((i=0; i<${#user_list[@]}; i++))
    do
        chage_info=`chage -l ${user_list[$i]}`
        pswd_expire_time=`echo "$chage_info" | grep "Password Expires" | awk -F':' '{print $2}' | sed 's/^[ \t]*//g' | sed 's/[ \t]*$//g'`
        if [ "X${pswd_expire_time}" == "Xnever" -o "X${pswd_expire_time}" == "XNever" ];then
            LOG "account ${user_list[$i]}'s password never expire"
            continue
        fi

        warning=`echo "$chage_info" | grep "Warning" | awk -F':' '{print $2}' | sed 's/^[ \t]*//g' | sed 's/[ \t]*$//g'`
	   #即将过期天数设置为至少7天
        if [ $warning -lt 7 ];then
            warning="7"
        fi
        #转换为秒数
        let warning*=86400
        pswd_expires_date=$(date -d "${pswd_expire_time}" +%s)
        if [ $? -ne 0 ];then
            LOG "[$FUNCNAME] Fail! Time para is ${pswd_expire_time}"
            pswd_expires_date=$(date -u -d "${pswd_expire_time}" +%s)
            pswd_expires_date=$(getTimeZoneDiffSeconds ${pswd_expires_date})
        fi
        now_date=$(date -d now +%s)
        lasttime=$(echo "${pswd_expires_date}-${now_date}" |bc -l)

        if [ $lasttime -lt 0 ];then
            if [ "${user_list[$i]}" == "obsbilling" ];then
                isPass=$(check_pass $isPass 4)
            else
                isPass=$(check_pass $isPass 1)
            fi
            echo "${user_list[$i]}:Password Expire Date ${pswd_expire_time}.ERRCODE(4)"
            LOG "${user_list[$i]}:Password Expire Date ${pswd_expire_time}"
        elif [ $lasttime -lt $warning ];then
            isPass=$(check_pass $isPass 4)
            day_before_overdue=$(awk -v a=$pswd_expires_date -v b=$now_date 'BEGIN{printf("%d",(a-b)/86400)}')
            echo "${user_list[$i]}:Password Expire Date ${pswd_expire_time},Days before overdue ${day_before_overdue}.ERRCODE(5)"
            LOG "${user_list[$i]}:Password Expire Date ${pswd_expire_time},Days before overdue ${day_before_overdue}."
        fi
    done
    
    return $isPass
}
function main()
{
    local iRet=0
	#初始化账户列表
    init_user_list
    #系统用户密码即将过期判断
    judge_expiring_account
    iRet=$?
    echo "Result:${iRet}"
    LOG "result=${iRet};" 
}

main

