############################################################
# 所属模块  : OceanStor9000 巡检工具
# 功能          : 检测复制任务是否完成
# 创建时间  : 2016年12月12日
# 描述        ：
#   在当前集群的HA主节点查询没有修复成功的任务数, 如果大于阈值认为巡检失败,返回1,否则0
############################################################

#!/bin/bash


check_num=0 #检查的阈值，由DE确定的
res_value=0  #返回值

NODE_TYPE=
readonly CM_INI_PATH="/opt/huawei/snas/etc/cm.ini"

readonly PRIMARY_TYPE="Primary"    #主
readonly STANDBY_TYPE="Standby"    #备
readonly BUSINESS_TYPE="Business"  #业务节点


#判断该节点是否需要检查,返回：1，需要检查；0，不需要检查
#1.判断是否是S3节点 swift不需要检查, DFS不需要检查
#2.判断是否是S3管理节点中的ha主节点
function isNotNeedCheck()
{
    isMultiazConf=$(grep "Enable=0" /opt/huawei/snas/etc/multiaz.ini )
    if [ "X$isMultiazConf" == "XEnable=0" ] ;then
        echo 'not config multiaz'
        return 0;
    fi
    
    local isNotNeedCheckFlag=0
    #获取节点类型标识
    node_service_type=$(egrep '[[]|^'node_service_type'=' /opt/huawei/snas/etc/snas.ini | tr -d '\n' | grep -Po '(?<=[[]'NODE'[]]'node_service_type'=)[0-9]+')
    if [ "${node_service_type}" = "2" -o "${node_service_type}" = "3" ]; then

        NODE_TYPE="${BUSINESS_TYPE}"
        source /opt/obs/scripts/common/s3_config_utility.sh >> /dev/null 2>&1
        #判断是否是s3管理节点
        is_s3_management_node > /dev/null
        if [ $? -eq 1 ];then
            localNID=$(grep -w NID ${CM_INI_PATH}|awk -F"=" '{print $2}')
            hainfo=$(grep -w "node id(${localNID})" /proc/monc_hamap)
            if [ "$hainfo" = "" ];then
                NODE_TYPE="${BUSINESS_TYPE}"
            else
                role=${hainfo##*role(}
                role=${role%%)status*}

                if [ "$role" = "1" ];then
                    NODE_TYPE="${PRIMARY_TYPE}"
                elif [ "$role" = "2" ];then
                    NODE_TYPE="${STANDBY_TYPE}"
                fi
            fi
        fi
    else
        isNotNeedCheckFlag=0
    fi
    
    #只在ha主节点查询数据
    echo "NODE_TYPE:$NODE_TYPE"
    if [ "$NODE_TYPE" == "$PRIMARY_TYPE" ]; then
        isNotNeedCheckFlag=1
    fi
    
    return $isNotNeedCheckFlag
}

#####################################################
# 功能      : 检测复制任务是否完成主函数
# 描述      ：查询没有修复成功的任务数, 如果大于阈值认为巡检失败
#             连续三次没有查到数据也认为巡检失败
# 创建时间  : 2016年12月12日
#####################################################
function checkRepMain(){
    retry=0
    while [ $retry -lt 3 ]
    do
        retry=$(($retry+1))
        unFixedRepNum=`curl -X GET -v http://127.0.0.1:9123/maintain/rep?type=repcheckinfo | sed -e 's/,/\n/g; s/{/\n/g; s/}/\n/g' | grep  "checkNum" | awk 'BEGIN{FS=":"} {print $2}'`
        echo "checkRepEnd:Get undo num=$unFixedRepNum"
        if [ -z $unFixedRepNum ]; then
            echo "checkRepEnd: curl response value is EMPTY"
            sleep 1
            continue
        else
            break
        fi
    done
    
    #3次都取不到数据认为巡检失败
    if [ -z $unFixedRepNum ]; then
        echo 'Result:failed'
        return 1;
    fi
    #如果大于阈值认为巡检失败   
    if [ $unFixedRepNum -gt $check_num ];then
        echo 'Result:failed'
        return 1;
    fi
    
    echo 'Result:Pass'
}


isNotNeedCheck
if [ $? -eq 0 ]; then
    echo "checkRepEnd: not need check"
    echo 'Result:NoCheck'
    exit 0
fi

checkRepMain
exit $res_value