#!/bin/bash
###
#功    能：桶信息长时间处于中间状态巡检项
#输入参数：无
#标准输出：打印信息显示
#          ${value}
#          Result:${res} 0:正常； 非0:不正常 （默认使用1）
###

G_REMOTE_TMP_FILE="/tmp/tmpfile"
G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml/"
LOG_FILE="/var/log/inspect.log"
mdcdbUserPwdStr=$(/opt/obs/scripts/common/commonfunction.sh getMdcdbUserPwdStr)
function LOG 
{
   time=$(date)
   echo [${time}][$$]$@ >> $LOG_FILE
}


#'result=0;value=All buckets are ready or deleted state;'

#脚本执行正常返回码0
RESULT_CODE_OK=0
#脚本执行异常返回码1
RESULT_CODE_ERR=1

value=""
res=$RESULT_CODE_OK

######################################################################
#   FUNCTION   : is_node_active
#   DESCRIPTION: HA主节点判断
#   INPUT      : 无
#   OUTPUT     : 返回值是否为主节点，0表示主节点，非0非主
######################################################################
function is_node_active()
{
	idList=$(cat "/opt/huawei/snas/etc/snas.ini" |tr \\n ] |grep -Po '(?<=[[]NETWORK[]]).*' |tr ] \\n |grep -P "^subnetwork_id_")
	if [ ! -z "$idList" ]; then
		for idParam in $idList
		do
			num=$(echo $idParam |awk -F "=" '{print $2}')
			if [ "$num" -eq 1 ] ; then
				key=$(echo $idParam |awk -F "=" '{print $1}' | awk -F "subnetwork_id_" '{print $2}')
				if [ ! -z "$key" ]; then
					netbond_mgr=$(cat "/opt/huawei/snas/etc/snas.ini" |tr \\n ] |grep -Po '(?<=[[]NETWORK[]]).*' |tr ] \\n |grep -Po "(?<=^ipaddr_${key}=).*" |awk 'NR==1{print}') 
					break
				fi
			fi
		done
	fi

    HAMIP=`sudo cat /proc/monc_hamap |grep "role(1)"|awk -F "(" '{print $2}'|awk -F ")" '{print $1}'`
	if [[ "${netbond_mgr}" != "${HAMIP}" ]]
    then
        return 1
    else
        return 0
    fi
}

function getTimeZoneDiffSeconds()
{
    timeSeconds=$1
    curTimeZone="$(date +%z)"
    curTimeZoneSign="${curTimeZone:0:1}"
    curTimeZoneHour="${curTimeZone:1:2}"
    curTimeZoneMin="${curTimeZone:3:2}"
    diffSeconds=$(echo "${curTimeZoneHour} * 3600 + ${curTimeZoneMin} * 60" | bc)
    if [ "X${curTimeZoneSign}" == "X+" ];then
        timeSeconds=$(($timeSeconds - $diffSeconds))
    else
        timeSeconds=$(($timeSeconds + $diffSeconds))
    fi
    echo "${timeSeconds}"
}

######################################################################
#   FUNCTION   : checkMdcMiddle
#   DESCRIPTION: 桶信息长时间处于中间状态判断
#   INPUT      : 无
#   OUTPUT     : 无
######################################################################
function checkMdcMiddle()
{
	local bucktable=`sudo -u gaussdba /opt/huawei/gaussdb/app/bin/gsql -d locations -p 5679 \
                    -c "select * from LOCATIONTABLE;" \
                    2>/dev/null`
	local bucknum=`echo "$bucktable" | grep -E -v "^$" | awk 'END{print NR}'`
    local currentTimeStamp=0
    currentTimeStamp=`date --date -2hour +%s`
    if [ $? -ne 0 ];then
        LOG "[$FUNCNAME] Fail! Time para is -2hour"
        currentTimeStamp=`date --date -2hour -u +%s`
        currentTimeStamp=$(getTimeZoneDiffSeconds ${currentTimeStamp})
    fi
    local gsql_res=`sudo -u gaussdba /opt/huawei/gaussdb/app/bin/gsql -A -t -d cloud_mdc -p 5679 $mdcdbUserPwdStr \
                    -c "select (LAST_MODIFIED - to_date('1970-01-01 00:00:00','yyyy-mm-dd hh24:mi:ss')) \
                    * 86400 as timestamp from bucket_location_info where status not in (3,6);" \
                    2>/dev/null | grep "days" | awk '{print $1}' | sed 's/^[ \t]*//g' | sed 's/[ \t]*$//g'`
    local tmpFileLineNum=`echo "$gsql_res" | grep -E -v "^$" | awk 'END{print NR}'`
    local timeoutCount=0
    
	if [ $bucknum -eq 0 ]
	then 
		value="${value},There is no bucket"
        LOG "There is no bucket" "INFO" "${scriptName}"
    elif [ $tmpFileLineNum -eq 0 ]
    then
        value="${value},All buckets are ready or deleted state"
        LOG "All buckets are ready or deleted state" "INFO" "${scriptName}"
    else
        while read line
        do
            if [ $currentTimeStamp -gt $line ]
            then
                let timeoutCount++
            fi
        done <<< "`echo "$gsql_res" | grep -E -v "^$"`"
        
        if [ $timeoutCount -ne 0 ]
        then
            res=$RESULT_CODE_ERR
            value="${value},last_modified:timeout.ERRCODE(4)"
            LOG "last_modified:timeout" "ERROR" "${scriptName}"
        else
            value="${value},The intermediate state less than 2 hours"
            LOG "The intermediate state less than 2 hours" "INFO" "${scriptName}"
        fi
    fi
}

function main()
{
	#HA主节点判断
    is_node_active
    if [ $? -ne 0 ]
    then
        LOG "standby-HA nodes do not need to inspect" "INFO" "${scriptName}"
        value="${value},standby-HA nodes do not need to inspect"
		
    else
        #桶信息长时间处于中间状态判断
        checkMdcMiddle
    fi
    
    echo "${value}" | grep "^," >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        value="${value#?}"
    fi
    LOG "result=${res};value=${value};" "INFO" "${scriptName}"
	line="$res$value"
	if [ -z "$line" ]
    then
        value="no inspect file"
        res="Fail"
        LOG "no inspect file" "ERROR" "${scriptName}"
    else
		value="${value#*value=}"
        if [ ${res} -eq 0 ]
        then
            res="Pass"
        else
            res="Fail"
        fi
    fi
    LOG "${value}" "INFO" "${scriptName}"
    LOG "Result:${res}" "INFO" "${scriptName}"
}

main
echo "${value}"
echo "Result:${res}"
