#!/bin/bash
set +x
G_TMP_FILE="/cf_data/root/usr/local/agent/snmp/log/"
G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"
LOG_FILE="/var/log/GetMdsFileInode.log"

function LOG
{
   time=$(date)
   echo [${time}][$$]$@ >> $LOG_FILE
}
#远程同步执行，输入ip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
    local iRet=$?
    LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time"
    return $iRet
}
#获得全系统inode总数
GetMdsFileInode()
{
    local Result=""
    local isPass=0
    local faildInfo=""
    local exe_result=""
    while true; do

        mdsMasterIP=`cat /proc/monc_leader | grep "Mds leader" |awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
        LOG "[$FUNCNAME]mdsMasterIP:$mdsMasterIP"
        if [ "mdsMasterIP" = "0" ];then
            LOG "[$FUNCNAME]:Failed to execute command(mds info show),get masterIp($mdsMasterIP) err."
            Result="Failed to execute command(mds info show),get masterIp(${mdsMasterIP}) err."
            isPass=1
            break;
        fi

        #在主MDS执行MML命令获得inode总数, 执行mml命令 mds info show
        remote_exec $mdsMasterIP 30 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds info show'" > $G_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ];then
            LOG "[$FUNCNAME]:iRet($iRet)"
            Result="INFO:Failed to execute command($mdsMasterIP 988 'mds info show')."
            isPass=2
            break
        fi

        exe_result1=`cat $G_TMP_FILE$FUNCNAME | grep '\(Cur Inode Count in Cluster\)\|\(Sys Inode Count\)' | dos2unix|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
        exe_result2=`cat $G_TMP_FILE$FUNCNAME | grep '\(Max Inode Count Support by Cluster\)' | dos2unix|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
        LOG "[$FUNCNAME]exe_result1:$exe_result1"
        LOG "[$FUNCNAME]exe_result2:$exe_result2"
        if [ "$exe_result1" == "" -o "$exe_result2" == "" ];then
           Result="INFO:Failed to get Inode Count."
           isPass=3
        else
            Result="${exe_result1}&${exe_result2}"
            echo $Result
        fi

        break
    done
    LOG "GetMdsFileInode success!"
    return $isPass
}
>$LOG_FILE
chmod 640 $LOG_FILE
GetMdsFileInode
