#!/bin/bash
#
#CCDB升级前检查运行脚本
PROG_NAME=$0

#check usage
if [ $# -lt 1 ]; then
    echo "Usage: ${PROG_NAME} {getchecklist|getversion|stopccdb|startccdb}"
    exit 2
fi

function get_master()
{
    local ccdb_map=$(cat /proc/monc_ccdbmap)
    local ccdb_masterinfo=$(cat /proc/monc_ccdbmap | grep "Role: 0")
    
    echo "$ccdb_map"
    echo "MatsterNode:"
    echo "$ccdb_masterinfo"
    return 0
}

function get_check_list()
{
    local ccdb_map=$(cat /proc/monc_ccdbmap | grep "NodeId")
    local ccdb_masterinfo=$(cat /proc/monc_ccdbmap | grep "Role: 0")
    local master_nodeid=$(echo "$ccdb_masterinfo" | awk -F ',' '{print $1}' |awk -F ' ' '{print $2}')
    local check_list=""
    local min_nodeid=1000000
    local min_check_node=""

    IFS=$'\n'
    for each_line in ${ccdb_map}
    do
        local nodeid=$(echo "$each_line" | awk -F ',' '{print $1}' |awk -F ' ' '{print $2}')
        if [ ${master_nodeid} -eq ${nodeid} ]; then
            continue
        fi
        if [ ${master_nodeid} -gt ${nodeid} ]; then
            check_list=`echo -e "${check_list}\n${each_line}"`
        fi
        if [ ${master_nodeid} -lt ${nodeid} ]; then
            if [ ${nodeid} -lt ${min_nodeid} ]; then
                min_nodeid=${nodeid}
                min_check_node="${each_line}"
            fi
        fi
    done
    if [ "X${check_list}" = "X" ]; then
        check_list="${min_check_node}"
    fi
    echo "MatsterNode:"
    echo "${ccdb_masterinfo}"
    echo "SlaveNode:"
    echo "${check_list}"
    return 0
}

function get_version()
{
    local dlm_path_name=$(ls /opt/huawei/etc/ccdb/ | grep "DLM" | awk -F ' ' '{print $NF}')
    local dlm_path="/opt/huawei/etc/ccdb/${dlm_path_name}"
    local dlm_paxos_list=$(ls ${dlm_path}/paxos_DLMDB_*)
    local max_version=0
    local min_check_node=""

    IFS=$'\n'
    for each_line in ${dlm_paxos_list}
    do
        local paxos_version=$(echo "$each_line" | awk -F ' ' '{print $NF}' | awk -F '_' '{print $NF}' | awk -F '-' '{print $1}')
        if [ ${max_version} -lt ${paxos_version} ]; then
            max_version=${paxos_version}
        fi
    done

    echo "paxos_version:${max_version}"
    return 0
}

function stop_ccdb()
{
    /opt/huawei/deploy/bin/daemon /opt/huawei/snas_cluster/bin/ccdb_server -s
    return 0
}

function start_ccdb()
{
    /opt/huawei/deploy/bin/daemon /opt/huawei/snas_cluster/bin/ccdb_server
    return 0
}

function usage()
{
    local inputpara="${1}"

    echo "Error:"
    echo "       input paras(${inputpara}) error."
    echo "Usage:"
    echo "       sh $0 [getmaster|getchecklist|getversion]"
    echo "Parameter Description:"
    echo "       $0 getchecklist          get ccdb check list."
    echo "       $0 getversion            get ccdb local paxos version."
    echo "       $0 stopccdb              stop ccdb server."
    echo "       $0 startccdb             start ccdb server."
    return 0
}

ACTION=$1
PARAM=$2
result=
case "$ACTION" in
    "getmaster")
        get_master
        result=$?
        ;;
    "getchecklist")
        get_check_list
        result=$?
        ;;
    "getversion")
        get_version
        result=$?
        ;;
    "stopccdb")
        stop_ccdb
        result=$?
        ;;
    "startccdb")
        start_ccdb
        result=$?
        ;;
    *)
        usage $1
        exit 0
        ;;
esac

exit $result