#!/bin/bash

source /opt/huawei/snas/script/inspect_mml/certUpdateLib.sh

function main()
{
    local iret=0
    local act=$1
    local cert=$2
    local key=${@:3}
    local tmpDir="/tmp/Certificate$$"
    local createFlag=0
    local tmpCertDir=${tmpDir}/Certificate/${cert}
    if [ "${cert}" = "DeviceManager" ]; then
        RestartDeviceManager
        iret=$?
        return ${iret}
    fi
    if [ ! -f /opt/inspect/Certificate.tar.gz ]; then 
        return 1
    fi
    if [ ! -d ${tmpDir} ]; then
        mkdir -p ${tmpDir} || return 1
        createFlag=1
    fi
    tar zxf /opt/inspect/Certificate.tar.gz -C ${tmpDir} 
    iret=$?
    if [ ${iret} -ne 0 ]; then
        [ ${createFlag} -eq 1 ] && rm -rf ${tmpDir}
        return 1
    fi
    if [ "${act}" = "restoreCert" ]; then
        CertRestore ${cert} ${tmpCertDir} "${key}"
        iret=$?
    else
        CertBackup ${cert} ${tmpCertDir}
        iret=$?
        if [ ${iret} -ne 0 ]; then
            [ ${createFlag} -eq 1 ] && rm -rf ${tmpDir}
            return 1
        fi
        if [ "$cert" = "ToolkitHttps" ];then
            [ ! -d /opt/inspect/CertificateTmp/Certificate ] && mkdir -p /opt/inspect/CertificateTmp/ && tar -vxf /opt/inspect/Certificate.tar.gz -C /opt/inspect/CertificateTmp/ >/dev/null 2>&1 
            local certName="/opt/Runtime/tomcat7/conf/server.keystore"
            local tmpFileName=`echo $certName | awk -F"/" '{print $NF}'` 
            local pemFile=`ls -l /opt/inspect/CertificateTmp/Certificate/*/* | awk '{print $NF}' | grep $tmpFileName`
            sed -i "s/netstat -lnp | grep \"8098\" | wc -l/netstat -lnp | grep -w \"8098\" | wc -l/g" /opt/Runtime/bin/replace_cert.sh
            local strret=$(
sh /opt/Runtime/bin/replace_cert.sh <<<"$pemFile
$(decode ${key})
$(decode ${key})
y
")
            echo ${strret} | grep "Replace certificate file successfully!" >/dev/null
            iret=$?
            if [ ${iret} -ne 0 ]; then
                echo "Failed to update ${cert} ${certName}" 
                CertRestore ${cert} ${tmpCertDir} "${key}"
                [ ${createFlag} -eq 1 ] && rm -rf ${tmpDir}
            fi
            rm -rf /opt/inspect/CertificateTmp/
            return ${iret}
        fi
        CertReplace ${cert} ${tmpCertDir} "${key}"
        iret=$?
        if [ ${iret} -ne 0 ]; then
            CertRestore ${cert} ${tmpCertDir} "${key}"
            [ ${createFlag} -eq 1 ] && rm -rf ${tmpDir}
            return 1
        fi
    fi
    [ ${createFlag} -eq 1 ] && rm -rf ${tmpDir}
    return ${iret}
}

main $@
