#!/bin/bash
set +x
###
#功    能：lib2d断链巡检巡检脚本
#输入参数：无
#标准输出：打印信息显示
#          result=返回码;value=指标值;
#          返回码：0:正常； 非0:不正常 （默认使用1）
###

G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml/"
LOG_FILE="/var/log/inspect.log"
function LOG
{
   time=$(date)
   echo [${time}][$$]$@ >> $LOG_FILE
}
#脚本执行正常返回码0
RESULT_CODE_OK=0
#脚本执行异常返回码1
RESULT_CODE_ERR=1

value=""
res=$RESULT_CODE_OK

function main()
{
    lib2dBrokenInfo=`curl -X GET -v http://127.0.0.1:9123/maintain/broken-lib2d 2>&1`
    LOG "lib2dBrokenInfo:"$lib2dBrokenInfo""
    lib2dBrokenRecord=`echo "$lib2dBrokenInfo" | grep "1OBS1" | tr -d '\n'`
    value="${value},lib2dBrokenRecord:${lib2dBrokenRecord:-null}"
    echo "$lib2dBrokenInfo" | grep -qE "HTTP/1.1\s+200\s+OK" > /dev/null 2>&1
    if [ $? -eq 0 ];then
        if [ -n "${lib2dBrokenRecord}" ];then
            res=$RESULT_CODE_ERR
            LOG "ERROR lib2dBrokenRecord:${lib2dBrokenRecord}"
        fi
    else
        LOG "ERROR: Execution error"
        value="Execution error"
        res=$RESULT_CODE_ERR
    fi

    echo "${value}" | grep "^," >/dev/null 2>&1
    if [ $? -eq 0 ];then
        value="${value#?}"
    fi
    LOG "INFO result=${res};value=${value}"
}

main

echo "result=${res};value=${value}"
