#!/bin/bash
set +x

source /opt/huawei/snas/script/inspect_mml/CommonFunc.sh

LOGFILE="/var/log/inspect.log"

function LOG()
{
    echo [`date`][$$]$@ >> $LOGFILE
}

tmpnasfile="/tmp/tmpfilecheckProtoSubdomain_Mml"
tmpdir="/tmp/checkProtoSubdomain"

function checkProtoSubdomain_Mml()
{
    #已巡检项名称创建一个临时目录用来生成nas文件，避免多个巡检项同时调用此文件
    mkdir $tmpdir
    nas="$tmpdir/nas.sh"
    echo "#!/bin/bash" > $nas
    echo "\$*" >> $nas
    chmod +x $nas

    #获取协议子域信息
    $nas "/usr/local/bin/nas_proto_cluster -c get_zone" > $tmpnasfile
    status=$(cat $tmpnasfile | grep "<status>" |awk -F">" '{print $2}' |awk -F"<" '{print $1}')

    echo "status:$status"
    if [ $status -ne 0 ];then
        return 0
    fi

    cat $tmpnasfile | awk '{
        if ($0~/<wise_link_zone>/) {
            if (zonename!="") {
                printf "ZoneName:%s\t%d\t%s\n", zonename, zonenodecount, zonenodelist
                zonename=""
            }
            zonenodecount=0
            zonenodelist="--"
            flag=1
        }
        else if ($0~/<\/zone_node_list>/) {
            if (zonename!="") {
                printf "ZoneName:%s\t%d\t%s\n", zonename, zonenodecount, zonenodelist
                zonename=""
            }
            flag=0
        }
        if (flag==1) {
            if ($0~/<zone_name>/) {
                sub("<zone_name>","")
                sub("</zone_name>","")
                gsub("[[:space:]]", "")
                zonename=$0
            }
            else if ($0~/<zone_node_name>/) {
                sub("<zone_node_name>","")
                sub("</zone_node_name>","")
                gsub("[[:space:]]", "")
                if (zonenodelist=="--") {
                    zonenodelist=$0
                } else {
                    zonenodelist=zonenodelist","$0
                }
                zonenodecount=zonenodecount+1
            }
        }
    } END {
         if (zonename!="") {
            printf "ZoneName:%s\t%d\t%s\n", zonename, zonenodecount, zonenodelist
        }
    }'
}
checkProtoSubdomain_Mml
[ -d "${tmpdir}" ] && rm -rf $tmpdir
[ -f "${tmpnasfile}" ] && rm -f "${tmpnasfile}"

