import os
import sys

def countFollowingZeros(l):
    """Return number of elements containing 0 at the beginning of the list."""
    if len(l) == 0:
        return 0
    elif l[0] != 0:
        return 0
    else:
        return 1 + countFollowingZeros(l[1:])

def ipv6Normal(ipaddr):

    ret = ':'.join(["%x" % x for x in [int(x, 16) for x in ipaddr.split(':')]])
    return ret
	
def ipv6Compressed(str):
    entrys = [int(y, 16) for y in str.split(':')]
    remnant = [0] * 8
    for index in xrange(len(entrys)):
        remnant[index] = countFollowingZeros(entrys[index:])
    place = remnant.index(max(remnant))
    if max(remnant) > 1:
        entrys = [y for y in ipv6Normal(str).split(':')]
        while place < len(entrys) and entrys[place] == '0':
            del(entrys[place])
        entrys.insert(place, '')
        if place + 1 >= len(entrys):
            entrys.append('')
        if place == 0:
            entrys = [''] + entrys
        return ':'.join(entrys)
    else:
        return ipv6Normal(str)
        
if __name__ == "__main__":
    ipaddr = sys.argv[1]
    result=ipv6Compressed(ipaddr)
    print result
