#!/bin/bash

# ********************************************** ***************************** #
# File Name: inspect_software.sh
# Description: ѲĿе״̬.
# Input:
# Output:
# Author:
# Created: 2013-01-16
# Function List
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #

dos2unix $G_SCRIPT_PATH/inspect_lib.sh > /dev/null 2>&1
dos2unix $G_SCRIPT_PATH/inspect_map.sh > /dev/null 2>&1

. $G_SCRIPT_PATH/inspect_lib.sh
. $G_SCRIPT_PATH/inspect_map.sh

G_TMP_FILE="$G_SCRIPT_PATH/tmpfile$!"
G_REMOTE_TMP_FILE="/tmp/tmpfile$!"
G_TMP_FILE2="$G_SCRIPT_PATH/tmpfilex$!"
G_REMOTE_TMP_FILE2="/tmp/tmpfilex$!"


IP_ROLE_FILE="/tmp/tmp_ip_role"


G_LINE_FILE="/tmp/lines.txt"
G_TOTALCAP_FILE="/tmp/totalcap.txt"
G_FREECAP_FILE="/tmp/freecap.txt"
G_INFO_FILE="/tmp/dsinfo.txt"
G_NODEPOOL_FILE="/tmp/dsnodepoolinfo.txt"
G_NODEPOOLTMP_FILE="/tmp/dsnodepoolinfoTMP.txt"

G_UNKNOWN_PROTO="Unknown protocol type"
G_CMD_FAILED="Execute command failed!"
LOG_FILE="/var/log/inspect.log"
LOG_FILE_BAK="/var/log/inspect_1.log"

VALID_IP_FILE="/tmp/tmp_valid_ip$!"
VALID_IP_FILE2="/tmp/tmp_valid_ip2"
VALID_IP_FILE3="/tmp/tmp_valid_ip3"

G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"
CM_DB="/opt/huawei/snas/etc/cm_conf.db"
RepeatTimes=(1 2 3)

FIFO_OPERATE_ID=759
FIFO_THREAD_NUM_MAX=60
RPC_REFER_CNT_MAX=20

G_SEPARATOR="-----------------------------------------------------------------------------"

RPC_REFER_PROC_FILE="/proc/sys/internalrpc/rpc_req_leak"
RPC_REFER_CNT_KEY="The leaked requests are found"

G_GET_REPLICATION_INFO="/opt/huawei/snas/script/inspect_mml/GetReplicationInfo"

###add 2016-09-12 Ѳ¿ܣѲ270-275#################
G_REMOTE_EXEX_RESULT="/tmp/tmpfileRemoteResult"
G_LOCAL_EXEX_RESULT="/tmp/tmpfileLocalResult"
G_DOWNLOAD_FILE="/tmp/inspect_downloadfile"
G_MML_INSPECT_HEAD=$G_MMLEX_FILE_PATH"/inspect_head"
G_MML_INSPECT=$G_MMLEX_FILE_PATH"/inspect"
###end add#

function LOG_Check
{
    if [ ! -f $LOG_FILE ]; then
        touch $LOG_FILE
        if [ $? -ne 0 ]; then
            echo "Create log file $LOG_FILE failed."
            return
        fi
    fi

    # delete log file bigger than 10M
    FILE_SIZE=$( ls -l $LOG_FILE | cut -d' ' -f 5 )
    if [ ! -z "$FILE_SIZE" ]; then
        # delete file when file bigger than 10M
        if [ $FILE_SIZE -gt 10485760 ]; then
            mv $LOG_FILE $LOG_FILE_BAK 2>&1
        fi
    fi
}

function LOG
{
   time=$(date)
   echo [${time}][$!]$@ >> $LOG_FILE
}

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

#ʹfifoܵ, ʵֶ̲, Ҫ׼ VALID_IP_FILE
function fifo_start
{
    trap "exec $FIFO_OPERATE_ID>&-;exec $FIFO_OPERATE_ID<&-;exit 0" 2

    mkfifo remoteFifo
    eval "exec $FIFO_OPERATE_ID<>remoteFifo"
    rm -rf remoteFifo

    local num=0
    for Item in $VALID_IP_FILE; do
        num=$((num+1))
    done

    local threadNum=$FIFO_THREAD_NUM_MAX
    if [ $threadNum -gt $num ]; then
        threadNum=$num
    fi

    for ((i=0;i<$threadNum;i++))
    do
        eval "echo >& $FIFO_OPERATE_ID"
    done
}

function fifo_finish
{
    eval "exec $FIFO_OPERATE_ID>&-"
    eval "exec $FIFO_OPERATE_ID<&-"
}

function check_pass()
{
    local list=(["2"]=0 ["1"]=1 ["4"]=2 ["0"]=3 ["3"]=4) #δ(2)>ͨ(1)>Ż(4)>ͨ(0)>漰(3)
    local isPass=$1   #Ⱥ
    local tmpIsPass=$2 #ǰ

    if [ ${list[$tmpIsPass]} -lt ${list[$isPass]} ];then
        isPass=$tmpIsPass
    fi
    echo $isPass
}

function check_symbolic()
{
    local desPath=$1
    if [ -L ${desPath} ];then
        return 0
    else
        return 1
    fi
}

function get_nlunmap()
{
    local result_log=/var/log/nluninfo.log
    #ȡIP
    local back_ip=$( get_backnet_ip )
    if [ "$back_ip" = "" ]; then
        errResult="INFO: Can't get local ip"
        LOG "[$FUNCNAME]:$errResult"
        WRITE_XML_ERROR 0 "Node:-(master)||INFO:Failed to get local ip.ERRCODE(11)"
        return 1
    fi

    nlunready=0
    #ڵǷ񶼼뵽nlunmapУ15sһΣ4ΣҲ1ӡѲ칤ÿȴ5
    waitcount=0
    while [ $waitcount -lt 4 ]
    do
        #Ƚ/var/log/nluninfo.log
        >${result_log}

         $G_MML_FILE_PATH/ShowInspectMml $back_ip 988 "monc nluninfo 0"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
         iRet=$?
         if [ $iRet -ne 0 ]; then
             Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
             LOG "[$FUNCNAME]mml_result:$Info"
             WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to execute MML command(monc nluninfo 0),port(988).return($iRet).ERRCODE(12)"
             nlunready=0
             break
         fi

        #ȡеnodepoolǷÿnodepoolеĽڵ㶼nlun(ֻҪһnodepoolеĽڵnlunУnodepoolеĽڵ㶼nlun)
        allNodePool=$( cat /proc/monc_tiermap | grep "nodepool id" | awk -F: '{print $2}' )
        for tmpNodePool in $allNodePool
        do
            nlunready=0
            frontIpInPool=$( cat /proc/monc_tiermap | grep -A16 "nodepool id :$tmpNodePool" | grep "node :" | sed 's/node : *//' )
            if [ "$frontIpInPool" = "" ];then
                LOG "[$FUNCNAME]:nodepool:$tmpNodePool no node."
                nlunready=1
            fi
            allBackIp=""
            allDsId=""
            #nodepoolǰipdsmapǺipҪǰipҶӦĺipٸݺipdsid
            for tmpfront in $frontIpInPool
            do
                tmpBackIp=$( sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=(select NID from CM_NODE_IP_T where IP_ADDR=\"$tmpfront\") and SUBNET_ID=1" )
                allBackIp=${allBackIp}" "${tmpBackIp}
                for tmpip in $tmpBackIp
                do
                    dsIdQuery=$( cat /proc/monc_dsmap | grep "$tmpip" | awk '{print $2}' )
                    allDsId=${allDsId}" $dsIdQuery"
                done
            done

            for dsid in $allDsId
            do
                grep "($dsid" ${result_log} > /dev/null
                if [ $? -eq 0 ];then
                    LOG "[$FUNCNAME]:ds $allDsId is in nlunmap"
                    nlunready=1
                    break
                fi
            done
            #ǰnodepoolеĽڵ㶼mapУΪmapҪ
            if [ $nlunready -ne 1 ];then
                LOG "[$FUNCNAME]:ds $allDsId is not in nlunmap"
                break
            fi
        done

        #nodepoolдpoolнڵ㶼ûnlunУ˵nlunûãȴһʱ
        if [ $nlunready -ne 1 ];then
            sleep 15
            let "waitcount=$waitcount+1"
        else
            break;
        fi
    done

    #nlun״̬ǲǳɹ˵βѯʧˣ󷵻ʧܼ
    if [ $nlunready -ne 1 ];then
        WRITE_XML_ERROR 0 "nodes $allBackIp have no nlunmap."
        return 0
    else
        return 1
        WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Get information failed.(monc nluninfo 0).ERRCODE(13)"
    fi
}

#ԶִͬУip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
    /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#ԶִǷ
function remote_exec_checkfini
{
    local remote_ip=$1
    local le_pid="$!$2"
    local err_info=$3

    for time in ${RepeatTimes[*]}; do
    local proresult=$( /opt/huawei/deploy/script/localexec.py progress $remote_ip $le_pid )
    local iRet=$?
        if [ $iRet -eq 101 ]; then
        LOG "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time,thread:$!"
            sleep 10
        else
            break
        fi
    done
    local process=$( echo $proresult | awk '{print $1}' )
    local errno=$( echo $proresult | awk '{print $4}' )

    if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
        return 0    #ѯִгɹԶû
    elif [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME] IP:$remote_ip, thread:$!,exec(get progress) failed.return($iRet)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to get command result.return($iRet),proces($process),errno($errno).ERRCODE(2)"
        return 1    #ѯִʧ
    elif [ $iRet -eq 0 ] && [ "$process" = "100" ] && [ "$errno" = "0" ] ;then
        LOG "[$FUNCNAME] IP:$remote_ip,thread:$!, exec(get progress) success.return($iRet),errno($errno),process($process)"
        return 2    #ɹɣ˴Ҫ0Ϊɹ
    elif [ "$errno" != "0" ] && [ "$errno" != "" ];then
        LOG "[$FUNCNAME] IP:$remote_ip, thread:$!,exec(get progress) failed.return($iRet) errno($errno)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info.return($iRet),proces($process),errno($errno).exec(get progress) failed.ERRCODE(2)"
        return 3    #Զִʧ
    elif [ "$process" = "" ] && [ "$errno" = "" ];then
        LOG "[$FUNCNAME]IP:$remote_ip, thread:$!, exec(get progress) failed.process(null), ip not accessed"
        return 5    #ʱ
    elif [ "$process" = "" ] || [ "$errno" = "" ];then
        LOG "[$FUNCNAME] IP:$remote_ip, thread:$!,exec(get progress) failed.process(null)"
        return 0    #ݴ
    else
        LOG "[$FUNCNAME]IP:$remote_ip, thread:$!, exec(get progress) failed. Undefined error info"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info.return($iRet),proces($process),errno($errno).ERRCODE(2)"
        return 4    #δ
    fi
}

#Զ첽ִУip/pid/timeout/cmd
function remote_exec_async
{
    local remote_ip=$1
    local le_pid="$!$2"
    local time_out=$3
    local cmd=$4
    for time in ${RepeatTimes[*]}; do
    /opt/huawei/deploy/script/localexec.py async $remote_ip $le_pid $time_out true "$cmd"
    local iRet=$?
        LOG "[$FUNCNAME]:IP:$remote_ip,thread:$!,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
    fi
    done
    return $iRet
}

#һѽڵ첽ִУҪ׼ REMOTE_IP_S
function remote_exec_async_batch
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}

    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$3"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command.return(${iRet}).ERRCODE(1)."
            ret=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}
#Զ̵MML
function remote_exec_async_batch_mml
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}
    local ret=0
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $1 $2 "$G_MML_FILE_PATH/$3 $Item > $G_REMOTE_TMP_FILE$4 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command.return(${iRet}).ERRCODE(1)."
            ret=1
        else
            cat $G_REMOTE_TMP_FILE$FUNCNAME | sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    return $ret
}

function remote_download_sync
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
        iRet=$?
        LOG "[$FUNCNAME] download ($remote_file) from ($remote_ip) to ($local_file) iRet:($iRet) time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done

    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get execute result.return($iRet).ERRCODE(3)"
    fi

    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        LOG "[$FUNCNAME] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi
    return $iRet
}

function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    eval "read -u $FIFO_OPERATE_ID"
    {
        for time in ${RepeatTimes[*]}; do
            /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
            iRet=$?
            LOG "[$FUNCNAME] download ($remote_file) from ($remote_ip) to ($local_file) iRet:($iRet) time:$time"
            if [ $iRet -eq 101 ]; then
                sleep 10
            else
                break
            fi
        done

        eval "echo >& $FIFO_OPERATE_ID"
    }

    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get execute result.return($iRet).ERRCODE(3)"
    fi

    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        LOG "[$FUNCNAME] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi
    return $iRet
}

#ȡڵһIP
function get_backnet_ip
{
    local subnet_id=$( grep 'subnetwork_id_.=1' /opt/huawei/snas/etc/snas.ini |awk -F= '{print $1}'|awk -F_ '{print $3}'|sort -k1|head -n1 )
    if [ "$subnet_id" = "" ]; then
        LOG "[$FUNCNAME]Failed to get back subnet"
        return 1
    fi

    local IPAddress=$( grep ipaddr_${subnet_id} /opt/huawei/snas/etc/snas.ini | awk -F= '{print $2}' )
    if [ "$IPAddress" = "" ]; then
        LOG "[$FUNCNAME]Failed to get back subnet IP"
        return 1
    fi

    echo $IPAddress
    return 0
}

#ȡȺDFSڵһIP
function get_dfs_backnet_ip
{
    local dfs_nid=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select NID from CM_NODE_T where (Reserved2 = 0 OR Reserved2 = 1)")
    local dfs_ip=$(get_node_backnet_ip "${dfs_nid}")

    echo $dfs_ip
    return 0
}

#Զ˷أ[ERR]ʶ
handle_remote_result()
{
    local line=$1
    echo "$line" |grep "\[ERR\]" > /dev/null
    if [ $? -eq 0 ]; then
        echo "$line" | awk -F] '{print $2}'
        return 1
    fi

    echo "$line"
    return 0
}

#ȡָڵһIP
function get_node_backnet_ip
{
    local nid=$1
    local temp=1
    local iRet=0
    sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID limit 1"
    iRet=$?
    while [[ ${iRet} -ne 0 ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get back subnet IP of $nid from db"
        temp=$((temp + 1))
        if [ $temp -gt 5 ];then
            break
        fi
        sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID limit 1"
        iRet=$?
    done
    return $iRet
}

#############################################################################################

#276. û뼴
accountcheck()
{
    WRITE_XML_SUBCMD_HEADER $1
    local errResult=""

    #Զ첽ִУҪУipVALID_IP_FILE
    local TASK_ID=0
    local isPass=0
    local isPass_tmp=0
    local dfsFlag=0
    local account=""
    local result=""
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch_mml $TASK_ID 30 accountcheck.sh $FUNCNAME
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            LOG "[$FUNCNAME]:IP:$Item"
            dfsFlag=1

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get Node IO information"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                #errResult="IP: $Item||Error: exec (ShowNodeIO) failed.return($iRet),errno($errno)!||${errResult}"
                LOG "[$FUNCNAME]$Item exec(get Node ioperform progress) failed.return($iRet),errno($errno)!"
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        if [ $dfsFlag = 0 ]; then
            continue
        fi

        fifoContext=$( cat $G_TMP_FILE$Item )
        if [ "$fifoContext" = "" ];then
            continue
        fi

        dos2unix $G_TMP_FILE$Item
        #
        cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

        set_ifs
        if grep -q "Result:0" $G_TMP_FILE$Item ;then
            Result="Node:$Item||INFO:pass"
            WRITE_XML_COMMON 0 "$Result"
            continue
        fi
        isPass_tmp=$(grep "Result:" $G_TMP_FILE$Item | awk -F":" '{print $2}')
        if [ $isPass_tmp -eq 4 -a $isPass -ne 1 ];then
            isPass=4
        else
            isPass=1
        fi

        while read line ;do
            if  echo $line |grep -q "Result:" ;then
                continue
            fi
            account=$(echo $line | awk -F":" '{print $1}')
            info=$(echo $line | awk -F":" '{print $2}')
            WRITE_XML_ERROR 0 "Node:$Item||INFO:$account $info"
            LOG "[$FUNCTION] Node:$Item||INFO:$account $info"
        done < $G_TMP_FILE$Item
        restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#278. ͨԼ
check_gateway()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local TASK_ID="getinfo"
    local isPass=0

    local back_ip=$( get_backnet_ip )
    if [ "$back_ip" = "" ]; then
        errResult="INFO: Can't get local ip"
        LOG "[$FUNCNAME]:$errResult"
        isPass=1
        break
    fi
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    remote_exec_async_batch_mml $TASK_ID 120 check_gateway.sh $FUNCNAME
    isPass=$?
    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
        do
            >${VALID_IP_FILE}

            for Item in $ValidIP
            do
                Result=""

                #Ϊ100%֮ļأн
                remote_exec_checkfini $Item $TASK_ID "Can not get gateway information"
                iRet=$?

                if [ $iRet -eq 0 ];then
                    echo -n "$Item " >> ${VALID_IP_FILE}
                    continue
                elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                    isPass=1
                    continue
                fi

                remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    isPass=1
                    continue
                fi
            done
            ValidIP=$( cat ${VALID_IP_FILE} )
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                LOG "[$FUNCNAME]:IP:$Item,file is empty!"
                continue
            fi

            #set_ifs
            #local nodePass=$( grep "Result:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
            while read line; do
                info=$( handle_remote_result "$line" )
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node:$Item||INFO:$info"
                    LOG "[$FUNCNAME] Error: $info"
                    WRITE_XML_ERROR 0 "${errResult}"
                else
                    Result="Node:$Item||INFO:$info"
                    WRITE_XML_COMMON 0 "$Result"
                fi
            done < $G_TMP_FILE$Item
            #restore_ifs
        done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#279. ͰϢڴм״̬
checkbuckinfo()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local TASK_ID="getinfo"
    local isPass=0

    local back_ip=$( get_backnet_ip )
    if [ "$back_ip" = "" ]; then
        errResult="INFO: Can't get local ip"
        LOG "[$FUNCNAME]:$errResult"
        isPass=1
        break
    fi

    HAMIP=$( sudo cat /proc/monc_hamap |grep "role(1)"|awk -F "(" '{print $2}'|awk -F ")" '{print $1}' )
    if [ "$HAMIP" != "" ];then
        Item=$HAMIP
        remote_exec_async $Item $TASK_ID 120 "$G_MML_FILE_PATH/checkbuckinfo.sh $Item > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command.return($iRet).ERRCODE(1)"
            isPass=1
        else
            cat $G_REMOTE_TMP_FILE$FUNCNAME | sed -e 's/\x1B\[0;[3-4][0-9]m//g' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        fi
        LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$Item"
        Result=""

        #Ϊ100%֮ļأн
        remote_exec_checkfini $Item $TASK_ID "Can not get buckinfo information"
        iRet=$?
        if [ $iRet -ne 0 ] && [ $iRet -ne 2] && [ $iRet -ne 5 ];then
            isPass=1
        fi
        remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
        iRet=$?
        if [ $iRet -ne 0 ]; then
            isPass=1
        fi
        wait
        fifoContext=$( cat $G_TMP_FILE$Item )
        if [ "$fifoContext" = "" ];then
            LOG "[$FUNCNAME]:IP:$Item,file is empty!"
        fi

        set_ifs
        local nodePass=$( grep "Result:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        while read line; do
            info=$( handle_remote_result "$line" )
            if [ "X${nodePass}" != "XPass" ];then
                Result="Node:$Item||Check result:failed||INFO:$info"
                WRITE_XML_ERROR 0 "$Result"
                isPass=1
            else
                Result="Node:$Item||Check result:pass||INFO:$info"
                WRITE_XML_COMMON 0 "$Result"
            fi
        done < $G_TMP_FILE$Item
        restore_ifs
    else
        Result="Check result:pass||INFO:none-HA and standby-HA nodes do not need to inspect"
        WRITE_XML_COMMON 0 "$Result"
    fi
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#280. DNSregion
checkdomainname()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local TASK_ID="getinfo"
    local isPass=0

    local back_ip=$( get_backnet_ip )
    if [ "$back_ip" = "" ]; then
        errResult="INFO: Can't get local ip"
        LOG "[$FUNCNAME]:$errResult"
        isPass=1
        break
    fi
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    remote_exec_async_batch_mml $TASK_ID 120 checkdomainname.sh $FUNCNAME
    isPass=$?
    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
        do
            >${VALID_IP_FILE}

            for Item in $ValidIP
            do
                Result=""

                #Ϊ100%֮ļأн
                remote_exec_checkfini $Item $TASK_ID "Can not get domainname information"
                iRet=$?

                if [ $iRet -eq 0 ];then
                    echo -n "$Item " >> ${VALID_IP_FILE}
                    continue
                elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                    isPass=1
                    continue
                fi

                remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    isPass=1
                    continue
                fi
            done
            ValidIP=$( cat ${VALID_IP_FILE} )
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
                fifoContext=$( cat $G_TMP_FILE$Item )
                if [ "$fifoContext" = "" ];then
                    LOG "[$FUNCNAME]:IP:$Item,file is empty!"
                    continue
                fi

                set_ifs
                local nodePass=$( grep "Result:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
                if [ "X${nodePass}" != "XPass" ];then
                    isPass=1
                fi
                while read line; do
                    echo "$line" | grep "Result:"
                    if [ $? -eq 0 ];then
                        continue
                    fi
                    info=$( handle_remote_result "$line" )
                    if [ $? -ne 0 ];then
                        WRITE_XML_ERROR 0 "Node:$Item||INFO:$info"
                    else
                         WRITE_XML_COMMON 0 "Node:$Item||Check result:${nodePass}||INFO:$info"
                    fi

                done < $G_TMP_FILE$Item
                restore_ifs
        done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

function get_valid_back_ip_by_dsid()
{
    local ds_id=$1
    local back_ip=""
    local back_ips=""
    local i=1
    local cnt=0

    back_ip=$( grep "DS $ds_id " /proc/monc_dsmap|awk '{print $14}' )
    back_ips=$( sqlite3 ${CM_DB} "select IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 and NID=(select NID from CM_NODE_IP_T where SUBNET_ID=1 and IP_ADDR=\"$back_ip\" limit 1)" )
    cnt=$( echo "$back_ips" | wc -l )
    #echo "default:$back_ip all:$back_ips cnt:$cnt"
    while [ "$i" -le "$cnt" ]
    do
        back_ip=$( echo "$back_ips" | awk NR==$i'{print $1}' )
        #echo  "cur: $back_ip"
        #try ping
        for time in ${RepeatTimes[*]};do
            ping_result=$( ping -q -c 1 $back_ip  | grep received | awk '{print $4}' )
            local iRet=$?
            #echo "iRet:$iRet"
            if [ $iRet -ne 0 ];then
                sleep 10
            else
                break
            fi
        done

        if [ "$ping_result" != 0 ];then
            #echo "ping_result:$ping_result valide_ip:$back_ip"
            echo "$back_ip"
            return
        fi

        i=$((i + 1))
    done
}


#200.ļϵͳ򿪾CA45000
checkOpenFileCount_Async()
{
    WRITE_XML_SUBCMD_HEADER $1

    local count=0
    local Result=""
    local isPass=0
    local dfsFlag=0
    local TASK_ID=0

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    LOG "REMOTE_IP_S:$REMOTE_IP_S"

    #Զ첽ִ
    remote_exec_async_batch_mml $TASK_ID 30 ShowOpenFileCount $FUNCNAME
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1

            #Ƿִгɹ
            remote_exec_checkfini $Item $TASK_ID "Can not get OpenFileCount information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get information."
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi

            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            #
            dos2unix $G_TMP_FILE$Item
            count=$( cat $G_TMP_FILE$Item|grep "Open File Count"|awk '{print $5}' )

            if [ "$count" == "" ];then
                LOG "[$FUNCNAME]$Item count($count)"

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

                count="Can not get open file count."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Can not get open file count.ERRCODE(4)"
                isPass=1
                continue
            fi

            Result="Node:$Item||OpenFileCount:$count"
            WRITE_XML_COMMON 0 "$Result"

            if [ $count -lt 45000 ];then
                LOG "[$FUNCNAME]$Item count($count)"
            else
                LOG "[$FUNCNAME]$Item count($count) >= 45000"

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:The Open File Count(${count}) is exceeds the threshold(45000).ERRCODE(5)"
                isPass=1
            fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#201. ڵ
checkNodeThroughput()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local isPass=0
    local CmdPort=4016
    local numCnt=1

    while true; do
        local back_ip=$( get_backnet_ip )
        if [ "$back_ip" = "" ]; then
            WRITE_XML_ERROR 0 "Node:-(master)||INFO:Failed to get back_ip.ERRCODE(11)"
            LOG "[$FUNCNAME]:$errResult"
            isPass=1
            break
        fi

        $G_MML_FILE_PATH/ShowInspectMml $back_ip $CmdPort "cm nodeopsinfo"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        if [ $? -ne 0 ]; then
            Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            LOG "[$FUNCNAME]mml_result:($Info)"
            WRITE_XML_ERROR 0 "Node:$back_ip(Master)||INFO:Failed to execute MML command(cm nodeopsinfo),port(4016).return($iRet).ERRCODE(12)"
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME

        #
        set_ifs
        nodeCount=$( cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "nodeopsinfo:" | wc -l )
        if [ $nodeCount -le 0 ]; then
            WRITE_XML_ERROR 0 "Node:$back_ip(Master)||INFO: No Node OPS INFO,Can not get information.ERRCODE(13)"
            LOG "[$FUNCNAME]:No Node OPS INFO,Can not get information.ERRCODE(13)"

            isPass=1
            restore_ifs
            break
        fi

        while [ $numCnt -le $nodeCount ]; do

            NID=$( cat $G_REMOTE_TMP_FILE$FUNCNAME| grep "nodeopsinfo:" | awk NR==$numCnt |awk '{print $3}' )
            CifsOps=$( cat $G_REMOTE_TMP_FILE$FUNCNAME| grep "nodeopsinfo:" | awk NR==$numCnt |awk '{print $6}' )
            NfsOps=$( cat $G_REMOTE_TMP_FILE$FUNCNAME| grep "nodeopsinfo:" | awk NR==$numCnt |awk '{print $9}' )

            numCnt=$((numCnt+1))
            Nodeip=$( get_node_backnet_ip $NID )

            if [ "$NID" == "" ] || [ "$CifsOps" == "" ] || [ "$NfsOps" == "" ];then
                WRITE_XML_ERROR 0 "Node:$Nodeip||INFO: OPS INFO have errors.ERRCODE(4)"
                LOG "[$FUNCNAME]:OPS INFO have errors.ERRCODE(4)"
                isPass=1
                continue
            fi

            if [ "$CifsOps" -gt 25000 ] || [ "$NfsOps" -gt 20000 ]; then
               isPass=1
               WRITE_XML_ERROR 0 "Node:$Nodeip||INFO: Cifs_Ops($CifsOps) is exceeds the threshold(25000) or Nfs_Ops($NfsOps) is exceeds the threshold(20000).ERRCODE(5)"
               LOG "[$FUNCNAME]:OPS INFO have errors.ERRCODE(4)"
            fi

            service_type=$(get_service_type_from_db "${Nodeip}")
            if [ "${service_type}" != "1" ]; then
                LOG "service_type = ${service_type}.skip ${Nodeip}."
                WRITE_XML_ERROR 0 "Node:$Nodeip||INFO:Does not involve"
                isPass=0
                continue
            fi

            LOG "[$FUNCNAME]:Node:$Nodeip||NID:$NID||Cifs_Ops:$CifsOps||Nfs_Ops:$NfsOps"
            WRITE_XML_COMMON 0 "Node:$Nodeip||NID:$NID||Cifs_Ops:$CifsOps||Nfs_Ops:$NfsOps"

        done

        restore_ifs
        break
    done


    WRITE_XML_JUDGE ${isPass}
    WRITE_XML_SUBCMD_TAIL
}

checkIOPerform()
{
    rcount=$( cat $G_TMP_FILE$Item |grep '<read count>' |sed "s/[^0-9]//g" )
    wcount=$( cat $G_TMP_FILE$Item |grep '<write count>' |sed "s/[^0-9]//g" )
    ccount=$( cat $G_TMP_FILE$Item |grep '<cmd count>' |sed "s/[^0-9]//g" )
    rbytes=$( cat $G_TMP_FILE$Item |grep '<read bytes>' |sed "s/[^0-9]//g" )
    wbytes=$( cat $G_TMP_FILE$Item |grep '<write bytes>' |sed "s/[^0-9]//g" )
    maxcalldelay=$( cat $G_TMP_FILE$Item |grep '<max call delay(ms)>' |sed "s/[^0-9]//g" )
    maxreaddelay=$( cat $G_TMP_FILE$Item |grep '<max read delay(ms)>' |sed "s/[^0-9]//g" )
    maxwritedelay=$( cat $G_TMP_FILE$Item |grep '<max write delay(ms)>' |sed "s/[^0-9]//g" )
    totalcmddelay=$( cat $G_TMP_FILE$Item |grep '<total cmd delay(ms)>' |sed "s/[^0-9]//g" )
    totalreaddelay=$( cat $G_TMP_FILE$Item |grep '<total read delay(ms)>' |sed "s/[^0-9]//g" )
    totalwritedelay=$( cat $G_TMP_FILE$Item |grep '<total write delay(ms)>' |sed "s/[^0-9]//g" )

    result="IP:$2||Protocol:$1||CheckType:IO perform||Read count:${rcount}||Write count:${wcount}||Cmd count:${ccount}"
    result=${result}"||Read bytes:${rbytes}||Write bytes:${wbytes}"
    result=${result}"||max call delay(ms):${maxcalldelay}||max read delay(ms):${maxreaddelay}||max write delay(ms):${maxwritedelay}"
    result=${result}"||total cmd delay(ms):${totalcmddelay}||total read delay(ms):${totalreaddelay}||total write delay(ms):${totalwritedelay}"
    echo $result

    return 0
}

#202. ڵIOͳϢ
checkNodeIOPerform()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""

    #Զ첽ִвѯCIFSЭIOܣҪУipVALID_IP_FILE
    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowNodeIO > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            LOG "[$FUNCNAME]:IP:$Item"
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_COMMON 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get Node IO information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="Node: $Item||INFO: exec (ShowNodeIO) failed.return($iRet),errno($errno)!"
                LOG "[$FUNCNAME]$Item exec(get Node ioperform progress) failed.return($iRet),errno($errno)!"
                isPass=1
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        if [ $dfsFlag = 0 ]; then
            continue
        fi

        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ]; then
            continue
        fi

        fifoContext=$( cat $G_TMP_FILE$Item )
        if [ "$fifoContext" = "" ];then
            continue
        fi

        dos2unix $G_TMP_FILE$Item

        #
        cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

        set_ifs
        while read line; do
            info=$( handle_remote_result "$line" )
            if [ $? -ne 0 ]; then
               isPass=1
               WRITE_XML_ERROR 0 "Node:$Item||INFO:$info"
            else
                WRITE_XML_COMMON 0 "Node:$Item||INFO:$info"
            fi

        done < $G_TMP_FILE$Item
        restore_ifs

    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#204. MONϵͳ״̬: Ƿ״̬ͨMAPṩMMLӡmap
#uds֧
checkMonitorHeartbeat_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isOK=0
    local Info=""

    strNormal="Normal"
    len=${#strNormal}
    errResult=""
    local ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')
    #Զ첽ִҪУipVALID_IP_FILE
    local TASK_ID=0
    local isPass=0
    local back_ip=$( get_backnet_ip )
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    patchinfo=$(/opt/huawei/snas/upd/patch_script/cluster_patch.sh "$back_ip" show)
    Version=$(echo $patchinfo |grep Version |awk -F "," '{print $3}' |awk -F ":" '{print $2}')
    if [ "null" = "$Version" -o "$Version" \< "V300R006C00SPH207" ];then
        isPass=3
        Result="INFO:The hot patch version is not involved($Version)."
        WRITE_XML_COMMON 0 "$Result"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/GetMapInfo 2>&1"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            remote_exec_checkfini $Item $TASK_ID "Can not get GetMapInfo information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ] || [ $ProductType -eq 80 ];then
                LOG "service_type = ${service_type}.skip ${Item},ProductType=$ProductType"

                #Ϊ100%֮ļأн
                file_DsMap="DsMap"
                remote_download_sync $Item $G_TMP_FILE$file_DsMap /tmp/tmpfile$file_DsMap
                iRet0=$?

                if [ "$iRet0" != "0" ];then
                    errResult="Node: $Item||Error: (get mapinfo) get progress failed.iRet0($iRet0)||${errResult}"
                    LOG "[$FUNCNAME] (get mapinfo) get progress failed.iRet0($iRet0)||${errResult}"

                    isPass=1
                    continue
                fi

                #DS mapϢ #Ƿҵ 'ucState' ʶ #############################################
                isOK=0
                isFound=0
                set_ifs

                head_info="******************** DS Map *********************"
                WRITE_XML_COMMON 0 "Node:$Item||INFO:$head_info"

                while read line
                do
                    tmp=$( echo ${line} | grep 'ucState'  )
                    if [ "${tmp}" == "" ]; then
                        continue
                    fi
                    locator=$(echo ${line} | awk '{print $1" "$2}')
                    ucstate=$( echo ${line}  | grep 'ucState' | awk '{print $12}' )
                    if [ "${ucstate:0:$len}" != "Normal" ];then
                        LOG "[$FUNCNAME]$Item monc_dsmap ucstate($ucstate) is not Normal"
                        WRITE_XML_ERROR 0 "Node:$Item||INFO:monc_dsmap ID($locator) ucstate($ucstate) is not Normal.ERRCODE(4)"
                        isOK=1
                        isPass=1
                    fi
                    isFound=1
                done < $G_TMP_FILE$file_DsMap

                if [ "${isFound}" == "0" ]; then
                    LOG "[$FUNCNAME]$Item cat /proc/monc_dsmap isFound(${isFound})"
                    errResult="Node: $Item||Error: cat /proc/monc_dsmap ucState flag is not found.ERRCODE(5)"
                    WRITE_XML_ERROR 0 "${errResult}"
                    isPass=1
                elif [ "$isOK" == "0" ]; then
                    WRITE_XML_COMMON 0 "Node: ||INFO:All DS Map Normal"
                fi
                continue
            fi

            #Ϊ100%֮ļأн
            file_DsMap="DsMap"
            remote_download_sync $Item $G_TMP_FILE$file_DsMap /tmp/tmpfile$file_DsMap
            iRet0=$?

            file_MdsMap="MdsMap"
            remote_download_sync $Item $G_TMP_FILE$file_MdsMap /tmp/tmpfile$file_MdsMap
            iRet1=$?

            file_CaMap="CaMap"
            remote_download_sync $Item $G_TMP_FILE$file_CaMap /tmp/tmpfile$file_CaMap
            iRet2=$?

            file_PipMap="PipMap"
            remote_download_sync $Item $G_TMP_FILE$file_PipMap /tmp/tmpfile$file_PipMap
            iRet3=$?

            file_MonMap="Monc_MonMap"
            remote_download_sync $Item $G_TMP_FILE$file_MonMap /tmp/tmpfile$file_MonMap
            iRet4=$?

            if [ "$iRet0" != "0" ] || [ "$iRet1" != "0" ] || [ "$iRet2" != "0" ] || [ "$iRet3" != "0" ] || [ "$iRet4" != "0" ];then
                errResult="Node: $Item||Error: (get mapinfo) get progress failed.iRet0($iRet0),iRet1($iRet1),iRet2($iRet2),iRet3($iRet3), iRet4($iRet4)||${errResult}"
                LOG "[$FUNCNAME] (get mapinfo) iRet1($iRet1),iRet2($iRet2),iRet3($iRet3),iRet4($iRet4)"

                isPass=1
                continue
            fi

            #DS mapϢ #Ƿҵ 'ucState' ʶ #############################################
            isOK=0
            isFound=0
            set_ifs

            head_info="******************** DS Map *********************"
            WRITE_XML_COMMON 0 "Node:$Item||INFO:$head_info"

            while read line
            do
                tmp=$( echo ${line} | grep 'ucState'  )
                if [ "${tmp}" == "" ]; then
                    continue
                fi
                locator=$(echo ${line} | awk '{print $1" "$2}')
                ucstate=$( echo ${line}  | grep 'ucState' | awk '{print $12}' )
                if [ "${ucstate:0:$len}" != "Normal" ];then
                    LOG "[$FUNCNAME]$Item monc_dsmap ucstate($ucstate) is not Normal"
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:monc_dsmap ID($locator) ucstate($ucstate) is not Normal.ERRCODE(4)"
                    isOK=1
                    isPass=1
                fi
                isFound=1
            done < $G_TMP_FILE$file_DsMap

            if [ "${isFound}" == "0" ]; then
                LOG "[$FUNCNAME]$Item cat /proc/monc_dsmap isFound(${isFound})"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:cat /proc/monc_dsmap ucState flag is not found .ERRCODE(5)"
                isPass=1
            elif [ "$isOK" == "0" ]; then
                WRITE_XML_COMMON 0 "Node: ||INFO:All DS Map Normal"
            fi

            #mds mapϢ###################################################################
            isFound=0
            isOK=0
            head_info="**************** Active MDS Map *****************"
            WRITE_XML_COMMON 0 "Node: ||INFO:$head_info"

            while read line
            do
                tmp=$( echo ${line} | grep 'State'  )
                if [ "${tmp}" == "" ]; then
                    continue
                fi
                locator=$(echo ${line} | awk '{print $1" "$2}')
                state=$( echo ${line}  | grep 'State' | awk '{print $6}' )
                if [ "${state:0:$len}" != "Normal" ];then
                    LOG "[$FUNCNAME]$Item monc_mdsmap state($state) is not Normal"
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:monc_mdsmap ID($locator) State($state) is not Normal.ERRCODE(6)"
                    isPass=1
                    isOK=1
                fi
                isFound=1
            done < $G_TMP_FILE$file_MdsMap

            if [ "${isFound}" == "0" ]; then
                LOG "[$FUNCNAME]$Item cat /proc/monc_mdsmap isFound(${isFound}))"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:cat /proc/monc_mdsmap State flag is not found.ERRCODE(7)"
                isPass=1
            elif [ "$isOK" == "0" ]; then
                WRITE_XML_COMMON 0 "Node: ||INFO:All MDS Map Normal"
            fi

            #ca map״̬###################################################################
            isFound=0
            isOK=0
            head_info="******************** CA Map *********************"
            WRITE_XML_COMMON 0 "Node: ||INFO:$head_info"

            while read line
            do
                tmp=$( echo ${line} | grep 'State'  )
                if [ "${tmp}" == "" ]; then
                    continue
                fi
                locator=$(echo ${line} | awk '{print $1" "$2}')
                state=$( echo ${line}  | grep 'State' | awk '{print $6}' )
                if [ "${state:0:$len}" != "Normal" ];then
                    LOG "[$FUNCNAME]$Item monc_camap state($state) is not Normal"
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:monc_camap ID($locator) State($state) is not Normal.ERRCODE(8)"

                    isOK=1
                    isPass=1
                fi
                isFound=1
            done < $G_TMP_FILE$file_CaMap

            if [ "${isFound}" == "0" ]; then
                LOG "[$FUNCNAME]$Item cat /proc/monc_camap isFound(${isFound}))"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:monc_camap State flag is not found.ERRCODE(9)"
                isPass=1
            elif [ "$isOK" == "0" ]; then
                WRITE_XML_COMMON 0 "Node: ||INFO:All CA Map Normal"
            fi

            #pip map״̬###################################################################
            isFound=0
            isOK=0
            head_info="******************** PIP Map *********************"
            WRITE_XML_COMMON 0 "Node: ||INFO:$head_info"

            while read line
            do
                tmp=$( echo ${line} | grep 'State'  )
                if [ "${tmp}" == "" ]; then
                    continue
                fi

                nodeIp=$(echo ${line} | awk '{print $3}')
                local node_service_type=$(get_service_type_from_db "${nodeIp}")
                if [ "${node_service_type}" != "1" ]; then
                    continue
                fi

                state=$( echo ${line}  | grep 'State' | awk '{print $5}' )
                if [ "${state:0:$len}" != "Normal" ];then
                    LOG "[$FUNCNAME]$Item monc_pipmap state($state) is not Normal"
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:monc_pipmap IP($nodeIp) State($state) is not Normal.ERRCODE(10)"
                    isOK=1
                    isPass=1
                fi
                isFound=1
            done < $G_TMP_FILE$file_PipMap

            if [ "${isFound}" == "0" ]; then
                LOG "[$FUNCNAME]$Item cat /proc/monc_pipmap isFound(${isFound}))"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:cat /proc/monc_pipmap State flag is not found.ERRCODE(14)"
                isPass=1
            elif [ "$isOK" == "0" ]; then
                WRITE_XML_COMMON 0 "Node: ||INFO:All PIP Map Normal"
            fi

        #mon map״̬###################################################################
            isFound=0
            isOK=0
            head_info="******************** Mon Map *********************"
            WRITE_XML_COMMON 0 "Node: ||INFO:$head_info"

            MonMapNum=$( cat $G_TMP_FILE$file_MonMap | grep iRank | wc -l )
            DsMapNum=$( cat $G_TMP_FILE$file_DsMap | grep IpAddr | wc -l )

            if [ $MonMapNum -ne $DsMapNum ]; then
                WRITE_XML_ERROR 0 "Node:$Item||INFO:MonMapNum($MonMapNum) is not same with DsMapNum($DsMapNum).ERRCODE(15)"
                isPass=1
            else
                WRITE_XML_COMMON 0 "Node: ||INFO:All Mon Map Normal"
            fi

            restore_ifs

        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done


    WRITE_XML_JUDGE ${isPass}
    WRITE_XML_SUBCMD_TAIL
}

#205. NTP״̬/server
checkNTPService_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local isConnected
    local ntpServer=""

    ALLIp=$( cat $IP_ROLE_FILE )

    >${VALID_IP_FILE}

    for Item in $ALLIp
    do
        #ԶΪ첽ִ
        remote_exec_async $Item 0 120 "service ntp status > $G_REMOTE_TMP_FILE$FUNCNAME"
        iRet=$?
        remote_exec_async $Item 1 30 "cat /etc/ntp.conf > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
        iRet2=$?
        if [ $iRet -ne 0 ] || [ $iRet2 -ne 0 ] ; then
            errResult="Node: $Item||Error: ${iRet}||$errResult"

            errResult="Node: $Item||Error: ${iRet2}||$errResult"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command.return1(${iRet}),return2(${iRet2}),ERRCODE(1)"
            isPass=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=$( cat ${VALID_IP_FILE} )

    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            #Ϊ100%֮ļأн
            TASK_ID=0
            remote_exec_checkfini $Item $TASK_ID "Can not get service ntp status information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            state=$( cat $G_TMP_FILE$Item |grep 'NTPD' | awk -F : '{ print $2}' | sed "s/[^a-z]//g" )
            if [ $? -ne 0 ]; then
                isPass=1
                Status="Can not get NTP status."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Can not get NTPD status.ERRCODE(4)"
                LOG "[$FUNCNAME]$Item $Status"
            elif [ "${state}" != "running" ];then
                isPass=1
                Status="NTP service is NOT running."
                LOG "[$FUNCNAME]$Item $Status"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:NTP service is NOT running.ERRCODE(5)"
            else
                Status="NTP service is running."
            fi

            #Ϊ100%֮ļأн #########################################
            TASK_ID=1
            remote_exec_checkfini $Item $TASK_ID "Can not get /etc/ntp.conf information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download_sync $Item $G_TMP_FILE2$Item $G_REMOTE_TMP_FILE2$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi

            #
            cat $G_TMP_FILE2$Item >> $LOG_FILE 2>&1

            server=$( cat $G_TMP_FILE2$Item |grep server | sed '/#/d'|awk '{print $2}' )
            if [ $? -ne 0 ] || [ "$server" == "" ]; then
                isPass=1
                server="Can not get NTP server."
                connectState="--"
                LOG "[$FUNCNAME]$Item $server"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Can not get NTP server.ERRCODE(6)"
            else
                LOG "[$FUNCNAME]$Item $server"
                isConnected=0
                for ip in ${server[*]}
                do
                    for time in ${RepeatTimes[*]}; do
                        tempStr_ping=$( ping -q -c 1 $ip |grep "1 received" |wc -l )
                        if [ "1" != "$tempStr_ping" ];then
                            tempStr_ping=$( ping6 -q -c 1 $ip |grep "1 received" |wc -l )
                        fi
                        local iRet=$?
                        LOG "[$FUNCNAME] tempStr_ping=$tempStr_ping,iRet=$iRet"
                        if [ $iRet -ne 0 ]; then
                            sleep 10
                        else
                            break
                        fi
                    done
                    if [ "1" == "$tempStr_ping" ];then
                        connectState="OK"
                        isConnected=1
                        ntpServer="$ip"
                        break
                    fi
                done
                if [ $isConnected -eq 0 ]; then
                    connectState="Can not access."
                    ntpServer=`echo ${server} | tr '\n' ' '`
                    isPass=1
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:Server $ntpServer Can not access.ERRCODE(7)"
                fi
            fi

            Result="RunningStatus:$Status||Server:$ntpServer||ConnectingStatus:$connectState"
            WRITE_XML_COMMON 0 "Node:$Item||$Result"
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#206. CMڵ
checkCMMaster()
{
    WRITE_XML_SUBCMD_HEADER $1
    local CMMasterNID=0
    local isPass=0
    local NID_before=""
    local TASK_ID=0
    local masterIP=""

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch_mml $TASK_ID 30 ShowCMMaster $FUNCNAME
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
    >${VALID_IP_FILE}

        for Item in $ValidIP; do

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get cmmaster information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            dos2unix $G_TMP_FILE$Item

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            set_ifs
            while read line; do
                info=$( handle_remote_result "$line" )
                if [ $? -ne 0 ]; then
                    isPass=1
                    LOG "[$FUNCNAME] Error: $info"
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:$info"
                    continue
                fi

                #ȡ
                masterNID=$( cat $G_TMP_FILE$Item | grep CMMasterNID | awk '{print $2}' )
                LOG "[$FUNCNAME]:masterNID:$masterNID,NID_before:$NID_before"

                if [ "$masterNID" == "" ]; then
                    isPass=1
                    LOG "[$FUNCNAME] Error: No CM MasterNID info"

                    WRITE_XML_ERROR 0 "Node:$Item||INFO:No masterNID info.ERRCODE(6)"
                    continue
                fi

                masterIP=$( get_node_backnet_ip $masterNID )
                Result="Node:$Item||CMMasterNID:$masterNID||CMMasterIP:$masterIP"

                if [ "$NID_before" != "" ];then
                    if [ "$NID_before" != $masterNID ];then
                        isPass=1
                        WRITE_XML_ERROR 0 "Node:$Item||INFO:The masterNID($NID_before) recorded by the current node is not the same as the masterNID($masterNID) recorded by the primary node.ERRCODE(7)"
                    fi
                fi

                NID_before=$masterNID
                WRITE_XML_COMMON 0 "${Result}"

            done < $G_TMP_FILE$Item
            restore_ifs
    done

    local tmpIP=`grep "^ip=" /opt/huawei/snas/etc/cm.ini | sed 's/ip=//'`
    #Ѿ鵽ڵˣѲ½ľǸIPһжڵǲԼ
    local myNid=`grep "NID=" /opt/huawei/snas/etc/cm.ini | sed 's/NID=//'`
    if [ "$myNid" != "$NID_before" ];then
        isPass=1
        WRITE_XML_ERROR 0 "Node:${tmpIP}||INFO:The master ip is not on master node!"
    fi
    #CM/monǲ
    local cm_master_ip=$(/opt/huawei/snas/script/getCmMaster.sh)
    local mon_leader=$(cat /proc/monc_leader | grep -Po '(?<=Mon leader: )[0-9.]*')
    if [ -z "${cm_master_ip}" ] || [ -z "${mon_leader}" ];then
        LOG "[$FUNCNAME][$LINENO]ERROR:Failed to get leader IP of cm or mon!"
        WRITE_XML_ERROR 0 "Node:${tmpIP}||INFO:Failed to get leader IP of cm or mon!"
        isPass=1
    else
        echo ${cm_master_ip} | grep -wFq ${mon_leader}
        if [ $? -eq 0 ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:${tmpIP}||INFO:Cm and mon's leader are on the same node!"
            LOG "[$FUNCNAME][$LINENO]ERROR:Cm and mon's leader are on the same node!"
        else
            LOG "[$FUNCNAME][$LINENO]OK:Cm and mon's leader are on the different node!"
        fi
    fi
    LOG "[$FUNCNAME][$LINENO]:myNid:$myNid,NID_before:$NID_before"

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#207. ISM״̬ISM/CM״̬
checkISMStatus_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Status=""
    local hbStatus=""
    local Result=""
    local process=""
    local isPass=0
    local iRet=0
    local iRet_ISM=0
    local iRet_ibase=0
    local subDomain=""

    ALLIp=$( cat $IP_ROLE_FILE )

    >${VALID_IP_FILE}
    #˷0ip
    for item in $ALLIp
    do
        remote_exec $item 30 "cat /opt/huawei/snas/etc/cm.ini | grep "SubDomain=0" >> /dev/null 2>&1"
        if [ $? -eq 0 ];then
            echo -n "$item " >> ${VALID_IP_FILE}
            continue
        fi
        LOG "item is not SubDomain=0"
    done

    ALLSubDomain0Ip=$( cat ${VALID_IP_FILE} )
    >${VALID_IP_FILE}
    for Item in $ALLSubDomain0Ip
    do
        #ԶΪ첽ִ
        remote_exec_async $Item 0 30 "/opt/huawei/snas/script/inspect_mml/ShowISMInfo > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet1=$?
        sleep 1
        remote_exec_async $Item 1 30 "lsof -i :8080|grep ESTABLISHED|grep ibase > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
        iRet2=$?

        if [ $iRet1 -ne 0 ] || [ $iRet2 -ne 0 ] ; then

            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to excute command ,execute ShowISMInfo return($iRet1), execute lsof return($iRet2).ERRCODE(1)"
            LOG "execute ShowISMInfo return $iRet1; execute lsof return $iRet2"
            echo $FUNCNAME >>  /var/log/inspect.log
            cat $G_REMOTE_TMP_FILE$FUNCNAME  >> /var/log/inspect.log
            cat $G_REMOTE_TMP_FILE2$FUNCNAME  >> /var/log/inspect.log
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=$( cat ${VALID_IP_FILE} )

    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            #Ϊ100%֮ļأн ӷظ ÿεȴ10
            remote_exec_checkfini $Item 0 "Can not get ISMInfo"
            iRet_ISM=$?
            remote_exec_checkfini $Item 1 "Can not get HTBTinfo "
            iRet_ibase=$?
            if [ $iRet_ISM -eq 0 -o $iRet_ibase -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet_ISM -ne 2 -a $iRet_ISM -ne 5 ] || [ $iRet_ibase -ne 2 -a $iRet_ibase - ne 5 ];then
                isPass=1
                continue
            fi

            remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi

            #ism״̬
            process=$(cat $G_TMP_FILE$Item |grep -v "SubDomain")
            SubDomain=$(cat $G_TMP_FILE$Item |grep "SubDomain" |awk -F "=" '{print $2}')
            if [ "${SubDomain}" != "0" ]; then
                continue
            fi

            if [ "$process" != "" ];then
                Status="DeviceManager is running."
            else
                Status="DeviceManager is not running."
                LOG "[$FUNCNAME]$Item $Status, process($process)"
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:${Status}.ERRCODE(4)"
            fi

            remote_download_sync $Item $G_TMP_FILE2$Item $G_REMOTE_TMP_FILE2$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
            #ismcm״̬
            hbStatus=$( cat $G_TMP_FILE2$Item )

            if [ "$hbStatus" != "" ];then
                htbtStatus="Normal"
            else
                htbtStatus="Abnormal"
                LOG "[$FUNCNAME]$Item htbtStatus($htbtStatus) not Normal"
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:htbtStatus($htbtStatus) not Normal.ERRCODE(5)"
            fi

            Result="IP:$Item||DeviceManagerStatus:$Status||HTBTStatus:$htbtStatus"
            WRITE_XML_COMMON 0 "$Result"
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#208. license״̬
checkLicenseStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local iRet=0

    while true; do

        local back_ip=$( get_backnet_ip )
        if [ "$back_ip" = "" ]; then
            LOG "[$FUNCNAME]:INFO: Can't get local ip"
            isPass=1
            WRITE_XML_ERROR 0 "Node:-(master)||INFO:Can't get local ip.ERRCODE(11)"
            break
        fi

        #ִmml cm licensecfg
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm licensecfg"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            LOG "[$FUNCNAME]mml_result:$Info"
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to execute MML command(cm licensecfg),port(4016).return($iRet).ERRCODE(12)"
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1

        Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "get license res cfg fail" )
        if [ "$Info" != "" ];then
            #һжǷмlicenseļ
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:License is not activated.ERRCODE(4)"
            break
        fi

        javaID=$( cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "acFeatureName"|sed 's/^ *//g'|sed "/^$/d" )

        if [ "$javaID" = "" ];then
            LOG "[$FUNCNAME]:$line,javaID is null"
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:No license resource active.ERRCODE(5)"
            break
        fi

        set_ifs
        for line in $javaID
        do
            if [ $line = "" ];then
                continue
            fi
            #ʽacFeatureName : WiseQuota || acLicRunTime : 1375113600000 || uiResLKVal : 10.
            #ʽacFeatureName : WiseLink || acLicRunTime : 1375113600000 || uiResLKVal : 10.
            #ʽacFeatureName : WiseTier || acLicRunTime : 1375113600000 || uiResLKVal : 10.

            Feature=$( echo $line |awk '{print $3}' )
            MaxNumber=$( echo $line |awk '{print $11}'|sed 's/\./ /g' )
            Deadline=$( echo $line |awk '{print $7}' )
            LOG "Deadline:$Deadline"
            if [ "${Deadline}" == "9999-12-31" ];then
                date1=$(date --date "${Deadline}" +%s)
                Deadline="PERMANENT"
            else
                date1=$( expr $Deadline \/ 1000 )
                Deadline=$( date --date "1970-01-01 UTC $date1 seconds" +"%Y-%m-%d %T %z" )
            fi
            LOG "Deadline:$Deadline"
            date2=$( date )

            t1=$date1
            t2=$( date --date "$date2" +%s )
            LOG "Deadline:$t1,CurrentTime:$t2"

            LOG "[$FUNCNAME]:$line"

            if [ $t1 -gt $t2 ]; then
                LOG "$Deadline > $date2"
                Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline"
                LOG "[$FUNCNAME_gt]:Result($Result)"
                WRITE_XML_COMMON 0 "$Result"
            elif [ $t1 -eq $t2 ]; then
                LOG "$Deadline == $date2"
                Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline"
                LOG "[$FUNCNAME_eq]:Result($Result)"
                WRITE_XML_COMMON 0 "$Result"
            else
                LOG "$Deadline < $date2"
                isPass=1
                LOG "isPass:$isPass"

                Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline"
                LOG "[$FUNCNAME_expired]:Result($Result)"
                WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Feature($Feature) over DeadLine($Deadline).ERRCODE(6)"
            fi
        done
        restore_ifs

        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#һΧڵ
function ProduceRandom()
{
    min=$1
    max=$2-$1
    num=$(date +%s+%N)
    ((retnum=num%max+min))
    echo $retnum
}

#209. ļϵͳ    ֳ֧ļв    ضĿ¼ִдĿ¼/ļ//ӲӵȲ
checkFileOperation_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local Info=""

    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/ShowFileOperation > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    sleep 10

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do

             #checkڵ
             service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_COMMON 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get FileOperation information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                continue
            fi
        done

        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi

            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            set_ifs
            while read line; do
                info=$( handle_remote_result "$line" )
                if [ $? -ne 0 ]; then
                    isPass=1
                fi

                WRITE_XML_COMMON 0 "Node:$Item||INFO:$info"

            done < $G_TMP_FILE$Item
            restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#NASЭ    ӵĿͻ    ͻIP/Э            NASЭ
#NASȺ״̬                            CM
#wiselink    ״̬                    NASЭ
#    OPS                            NASЭ

checkNASClient()
{
    local Item=$1
    local res=$(cat $G_TMP_FILE$Item)
    if [ "${res}" == "Does not involve" ];then
        LOG "res:${res}"
        result="$res"
        return 0
    fi

    client_ip=$( cat $G_TMP_FILE$Item |grep "ip_clnt"|awk -F">" '{print $2}'| awk -F"<" '{print $1}' )
    client_num=$( cat $G_TMP_FILE$Item |grep "ip_clnt"|awk -F">" '{print $2}'| awk -F"<" '{print $1}'|wc -l )
    client_protocal=$( cat $G_TMP_FILE$Item |grep "proto_type"| sed 's/[^A-Z]//g' )
    result="LocalIp:$1||client_num:${client_num}||client_type:$2"

    info=$( cat $G_TMP_FILE$Item )
    LOG "[$FUNCNAME] $1 ,info:$info"
    LOG "client_num:$client_num"

    if [ ${client_num} -gt 400 ];then
        LOG "[$FUNCNAME]$1 ${client_protocal} client num(${client_num}) over 400!"
        echo $result
        return 1
    else
        echo "LocalIp:$1||client_num:$client_num||client_type:$2"
    fi
}

#===================================================
# ƣȡcm_conf.dbнڵӦķ
# ܣ
# 
#===================================================
function get_service_type_from_db()
{
    local temp=1
    local ip=$1
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    local service_type=$(/usr/bin/sqlite3 ${CM_DB} "select Reserved2 from CM_NODE_T where NID='${nid}'" | tr -d ' ')
    while [[ "${service_type}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get service_type from db ,temp=$temp"
        service_type=$(/usr/bin/sqlite3 ${CM_DB} "select Reserved2 from CM_NODE_T where NID='${nid}'" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done

    echo ${service_type}
}
#===================================================
# ƣȡcm_conf.dbнڵӦIP
# ܣͨڵĺIPݿжϵǰڵIPV4 or IPV6
# 
#===================================================
function get_frontip_type()
{
    local temp=1
    local ip=$1
    local FrontIP=""
    local iret=0
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    #ȡڵһǰIP
    local FrontIP=$(/usr/bin/sqlite3 ${CM_DB} "select IP_ADDR from CM_NODE_IP_T where NID='${nid}' and SUBNET_ID=2 limit 1" | tr -d ' ')
    while [[ "${FrontIP}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get FrontIP from db ,temp=$temp"
        FrontIP=$(/usr/bin/sqlite3 ${CM_DB} "select IP_ADDR from CM_NODE_IP_T where NID='${nid}' and SUBNET_ID=2 limit 1" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    #IPûðűʾIPV4
    echo $FrontIP|grep -q "\:" > /dev/null
    iret=$?
    echo ${iret}
}

#===================================================
# ƣȡcm_conf.dbнڵӦĽڵ
# ܣͨڵĺIPݿȡڵ
# 
#===================================================
function get_node_hostname_from_db()
{
    local temp=1
    local ip=$1
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    local hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
    while [[ "${hostname}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get node hostname from db ,temp=$temp"
        hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done

    echo ${hostname}
}


#210. NASӵĿͻ
checkALLClient()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""

    local TASK_CIFS_ID=0
    local isPass=0
    local dfsFlag=0

    local isGotClientCIFS=1
    local isGotClientNFS=1

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch $TASK_CIFS_ID 30 "cat /var/lib/smbd/conn_info > $G_REMOTE_TMP_FILE$FUNCNAME[CIFS] 2>&1"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi
            dfsFlag=1
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_CIFS_ID "Can not get conn_info information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            #ݽ
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[CIFS]
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi

            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                #WRITE_XML_ERROR 0 "Node:$Item||INFO:The CIFS client does not exist"
                WRITE_XML_COMMON 0 "Node:$Item||Client_Type:CIFS||SMB1:--||SMB2:--||SMB3:--||NFSV3:--||NFSV4:--"
                continue
            fi
            > /tmp/checkALLClient[CIFS]
            while read line; do
                raddr=$(echo $line |grep -w raddr |awk '{print $4}' |awk -F: '{print $2}')
                if [ "X${raddr}" == "X" ];then
                    continue
                fi
                vers=$(echo $line |grep -w vers |awk '{print $22}' |awk -F: '{print $2}')
                echo "raddr=$raddr vers=$vers" >>/tmp/checkALLClient[CIFS]
                LOG "raddr=$raddr vers=$vers"
            done < $G_TMP_FILE$Item

            SMB1=$(cat /tmp/checkALLClient[CIFS] |sort -u |grep "vers=1" |wc -l)
            SMB2=$(cat /tmp/checkALLClient[CIFS] |sort -u |grep "vers=2" |wc -l)
            SMB3=$(cat /tmp/checkALLClient[CIFS] |sort -u |grep "vers=3" |wc -l)

            WRITE_XML_COMMON 0 "Node:$Item||Client_Type:CIFS||SMB1:$SMB1||SMB2:$SMB2||SMB3:$SMB3||NFSV3:--||NFSV4:--"
    done



    #ȡnfsͻ
    TASK_NFS_ID=1
    remote_exec_async_batch $TASK_NFS_ID 30 "cat /proc/fs/nfsd/conn_info > $G_REMOTE_TMP_FILE$FUNCNAME[NFS] 2>&1"
    if [ "${isPass}" -eq "0" ];then
        isPass=$?
    fi

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do

            #checkڵ
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                continue
            fi

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_NFS_ID "Can not get nas_proto_status_nfs information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            #ݽ
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[NFS]
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi

            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                #WRITE_XML_ERROR 0 "Node:$Item||INFO:The NFS client does not exist"
                WRITE_XML_COMMON 0 "Node:$Item||Client_Type:NFS||SMB1:--||SMB2:--||SMB3:--||NFSV3:--||NFSV4:--"
                continue
            fi

            > /tmp/checkALLClient[NFS]
            while read line; do
                raddr=$(echo $line |grep -w raddr |awk '{print $4}' |awk -F: '{print $2}')
                if [ "X${raddr}" == "X" ];then
                    continue
                fi
                vers=$(echo $line |grep -w vers |awk '{print $22}' |awk -F: '{print $2}')
                echo "raddr=$raddr vers=$vers" >>/tmp/checkALLClient[NFS]
                LOG "raddr=$raddr vers=$vers"
            done < $G_TMP_FILE$Item

            NFSV3=$(cat /tmp/checkALLClient[NFS] |sort -u |grep "vers=3" |wc -l)
            NFSV4=$(cat /tmp/checkALLClient[NFS] |sort -u |grep "vers=4" |wc -l)
            WRITE_XML_COMMON 0 "Node:$Item||Client_Type:NFS||SMB1:--||SMB2:--||SMB3:--||NFSV3:$NFSV3||NFSV4:$NFSV4"
    done
    [ -f "/tmp/checkALLClient[CIFS]" ] && rm -f "/tmp/checkALLClient[CIFS]"
    [ -f "/tmp/checkALLClient[NFS]" ] && rm -f "/tmp/checkALLClient[NFS]"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#211. NASȺ״̬InfoEqualizer״̬
checkNASClusterStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local dfsFlag=0
    local NASStatus=""
    local AbnormalInfo=""
    local unusedInfo=""

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    #ȡnascifsϢ
    local TASK_ID="getNASStatus"
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowNasState > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get nascifs status information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi

            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ]; then
                continue
            fi

            dos2unix $G_TMP_FILE$Item

            set_ifs
            Result=""
            NASStatus=`cat $G_TMP_FILE$Item`
            if [ "$NASStatus" == "" ];then
                isPass=1
                echo "faile0:$isPass no 0"
                Result="Node:$Item||InfoEqualizer_Status:Unknown||CIFS_Status:Unknown||NFS_Status:Unknown"
            else
                AbnormalInfo=`echo $NASStatus | grep "Abnormal"`
                unusedInfo=`echo $NASStatus | grep "unused"`
                Result="$NASStatus"
                if [ "$AbnormalInfo" != "" ] || [ "$unusedInfo" != "" ];then
                    isPass=1
                    echo "faile1:$isPass no 0"
                fi
            fi

            restore_ifs
            WRITE_XML_COMMON 0 "Node:$Item||$Result"
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#212. ̿ռʹ    DSṩ̿ռʹ
checkDSUsage()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local isPass=0
    local AllUsedCap=0
    local CalResult=0
    local DiskPoolNum=0
    local NodePoolCnt=0
    local L_TMP_FILE="/tmp/tmpfile_checkDSUsage"
    local L_LINE_FILE="/tmp/tmplinefile_checkDSUsage"
    local L_TOTALCAP_FILE="/tmp/l_totalcapfile_checkDSUsage"
    local L_TMP_TOTALCAP_FILE="/tmp/tmptotalcapfile_checkDSUsage"
    local L_TMP_INFO_FILE="/tmp/l_tmpinfofile_checkDSUsage"
    local L_IP_FILE="/tmp/l_ipfile_checkDSUsage"
    local path_list="${L_TMP_FILE} ${L_LINE_FILE} ${L_TOTALCAP_FILE} ${L_TMP_TOTALCAP_FILE} ${L_TMP_INFO_FILE} ${L_IP_FILE}"
    for tmp_path in ${path_list}
    do
        check_symbolic ${tmp_path}
        if [ $? -eq 0 ];then
            rm -f ${tmp_path}
        fi
    done
    >$L_TOTALCAP_FILE
    >$L_IP_FILE
    cat /proc/monc_dsmap > $L_TMP_FILE 2>&1
    iRet=$?
    if [ $iRet -ne 0 ]; then
        Info=`cat $L_TMP_FILE`
        Result="INFO:exec(cat /proc/monc_dsmap) failed!errno($iRet,$Info)"
        LOG "[$FUNCNAME]$Item exec(cat /proc/monc_dsmap) failed!errno($iRet),${Info}"
        isPass=1
        WRITE_XML_ERROR 0 "Node:--||$Result"
    else
        #ȡк
        set_ifs
        awk '/IpAddr/{print NR}' $L_TMP_FILE > $L_LINE_FILE
        count=1
        nodesNum=`cat $L_LINE_FILE|wc -l`
        while [ $count -le $nodesNum ]
        do
            line1=`cat $L_LINE_FILE|sed -n $count'p'`
            count=`expr $count \+ 1`
            if [ $count -le $nodesNum ];then
                line2=`cat $L_LINE_FILE|sed -n $count'p'`
            else
                line2=`cat $L_TMP_FILE|wc -l`
            fi
            line2=`expr $line2 \- 1`

            sed -n $line1,$line2'p' $L_TMP_FILE > $L_TMP_INFO_FILE
            cat $L_TMP_INFO_FILE | grep "TotalCap" > $L_TMP_TOTALCAP_FILE
            IPAddress="$( cat $L_TMP_INFO_FILE|grep "IpAddr"|awk '{print $14}' )"
            sed -i 's/$/& '$IPAddress'/g' $L_TMP_TOTALCAP_FILE
            NodePoolCnt="$( cat $L_TMP_INFO_FILE|grep "IpAddr"|awk '{print $4}' )"
            sed -i 's/$/& '$NodePoolCnt'/g' $L_TMP_TOTALCAP_FILE
            cat $L_TMP_TOTALCAP_FILE >> $L_TOTALCAP_FILE
            echo $IPAddress >> $L_IP_FILE
        done
        DiskPoolNum=$(cat $L_TOTALCAP_FILE|sed 's/^ *//g'|sed "/^$/d"|grep "DiskPool"|awk '{print $6}'|sort -u)
        for typenum in $DiskPoolNum
        do
            local MaxCap=0
            local MixCap=0
            local maxCapIp=""
            local minCapIp=""
            local maxRate=0
            local minRate=101
            local maxId=101
            local minId=101
            local maxRateIp=""
            local minRateIp=""
            local DSTotalCap=0
            local maxDSTotalCap=0
            local maxDSTotalCapIP=""
            for ip in $(cat $L_IP_FILE)
            do
                AllUsedCap=0
                DSTotalCap=0
                javaID=$(cat $L_TOTALCAP_FILE|sed 's/^ *//g'|sed "/^$/d"|grep "DiskPool $typenum" | awk -v vip="$ip" '{if (vip == $(NF - 1)){print $0}}')
                if [ "x" != "x${javaID}" ];then
                    for line in $javaID
                    do
                        local usedRate=0
                        local id=$(echo $line|awk '{print $2}')
                        local totalCap=`echo $line|awk '{print $10}'`
                        local freeCap=`echo $line|awk '{print $12}'`
                        local usedCap=`expr $totalCap \- $freeCap`
                        if [ $totalCap -eq 0 ];then
                            usedRate=0
                        else
                            usedRate=$(echo "$usedCap * 100 / $totalCap" | bc)
                        fi
                        #λֽתGB
                        usedCap=`expr $usedCap / 1073741824`
                        AllUsedCap=`expr $AllUsedCap \+ $usedCap`
                        totalCap=`expr $totalCap / 1073741824`
                        DSTotalCap=`expr $DSTotalCap \+ $totalCap`
                        NodePoolCnt=`echo $line|awk '{print $18}'`
                        if [ $usedRate -gt $maxRate ]; then
                            maxRate=$usedRate
                            maxId="$id"
                            maxRateIp="$ip"
                        fi
                        if [ $minRate -eq 101 -o $usedRate -lt $minRate ]; then
                            minRate=$usedRate
                            minId=$id
                            minRateIp="$ip"
                        fi
                        WRITE_XML_COMMON 0 "IP:$ip||PoolID:${id}||Used Capacity(GB):$usedCap||Used Rate:${usedRate}% ||DiskPool Number:$typenum||NodePoolNumber:--"
                    done
                    if [ $AllUsedCap -gt $MaxCap ]; then
                        MaxCap=$AllUsedCap
                        maxCapIp="$ip"
                    fi
                    if [ $DSTotalCap -gt $maxDSTotalCap ]; then
                        maxDSTotalCap=$DSTotalCap
                        maxDSTotalCapIP="$ip"
                    fi
                    if [ $MixCap -eq 0 -o $AllUsedCap -lt $MixCap ]; then
                        MixCap=$AllUsedCap
                        minCapIp="$ip"
                    fi
                    LOG "[$FUNCNAME]ip:$ip  DiskPool Number:$typenum NodePoolCnt:$NodePoolCnt totalCap:$totalCap freeCap:$freeCap usedCap:$usedCap MaxCap:$MaxCap MixCap:$MixCap"
                    WRITE_XML_COMMON 0 "IP:$ip||PoolID:--||Used Capacity(GB):$AllUsedCap||Used Rate:--||DiskPool Number:$typenum||NodePoolNumber:$NodePoolCnt"
                fi
            done
            #ֵ
            CalResult=`expr $MaxCap \- $MixCap`
            local DSTotalCapPer3=$(echo "$maxDSTotalCap * 3 / 100" | bc)
            local DSTotalCapPer5=$(echo "$maxDSTotalCap * 5 / 100" | bc)
            LOG "[$FUNCNAME]Data capacity difference(GB):$CalResult DiskPool Number:$typenum NodePoolNumber:$NodePoolCnt maxDSTotalCapIP:$maxDSTotalCapIP DSTotalCap:$maxDSTotalCap DSTotalCapPer3:$DSTotalCapPer3 DSTotalCapPer5:$DSTotalCapPer5"
            if [ ${CalResult} -gt ${DSTotalCapPer5} ]; then
                isPass=$(check_pass ${isPass} 1)
                WRITE_XML_ERROR 0 "Node:--||INFO:Diskpool($typenum) used capacity difference ($CalResult GB) exceeds 5% of TotalCap (${DSTotalCapPer5}).(Node:${maxCapIp},${MaxCap}GB; Node:${minCapIp},${MixCap}GB)"
            elif [ ${CalResult} -gt ${DSTotalCapPer3} ]; then
                isPass=$(check_pass ${isPass} 4)
                WRITE_XML_ERROR 0 "Node:--||INFO:Diskpool($typenum) used capacity difference ($CalResult GB) exceeds 3% of TotalCap (${DSTotalCapPer3}).(Node:${maxCapIp},${MaxCap}GB; Node:${minCapIp},${MixCap}GB)"
            fi

            local CalRate=$(expr $maxRate \- $minRate)
            if [ $CalRate -gt 10 ]; then
                isPass=$(check_pass ${isPass} 4)
                WRITE_XML_ERROR 0 "Node:--||INFO:Single disk usage in Diskpool($typenum) differs by more than 10%.(Node:${maxRateIp},PoolId:${maxId},${maxRate}%; Node:${minRateIp},PoolId:${minId},${minRate}%)."
            fi
        done
        restore_ifs
    fi
    rm -rf $L_TMP_FILE $L_LINE_FILE $L_TOTALCAP_FILE $L_TMP_TOTALCAP_FILE $L_TMP_INFO_FILE $L_IP_FILE
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#213. ڵϵͨѶ·
checkCommuLink()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local TASK_ID=0
    local isPass=0
    local isFind=0
    local JavaId=""

    #ݿȡнڵĺIP
    JavaId=$( sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1;' | sort|uniq )
    if [ $? -ne 0 ] || [ "$JavaId" = "" ];then
        LOG "[$FUNCNAME]JavaId($JavaId), ret($?)"
        errResult="INFO: Failed to get the back ip of all node.return($?).ERRCODE(4)"
        WRITE_XML_ERROR 0 "${errResult}"
        WRITE_XML_JUDGE 1
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    remote_exec_async_batch $TASK_ID 30 "cat /proc/sys/lnet/peers > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get /proc/sys/lnet/peers information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                WRITE_XML_ERROR 0 "Node: $Item||INFO: remote download file failed."
                LOG "[$FUNCNAME] IP:$Item ,remote download failed! return($iRet)"
                isPass=1
                continue
            fi

        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            dos2unix $G_TMP_FILE$Item
            set_ifs

            Result=""
            while read row
            do
                rowinfo=$( echo $row | awk '{print $2}' | grep '4004\|4020\|4016\|988\|peernid' )
                if [ "${rowinfo}" != "" ];then
                    status=$( echo $row | awk '{print $4}'|sed 's/^ *//g'|sed "/^$/d" )
                    status_info=$( echo $status | grep down )

                    if [ "$status" == "NA" ]; then
                        continue
                    fi
                    isFind=1

                    if [ "$status" == "down" ] || [ "${status_info}" != "" ];then
                       LOG "[$FUNCNAME]status:$status,status_info:$status_info"
                       isFind=0
                       ip_info=$( echo $row | awk '{print $2}' | sed 's/@.*$//g' |sed 's/^ *//g' |sed "/^$/d" )

                       for line in $JavaId; do
                            if [ "${line}" == "${ip_info}" ];then
                                isPass=1
                                WRITE_XML_ERROR 0 "Node:$Item||INFO:${row}.ERRCODE(5)"
                                isFind=1
                                break
                            fi
                       done
                    fi

                    if [ $isFind -eq 1 ];then
                           if [ "" != "${Result}" ];then
                                Result="${Result}||INFO:${row}"
                           else
                                Result="INFO:${row}"
                           fi
                    fi
                fi
            done   <  $G_TMP_FILE$Item

            if [ "" != ${Result} ];then
                WRITE_XML_COMMON 0 "INFO:${G_SEPARATOR}||INFO:$Item||${Result}"
            fi

            restore_ifs
    done

    if [ "${isPass}" == "0" ];then
        WRITE_XML_JUDGE 0
    else
        WRITE_XML_JUDGE 1
    fi

    WRITE_XML_SUBCMD_TAIL
}

#214. ڴʹ
#uds֧
checkMemPoolUsage_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local Remote_filename="MemPoolUsage"
    local TASK_ID=0
    local isPass=0
    local isflag=""
    local Total_Count=0
    local numCnt=1
    local numCnt_new=0
    local yellowmemline=0
    local Info=""
    local Info_one=""
    local PoolName=""
    local MainNodeIP=$( get_backnet_ip )
    local DM_ibaseused=$(ps -e -o "pid,comm,rsz" | grep ibase|awk '{print $3}')
    local DM_httpdused=$(ps -e -o "pid,comm,rsz" | grep httpd|awk '{print $3}')

    local ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch_mml $TASK_ID 180 GetMemPoolUsageInfo $FUNCNAME
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult,ProductType=$ProductType"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            Result=""

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get GetMemPoolUsageInfo information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi


                remote_download $Item $G_TMP_FILE$Item /tmp/tmpfile$Remote_filename
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    LOG "[$FUNCNAME]:Node:$Item||INFO:download pool info fail,return($iRet)"
                    errResult="Node:$Item||INFO:download pool info fail"
                    WRITE_XML_ERROR 0 "$Result"
                    isPass=1
                    continue
                fi


        #end for Item in $ValidIP
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        fifoContext=$( cat $G_TMP_FILE$Item )
        if [ "$fifoContext" = "" ];then
                continue
        fi
        dos2unix $G_TMP_FILE$Item
        if [ "$Item" == "$MainNodeIP" ]; then
            #ȡDMģڴϢ,ֻڵִм
            sed -i '$d' $G_TMP_FILE$Item
            if [ "X""${DM_ibaseused}" == "X" ];then
                echo "[DM_ibase]" >>$G_TMP_FILE$Item 2>&1
                echo "DM[ERR]module DM ibase process not exit!ERRCODE(8)" >>$G_TMP_FILE$Item 2>&1
            else
                echo "$DM_ibaseused" |while read line;do
                    echo "[DM_ibase]" >>$G_TMP_FILE$Item 2>&1
                    echo "ibase_Used=${line}" >>$G_TMP_FILE$Item 2>&1
                done
            fi
            if [ "X""{DM_httpdused}" == "X" ];then
                echo "[DM_ibase]" >>$G_TMP_FILE$Item 2>&1
                echo "DM[ERR]module DM httpd process not exit!ERRCODE(9)" >>$G_TMP_FILE$Item 2>&1
            else
                echo "${DM_httpdused}" |while read line;do
                    echo "[DM_httpd]" >>$G_TMP_FILE$Item 2>&1
                    echo "httpd_Used=${line}" >>$G_TMP_FILE$Item 2>&1
                done
             fi
            echo "[END]" >>$G_TMP_FILE$Item 2>&1
        fi
        local count=0
        while read line;do
            echo $line|grep -q "^\[" >/dev/null 2>&1
            iRet=$?
            if [ 0 -eq $iRet ];then
                if [ 0 -eq $count ];then
                    let count++
                else
                    let count++
                    LOG "[${FUNCNAME}]Node:${Item}||$module:$pool||memSuccessiveArise:$memSuccessiveArise||totalsize:$totalsize(MB)||freesize(MB):$freesize||Percentage(%):$percentage||Process_Used(MB):${processused_TMP}||RPCmemused/RPCpageusd(MB):${RPCmemused_TMP}/${RPCpageused_TMP}||MDS_LeftMemSize/MDS_ResvMemSize(MB):${MDS_LeftMemSize}/${MDS_ResvMemSize}"
                    Result="Node:${Item}||Module:$module||Pool:$pool||memSuccessiveArise:$memSuccessiveArise||totalsize(MB):$totalsize||freesize(MB):$freesize||Percentage(%):$percentage||Process_Used(MB):${processused_TMP}||RPCmemused/RPCpageusd(MB):${RPCmemused_TMP}/${RPCpageused_TMP}||MDS_LeftMemSize/MDS_ResvMemSize(MB):${MDS_LeftMemSize}/${MDS_ResvMemSize}"
                    WRITE_XML_COMMON 0 "$Result"

                fi
                module=$(echo $line |awk -F"[" '{print $2}'|awk -F"]" '{print $1}')
                pool="-"
                totalsize="--"
                freesize="--"
                percentage="--"
                processused_TMP="--"
                RPCmemused_TMP="--"
                RPCpageused_TMP="--"
                MDS_LeftMemSize="--"
                MDS_ResvMemSize="--"
                memSuccessiveArise="--"
                MDSsafeMemsize="1500"
            else
                Info=$( handle_remote_result "$line" )
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node:$Item||INFO:$Info"
                    LOG "[$FUNCNAME] Error: $Info"
                    WRITE_XML_ERROR 0 "${errResult}"
                else
                    echo $Info|grep -q "total size" >/dev/null 2>&1
                    TOTAL=$?
                    if [ 0 -eq $TOTAL ];then
                        if [ "NAS" == "$module" ];then
                            pool=$(echo $Info  | awk -F: '{print $1}')
                            poolid=$(echo "$pool" |sed 's/ //g'|awk -F] '{print $1}'|awk -F[ '{print $2}')
                            totalsize_tmp=$(expr $(echo $Info|awk -F":|," '{print $3}') \* ${poolid})
                            totalsize=$(echo "scale=4; ${totalsize_tmp}/10485760"|bc -l)
                            freesize_tmp=$(expr $(echo $Info |awk -F":|," '{print $5}') \* ${poolid})
                            freesize=$(echo "scale=4; ${freesize_tmp}/10485760"|bc -l)
                            usedSize=$(expr $(echo $Info |awk -F":|," '{print $7}') \* ${poolid})
                            usedSize_temp=$(expr $usedSize \* 100)
                            percentage=$(expr $usedSize_temp \/ ${totalsize_tmp})
                        else
                            pool=$(echo $Info | awk -F: '{print $1}')
                            totalsize=$(echo $Info|awk '{print $4}')
                            freesize=$(echo $Info |awk '{print $11}')
                            usedSize=$(expr $totalsize \- $freesize)
                            usedSize_temp=$(expr $usedSize \* 100)
                            percentage=$(expr $usedSize_temp \/ $totalsize)
                        fi
                        Threpercentage=""
                        #ģԼӦģڴʹֵ
                        MODULEMEM=("MON" "BJM_Server" "BJM_Worker" "CA" "DAB" "DS" "OBS" "CM_Kernel" "CM_User" "NV" "TRNS" "TRNS_LOG" "MONC" "NOFS" "DLM" "NAS")
                        moduleper=(85 85 85 85 80 80 80 90 90 85 90 90 85 95 80 70)
                        for i in $(seq 0 `expr ${#MODULEMEM[@]} - 1`);do
                            if [ "$module" == "${MODULEMEM[$i]}" ];then
                               Threpercentage=${moduleper[$i]}
                               break;
                            fi
                        done
                        if [ $percentage -ge $Threpercentage ];then
                            isPass=1
                            LOG "[${FUNCNAME}]Node ${Item} $module percentage ${percentage} over the threshould percentage ${Threpercentage}"
                            errResult="Node: ${Item}||INFO:$module percentage ${percentage} over the threshould percentage ${Threpercentage}!ERRCODE(10)"
                            WRITE_XML_ERROR 0 "${errResult}"
                            continue
                        fi
                    fi
                    #MON,BJM_Server,BJM_Worker,BJM_ManagerģҪУ鵱ǰڴʹ
                    echo $Info |grep "_Used" >/dev/null 2>&1
                    TOTALUSED=$?
                    if [ 0 -eq $TOTALUSED ];then
                        #ģԼӦģڴʹֵ,MONģΪ1.5G,BJM_ServerģΪ2G,BJM_ServerģΪ1G,BJM_ManagerģΪ500M
                        TOTALModule=("MON" "BJM_Server" "BJM_Worker" "BJM_Manager" "DM_ibase" "DM_httpd" "Replication")
                        TOTALTHRmem=("1610612736" "2147483648" "1073741824" "536870912" "335544320" "83886080" "1073741824")
                        processused=$(echo $Info|awk -F= '{print $2}')
                        processused_TMP=$(echo "scale=4; ${processused}/10485760"|bc -l)
                        if [ "X""$processused" == "X" ];then
                            isPass=1
                            LOG "[${FUNCNAME}] Node: ${Item}||INFO:get information of $module processused used FAILED"
                            errResult="Node: ${Item}||INFO:get information of $module processused used FAILED!ERRCODE(14)"
                            WRITE_XML_ERROR 0 "${errResult}"
                            continue
                        else
                            for i in $(seq 0 `expr ${#TOTALModule[@]} - 1`);do
                                if [ "$module" == "${TOTALModule[$i]}" ];then
                                    ThreshouldMem=${TOTALTHRmem[$i]}
                                    break;
                                fi
                            done
                            if [ $processused -ge $ThreshouldMem ];then
                                isPass=1
                                LOG "[${FUNCNAME}]Node: ${Item}||INFO:$module processused $processused (B) over the ThreshouldMem  $ThreshouldMem (B)!"
                                errResult="Node: ${Item}||INFO:$module processused $processused (B) over the ThreshouldMem  $ThreshouldMem (B)!ERRCODE(15)"
                                WRITE_XML_ERROR 0 "${errResult}"
                                continue
                            fi
                        fi
                    fi
                    #鶯̬ڴ־
                    echo "$Info" |grep "memSuccessiveArise" >/dev/null 2>1
                    if [ $? -eq 0 ];then
                        memSuccessiveArise=$(echo $Info|awk -F"," '{print $1}'|awk -F= '{print $2}')
                        if [ ${module} != "MDS" ];then
                            if [ 1 -eq ${memSuccessiveArise} ];then
                                isPass=1
                                details=$(echo $Info|awk -F"," '{print $2}')
                                LOG "[${FUNCNAME}]Node: ${Item}||INFO:the details of ten days memory ($details)"
                                errResult="Node: ${Item}||INFO:the module $module memory of ten days ($details).ERRCODE(16)"
                                WRITE_XML_ERROR 0 "${errResult}"
                                continue
                            fi
                        else
                            if [ 1 -eq ${memSuccessiveArise} -a ${MDS_LeftMemSize} -lt ${MDSsafeMemsize} ]; then
                                isPass=1
                                details=$(echo ${Info}|awk -F"," '{print $2}')
                                LOG "[${FUNCNAME}][$LINENO]Node: ${Item}||INFO:the details of ten days memory (${details})"
                                errResult="Node: ${Item}||INFO:the module ${module} memory of ten days (${details})"
                                WRITE_XML_ERROR 0 "${errResult}"
                                continue
                            fi
                        fi
                    fi
                    #RPCģֻRPCmemusedRPCpageused
                    echo $Info |grep "RPC_" >/dev/null 2>&1
                    RPC=$?
                    if [ 0 -eq $RPC ];then
                        RPCmemused=$(echo $Info|awk -F"," '{print $1}'|awk -F= '{print $2}')
                        RPCpageused=$(echo $Info|awk -F"," '{print $2}'|awk -F= '{print $2}')
                        RPCmemused_TMP=$(echo "scale=4; ${RPCmemused}/10485760"|bc -l)
                        RPCpageused_TMP=$(echo "scale=4; ${RPCpageused}/10485760"|bc -l)
                        #RPCģֵΪ1G
                        ThreshouldRPCMem="1073741824"
                        if [ $RPCmemused -gt $ThreshouldRPCMem -a $RPCpageused -gt $ThreshouldRPCMem ];then
                            isPass=1
                            LOG "[${FUNCNAME}]RPCmemused:$RPCmemused, RPCpageused:$RPCpageused"
                            errResult="Node: ${Item}||INFO:$module $RPCpageused (B) AND $RPCmemused (B) ALL OVER THE $ThreshouldRPCMem (B)!ERRCODE(17)"
                            WRITE_XML_ERROR 0 "${errResult}"
                        fi
                    fi

                    #MDSģLeftMemSizeǷСڵResvMemSize
                    echo $Info |grep "MDS_" >/dev/null 2>&1
                    MDS=$?
                    if [ 0 -eq ${MDS} ];then
                        MDS_LeftMemSize=$(echo $Info|awk -F"," '{print $1}'|awk -F= '{print $2}')
                        MDS_ResvMemSize=$(echo $Info|awk -F"," '{print $2}'|awk -F= '{print $2}')
                        if [ "X" == "X${MDS_LeftMemSize}" -o "X" == "X${MDS_ResvMemSize}" ];then
                            isPass=1
                            LOG "[${FUNCNAME}]MDS_LeftMemSize:${MDS_LeftMemSize}, MDS_ResvMemSize:${MDS_ResvMemSize}"
                            errResult="Node: ${Item}||INFO:get $module MDS_LeftMemSize ${MDS_LeftMemSize} (MB)  or MDS_ResvMemSize ${MDS_ResvMemSize} (MB) failed!"
                            WRITE_XML_ERROR 0 "${errResult}"
                        elif [ ${MDS_LeftMemSize} -le ${MDS_ResvMemSize} ];then
                            isPass=1
                            LOG "[${FUNCNAME}]MDS_LeftMemSize:${MDS_LeftMemSize}, MDS_ResvMemSize:${MDS_ResvMemSize}"
                            errResult="Node: ${Item}||INFO:$module MDS_LeftMemSize ${MDS_LeftMemSize} (MB)  is less than or equal to  MDS_ResvMemSize ${MDS_ResvMemSize} (MB)!"
                            WRITE_XML_ERROR 0 "${errResult}"
                        fi
                    fi

                fi
            fi
        done <$G_TMP_FILE$Item


    #end for Item in $ValidIPResult
    done


    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#215. ؼһУ
checkDataConsistent_Async()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local result_log=/var/log/nluninfo.log
    local TASK_ID_MDS=0
    local TASK_ID_MONC=1
    local isPass=0
    local dfsFlag=0
    local MDS="mds"
    local MONC="monc"
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    LOG "REMOTE_IP_S:$REMOTE_IP_S"

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        #checkڵͣDFSִ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            continue
        fi

        #ǣ˵ȺкDFSڵ
        dfsFlag=1
        remote_exec_async $Item $TASK_ID_MDS 60 "$G_MML_FILE_PATH/ShowInspectMml $Item 988 'mds objid show' > $G_REMOTE_TMP_FILE$FUNCNAME$MDS 2>&1"
        iRet_mds=$?
        sleep 15
        remote_exec_async $Item $TASK_ID_MONC 60 "$G_MML_FILE_PATH/ShowInspectMml $Item 988 'monc nluninfo 0'  >  $G_REMOTE_TMP_FILE$FUNCNAME$MONC 2>&1"
        iRet_monc=$?
        if [ $iRet_mds -ne 0 -o $iRet_monc -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet_mds}, ${iRet_monc}"
            WRITE_XML_ERROR 0 "Node:$Item||Error:Failed to execute command.return_MDS(${iRet_mds}),return_MONC(${iRet_monc}).ERRCODE(1)"
            isPass=1
            break
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
        break
    done

    if [ $dfsFlag -eq 0 ]; then
        isPass=0
        WRITE_XML_ERROR 0 "Does not involve"
    fi

    ValidIP=$( cat ${VALID_IP_FILE} )
     while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID_MDS "Can not check data consistent "
            iRet_mds=$?
            remote_exec_checkfini $Item $TASK_ID_MONC "Can not check data consistent "
            iRet_monc=$?
            if [ $iRet_mds -eq 0 -o $iRet_monc -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet_mds -ne 2 -a $iRet_mds -ne 5 ] || [ $iRet_monc -ne 2 -a $iRet_monc -ne 5 ];then
                isPass=1
                continue
            fi
            remote_download_sync $Item $G_TMP_FILE$Item$MDS $G_REMOTE_TMP_FILE$FUNCNAME$MDS
            iRet=$?
            if [ $iRet -ne 0 ];then

                WRITE_XML_COMMON 0 "Failed to execute remote_download command."
                isPass=1
                break
            fi

            set_ifs
            dos2unix $G_TMP_FILE$Item$MDS
            cat  $G_TMP_FILE$Item$MDS >> $LOG_FILE 2>&1
            #ȡ
            root_dir1=$( grep "ROOT_DIR" $G_TMP_FILE$Item$MDS|awk -F: '{print $2}' | awk -F, '{print $1}' |sed 's/^ *//g'|sed "/^$/d"|awk -F/ '{print $1}' )
            root_dir2=$( grep "ROOT_DIR" $G_TMP_FILE$Item$MDS|awk -F: '{print $2}' | awk -F, '{print $1}' |sed 's/^ *//g'|sed "/^$/d"| awk -F/ '{print $2}' )
            LOG "[$FUNCNAME]root_dir1:$root_dir1 ,root_dir2:$root_dir2"

            fs_sblock1=$( grep "FS_SBLOCK" $G_TMP_FILE$Item$MDS|awk -F: '{print $2}' | awk -F, '{print $1}' |sed 's/^ *//g'|sed "/^$/d"|awk -F/ '{print $1}' )
            fs_sblock2=$( grep "FS_SBLOCK" $G_TMP_FILE$Item$MDS|awk -F: '{print $2}' | awk -F, '{print $1}' |sed 's/^ *//g'|sed "/^$/d"|awk -F/ '{print $2}' )
            LOG "[$FUNCNAME]fs_sblock1:$fs_sblock1,fs_sblock2: $fs_sblock2"

            #nlun map
            if [ "$root_dir1" == "" ] || [ "$root_dir1" == "" ] || [ "$fs_sblock1" == "" ] || [ "$fs_sblock2" == "" ]; then
                errResult="INFO:Failed to get objid (root_dir1:$root_dir1 ,root_dir2:$root_dir2, fs_sblock1:$fs_sblock1, fs_sblock2: $fs_sblock2).ERRCODE(4)"

                WRITE_XML_COMMON 0 "$errResult"
                isPass=1
                restore_ifs
                break
            fi

            LOG "[$FUNCNAME]get objid (root_dir1:$root_dir1 ,root_dir2:$root_dir2,fs_sblock1:$fs_sblock1,fs_sblock2: $fs_sblock2)ok"

            remote_download_sync $Item $G_TMP_FILE$Item$MONC $result_log
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                restore_ifs
                break
            fi

            checknlun_Reault=$( grep ${root_dir1} $G_TMP_FILE$Item$MONC )
            if [ "${checknlun_Reault}" == "" ]; then
                LOG "[$FUNCNAME]checknlun_Reault is Null"
                errResult="INFO:Failed to get nluninfo by $root_dir1.ERRCODE(5)"
                WRITE_XML_COMMON 0 "$errResult"
                isPass=1
                restore_ifs
                break
            fi

            Primary_id=$( echo "$checknlun_Reault" | sed 's/[[:space:]]/\n/g'|grep Primary|awk -F'(' '{print $2}' )
            LOG "[$FUNCNAME]Primary_id:$Primary_id"
            if [ "${Primary_id}" == "" ]; then
                LOG "[$FUNCNAME]Primary_id is Null"
                errResult="INFO:Failed to get Primary_id by $checknlun_Reault.ERRCODE(6)"

                WRITE_XML_COMMON 0 "$errResult"
                isPass=1
                restore_ifs
                break
            fi


            #ȡDS_IDӦIPַ
            DS_ID_Address=$( get_valid_back_ip_by_dsid "$Primary_id" )
            LOG "[$FUNCNAME]DS_ID_Address:${DS_ID_Address}"
            if [ "${DS_ID_Address}" == "" ]; then
                LOG "DS_ID_Address is Null"
                errResult="INFO:Failed to get DS Address fail.ERRCODE(7)"

                WRITE_XML_COMMON 0 "$errResult"
                isPass=1
                restore_ifs
                break
            fi

            #Ƚroot_dirһ
            rootdir_result=$( remote_exec ${DS_ID_Address} 30 "$G_MML_FILE_PATH/ShowDataConsistent $DS_ID_Address 'check consfile $root_dir1 $root_dir2' ROOT_DIR 2>&1" )
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="INFO:Failed to execute(${DS_ID_Address},check consfile $root_dir1 $root_dir2),return($iRet),errinfo($rootdir_result).ERRCODE(8)"
                LOG "[$FUNCNAME]Failed to execute(${DS_ID_Address},check consfile $root_dir1 $root_dir2),return($iRet),errinfo($rootdir_result)"
                WRITE_XML_COMMON 0 "$errResult"
                isPass=1
            else
                WRITE_XML_COMMON 0 "$rootdir_result"
            fi

            #ȽFS_SBLOCKһ
            fssblock_result=$( remote_exec ${DS_ID_Address} 30 "$G_MML_FILE_PATH/ShowDataConsistent ${DS_ID_Address} 'check consfile $fs_sblock1 $fs_sblock2' FS_SBLOCK 2>&1" )
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="INFO:Failed to execute(${DS_ID_Address},check consfile $fs_sblock1 $fs_sblock2),return($iRet),errinfo($fssblock_result).ERRCODE(9)"
                LOG "[$FUNCNAME] Failed to execute(${DS_ID_Address},check consfile $fs_sblock1 $fs_sblock2),return($iRet),errinfo($fssblock_result)"

                WRITE_XML_COMMON 0 "$errResult"
                isPass=1
            else
                WRITE_XML_COMMON 0 "$fssblock_result"
            fi

            restore_ifs
            break
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done
    chmod 640 ${result_log}

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

hextoip() {
    hex=$1
    local length=$( echo $hex |wc -c )
    if [ $length -lt 9 ] || [ $length -gt 10 ]; then
        printf "0"
        return
    fi
    if [ $length -eq 10 ]; then
        printf "%d." 0x${hex:0:2}
        printf "%d." 0x${hex:2:2}
        printf "%d." 0x${hex:4:2}
        printf "%d"  0x${hex:6:2}
    else
        printf "%d." 0x${hex:0:1}
        printf "%d." 0x${hex:1:2}
        printf "%d." 0x${hex:3:2}
        printf "%d"  0x${hex:5:2}
    fi
}

mdsMasterIP1=""
mdsMasterIP2=""
#ȡLeaderкIP
function getMdsMasterIps()
{

    mdsMasterIP1=""
    mdsMasterIP2=""
    local isPass=0
    local TASK_ID=0
    local errResult=""
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    remote_exec_async_batch_mml $TASK_ID 30 GetMdsSubtreeInfo $FUNCNAME
    isPass=$?

    sleep 5
    ValidIP=$( cat ${VALID_IP_FILE} )
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            #checkڵ
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "[$FUNCNAME]: $Item is not DFS node."
                continue
            fi
            isDfs=1
            remote_exec_checkfini $Item $TASK_ID "Can not get mds info show information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 ];then
                isPass=1
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                continue
            fi

            #Ϊ100%֮ļأн
            remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                isPass=1
                continue
            fi

            MDSMaster1=$( cat $G_TMP_FILE$Item | grep "root mds ip"|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            if [ "$MDSMaster1" == "" ];then
                isPass=1
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                errResult="Node:$Item||INFO:Failed to get MDS master1.ERRCODE(4)"
                WRITE_XML_ERROR 0 "${errResult}"
                break
            fi

            #16ƵַʽתΪipv4͵ַ
            mdsMastertmp1=$MDSMaster1
            mdsMasterIP1=$( hextoip "${mdsMastertmp1}" )
            LOG "[$FUNCNAME]mdsMasterIP1:$mdsMasterIP1"
            if [ "$mdsMasterIP1" == "" ];then
                LOG "[$FUNCNAME]:Failed to execute command(mds info show),get masterIp($mdsMastertmp1) err."
                errResult="Node:$Item||INFO:Failed to execute command(mds info show),get masterIp(${mdsMastertmp1}) err.ERRCODE(5)"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                break
            fi

            MDSMaster2=$( cat $G_TMP_FILE$Item | grep "root mds 2nd ip"|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            if [ "$MDSMaster2" == "" ];then
                isPass=1
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                errResult="Node:$Item||INFO:Failed to get MDS master2.ERRCODE(6)"
                WRITE_XML_ERROR 0 "${errResult}"
                break
            fi

            #16ƵַʽתΪipv4͵ַ
            mdsMastertmp2=$MDSMaster2
            mdsMasterIP2=$( hextoip "${mdsMastertmp2}" )
            LOG "[$FUNCNAME]mdsMasterIP2:$mdsMasterIP2"
            if [ "mdsMasterIP2" == "" ];then
                LOG "[$FUNCNAME]:Failed to execute command(mds info show),get masterIp($mdsMastertmp2) err."
                Result="Failed to execute command(mds info show),get masterIp(${mdsMastertmp2}) err."
                errResult="Node:$Item||INFO:Failed to execute command(mds info show),get masterIp(${mdsMasterIP2}) err.ERRCODE(7)"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                break
            fi
            >${VALID_IP_FILE}
            break
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done
}
#216. ϵͳinodeBirth--
checkFileInodeAndBirthCount()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local faildInfo=""
    local MDSMaster=""
    local errResult=""
    local usedCapRate=0
    local exe_result1=""
    local exe_result2=""
    local exe_result3=""
    local exe_result4=""
    local exe_result5=""
    local exe_result6=""
    local exe_result7=""
    local tmpResult=""
    local CurInodeCount=0
    local MaxInodeCount=0
    local FileInodeCount=0
    local SysBirthCount=""
    local inodeRate=0
    local MDSMemory=0
    local ratio=0
    local maxBirthMem=0
    local maxBirthCount=0
    local safeBirthCount=0
    local isArchive=0
    local value1=0
    local value2=0
    local calBirthCount=0
    local dfsNodeCnt=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    for Item in $REMOTE_IP_S
    do
        #1.checkڵԼDFSڵĸ
        local service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" == "1" ];then
            dfsNodeCnt=$((dfsNodeCnt+1))
        else
            LOG "[$FUNCNAME][${LINENO}]: $Item is not DFS node."
            continue
        fi
    done
    if [ ${dfsNodeCnt} -eq 0 ];then
        isPass=3
        LOG "[$FUNCNAME][${LINENO}]:There is no DFS node."
        WRITE_XML_COMMON 0 "There is no DFS node. Do not involve to inspect."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    while true; do
        back_ip=$( get_backnet_ip )
        if [ "$back_ip" = "" ];then
            isPass=1
            LOG "[FUNCNAME] Can't to get the backIP."
            WRITE_XML_ERROR 0 "Node:(master)||INFO:Can't get back IP."
            break
        fi
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm system" >$G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ "${iRet}" -ne 0 ];then
            Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            LOG "[FUNCNAME] mml_result : $Info"
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to execute command(MmlBatch 4016 'cm system'). Error(${iRet})"
            isPass=1
            break
        else
            dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
            content=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            if [ "$content" == "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed get infomation from output(MmlBatch 4016 'cm system') failed."
                break
            else
                #usedCapRate = Cluster_Used_Capacity / Cluster_Capacity * 100
                Cluster_Capacity=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Capacity"|awk -F: '{print $2}' )
                Cluster_Used_Capacity=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Used_Capacity"|awk -F: '{print $2}' )
                usedCapRate=$(echo ""|awk -v x=${Cluster_Used_Capacity} -v y=${Cluster_Capacity} '{printf("%0.2f",x*100/y)}')
                cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            fi
        fi
        mdsMasterIP=$( cat /proc/monc_leader | grep Mds | awk '{print $3}' )
        if [ "no" = "${mdsMasterIP}" ]; then
            LOG "[$FUNCNAME]:There is no mdsMasterIP in the S3 nodes"
            WRITE_XML_ERROR 0 "Does not involve in S3 nodes"
            break;
        fi
        #DFS ȡLeaderMdsĺIps
        getMdsMasterIps
        #MDS leader
        mdsMasterIP=$mdsMasterIP1
        LOG "[$FUNCNAME][${LINENO}]mdsMasterIP:$mdsMasterIP"
        if [ "$mdsMasterIP" = "" ];then
            LOG "[$FUNCNAME][${LINENO}]:Failed to execute function getMdsMasterIps,get masterIp err."
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to get MDS master IP."
            isPass=1
            break;
        fi

        #MDSִMMLinode, ִmml "mds info show" 'mds show lru'
        remote_exec $mdsMasterIP 60 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds show lru' > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
        iRet0=$?
        remote_exec $mdsMasterIP 30 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds info show' >> $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
        iRet1=$?
        if [ $iRet0 -ne 0 -o $iRet1 -ne 0 ];then
            #ڵ2Ipִmml
            if [ "$mdsMasterIP2" = "" ]; then
                LOG "[$FUNCNAME]:return($iRet0)($iRet1)"
                errResult="Node:$mdsMasterIP||INFO:Failed to execute mml command(mds info show & mds show lru),port(988).return($iRet0)($iRet1).ERRCODE(1)"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                break
            fi
            mdsMasterIP=$mdsMasterIP2
            remote_exec $mdsMasterIP 60 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds show lru' > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
            iRet0=$?
            remote_exec $mdsMasterIP 30 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds info show' >> $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
            iRet1=$?
        fi

        if [ $iRet0 -ne 0 -o $iRet1 -ne 0 ]; then
            LOG "[$FUNCNAME]:return($iRet0)($iRet1) "
            errResult="Node:$mdsMasterIP||INFO:Failed to execute mml command(mds info show & mds show lru),port(988).return($iRet0)($iRet1).ERRCODE(1)"
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
        fi

        #
        remote_download_sync $mdsMasterIP $G_TMP_FILE $G_REMOTE_TMP_FILE2$FUNCNAME
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME]download inode infp from $mdsMasterIP fail"
            WRITE_XML_ERROR 0 "Node:$mdsMasterIP||INFO:download inode infp from $mdsMasterIP fail.ERRCODE(3)"
            break
        fi

        exe_result1=$( cat $G_TMP_FILE | grep '\(Cur Inode Count in Cluster\)\|\(Sys Inode Count\)' | dos2unix )
        exe_result2=$( cat $G_TMP_FILE | grep '\(Max Inode Count Support by Cluster\)' | dos2unix )
        exe_result3=$( cat $G_TMP_FILE | grep '\(Sys File Inode Count\)' | dos2unix )
        exe_result4=$( cat $G_TMP_FILE | grep '\(Sys Birth Count\)' | dos2unix )
        # 7.1.0Լ֮ǰ汾MDSģܵĿõڴֵ
        exe_result5=$( cat $G_TMP_FILE | grep "pstMemStat\->stInitSpaceStat.ullPoolCanUseMaxSize"| dos2unix )
        exe_result6=$( cat $G_TMP_FILE | grep "\(Sys Dir Inode Count\)"| dos2unix )
        # MDSģpool[0]ڴشС
        exe_result7=$( cat $G_TMP_FILE | grep "Pool\[0\] Init free  size"| dos2unix )
        LOG "[$FUNCNAME][${LINENO}]exe_result1:$exe_result1"
        LOG "[$FUNCNAME][${LINENO}]exe_result2:$exe_result2"
        LOG "[$FUNCNAME][${LINENO}]exe_result3:$exe_result3"
        LOG "[$FUNCNAME][${LINENO}]exe_result4:$exe_result4"
        LOG "[$FUNCNAME][${LINENO}]exe_result5:$exe_result5"
        LOG "[$FUNCNAME][${LINENO}]exe_result6:$exe_result6"
        LOG "[$FUNCNAME][${LINENO}]exe_result7:$exe_result7"
        if [ "$exe_result1" == "" -o "$exe_result2" == "" -o "$exe_result3" == "" -o "$exe_result4" == "" -o "$exe_result5" == "" -o "$exe_result6" == "" -o "$exe_result7" == "" ];then
           errResult="Node:$mdsMasterIP||INFO:Get Inode information from output(MmlBatch 988 'mds info show';MmlBatch 988 'mds show lru') failed."
           WRITE_XML_ERROR 0 "${errResult}"
           isPass=1

           #
           cat $G_TMP_FILE >> $LOG_FILE 2>&1
           break
        else

            CurInodeCount=$( echo $exe_result1 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            MaxInodeCount=$( echo $exe_result2 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            FileInodeCount=$( echo $exe_result3 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            SysBirthCount=$( echo $exe_result4 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            SysDirInodeCount=$( echo $exe_result6 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            #inodeRate = Sys Inode Count / Max Inode Count Support by Cluster * 100
            inodeRate=$(echo ""|awk -v x=${CurInodeCount} -v y=${MaxInodeCount} '{printf("%0.2f",x*100/y)}')
            LOG "[$FUNCNAME][${LINENO}],CurInodeCount:$CurInodeCount||MaxInodeCount:$MaxInodeCount||usedCapRate(%):$usedCapRate||inodeRate(%):$inodeRate||SysBirthCount:$SysBirthCount"

            if [ $(echo "$inodeRate > 90" | bc) -eq 1 ] && [ $(echo "$inodeRate > $usedCapRate" | bc) -eq 1 ];then
                isPass=1
                errResult="Node:$mdsMasterIP||INFO:Inode percentage(${inodeRate}) exceeds the threshold(90) and exceeds the used capacity percentage($usedCapRate)."
                WRITE_XML_ERROR 0 "${errResult}"
                #
                cat $G_TMP_FILE >> $LOG_FILE 2>&1
            fi
            #ȡ7.1.0Լǰ汾MDSܵĿʹڴֵ
            MDS_TOTAL_MEM_SIZE=$( echo $exe_result5 | awk -F"=" '{print $2}'|sed 's/^ *//g'|sed "/^$/d")
            # ȡڵMDS pool[0]ڴشС
            MDS_MEM_POOL0_SIZE=$( echo $exe_result7 | awk -F"=" '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            LOG "[$FUNCNAME][${LINENO}]MDS_TOTAL_MEM_SIZE:${MDS_TOTAL_MEM_SIZE} MDS_MEM_POOL0_SIZE:${MDS_MEM_POOL0_SIZE}."

            # ȡmdsʹֵ
            #ȡȺĲ,ΪСļ(serviceType=archive)Ĭratio=58,ĬΪ 40
            serviceType=$( cat /opt/huawei/snas/etc/snas.ini |grep "serviceType=")
            isArchive=$( cat /opt/huawei/snas/etc/snas.ini |grep "serviceType=archive" | wc -l)
            if [ ${isArchive} -eq 1 ]; then
                ratio=$( grep sys_birth_mem_ratio_for_massive /opt/huawei/snas/static/mds.ini | awk -F= '{print $2}' | grep -o [0-9]* )
                if [ X"${ratio}" == X"" ]; then
                    ratio=58
                fi
            else
                ratio=$( grep sys_birth_mem_ratio_for_others /opt/huawei/snas/static/mds.ini | awk -F= '{print $2}' | grep -o [0-9]* )
                if [ X"${ratio}" == X"" ]; then
                    ratio=40
                fi
            fi

            pool0ratio=$( grep sys_birth_mem_max_ratio_in_pool0 /opt/huawei/snas/static/mds.ini | awk -F= '{print $2}' | grep -o [0-9]* )
            if [ X"${pool0ratio}" == X"" ]; then
                    pool0ratio=75
            fi
            LOG "INFO: ${serviceType} so ratio is ${ratio},pool0ratio is ${pool0ratio}."

            # 㼯ȺBirthЧڴ
            ullBirthTotalMemMax1=$(echo ""|awk -v x=${MDS_TOTAL_MEM_SIZE} -v y=${ratio} -v z=${dfsNodeCnt} '{printf("%0.0f", (x * y + x*y/(z-1)) / 100)}')
            # 㼯ȺBirthЧڴ,MDSڴֵΪ0.75
            ullBirthTotalMemMax2=$( echo ""|awk -v x=${MDS_MEM_POOL0_SIZE} -v y=${pool0ratio} '{printf("%0.0f", x * y / 100)}' )
            # Mdsٿõڴ
            [ ${ullBirthTotalMemMax1} -gt ${ullBirthTotalMemMax2} ] && ullMinMdsBirthMemSize=${ullBirthTotalMemMax2} || ullMinMdsBirthMemSize=${ullBirthTotalMemMax1}
            # 㼯ȺMdsԤڿɲBirth,ݿÿbirthĴСΪ32ֽ
            clsMaxBirthCount=$( echo ""|awk -v x=${ullMinMdsBirthMemSize} -v y=${dfsNodeCnt} '{printf("%0.0f", x/32 * y)}' )
            LOG "[$FUNCNAME][${LINENO}]ullBirthTotalMemMax1:${ullBirthTotalMemMax1} ullBirthTotalMemMax2:${ullBirthTotalMemMax2} ullMinMdsBirthMemSize:${ullMinMdsBirthMemSize}."
            LOG "[$FUNCNAME][${LINENO}]clsMaxBirthCount:${clsMaxBirthCount}."
            # Ԥ⼯Ⱥﵽ90%ʱʹõbirth
            maybeBirthInodeCnt=$( echo ""|awk -v x=${SysBirthCount} -v y=${usedCapRate} '{printf("%d", 90 * x / y)}' )
            # xΪʹʴﵽ90%birth,x >= maxBirthCount*0.5Ѳ첻ͨ
            calValue=$( echo ""|awk -v x=${maybeBirthInodeCnt} -v y=${clsMaxBirthCount} '{printf("%d", x >= (y*0.5))}' )
            if [ ${calValue} -eq 1 ]; then
                isPass=1
                errResult="Node:$mdsMasterIP||INFO:When the cluster capacity usage reaches 90%, the number of birthInode count may be insufficient."
                WRITE_XML_ERROR 0 "${errResult}"
            fi

            #ԤƼȺBirthCount=(Sys Birth Count)*(90/ratio)
            calBirthCount=$(echo ""|awk -v x=${SysBirthCount} -v y=${ratio} '{printf("%0.0f",x*90/y)}')
            # (Sys Birth Count)*(90/ratio) >= 10000000000()Ѳ첻ͨ
            if [ $calBirthCount -ge 10000000000 ];then
                isPass=1
                errResult="Node:$mdsMasterIP||INFO:calBirthCount($calBirthCount) >= 10000000000."
                WRITE_XML_ERROR 0 "${errResult}"
            fi

            Result="CurInodeCount:$CurInodeCount||ClsSupportMaxInodeCnt:$MaxInodeCount||usedCapRate(%):$usedCapRate||inodeRate(%):$inodeRate||SysBirthCount:$SysBirthCount || clsMayMaxBirthCount:${clsMaxBirthCount} ||may90CapUsedBirthInodeCnt:${maybeBirthInodeCnt}||SysDirInodeCount:${SysDirInodeCount}"
        fi
        break
    done

    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#217 AD״̬
checkADDomain()
{
    WRITE_XML_SUBCMD_HEADER $1
    local join_state="no"
    local Result=""
    local isPass=0
    local checkInfo=""
    local checkResult="--"
    local errResult=""
    local tmpResult=""
    local dfsIP=""
    local iRet=0
    local checkVersion="211"
    local splitWord="V300R006C00SPH"
    local product_version=$( grep "^ExternalVersion" /opt/huawei/deploy/package/version |awk -F"=" '{print $2}' |tr -d " " )
    
    #SFS û
    if [[ "$product_version" =~ "V100R006C10" ]];then
        isPass=0
        LOG "[$FUNCNAME][${LINENO}]:It's SFS ${product_version}. No need to inspect."
        WRITE_XML_COMMON 0 "It's SFS ${product_version}. No need to inspect."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    for Item in $REMOTE_IP_S
    do
        #1.checkڵ
        local service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" == "1" ];then
            dfsIP="${Item}"
            break
        else
            LOG "[$FUNCNAME][${LINENO}]: $Item is not DFS node."
            continue
        fi
    done
    if [ "X${dfsIP}" = "X" ];then
        isPass=0
        LOG "[$FUNCNAME][${LINENO}]:There is no DFS node."
        WRITE_XML_COMMON 0 "There is no DFS node. No need to inspect."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    while true; do
        #DFSڵִִ "nas_proto_auth -c show-join" Զִͬ Խڱļ
        /opt/huawei/deploy/script/localexec.py cmd ${dfsIP} 30 false "$G_MML_FILE_PATH/nas_checkADdomainControllerStatus checkADDomain" > $G_TMP_FILE${dfsIP} 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME][${LINENO}]:return($iRet) "
            errResult="Node:${dfsIP}||INFO:Failed to execute command(nas_proto_auth -c show-join). Error(${iRet})."
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
            break
        else
            checkInfo=$( cat $G_TMP_FILE${dfsIP} | grep "join_state:yes" )
            if [ "X$checkInfo" != "X" ];then
                join_state="yes"
                info=$(cat $G_TMP_FILE${dfsIP} | grep "HotPatchCheck:Have no HotPatch")
                if [ "X${info}" = "X" ]; then
                    version=$(cat $G_TMP_FILE${dfsIP} | grep "HotPatchCheck:" | awk -F: '{print $2}')
                    cmpVersion=$(echo $version | awk -F"${splitWord}" '{print $2}')
                    if [ "$cmpVersion" -lt "$checkVersion" ];then
                        #汾Ҫ汾
                        isPass=1
                        checkResult="HotPatch $version version is less than recommended version ${splitWord}$checkVersion."
                        WRITE_XML_ERROR 0 "Node:${dfsIP}||JOINED_DOMAIN:${join_state}||HotPatchCheck:${checkResult}"
                    else
                        #Ҫ
                        checkResult="HotPatch $version status is confirm ok.Recommended version is ${splitWord}$checkVersion."
                        WRITE_XML_COMMON 0 "Node:${dfsIP}||JOINED_DOMAIN:${join_state}||HotPatchCheck:${checkResult}"
                    fi
                else
                    #ûЧĲ
                    isPass=1
                    checkResult="Have no HotPatch is confirm ok.Recommended version is ${splitWord}$checkVersion or later."
                    WRITE_XML_ERROR 0 "Node:${dfsIP}||JOINED_DOMAIN:${join_state}||HotPatchCheck:${checkResult}"
                fi
            else
                #δAD
                WRITE_XML_COMMON 0 "Node:${dfsIP}||JOINED_DOMAIN:$join_state||HotPatchCheck:${checkResult}"
            fi
        fi
        break
    done
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#218. linuxϵͳ򿪵ļ
checkSystemFileOpened()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""

    local TASK_ID=0
    local isPass=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch $TASK_ID 30 "cat /proc/sys/fs/file-nr > $G_REMOTE_TMP_FILE$FUNCNAME"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            #ؽ/proc/sys/fs/file-nr
            remote_exec_checkfini $Item $TASK_ID "Can not get /proc/sys/fs/file-nr information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            usedunm=$( cat $G_TMP_FILE$Item|awk '{print $1}' )
            unusedunm=$( cat $G_TMP_FILE$Item|awk '{print $2}' )
            maxCount=$( cat $G_TMP_FILE$Item|awk '{print $3}' )
            fileCount=$( expr $usedunm + $unusedunm )

            LOG "[$FUNCNAME]:usedunm:$usedunm,unusedunm:$unusedunm,fileCount:$fileCount,maxCount:$maxCount"

            percentage=$(echo "scale=4; $fileCount*100/$maxCount"|bc -l| awk '{printf "%.4f", $0}')

            Result="Node:$Item||FileCount:$fileCount||MaxFileCount:$maxCount||Percentage(%):$percentage"
            percentage=$( echo $fileCount*100/$maxCount|bc -l )
            if [  $( echo "$percentage > 80" | bc ) -eq 1  ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:the current percentage $percentage exceeds the threshold Percentage 80.ERRCODE(4)"
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            fi

            WRITE_XML_COMMON 0 "$Result"
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#219. NIS
checkNIS()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local TASK_ID=0
    local NisInfo=0
    local isExistFlag=0;
    local ypwhichinfo=""
    local errinfo=""
    local nisIp=""
    local pingResult=""
    local pingTag="ping"
    local pingCompare=0
    local masterFlag=0 #ǵһϷNIS server ipִpingΪ1Ϊ1ʾýڵipִйping
    local pline="p"

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    LOG "REMOTE_IP_S:$REMOTE_IP_S"

    for Item in $REMOTE_IP_S; do
        #checkڵͣDFSִ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            continue
        fi

        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowNisServer > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?

        remote_download_sync $Item $G_REMOTE_TMP_FILE$FUNCNAME$Item $G_REMOTE_TMP_FILE$FUNCNAME
        downCon=$(cat $G_REMOTE_TMP_FILE$FUNCNAME$Item)
        LOG "[$FUNCNAME]node:$Item, remote_exec NisServer iRet: $iRet, downCon: ${downCon}"

        if [ $iRet -ne 0 ] || [ "x${downCon}" == "x" ]; then
            continue
        fi

        set_ifs
        while read line; do
            info=$( handle_remote_result "$line" )
            if [ $? -ne 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:$line"
            fi

            #жǷnis server
            NisInfo=$( echo $info | grep "no nis_server" )
            if [ "$NisInfo" != "" ];then
                isExistFlag=1
            fi

            nisIpArr=$(echo $info|awk -F'(' '{print $2}'|awk -F')' '{print $1}')

        done < $G_REMOTE_TMP_FILE$FUNCNAME$Item
        restore_ifs

    break
    done

    #
    LOG "[$FUNCNAME]:isPass:$isPass,isExistFlag:$isExistFlag"
    cat $G_REMOTE_TMP_FILE$FUNCNAME$Item >> $LOG_FILE 2>&1

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
    #checkڵͣDFSִ
    local service_type=$(get_service_type_from_db "${Item}")
    if [ "${service_type}" != "1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            WRITE_XML_COMMON 0 "Node:$Item||NisIp:--||DFS:No||nis_server status:--"
            continue
    fi

    if [ "$isExistFlag" -eq 1 -a "${service_type}" == "1" ];then
            Result="Node:$Item||NisIp:--||DFS:Yes||nis_server status:no nis_server"
            WRITE_XML_COMMON 0 "$Result"
    fi

    echo -n "$Item " >> ${VALID_IP_FILE}
    done

    if [ "$isPass" -eq 0 ] && [ "$isExistFlag" -eq 0 ];then

        #Զִypwhich鿴
        ValidIP=$(cat "${VALID_IP_FILE}")

        for Item in $ValidIP
        do

            #鿴ÿڵ
            ypwhichinfo=$(remote_exec $Item 10 "ypwhich")
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME] $Item Failed to execute(free) command.return($iRet)"
                isPass=1

                Result="Node:$Item||INFO:NisIp $nisIp nis_server status is Can't communicate with ypbind.return($iRet).ERRCODE(5)"
                WRITE_XML_ERROR 0 "$Result"
                continue
            fi

            errinfo=""
            errinfo=$(echo $ypwhichinfo | grep "Can't communicate with ypbind")
            if [ "$errinfo" != "" ]; then

                LOG "[$FUNCNAME]errinfo:$errinfo"
                Result="Node:$Item||INFO:NisIp $nisIp nis_server status is Can't communicate with ypbind.ERRCODE(5)"
                WRITE_XML_ERROR 0 "$Result"
                isPass=1
            else
                Result="Node:$Item||NisIp:$ypwhichinfo||DFS:Yes||nis_server status:ok"
                WRITE_XML_COMMON 0 "$Result"
            fi

        done
    fi

    if [ "$isPass" -eq 0 ] && [ "$isExistFlag" -eq 0 ];then

        #Զִping
        for Item in $ValidIP
        do
        remote_exec $Item 30 "> $G_REMOTE_TMP_FILE$FUNCNAME$pingTag  2>&1"
            for nisItem in $nisIpArr; do
                remote_exec $Item 30 "$G_MML_FILE_PATH/ShowPingResult $nisItem >> $G_REMOTE_TMP_FILE$FUNCNAME$pingTag  2>&1; exit 0"
            done
        done

        #Զping
        ValidIPResult=$ValidIP
        LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
        fifo_start
        for Item in $ValidIP
        do
            remote_download $Item $G_TMP_FILE$pingTag$Item $G_REMOTE_TMP_FILE$FUNCNAME$pingTag
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                errResult="Node: $Item||INFO:NisIp $nisIp ping status is remote download file($G_REMOTE_TMP_FILE$FUNCNAME$pingTag) failed.ERRCODE(3)"
                WRITE_XML_ERROR 0 "$errResult"
                continue
            fi
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$pingTag$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

        nisCnt=0
        masterFlag=0
            for nisIp in $nisIpArr
            do
                nisCnt=$((nisCnt+1))

                pingResult=$(sed -n $nisCnt$pline $G_TMP_FILE$pingTag$Item)
                if [ "$pingResult" == "" ];then
                    if [ $masterFlag -eq 0 ]; then
                        isPass=1
                    elif [ $masterFlag -eq 1 -a $isPass -eq 0 ]; then
                        isPass=4
                    fi
                    errResult="Node: $Item||INFO:NisIp $nisIp ping status is Failed to execute PING command and Pingtime is $pingResult.ERRCODE(6)"
                    WRITE_XML_ERROR 0 "$errResult"
                else
                    pingCompare=$(echo "$pingResult >= 200" | bc)
                    if [ $pingCompare -eq 1 ];then
                        if [ $isPass -eq 0 ]; then
                            isPass=4
                        fi
                        errResult="Node: $Item||INFO:NisIp $nisIp ping status is Ping too large and Pingtime is $pingResult.ERRCODE(7)"
                        WRITE_XML_ERROR 0 "$errResult"
                    else
                        Result="Node: $Item||NisIp:$nisIp||ping status:ok||Ping:$pingResult"
                        WRITE_XML_ERROR 0 "$Result"
                    fi
                fi

                if [ $masterFlag -eq 0 ]; then
                    masterFlag=1
                fi
            done
        done

    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#255 keystone
checkKeyStone()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local TASK_ID=0
    local Result=""
    local isSwift=0
    #ȡڵ
    local back_ip=$( get_backnet_ip )
    if [ "$back_ip" = "" ]; then
        LOG "[$FUNCNAME]:INFO: Can't get local ip"
        WRITE_XML_ERROR 0 "Node:-(master)||INFO:Failed to get local ip.ERRCODE(11)"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 1
    fi
    local local_service_type=$(get_service_type_from_db "$back_ip")
    #ڵΪswiftڵ
    if [ "${local_service_type}" == "3" ]; then
        #ȡauth_host,auth_port, admin_tenant_name, admin_user, admin_passwordֵ
        swift_host_info=$( cat /opt/obs/obsconf/swift/proxy-server.ini |grep auth_host |awk -F'auth_host=' '{print $2}' )
        swift_port_info=$( cat /opt/obs/obsconf/swift/proxy-server.ini |grep auth_port |awk -F'auth_port=' '{print $2}' )
        admin_tenant_name_info=$( cat /opt/obs/obsconf/swift/proxy-server.ini |grep admin_tenant_name |awk -F'admin_tenant_name=' '{print $2}' )
        admin_user_info=$( cat /opt/obs/obsconf/swift/proxy-server.ini |grep admin_user |awk -F'admin_user=' '{print $2}' )
        LOG "[$FUNCNAME]:swift_host:$swift_host_info||swift_port:$swift_port_info||admin_tenant_name:$admin_tenant_name_info||admin_user:$admin_user_info"
        if [ "$swift_host_info" == "" ] || [ "$swift_port_info" == "" ] || [ "$admin_tenant_name_info" == "" ] || [ "$admin_user_info" == "" ]; then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to get keystone info.ERRCODE(4)"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 1
        fi
    fi
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch $TASK_ID 30 "cat /opt/obs/obsconf/swift/proxy-server.ini > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #checkڵ
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "3" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi
            isSwift=1
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not keystone information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                echo "FlagDownfail" >> $G_TMP_FILE$Item 2>&1
                continue
            fi
        done

        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    if [ $isSwift -eq 1 ];then

        for Item in $ValidIPResult; do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "3" ]; then
                continue
            fi

            FlagDownfail=$( cat $G_TMP_FILE$Item |grep FlagDownfail )
            if [ "$FlagDownfail" != "" ];then
                LOG "[$FUNCNAME]:IP:$Item,Down file fail"
                continue
            fi

            node_swift_host=$( cat $G_TMP_FILE$Item | grep auth_host |awk -F'auth_host=' '{print $2}' )
            node_swift_port=$( cat $G_TMP_FILE$Item | grep auth_port |awk -F'auth_port=' '{print $2}' )
            node_admin_tenant_name=$( cat $G_TMP_FILE$Item | grep admin_tenant_name |awk -F'admin_tenant_name=' '{print $2}' )
            node_admin_user=$( cat $G_TMP_FILE$Item | grep admin_user |awk -F'admin_user=' '{print $2}' )
            Result="Node:$Item||node_swift_host:$node_swift_host||node_swift_port:$node_swift_port||admin_tenant_name:$node_admin_tenant_name||admin_user:$node_admin_user"
            LOG "[$FUNCNAME]:Result:$Result"
            WRITE_XML_COMMON 0 "$Result"
            #Ϊ
            if [ "$node_swift_host" == "" ] || [ "$node_swift_port" == "" ] || [ "$node_admin_tenant_name" == "" ] || [ "$node_admin_user" == "" ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:node_swift_host($node_swift_host) is empty or node_swift_port($node_swift_port) is empty or admin_tenant_name($node_admin_tenant_name) is empty or admin_user($node_admin_user) is empty.ERRCODE(5)"
                break
            fi
        done
    fi
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#220 ⲿDNSǷͨ
checkExtDnsConn()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    local AllDnsService=""
    local DnsNum=0
    local errResult=""
    local Result=""
    local Item=""
    local ValidIP=""
    local extDnsServe=""
    local serverConn=""
    local pingResult=""
    local numCnt=1
    local pingTag="ping"
    local pingCompare=0
    local DnsCnt=0
    local service_type=0
    local ipflag=0
    local frontiptype=0
    local FLAG=1
    local isOMnetflag=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    while true; do
        local back_ip=$( get_backnet_ip )
        if [ "$back_ip" = "" ]; then
            errResult="Node:-(master)||INFO: Can't get local ip.ERRCODE(11)"
            LOG "[$FUNCNAME]:$errResult"
            isPass=1
            WRITE_XML_ERROR 0 "$errResult"
            break
        fi
        AllDnsService=$( cat /etc/resolv.conf | grep ^nameserver | awk '{print $2}' | grep -E '^[0-9a-fA-F:.]+$' )
        #ȡⲿDNSûΪͨ
        DnsNum=$( echo "$AllDnsService" | wc -l )
        #ڵS3ڵ漰

        LOG "[$FUNCNAME]:AllDnsService:$AllDnsService,DnsNum:$DnsNum"
        if [ "$DnsNum" -le "0" ] || [ "$AllDnsService" == "" ] ;then
            FLAG=0

            Result="DNS_server: -- ||INFO: DNS server does not exist"

            WRITE_XML_COMMON 0 "$Result"
            cat /etc/resolv.conf >>  $LOG_FILE

            break
        fi
        local netflag=0 #ǰIPֻIPV4IPV6ַΪ0ͬʱΪ1
        local oldnodeiptype=-1
        for Item in $REMOTE_IP_S; do
            frontiptype=$(get_frontip_type "${Item}")
            if [ "$oldnodeiptype" == -1 ];then
                oldnodeiptype=$frontiptype
            fi
            if [ "$oldnodeiptype" -eq "$frontiptype" ];then
                continue
            else
                LOG "[$FUNCNAME]:the network is IPV4 and IPV6"
                netflag=1
                break
            fi
            LOG "[$FUNCNAME]:the network is only IPV4 or IPV6"
        done

        extDnsServe=""
        serverConn=""
        numCnt=1
        while [ $numCnt -le $DnsNum ]; do

            extDnsServe=$(  echo $AllDnsService | awk '{print $ '$numCnt'}' )

            #״̬
            if [ "$extDnsServe" == "" ];then
                LOG "[$FUNCNAME]:failed numCnt:$numCnt,NS server is NULL"

                numCnt=$((numCnt+1))
                continue
            fi

            #ڵжdns############################################################################
            >${VALID_IP_FILE}
            #жIPͣV4ͺС::ffff:͡.ַ::ffff:100.1.1.1;ipflag=1ʾIPV40ʾIPV6
            echo $extDnsServe|grep "::ffff:"|grep "\." > /dev/null
            if [ $? -eq 0 ];then
                extDnsServe=$(echo $extDnsServe|sed 's/::ffff://g')
                ipflag=1
            else
                #ipv6
                ipflag=0
            fi
            #жDNS IPǷڹ,isOMnetflag=1˵DNSǰ
            isOMnet=$(cat /opt/huawei/deploy/script/deploy_source_route.sh |grep -w $extDnsServe |grep om1)
            if [ "$isOMnet" == "" ];then
                isOMnetflag=1
            fi
            TASK_ID=$numCnt

            remote_exec_async_batch $TASK_ID 30 "/usr/bin/host test $extDnsServe > $G_REMOTE_TMP_FILE$FUNCNAME$numCnt  2>&1; exit 0"

            ValidIP=$( cat ${VALID_IP_FILE} )
            ValidIPResult=$ValidIP

            LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

            fifo_start
            while [ "${ValidIP}" != "" ]; do
                >${VALID_IP_FILE}

                for Item in $ValidIP; do
                    service_type=$(get_service_type_from_db "${Item}")
                    if [ "${service_type}" != "1" ];then
                       LOG "service_type = ${service_type}.skip ${Item}."
                       errResult="Does not involve"
                       WRITE_XML_COMMON 0 "Node:$Item||DNS_server:--||INFO:$errResult"
                       continue
                    fi

                    dfsFlag=1

                    #ѯ
                    remote_exec_checkfini $Item $TASK_ID "Can not DNS($extDnsServe) link status"
                    iRet=$?

                    if [ $iRet -eq 0 ];then
                        echo -n "$Item " >> ${VALID_IP_FILE}
                        continue
                    elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                        LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd(/usr/bin/host test $extDnsServe) failed."
                        isPass=1
                        continue
                    fi

                    remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME$numCnt
                    iRet=$?
                    if [ $iRet -ne 0 ];then
                        isPass=1
                        errResult="Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME$numCnt) failed."
                        WRITE_XML_ERROR 0 "$errResult"
                        continue
                    fi
                done
                ValidIP=$( cat ${VALID_IP_FILE} )
            done

            wait
            fifo_finish



            for Item in $ValidIPResult; do
                    if [ $dfsFlag = 0 ]; then
                        continue
                    fi
                    #DNSΪڵʱ򣬹˷ڵļ
                    if [ $isOMnetflag = 0 ];then
                        if [ "$Item" != "$back_ip" ];then
                            continue
                        fi
                    fi

                    service_type=$(get_service_type_from_db "${Item}")
                    if [ "${service_type}" != "1" ]; then
                        continue
                    fi

                    fifoContext=$( cat $G_TMP_FILE$Item )
                    if [ "$fifoContext" = "" ];then
                        continue
                    fi
                    frontiptype=$(get_frontip_type "${Item}")
                    if [ $netflag -eq 1 ];then
                        if [ $ipflag -ne $frontiptype ];then
                            continue
                        fi
                    fi
                    #жǷͨ

                    serverConn=$( cat $G_TMP_FILE$Item|grep "Using domain server"|wc -l )
                    if [ $serverConn -eq 0 ]
                    then
                        isPass=1
                        Result="DNS_server: $extDnsServe||INFO: DNS server is not connectable.ERRCODE(4)"
                        WRITE_XML_ERROR 0 "Node:$Item||$Result"

                        #
                        LOG "[$FUNCNAME]:/usr/bin/host test $extDnsServe result:"
                        cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

                    else
                        Result="DNS_server: $extDnsServe||INFO: DNS server is connectable."
                        WRITE_XML_COMMON 0 "Node:$Item||$Result"
                    fi
            done
            DnsCnt=$( echo "$AllDnsService" | grep -v "^$" | wc -l )
            if [ "$isPass" -eq 0 ] && [ "$DnsCnt" -gt 0 ];then
            #Զִping
            ValidIP=$( cat $IP_ROLE_FILE )

        while [[ ${ValidIP} != "" ]]
        do
            for Item in $ValidIP
            do
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                continue
            fi
            if [ $ipflag -eq 1 ];then
                remote_exec_async $Item $TASK_ID 30 "ping $extDnsServe -c 2|grep avg|awk -F= '{print \$2}'|awk -F/ '{print \$2}' > $G_REMOTE_TMP_FILE$FUNCNAME$pingTag$numCnt  2>&1; exit 0"
            else
                remote_exec_async $Item $TASK_ID 30 "ping6 $extDnsServe -c 2|grep avg|awk -F= '{print \$2}'|awk -F/ '{print \$2}' > $G_REMOTE_TMP_FILE$FUNCNAME$pingTag$numCnt  2>&1; exit 0"
            fi
            done
            ValidIP=$( cat ${VALID_IP_FILE} )
        done

        #ȴping
        sleep 10

        #Զping
        ValidIP=$( cat $IP_ROLE_FILE )
        ValidIPResult=$ValidIP
        LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
        fifo_start
        while [[ ${ValidIP} != "" ]]
        do
            for Item in $ValidIP
            do
                #S3ڵ㲻漰
                service_type=$(get_service_type_from_db "${Item}")
                if [ "${service_type}" != "1" ];then
                    LOG "service_type = ${service_type}.skip ${Item}."
                    continue
                fi

                dfsFlag=1

                remote_download $Item $G_TMP_FILE$pingTag$Item $G_REMOTE_TMP_FILE$FUNCNAME$pingTag$numCnt
                iRet=$?
                if [ $iRet -ne 0 ];then
                    isPass=1
                    errResult="Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME$pingTag$numCnt) failed."
                    WRITE_XML_ERROR 0 "$errResult"
                    continue
                fi
            done
            ValidIP=$( cat ${VALID_IP_FILE} )
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
                if [ $dfsFlag = 0 ]; then
                    continue
                fi
                #DNSΪڵʱ򣬹˷ڵļ
                if [ $isOMnetflag = 0 ];then
                    if [ "$Item" != "$back_ip" ];then
                        continue
                    fi
                fi

                service_type=$(get_service_type_from_db "${Item}")
                if [ "${service_type}" != "1" ]; then
                    continue
                fi

                pingResult=$( cat $G_TMP_FILE$pingTag$Item )
                if [ "$pingResult" = "" ];then
                    continue
                fi
                frontiptype=$(get_frontip_type "${Item}")
                if [ $netflag -eq 1 ];then
                if [ $ipflag -ne $frontiptype ];then
                    continue
                    fi
                fi
                if [ "$pingResult" == "" ];then
                    isPass=1
                    errResult="Node: $Item||DNS_server: $extDnsServe||INFO:Failed to execute PING command.ERRCODE(5)"
                    WRITE_XML_ERROR 0 "$errResult"
                else
                    pingCompare=$( echo "$pingResult >= 200" | bc )
                    if [ $pingCompare -eq 1 ];then
                        isPass=4
                        errResult="Node: $Item||DNS_server: $extDnsServe||INFO:pingtime $pingResult over 200 and Ping too large.ERRCODE(6)"
                        WRITE_XML_ERROR 0 "$errResult"
                    fi
                fi
            done

        fi

        ######################################################################################

        numCnt=$((numCnt+1))
        done

        #˳while
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#221. LDAP
checkLDAP()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local dfsFlag=0
    local ldapIp=""
    local pingResult=""
    local errResult=""
    local pingCompare=0
    local TASK_ID=2
    local basedn=""  #Ըڵ㣬ļһʱֵ
    local portnum="" #Ըڵ㣬ļһʱֵ
    local masterFlag=0 #ǵһϷLDAP server ipִpingΪ1Ϊ1ʾýڵipִйping
    local frontiptype=0
    local ipflag=0
    local FLAG=1

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/ShowLdapServer > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ 0 -ne $? ];then
        isPass=1
    fi

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            #s3 judge
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_COMMON 0 "Node:${Item}||DFS:No||ldap_server_ip:--||ldap_server_basedn:--||ldap_server_portnum:--||ldap_server_status:--"
                continue
            fi

            dfsFlag=1

            LOG "[$FUNCNAME]:IP:$Item"
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get ldap information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="IP: $Item||Error: exec (checkLDAP) failed.return($iRet),errno($errno)!||${errResult}"
                LOG "[$FUNCNAME]$Item exec(check LDAP failed.return($iRet),errno($errno)!"
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    local netflag=0 #ǰIPֻIPV4IPV6ַΪ0ͬʱΪ1
    local oldnodeiptype=-1
    for Item in $ValidIPResult; do
        frontiptype=$(get_frontip_type "${Item}")
        if [ "$oldnodeiptype" == -1 ];then
            oldnodeiptype=$frontiptype
        fi
        if [ "$oldnodeiptype" -eq "$frontiptype" ];then
            continue
        else
            LOG "[$FUNCNAME]:the network is IPV4 and IPV6"
            netflag=1
            break
        fi
        LOG "[$FUNCNAME]:the network is only IPV4 or IPV6"
    done

    for Item in $ValidIPResult; do
        if [ $dfsFlag = 0 ]; then
            continue
        fi

        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ]; then
            continue
        fi

        fifoContext=$( cat $G_TMP_FILE$Item )
        if [ "$fifoContext" = "" ];then
            continue
        fi

        dos2unix $G_TMP_FILE$Item
        #
        cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
        frontiptype=$(get_frontip_type "${Item}")


        #ÿڵ㴦ļǰֵʼ
        masterFlag=-1
        basedn=""
        portnum=""
        set_ifs
        while read line; do
            info=$( handle_remote_result "$line" )
            if [ $? -ne 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:$info"
            else
                #жϵǰǷldap server
                ldap_server=$(echo $info|grep -w "no ldap_server")
                if [ "$ldap_server" != "" ];then
                    WRITE_XML_COMMON 0 "Node:${Item}||DFS:Yes||ldap_server_ip:no ldap_server||ldap_server_basedn:no ldap_server||ldap_server_portnum:no ldap_server||ldap_server_status:no ldap_server"
                    FLAG=0
                    break
                fi

                #ǰضldap server
                ldap_server_ip=$(echo $info|grep -w "ldap_server_ip"|awk -F '\\|\\|' '{print $1}'|awk '{print $2}')
                ldap_server_basedn=$(echo $info|grep -w "ldap_server_basedn"|awk -F '\\|\\|' '{print $2}'|awk -F ':' '{print $3}')
                ldap_server_portnum=$(echo $info|grep -w "ldap_server_portnum"|awk -F '\\|\\|' '{print $3}'|awk -F ':' '{print $3}')

                ldap_server_status=$(echo $info|grep -w "status")
                ldapIp=$( echo $info|grep -w "status"|awk -F"status" '{print $1}' )
                ldapIp_vaild=$(echo $info|grep -w "status ok")

                #жǷΪϢĵһУbasednportnumcontinueһ
                if [ "${ldap_server_ip}" != "" ];then
                    basedn=$ldap_server_basedn
                    portnum=$ldap_server_portnum
                    continue
                fi
                #ldapIpΪյУV4pingV6 ײֶ
                if [ "${ldapIp}" == "" ];then
                   continue
                fi
                #masterFlagΪ0
                masterFlag=$((masterFlag+1))
                #Ź˲ͬ͵صַ
                if [ $netflag -eq 1 ];then
                    #ǰLDAPIPͲһֱӹ
                    echo $ldapIp |grep -q "\:" >/dev/dull
                    ipflag=$?
                    if [ $ipflag -ne $frontiptype ];then
                        LOG "ipflag=$ipflag;frontiptype=$frontiptype"
                        continue
                    fi
                fi
                if [ "${ldapIp}" != "" ];then
                    #ÿһldap server ip ֱӡϢ
                    WRITE_XML_COMMON 0 "Node:${Item}||DFS:Yes||ldap_server_ip:${ldapIp}||ldap_server_basedn:${basedn}||ldap_server_portnum:${portnum}||ldap_server_status:$ldap_server_status"
                fi
                FLAG=0

                #ǰip״̬:status err. һip
                if [ "x$ldapIp_vaild" == "x" ];then
                    if [ $masterFlag -eq 0 ];then
                        isPass=1

                        LOG "masterFlag=$masterFlag  isPass=$isPass"
                    elif [ $masterFlag -ne 0 -a $isPass -eq 0 ]; then
                        isPass=4
                    fi

                    continue
                fi

                remote_exec $Item 30 "$G_MML_FILE_PATH/ShowPingResult $ldapIp > $G_REMOTE_TMP_FILE$FUNCNAME$Item 2>&1"
                if [ $? -ne 0 ]; then
                    if [ $masterFlag -eq 0 ];then
                        isPass=1
                    elif [ $masterFlag -ne 0 -a $isPass -eq 0 ]; then
                        isPass=4
                    fi

                    WRITE_XML_ERROR 0 "Node:${Item}||INFO:LDAP $ldapIp Failed to execute ShowPingResult.ERRCODE(1)"
                    continue
                fi

                remote_download_sync $Item $G_REMOTE_TMP_FILE$FUNCNAME$Item$Item $G_REMOTE_TMP_FILE$FUNCNAME$Item
                if [ $? -ne 0 ]; then
                    if [ $masterFlag -eq 0 ];then
                        isPass=1
                    elif [ $masterFlag -ne 0 -a $isPass -eq 0 ]; then
                        isPass=4
                    fi
                    WRITE_XML_ERROR 0 "Node:${Item}||INFO:LDAP $ldapIp Failed to execute remote_download,Pingrestult get failed.ERRCODE(3)"
                    continue
                fi
                pingResult=$(sed -n 1p $G_REMOTE_TMP_FILE$FUNCNAME$Item$Item)
                if [ "$pingResult" == "" ];then
                    if [ $masterFlag -eq 0 ];then
                        isPass=1
                    elif [ $masterFlag -ne 0 -a $isPass -eq 0 ]; then
                        isPass=4
                    fi
                    WRITE_XML_ERROR 0 "Node:${Item}||INFO:LDAP $ldapIp Failed to execute PING command,pingResult is empty.ERRCODE(6)"
                else
                    pingCompare=$( echo "$pingResult >= 200" | bc )
                    if [ $pingCompare -eq 1 ];then
                        if [ $isPass -eq 0 ];then
                            isPass=4
                        fi
                        WRITE_XML_ERROR 0 "Node:${Item}||INFO:LDAP $ldapIp Ping too large,PingResult is $pingResult.ERRCODE(7)"
                    else
                        WRITE_XML_ERROR 0 "Node:${Item}||INFO:LDAP $ldapIp Ping is normal and Pingresult is $pingResult"
                    fi
                fi

            fi
        done < $G_TMP_FILE$Item
        restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

checkOMIPandIPMIinOneNet()
{
    local omip_v4_gw=""
    local ipmi_v4_gw=""
    local omip_mask_v4=""
    local ipmi_mask_v4=""
    local omip_v6_gw=""
    local ipmi_v6_gw=""
    local omip_mask_v6=""
    local ipmi_mask_v6=""
    local ipmi_ip_v6_prefix_tmp=""
    local ret=0

    $G_MML_FILE_PATH/GetIPMIAddress >/etc/null 2>&1

    omip_v4_gw=$( cat /opt/huawei/snas/etc/cm.ini|grep -w omGateway|awk -F= '{print $2}' |tr -d ' ' )
    ipmi_v4_gw=$( cat /tmp/tmpfilecheckIPMI|grep -w "Default Gateway IP"|awk -F: '{print $2}' | tr -d ' ' )
    omip_mask_v4=$( cat /opt/huawei/snas/etc/cm.ini |grep -w omNetMask|awk -F= '{print $2}' | tr -d ' ' )
    ipmi_mask_v4=$( cat /tmp/tmpfilecheckIPMI|grep -w "Subnet Mask"|awk -F: '{print $2}' |tr -d ' ' )
    LOG "[$FUNCNAME]omip_v4_gw: $omip_v4_gw,ipmi_v4_gw: $ipmi_v4_gw,omip_mask_v4: $omip_mask_v4,ipmi_mask_v4: $ipmi_mask_v4"
    omip_v6_gw=$( cat /opt/huawei/snas/etc/cm.ini|grep -w omGateway_v6|awk -F= '{print $2}' |tr -d ' ' )
    ipmi_v6_gw=$( cat /tmp/tmpfilecheckIPMI | grep -w "ipmi_ipv6_gateway" | awk -F: '{print $2}'| tr -d ' ' )
    omip_mask_v6=$( cat /opt/huawei/snas/etc/cm.ini |grep -w omNetMask_v6|awk -F= '{print $2}' | tr -d ' ' )
    ipmi_ip_v6_prefix_tmp=$( cat /tmp/tmpfilecheckIPMI | grep -w "ipmi_ipv6_prefix" | awk -F: '{print $2} '  )
    ipmi_mask_v6="$( printf %d 0x0$ipmi_ip_v6_prefix_tmp )"
    LOG "[$FUNCNAME]omip_v6_gw: $omip_v6_gw,ipmi_v6_gw: $ipmi_v6_gw,omip_mask_v6: $omip_mask_v6,ipmi_mask_v6: $ipmi_mask_v6"
    if [ "$omip_v4_gw" == "$ipmi_v4_gw" -a "$omip_mask_v4" == "$ipmi_mask_v4" ];then
        ret=1;
    fi
    if [ "$omip_v6_gw" == "$ipmi_v6_gw" -a "$omip_mask_v6" == "$ipmi_mask_v6" -a "$ipmi_mask_v6" != "0" ];then
        ret=1;
    fi

    return $ret
}
#222. ڵIPMIַ
checkIPMI()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isFlag=1
    local filename="checkIPMI"
    local TASK_ID=0
    local isPass=0
    local isSameNet=1
    local ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')

    #жOMIPIPMIǷΪһ
    checkOMIPandIPMIinOneNet
    isSameNet=$?
    if [ $isSameNet -eq 0 ];then
        errResult="BMC network and Manage network is not in the same network segment!"
        WRITE_XML_ERROR 0 "$errResult"
        WRITE_XML_JUDGE 0
    else
        set_ifs
        #ȡصomip
        OMIPV4Address=$( cat /opt/huawei/snas/etc/cm.ini|grep -w omip|awk -F= '{print $2}' )
        OMIPV6Address=$( cat /opt/huawei/snas/etc/cm.ini|grep -w omip_v6|awk -F= '{print $2}' )
        LOG "[$FUNCNAME]OMIPV4Address: $OMIPV4Address,OMIPV6Address: $OMIPV6Address"
        restore_ifs

        REMOTE_IP_S=$(cat "${IP_ROLE_FILE}")

        >${VALID_IP_FILE}
        for Item in $REMOTE_IP_S; do
            remote_exec ${Item} 30 "cat /opt/huawei/deploy/etc/deploy.ini | grep devicename | grep \"9000 C72 Node\" >> /dev/null 2>&1"
            if [ $? -ne 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            fi
            WRITE_XML_ERROR 0 "Node:$Item(C72 node)||IPMI:--||ConnectingStatus:--"
        done

        REMOTE_IP_S=$(cat "${VALID_IP_FILE}")

        remote_exec_async_batch $TASK_ID 300 "$G_MML_FILE_PATH/GetIPMIAddress  2>&1"
        isPass=$?

        ValidIP=$( cat ${VALID_IP_FILE} )
        ValidIPResult=$ValidIP

        LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

        fifo_start
        while [[ ${ValidIP} != "" ]]
        do
            >${VALID_IP_FILE}

            for Item in $ValidIP
            do
                #Ϊ100%֮ļأн
                remote_exec_checkfini $Item $TASK_ID "Can not get GetIPMIAddress information"
                iRet=$?

                if [ $iRet -eq 0 ];then
                    echo -n "$Item " >> ${VALID_IP_FILE}
                    continue
                elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                    isPass=1
                    continue
                fi

                #ű̶ѽд$G_REMOTE_TMP_FILE$Item
                remote_download $Item $G_TMP_FILE$Item /tmp/tmpfile$filename
                iRet=$?
                if [ $iRet -ne 0 ];then
                    isPass=1
                    continue
                fi
            done
            ValidIP=$( cat ${VALID_IP_FILE} )
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            #IPMIַ
            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            connectState_v4=""
            ipmi_ip_v4=$( cat $G_TMP_FILE$Item |grep "IP Address"|grep -v Source|awk '{print $4}' )
            connectState_v6=""
            ipmi_ip_v6=$( cat $G_TMP_FILE$Item | grep "ipmi_ipv6_address:" | awk -F'ipmi_ipv6_address:' '{print $2}' )
            if [ "$ipmi_ip_v4" == "" -o "$ipmi_ip_v4" == "0.0.0.0" ];then
                ipmi_ip_v4="--"
                connectState_v4="no IPMI"
            fi
            if [ "$ipmi_ip_v6" == "" -o "$ipmi_ip_v6" == "null" -o "$ipmi_ip_v6" == "::" ];then
                ipmi_ip_v6="--"
                connectState_v6="no IPMI"
            fi
            if [ "$ipmi_ip_v4" == "--" ] && [ "$ipmi_ip_v6" == "--" ];then
                errResult="Node: $Item||INFO: can not get IPMI address!ERRCODE(4)"
                LOG "[$FUNCNAME] $Item:can not get IPMI address!"
                isPass=1
                WRITE_XML_ERROR 0 "${errResult}"
            fi
            if [ "$ipmi_ip_v4" != "--" ] ;then
                #ͨomip ping ipmi 
                for time in ${RepeatTimes[*]}; do
                    tempStr_ping_v4=$( ping -q -c 1 $ipmi_ip_v4 |grep "1 received" |wc -l )
                    local iRet=$?
                    if [ $iRet -ne 0 ];then
                        sleep 10
                    else
                        break
                    fi
                done
                LOG "Node:$Item, ipmi:$ipmi_ip_v4,omipv4:$OMIPV4Address,tempStr_ping_v4:$tempStr_ping_v4"
                if [ "0" != "$tempStr_ping_v4" ];then
                    connectState_v4="OK"
                    else
                    connectState_v4="Can not access."
                    isPass=1
                    WRITE_XML_ERROR 0 "Node: $Item||INFO:the IPV4 ipmi($ipmi_ip_v4) Can not access.ERRCODE(5)"
                    fi
            fi
            if [ "$ipmi_ip_v6" != "--" ];then
                #ͨomip ping ipmi 
                for time in ${RepeatTimes[*]}; do
                    tempStr_ping_v6=$( ping6 -q -c 1 $ipmi_ip_v6 |grep "1 received" |wc -l )
                local iRet=$?
                if [ $iRet -ne 0 ]; then
                    sleep 10
                else
                    break
                fi
                done
                LOG "Node:$Item, ipmi:$ipmi_ip_v6,omipv6:$OMIPV6Address,tempStr_ping_v6:$tempStr_ping_v6"
                if [ "0" != "$tempStr_ping_v6" ];then
                    connectState_v6="OK"
                else
                    connectState_v6="Can not access."
                    isPass=1
                    WRITE_XML_ERROR 0 "Node: $Item||INFO:the IPV6 ipmi($ipmi_ip_v6) Can not access.ERRCODE(6)"
                fi
            fi

            Result="Node:$Item||IPMI_IPV4:$ipmi_ip_v4||IPMI_IPV6:$ipmi_ip_v6||ConnectingStatus_IPV4:$connectState_v4||ConnectingStatus_IPV6:$connectState_v6"
            LOG "[$FUNCNAME]Node:$Item(Not C72 node)||$Result"

            WRITE_XML_COMMON 0 "$Result"
        done

        if [ "${isPass}" == "0" ];then
            WRITE_XML_JUDGE 0
        else
            WRITE_XML_ERROR 0 "$errResult"
            WRITE_XML_JUDGE 1
        fi
    fi
    WRITE_XML_SUBCMD_TAIL
}

#DiskPoolֵ
Checkdiskpoolcap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local PoolType=""
    local PoolTypeindex=0
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local Result1="nodepool_id:--||nodePool_name:--||CapThreshold:--||ReadOnlyThreshold:--||RecoverValue:--||RecoverReadOnlyValue:--||node_count:--||node:--"
    local isok=0

    dos2unix $G_TMP_FILE$Item

    TierInfoCount=$( cat $G_TMP_FILE$Item | grep "DiskPool"|wc -l )
    LOG "[$FUNCNAME]TierInfoCount:$TierInfoCount"

    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=$( cat $G_TMP_FILE$Item | grep DiskPool | sed -n "$index"p )
        PoolTypeindex=$( cat $G_TMP_FILE$Item | grep -A12 -E "${HeadInfo}"$ | grep PoolType | awk -F: '{print $2}' )
        PoolType="SSD"
        if [ "$PoolTypeindex" == "1" ]; then
            PoolType="HDD"
        fi

        TotalCap=$( cat $G_TMP_FILE$Item | grep -A12 -E "${HeadInfo}"$ | grep TotalCap | awk -F: '{print $2}' )
        LeftCap=$( cat $G_TMP_FILE$Item | grep -A12 -E "${HeadInfo}"$ | grep LeftCap | awk -F: '{print $2}' )

        UsedCap=$( echo $TotalCap-$LeftCap|bc -l )
        if [ "$TotalCap" == "0" ]; then
            Percentage=0
        else
            Percentage=$(echo "$UsedCap/$TotalCap*100"|bc -l| awk '{printf "%.2f", $0}')
        fi
        LOG "[$FUNCNAME]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:"$PoolType" "$HeadInfo"||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "${Result}||${Result1}"

        if [  $( echo "$Percentage > 75.0" | bc ) -eq 1 ]; then
            LOG "[$FUNCNAME]:$isok"
            isok=1
            WRITE_XML_ERROR 0 "MonMaster:$Item||INFO:DiskPool Tier_info($HeadInfo) current Percentage($Percentage) exceeds the threshold Percentage(75)."
        fi

        index=$((index + 1 ))
    done

    return $isok
}

#NodePoolֵ
CheckNodePoolCap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local Result1="nodepool_id:--||nodePool_name:--||CapThreshold:--||ReadOnlyThreshold:--||RecoverValue:--||RecoverReadOnlyValue:--||node_count:--||node:--"
    local isok=0

    dos2unix $G_TMP_FILE$Item

    TierInfoCount=$( cat $G_TMP_FILE$Item | grep "NodePool"|wc -l )
    LOG "[$FUNCNAME]TierInfoCount:$TierInfoCount"

    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=$( cat $G_TMP_FILE$Item | grep NodePool | awk NR==$index )

        TotalCap=$( cat $G_TMP_FILE$Item | grep -A4 -E "${HeadInfo}"$ | grep TotalCap | awk -F: '{print $2}' )
        LeftCap=$( cat $G_TMP_FILE$Item | grep -A4 -E "${HeadInfo}"$ | grep LeftCap | awk -F: '{print $2}' )

        UsedCap=$( echo $TotalCap-$LeftCap|bc -l )
        if [ "$TotalCap" == "0" ]; then
            Percentage=0
        else
            Percentage=$(echo "$UsedCap/$TotalCap*100"|bc -l| awk '{printf "%.2f", $0}')
        fi

        LOG "[$FUNCNAME]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:$HeadInfo||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "${Result}||${Result1}"

        if [  $( echo "$Percentage > 75.0" | bc ) -eq 1 ];then
            LOG "[$FUNCNAME]:$isok"
            isok=1
            WRITE_XML_ERROR 0 "MonMaster:$Item||INFO:NodePool Tier_info($HeadInfo) current Percentage($Percentage) exceeds the threshold Percentage(75)."
        fi

        index=$((index + 1 ))
    done

    return $isok
}

#Tiercapֵ
CheckTierCap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local isok=0
    local Result1="nodepool_id:--||nodePool_name:--||CapThreshold:--||ReadOnlyThreshold:--||RecoverValue:--||RecoverReadOnlyValue:--||node_count:--||node:--"
    dos2unix $G_TMP_FILE$Item

    TierInfoCount=$( cat $G_TMP_FILE$Item | grep "Tier"|wc -l )
    LOG "[$FUNCNAME]TierInfoCount:$TierInfoCount"
    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=$( cat $G_TMP_FILE$Item | grep Tier | awk NR==$index )

        TotalCap=$( cat $G_TMP_FILE$Item | grep -A4 -E "${HeadInfo}"$ | grep TotalCap | awk -F: '{print $2}' )
        LeftCap=$( cat $G_TMP_FILE$Item | grep -A4 -E "${HeadInfo}"$ | grep LeftCap | awk -F: '{print $2}' )

        UsedCap=$( echo $TotalCap-$LeftCap|bc -l )
        if [ "$TotalCap" == "0" ]; then
            Percentage=0
        else
            Percentage=$(echo "$UsedCap/$TotalCap*100"|bc -l| awk '{printf "%.2f", $0}')
        fi

        LOG "[$FUNCNAME]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:$HeadInfo||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "${Result}||${Result1}"

        if [ $( echo "$Percentage > 75.0" | bc ) -eq 1 ];then
            LOG "[$FUNCNAME]:$isok"
            isok=1
            WRITE_XML_ERROR 0 "MonMaster:$Item||INFO: Tier Tier_info($HeadInfo) current Percentage($Percentage) exceeds the threshold Percentage(75)."
        fi

        index=$((index + 1 ))
    done

    return $isok
}

#TierMap
CheckTierMap()
{
    local PoolInfoCount=0
    local Result1="Tier_info:--||TotalCap(BYTE):--||UsedCap(BYTE):--||Percentage(%):--"
    local isok=0

    dos2unix $G_TMP_FILE$Item

    PoolInfoCount=$( cat $G_TMP_FILE$Item | grep "nodepool id"|wc -l )
    LOG "[$FUNCNAME]PoolInfoCount:$PoolInfoCount"
    index=1
    while [ "$index" -le "$PoolInfoCount" ]
    do
        local HeadInfo=$( cat $G_TMP_FILE$Item | grep "nodepool id" | awk NR==$index )
        local tmpinfo=$( cat $G_TMP_FILE$Item | grep -A13 -E "${HeadInfo}"$ )
        local nodePoolId=$( echo "${tmpinfo}" | grep "nodepool id" | awk -F: '{print $2}' )
        local nodePoolName=$( echo "${tmpinfo}" | grep "nodepool name" | awk -F: '{print $2}' )
        local nodeCount=$( echo "${tmpinfo}" | grep "node count" | awk -F: '{print $2}' )
        local nodeList=$( echo "${tmpinfo}" | grep "node :" | awk -F: '{print $2}' )
        local CapThreshold=$( echo "${tmpinfo}" | grep "CapThreshold" | awk -F: '{print $2}' )
        local ReadOnlyThreshold=$( echo "${tmpinfo}" | grep "ReadOnlyThreshold" | awk -F: '{print $2}' )
        local RecoverValue=$( echo "${tmpinfo}" | grep "RecoverValue" | awk -F: '{print $2}' )
        local RecoverReadOnlyValue=$( echo "${tmpinfo}" | grep "RecoverReadOnlyValue" | awk -F: '{print $2}' )

        local Result2="nodepool_id:${nodePoolId}||nodePool_name:${nodePoolName}||CapThreshold:${CapThreshold}||ReadOnlyThreshold:${ReadOnlyThreshold}"
        local Result3="RecoverValue:${RecoverValue}||RecoverReadOnlyValue:${RecoverReadOnlyValue}||node_count:${nodeCount}||node:${nodeList}"
        WRITE_XML_COMMON 0 "${Result1}||${Result2}||${Result3}"
        index=$((index + 1 ))
    done

    return $isok
}

#223.ּ
checkTier()
{
    WRITE_XML_SUBCMD_HEADER $1
    local count=0
    local Result=""
    local isPass=0
    local Item=""

    while true; do
        #ȡmonĵַ
        set_ifs

        AllItem=$( cat /proc/monc_monmap | grep ipaddr_ | awk -F "=" '{print $2}' )
        for Item in $AllItem
        do
            remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon' > $G_REMOTE_TMP_FILE$FUNCNAME[Tier] 2>&1"
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME]can't get mon info"
            else
                LOG "[$FUNCNAME]:MonIP:$Item"
                break
            fi
        done

        #ִmon tiercap 0
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon tiercap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[Tier] 2>&1"
        remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[Tier]
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME]can't get TierCap info"
            WRITE_XML_ERROR 0 "MonMaster:$Item||INFO: can't get TierCap info"
        else
            #
            CheckTierCap
            if [ $? -ne 0 ]; then
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi
        fi

        #ִmon nodepoolcap 0
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon nodepoolcap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[NODE] 2>&1"
        remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[NODE]
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME]can't get nodepoolcap info"
            WRITE_XML_ERROR 0 "MonMaster:$Item||INFO: can't get nodepoolcap info"
        else
            #
            CheckNodePoolCap
            if [ $? -ne 0 ]; then

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi
        fi

        #ִmon diskpoolcap 0
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon diskpoolcap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[DISK] 2>&1"
        remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[DISK]
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME]can't get diskpoolcap info"
            WRITE_XML_ERROR 0 "MonMaster:$Item||INFO: can't get diskpoolcap info"
        else
            #
            Checkdiskpoolcap
            if [ $? -ne 0 ]; then

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi
        fi

        #ִcat /proc/monc_tiermap
        cat /proc/monc_tiermap > $G_TMP_FILE$Item 2>&1
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME]can't get diskpoolcap info"
            WRITE_XML_ERROR 0 "MonMaster:$Item||INFO: can't get tiermap info"
        else
            #
            CheckTierMap
            if [ $? -ne 0 ]; then
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi
        fi

        restore_ifs
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#224Ƿδĸ澯
checkLeftAlarm_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local value
    local iRet=0

    set_ifs
    #ѯδĸ澯δδָδѻָ2״̬
    for((i=0;i<3;++i));do
        sqlite3 /opt/huawei/snas/etc/cm_alarm_record.db 'select ALMID,ALMOCCURTIME from CM_ALARM_RECORD_T where ALMTYPE=0 and (ALMSTATUS=1 or ALMSTATUS=3);' >$G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -eq 0 ]; then
            LOG "[$FUNCNAME]times=$i,iRet=$iRet:get alarm information success!"
            break;
        else
            LOG "[$FUNCNAME]times=$i,iRet=$iRet:can't get alarm information!"
            sleep 5
        fi
    done
    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "Error: can't get alarm information!ERRCODE(4)"
        LOG "[$FUNCNAME]$IPAddress:can't get alarm information!"
        isPass=1
    else
        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        alarmInfo=$(cat $G_REMOTE_TMP_FILE$FUNCNAME)
        if [ ! -z "${alarmInfo}" ]; then
            while read line
            do
                alarmid=$( echo "${line}" | awk -F '|' '{print $1}' )
                alarmidHex=$( echo "obase=16;$alarmid"|bc )
                alarm_occur_time=$( echo "${line}" | awk -F '|' '{print $2}' )
                alarm_occur_time=$( date -d @${alarm_occur_time} )
                alarm_name=$( sqlite3 /opt/huawei/snas/static/alarmdef.db "select AlmName from alarmdefine_en where AlmID=${alarmid};" )
                WRITE_XML_COMMON 0 "Uncleared alarm ID:0x$alarmidHex||Alarm occur time:${alarm_occur_time}||Alarm name:${alarm_name}"
                LOG "[$FUNCNAME][${LINENO}]:Uncleared alarm ID:0x$alarmidHex||Alarm occur time:${alarm_occur_time}||Alarm name:${alarm_name}"
            done < $G_REMOTE_TMP_FILE$FUNCNAME
            isPass=1
        else
            WRITE_XML_COMMON 0 "There are no uncleared alarms in the system."
            LOG "[$FUNCNAME]:There are no uncleared alarms in the system."
        fi
    fi
    restore_ifs

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#225 ҵڵ
#uds֧
checkMasterStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local errResult=""
    local Result=""
    local TASK_ID=0
    local ProductType=$(cat "/opt/huawei/snas/etc/snas.ini"|grep productType|awk -F= '{print $2}')

    set_ifs
    #ȡcmϢΪ׼
    mon_base=$( cat /proc/monc_leader | grep Mon | awk '{print $3}' )
    mds_base=$( cat /proc/monc_leader | grep Mds | awk '{print $3}' )
    pip_base=$( cat /proc/monc_leader | grep Pip | awk '{print $3}' )
    restore_ifs

    LOG "[$FUNCNAME]:mon_base:$mon_base||mds_base:$mds_base||pip_leader:$pip_base||ProductType:$ProductType"

        REMOTE_IP_S=$( cat $IP_ROLE_FILE )

        remote_exec_async_batch $TASK_ID 30 "cat /proc/monc_leader > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        isPass=$?

        ValidIP=$( cat ${VALID_IP_FILE} )
        ValidIPResult=$ValidIP
        LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
        fifo_start
        while [ "${ValidIP}" != "" ]; do
            >${VALID_IP_FILE}

            for Item in $ValidIP; do
                #Ϊ100%֮ļأн
                remote_exec_checkfini $Item $TASK_ID "Can not monc_leader information"
                iRet=$?

                if [ $iRet -eq 0 ];then
                    echo -n "$Item " >> ${VALID_IP_FILE}
                    continue
                elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                    isPass=1
                    continue
                fi

                remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to get monc_leader info"
                    isPass=1
                    continue
                fi
            done

            ValidIP=$( cat ${VALID_IP_FILE} )
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            mon_leader=$( cat $G_TMP_FILE$Item | grep Mon | awk '{print $3}' )
            mds_leader=$( cat $G_TMP_FILE$Item | grep Mds | awk '{print $3}' )
            pip_leader=$( cat $G_TMP_FILE$Item | grep Pip | awk '{print $3}' )
            #checkڵ
            if [ $ProductType -eq 80 ];then
                Result="Node:$Item||mon_leader:$mon_leader"
            else
                local service_type=$(get_service_type_from_db "${Item}")
                if [ "${service_type}" == "1" ];then
                    Result="Node:$Item||mon_leader:$mon_leader||mds_leader:$mds_leader||pip_leader:$pip_leader"
                else
                    Result="Node:$Item||mon_leader:$mon_leader||mds_leader:--||pip_leader:--"
                fi
            fi

            LOG "[$FUNCNAME]:Result:$Result"
            WRITE_XML_COMMON 0 "$Result"
            #ݲһ
            if [ $ProductType -eq 80 ];then
                if [ "$mon_leader" == "" ] || [ "$mon_leader" != "$mon_base" ]; then
                    isPass=1
                    WRITE_XML_ERROR 0 "Node:Item||INFO: mon_leader($mon_leader) is empty or monleader($mon_leader) in not same with master node mon_leander($mon_base).ProductType(${ProductType})"
                fi
            else
                if [ "${service_type}" == "1" ];then
                    if [ "$mon_leader" == "" ] || [ "$mds_leader" == "" ] || [ "$pip_leader" == "" ] || [ "$mon_leader" != "$mon_base" ] || [ "$mds_leader" != "$mds_base" ] || [ "$pip_leader" != "$pip_base" ]; then
                        isPass=1
                        WRITE_XML_ERROR 0 "Node:Item||INFO: mon_leader($mon_leader) is empty or is not same with master node mon_leander($mon_base),mds_leader($mds_leader) is empty or is not same with master node mds_leader($mds_leader),pip_leader($pip_leader) is empty or is not same with master node pip_leader($pip_leader).service_type(${service_type})"
                    fi
                else
                    if [ "$mon_leader" == "" ] || [ "$mon_leader" != "$mon_base" ]; then
                        isPass=1
                        WRITE_XML_ERROR 0 "Node:Item||INFO: mon_leader($mon_leader) is empty or monleader($mon_leader) in not same with master node mon_leander($mon_base).service_type(${service_type})"
                    fi
                fi
            fi

            >$G_TMP_FILE$Item
        done


    if [ "" != "${errResult}" ];then
        WRITE_XML_ERROR 0 "$errResult"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
 }

#226 mon server
checkMonServer()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0

    LOG "[$FUNCNAME]start!"

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/ShowMonServer > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not mon Server information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                continue
            fi
        done

        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            set_ifs
            while read line; do
                info=$( handle_remote_result "$line" )
                if [ $? -ne 0 ]; then
                    isPass=1
                    errResult="Node:$Item||INFO:$info"
                    WRITE_XML_ERROR 0 "${errResult}"
                else
                    echo "$info"|grep "Server_num"
                    if [ $? -eq 0 ]; then
                        MonServer_NUM=$(echo "$info" | grep "Server_num" | awk -F= '{print $2}')
                    fi
                    echo "$info"|grep "Server_IP"
                    if [ $? -eq 0 ]; then
                        MonServer_IP=$(echo "$info" | grep "Server_IP" | awk -F= '{print $2}')
                    fi
                fi
            done < $G_TMP_FILE$Item
            WRITE_XML_COMMON 0 "Node:$Item||MonServer_NUM:$MonServer_NUM||MonServer_IP:$MonServer_IP"
            restore_ifs
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#λȡpoolname
NvdimmPool_GetPollName()
{
    case $1 in
        5)
            echo "Pool[nvcache.0]"
            ;;
        6)
            echo "Pool[trns.0]"
            ;;
        7)
            echo "Pool[ds.0]"
            ;;
        8)
            echo "Pool[quota.0]"
            ;;
        *)
            echo "Pool[UNKNOWN]"
            ;;
    esac
}

#227 Nvdimmڴصʹ
checkNvdimmPool()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local fimename="NvdimmPool"
    local TASK_ID="getinfo"
    local isPass=0
    local isflag=""
    local Info=""
    local Info_one=""
    local Total_Count=0
    local numCnt=1
    local numCnt_new=0
    local PoolName=""
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch_mml $TASK_ID 120 GetNvdimmPoolUsage $FUNCNAME
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}

        for Item in $ValidIP
        do
            Result=""

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get NvdimmPool information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            for i in {5..7};
            do
                Info=""
                remote_download $Item $G_TMP_FILE$Item$i /tmp/tmpfile$fimename$i
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    LOG "[$FUNCNAME]:Node:$Item||INFO:download pool($i) info fail,return($iRet)"
                    Result="Node:$Item||INFO:download pool info fail ||Pool:-||TotalSize(MB):-||FreeSize(MB):-||UsedSize(MB):-||Percentage(%):-"
                    WRITE_XML_COMMON 0 "$Result"
                    isPass=1
                    continue
                fi
            done
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            Result=""

            for i in {5..7};
            do
                fifoContext=$( cat $G_TMP_FILE$Item$i )
                if [ "$fifoContext" = "" ];then
                    continue
                fi

                #жǷΪûnvdimmµ
                isNvdimm=$( cat $G_TMP_FILE$Item$i | grep "no nvdimm, no need to get" )
                if [ "$isNvdimm" != "" ] ;then
                    Result="Node:$Item||INFO: no nvdimm, no need to get ||Pool:-||TotalSize(MB):-||FreeSize(MB):-||UsedSize(MB):-||Percentage(%):-"
                    WRITE_XML_COMMON 0 "$Result"
                    continue
                fi

                Info=$( cat $G_TMP_FILE$Item$i | grep "total size" )
                if [ "$Info" == "" ];then
                    Info=$( cat $G_TMP_FILE$Item$i )
                    LOG "[$FUNCNAME]:Node:$Item||INFO:get pool($i) info fail,Info($Info)"

                    Result="Node:$Item||INFO:get Nvdimm pool info fail ||Pool:-||TotalSize(MB):-||FreeSize(MB):-||UsedSize(MB):-||Percentage(%):-"
                    WRITE_XML_COMMON 0 "$Result"
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:get Nvdimm pool info fail from $G_TMP_FILE$Item$i.ERRCODE(4)"
                    isPass=1
                    continue
                fi

                set_ifs

                #ȡ
                Total_Count=$( cat $G_TMP_FILE$Item$i | grep "total size" | wc -l )
                numCnt=1
                while [ $numCnt -le $Total_Count ]; do
                    #ȡݣ
                    Info_one=$( cat $G_TMP_FILE$Item$i | grep "total size" | awk NR==$numCnt )

                    isflag=$( echo $Info_one |grep ">>>" )
                    if [ "$isflag" == "" ];then
                        PoolName=$( cat $G_TMP_FILE$Item$i | grep "total size" | awk NR==$numCnt | awk -F'Pool' '{print $2}' | awk -F'[' '{print $2}' | awk -F']' '{print $1}' )
                        if [ "$PoolName" == "" ];then
                            Pool=$( NvdimmPool_GetPollName $i )
                        else
                            Pool="Pool[$PoolName]"
                        fi
                    else
                        Pool=$( NvdimmPool_GetPollName $i )
                    fi

                    totalsize=$( echo $Info_one|awk '{print $4}' )
                    freesize=$( echo $Info_one|awk '{print $11}' )

                    usedSize=$( expr $totalsize \- $freesize )

                    usedSize_temp=$( expr $usedSize \* 100 )
                    percentage=$( expr $usedSize_temp \/ $totalsize )
                    Result="Node:$Item||INFO: get pool info ok||Pool:$Pool||TotalSize(MB):$totalsize||FreeSize(MB):$freesize||UsedSize(MB):$usedSize||Percentage(%):$percentage"
                    LOG "[$FUNCNAME]:$Result"

                    WRITE_XML_COMMON 0 "$Result"
                    #ģڴռҲģڴռ85%
                    if [ $percentage -ge 90 ];then
                        isPass=1
                        WRITE_XML_ERROR 0 "Node:$Item||INFO:Pool $Pool current percentage($percentage) exceeds the threshold percentage(90).ERRCODE(5)"
                    fi

                    #¼
                    numCnt=$((numCnt+1))
                done
                restore_ifs
            done
    done

    WRITE_XML_JUDGE ${isPass}
    WRITE_XML_SUBCMD_TAIL
}

#228 ع״̬
checkDataRestore()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local checkScenario=$2
    local dailyScenario=2
    local upgradeScenario=4
    local isNeedCheck="yes"
    local tmpfile=/tmp/tmpfilecheckDataRestore
    local totalcount=0
    local back_ip=""
    local lunflag=0

    back_ip=$(get_backnet_ip)
    if [ "$back_ip" = "" ]; then
        LOG "[$FUNCNAME]:INFO:Can't get back-end IP."
        isPass=1
        WRITE_XML_ERROR 0 "Node:Master||INFO:Can't get back-end IP."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
    fi

    #1cm_task.db
    if [ -f /opt/huawei/snas/etc/cm_task.db ];then
        #ʱmsdateȡʱ룬Ҫת
        taskInfo=$(sqlite3 /opt/huawei/snas/etc/cm_task.db "select ID,RUNSTATE,STARTTIME,USEDTIME from CM_TASK_T  where (OPTID=4 and FINISHTIME=0 and DELETED!=1);")
        currTime=$(date +%s)

        for item in $taskInfo
        do
            local taskid=$(echo $item | awk -F "|" '{ print $1}')
            local runstate=$(echo $item | awk -F "|" '{ print $2}')
            local starttime=$(echo $item | awk -F "|" '{ print $3}')
            local usedtime=$(echo $item | awk -F "|" '{ print $4}')
            starttime=$(expr $starttime \/ 1000)
            local runningStatus=$(MapRunningStatus $runstate)
            if [ "$runningStatus" = "RUNNING" ];then
                usedtime=$(expr $currTime - $starttime)
            fi
            local strdate=$(date -d @$starttime)
            if [ ${checkScenario} -eq ${dailyScenario} ] && [ ${usedtime} -gt 172800 ]; then
                isPass=1
                isNeedCheck="no"
                WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:The reconstruction task ${taskid} has been executed for more than 48 hours."
            fi
            let totalcount++
            WRITE_XML_COMMON 0 "TaskId:${taskid}||TaskName:data_reconstruction||RunState:${runningStatus}||StartTime:$strdate||UsedTime:$usedtime"
        done

        if [ $totalcount -ne 0 ] && [ ${checkScenario} -eq ${upgradeScenario} ];then
            isNeedCheck="no"
            isPass=1
            WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:The cluster currently has reconfiguration tasks not completed."
        fi
    fi
    #2MmlBatch 4016 "cm task show"
    if [ "${isNeedCheck}" == "yes" ];then
        /usr/local/bin/MmlBatch 4016 "cm task show" > $tmpfile 2>&1
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:Can not get task info (MmlBatch 4016 'cm task show'),Error(${iRet})!"
            LOG "iRet=$iRet,can not get task info:$(cat $tmpfile)"
        else
            dos2unix $tmpfile > /dev/null 2>&1
            sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $tmpfile >/dev/null 2>&1

            local Tasks=$(cat $tmpfile | grep "task_id" | grep "task_type:4" | sed 's/^ *//g' | sed "/^$/d" | tr -d "\r")
            set_ifs
            for Task in $Tasks
            do
            {
                local TaskId=$(echo $Task |awk -F "task_id:" '{printf $2}'|awk -F "task_name" '{printf $1}' |tr -d " |")
                local TaskName=$(echo $Task |awk -F "task_name:" '{printf $2}'|awk -F "task_type" '{printf $1}' |tr -d " |")
                local TaskType=$(echo $Task |awk -F "task_type:" '{printf $2}'|awk -F "runningStatus" '{printf $1}' |tr -d " |")
                local runStatus=$(echo $Task |awk -F "runningStatus:" '{printf $2}')
                if [ "$TaskType" = "" ] || [ "$runStatus" = "" ] || [ "$TaskId" = "" ];then
                    continue;
                fi
                if [ "$TaskName" = "" ];then
                    break;
                fi

                local runningStatus=$(MapRunningStatus $runStatus)
                if [ "$runStatus" != "38" ] && [ "$runStatus" != "40" ];then
                    LOG "Task:$Task"
                    isNeedCheck="no"
                    isPass=1
                    WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:Refactoring task ${TaskId} status (${runningStatus}) is not STOP or COMPLETED."
                fi
                let totalcount++

                WRITE_XML_COMMON 0 "TaskId:$TaskId||TaskName:$TaskName||RunState:$runningStatus||StartTime:--||UsedTime:--"
            }
            done
            restore_ifs
        fi
    fi

    if [ "${isNeedCheck}" == "yes" ] && [ ${checkScenario} -eq ${upgradeScenario} ];then
        [ -f $tmpfile ]&& rm $tmpfile
        local mon_leader=$(grep "Mon" /proc/monc_leader | awk -F':' '{print $2}' | tr -d ' ')
        remote_exec $mon_leader 30 "$G_MML_FILE_PATH/ShowDataRestore $mon_leader > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        remote_download $mon_leader $tmpfile $G_REMOTE_TMP_FILE$FUNCNAME
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:${mon_leader}||INFO:Can not get hln info (MmlBatch 988 'show hln'),Error(${iRet})!"
            LOG "iRet=$iRet,can not get hln info:$(cat $tmpfile)"
        else
            #mmlĽ
            Recover_Info=$(cat $tmpfile | grep 'uiPrintNlunCount' 2>&1)

            PrintNlunCount=$(echo $Recover_Info | awk -F"("  '{print $2}' | awk -F")"  '{print $1}')
            var=$(echo "$PrintNlunCount" | bc 2>/dev/null)
            if [ "$PrintNlunCount" == "" ] || [ "$var" != "$PrintNlunCount" ];then
                isPass=1
                LOG "The cluster currently has reconstruction tasks.(show hln running)!"
                WRITE_XML_ERROR 0 "Node:${mon_leader}||INFO:The cluster currently has reconstruction tasks.(show hln running)"
            elif [ "$PrintNlunCount" -ne "0" ];then
                local lunlist=$(cat $tmpfile | grep "Index([0-9+])NLUN" | awk '{print $2}' |sed ':jix;N;s/\n/,/g;b jix')
                if [ ${#lunlist} -gt 60 ];then
                    lunlist="${lunlist:0:60}......"
                fi
                isPass=1
                WRITE_XML_ERROR 0 "Node:${mon_leader}||INFO:The cluster has $PrintNlunCount luns of data to be restored.(${lunlist})"
            else
                lunflag=1
            fi
        fi
    fi

    if [ $totalcount -eq 0 ];then
        WRITE_XML_COMMON 0 "INFO:The cluster currently has no reconstruction tasks."
        if [ $lunflag -eq 1 ];then
            WRITE_XML_COMMON 0 "INFO:There is no lun in the cluster that needs to be restored."
        fi
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#229 Ⱥֻˮλ
checkReadOnlyThreshold()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local info=""
    local back_ip=""
    local errResult=""
    local nodepool_name=""
    local thresholdValue=""
    local allNodePool=""
    local productName=""
    local productVersion=$(cat /opt/huawei/deploy/package/version | grep -w "ProductVersion" | awk -F= '{print $2}')
    if [[ "$productVersion" =~ "V100R006C30SPC" ]] || [[ "$productVersion" =~ "V100R006C10SPC" ]];then
        isPass=3
        WRITE_XML_COMMON 0 "ReadOnlyThreshold:No need checking $productVersion."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    info=$(cat /proc/monc_tiermap)
    if [ "X$info" = "X" ];then
        isPass=1
        errResult="INFO:The file /proc/monc_tiermap is empty in node $(hostname)."
        WRITE_XML_ERROR 0 "${errResult}"
    else
        allNodePool=$(echo "$info" | grep -w "nodepool id " | awk -F: '{print $2}')
        for tmpNodePool in $allNodePool
        do
            local highValue=95
            local lowValue=90
            tmpNodeIp=$(echo "$info" | grep -wA15 "nodepool id :$tmpNodePool" | grep -w "node :" | awk '{print $NF}')
            if [ X"${tmpNodeIp}" == X"" ]; then
                productName=$(/opt/huawei/deploy/script/localexec.py cmd ${tmpNodeIp} 30 false "ipmitool fru" |grep "Product Name" | awk -F: '{print $2}')
            else
                productName=$(ipmitool fru |grep "Product Name" | awk -F: '{print $2}')
            fi
            if [[ "${productName}" =~ "P12" ]] || [[ "${productName}" =~ "S12" ]] || [[ "${productName}" =~ " M " ]];then
                highValue=90
                lowValue=85
            fi
            nodepool_name=$(echo "$info" | grep -wA15 "nodepool id :$tmpNodePool" | grep -w "nodepool name " | awk -F: '{print $2}' | head -1 )
            thresholdValue=$(echo "$info" | grep -wA15 "nodepool id :$tmpNodePool" | grep -w "ReadOnlyThreshold " | awk -F: '{print $2}' | head -1 )
            if [ $? -eq 0 ]; then
                if [ "${thresholdValue}" -gt ${highValue} ];then
                    isPass=$(check_pass $isPass 1)
                elif [ "${thresholdValue}" -gt ${lowValue} ];then
                    isPass=$(check_pass $isPass 4)
                fi
                WRITE_XML_COMMON 0 "NodePool:${tmpNodePool}||NodePoolName:${nodepool_name}||ProductName:${productName}||ReadOnlyThreshold:${thresholdValue}"
            else
                isPass=$(check_pass $isPass 1)
                errResult="INFO:The file /proc/monc_tiermap is error.(NO ReadOnlyThreshold value in ${tmpNodePool})"
                WRITE_XML_ERROR 0 "${errResult}"
            fi
        done
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#ds mapȡ״̬쳣pool
getAbnormalPool()
{
    dsid=0
    poolid=0
    cat /proc/monc_dsmap > /var/dsmap
    > /var/abnormalpool;
    while read line
    do
        echo "$line" |grep "^Pools" &> /dev/null
        if [ $? -eq 0 ]; then
            dsid=$( echo $line |awk -F" " '{print $4}' |awk -F":" '{print $1}' )
            continue;
        fi
        echo "$line" |grep "^Id" &> /dev/null
        if [ $? -eq 0 ]; then
            echo "$line" |grep "Abnormal" &> /dev/null
            if [ $? -ne 0 ]; then
                continue;
            fi
            #abnormal pool
            poolid=$( echo $line |awk -F" " '{print $2}' )
            echo "($dsid $poolid)" >> /var/abnormalpool
        fi
    done < /var/dsmap
}

getDiskStatInNlun()
{
    bitmap=$( printf %d 0x$1 )
    cnt=$2
    index=$3
    cnt=$(($cnt-$index))
    cnt=$(($cnt-1))
    cnt=$((3*$cnt))
    bitmap=$(($bitmap>>$cnt))
    bitmap=$(($bitmap&7))
    return $bitmap;
}

addPoolInBadList()
{
    echo "$1" >> /var/nlun_pool_result
}

#nlun mapds mapеpool statǷһ
checkDiskStat()
{
    nlundiskstat=$1
    poolcnt=$2
    idx=$3
    pname=$4
    #ȡnlun disk statӦbitλ
    getDiskStatInNlun $nlundiskstat $poolcnt $idx
    if [ $? -eq 0 ]; then
        return
    fi
    #쳣poolǷѾ¼/var/nlun_pool_result
    grep "$pname" /var/nlun_pool_result &> /dev/null
    if [ $? -eq 0 ]; then
        return
    fi
    #ӹpool
    addPoolInBadList "($pname)"
}

#nlunгԱpool״̬״̬쳣DS map״̬һ¶ӡ$G_TMP_FILE2$Item
checkNlunPoolStatus()
{
    local result_log=/var/log/nluninfo.log

    > /var/nlun_pool_result
    #$result_logÿһ
    neednext=0
    while read line
    do
        if [[ "$line" == NLUN*NewPt* ]]; then
            diskstat=$( echo $line |awk -F" " '{print $23}' )
            neednext=1
            continue;
        fi
        if [ $neednext -eq 1 ]; then
            neednext=0
            #ȡnlunԱ
            if [ $diskstat -ne 0 ]; then
                pools=$( echo $line |awk 'BEGIN{FS="[()]"}{for(i=2;i<NF;i++) if($i!=" ")print $i}' )
                poolcnt=0
                for pool in $pools
                do
                    poolcnt=$(($poolcnt+1))
                done
                index=0
                for pool in $pools
                do
                    checkDiskStat $diskstat $poolcnt $index $pool
                    index=$(($index+1))
                done
            fi
        fi
    done < $result_log
    #/var/abnormalpoolе쳣̼/var/nlun_pool_result
    while read line
    do
        #쳣poolǷѾ¼/var/nlun_pool_result
        grep "$line" /var/nlun_pool_result &> /dev/null
        if [ $? -eq 0 ]; then
            continue;
        fi
        addPoolInBadList "$line"
    done < /var/abnormalpool
}

#230 nlun״̬
getNlunStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local TASK_ID=0
    local result_log=/var/log/nluninfo.log

    while true;do
        get_nlunmap
        iRet=$?
        if [ $iRet -eq 0 ];then
            isPass=1
            break
        fi

        set_ifs

        cat $result_log | grep -w State  | grep -wv 'State 0' > $G_TMP_FILE2$FUNCNAME
        lineNum=$( cat $G_TMP_FILE2$FUNCNAME|wc -l )
        if [ $lineNum -eq 0 ];then
            Result="Nlun State:--------------------------------------------------||Nlun State:All State is 0"
            WRITE_XML_COMMON 0 "$Result"
            LOG "$Result"
        else
            isPass=1
            Result="Nlun State:--------------------------------------------------||Nlun State:There are $lineNum that States are not 0.ERRCODE(4)"
            WRITE_XML_ERROR 0 "${Result}"

            top_20=$( cat $G_TMP_FILE2$FUNCNAME | head -20| sed 's/</(lt)/g' )
            Result=""
            for line in "$top_20"; do
                if [ "" != "${Result}" ];then
                    Result="$Result||Nlun State:$line"
                else
                    Result="Nlun State:$line"
                fi
            done

            Result="Nlun State:--------------detail--------------||${Result}"
            WRITE_XML_COMMON 0 "$Result"
            WRITE_XML_ERROR 0 "INFO:The number of error State is $lineNum."
        fi
        restore_ifs
        break;
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#231 MONǷƵѡ
 checkMonHealth()
 {
     WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0

    LOG "[$FUNCNAME]start!"

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch_mml $TASK_ID 30 ShowMonitorHealth $FUNCNAME
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Cann't get MonHealth "
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Get MonHealth failed.ERRCODE(4)"
                continue
            fi

            dos2unix $G_TMP_FILE$Item

            Ret=$( cat $G_TMP_FILE$Item | grep bootstrap | tr -d " "| awk -F: '{printf $2}' )
            Ret1=$( cat $G_TMP_FILE$Item | grep "elec      :" | tr -d " " | awk -F: '{printf $2}' )
            if [ "$Ret" != "OK" ] || [ $Ret1 != "OK" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:THE bootstrap status($Ret) is not OK or elec status($Ret1) is not OK. ERRCODE(5)"
                cat $G_TMP_FILE$Item >> $LOG_FILE
                if [ "X${Ret}" != "X" ] || [ "X${Ret1}" != "X" ];then
                    Result="Node:$Item||Bootstrap:$Ret||Elec:$Ret1"
                    WRITE_XML_COMMON 0 "$Result"
                else
                    info="Get MonHealth failed."
                    errResult="Node:$Item||Error:$info||${errResult}"
                fi
            else
                Result="Node:$Item||Bootstrap:$Ret||Elec:$Ret1"
                WRITE_XML_COMMON 0 "$Result"
            fi
    done

    if [ "$errResult" != "" ];then
        WRITE_XML_ERROR 0 "${errResult}"
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
 }

#232 MDSһ
checkMdsSubTreeStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local dfsFlag=0

    #Զ첽ִҪУipVALID_IP_FILE
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    remote_exec_async_batch_mml $TASK_ID 120 CheckMdsSubTree $FUNCNAME
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                errResult="Does not involve"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:$errResult"
                continue
            fi

            dfsFlag=1

            remote_exec_checkfini $Item $TASK_ID "Can not get mds SubTree information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                continue
            fi

            #Ϊ100%֮ļأн
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ]; then
                continue
            fi

            #ǷokSubtree checkup OK.Subtree checkup failed
            checkRst=$( cat $G_TMP_FILE$Item|grep "checkup OK" )
            if [ "$checkRst" == "" ]
            then
                errResult="Node: $Item||INFO: mds subtree is not accordant.ERRCODE(4)"
                WRITE_XML_ERROR 0 "$errResult"

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

                isPass=1
            else
                errResult="Node: $Item||INFO: mds subtree is accordant."
                WRITE_XML_COMMON 0 "$errResult"
            fi

            filenum=$( cat $G_TMP_FILE$Item | grep "\[DENTRY_FILE" |cut -d '=' -f 2|cut -d ',' -f 1 |sed 's/ //g' )
            dirnum=$( cat $G_TMP_FILE$Item  | grep "\[DENTRY_DIR"  |cut -d '=' -f 2|cut -d ',' -f 1 |sed 's/ //g' )

            LOG "[$FUNCNAME]:Lru filenum:$filenum, dirnum:$dirnum"

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            WRITE_XML_COMMON 0 "Node:$Item||INFO:Lru in mem file:$filenum, dir:$dirnum"
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

# 233 ǷCOREļ
checkCoreFile()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0
    local spaceFlag=0

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    #ֱ/corefile/crash/corefileĿ¼вǷн30ļ
    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/CheckItems checkCoreFile $G_REMOTE_TMP_FILE$FUNCNAME"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get core information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            #ǷcoreļȣļмУоcoreļблļٻһ
            crashPass=no
            corePass=no
            coreName="--"
            crashfile=$(cat $G_TMP_FILE$Item | grep "/corefile/crash/" |grep -v "find: \`/corefile/crash'" | awk 'END {print NR}')
            LOG "[$FUNCNAME]:Node: $Item||INFO: crash file is exit,crashfile:$crashfile"

            if [ $crashfile -ge 1 ]
            then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:crash file is exit,crashfile $crashfile.ERRCODE(4)"
                crashPass=yes
            fi

            corefile=$(cat $G_TMP_FILE$Item | grep "/corefile/core-" |grep -v "find: \`/corefile"| awk 'END {print NR}')
            LOG "[$FUNCNAME]:Node: $Item||INFO: core file is exit,corefile:$corefile"

            if [ $corefile -ge 1 ]
            then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:core file is exit,corefile $corefile.ERRCODE(5)"
                corePass=yes
                coreName=$(cat $G_TMP_FILE$Item | grep "/corefile/core-" | awk BEGIN{RS=EOF}'{gsub(/\n/," ");print}' | sed 's/\/corefile\///g')
            fi

            corefileSpace=$(cat $G_TMP_FILE$Item | grep "AvailableSpace" | awk -F '=' '{print $2}')
            if [ -n "$corefileSpace" ];then
                if [ $corefileSpace -lt 20480 ];then
                    spaceFlag=1
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:corefile space ${corefileSpace}M less 20480M!.ERRCODE(7)"
                    LOG "[$FUNCNAME][$LINENO]ip:$Item,spaceFlag=$isPass,corefile space less 20480M!"
                fi
            else
               isPass=1
               corefileSpace="--"
               LOG "[$FUNCNAME][$LINENO]ip=$Item,isPass=$isPass,Get corefile space Failed!"
               WRITE_XML_ERROR 0 "Node:$Item||INFO:Get corefile space Failed!.ERRCODE(6)"
            fi
            errResult="Node: $Item||AvailableSpace(MB):$corefileSpace||crashfile: $crashPass||corefile: $corePass||coreName: $coreName"
            WRITE_XML_COMMON 0 "$errResult"

    done

    if [ $isPass -eq 0 ] && [ $spaceFlag -eq 1 ];then
        isPass=4

    fi
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#234 NTP״̬
checkNtpConn()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0
    local ntpserverIP=""
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    #DNSڣжǷͨ
    remote_exec_async_batch $TASK_ID 120 "ntpq -p > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1; exit 0"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get verify information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish
    #ȡڵ
    local back_ip=$( get_backnet_ip )
    for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            bflag1=1   #NTPǷΪ1Ϊ0
            bflag2=1   #ڵNTPserver*Ϊ0Ϊ1.
            #״̬
            serverConn=$( cat $G_TMP_FILE$Item|grep "^*"|wc -l )
            if [ $serverConn -eq 0 ];then
                bflag1=0
                if [ $back_ip == $Item ];then
                    ntpserverIP=$(cat /etc/ntp.conf |grep "^server"|awk '{print $2}')
                    for serverip in ${ntpserverIP[*]};
                    do
                        ntpinfo=$(sntp -t 3 $serverip |grep "no-leap"|wc -l)
                        if [ $ntpinfo -eq 1 ];then
                            bflag1=1
                            bflag2=0
                            LOG "[$FUNCNAME]bflag1=$bflag1;bflag2=$bflag2"
                            break
                        fi
                    done
                fi
                if [ $bflag1 == 0 ];then
                    isPass=1
                    errResult="Node: $Item||INFO: ntp is unreachable.ERRCODE(4)"
                    WRITE_XML_ERROR 0 "$errResult"
                fi
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            fi

            if [ $bflag1 == 1 ];then
                #offsetƫ
                if [ bflag2 == 1 ];then
                    offset=$( tac $G_TMP_FILE$Item|grep "^*"|awk '{print $9}'|sed -n '1p' )
                else
                    offset=$( cat $G_TMP_FILE$Item|awk '{print $9}'|sed -n '3p' )
                fi

                LOG "[$FUNCNAME]:offset:$offset"
                if [  $( echo "$offset < 7200000"|bc ) -eq 1 ] && [  $( echo "$offset > -7200000"|bc ) -eq 1 ] ;then
                    offset=${offset#-}
                    errResult="Node: $Item||INFO: ntp is normal.||Offset: ${offset}"
                    WRITE_XML_COMMON 0 "$errResult"
                else
                    isPass=1
                    errResult="Node: $Item||INFO: ntp offset($offset) is more than 7200000.ERRCODE(5)"
                    WRITE_XML_ERROR 0 "$errResult"

                    #
                    cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                fi
            fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#235 RPCǷüй©
checkNodeRPC_ReferCnt()
{
     WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local Result=""
    local errResult=""
    local numCnt=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    for Item in $REMOTE_IP_S; do

        set_ifs
        remoteResult=$( remote_exec $Item 30 "cat $RPC_REFER_PROC_FILE" )
        LOG "[$FUNCNAME] [$(date)] $Item result :: ${remoteResult}"

        echo "${remoteResult}" | grep -q "$RPC_REFER_CNT_KEY"
        iRet=$?
        if [ $iRet -eq 0 ]; then
            LOG "[$FUNCNAME] $Item Failed to execute(checkRPC_ReferCnt) command.return($iRet)"
            numCnt=$(echo "${remoteResult}"  | grep -E '[0-9]' | awk 'END {print NR}')
            if [ $numCnt -lt $RPC_REFER_CNT_MAX ]; then
                isPass=4
                errResult="Node:$Item||INFO:The reference count of RPC is $numCnt.ERRCODE(4)"
                WRITE_XML_ERROR 0 "$errResult"
            else
                isPass=1
                errResult="Node:$Item||INFO:The reference count of RPC is $numCnt and exceeds the threshold(20).ERRCODE(5)"
                WRITE_XML_ERROR 0 "$errResult"
            fi

        else
            Result="Node:$Item||INFO:The reference count of RPC is zero"
        fi

        restore_ifs
        WRITE_XML_COMMON 0 "$Result"

    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#236дNOFSǷгʱ
checkWrtNofsTimeout()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    #Զ첽ִҪУipVALID_IP_FILE
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/CheckWrtNofsTimeout > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1; exit 0"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            LOG "[$FUNCNAME]:IP:$Item"
            #Զִн
            remote_exec_checkfini $Item $TASK_ID "Can not get node RPC reference count"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            #Զ100%Ժִнļ
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="[$FUNCNAME]$Item exec(Check if write nofs timeout) failed.iRet($iRet),errno($errno)!"
                LOG "[$FUNCNAME]$Item exec(Check if write nofs timeout) failed.return($iRet),errno($errno)!"
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            dos2unix $G_TMP_FILE$Item

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            set_ifs
            while read line; do
                echo "$line" |grep "WriteNOFSfail"
                if [ $? -eq 0 ]; then
                   isPass=1
                   WRITE_XML_ERROR 0 "Node:$Item||INFO:WriteNOFSfail.ERRCODE(4)"
                fi
                info=$( handle_remote_result "$line" )
                WRITE_XML_COMMON 0 "Node:$Item||INFO:$info"

            done < $G_TMP_FILE$Item
            restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#237 ڵIPǷڽڵ
checkNodeIPLegality()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local Result=""
    local errResult=""

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    for Item in $REMOTE_IP_S; do

        set_ifs
        port_result=$( remote_exec $Item 30 "cat /opt/huawei/snas/etc/frontPortStatus" )
        iRet=$?
        LOG "[$FUNCNAME]node:$Item, port_result:$port_result,iRet:$iRet."
        if [ "$port_result" == "" ] ;then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||INFO:get frontPortStatus faild.return($iRet).ERRCODE(1)"
            restore_ifs
            continue
        fi
        for line in $port_result; do
            netport=$(echo $line|awk -F ":" '{print $1}'|tr -d ' ')
            status=$(echo $line|awk -F ":" '{print $2}'|tr -d ' ')
            if [ "$status" == "DOWN" ];then
               isPass=4
               WRITE_XML_ERROR 0 "Node:$Item||INFO:netport $netport status is DOWN.ERRCODE(4)"
               LOG "[$FUNCNAME]isPass:$isPass,node:$Item,line:$line"
            fi
            WRITE_XML_COMMON 0 "Node:$Item||Netport:$netport||Status:$status"
        done
        restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL

}

#238 BJM̼
checkBJM()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local iRet=0
    local IPNotOk=""
    local workCheck=0

    while true; do
        local back_ip=$( get_backnet_ip )
        if [ "$back_ip" = "" ]; then
            LOG "[$FUNCNAME]:INFO: Can't get local ip.ERRCODE(11)"
            isPass=1
            WRITE_XML_ERROR 0 "Node:-(master)||INFO:Can't get local ip.ERRCODE(11)"
            break
        fi

        #ִmml bjm map 0
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4104 "bjm map 0"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            LOG "[$FUNCNAME]mml_result:$Info"
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to execute MML command(bjm map 0),port(4104).return($iRet).ERRCODE(12)"
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1

        #ȼ̸
        Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Manager" |wc -l )
        if [ "$Info" -ne 1 ];then
            Result="Node:$back_ip(master)||INFO:active Manager number is not ok,process Number is $info.ERRCODE(4)"
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        fi

        Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Server" |wc -l )
        if [ "$Info" -ne 1 ];then
            Result="Node:$back_ip(master)||INFO:active Server number is not ok,process Number is $info.ERRCODE(5)"
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        fi

        Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Worker" |wc -l )
        if [ "$Info" -lt 1 ];then
            Result="Node:$back_ip(master)||INFO:active Worker number is not ok,process Number is $info.ERRCODE(6)"
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        fi

        if [ $isPass -eq 1 ];then
            break
        fi

        #ip
        Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Manager" | cut -d '(' -f 3 | cut -d ')' -f 1 )
        if [ "$Info" == "" ] || [ "$Info" == "0.0.0.0" ];then
            Result="Node:$back_ip(master)||INFO:active Manager status is not ok ,node IP($Info) is 0.0.0.0 or null.ERRCODE(7)"
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        else
            Result="INFO:active Manager status is ok||node:$Info"
            WRITE_XML_COMMON 0 "$Result"
        fi


        Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Server" | cut -d '(' -f 3 | cut -d ')' -f 1 )
        if [ "$Info" == "" ] || [ "$Info" == "0.0.0.0" ];then
            Result="Node:$back_ip(master)||INFO:active Server status is not ok,node IP($Info) is 0.0.0.0 or null.ERRCODE(8)"
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        else
            Result="INFO:active Server status is ok||node:$Info"
            WRITE_XML_COMMON 0 "$Result"
        fi

        Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Worker" | cut -d '(' -f 3 | cut -d ')' -f 1 )
        for i in $Info; do
            if [ "$i" == "" ] || [ "$i" == "0.0.0.0" ];then
                IPNotOk=$IPNotOk" $i"
                isPass=1
                workCheck=1
            else
                Result="INFO:active Worker status is ok||node:$i"
                WRITE_XML_COMMON 0 "$Result"
            fi
        done

        if [ "$workCheck" -eq 1 ]; then
            Result="Node:$back_ip(master)||INFO:active Worker status is not ok,node IP($IPNotOk) is 0.0.0.0 or null.ERRCODE(9)"
            WRITE_XML_ERROR 0 "$Result"
        fi
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}
#239. 鼯Ⱥ״̬
checkSystemInfo_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local servertype=$(cat /opt/huawei/snas/etc/snas.ini |grep ^serviceType |awk -F= '{print $2}')

    while true; do

        local back_ip=$( get_backnet_ip )
        if [ "$back_ip" = "" ]; then
            errResult="INFO: Can't get local ip"
            LOG "[$FUNCNAME]:$errResult"
            WRITE_XML_ERROR 0 "Node:-(master)||INFO:Can't get local ip.ERRCODE(11)"
            isPass=1
            break
        fi

        #ע
        set_ifs

        #ȡĬ
        redundancevalue=$(python $G_MML_FILE_PATH/GetClusterValueFromDepXml "CLUSTER" "PARAM" "redundanceDataCount" )

        #ִmml cm system
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm system"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1

        if [ $? -ne 0 ]; then
            Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            LOG "[$FUNCNAME]:mml_result:${Info}"
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to execute mml command(cm system),port(4016).ERRCODE(12)"
            isPass=1
        else
            dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
            content=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )

            if [ "$content" == "" ];then
                WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Can not get information.ERRCODE(13)"
                isPass=1
            else
                ID=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_ID"|awk -F: '{print $2}' )
                Name=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Name"|awk -F: '{print $2}' )
                Health_Status=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Health_Status"|awk -F: '{print $2}'|awk 'gsub(/^ *| *$/,"")' )
                Running_Status=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Running_Status"|awk -F: '{print $2}'|awk 'gsub(/^ *| *$/,"")' )
                version=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Version"|awk -F: '{print $2}' )

                totalCap=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Capacity"|awk -F: '{print $2}'|egrep -o "[0-9]+" )
                usedCap=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Used_Capacity"|awk -F: '{print $2}'|egrep -o "[0-9]+" )
                Percentage=$( expr 100 \* $usedCap )
                Percentage=$( expr $Percentage / $totalCap )

                echo $Health_Status
                echo $Running_Status
                Health_Status=$( MapHealthStatus $Health_Status )
                Running_Status=$( MapRunningStatus $Running_Status )
                Result="ID:$ID||Name:$Name||Health_Status:$Health_Status||Running_Status:$Running_Status||Version:$version||TotalCapacity(MB):$totalCap||UsedCapacity(MB):$usedCap||Percentage(%):$Percentage||Server_Type:$servertype||DefultRedundance:${redundancevalue}"
                WRITE_XML_COMMON 0 "$Result"
                Running_Status=$(echo ${Running_Status})

                if [ "$Running_Status" == "RUNNING" ] && [ "$Health_Status" == "NORMAL" ];then
                    LOG "[$FUNCNAME]Running_Status($Running_Status);Health_Status($Health_Status) check ok"
                else
                    isPass=1

                    #
                    cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
                    LOG "[$FUNCNAME]Running_Status($Running_Status);Health_Status($Health_Status) check failed"
                    WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Cluster Running_Status($Running_Status) is not RUNNING or Cluster Health_Status($Health_Status) is not NORMAL.ERRCODE(4)"
                    break
                fi
                #Ƶسֵȡ95,ֵ75
                if [ "$servertype" == "surveillance" ];then
                    if [ $Percentage -ge 95 ];then
                       isPass=1
                       WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:servertype($servertype) Cluster Capacity used Percentage($Percentage) exceeds the threshold Percentage(95).ERRCODE(5)"
                       LOG "[$FUNCNAME]servertype=$servertype Percentage=$Percentage"
                    fi
                else
                    if [ $Percentage -ge 75 ];then
                       isPass=1
                       WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:servertype($servertype) Cluster Capacity used Percentage($Percentage) exceeds the threshold Percentage(75).ERRCODE(6)"
                       LOG "[$FUNCNAME]servertype=$servertype Percentage=$Percentage"
                    fi
                fi
            fi
        fi

        restore_ifs
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#240 poor״̬
checkNodePoolStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local iRet=0
    local isPass=0
    local iFail=0
    local iOptimize=0
    local iOpCnt=0
    cat /proc/monc_dsmap > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
    iRet=$?
    if [ $iRet -ne 0 ]; then
        Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
        Result="INFO:exec(cat /proc/monc_dsmap) failed!ERRCODE(4)"
        LOG "[$FUNCNAME]$Item exec(cat /proc/monc_dsmap) failed!errno($iRet),${Info}"
        isPass=1
        WRITE_XML_ERROR 0 "$Result"
    else
        set_ifs
        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        ips=($(grep -w "IpAddr"  $G_REMOTE_TMP_FILE$FUNCNAME| awk -F " " '{print $14}'))
        #IP
        [ -f "/tmp/tmpipinfo" ] && rm -rf "/tmp/tmpipinfo"
        grep -w "IpAddr"  $G_REMOTE_TMP_FILE$FUNCNAME| awk -F " " '{print $14}'|awk -F "." '{print $1 $2 $3 $4}' > /tmp/tmpipinfo 2>&1
        ipnumber=($(cat -n /tmp/tmpipinfo|sort -nk 2|awk '{print $1}'))
        NumArr1=($(grep -n -w "IpAddr"  $G_REMOTE_TMP_FILE$FUNCNAME|awk -F ":" '{print $1}'))
        NumArr2=($(grep -n "\-\-\-\-\-\-\-\-\-\-" $G_REMOTE_TMP_FILE$FUNCNAME|awk -F ":" '{print $1}'))
        for i in ${ipnumber[*]}
        do
            i=$((i-1))
            iOpCnt=0
            distance=$((${NumArr2[i]}-${NumArr1[i]}-1))
            grep -A${distance} -w ${ips[i]} $G_REMOTE_TMP_FILE$FUNCNAME|grep -v ${ips[i]}|grep -v "Pools in Ds" > $G_TMP_FILE$FUNCNAME
            cat $G_TMP_FILE$FUNCNAME |grep "State" |sort -nk 2 > $G_TMP_FILE2$FUNCNAME
            while read line
            do
                ID=$(echo $line |awk -F " " '{print $2}')
                states=$(echo $line |awk -F " " '{print $4}')
                Result="Node:${ips[i]}||ID:$ID||States:${states}"
                WRITE_XML_COMMON 0 "$Result"
                if [ ${states} = "Abnormal(5)" ]; then
                    iOpCnt=$(($iOpCnt + 1))
                    WRITE_XML_ERROR 0 "INFO:Node(${ips[i]}) ID($ID) States ${states} is not Normal.ERRCODE(6)"
                elif [ ${states} != "Normal" ]; then
                    iFail=1
                    WRITE_XML_ERROR 0 "INFO:Node(${ips[i]}) ID($ID) States ${states} is not Normal.ERRCODE(5)"
                fi
            done < $G_TMP_FILE2$FUNCNAME
            if [ $iOpCnt -ne 0 ] && [ $iOpCnt -le 2 ]; then
                iOptimize=1
            elif [ $iOpCnt -gt 2 ]; then
                iFail=1
                WRITE_XML_ERROR 0 "INFO:There are more than 2 disk that States are Abnormal(5).ERRCODE(7)"
            fi
        done
        if [ $iFail -eq 1 ]; then
            isPass=1
        elif [ $iOptimize -eq 1 ]; then
            isPass=4
        else
            isPass=0
        fi
        restore_ifs
    fi
    rm -rf /tmp/tmpipinfo
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#241.ȲƼ汾
checkHpatchOperation()
{
    local ProductName=""
    local ProductVersion=""
    local patchVersion=""
    local Version=""
    local Result=""
    local back_ip=""
    local patchPath="/tmp/InfoInspect/productHotPatch.xml"
    local ProductSvn=""
    local V3R6C00SPC100_base_Svn="90706"
    local V3R6C00SPC200_base_Svn="98356"

    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0

    #ƻ漰Ѳ
    local IsOem=$(ls /opt/huawei/deploy/package/oem)
    if [ ! -z "$IsOem" ];then
        WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
        WRITE_XML_JUDGE 3
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    ProductVersion=$(grep ProductVersion /opt/huawei/deploy/package/version |awk -F= '{print $2}')
    ProductSvn=$(tail -n +2 /opt/huawei/deploy/package/svn.txt)

    if [ "V300R006C00SPC100" == $ProductVersion ] && [ $V3R6C00SPC100_base_Svn != $ProductSvn ];then
        isPass=$(check_pass ${isPass} 1)
        WRITE_XML_ERROR 0 "INFO: the childversion($ProductSvn) is not same with the threshold version($V3R6C00SPC100_base_Svn) when product version is V300R006C00SPC100."
    fi
    if [ "V300R006C00SPC200" == $ProductVersion ] && [ $V3R6C00SPC200_base_Svn != $ProductSvn ];then
        isPass=$(check_pass ${isPass} 1)
        WRITE_XML_ERROR 0 "INFO: the childversion($ProductSvn) is not same with the threshold version($V3R6C00SPC200_base_Svn) when product version is V300R006C00SPC200."
    fi
    if [ ! -f ${patchPath} ];then
        isPass=$(check_pass ${isPass} 4)
        WRITE_XML_ERROR 0 "INFO:Please update or download new tools."
    else
        back_ip=$(get_backnet_ip)
        if [ "X${back_ip}" == "X" ];then
            LOG "[$FUNCNAME]:Failed to get back ip"
            isPass=$(check_pass ${isPass} 1)
            WRITE_XML_ERROR 0 "INFO:Failed to get back_ip."
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return
        fi
        ProductName=$(grep ProductName /opt/huawei/deploy/package/version |awk -F= '{print $2}')
        # productHotPatch.xml ļʱ,1.productVersion patchVersion Ҫ4,2.productVersionproductModel</Ҫո
        patchVersion=$(grep -A4 "${ProductVersion}</productVersion>" ${patchPath} | grep -A2 "${ProductName}</productModel>" |grep "patchVersion" |awk -F '>' '{print $2}' |awk -F '<' '{print $1}')
        Version=$(/opt/huawei/snas/upd/patch_script/cluster_patch.sh "$back_ip" show| grep "Version:" |awk -F, '{print $3}' | awk -F: '{print $2}' 2>/dev/dull)
        Version=${Version:-null}

        LOG "[$FUNCNAME]:ProductName=$ProductName ProductVersion=$ProductVersion"
        Result="Product Version:$ProductVersion||Local Patch Version:$Version"

        #Ƽûеǰ汾ȲҪװ
        if [[ "X${patchVersion}" == "X" ]] ;then
            Result="$Result || Recommended Patch Version:There is no recommended hot patch for the current version in productHotPatch.xml.||ProductChildVersion:$ProductSvn"
            WRITE_XML_COMMON 0 "$Result"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return
        fi

        #δװȲߵƼĲ汾
        if [[ "X$Version" == "Xnull" ]] ;then
            isPass=$(check_pass ${isPass} 4)
        else
            local ver1=$(echo "${patchVersion}" | grep -Po '(?<=SPH)[0-9]+')
            local ver2=$(echo "${Version}" | grep -Po '(?<=SPH)[0-9]+')
            if [[ "$ver1" == "" ]] || [[ "$ver2" == "" ]] ;then
                isPass=$(check_pass ${isPass} 4)
                WRITE_XML_ERROR 0 "INFO:Malformed patch name format error!"
            elif [ $ver1 -gt $ver2 ];then
                isPass=$(check_pass ${isPass} 4)
            fi
        fi

        Result="$Result||Recommended Patch Version:$patchVersion or later||ProductChildVersion:$ProductSvn"
    fi

    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL

}

#243. ϵͳ--
checkQuotaServe()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=1
    local iRet=0
    local quotaServer=""
    local quotaServiceState="--"
    local firstEpoch="--"
    local currentEpoch="--"
    local settingEpoch="--"
    while true; do
        back_ip=$( get_backnet_ip )
        if [ "$back_ip" = "" ];then
            isPass=1
            LOG "[FUNCNAME] Can't to get the backIP."
            WRITE_XML_ERROR 0 "Node:(master)||INFO:Can't get back IP."
            break
        fi
        #ȡڵ洢
        node_service_type=$(egrep '[[]|^'node_service_type'=' /opt/huawei/snas/etc/snas.ini | tr -d '\n' | grep -Po '(?<=[[]'NODE'[]]'node_service_type'=)[0-9]+')
        if [ "${node_service_type}" != "1" ];then    
            isPass=0
            quotaServer="CM master($back_ip) is not dfs node(${node_service_type})."
            LOG "$back_ip is not dfs node. node_service_type :${node_service_type}.Does not involve"
        else
            $G_MML_FILE_PATH/ShowInspectMml $back_ip 988 "mds info show" >$G_REMOTE_TMP_FILE$FUNCNAME 2>&1
            iRet=$?
            if [ "${iRet}" -ne 0 ];then
                Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
                LOG "[FUNCNAME] mml_result : $Info"
                WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to execute command(MmlBatch 988 'mds info show'). Error(${iRet})"
                isPass=1
                break
            else
                dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
                content=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
                if [ "$content" == "" ];then
                    isPass=1
                    WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Get infomation from output(MmlBatch 988 'mds info show') failed."
                else
                    #ȡеqml mdsidquota serverڽڵmdsid;
                    mdsid=$( cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "qml mdsid" | awk -F: '{print $2}' |tr -d " "| dos2unix)
                    quotaServer=$( cat /proc/monc_mdsmap|grep -w "CtrlRank $mdsid"|grep -Poa '(?<= IpAddr ).*' | awk '{print $1}' |tr -d " " | dos2unix )
                    local cnt=30
                    while [ $cnt -gt 0 ]; do
                        #ȡڵ洢
                        node_service_type=$(/opt/huawei/deploy/script/localexec.py cmd $quotaServer 30 false "cat /opt/huawei/snas/etc/snas.ini" | grep "^node_service_type=" | awk -F'=' '{print $2}')
                        if [ "${node_service_type}" != "1" ];then
                            isPass=0
                            quotaServer="$quotaServer is not dfs node(${node_service_type})."
                            LOG "$quotaServer is not dfs node. node_service_type :${node_service_type}.Does not involve"
                        fi
                        /opt/huawei/deploy/script/localexec.py cmd $quotaServer 30 false "$G_MML_FILE_PATH/ShowInspectMml $quotaServer 988 'mds qm srvinfo'" | grep -E "Quota Service State|Current Epoch|Setting Epoch"  >$G_REMOTE_TMP_FILE$FUNCNAME 2>&1
                        iRet=$?
                        if [ "${iRet}" -ne 0 ];then
                            isPass=1
                            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Get infomation by exec(MmlBatch 988 'mds qm srvinfo') from $quotaServer failed."
                            LOG "[FUNCNAME] mml_result : /opt/huawei/deploy/script/localexec.py cmd $quotaServer 30 false \"MmlBatch 988 'mds qm srvinfo'\" ret=$iret"
                            break
                        fi
                        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
                        content=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
                        if [ "$content" == "" ];then
                            isPass=1
                            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Get infomation by exec(MmlBatch 988 'mds qm srvinfo') from $quotaServer failed.mml_result is NULL!"
                            break
                        fi
                        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
                        quotaServiceState=$(cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "Quota Service State" | awk -F"=" '{print $2}' |tr -d " "| dos2unix)
                        currentEpoch=$(cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "Current Epoch" | awk -F"=" '{print $2}' |tr -d " "| dos2unix)
                        settingEpoch=$(cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "Setting Epoch" | awk -F"=" '{print $2}' |tr -d " "| dos2unix)
                        if [ "X${firstEpoch}" = "X--" ];then
                            firstEpoch=$currentEpoch
                        else
                            if [[ "X${quotaServiceState}" =~ "X2" ]];then
                                if [ "X${firstEpoch}" != "X${currentEpoch}" ] || [[ ! "X${settingEpoch}" =~ "X1" ]];then
                                    isPass=0
                                    break
                                fi
                            else
                                isPass=1
                                WRITE_XML_ERROR 0 "Node:$quotaServer||INFO:The quotaServer node has changed! Please inspect again later."
                                break
                            fi
                        fi
                        let "cnt=${cnt}-1"
                        sleep 3
                    done
                fi
            fi
        fi
        break
    done
    Result="quotaServer:${quotaServer}||quotaServiceState:${quotaServiceState}||firstEpoch:${firstEpoch}||currentEpoch:${currentEpoch}||settingEpoch:${settingEpoch}"
    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#331. 𳡾Сü
CheckStripeCfg()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local faildInfo=""
    local errResult=""
    local tmpResult=""
    local isArchive=0
    local dfsIP=""

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    for Item in $REMOTE_IP_S
    do
        local service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" == "1" ];then
            dfsIP="${Item}"
            break
        else
            LOG "[$FUNCNAME][${LINENO}]: $Item is not DFS node."
            continue
        fi
    done
    if [ "X${dfsIP}" = "X" ];then
        isPass=0
        LOG "[$FUNCNAME][${LINENO}]:There is no DFS node."
        WRITE_XML_COMMON 0 "There is no DFS node. No need to inspect."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    while true; do
        #DFSڵִִ /opt/huawei/snas/script/inspect_mml/CheckStripeCfg Զִͬ Խڱļ
        /opt/huawei/deploy/script/localexec.py cmd ${dfsIP} 300 false "$G_MML_FILE_PATH/CheckItems CheckStripeCfg" > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME][${LINENO}]:return($iRet) "
            errResult="Node:${dfsIP}||INFO:Failed to execute command(CheckStripeCfg). Error(${iRet})."
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
            break
        else
            local Msg=$(cat $G_REMOTE_TMP_FILE2$FUNCNAME)
            if [ "$Msg" = "" ];then
                LOG "[$FUNCNAME]:Node: ${dfsIP}||INFO:($fun) get Msg failed"
                WRITE_XML_ERROR 0 "Node:${dfsIP}||INFO:Null output($FUNCNAME)!"
                isPass=$(check_pass $isPass 1)
            else
                set_ifs
                while read line; do
                    info=`handle_remote_result "$line"`
                    if [ $? -ne 0 ]; then
                        WRITE_XML_ERROR 0 "Node:${dfsIP}||${info}"
                        isPass=$(check_pass $isPass 1)
                    else
                        WRITE_XML_COMMON 0 "Node:${dfsIP}||${info}"
                    fi
                done < $G_REMOTE_TMP_FILE2$FUNCNAME
                restore_ifs
                rm -rf $G_REMOTE_TMP_FILE2$FUNCNAME
            fi
        fi
        break
    done

    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#333.  xattrxinfoü
CheckXinfoXattr()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local faildInfo=""
    local errResult=""
    local tmpResult=""
    local isArchive=0
    local dfsIP=""

    # V3R6C00漰Ѳ
    WRITE_XML_COMMON 0 "PASS."
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    for Item in $REMOTE_IP_S
    do
        local service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" == "1" ];then
            dfsIP="${Item}"
            break
        else
            LOG "[$FUNCNAME][${LINENO}]: $Item is not DFS node."
            continue
        fi
    done
    if [ "X${dfsIP}" = "X" ];then
        isPass=0
        LOG "[$FUNCNAME][${LINENO}]:There is no DFS node."
        WRITE_XML_COMMON 0 "There is no DFS node. No need to inspect."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    while true; do
        #DFSڵִִ /opt/huawei/snas/script/inspect_mml/CheckXinfoXattr Զִͬ Խڱļ
        /opt/huawei/deploy/script/localexec.py cmd ${dfsIP} 900 false "$G_MML_FILE_PATH/CheckItems CheckXinfoXattr" > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME][${LINENO}]:return($iRet) "
            errResult="Node:${dfsIP}||INFO:Failed to execute command(CheckXinfoXattr). Error(${iRet})."
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
            break
        else
            local Msg=$(cat $G_REMOTE_TMP_FILE2$FUNCNAME)
            if [ "$Msg" = "" ];then
                LOG "[$FUNCNAME]:Node: ${dfsIP}||INFO:($fun) get Msg failed"
                WRITE_XML_ERROR 0 "Node:${dfsIP}||INFO:Null output($FUNCNAME)!"
                isPass=$(check_pass $isPass 1)
            else
                set_ifs
                while read line; do
                    info=`handle_remote_result "$line"`
                    if [ $? -ne 0 ]; then
                        WRITE_XML_ERROR 0 "Node:${dfsIP}||${info}"
                        isPass=$(check_pass $isPass 4)
                    else
                        WRITE_XML_COMMON 0 "Node:${dfsIP}||${info}"
                    fi
                done < $G_REMOTE_TMP_FILE2$FUNCNAME
                restore_ifs
                rm -rf $G_REMOTE_TMP_FILE2$FUNCNAME
            fi
        fi
        break
    done

    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}
CheckReplicationMasterNodeChannel()
{
    local item="$1"
    local nodeip="$2"

    NodeNum=$( echo "${item}" | awk '{print $5}' )
    ChannelNum=$( echo "${item}" | awk '{print $6}' )
    WRITE_XML_COMMON 0 "Node:${nodeip}||NodeNum:$NodeNum||ChannelNum:$ChannelNum"
    if [ "X$NodeNum" == "X0" ] && [ "X$ChannelNum" == "X0" ]; then
        return 0
    elif [ "X$NodeNum" == "X0" ] && [ "X$ChannelNum" != "X0" ]; then
        WRITE_XML_ERROR 0 "Node:${nodeip}||INFO:NodeNum($NodeNum) is 0 but ChannelNum($ChannelNum) is not 0.ERRCODE(6)"
        return 1
    else
        WRITE_XML_ERROR 0 "Node:${nodeip}||INFO:inter error.ERRCODE(5)"
        return 2
    fi
}

CheckReplicationMasterNodePair()
{
    local item="$1"
    local nodeip="$2"

    NodeNum=$( echo "${item}" | awk '{print $5}' )
    PairCount=$( echo "${item}" | awk '{print $6}' )
    WRITE_XML_COMMON 0 "Node: ${nodeip}|| NodeNum:$NodeNum||PairCount:$PairCount"
    if [ "X$NodeNum" == "X0" ] && [ "X$PairCount" == "X0" ]; then
        return 0
    elif [ "X$NodeNum" == "X0" ] && [ "X$PairCount" != "X0" ]; then
        return 1
    else
        WRITE_XML_ERROR 0 "inter error"
        return 2
    fi
}

function JudgeLicense()
{
    local back_ip=$( get_backnet_ip )
    if [ "$back_ip" = "" ]; then
        LOG "[$FUNCNAME]:INFO: Can't get local ip"
        WRITE_XML_ERROR 0 "Node:-(master)||INFO:Can't get local ip.ERRCODE(11)"
        return 2
    fi

    $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm licensecfg"  >  $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1
    iRet=$?
    if [ $iRet -ne 0 ]; then
        Info=$( cat $G_REMOTE_TMP_FILE2$FUNCNAME )
        LOG "[$FUNCNAME]mml_result:$Info"
        WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to execute mml command(cm licensecfg),port(4016).return($iRet).ERRCODE(12)"
        return 2
    fi

    dos2unix $G_REMOTE_TMP_FILE2$FUNCNAME
    cat $G_REMOTE_TMP_FILE2$FUNCNAME >> $LOG_FILE 2>&1

    javaId=$(cat $G_REMOTE_TMP_FILE2$FUNCNAME|grep InfoReplicator)
    if [ "$javaId" = "" ]; then
        LOG "[$FUNCNAME]:javaId is null"
        WRITE_XML_ERROR 0 "No license resource exists."
        return 0
    fi

    acRunTime=$( echo $javaId |awk '{print $7}' )
    LOG "acRunTime:$acRunTime"
    if [ "${acRunTime}" == "9999-12-31" ];then
        date1=$(date --date "${acRunTime}" +%s)
        return 1
    else
        date1=$( expr $acRunTime \/ 1000 )
    fi
    LOG "date1:$date1"
    date2=$( date )

    t1=$date1
    t2=$( date --date "$date2" +%s )
    LOG "acRunTime:$t1,CurrentTime:$t2"
    if [ $t1 -lt $t2 ]; then
        LOG "$acRunTime < $date2"
        WRITE_XML_COMMON 0 "license resource currently disabled"
        return 0
    elif [ $t1 -eq $t2 ]; then
        LOG "$acRunTime = $date2"
        return 1
    else
        LOG "$acRunTime > $date2"
        return 1
    fi
}


#return:0 pass, 1 fail, 2 error
#set
interCheckReplicationLink()
{
    local NodeIP="$1"
    local tmpFile="$2"
    local ret=0

    sed -i /^shell-init:*/d "${tmpFile}"
    #add filed:NodeStatus NodeResult isMasterNode isCtrlNode
    #original filed:LogicId     ArrayID     LinkCnt     LiveLink     Status    Ref    Compatible
    #original filed:$NodeNum $ChannelNum
    while read item
    do
        nodeStatus=$( echo "${item}" | awk '{print $1}' )
        if [ "X$nodeStatus" != "X0" ]; then
            LOG "[$FUNCNAME] Node: $NodeIP nodeStatus: $nodeStatus."
            ret=0
            break
        fi

        isGetSuccess=$( echo "${item}" | awk '{print $2}' )
        isMasterNode=$( echo "${item}" | awk '{print $3}' )
        isCtrlNode=$( echo "${item}" | awk '{print $4}' )

        #cmd exec fail
        if [ "X$isGetSuccess" = "XFail" ]; then
            WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:excute diagnose cmd failed.ERRCODE(4)"
            ret=2
            break
        fi

        #MasterNode and isCtrlNode=-, display:$NodeNum $ChannelNum
        if  [ "$isMasterNode" == "MasterNode" ]; then
            isFindMasterNode=1
            if [ "$isCtrlNode" == "-" ]; then
                #MasterNode and isCtrlNode=-, display:$NodeNum $ChannelNum
                CheckReplicationMasterNodeChannel "${item}" "${NodeIP}"
                ret=$?
                return $ret
            fi
        fi
        if  [ "X$isCtrlNode" != "XCtrlNode" ]; then
            ret=0
            break
        fi

        isFindCtrlNode=1
        #ctrl link info
        if [ "X$isGetSuccess" = "XEmpty" ]; then
            WRITE_XML_COMMON 0 "INFO:replication link not configure"
            ret=0
            break
        fi

        LogicId=$( echo "${item}" | awk '{print $5}' )
        ArrayID=$( echo "${item}" | awk '{print $6}' )
        LinkCnt=$( echo "${item}" | awk '{print $7}' )
        LiveLink=$( echo "${item}" | awk '{print $8}' )
        Status=$( echo "${item}" | awk '{print $9}' )
        Ref=$( echo "${item}" | awk '{print $10}' )
        Compatible=$( echo "${item}" | awk '{print $11}' )
        WRITE_XML_COMMON 0 "LogicId:$LogicId||ArrayID:$ArrayID||LinkCnt:$LinkCnt||LiveLink:$LiveLink||Status:$Status||Ref:$Ref||Compatible:$Compatible"
        if [ "X$LiveLink" = "X0" ]; then
                LOG "[$FUNCNAME] Node: $NodeIP item: $item."
                WRITE_XML_ERROR 0 "Node:$NodeIP||INFO: LogicId($LogicId) ArrayID($ArrayID), LiveLink($LiveLink) is 0.ERRCODE(7)"
                ret=1

        fi

    done <$tmpFile

    return $ret
}

#245.Check Replication Link
checkReplicationLink()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local tmpFile="/tmp/tmpfile$FUNCNAME"
    local dfsFlag=0
    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    else
        LOG "license resource exists."
    fi

    isFindMasterNode=0
    isFindCtrlNode=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    remote_exec_async_batch $TASK_ID 60 "${G_GET_REPLICATION_INFO} Link > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1
            remote_exec_checkfini $Item $TASK_ID "Can not get information about replication link"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:excute check cmd failed"
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME) failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:remote download file failed"
                isPass=1
                continue
            fi
        done

        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            interCheckReplicationLink "$Item" "$G_TMP_FILE$Item"
            ret=$?
            if [ $ret -ne 0 ]; then
                isPass=1
            fi
    done

    if [ $dfsFlag = 1 ]; then
        if [ $isPass -eq 0 ]; then
            #cluster no rep master node
            if [ $isFindMasterNode -eq 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:-||INFO:Not find master node .ERRCODE(8)"
            #cluster no rep ctrl node
            elif [ $isFindCtrlNode -eq 0 ]; then
                WRITE_XML_COMMON 0 "INFO:replication link not configure"
            fi
        fi
    fi
    LOG "[$FUNCNAME] pass:$isPass."

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}



interCheckReplicationProcess()
{
    local NodeIP="$1"
    local tmpFile="$2"
    local ret=0

    sed -i /^shell-init:*/d "${tmpFile}"
    #isGetSuccess isRepZoneNode status repPid
    if [  $( cat $tmpFile | wc -l ) -ne 1 ]; then
        WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:get replication process information error.ERRCODE(4)"
        tmpinfo=$(cat $tmpFile)
        LOG "[$FUNCNAME] $tmpFile unexpect.NodeIP=$NodeIP,tmpinfo=$tmpinfo"
        return 1
    fi
        item=$( cat $tmpFile )
        status=$( echo "${item}" | awk '{print $1}' )
        repPid=$( echo "${item}" | awk '{print $2}' )
        if [ $status -eq 0 ]; then
            if [ "X$repPid" == "X-" ]; then
                LOG "[$FUNCNAME] Failed to get Replication Process when device status is $status."
                WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:Status is Normal but there is no running RepProcess($repPid).ERRCODE(5)"
                return 1
            else
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Normal||RepProcess:Running"
                return 0
            fi
        elif [ $status -eq 1 ]; then
            if [ "$repPid" != "-" ]; then
                LOG "[$FUNCNAME] Get Replication Process when device status is $status."
                WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:Status is Disabled but RepProcess($repPid) is Running.ERRCODE(6)"
                return 1
            else
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Disabled||RepProcess:Not Running"
                return 0
            fi
        elif [ $status -eq 2 ]; then
            if [ "$repPid" != "-" ]; then
                LOG "[$FUNCNAME] Get Replication Process when device status is $status."
                WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:Status is Frozen but RepProcess($repPid) is Running.ERRCODE(7)"
                return 1
            else
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Frozen||RepProcess:Not Running"
                return 0
            fi
        elif [ $status -eq 3 ]; then
            if [ "$repPid" != "-" ]; then
                LOG "[$FUNCNAME] Get Replication Process when device status is $status."
                WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:Status is Shutdown but RepProcess($repPid) is Running.ERRCODE(8)"
                return 1
            else
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Shutdown||RepProcess:Not Running"
                return 0
            fi
        elif [ $status -eq 4 ]; then
            if [ "$repPid" != "-" ]; then
                LOG "[$FUNCNAME] Get Replication Process when device status is $status."
                WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:Status is Deleted but RepProcess($repPid) is Running.ERRCODE(9)"
                return 1
            else
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Deleted||RepProcess:Not Running"
                return 0
            fi
        elif [ $status -eq 5 ]; then
            if [ "$repPid" != "-" ]; then
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Restart||RepProcess:Running"
            else
                WRITE_XML_COMMON 0 "Node:$NodeIP||Status:Restart||RepProcess:Not Running"
            fi
            return 0
        else
            LOG "[$FUNCNAME] Get Replication Process when device status is $status."
            if [ "$repPid" != "-" ]; then
                WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:RepProcess($repPid),Status is Unknown.ERRCODE(10)"
            else
                WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:RepProcess($repPid),Status is Unknown .ERRCODE(10)"
            fi
            return 1
        fi

    return 0
}

#246 Check Replication Process
checkReplicationProcess()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    local tmpFile="/tmp/tmpfile$FUNCNAME"

    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    else
        LOG "license resource exists."
    fi

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    remote_exec_async_batch $TASK_ID 60 "${G_GET_REPLICATION_INFO} Process > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1

            remote_exec_checkfini $Item $TASK_ID "Can not get information about replication process"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:excute check cmd failed"
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME) failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:remote download file failed"
                isPass=1
                continue
            fi
        done

        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            interCheckReplicationProcess "$Item" "$G_TMP_FILE$Item"
            ret=$?
            if [ $ret -ne 0 ]; then
                isPass=1
            fi
    done

    LOG "[$FUNCNAME] pass:$isPass."

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

interCheckReplicationZoneStatus()
{
    local NodeIP="$1"
    local tmpFile="$2"
    local ret=0

    sed -i /^shell-init:*/d "${tmpFile}"
    #add filed:NodeStatus NodeResult isMasterNode isCtrlNode
    #original filed:NodeNum ChannelNum
    while read item
    do
        nodeStatus=$( echo "${item}" | awk '{print $1}' )
        if [ "X$nodeStatus" != "X0" ]; then
            LOG "[$FUNCNAME] Node: $NodeIP nodeStatus: $nodeStatus."
            ret=0
            break
        fi

        isGetSuccess=$( echo "${item}" | awk '{print $2}' )
        isMasterNode=$( echo "${item}" | awk '{print $3}' )
        isCtrlNode=$( echo "${item}" | awk '{print $4}' )

        #cmd exec fail
        if [ "X$isGetSuccess" = "XFail" ]; then
            WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:excute diagnose cmd failed.ERRCODE(4)"
            ret=2
            break
        fi

        #MasterNode and isCtrlNode=-, display:$NodeNum $ChannelNum
        if  [ "$isMasterNode" == "MasterNode" ]; then
            isFindMasterNode=1
            if [ "$isCtrlNode" == "-" ]; then
                #MasterNode and isCtrlNode=-, display:$NodeNum $ChannelNum
                CheckReplicationMasterNodeChannel "${item}" "${NodeIP}"
                ret=$?
                return $ret
            fi
        fi
        if  [ "X$isCtrlNode" != "XCtrlNode" ]; then
            ret=0
            break
        fi

        isFindCtrlNode=1
        #ctrl link info
        if [ "X$isGetSuccess" = "XEmpty" ]; then
            WRITE_XML_COMMON 0 "INFO:replication not configure"
            ret=0
            break
        fi

        NodeNum=$( echo "${item}" | awk '{print $5}' )
        ChannelNum=$( echo "${item}" | awk '{print $6}' )
        if [ "X$NodeNum" = "X0" ] && [ "X$ChannelNum" != "X0" ]; then
            LOG "[$FUNCNAME], NodeNum($NodeNum), ChannelNum($ChannelNum)"
            WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:NodeNum($NodeNum) is 0 and ChannelNum($ChannelNum) is not 0.ERRCODE(6)"
            ret=1
        fi
        WRITE_XML_COMMON 0 "NodeNum:$NodeNum||ChannelNum:$ChannelNum"

    done <$tmpFile

    return $ret
}

#247.Check ReplicationZone Status
checkReplicationZoneStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local tmpFile="/tmp/tmpfile$FUNCNAME"
    local dfsFlag=0
    local sFlag=0

    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    else
        LOG "license resource exists."
    fi

    isFindMasterNode=0
    isFindCtrlNode=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    remote_exec_async_batch $TASK_ID 60 "${G_GET_REPLICATION_INFO} ZoneStatus > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                sFlag=1
                continue
            fi

            dfsFlag=1
            remote_exec_checkfini $Item $TASK_ID "Can not get information about replication zone status"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:excute check cmd failed"
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME) failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:remote download file failed"
                isPass=1
                continue
            fi
        done

        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            interCheckReplicationZoneStatus "$Item" "$G_TMP_FILE$Item"
            ret=$?
            if [ $ret -ne 0 ]; then
                isPass=1
            fi
    done

    if [ $dfsFlag = 1 ];then
        if [ $isPass -eq 0 ]; then
            #cluster no rep master node
            if [ $isFindMasterNode -eq 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:-||INFO:Not find master node.ERRCODE(7)"
            #cluster no rep ctrl node
            elif [ $isFindCtrlNode -eq 0 ]; then
                WRITE_XML_COMMON 0 "INFO:replication not configure"
            fi
        fi
    fi
    LOG "[$FUNCNAME] pass:$isPass."

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

interCheckReplicationPairStatus()
{
    local NodeIP="$1"
    local tmpFile="$2"
    local ret=0
    local isPass=0

    sed -i /^shell-init:*/d "${tmpFile}"
    while read item
    do
        nodeStatus=$( echo "${item}" | awk '{print $1}' )
        if [ "X$nodeStatus" != "X0" ]; then
            LOG "[$FUNCNAME] Node: $NodeIP nodeStatus: $nodeStatus."
            break
        fi

        isGetSuccess=$( echo "${item}" | awk '{print $2}' )
        isMasterNode=$( echo "${item}" | awk '{print $3}' )
        isCtrlNode=$( echo "${item}" | awk '{print $4}' )

        #cmd exec fail
        if [ "X$isGetSuccess" = "XFail" ]; then
            WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:excute diagnose cmd failed.ERRCODE(4)"
            isPass=$(check_pass ${isPass} 1)
            break
        fi

        if  [ "$isMasterNode" == "MasterNode" ]; then
            isFindMasterNode=1
            if [ "$isCtrlNode" == "-" ]; then
                #MasterNode and isCtrlNode=-, display:$NodeNum $PairCount
                CheckReplicationMasterNodePair "${item}" "${NodeIP}"
                ret=$?
                if [ $ret -ne 0 ]; then
                    isPass=$(check_pass ${isPass} 1)
                fi
                return $isPass
            fi
        elif [ "$isMasterNode" == "-" ]; then
            #MasterNode=- and isCtrlNode=CtrlNode, display ERR $NF
            tmpInfo=`echo "${item}" | awk -F" CtrlNode " '{print $2}'`
            WRITE_XML_ERROR 0 "Node:${NodeIP}||INFO:${tmpInfo}"
            isPass=$(check_pass ${isPass} 4)
            continue
        fi
        if  [ "X$isCtrlNode" != "XCtrlNode" ]; then
            break
        fi

        isFindCtrlNode=1
        #ctrl link info
        if [ "X$isGetSuccess" = "XEmpty" ]; then
            WRITE_XML_COMMON 0 "INFO:Replication pair is not configured."
            break
        fi

        PairId=$( echo "${item}" | awk '{print $5}' )
        RunningStatus=$( echo "${item}" | awk '{print $6}' )
        HealthStatus=$( echo "${item}" | awk '{print $7}' )
        if [ "$RunningStatus" == "Interrupted" ] || [ "$RunningStatus" == "ToBeRecoverd" ] || [ "$RunningStatus" == "Invalid" ]; then
            LOG "[$FUNCNAME] NodeIP($NodeIP), PairId($PairId), RunningStatus($RunningStatus), HealthStatus($HealthStatus)."
            isPass=$(check_pass ${isPass} 1)
            WRITE_XML_ERROR 0 "Node:$NodeIP||INFO:PairId($PairId),HealthStatus($HealthStatus),RunningStatus($RunningStatus) is Interrupted or ToBeRecoverd or Invalid.ERRCODE(7)"
            ret=1
        fi
        WRITE_XML_COMMON 0 "PairId:$PairId||RunningStatus:$RunningStatus||HealthStatus:$HealthStatus"
    done <$tmpFile

    return $isPass
}

#248 Check Replication Pair Status
checkReplicationPairStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local tmpFile="/tmp/tmpfile$FUNCNAME"
    local dfsFlag=0


    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    else
        LOG "license resource exists."
    fi

    isFindMasterNode=0
    isFindCtrlNode=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    remote_exec_async_batch $TASK_ID 60 "${G_GET_REPLICATION_INFO} PairStatus > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do

        #checkڵ
        local service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
            continue
        fi

        dfsFlag=1
            remote_exec_checkfini $Item $TASK_ID "Can not get information about replication pair status"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:excute check cmd failed"
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME) failed."
                isPass=1
                continue
            fi
        done

        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            interCheckReplicationPairStatus "$Item" "$G_TMP_FILE$Item"
            ret=$?
            isPass=$(check_pass ${isPass} $ret)
    done

    if [ $dfsFlag = 1 ];then
        if [ $isPass -eq 0 ]; then
            #cluster no rep master node
            if [ $isFindMasterNode -eq 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Error:Not find master node.ERRCODE(8)"
            fi
        fi
    fi
    LOG "[$FUNCNAME] pass:$isPass."

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#249.Check Replication Version
checkReplicationVersion()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    local tmpFile="/tmp/tmpfile$FUNCNAME"

    JudgeLicense
    if [ $? -eq 0 ]; then
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    elif [ $? -eq 2 ]; then
        isPass=1
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    else
        LOG "license resource exists."
    fi

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
       remote_exec_async_batch $TASK_ID 60 "${G_GET_REPLICATION_INFO} Version > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?
    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            dfsFlag=1

            remote_exec_checkfini $Item $TASK_ID "Can not get information about replication version"
            iRet=$?
            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:excute check cmd failed"
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME]:Node:$Item||INFO: remote download file($G_REMOTE_TMP_FILE$FUNCNAME) failed."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:remote download file failed"
                isPass=1
                continue
            fi
        done

        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            sed -i /^shell-init:*/d "${G_TMP_FILE}""${Item}"
            nodeStatus=$( cat $G_TMP_FILE$Item | awk '{printf $1}' )
            if [ "X$nodeStatus" != "X0" ]; then
                LOG "[$FUNCNAME] Node: $NodeIP nodeStatus: $nodeStatus."
                continue
            fi

            isGetSuccess=$( cat $G_TMP_FILE$Item | awk '{printf $2}' )
            if [ "X$isGetSuccess" = "XFail" ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:excute diagnose cmd failed.ERRCODE(4)"
                continue
            fi
            repVersion=$( cat $G_TMP_FILE$Item | awk '{printf $4}' )
            WRITE_XML_COMMON 0 "Node:$Item||RepVersion:$repVersion"
            if [ -z "$firstVersionInfo" ]; then
                firstVersionInfo="$repVersion"
                FirstNode="$Item"
            else
                if [ "X$firstVersionInfo" != "X$repVersion" ]; then
                    isPass=1
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:RepVersion($repVersion) is not consistent with the firstVersionInfo($firstVersionInfo) of node($FirstNode).ERRCODE(5)"
                fi
            fi
    done

    LOG "[$FUNCNAME] pass:$isPass."

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#251.Check TLV black list
checkTLVBlacklist()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    local service_type=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        #checkڵͣDFSִ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            errResult="Does not involve"
            WRITE_XML_COMMON 0 "Node:$Item||INFO:$errResult"
            continue
        fi
        remote_exec_async $Item $TASK_ID 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 988 'nvshow black' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||INFO: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command(nvshow black),port(988).return($iRet),ERRCODE(1)"
            isPass=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #checkڵ
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            dfsFlag=1

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get metadata black list"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            if [ $dfsFlag = 0 ]; then
                continue
            fi

            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                continue
            fi

            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            set_ifs
            dos2unix $G_TMP_FILE$Item
            cat  $G_TMP_FILE$Item >> $LOG_FILE 2>&1

            info1=$(cat $G_TMP_FILE$Item |grep -A1 g_astNv_MetaBlack)
            if [ -z "${info1}" ]; then
                LOG "[$FUNCNAME] Node: $Item||INFO: can not get key word g_astNv_MetaBlack"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:can not get key word g_astNv_MetaBlack.ERRCODE(4)"
                isPass=1
            fi
            info2=$(echo "${info1}" |grep -v g_astNv_MetaBlack)
            if [ -z "${info2}" ]; then #Ѳͨ
                WRITE_XML_COMMON 0 "Node:$Item||INFO:There are no metadata black lists in the node."
            else                       #Ѳ첻ͨ
                LOG "[$FUNCNAME] Node: $Item||INFO: There are some metadata black lists in the node."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:There are some metadata black lists in the node.ERRCODE(5)"
                isPass=1
            fi

            restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#252/401.Check data migration task
checkDataMigrationTask()
{
    WRITE_XML_SUBCMD_HEADER $1
    local checkScenario=$2
    local upgradeScenario=4
    local TASK_ID=0
    local isPass=0
    local connectCount=0
    REMOTE_IP_S=$(cat /proc/monc_jmmap | grep 'active manager ip' | awk -F'(' '{print $2}' | awk -F')' '{print $1}')

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        for time in ${RepeatTimes[*]}; do
        pingResult=$(ping -q -c 1 $Item |grep "1 received" |wc -l)
            local iRet=$?
            if [ $iRet -ne 0 ]; then
                sleep 10
            else
                break
            fi
        done
        if [ "1" == "$pingResult" ];then
            connectCount=1
            #manager get job 100 1100ʾǨ1ʾǰе
            #manager get job 109 1109ʾһǨ1ʾǰе
            remote_exec_async $Item $TASK_ID 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4100 'manager get job 100 1' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1;sleep 3;$G_MML_FILE_PATH/ShowInspectMml $Item 4100 'manager get job 109 1' >> $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute mml command(manager get job 100 1),port(4100),return($iRet)"
                isPass=1
            else
                echo -n "$Item " >> ${VALID_IP_FILE}
            fi

            break
        fi
    done

    ValidIP=$( cat ${VALID_IP_FILE} )

    if [ "${connectCount}" == "0" ];then
        LOG "[$FUNCNAME] Node: $Item||Error:Failed to connect bjm master.ERRCODE(4)"
        WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to connect bjm master.ERRCODE(4)"
        isPass=1
    fi

    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get bjm job information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                echo "FlagDownfail" >> $G_TMP_FILE$Item 2>&1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        FlagDownfail=$( cat $G_TMP_FILE$Item |grep FlagDownfail )
        if [ "$FlagDownfail" != "" ];then
            LOG "[$FUNCNAME]:IP:$Item,Down file fail"
            continue
        fi

        dos2unix $G_TMP_FILE$Item

        cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

        cat $G_TMP_FILE$Item |grep "data_migration"
        iRet=$?
        if [ $iRet -ne 0 ];then
            LOG "[$FUNCNAME]: There is no data-migration task running in cluster system."
            WRITE_XML_COMMON 0 "There is no data-migration task running in cluster system."
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return
        elif [ ${checkScenario} -eq ${upgradeScenario} ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Data-migration tasks exist."
        fi

        while read line; do
            echo "$line" |grep "data_migration"
            if [ $? -ne 0 ]; then
                continue
            fi
            local task_id=$(echo "$line"|awk -F " " '{print $1}' | awk -F "(" '{print $2}' |awk -F ")" '{print $1}')
            local task_name=$(echo "$line"|awk -F " " '{print $2}' | awk -F "(" '{print $2}' |awk -F ")" '{print $1}')
            local startTime=$(echo "$line"|awk -F " " '{print $6}' | awk -F "(" '{print $2}' |awk -F ")" '{print $1}')
            local tmpstartTime=$(date -d @${startTime} "+%Y-%m-%d %H:%M:%S")
            local endTime=$(echo "$line"|awk -F " " '{print $7}' | awk -F "(" '{print $2}' |awk -F ")" '{print $1}')
            if [ "$endTime" = "0" ];then
                tmpendTime="--"
            else
                tmpendTime=$(date -d @${endTime} "+%Y-%m-%d %H:%M:%S")
            fi
            local usedTime=$(echo "$line"|awk -F " " '{print $8}')
            local usedTime2=$(echo "$usedTime"|awk -F "(" '{print $2}'|awk -F ")" '{print $1}')
            if [ ${checkScenario} -ne ${upgradeScenario} -a $usedTime2 -ge 604800 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:$task_name(TaskID:$task_id) has been executed for more than 7 days."
            fi
            WRITE_XML_COMMON 0 "Active_Manager:$Item ||TaskID:$task_id||Task_Name:$task_name||Start_Time:${tmpstartTime}||Finish_Time:${tmpendTime}||Used_Time:$usedTime2"
        done < $G_TMP_FILE$Item

    done
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#254 󴢴״̬
function checkObjsServiceStat()
{
    WRITE_XML_SUBCMD_HEADER $1

    local Result=""
    local errResult=""
    local isPass=0
    local TASK_ID=0
    local hostname=""
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch $TASK_ID 90 "$G_MML_FILE_PATH/ShowObjsProcess > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ 0 -ne $? ];then
        isPass=1
    fi

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            LOG "[$FUNCNAME]:IP:$Item"
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get Process information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="IP: $Item||Error: exec (ShowObjsProcess) failed.return($iRet),errno($errno)!||${errResult}"
                LOG "[$FUNCNAME]$Item exec(get Object Storage progress) failed.return($iRet),errno($errno)!"
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi
            hostname=$(get_node_hostname_from_db "${Item}")
            dos2unix $G_TMP_FILE$Item

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            set_ifs
            while read line; do
                info=$( handle_remote_result "$line" )
                if [ $? -ne 0 ]; then
                   isPass=1
                   WRITE_XML_ERROR 0  "Node:$Item||INFO:$info"
                else
                    if [ "$(echo $info|grep -w "Does not involve")" = "" ];then
                        WRITE_XML_COMMON 0 "nodeName:$hostname||backIP:$Item||$info"
                    else
                        WRITE_XML_ERROR 0  "Node:$Item||INFO:$info"
                    fi
                fi

            done < $G_TMP_FILE$Item
            restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#256.״̬
checkAvServerStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local totalline=0
    local numCnt=1
    local switch=0
    local avstatus=""
    local avtmpstatus=""
    local isDfs=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    for Item in $REMOTE_IP_S
    do
        #1.checkڵ
        local service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "[$FUNCNAME]: $Item is not DFS node."
            continue
        fi
        isDfs=1
        break
    done

    if [ $isDfs -ne 0 ];then
        set_ifs
        while true; do
            local back_ip=$( get_backnet_ip )
            if [ "$back_ip" = "" ]; then
                LOG "[$FUNCNAME]:INFO: Can't get local ip"
                isPass=1
                WRITE_XML_ERROR 0 "Node:-(master)||INFO:Can't get local ip.ERRCODE(11)"
                break
            fi
            #1.ѯ״̬
            $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm avconfig show"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "[$FUNCNAME] get antivirus config info failed."
                WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to excute MML command(cm avconfig show),port(4016).return($iRet).ERRCODE(12)"
                break
            else
                #2.жϷ״̬رգѲɹ
                switch=$( cat $G_REMOTE_TMP_FILE$FUNCNAME | grep 'enableScan' | awk -F ':' '{print $2}' | awk 'gsub(/\r/,"")1' | awk 'gsub(/ /,"")1' )
                if [ $switch == 1 ]; then
                    #3.ش򿪣ȡ״̬
                    $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm avserver show" >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
                    iRet=$?
                    if [ $iRet -ne 0 ];then
                        isPass=1
                        LOG "[$FUNCNAME] get antivirus server info failed."
                        WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to excute MML command(cm avserver show),port(4016).return($iRet).ERRCODE(12)"
                        break
                    else
                        cat /var/log/antivirus_servers  | grep -E 'runningStatus|serverIPAddr' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
                        #4.û÷Ѳʧ
                        iRet=$?
                        if [ $iRet -ne 0 ]; then
                            isPass=1
                            LOG "[$FUNCNAME] antivirus server is not configed."
                            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Antivirus server Not Configured.ERRCODE(4)"
                            break
                        else
                            totalline=$( cat $G_REMOTE_TMP_FILE$FUNCNAME | wc -l )
                        fi
                    fi
                    #5.״̬йϣѲʧ
                    #6.״̬Ѳɹ
                    while [ $numCnt -le $totalline ]; do
                        avtmpstatus=$( sed -n "${numCnt}p" $G_REMOTE_TMP_FILE$FUNCNAME | awk -F ':' '{print $2}' | awk 'gsub(/\r/,"")1' | awk 'gsub(/ /,"")1' )
                        if [ $avtmpstatus == "35" ]; then
                            isPass=1
                            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Antivirus server status is 35(AV_SERVER_STATUS_FAULT).ERRCODE(5)"
                            LOG "[$FUNCNAME]antivirus server fault."
                        fi
                        avstatus=$( sed -n "${numCnt}p" $G_REMOTE_TMP_FILE$FUNCNAME | awk -F ':' '{print $2}' | awk 'gsub(/\r/,"")1' | awk 'gsub(/ /,"")1' )
                        if [ $avstatus == "35" ]; then
                            avstatus="AV_SERVER_STATUS_FAULT"
                        elif  [ $avstatus == "1" ]; then
                            avstatus="AV_SERVER_STATUS_NORMAL"
                        else [ $avstatus == "89" ]
                            avstatus="AV_SERVER_STATUS_BUSY"
                        fi
                        serverIp=$( sed -n "$((numCnt+1))p" $G_REMOTE_TMP_FILE$FUNCNAME | awk '{print $2}' | awk 'gsub(/\r/,"")1' | awk 'gsub(/ /,"")1' )
                        LOG "AntivirusServer:${serverIp}||Status:${avstatus}"
                        WRITE_XML_COMMON 0 "Server:${serverIp}||Status:${avstatus}"
                        numCnt=$((numCnt+2))
                    done
                    break
                else

                    WRITE_XML_COMMON 0 "The antivirus service is closed."
                    break
                fi
            fi
        done
        restore_ifs
    else
        WRITE_XML_COMMON 0 "Does not involve."
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#257.鼯ȺǷ
function checkMdsSubTreeNum()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local SumNum=0
    local SubtreeNum=0
    local TASK_ID=0
    local isDfs=0
    local MaxSubtreeNum=80000

    local MDSMaster=""
    local Result=""
    MDSFILE="/var/log/snas.mds.cache.log"
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    remote_exec_async_batch_mml $TASK_ID 30 GetMdsSubtreeInfo $FUNCNAME
    isPass=$?

    sleep 5
    ValidIP=$( cat ${VALID_IP_FILE} )
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            #checkڵ
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "[$FUNCNAME]: $Item is not DFS node."
                continue
            fi
            isDfs=1
            remote_exec_checkfini $Item $TASK_ID "Can not get mds info show information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                continue
            fi

            #Ϊ100%֮ļأн
            remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                isPass=1
                continue
            fi

            MDSMaster=$( cat $G_TMP_FILE$Item | grep "root mds ip"|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            if [ "$MDSMaster" == "" ];then
                isPass=1
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                errResult="Node:$Item||INFO:Failed to get MDS master(root mds ip).ERRCODE(4)"
                WRITE_XML_ERROR 0 "${errResult}"
                break
            fi

            #16ƵַʽתΪipv4͵ַ
            mdsMastertmp=$MDSMaster
            mdsMasterIP=$( hextoip "${mdsMastertmp}" )
            LOG "[$FUNCNAME]mdsMasterIP:$mdsMasterIP"
            if [ "mdsMasterIP" == "" ];then
                LOG "[$FUNCNAME]:Failed to execute command(mds info show),get masterIp($mdsMastertmp) err."
                errResult="Failed to execute command(mds info show),get masterIp(${mdsMastertmp}) err.ERRCODE(5)"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                break
            fi

            #MDSִнű, ִнűGetMdsSubtreeNum
            remote_exec $mdsMasterIP 60 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds gst showtree 0x400 0' > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
            iRet=$?
            if [ $iRet -ne 0 ];then
                #Իȡ2ip
                MDSMaster=$( cat $G_TMP_FILE$Item | grep "root mds 2nd ip"|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
                if [ "$MDSMaster" == "" ];then
                    isPass=1
                    cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                    errResult="Failed to get MDS master(root mds 2nd ip).ERRCODE(4)"
                    WRITE_XML_ERROR 0 "Node:$mdsMasterIP||INFO:${errResult}"
                    break
                fi

                #16ƵַʽתΪipv4͵ַ
                mdsMastertmp=$MDSMaster
                mdsMasterIP=$( hextoip "${mdsMastertmp}" )
                LOG "[$FUNCNAME]mdsMasterIP:$mdsMasterIP"
                if [ "mdsMasterIP" = "0" ];then
                    LOG "[$FUNCNAME]:Failed to execute command(mds info show),get masterIp($mdsMastertmp) err."
                    errResult="Failed to execute command(mds info show),get masterIp(${mdsMastertmp}) err.ERRCODE(5)"
                    WRITE_XML_ERROR 0 "Node:$mdsMasterIP||INFO:${errResult}"
                    isPass=1
                    break;
                fi

                #MDSִнű, ִнűGetMdsSubtreeNum
                remote_exec $mdsMasterIP 60 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds gst showtree 0x400 0' > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
                iRet=$?
            fi

            if [ $iRet -ne 0 ];then
                errResult="Failed to execute mml(mds gst showtree 0x400 0) on $mdsMasterIP.return($iRet).ERRCODE(1)"
                LOG "[$FUNCNAME]:Failed to execute mml(mds gst showtree 0x400 0) on $mdsMasterIP.return($iRet).ERRCODE(1)"
                WRITE_XML_ERROR 0 "Node:$mdsMasterIP||INFO:${errResult}"
                isPass=1
                break
            fi

            #
            remote_download_sync $mdsMasterIP $G_TMP_FILE $MDSFILE
            iRet=$?
            if [ $iRet -ne 0 ];then
                Result="ERR:download $MDSFILE from $mdsMasterIP fail"
                LOG "[$FUNCNAME]download $MDSFILE from $mdsMasterIP fail"
                isPass=1
                break
            fi
            #ͳƼȺ
            MdsInfo=$( cat /proc/monc_mdsmap |grep -w "Rank" )
            set_ifs
            for line in $MdsInfo;do
                Mdsidx=$( echo $line |awk '{print $4}' )
                IpAddr=$( echo $line |awk '{print $8}' )
                if [ "$mdsMasterIP" == "$IpAddr" ];then
                    Role=Leader
                else
                    Role=Member
                fi
                #ͳƼȺ
                SubtreeNum=$( cat $G_TMP_FILE | grep "InoPop" | grep -v "I(400)" | grep "A($Mdsidx)" | wc -l )
                SumNum=$((SumNum+SubtreeNum))

                WRITE_XML_COMMON 0 "Node:$IpAddr||Mdsidx:$Mdsidx||Role:$Role||Subtree_num:$SubtreeNum"
                LOG "[$FUNCNAME]Node:$IpAddr,Mdsidx:$Mdsidx,Role:$Role,Subtree_num:$SubtreeNum,SumNum=$SumNum"
            done
            restore_ifs
            if [ $SumNum -ge $MaxSubtreeNum ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$mdsMasterIP||INFO:There are $SubtreeNum subtrees in cluster, exceed $MaxSubtreeNum.ERRCODE(6)"
                LOG "[$FUNCNAME]:There are $SubtreeNum subtrees in cluster, exceed $MaxSubtreeNum."
            fi

            >${VALID_IP_FILE}
            break
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    if [ "$MDSMaster" == "" ];then
        if [ $isDfs -eq 0 ];then
            isPass=0
            Result="There are not DFS nodes in the cluster environment."
        fi
    fi

    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass

    WRITE_XML_SUBCMD_TAIL
}

#258.rpcǷȷ
checkRpcBindCore()
{
    WRITE_XML_SUBCMD_HEADER $1
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    isPass=0

    for Item in $REMOTE_IP_S; do

        set_ifs
        log_result=$( remote_exec $Item 30 "$G_MML_FILE_PATH/CheckRpcBindCore" )
        iRet=$?
        LOG "[$FUNCNAME]node:$Item, log_result:$log_result,iRet:$iRet."

        is_correct=$( echo $log_result |grep 'pass!' )

        if [ -z "$is_correct" ]
        then
            isPass=1
            Result="Node:$Item||RESULT: $log_result"
            WRITE_XML_ERROR 0 "$Result"
        else
            Result="Node:$Item||RESULT: $log_result"
            WRITE_XML_COMMON 0 "$Result"
        fi
        restore_ifs

    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#260.check ad connection
checkADdomainControllerStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0
    local dcUnAvlCnt=0
    local nodecnt=0

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    remote_exec_async_batch $TASK_ID 30 "$G_MML_FILE_PATH/nas_checkADdomainControllerStatus > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    fifo_start
    while [ ! -z "${ValidIP}" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get Node NAS Connnect information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="IP: $Item||Error: exec (ShowNasConnInfo) failed.return($iRet),errno($errno)!||${errResult}"
                LOG "[$FUNCNAME]$Item exec(ShowNasConnInfo progress) failed.return($iRet),errno($errno)!"
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish
    for Item in $ValidIPResult; do
            dos2unix $G_TMP_FILE$Item
            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" == "" ];then
                continue
            fi

            #
            cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
            nodecnt=$[ $nodecnt+1 ]
            set_ifs

            while read line; do
                info=$( handle_remote_result "${line}" )
                if [ $? -ne 0 ]; then
                    isPass=1
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:$info"
                else
                    check_result=$( echo ${line} | grep "DOMAIN AVAILABLE:no" | wc -l )
                    if [ ${check_result} -eq 1 ]; then
                        dcUnAvlCnt=$[ $dcUnAvlCnt+1 ]
                    fi
                    WRITE_XML_COMMON 0 "Node:$Item||$info"
                fi
            done < $G_TMP_FILE$Item
            restore_ifs
    done

    if [ $dcUnAvlCnt -ne 0 ]; then
        isPass=1
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#261. ʱ
function checkDelayReimportDisk()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0
    local ret=0

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    #Զ첽ִ
    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        remote_exec_async $Item $TASK_ID 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 988 'pma delay-reimport' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command(pma delay-reimport),port(988).return($iRet).ERRCODE(1)"
            isPass=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do
            LOG "[$FUNCNAME]:IP:$Item"
            #Զִн
            remote_exec_checkfini $Item $TASK_ID "Can not get delay re-import disk"
            iRet=$?
            if [ $iRet -eq 0 ]; then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ]; then
                isPass=1
                continue
            fi

            #Զ100%Ժִнļ
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ]; then
                errResult="[$FUNCNAME]$Item exec(get delay re-import disk) failed.return($iRet),errno($errno)!"
                LOG "[$FUNCNAME]$Item exec(get delay re-import disk) failed.return($iRet),errno($errno)!"
                isPass=2
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
            fifoContext=$( cat $G_TMP_FILE$Item )
            if [ "$fifoContext" = "" ];then
                continue
            fi

            dos2unix $G_TMP_FILE$Item
            sed -i 's/\x1B\[0;[3-4][0-9]m//g' $G_TMP_FILE$Item
            while read line
            do
                tmp=$( echo ${line} | grep 'pool name'  )
                if [ "${tmp}" != "" ]; then
                    isPass=1
                    Result="NodeIp:$Item||Info:$line.ERRCODE(4)"
                    WRITE_XML_ERROR 0 "$Result"
                else
                    tmp=$( echo ${line} | grep 'no delay'  )
                    if [ "${tmp}" == "" ]; then
                        continue
                    else
                        Result="NodeIp:$Item||Info:None"
                        WRITE_XML_COMMON 0 "$Result"
                    fi
                fi

            done < $G_TMP_FILE$Item
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#262. license
checkExpandLicense()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local iRet=0

    while true; do

        sysNodeNum=$( sqlite3 /opt/huawei/snas/etc/cm_conf.db "select count(*) from CM_NODE_T" )
        iRet=$?
        if [ $iRet -ne 0 ]; then
            sleep 1
            sysNodeNum=$( sqlite3 /opt/huawei/snas/etc/cm_conf.db "select count(*) from CM_NODE_T" )
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME][$LINENO]Can't get sysNodeNum by sqlite3,iRet=$iRet"
                WRITE_XML_ERROR 0 "Node:(master)||INFO:Can't get the number of nodes in system.return($iRet).ERRCODE(4)"
                isPass=1
                break
            fi
        fi

        local back_ip=$( get_backnet_ip )
        if [ "$back_ip" = "" ]; then
            LOG "[$FUNCNAME][$LINENO]Can't get local ip"
            isPass=1
            WRITE_XML_ERROR 0 "Node:-(master)||INFO:Can't get local ip.ERRCODE(11)"
            break
        fi

        #ִmml cm licensecfg
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm licensecfg"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            LOG "[$FUNCNAME][$LINENO]mml_result:$Info"
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to execute command(cm licensecfg),port(4016).return($iRet).ERRCODE(12)"
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1

        Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "get license res cfg fail" )
        if [ "$Info" != "" ];then
            #һжǷмlicenseļ
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:License is not activated."
            break
        fi

        javaID=$( cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "acFeatureName"|sed 's/^ *//g'|sed "/^$/d" )

        if [ "$javaID" = "" ];then
            LOG "[$FUNCNAME][$LINENO]$line,javaID is null"
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:No license resource active."
            break
        fi

        set_ifs
        for line in $javaID
        do
            if [ $line = "" ];then
                continue
            fi

            Feature=$( echo $line |awk '{print $3}' )
            MaxNumber=$( echo $line |awk '{print $11}'|sed 's/\./ /g' )
            Deadline=$( echo $line |awk '{print $7}' )
            LOG "[$FUNCNAME][$LINENO]Deadline:$Deadline"
            if [ "${Deadline}" == "9999-12-31" ];then
                date1=$(date --date "${Deadline}" +%s)
                Deadline="PERMANENT"
            else
                date1=$( expr $Deadline \/ 1000 )
                Deadline=$( date --date "1970-01-01 UTC $date1 seconds" +"%Y-%m-%d %T %z" )
            fi
            LOG "[$FUNCNAME][$LINENO]Deadline:$Deadline"
            date2=$( date )

            t1=$date1
            t2=$( date --date "$date2" +%s )
            LOG "[$FUNCNAME][$LINENO]Deadline:$t1,CurrentTime:$t2"
            if [ $t1 -lt $t2 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:The active licence Certificate expiration time($t1) is less than current time($t2).ERRCODE(6)"
            elif [ $MaxNumber -le $sysNodeNum ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:active licence Certificate supports a maximum number of nodes($MaxNumber) less than or equal to the number of current nodes($sysNodeNum).ERRCODE(7)"
            fi

            Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline||NodeNum:$sysNodeNum"
            LOG "[$FUNCNAME][$LINENO]Result=$Result,isPass=$isPass"
            WRITE_XML_COMMON 0 "$Result"
        done
        restore_ifs

        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#263. CMڵdeploy̼
checkCMMasterDeploy()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local deployFile="/opt/huawei/deploy/bin/snas_deploy"
    local deployProduct="/opt/product/deploy/bin/snas_deploy"

    LOG "[$FUNCNAME][$LINENO]start!"

    while true; do
        deployProcess=$(ps -C snas_deploy |grep snas_deploy )
        if [ "X$deployProcess" == "X" ]; then
            WRITE_XML_ERROR 0 "$deployProduct is not running.ERRCODE(4)"
            isPass=1
        else
            WRITE_XML_COMMON 0 "$deployProduct is running"
        fi

        break
    done

    LOG "[$FUNCNAME][$LINENO]finish! errResult=$errResult"

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#264. S3 S3FSǷ
checkS3FSService()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local G_TMP_FILE_Item=()
    local count=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/checkS3FSService > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ $? -ne 0 ];then
        isPass=1
    fi

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            #check node type
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" == "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            remote_exec_checkfini $Item $TASK_ID "Can not get s3fs service status information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME] $Item exec(checkS3FSService) failed.return($iRet)"
                errResult="Node: ${Item}||INFO: Failed to execute command(${G_MML_FILE_PATH}/checkS3FSService)"
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[${FUNCNAME}] ${Item} download ${G_REMOTE_TMP_FILE}${FUNCNAME} failed.return($iRet)"
                errResult="Node: ${Item}||INFO:Cannot get s3fs service status information!"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                continue
            fi

            G_TMP_FILE_Item[count]=$Item
            count=$((count+1))

        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in ${G_TMP_FILE_Item[*]}; do
        nodePass=$( grep "isPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        sMount=$( grep "s3fs:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        lsS3FS=$( grep "s3fs:" $G_TMP_FILE$Item |awk -F ":" '{print $3}' )
        bMount=$( grep "bill:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        lsBILL=$( grep "bill:" $G_TMP_FILE$Item |awk -F ":" '{print $3}' )
        sPath=$( grep "sPath:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        bPath=$( grep "bPath:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )

        #ıʶͬӰ칤߽ʾ
        Result="Node:$Item||Path:${sPath}||Is Mounted:${sMount}||Can LS:${lsS3FS}"
        Result="Node:$Item||Path:${bPath}||Is Mounted:${bMount}||Can LS:${lsBILL}||${Result}"
        WRITE_XML_COMMON 0 "$Result"

        if [ "${nodePass}""X" != "0X" ];then
            isPass=1
        fi
        while read line
        do
            info=$( handle_remote_result "${line}" )
            if [ $? -ne 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:$info"
            fi

        done < $G_TMP_FILE$Item
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#265. UPFݿⱸ.

checkUPFDBBackup()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local G_TMP_FILE_Item=()
    local count=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/checkUPFDBBackup > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ $? -ne 0 ];then
        isPass=1
    fi

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            #check node type
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" == "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            remote_exec_checkfini $Item $TASK_ID "Can not get upf database backup information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME] $Item exec(checkUPFDBBackup) failed.return($iRet)"
                errResult="Node: ${Item}||INFO: Failed to execute command(${G_MML_FILE_PATH}/checkUPFDBBackup)"
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[${FUNCNAME}] ${Item} download ${G_REMOTE_TMP_FILE}${FUNCNAME} failed.return($iRet)"
                errResult="Node: ${Item}||INFO:Cannot get upf database backup information!"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                continue
            fi

            G_TMP_FILE_Item[count]=$Item
            count=$((count+1))

        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in ${G_TMP_FILE_Item[*]}; do
        local isCheck=$( grep "isCheck:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        if [ "X$isCheck" == "X0" ];then
            LOG "This node not need to check, isCheck:[$isCheck] ${Item}."
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
            continue
        fi

        listerror=$( grep "listError" $G_TMP_FILE$Item )
        if [ "X${listerror}" != "X" ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||INFO: Failed to excute command(listBackups).ERRCODE(4)"
            continue
        fi

        local nodePass=$( grep "isPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        grep "NotExist" $G_TMP_FILE$Item|awk -F":" '{print $2}'|while read line
        do
            Result="Node:$Item||INFO:Backup Failed Date is $line.ERRCODE(5)"
            WRITE_XML_ERROR 0 "$Result"
        done

        if [ "${nodePass}""X" != "0X" ];then
            isPass=1
        fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#266. S3ؼ.

checkS3KeySerStatus()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local G_TMP_FILE_Item=()
    local count=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/checkS3KeySerStatus > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ $? -ne 0 ];then
        isPass=1
    fi

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            #check node type
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" == "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            remote_exec_checkfini $Item $TASK_ID "Can not get s3 key service information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME] $Item exec(checkS3KeySerStatus) failed.return($iRet)"
                errResult="Node: ${Item}||INFO: Failed to execute command(${G_MML_FILE_PATH}/checkS3KeySerStatus)"
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[${FUNCNAME}] ${Item} download ${G_REMOTE_TMP_FILE}${FUNCNAME} failed.return($iRet)"
                errResult="Node: ${Item}||INFO:Cannot get s3 key service information!"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                continue
            fi

            G_TMP_FILE_Item[count]=$Item
            count=$((count+1))

        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in ${G_TMP_FILE_Item[*]}; do
        local isCheck=$( grep "isCheck:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        if [ "X$isCheck" == "X0" ];then
            LOG "This node not need to check, isCheck:[$isCheck] ${Item}."
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
            continue
        fi

        local nodePass=$( grep "isPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        local nodeType=$( grep "nodeType:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        local errPro=$( grep "errPro:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        Result="Node:$Item||NodeType:${nodeType}||Error Service:${errPro}"
        WRITE_XML_COMMON 0 "$Result"

        if [ "${nodePass}""X" != "0X" ];then
            isPass=1
        fi
    done
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#268. DNSҵ״̬Ѳ.

checkS3DNSservice()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local G_TMP_FILE_Item=()
    local count=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/checkS3DNSservice > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ $? -ne 0 ];then
        isPass=1
    fi

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            #check node type
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" == "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            remote_exec_checkfini $Item $TASK_ID "Can not get s3 DNS service information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME] $Item exec(checkS3DNSservice) failed.return($iRet)"
                errResult="Node: ${Item}||INFO: Failed to execute command(${G_MML_FILE_PATH}/checkS3DNSservice)"
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[${FUNCNAME}] ${Item} download ${G_REMOTE_TMP_FILE}${FUNCNAME} failed.return($iRet)"
                errResult="Node: ${Item}||INFO:Cannot get s3 DNS service information!"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                continue
            fi

            G_TMP_FILE_Item[count]=$Item
            count=$((count+1))

        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in ${G_TMP_FILE_Item[*]}; do
        local isCheck=$( grep "isCheck:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        if [ "X$isCheck" == "X0" ];then
            LOG "This node not need to check, isCheck:[$isCheck] ${Item}."
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
            continue
        fi

        local nodePass=`grep "isPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}'`
        if [ "${nodePass}""X" != "0X" ];then
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||INFO:$info"
        fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#269. Ѳ.

checkBillService()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local G_TMP_FILE_Item=()
    local count=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/checkBillService > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ $? -ne 0 ];then
        isPass=1
    fi

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            #check node type
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" == "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            remote_exec_checkfini $Item $TASK_ID "Can not get bill information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME] $Item exec(checkBillService) failed.return($iRet)"
                errResult="Node: ${Item}||INFO: Failed to execute command(${G_MML_FILE_PATH}/checkBillService)"
                WRITE_XML_ERROR 0 "${errResult}"
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[${FUNCNAME}] ${Item} download ${G_REMOTE_TMP_FILE}${FUNCNAME} failed.return($iRet)"
                errResult="Node: ${Item}||INFO:Cannot get bill information!"
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                continue
            fi

            G_TMP_FILE_Item[count]=$Item
            count=$((count+1))

        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in ${G_TMP_FILE_Item[*]}; do
        local isCheck=$( grep "isCheck:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        if [ "X$isCheck" == "X0" ];then
            LOG "This node not need to check, isCheck:[$isCheck] ${Item}."
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
            continue
        fi

        local nodePass=$( grep "isPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        local origPass=$( grep "origPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        local storPass=$( grep "storPass:" $G_TMP_FILE$Item |awk -F ":" '{print $2}' )
        if [ "${origPass}""X" == "0X" ];then
            Result="Node:$Item||INFO:Check Operation-Specific CDR path failed"
            WRITE_XML_COMMON 0 "$Result"
        else
            Result="Node:$Item||INFO:Check Operation-Specific CDR path success"
            WRITE_XML_COMMON 0 "$Result"
        fi
        if [ "${storPass}""X" == "0X" ];then
            Result="Node:$Item||INFO:Check Storage-Specific CDR path failed"
            WRITE_XML_COMMON 0 "$Result"
        else
            Result="Node:$Item||INFO:Check Storage-Specific CDR path success"
            WRITE_XML_COMMON 0 "$Result"
        fi
        while read line
        do
            info=$( handle_remote_result "${line}" )
            if [ $? -ne 0 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:$info"
            fi

        done < $G_TMP_FILE$Item
        if [ "${nodePass}""X" != "0X" ];then
            isPass=1
        fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#273 ݾ⿪
function checkBalanceStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local tmpStr=""
    local isPass=0
    local checkScenario=$2
    local upgradeScenario=4
    local tmpfile="/tmp/tmpfilecheckBalanceStatus"

    [ -f $tmpfile ] && rm -f $tmpfile

    /usr/local/bin/MmlBatch 4016 "cm balance show" > $tmpfile 2>&1
    iRet=$?
    if [ $iRet -ne 0 ];then
        isPass=1
        WRITE_XML_ERROR 0 "INFO: Can not get balance status info!(MmlBatch 4016 'cm balance show')"
        LOG "iRet=$iRet, can not get balance status info!"
    else
        dos2unix -f $tmpfile >/dev/null 2>&1
        sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $tmpfile 2>&1
        tmpStr=$(cat $tmpfile |grep "BalanceStatus"|sed 's/^ *//g'|sed "/^$/d"|awk -F ":" '{print $2}' | tr -d ' ')
        if [ ${checkScenario} -eq ${upgradeScenario} ];then
            if [ "${tmpStr}" == "ON" ];then
                isPass=1
                WRITE_XML_ERROR 0 "INFO:Data balance status is not off."
            fi
        else
            if [ "${tmpStr}" == "OFF" ] ;then
                isPass=1
                WRITE_XML_ERROR 0 "INFO:Data balance status is not on."
            fi
        fi
        LOG "BalanceStatus:$tmpStr,tmpStr=$tmpStr"
    fi
    [ -f $tmpfile ] && rm -f $tmpfile
    WRITE_DIR_XML_COMMON 0 "BalanceStatus:$tmpStr"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL

}

#282.Ȳ״̬
checkHPatchstatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0

    remote_exec_async_batch $TASK_ID 300 "$G_MML_FILE_PATH/GetHPatchstatus > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ 0 -ne $? ];then
        isPass=1
    fi

    local ValidIP=$( cat ${VALID_IP_FILE} )
    local ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get HPatchstatus information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "item=$Item, download file fail!"
                continue
            fi
        done

        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        local fifoContext=$( cat $G_TMP_FILE$Item )
        if [ "X${fifoContext}" == "X" ];then
            LOG "item=$Item, file($G_TMP_FILE$Item) is empty!"
            continue
        fi

        set_ifs
        while read line
        do
            LOG "item=$Item, $line!"
            isPass=1
            WRITE_XML_ERROR 0 "Node: $Item||INFO: $line!"
        done <$G_TMP_FILE$Item
        restore_ifs

    done

    /opt/huawei/snas/upd/patch_script/cluster_patch.sh cluster show > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
    if [ 0 -ne $? ];then
        isPass=1
        WRITE_XML_ERROR 0 "Node:--||INFO:exe(cluster_patch.sh cluster show) fail."
    fi

    while read line
    do
        local status=""
        local tmpIp=$(echo ${line} | grep -Po '(?<=IP:)[0-9]+.[0-9]+.[0-9]+.[0-9]+')
        if [ "X${tmpIp}" != "X" ]; then
            local info=$(echo ${line} | grep 'Node Status')
            if [ "X${info}" != "X" ]; then
                status=$(echo $info | awk -F, '{print $2}' | awk -F: '{print $2}' | tr -d ' ')
            else
                local tmpinfo=$(/opt/huawei/snas/upd/patch_script/cluster_patch.sh ${tmpIp} show | grep "Node Status" )
                if [ 0 -ne $? ];then
                    isPass=$(check_pass $isPass 1)
                    WRITE_XML_ERROR 0 "Node:${tmpIp}||INFO: Failed to exectue command(cluster_patch.sh ${tmpIp} show)."
                else
                    status=$(echo "$tmpinfo" | awk -F, '{print $2}' | awk -F: '{print $2}' | tr -d ' ')
                    line="$tmpinfo"
                fi
            fi
            #ڵʱstatusΪ
            if [ "X${status}" != "X" ] && [ "${status}" != "unload" ] && [ "${status}" != "confirmok" ];then
                isPass=$(check_pass $isPass 1)
                WRITE_XML_ERROR 0 "Node: $tmpIp||INFO: patch status (${status}) not is empty, upload, confirm ok!"
            fi
        fi
        WRITE_XML_COMMON 0 "INFO:${line}"
    done < $G_REMOTE_TMP_FILE$FUNCNAME

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#283.鹲Ŀ¼
checkRedundantRatio()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local dfsip=""

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "REMOTE_IP_S:$REMOTE_IP_S"

    for Item in $REMOTE_IP_S; do
        #checkڵͣDFSִ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            continue
        fi
        #ǣ˵ȺкDFSڵ
        dfsip=$Item
        break
    done

    if [ "X${dfsip}" != "X" ];then
        #dfsڵ
        remote_exec $dfsip 300 "$G_MML_FILE_PATH/GetRedundantRatio > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ];then
            LOG "$[FUNCNAME][$LINENO] failed to get info  from GetRedundantRatio,iRet=$iRet,dfsip=$dfsip"
            WRITE_XML_ERROR 0 "INFO:Failed to get Redundancy Ratios info"
            isPass=1
        else
            remote_download $dfsip $G_TMP_FILE$dfsip $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "$[FUNCNAME][$LINENO]item=$Item, download file fail!"
            fi
            set_ifs
            for tmpline in $(cat $G_TMP_FILE$dfsip)
            do
                Share_Type=$(echo "$tmpline" |grep "Share_Type=" |awk -F'\\|\\|' '{print $1}' |awk -F= '{print $2}' |tr -d ' ')
                Share_Dir=$(echo "$tmpline" |grep "Share_Dir=" |awk -F'\\|\\|' '{print $2}' |sed 's/^Share_Dir=//g')
                RedundantRatio=$(echo "$tmpline" |grep "RedundantRatio=" |awk -F'\\|\\|' '{print $3}' |awk -F= '{print $2}' |tr -d ' ')
                LOG "[$FUNCNAME][$LINENO] Share_Type=$Share_Type Share_Dir=$Share_Dir RedundantRatio=$RedundantRatio"

                if [ "$Share_Type" == "" ] && [ "$Share_Dir" == "" ] && [ "$RedundantRatio" == "" ];then
                    # н壬ǿлӡϢ
                    continue
                fi

                if [ "$Share_Dir" == "--" ] && [ "$RedundantRatio" == "--" ];then
                    #ûЭ鹲Ŀ¼
                    WRITE_XML_COMMON 0 "INFO:Shared directory does not exist"
                    continue
                fi
                #/mnt/fs/share ʾڽ,ݹߵҪҪxmlĿ¼ֵ&apos;תΪ&#39;
                Share_Dir=$(echo "${Share_Dir}" |sed 's/\/mnt\/fs\/share//g' |sed 's/&apos;/\&#39;/g' |sed 's/|/\&#x7c;/g')
                if [ "$RedundantRatio" == "no" ];then
                    #Ŀ¼ڣ
                    if [ $isPass -eq 0 ];then
                        isPass=4
                    fi
                    WRITE_DIR_XML_COMMON 0 "Share_Type:$Share_Type||Share_Dir:<![CDATA[$Share_Dir]]>||RedundantRatio:The directory does not exist"
                    continue
                fi
                if [ "${RedundantRatio}" == "+1" ] ;then
                    #Ϊ+1
                    isPass=1
                fi
                WRITE_DIR_XML_COMMON 0 "Share_Type:$Share_Type||Share_Dir:<![CDATA[$Share_Dir]]>||RedundantRatio:$RedundantRatio"
                LOG "[$FUNCNAME][$LINENO] Share_Type=$Share_Type Share_Dir=<![CDATA[$Share_Dir]] RedundantRatio=$RedundantRatio"
            done
            restore_ifs
        fi
    else
        Result="INFO:Does not involve"
        WRITE_XML_COMMON 0 "$Result"
        isPass=0
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#284.Эɾ־Ŀ¼
checkNasLogDir()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local dfs_ip=""
    local ishavedfsnode=""
    local isPass=0
    local iRet=0
    local remotefile=""
    local isopen=0
    local issetdir=""
    local dirpath=""

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    LOG "REMOTE_IP_S:$REMOTE_IP_S"

    for Item in $REMOTE_IP_S; do
        local node_service_type=$(get_service_type_from_db "${Item}")
        if [ "${node_service_type}" != "1" ]; then
            LOG "service_type = ${service_type}.skip ${Item}."
            continue
        fi
        #ΪǼȺϢֻҪҵһdfsڵ㼴
        dfs_ip=$Item
        break
    done
    if [ "X${dfs_ip}" != "X" ];then
        #dfsڵ
        remotefile=$( remote_exec $dfs_ip 120 "$G_MML_FILE_PATH/checkNasLogDirMml" )
        iRet=$?
        if [ $iRet -ne 0 ];then
            LOG "$[FUNCNAME] failed to get info from checkNasLogDirMml,iRet=$iRet.dfs_ip=$dfs_ip"
            WRITE_XML_ERROR 0 "Node:$dfs_ip||INFO:Failed to get info from checkNasLogDirMml,return($iRet).ERRCODE(1)"
            isPass=1
        else
            #
            isPass=$(echo $remotefile | cut -d ":" -f 2 | cut -d ";" -f 1)
            isopen=$(echo $remotefile | cut -d ":" -f 3 | cut -d ";" -f 1)
            issetdir=$(echo $remotefile | cut -d ":" -f 4 | cut -d ";" -f 1)
            dirpath=$(echo $remotefile | cut -d ":" -f 5 | cut -d ";" -f 1)
            if [ $isopen -eq 0 ];then
                Result="INFO:The naslogdir is not open"
                WRITE_XML_COMMON 0 "$Result"
            else
                if [ $issetdir -eq 0 ];then
                    errResult="INFO:The naslogdir is open,but not set the path.ERRCODE(4)"
                    WRITE_XML_ERROR 0 "Node:$dfs_ip||INFO:$errResult"
                elif [ $isPass -eq 1 ];then
                    errResult="INFO:The naslogdir path is $dirpath,but it is not a directory.ERRCODE(5)"
                    WRITE_XML_ERROR 0 "Node:$dfs_ip||INFO:$errResult"
                else
                    Result="INFO:The naslogdir path is $dirpath"
                    WRITE_XML_COMMON 0 "$Result"
                fi
            fi
        fi
    else
        Result="INFO:Does not involve"
        isPass=0
    fi


    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#285.ȡvfsͳ
checkVfsPerformance()
{
     WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    remote_exec_async_batch $TASK_ID 120 "/usr/local/bin/nas_proto_pum -m nas_vfs -c get_request_stat > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ 0 -ne $? ];then
        isPass=1
    fi

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ]; then
                LOG "service_type = ${service_type}.skip ${Item}."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Does not involve"
                continue
            fi

            remote_exec_checkfini $Item $TASK_ID "Can not get vfs Performance information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "item=$Item, download file fail!"
                continue
            fi
        done

        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ]; then
            continue
        fi

        fifoContext=$( cat $G_TMP_FILE$Item )
        if [ "X${fifoContext}" == "X" ];then
            LOG "item=$Item, file($G_TMP_FILE$Item) is empty!"
            continue
        fi

        #ȥոкͿհ
        sed -i 's/^ *//g' $G_TMP_FILE$Item
        sed -i "/^$/d" $G_TMP_FILE$Item

        Info=$(cat $G_TMP_FILE$Item | awk '{if($1~/Operation/){lens=split($0,T," ");colline[1]=T[1];colline[2]=T[2];colline[3]=T[3]" "T[4];colline[4]=T[5]" "T[6];printf ("%-20s %-20s %-20s %-20s\n",colline[1],colline[2],colline[3],colline[4])}else{printf ("%-20s %-20s %-20s %-20s\n",$1,$2,$3,$4)}}')
        set_ifs
        Result=""
        for line in $Info; do
            if [ "X" != "X${Result}" ]; then
                Result="$Result||VFS Performance:$line"
            else
                Result="VFS Performance:$line"
            fi
        done
        #ıʶͬӰ칤߽ʾ
        Result="VFS Performance:${G_SEPARATOR}||VFS Performance:$Item||${Result}"
        WRITE_XML_COMMON 0 "$Result"
        restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#286.ؼļȨ޼
checkKeyFileAuthority()
{
    WRITE_XML_SUBCMD_HEADER $1
    local TASK_ID=0
    local isPass=0
    local isPass1=0

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    LOG "REMOTE_IP_S:$REMOTE_IP_S"
    iRet=$(cat /opt/huawei/deploy/script/localexec2.py | grep "\"CheckKeyFileAuthority.sh\""|wc -l)
    if [ $iRet -eq 0 ];then
        isPass=3
        WRITE_XML_COMMON 0 "INFO:Does not involve."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/CheckKeyFileAuthority.sh > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
     if [ 0 -ne $? ];then
        isPass=1
    fi

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get fileMode information"
                    iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "item=$Item, download file fail!"
                continue
            fi
        done

        ValidIP=$( cat ${VALID_IP_FILE} )
    done
    wait
    fifo_finish

    for Item in $ValidIPResult; do

        fifoContext=$( cat $G_TMP_FILE$Item )
        if [ "X${fifoContext}" == "X" ];then
            LOG "item=$Item, file($G_TMP_FILE$Item) is empty!"
            continue
        fi
        #жǷ
        snasshinfo=$(cat $G_TMP_FILE$Item |grep snassh)
        if [ "X${snasshinfo}" != "X" ];then
            for line in $snasshinfo;do
                isPass1=1
                catalogue=$(echo $line |awk -F ":" '{print $2}' )
                errResult="Node:$Item||INFO:There is a soft connection,snassh is at $catalogue.ERRCODE(4)"
                LOG "item=$Item,snassh is at $catalogue"
                WRITE_XML_ERROR 0 "$errResult"
            done
        fi
        #S30_get_os_permission.sh
        echo $fifoContext |grep S30_get_os_permission.sh >/dev/null
        if [ $? -eq 0 ];then
            Result="Node:$Item||Info:S30_get_os_permission not exist."
            WRITE_XML_COMMON 0 "${Result}"
            continue
        fi
        #permission.log
        echo $fifoContext |grep permission.log >/dev/null
        if [ $? -eq 0 ];then
            Result="Node:$Item||Info:/opt/permission.log not exist,create it successful."
            WRITE_XML_COMMON 0 "${Result}"
            continue
        fi
        #ӡȨ޲ͬ
        unequalfilename=$(cat $G_TMP_FILE$Item |grep filename0)
        for line in $unequalfilename;do
            isPass=4
            filename=$(echo $line | awk -F '\\|\\|' '{print $1}' | awk -F ":" '{print $2}')
            realfileMode=$(echo $line | awk -F '\\|\\|' '{print $2}' | awk -F ":" '{print $2}')
            expectfileMode=$(echo $line | awk -F '\\|\\|' '{print $3}' | awk -F ":" '{print $2}')
            errResult="Node:$Item||INFO:the file $filename realfileMode($realfileMode) is not same with the expectfileMode($expectfileMode).ERRCODE(5)"
            LOG "[$FUNCNAME] :Node:$Item||INFO:the file $filename realfileMode($realfileMode) is not same with the expectfileMode($expectfileMode).ERRCODE(5)"
            WRITE_XML_ERROR 0 "$errResult"
        done

    done
    #ȫͬӡ
    if [ "X${errResult}" == "X" ] && [ "X${Result}" == "X" ];then
        Result="Info:The fileMode in /opt/permission.log is same with the realfileMode."
        WRITE_XML_COMMON 0 "$Result"
    fi
    if [ $isPass1 -eq 1 ];then
        WRITE_XML_JUDGE $isPass1
    else
        WRITE_XML_JUDGE $isPass
    fi
    WRITE_XML_SUBCMD_TAIL
}

#287.omuserͬ
checkOSUserInfoSync()
{
    WRITE_XML_SUBCMD_HEADER $1
    local CHECK_PASSED=0
    local CHECK_FAILED=1
    local isPass=${CHECK_PASSED}
    local TASK_ID=0
    local iRet=0

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    LOG "REMOTE_IP_S:$REMOTE_IP_S"

    remote_exec_async_batch $TASK_ID 30 "cat /opt/huawei/snas/etc/cm.ini | grep OSUserInfoSyncFlag > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    if [ $? -ne 0 ];then
        isPass=${CHECK_FAILED}
    fi

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}
        for Item in $ValidIP; do
            remote_exec_checkfini $Item $TASK_ID "Can not get OSUserInfoSyncFlag information."
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=${CHECK_FAILED}
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=${CHECK_FAILED}
                LOG "item=$Item, download file fail!"
                continue
            fi
        done

        ValidIP=$( cat ${VALID_IP_FILE} )
    done
    wait
    fifo_finish

    for Item in $ValidIPResult; do
        if [ ! -f $G_TMP_FILE$Item ];then
            #־ǰѾﲻٴӡ
            isPass=${CHECK_FAILED}
            continue
        fi

        downCon=$(cat $G_TMP_FILE$Item)
        rc=$?
        LOG "[$FUNCNAME]node:$Item, remote_exec:cat /opt/huawei/snas/etc/cm.ini | grep OSUserInfoSyncFlag rc: $rc, downCon: ${downCon}"
        if [ $rc -ne 0 ] || [ "x${downCon}" == "x" ]; then
            WRITE_XML_ERROR 0 "Node:$Item||INFO:get OSUserInfoSyncFlag failed.ERRCODE(4)"
            isPass=${CHECK_FAILED}
            continue
        fi

        OSUserInfoSyncFlag=$( echo ${downCon} | grep OSUserInfoSyncFlag | awk -F "=" '{print $2}' | sed 's/^[ \t]*//g' | sed 's/[ \t]*$//g' )
        if [ "${OSUserInfoSyncFlag}" == "1" ];then
            WRITE_XML_COMMON 0 "Node:$Item||INFO:OSUserInfoSyncFlag=${OSUserInfoSyncFlag},check passed."
        else
            WRITE_XML_ERROR 0 "Node:$Item||INFO:OSUserInfoSyncFlag=${OSUserInfoSyncFlag},check failed.ERRCODE(5)"
            isPass=${CHECK_FAILED}
        fi
        continue
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#291. NFSӾ̬ipĿͻ
nascheck_static_mount()
{
    WRITE_XML_SUBCMD_HEADER $1
    local errResult=""
    local isPass=0
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    TASK_NFS_ID=0
    local back_ip=$( get_backnet_ip )
    patchinfo=$(/opt/huawei/snas/upd/patch_script/cluster_patch.sh "$back_ip" show)
    Version=$(echo $patchinfo |grep Version |awk -F "," '{print $3}' |awk -F ":" '{print $2}')
    if [ "null" = "$Version" -o "$Version" \< "V300R006C00SPH207" ];then
        isPass=3
        Result="INFO:The hot patch version is not involved($Version)."
        WRITE_XML_COMMON 0 "$Result"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    remote_exec_async_batch $TASK_NFS_ID 30 "$G_MML_FILE_PATH/nascheck_static_mount.sh > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

    fifo_start
    while [[ ${ValidIP} != "" ]]
    do
        > ${VALID_IP_FILE}
        for Item in $ValidIP
        do

            #checkڵ
            local service_type=$(get_service_type_from_db "${Item}")
            if [ "${service_type}" != "1" ];then
                LOG "service_type = ${service_type}.skip ${Item}."
                continue
            fi

            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_NFS_ID "Can not get nas_proto_status_nfs information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                continue
            fi

            #ݽ
            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish
    for Item in $ValidIPResult; do
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ]; then
            continue
        fi

        fifoContext=$( cat $G_TMP_FILE$Item )
        if [ "$fifoContext" = "" ];then
            WRITE_XML_ERROR 0 "Node:$Item||INFO:The NFS client does not exist"
            continue
        fi
        #any a node has ip regard not pass
        isPass=4
        WRITE_XML_ERROR 0 "Node:$Item||INFO:Client_type is NFS,Client_addr is $fifoContext.ERRCODE(4)"
    done
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#292 snas_daemon.shMD5ֵǷһ
checkDaemonMD5()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0
    local Result=""

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    #ֱȡ/opt/snas_daemon.shMD5ֵ/opt/huawei/deploy/script/daemon/snas_daemon.shMD5ֵ
    remote_exec_async_batch $TASK_ID 120 "$G_MML_FILE_PATH/GetDaemonMD5.sh > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?


    #ȡڵ/opt/snas_daemon.shMD5ֵ/opt/huawei/deploy/script/daemon/snas_daemon.shMD5ֵ
    MD5_master=$( md5sum /opt/snas_daemon.sh | awk '{print $1}' )


    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get MD5 information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                continue
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish
    for Item in $ValidIPResult; do
        local md5resolved=$(cat $G_TMP_FILE$Item | sed -n '/opt\/snas_daemon/p' | awk '{print $1}')
        local md5deployed=$(cat $G_TMP_FILE$Item | sed -n '/daemon\/snas_daemon/p' | awk '{print $1}')
        set_ifs
        while read line; do

            info=$( handle_remote_result "$line" )
            if [ $? -ne 0 ]; then
                isPass=1
                errResult="Node: $Item||INFO: $info||${errResult}"
                WRITE_XML_ERROR 0 "$errResult"
                LOG "[$FUNCNAME] Error: $info"
            else
                Result="Node:$Item ||detail:$info||${Result}"
            fi
        done < $G_TMP_FILE$Item
        if [ "${md5resolved}" != "${MD5_master}" -a ${isPass} -ne 1 ]; then
            isPass=4
            WRITE_XML_ERROR 0 "Node: $Item||INFO:The MD5 value(/opt/snas_daemon.sh) is not same with the master node($MD5_master).ERRCODE(5)"
        fi
        if [ "${md5resolved}" != "${md5deployed}" -a ${isPass} -ne 1 ]; then
            isPass=4
            WRITE_XML_ERROR 0 "Node: $Item||INFO:The MD5 value(/opt/snas_daemon.sh) is not same with /opt/huawei/snas/script/daemon/snas_daemon.sh."
        fi
        restore_ifs

    done

    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

# 339 ־
CheckConcomitantLogs()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local TASK_ID=0
    local isPass=0
    local spaceFlag=0
    local fun=$( GetInspectType 339 )
    local fun_end=${fun}_End
    local strGrep=${fun}_Pass
    local CheckMsgFile=/tmp/tmpResultCheckConcomitantLogs_

    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    #鿴ڵİ־handoffܻܶ࣬ᳬʱ
    remote_exec_async_batch $TASK_ID 1500 "$G_MML_FILE_PATH/CheckItems 339 > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
    isPass=$?

    ValidIP=$( cat ${VALID_IP_FILE} )
    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "Can not get ConcomitantLogs information"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO: excute check cmd failed."
                isPass=1
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                errResult="Node: $Item||INFO: remote download file failed."
                WRITE_XML_ERROR 0 "$errResult"
                continue
            fi

            PassStatus=$(cat $G_TMP_FILE$Item |eval sed '0,/$fun/d' |eval sed '/${fun_end}/,\$\d' |eval grep '${strGrep}' |awk '{print $2}')
            if [ "$PassStatus" = "" ];then
                LOG "[$FUNCNAME]:Node: $Item||INFO:($fun) get PassStatus failed"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:($fun) get PassStatus failed!ERRCODE(21)"
                isPass=1
            else
                #ӽڵѲϢ
                cat $G_TMP_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$strGrep/,\$\d' >${CheckMsgFile}
                #дѲXML
                CheckMsg=$(cat $CheckMsgFile)
                if [ "$CheckMsg" = "" ];then
                    LOG "[$FUNCNAME]:Node: $Item||INFO:$(fun) get CheckMsg failed"
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:$(fun) get CheckMsg failed!ERRCODE(21)"
                else
                    CheckMsgParse "$Item" "$CheckMsgFile" "$PassStatus" "339"
                    rm -rf $CheckMsgFile
                fi
                if [ "$PassStatus" !=  "0" ]; then
                    LOG "[$FUNCNAME]:Node: $Item||INFO: ${fun} check result:$PassStatus."
                    isPass=$(check_pass ${isPass} $PassStatus)
                fi
            fi
        done
        ValidIP=$( cat ${VALID_IP_FILE} )
    done

    wait
    fifo_finish
    rm -rf $CheckMsgFile

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

# 345 ˺ĬϿ
checkAccountDefaultPassword()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local key="storage"
    local passwd_suffix=""
    local user_list=("omuser" "omsftp" "root" "admin")
    local result=""
    local expect_log="/var/log/exeLogin.log"
    >${expect_log}

    LOG "[$FUNCNAME] start to check account default password"

    for ((i=0; i<${#user_list[@]}; i++))
    do
      account=${user_list[$i]}
      [ ${account} = "omsftp" ] && passwd_suffix=$( echo ${key} | sed 's/\b[a-z]/\U&/g' ) || passwd_suffix=${key}
      default_passwd=$( echo ${account} | sed 's/\b[a-z]/\U&/g' )"@"${passwd_suffix}

      LOG "[$FUNCNAME] start to check account ${account}"
      if [ ${account} = "admin" ]; then
        expect $G_MML_FILE_PATH/exeLogin.ex ${default_passwd} >> ${expect_log}
        iRet=$?
      else
        passwd_crypt=$( cat /etc/shadow | grep ${account} | awk -F: '{print $2}' )
        crypt_key=$( echo ${passwd_crypt} | awk -F '$' '{print "$"$2"$"$3"$"}' )
        default_passwd_crypt=$( python -c "import crypt; print crypt.crypt('${default_passwd}', '${crypt_key}')" )
        if [ ${default_passwd_crypt} = ${passwd_crypt} ]; then
          iRet=0
        else
          iRet=121
        fi
      fi


      [ ${iRet} -eq 121 ] && result="pass" || result="no pass"
      LOG "[$FUNCNAME] account:${account} check result is ${result}(${iRet})"

      if [ ${iRet} -ne 121 ]; then
          isPass=$(check_pass $isPass 4)
          if [ ${iRet} -eq 0 ];
          then
            WRITE_XML_ERROR 0 "Node:(master)||INFO:The ${account} account uses the default password."
          else
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node:(master)||INFO:The ${account} account check failed."
          fi
      fi
      WRITE_XML_COMMON 0 "Node:(master)||Account:${account}||Result:${result}."
    done

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#ûдѲΪ
noInspectItem()
{
    WRITE_XML_SUBCMD_HEADER $1
    WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
    WRITE_XML_JUDGE 3
    WRITE_XML_SUBCMD_TAIL
    LOG "The current system does not support the appointed inspect item!"
}

# **************************************************************************** #
# Function Name: checkSoftwareStatus
# Description: Software м.
# Parameter: $1 cmditemID
# Return:
# **************************************************************************** #
checkSoftwareStatus()
{
    WRITE_XML_CMD_HEADER $1

    #GetBackIPAndRoleFromDB
    LOG_Check

    rm -rf /opt/inspect/tmpfile$!*
    rm -rf /opt/inspect/tmpfilex$!*
    rm -rf /tmp/tmpfile$!*

    LOG "[$FUNCNAME] param = ($1)"
    case $1 in
        200)
            #2.Check Open File Count
            checkOpenFileCount_Async "0"
            ;;
        201)
            #3.Check Node Throughput (ڵ)
            checkNodeThroughput  "0"
            ;;
        202)
            #4.Check Node IO Perform
            checkNodeIOPerform  "0"
            ;;
        204)
            #5.Check Monitor's Map status(monϵͳ״̬ mds ds ca pip mapϢ)
            checkMonitorHeartbeat_Async "0"
            ;;
        205)
            #6.Check NTP Service
            checkNTPService_Async "0"
            ;;
        206)
            #7.Check CM master
            checkCMMaster "0"
            ;;
        207)
            #8.Check ISM status
            checkISMStatus_Async "0"
            ;;
        208)
            #9.Check License status
            checkLicenseStatus_MML "0"
            ;;
        209)
            #10.Check File operationļ
            checkFileOperation_Async "0"
            ;;
        210)
            #11.Check NAS client
            checkALLClient "0"
            ;;
        211)
            #12.Check NAS Cluster Status
            checkNASClusterStatus "0"
            ;;
        212)
            #13.Check DS Usage
            checkDSUsage "0"
            ;;
        213)
            #14.Check Communication Link (ڵϵͨѶ·)
            checkCommuLink "0"
            ;;
        214)
            #14.Check memory pool usage (ڴصʹ)
            checkMemPoolUsage_Async "0"
            ;;
        215)
            #Check data consistentһ
            checkDataConsistent_Async "0"
            ;;
        216)
            #Check System inode(ϵͳinodeBirth)
            checkFileInodeAndBirthCount "0"
            ;;
        217)
            #Check AD ״̬
            checkADDomain "0"
            ;;
        218)
            #Check system file opened (linuxϵͳ򿪵ļ)
            checkSystemFileOpened "0"
            ;;
        219)
            #Check NIS ط״̬
            checkNIS "0"
            ;;
        220)
            #Check external DNS
            checkExtDnsConn "0"
            ;;
        221)
            #Check LDAP ط״̬
            checkLDAP "0"
            ;;
        222)
            #Check IPMIַǷ
            checkIPMI "0"
            ;;
        223)
            #Check Tierּ
            checkTier "0"
            ;;
        224)
            #Ƿδĸ澯
            checkLeftAlarm_MML "0"
            ;;
        225)
            #ҵڵ״̬  mon mds pip
            checkMasterStatus "0"
            ;;
        226)
            #MON Serverڵ
            checkMonServer "0"
            ;;
        227)
            #Nvdimmڴصʹ
            checkNvdimmPool "0"
            ;;
        228)
            #ָ̨״̬
            checkDataRestore "0" "2"
            ;;
        229)
            #Ⱥֻˮλ
            checkReadOnlyThreshold "0"
            ;;
        230)
            #nlun״̬
            getNlunStatus "0"
            ;;
        231)
            #MONǷƵѡ
            checkMonHealth "0"
            ;;
        232)
            #mdsһ
            checkMdsSubTreeStatus "0"
            ;;
        233)
            #Ƿcoreļ
            checkCoreFile "0"
            ;;
        234)
            #ntp״̬
            checkNtpConn "0"
            ;;
        235)
            #check if there is a RPC leak in node by check reference count of RPC
            #ǷRPCüй©,
            checkNodeRPC_ReferCnt "0"
            ;;
        236)
            #дNOFSǷгʱ
            checkWrtNofsTimeout "0"
            ;;
        237)
            #IPϷ
            checkNodeIPLegality "0"
            ;;
        238)
            #bjm̼
            checkBJM "0"
            ;;
        239)
            #1.Check System Information
            checkSystemInfo_MML "0"
            ;;
        240)
            #1.Check pool status
            checkNodePoolStatus "0"
            ;;
        241)
            #ȲƼ汾
            checkHpatchOperation "0"
            ;;
        243)
            #
            checkQuotaServe 0
            ;;
        245)
            #1.Check Replication Link
            checkReplicationLink "0"
            ;;
        246)
            #1.Check Replication Process
            checkReplicationProcess "0"
            ;;
        247)
            #1.Check ReplicationZone Status
            checkReplicationZoneStatus "0"
            ;;
        248)
            #1.Check Replication Pair Status
            checkReplicationPairStatus "0"
            ;;
        249)
            #1.Check ReplicationZone Version
            checkReplicationVersion "0"
            ;;
        251)
            #4.check TLV black list
            checkTLVBlacklist "0"
            ;;
        252)
            #4.check TLV black list
            checkDataMigrationTask "0" "2"
            ;;
        254)
            #洢״̬
            checkObjsServiceStat "0"
            ;;
        255)
            #keystone
            checkKeyStone "0"
            ;;
        256)
            #AV Server״̬
            checkAvServerStatus "0"
            ;;
        257)
            #MDS
            checkMdsSubTreeNum "0"
            ;;
        258)
            #rpcǷȷ
            checkRpcBindCore "0"
            ;;
        260)
            #check ad connection
            checkADdomainControllerStatus "0"
            ;;
        261)
            #ʱ
            checkDelayReimportDisk "0"
            ;;
        262)
            #license
            checkExpandLicense "0"
            ;;
        263)
            #CMڵdeploy̼
            checkCMMasterDeploy "0"
            ;;
        264)
            #check s3 s3fs service
            checkS3FSService "0"
            ;;
        265)
            #check ufp database backup service
            checkUPFDBBackup "0"
            ;;
        266)
            #check s3 key service
            checkS3KeySerStatus "0"
            ;;
        268)
            #check s3 dns service
            checkS3DNSservice "0"
            ;;
        269)
            #check bill service
            checkBillService "0"
            ;;
        273)
            checkBalanceStatus "0" "2"
            ;;
        276)
            #accountcheck
            accountcheck "0"
            ;;
        278)
            #check_gateway
            check_gateway "0"
            ;;
        279)
            #checkbuckinfo
            checkbuckinfo "0"
            ;;
        280)
            #checkdomainname
            checkdomainname "0"
            ;;
        282)
            #Ȳ״̬
            checkHPatchstatus "0"
            ;;
        283)
            #鹲Ŀ¼
            checkRedundantRatio "0"
            ;;
        284)
            #Эɾ־Ŀ¼
            checkNasLogDir "0"
            ;;
        285)
            #ȡvfsͳ
            checkVfsPerformance "0"
            ;;
        286)
            #ؼļȨ޼
            checkKeyFileAuthority "0"
            ;;
        287)
            #omuserͬ
            checkOSUserInfoSync "0"
            ;;
        291)
            #ǷNFSӾ̬ipĿͻ
            nascheck_static_mount "0"
            ;;
        292)
            #daemonMD5ֵǷͬ
            checkDaemonMD5 "0"
            ;;
        331)
            #𳡾Сü
            CheckStripeCfg "0"
            ;;
        333)
            #xattrxinfoü
            CheckXinfoXattr "0"
            ;;
        339)
            # ־
            CheckConcomitantLogs "0"
            ;;
        345)
            #˺ĬϿ
            checkAccountDefaultPassword "0"
            ;;
        401)
            #4.check TLV black list
            checkDataMigrationTask "0" "4"
            ;;
        405)
            #ָ̨״̬
            checkDataRestore "0" "4"
            ;;
        406)
            #ݾ Ѳ
            checkBalanceStatus "0" "4"
            ;;
        *)
            noInspectItem "0"
            ;;
        esac
    chmod 640 $LOG_FILE
    WRITE_XML_CMD_TAIL
    rm -rf /opt/inspect/tmpfile$!*
    rm -rf /opt/inspect/tmpfilex$!*
    rm -rf /tmp/tmpfile$!*
    rm -rf /tmp/tmp_valid_ip$!
}

#274 У֤һ
function CheckNodeCertificateConsistency()
{
    local isPass=$1
    local checkfile=$2
    local CertificateList="/opt/huawei/snas/etc/sslcert.pem /opt/huawei/snas/etc/sslca.cer /opt/huawei/deploy/etc/Equipment_Root_CA.der /opt/huawei/deploy/etc/IT_Product_CA.cer /etc/softcert/HuaweiRootCA.der /opt/huawei/deploy/etc/cluster_ca.cer /opt/huawei/deploy/etc/cluster_cert.pem /opt/huawei/deploy/etc/toolkit_dep_ca.cer /opt/Runtime/tomcat7/conf/server.pem /opt/Runtime/tomcat7/conf/server.cer /etc/ssl/private/server_cert.pem /opt/huawei/snas/etc/cert/alarm/cacert.pem /opt/huawei/snas/etc/cert/password/cacert.pem /opt/huawei/snas/etc/cert/emui/cacert.pem /etc/rsyslog-key/client_cert.pem /etc/rsyslog-key/ca.pem /opt/deviceManager/apache/conf/ca.crt /opt/huawei/viid/config/server/server.pem /opt/huawei/viid/config/server/server.cer /opt/huawei/deploy/etc/toolkit_dep_cert.pem /opt/deviceManager/apache/conf/cert_en.pem /opt/Runtime/tomcat7/cert/ToolKitDeploy.keystore /opt/Runtime/tomcat7/cert/IT_CA.keystore /opt/Runtime/tomcat7/conf/server.keystore /opt/obs/service/osc/etc/keystore /opt/obs/service/poe/etc/keystore /opt/obs/service/dcm/etc/keystore /var/uds/user/data_upf/server.crt"
    for item in ${CertificateList}
    do
        #ȥֻSHA
        DiffCertiList=$( grep ${item} ${checkfile} | awk -F"|" '{print $9}' | awk -F"key:" '{print $2}' |grep -v "NA" | sort | uniq -c | sort  | awk '{print $2}' )
        ArraySHAList=(${DiffCertiList})
        #һµĻֱӳȥ
        if [ 1 -eq ${#ArraySHAList[@]} ];then
            continue
        fi
        for i in $( seq 0 $( expr ${#ArraySHAList[@]} - 2 ) )
        do
            isPass=1
            grep ${item} ${checkfile} | grep "${ArraySHAList[i]}" |while read line
            do
                Nodeip=$( echo ${line} | awk -F'|' '{print $1}' | awk -F"=" '{print $2}')
                #ҵͬshaֵ,ֱӱȥ,:ļûм¼ڵϢ,֪ĸڵ,ڵϢȥ
                WRITE_XML_ERROR 0 "Node:${Nodeip}||INFO:The Certificate ${item} is different with other nodes."
            done
        done
    done
    return ${isPass}

}

#274 ֤һļи
function DealCertificateSHA()
{
    local nodeip=$1
    local dealfile=$2
    local CertiFun="CheckCertificate"
    local dealfile_tmp="${dealfile}_${CertiFun}"
    grep "^CerName" ${dealfile} | sed "s/^/Node=${nodeip}||&/g" >> ${dealfile_tmp} 2>&1

    #ļеSHAֵ˵,ղʾSHAֵ
    sed -i "s/||key:[A-Za-z0-9:]*//g" ${dealfile}

}
#317 ü
function CheckALLNodeSpecialConf()
{
    local isPass=$1
    local checkfile=$2
    local checkList="shutdownEarTemp shutdownCpuTemp shutdownNvdimmTemp"
    local NodeNum=$(cat $checkfile | grep shutdownEarTemp: | wc -l)
    for item in ${checkList}
    do
        local nodeList=""
        local cfgNum=$(cat $checkfile | grep "${item}:yes" |wc -l)
        if [ ${cfgNum} -ne ${NodeNum} ] && [ ${cfgNum} -ne 0 ];then
            isPass=$(check_pass ${isPass} 4)
            local notCfgInfo=$(cat $checkfile | grep ${item}:no )
            for tmpInfo in ${notCfgInfo}
            do
                local node=$(echo ${tmpInfo} | grep -Po '(?<=^Node:)[0-9.]*')
                nodeList="${node} ${nodeList}"
            done
            WRITE_XML_ERROR 0 "nodeIP:master||INFO:${item} is not configued on (${nodeList})."
        fi
    done
    return ${isPass}

}
#Խļд
function DealResultFile()
{
    local taskid=$1
    local nodeip="$2"
    local needdealfile="$3"

    case $taskid in
    274)
        DealCertificateSHA  "${nodeip}" "${needdealfile}"
        ;;
     *)
        echo ""
        ;;
     esac
}
local_exec_cmd()
{
    taskids=$1
    params=$2
    ${G_MML_FILE_PATH}/CheckItems "$taskids" "$params"> $G_DOWNLOAD_FILE$3 2>&1
    iRet=$?
    if [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME]||INFO:cmd failed taskids:($taskids)"
    fi
}
#Ѳ357 ڵӲһԼ Ҫӽڵip
checkNodePoolDiskConsistency()
{
    local CheckMsg=$1
    local masterip=$2
    local info=""
    set_ifs
    for line in ${CheckMsg}
    do
        if [ "${line}" != "" ]; then
            info=$( handle_remote_result "${line}" )
            if [ $? -ne 0 ]; then
                WRITE_XML_ERROR 0 "Node:$masterip(master)||INFO:$info"
                LOG "[$FUNCNAME]:Node: $masterip||INFO:inspect error ${line}"
            else
                WRITE_XML_COMMON 0 "${line}" >/dev/null
            fi
        fi
    done
    restore_ifs
}

#327. CCDBڵݿ汾Ƿһ
analyse_result_CheckCCDBDBConsistency()
{
    fun=$1
    fun_end=${fun}_End
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    local isPass=0
    local result=""
    local fifoContext=""
    local dbfileList=""
    local CCDB_Num=0
    local monLeader=""
    local ccdbIP=""
    local isBackIp=""
    local isCCDBIp=""
    local nodeIdList=""
    local tmpIpRole=$(cat $IP_ROLE_FILE)
    LOG "[$FUNCNAME][$LINENO]isPass=$isPass,REMOTE_IP_S=$REMOTE_IP_S"
    local tmpFileCCDB="${G_TMP_FILE}CCDB"
    local tmpFileCCDB_bak="${G_TMP_FILE}CCDB.BAK"
    > ${tmpFileCCDB}
    >${tmpFileCCDB_bak}
    monLeader=$(cat /proc/monc_leader | grep "Mon leader:" | awk -F":" '{print $2}')
    
    if [ -f "/proc/monc_ccdbmap" ];then
        nodeIdList=$(cat /proc/monc_ccdbmap | grep -Po '(?<=MinIp: )[0-9.]+' | tr "\n" " ")
        local nodeId=""
        for nodeId in $nodeIdList;do
            local bakipList=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select ip_addr from cm_node_ip_t where(nid = (select nid from cm_node_ip_t where(ip_addr = '${nodeId}')) and SUBNET_ID = 1) ")
            local ip=""
            for ip in $bakipList;do
                isBackIp=$(echo "${tmpIpRole}" | grep -wF ${ip})
                if [ $? -eq 0 ];then
                    ccdbIP="${ip} ${ccdbIP}"
                    break
                fi
            done
        done
    else
        #monڵִвѯccdb
        nodeIdList=$(/opt/huawei/deploy/script/localexec.py cmd ${monLeader} 30 false "MmlBatch 988 'monc ccdbmap 0'| grep \"Node Id :\"  " | grep -Po '(?<=Node Id : )[0-9]+')
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME][${LINENO}]:return($iRet) "
            errResult="Node:${monLeader}||INFO:Failed to execute command(MmlBatch 988 'monc ccdbmap 0'). Error(${iRet})."
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
        else
            /opt/huawei/deploy/script/localexec.py cmd ${monLeader} 30 false "cat /proc/monc_nodemap" > ${tmpFileCCDB} 2>&1
            local nodeId=""
            for nodeId in $nodeIdList;do
                local tmpNodeIdIp=$(cat ${tmpFileCCDB} | grep "NodeID($nodeId)" | grep -Po '(?<=DevName\()[0-9.]+')
                local bakipList=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select ip_addr from cm_node_ip_t where(nid = (select nid from cm_node_ip_t where(ip_addr = '${tmpNodeIdIp}')) and SUBNET_ID = 1) ")
                local ip=""
                for ip in $bakipList;do
                    isBackIp=$(echo "${tmpIpRole}" | grep -wF ${ip})
                    if [ $? -eq 0 ];then
                        ccdbIP="${ip} ${ccdbIP}"
                        break
                    fi
                done
            done
            > ${tmpFileCCDB}
        fi
    fi
    #ҵ߼
    if [ -z "$ccdbIP" ];then
        isPass=$(check_pass $isPass 1)
        WRITE_XML_ERROR 0 "Node: $(hostname)(master) || INFO: Can not get ccdbIP!"
        rm -f ${tmpFileCCDB}
        LOG "[$FUNCNAME] pass:$isPass."
        WRITE_XML_JUDGE $isPass
        return
    fi
    for Item in $tmpIpRole; do
        cat $G_DOWNLOAD_FILE$Item |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >$CheckMsgFile$Item
        dos2unix $CheckMsgFile$Item > /dev/null 2>&1
        isCCDBIp=$(echo "$ccdbIP" | grep -w "$Item")
        if [ $? -ne 0 ];then
            cat $CheckMsgFile$Item >> ${tmpFileCCDB_bak}
            echo $Item >> ${tmpFileCCDB_bak}
            continue
        fi
        fifoContext=`cat $CheckMsgFile$Item`
        if [ "$fifoContext" = "" ];then
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Null output(${fun})."
            isPass=$(check_pass $isPass 1)
            continue
        fi
        result=`echo "$fifoContext" |grep "No CCDB database file"`
        if [ "X" != "X${result}" ];then
            LOG "Node: $Item||INFO: No CCDB database file"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:${result}"
            isPass=$(check_pass $isPass 1)
        else
            CCDB_Num=$(expr $CCDB_Num + 1)
            cat $CheckMsgFile$Item >> ${tmpFileCCDB}
            echo $Item >> ${tmpFileCCDB}
        fi
    done
    dbfileList=$(/opt/huawei/deploy/script/localexec.py cmd ${monLeader} 30 false "find /opt/product/etc/ccdb/ -type f "| grep -vP '\-wal|\-shm|\.log|/ccdb_export/')
    [ $? -ne 0 ] && dbfileList=$(cat ${tmpFileCCDB} | grep "^/opt/" | awk '{print $1}' |sort -u )
    for item in $dbfileList;do
        maxVer=$(cat ${tmpFileCCDB} | grep -w "$item" | awk '{print $NF}' | sort -n | tail -1)
        tmpNum=$(cat ${tmpFileCCDB} | grep -w "$item" | grep -w "${maxVer}" | wc -l)
        if [ "$tmpNum" -gt "$(expr $CCDB_Num / 2 )" ] || [ "$item" = "/opt/product/etc/ccdb/ccdb_metadata.db_0/ccdb_metadata.db" ];then
            WRITE_XML_COMMON 0 "Node: ${monLeader}(mon) || INFO:$item max version is $maxVer ($tmpNum/$CCDB_Num)."
        else
            isPass=$(check_pass $isPass 1)
            WRITE_XML_ERROR 0 "Node: ${monLeader}(mon) || INFO: $item max version is $maxVer ($tmpNum/$CCDB_Num)!"
        fi
    done
    mv -f ${tmpFileCCDB} /var/log/CCDB_DB_version.log
    echo "-------other node-------" >> /var/log/CCDB_DB_version.log
    cat ${tmpFileCCDB_bak} >> /var/log/CCDB_DB_version.log 
    [ -f "${tmpFileCCDB_bak}" ] && rm -f  ${tmpFileCCDB_bak}
    LOG "[$FUNCNAME] pass:$isPass."
    WRITE_XML_JUDGE $isPass
}
CheckLocalMsgParse()
{
    local CheckMsg=$1
    local PassCode=$2
    local masterip=$3
    local info=""
    set_ifs
    for line in ${CheckMsg}
    do
        if [ "${line}" != "" ]; then
            info=$( handle_remote_result "${line}" )
            if [ $? -ne 0 ]; then
                WRITE_XML_ERROR 0 "Node:$masterip(master)||INFO:$info"
                LOG "[$FUNCNAME]:Node: $masterip||INFO:inspect error ${line}"
            else
                WRITE_XML_COMMON 0 "Node: $masterip(master)||${line}" >/dev/null
            fi
        fi
    done
    restore_ifs
}

#Ѳ
CheckLocalPassStatus()
{
    local PassCode=1
    local fun=$1
    local RemoteIp=$2
    local process=$3
    local fun_end=${fun}_End
    local strGrep=""
    if [ "x${process}" != "x" ];then
        strGrep=${fun}_${process}_Pass
    else
        strGrep=${fun}_Pass
    fi
    local CheckMsgFile="/tmp/CheckMsgFile$!"
    cat $G_DOWNLOAD_FILE$RemoteIp |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >${CheckMsgFile}
    local PassStatus=$(cat ${CheckMsgFile} |eval grep '${strGrep}' |awk '{print $NF}')
    if [[ "${PassStatus}" =~ ^[0-9]+$ ]];then
        PassCode=${PassStatus}
    else
        LOG "[$FUNCNAME]||$fun get Passcode failed from $RemoteIp : PassStatus is ${PassStatus}"
    fi
    #ӽڵѲϢ
    local CheckMsg=""
    if [ "x${process}" != "x" ];then
        CheckMsg=$(cat ${CheckMsgFile} | grep -v ${fun}_[0-9]*_Pass)
    else
        CheckMsg=$(cat ${CheckMsgFile} | grep -v ${strGrep})
    fi
    if [ "$CheckMsg" = "" ]; then
        WRITE_XML_ERROR 0 "Node:$RemoteIp(master)||INFO:$fun Get CheckMsg failed.ERRCODE(21)"
    else
        # Ѳ357   Ҫӽڵip ⴦
        if [ "${fun}" = "CheckNodePoolDiskConsistency" ];then
            checkNodePoolDiskConsistency "${CheckMsg}" "$RemoteIp"
        else
            CheckLocalMsgParse "${CheckMsg}" "$PassCode" "$RemoteIp"
        fi
    fi
    rm -rf $CheckMsgFile

    WRITE_XML_JUDGE $PassCode >/dev/null
}

analyse_local_result()
{
    #Զؽһ£xmlд뷽ʽֻܴС
    MainNodeIp=$2
    for taskid in $1
    do
    {
        InspectFun=$( GetInspectType $taskid )

        G_CHECK_RESULT_FILE="/opt/inspect/check_result_file"$taskid
        > $G_CHECK_RESULT_FILE
        WRITE_XML_HEADER >/dev/null
        WRITE_XML_CMD_HEADER $taskid >/dev/null
        WRITE_XML_SUBCMD_HEADER "0" >/dev/null
        if [ "$InspectFun" != "" ];then
            CheckLocalPassStatus "$InspectFun" "$MainNodeIp"
        else
            LOG "[$FUNCNAME]||INFO:The current system does not support the appointed inspect item($taskid)!"
            WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
        fi
        WRITE_XML_SUBCMD_TAIL >/dev/null
        WRITE_XML_CMD_TAIL >/dev/null
        WRITE_XML_TAIL $taskid >/dev/null
    }
    done
    wait
}

#ִ
exec_cmd()
{
    remoteIp=$1
    taskids=$2
    params=$3
    exec_taskid="CheckItems"
    command="${G_MML_FILE_PATH}/CheckItems '$taskids' '$params'> $G_REMOTE_EXEX_RESULT 2>&1"
    remote_exec_async $remoteIp $exec_taskid 300 "$command"
    iRet=$?
    if [ $iRet -ne 0 ]; then
        LOG "Node:$remoteIp||INFO:Failed to exec_cmd command.iRet=$iRet,taskids($taskids)"

    fi
}


function download_result()
{
    remoteIp=$1
    TASK_ID="CheckItems"
    local iRet=0
    #ѭֱسɹʧܺ˳ѭ
    while [[ ${remoteIp} != "" ]]
    do
    {
        remote_exec_checkfini $remoteIp $TASK_ID "download ($remoteIp) exec result failed"
        iFunRet=$?
        if [ $iFunRet -eq 0 ];then
            continue
        elif [ $iFunRet -eq 2 -o $iFunRet -eq 5 ];then
            iRet=0
        else
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO: remote_exec_checkfini return ($iFunRet)download_result checkfini failed."
            iRet=1
        fi

        #Ϊ100%֮ļأн
        remote_download_sync $remoteIp $G_DOWNLOAD_FILE$remoteIp $G_REMOTE_EXEX_RESULT
        iFunRet=$?
        if [ $iFunRet -ne 0 ];then
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO:remote_download_sync return ($iFunRet) download_result download file failed."
            iRet=1
        fi
        break
    }
    done
    return $iRet
}

CheckMsgParse()
{
    Remote_ip=$1
    CheckMsgFile=$2
    PassCode=$3
    taskid=$4
    dos2unix $CheckMsgFile > /dev/null 2>&1
    index=0
    while read var
    do
        if [ "$var" != "" ]; then
            info=$( handle_remote_result "$var" )
            if [ $? -ne 0 ]; then
                WRITE_XML_ERROR 0 "Node:$Remote_ip||INFO:$info"
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:inspect error ${var}"
            else
                if [ "${taskid}" = "317" ];then
                    WRITE_XML_COMMON 0 "${var}" >/dev/null
                else
                    WRITE_XML_COMMON 0 "Node:$Remote_ip||${var}" >/dev/null
                fi
            fi
        fi
    done < "$CheckMsgFile"
}

CheckPassStatus()
{
    local need_compare_taskids="274 317"
    local need_deal_taskids="274"
    isPass=0
    fun=$1
    taskid=$2
    fun_end=${fun}_End
    strGrep=${fun}_Pass
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    CheckMsgFile="/tmp/CheckMsgFile$!"
    CheckMsgFile_fun="${CheckMsgFile}_${fun}"
    >${CheckMsgFile_fun}
    for Remote_ip in ${REMOTE_IP_S}
    do
    {
        PassStatus=$(cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${strGrep}' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:($fun) get PassStatus failed"
            WRITE_XML_ERROR 0 "Node:$Remote_ip||INFO:($fun) get PassStatus failed!ERRCODE(21)"
            isPass=1
        else
            #ӽڵѲϢ
            cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$fun/d' |eval sed '/$strGrep/,\$\d' >${CheckMsgFile}
            #дѲXML
            CheckMsg=$(cat $CheckMsgFile)
            if [ "$CheckMsg" = "" ];then
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:$(fun) get CheckMsg failed"
                WRITE_XML_ERROR 0 "Node:$Remote_ip||INFO:$(fun) get CheckMsg failed!ERRCODE(21)"
            else
                if [[ "${need_compare_taskids}" =~ "${taskid}" ]];then

                    #һԽڵļļĺ
                    if [[ ${need_deal_taskids} =~ "${taskid}" ]];then
                        #Ҫΰļȥ
                        DealResultFile "${taskid}" "$Remote_ip" "${CheckMsgFile}"
                    else
                        cat ${CheckMsgFile} >> ${CheckMsgFile_fun}
                    fi
                fi
                CheckMsgParse "$Remote_ip" "$CheckMsgFile" "$PassStatus" "${taskid}"
                rm -rf $CheckMsgFile
            fi
            if [ "$PassStatus" !=  "0" ]; then
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO: ${fun} check result:$PassStatus."
                isPass=$PassStatus
            fi
        fi
    }
    done
    if [[ "${need_compare_taskids}" =~ "${taskid}" ]];then
        case ${taskid} in
        274)
            CheckNodeCertificateConsistency  ${isPass} ${CheckMsgFile_fun}
            isPass=$?
            ;;
        317)
            CheckALLNodeSpecialConf  ${isPass} ${CheckMsgFile_fun}
            isPass=$?
            ;;
        *)
            echo ""
            ;;
        esac
    fi
    WRITE_XML_JUDGE $isPass >/dev/null
}

analyse_result()
{
    #xmlдļG_CHECK_RESULT_FILE У̴ᵼд󣬹ʴС
    #ڿɸıдxmlʽŻΪС
    taskids=$1
    for taskid in $taskids
    do
    {
        InspectFun=$( GetInspectType $taskid )

        G_CHECK_RESULT_FILE="/opt/inspect/check_result_file"$taskid
        > $G_CHECK_RESULT_FILE
        WRITE_XML_HEADER >/dev/null
        WRITE_XML_CMD_HEADER $taskid >/dev/null
        WRITE_XML_SUBCMD_HEADER "0" >/dev/null
        if [ "$InspectFun" != "" ];then
            if [ "${taskid}" = "327" ];then
                analyse_result_CheckCCDBDBConsistency ${InspectFun}
            else
                CheckPassStatus ${InspectFun} ${taskid}
            fi
        else
            LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:The current system does not support the appointed inspect item(taskid:$taskid)!"
            WRITE_XML_COMMON 0 "INFO:The current system does not support the appointed inspect item(taskid:$taskid)!"
        fi
        WRITE_XML_SUBCMD_TAIL >/dev/null
        WRITE_XML_CMD_TAIL >/dev/null
        WRITE_XML_TAIL $taskid >/dev/null
    }
    done
    wait
}

# **************************************************************************** #
# Function Name: checkSoftwareStatusEx
# Description: Software мչ.
# Parameter: $1 cmditemID
# Return:
# **************************************************************************** #
checkSoftwareStatusEx()
{
    local check_id=$1
    #ȡеĺIPִ
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    #ȡǰڵipַ
    local MainNodeIP=$( get_backnet_ip )
    #Զ̽ڵȡϢѲ ¿б inspect_map.shļʼ
    #Ҫ޸Ѳ
    #no_group_taskids="501 502"
    #normal_remote_taskids="157 253 274 293 294 295 296 297 298 299 301 302 313 315 317 318 319 320 321 322 323 407 501 502"
    #quality_remote_taskids="350 351 352 354 358 359"
    #ֻڱؽڵͿԻȡѲ
    #normal_local_taskids="270 316 357"
    #quality_local_taskids="353 355 356"
    #needcheck_quality_taskids="350 351 352 353 354 355 356 358 359"
    #needcheck_normal_taskids="157 253 270 274 293 294 295 296 297 298 299 301 302 313 315 316 317 318 319 320 321 322 323 407"
    #齨checkitemsִвʽ壨InspectFun1-param1-param2-param3 inspectFun2-param1-param2-param3 ...)
 
    Params=""
    #ݵǰidжϳ
    if [[ "$no_group_taskids" =~ "${check_id}" ]];then  #޸Ѳ飬
        local_taskids=""
        remote_taskids="${check_id}"
    elif [[ "${needcheck_quality_taskids}" =~ "${check_id}" ]];then
        local_taskids="${quality_local_taskids}"
        remote_taskids="${quality_remote_taskids}"
    elif [[ "${needcheck_normal_taskids}" =~ "${check_id}" ]];then
        local_taskids="${normal_local_taskids}"
        remote_taskids="${normal_remote_taskids}"
    else
        local_taskids="${normal_local_taskids} ${quality_local_taskids}"
        remote_taskids="${normal_remote_taskids} ${quality_remote_taskids}"
    fi
    for REMOTE_IP in $REMOTE_IP_S
    do
    {
        if [ "$REMOTE_IP" = "$MainNodeIP" ]; then
            local_exec_cmd "$local_taskids $remote_taskids" "$Params" "$MainNodeIP"
        else
            alltask="${remote_taskids}"
            if [ "$MainNodeIP" = "" ]; then
                alltask="$local_taskids ${remote_taskids}"
            fi
            exec_cmd "${REMOTE_IP}" "${alltask}" "$Params"
            sleep 2
            download_result "${REMOTE_IP}"
            if [ $? -ne 0 ]; then    #ʧܣһ
                LOG "Download Result first time failed try again!"
                exec_cmd "${REMOTE_IP}" "${alltask}" "$Params"
                sleep 2
                download_result "${REMOTE_IP}"
                if [ $? -ne 0 ];then
                    LOG "Download Result second time failed return!"
                    echo "download result second time failed"
                fi
            fi
        fi
    }&
    done
    wait
    analyse_local_result "${local_taskids}" "$MainNodeIP"
    analyse_result "${remote_taskids}"
}
##end add

