#!/bin/bash
set +x

# ********************************************** ***************************** #
# File Name: inspect_software.sh
# Description: ѲĿе״̬.
# Input:
# Output:
# Author:
# Created: 2013-01-16
# Function List
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #

G_SCRIPT_PATH="/opt/inspect"
dos2unix $G_SCRIPT_PATH/inspect_lib.sh > /dev/null 2>&1
dos2unix $G_SCRIPT_PATH/inspect_map.sh > /dev/null 2>&1
. $G_SCRIPT_PATH/inspect_lib.sh
. $G_SCRIPT_PATH/inspect_map.sh

G_TMP_FILE="$G_SCRIPT_PATH/tmpfile$$"
G_REMOTE_TMP_FILE="/tmp/tmpfile$$"
G_TMP_FILE2="$G_SCRIPT_PATH/tmpfilex$$"
G_REMOTE_TMP_FILE2="/tmp/tmpfilex$$"

IP_ROLE_FILE="/tmp/tmp_ip_role"

G_UNKNOWN_PROTO="Unknown protocol type"
G_CMD_FAILED="Execute command failed!"
LOG_FILE="/var/log/inspect.log"
LOG_FILE_BAK="/var/log/inspect_1.log"

VALID_IP_FILE="/tmp/tmp_valid_ip$$"
VALID_IP_FILE2="/tmp/tmp_valid_ip2"
VALID_IP_FILE3="/tmp/tmp_valid_ip3"

export G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"
. $G_MML_FILE_PATH/CommonFunc.sh
CM_DB="/opt/huawei/snas/etc/cm_conf.db"
RepeatTimes=(1 2 3)

FIFO_OPERATE_ID=759
FIFO_THREAD_NUM_MAX=60
RPC_REFER_CNT_MAX=20

G_SEPARATOR="-----------------------------------------------------------------------------"

RPC_REFER_PROC_FILE="/proc/sys/internalrpc/rpc_req_leak"
RPC_REFER_CNT_KEY="The leaked requests are found"

G_GET_REPLICATION_INFO="/opt/huawei/snas/script/inspect_mml/GetReplicationInfo"

###add 2016-09-12 Ѳ¿ܣѲ270-275#################
G_REMOTE_EXEX_RESULT="/tmp/tmpfileRemoteResult$$"
G_LOCAL_EXEX_RESULT="/tmp/tmpfileLocalResult$$"
G_DOWNLOAD_FILE="/tmp/inspect_downloadfile$$"
G_MML_INSPECT_HEAD=$G_MMLEX_FILE_PATH"/inspect_head"
G_MML_INSPECT=$G_MMLEX_FILE_PATH"/inspect"
###end add#

function LOG
{
   time=$(date)
   echo [${time}][$$]$@ >> $LOG_FILE
}

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

#ʹfifoܵ, ʵֶ̲, Ҫ׼ VALID_IP_FILE
function fifo_start
{
    trap "exec $FIFO_OPERATE_ID>&-;exec $FIFO_OPERATE_ID<&-;exit 0" 2

    mkfifo remoteFifo
    eval "exec $FIFO_OPERATE_ID<>remoteFifo"
    rm -rf remoteFifo

    local num=0
    for Item in $VALID_IP_FILE; do
        num=$((num+1))
    done

    local threadNum=$FIFO_THREAD_NUM_MAX
    if [ $threadNum -gt $num ]; then
        threadNum=$num
    fi

    for ((i=0;i<$threadNum;i++))
    do
        eval "echo >& $FIFO_OPERATE_ID"
    done
}

function fifo_finish
{
    eval "exec $FIFO_OPERATE_ID>&-"
    eval "exec $FIFO_OPERATE_ID<&-"
}

function check_pass()
{
    local list=(["2"]=0 ["1"]=1 ["4"]=2 ["0"]=3 ["3"]=4) #δ(2)>ͨ(1)>Ż(4)>ͨ(0)>漰(3)
    local isPass=$1   #Ⱥ
    local tmpIsPass=$2 #ǰ

    if [ ${list[$tmpIsPass]} -lt ${list[$isPass]} ];then
        isPass=$tmpIsPass
    fi
    echo $isPass
}

function check_symbolic()
{
    local desPath=$1
    if [ -L ${desPath} ];then
        return 0
    else
        return 1
    fi
}

function get_nlunmap()
{
    local result_log=/var/log/nluninfo.log
    #ȡIP
    local back_ip=`get_backnet_ip`
    if [ "$back_ip" = "" ]; then
        errResult="INFO:Can't get back IP."
        LOG "[$FUNCNAME][${LINENO}]:$errResult"
        WRITE_XML_ERROR 0 "INFO:Can't get back IP."
        return 1
    fi

    nlunready=0
    #ڵǷ񶼼뵽nlunmapУ15sһΣ4ΣҲ1ӡѲ칤ÿȴ5
    waitcount=0
    while [ $waitcount -lt 4 ]
    do
        #Ƚ/var/log/nluninfo.log
        >${result_log}

        $G_MML_FILE_PATH/ShowInspectMml $back_ip 988 "monc nluninfo 0"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME][${LINENO}]mml_result:$Info"
            WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:Failed to execute command(MmlBatch 988 'monc nluninfo 0'). Error(${iRet})."
            nlunready=0
            return 1
        fi

        #ȡеnodepoolǷÿnodepoolеĽڵ㶼nlun(ֻҪһnodepoolеĽڵnlunУnodepoolеĽڵ㶼nlun)
        allNodePool=`cat /proc/monc_tiermap | grep "nodepool id" | awk -F: '{print $2}'`
        for tmpNodePool in $allNodePool
        do
            nlunready=0
            frontIpInPool=`cat /proc/monc_tiermap | grep -A16 "nodepool id :$tmpNodePool" | grep "node :" | sed 's/node : *//'`
            if [ "$frontIpInPool" = "" ];then
                LOG "[$FUNCNAME][${LINENO}]:nodepool:$tmpNodePool no node."
                nlunready=1
            fi
            allBackIp=""
            allDsId=""
            #nodepoolǰipdsmapǺipҪǰipҶӦĺipٸݺipdsid
            for tmpfront in $frontIpInPool
            do
                tmpBackIp=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=(select NID from CM_NODE_IP_T where IP_ADDR=\"$tmpfront\") and SUBNET_ID=1"`
                allBackIp=${allBackIp}" "${tmpBackIp}
                for tmpip in $tmpBackIp
                do
                    dsIdQuery=`cat /proc/monc_dsmap | grep "$tmpip" | awk '{print $2}'`
                    allDsId=${allDsId}" $dsIdQuery"
                done
            done

            for dsid in $allDsId
            do
                grep "($dsid" ${result_log} > /dev/null
                if [ $? -eq 0 ];then
                    LOG "[$FUNCNAME][${LINENO}]:ds $allDsId is in nlunmap"
                    nlunready=1
                    break
                fi
            done
            #ǰnodepoolеĽڵ㶼mapУΪmapҪ
            if [ $nlunready -ne 1 ];then
                LOG "[$FUNCNAME][${LINENO}]:ds $allDsId is not in nlunmap"
                break
            fi
        done

        #nodepoolдpoolнڵ㶼ûnlunУ˵nlunûãȴһʱ
        if [ $nlunready -ne 1 ];then
            sleep 15
            let "waitcount=$waitcount+1"
        else
            break;
        fi
    done

    #nlun״̬ǲǳɹ˵βѯʧˣ󷵻ʧܼ
    if [ $nlunready -ne 1 ];then
        WRITE_XML_ERROR 0 "INFO:Nodes $allBackIp have no nlunmap."
        return 1
    else
        return 0
    fi
}

#ԶִͬУip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        LOG "[$FUNCNAME][${LINENO}]:IP:$remote_ip,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

#ԶִǷ
function remote_exec_checkfini
{
    local remote_ip=$1
    local le_pid="$$$2"
    local exe_cmd=$3

    for time in ${RepeatTimes[*]}; do
        local proresult=`/opt/huawei/deploy/script/localexec.py progress $remote_ip $le_pid`
        local iRet=$?
        if [ $iRet -eq 101 ] || [ $iRet -eq 107 ] || [ "X${proresult}" == "X" ]; then
            LOG "[$FUNCNAME][${LINENO}]:IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},Return:$iRet,TryTimes:$time"
            sleep 10
        else
            break
        fi
    done
    local process=`echo $proresult | awk '{print $1}'`
    local errno=`echo $proresult | awk '{print $4}'`

    if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
        return 0    #ѯִгɹԶû
    elif [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME][${LINENO}] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},exec(get progress) failed.iRet($iRet)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to query. if command(${exe_cmd}) was finished or not. Error(${iRet})."
        if [ $iRet -eq 106 ];then
            return 125 # timeout=125
        fi
        return 1    #ѯִʧ
    elif [ $iRet -eq 0 ] && [ "$process" = "100" ] && [ "$errno" = "0" ] ;then
        LOG "[$FUNCNAME][${LINENO}] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid}, exec(get progress) success.iRet($iRet),errno($errno),process($process)"
        return 2    #ɹɣ˴Ҫ0Ϊɹ
    elif [ "$errno" != "0" ] && [ "$errno" != "" ];then
        LOG "[$FUNCNAME][${LINENO}] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},exec(get progress) failed.iRet($iRet) errno($errno)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to query. if command(${exe_cmd}) was finished or not. Errno(${errno})."
        if [ "$errno" = "106" ]; then
            return 125 # timeout=125
        fi
        return 3    #Զִʧ
    elif [ "$process" = "" ] && [ "$errno" = "" ];then
        LOG "[$FUNCNAME][${LINENO}] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid}, exec(get progress) failed.process(null), ip not accessed"
        return 5    #ʱ
    elif [ "$process" = "" ] || [ "$errno" = "" ];then
        LOG "[$FUNCNAME][${LINENO}] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},exec(get progress) failed.process(null)"
        return 0    #ݴ
    else
        LOG "[$FUNCNAME][${LINENO}]IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid}, exec(get progress) failed. Undefined error info"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to query. if command(${exe_cmd}) was finished or not. Progress(${process})."
        return 4    #δ
    fi
}

#Զ첽ִУip/pid/timeout/cmd
function remote_exec_async
{
    local remote_ip=$1
    local le_pid="$$$2"
    local time_out=$3
    local cmd=$4
    local iRet=0
    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py async $remote_ip $le_pid $time_out true "$cmd"
        iRet=$?
        LOG "[${FUNCNAME}][$LINENO]:IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},Return:$iRet,TryTimes:$time,CMD:${cmd}"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
    fi
    done
    return $iRet
}

#һѽڵ첽ִУҪ׼ REMOTE_IP_S
function remote_exec_async_batch
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}

    local ret=0
    local Num=0
    for Item in $REMOTE_IP_S; do
        Num=$((Num+1))
        if [ "$[Num%20]" = "0" ];then
            sleep 5
        fi
        remote_exec_async $Item $1 $2 "$3"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME][${LINENO}] Node: $Item,item:${G_CHECK_IDLIST}||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command($3). Error(${iRet})."
            ret=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done
    #˴sleepΪ˷ֹ첽ִнڵδִɾͿʼˣɾ
    sleep 5
    return $ret
}

#Զ̵MML
function remote_exec_async_batch_mml
{
    #ĿǰȡдļķʽЧIP
    >${VALID_IP_FILE}
    local ret=0
    local Num=0
    for Item in $REMOTE_IP_S; do
        Num=$((Num+1))
        if [ "$[Num%20]" = "0" ];then
            sleep 5
        fi
        remote_exec_async $Item $1 $2 "$G_MML_FILE_PATH/$3 $Item > $G_REMOTE_TMP_FILE$4 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME] Node: $Item,item:${G_CHECK_IDLIST}||Error: ${iRet}"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command(/opt/product/snas/script/inspect_mml/$3 $Item). Error(${iRet})."
            ret=1
        else
            echo -n "$Item " >> ${VALID_IP_FILE}
        fi
    done
    #˴sleepΪ˷ֹ첽ִнڵδִɾͿʼˣɾ
    sleep 5
    return $ret
}

function remote_download_sync
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    for time in ${RepeatTimes[*]}; do
        /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
        iRet=$?
        LOG "[$FUNCNAME][${LINENO}] download $remote_file from $remote_ip to $local_file item:${G_CHECK_IDLIST} Return:$iRet TryTimes:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $local_file 2>&1
            break
        fi
    done

    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        LOG "[$FUNCNAME][${LINENO}] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi
    return $iRet
}

function remote_download
{
    local remote_ip=$1
    local local_file=$2
    local remote_file=$3
    local iRet=0
    local iRmRet=0

    eval "read -u $FIFO_OPERATE_ID"
    {
        for time in ${RepeatTimes[*]}; do
            /opt/huawei/deploy/script/localexec.py download $remote_ip $local_file $remote_file
            iRet=$?
            LOG "[$FUNCNAME][${LINENO}] download $remote_file from $remote_ip to $local_file item:${G_CHECK_IDLIST} Return:$iRet TryTimes:$time"
            if [ $iRet -eq 101 ]; then
                sleep 10
            else
                sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $local_file 2>&1
                break
            fi
        done

        eval "echo >& $FIFO_OPERATE_ID"
    }

    remote_exec $remote_ip 30 "$G_MML_FILE_PATH/ClearTmpFile $remote_file"
    iRmRet=$?
    if [ $iRmRet -ne 0 ]; then
        LOG "[$FUNCNAME][${LINENO}] rm ($remote_file) from ($remote_ip) iRmRet:($iRmRet)"
    fi
    return $iRet
}

#ȡڵһõĺIP
function get_backnet_ip
{
    local snas_ini_file="/opt/huawei/snas/etc/snas.ini"
    local IpIndex=1
    local subnetwork_id
    local BackendIp
    local IpNum
    IpNum=`cat ${snas_ini_file} | grep "ipaddr_" | wc -l`

    while [ "$IpIndex" -le "$IpNum" ]; do
        subnetwork_id=`grep "subnetwork_id_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
        if [ -z "${subnetwork_id}" ]; then
            break
        fi

        if [ ${subnetwork_id} -eq 1 ]; then
            BackendIp=`grep "ipaddr_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
            ping "${BackendIp}" -f -c 2 -w 2 >/dev/null 2>&1
            if [ $? -ne 0 ]; then
                IpIndex=$((IpIndex + 1))
                continue
            else
                echo ${BackendIp}
                break
            fi
        fi

        IpIndex=$((IpIndex + 1))
    done
}

#ȡȺDFSڵһIP
function get_dfs_backnet_ip
{
    local dfs_nid=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select NID from CM_NODE_T where (Reserved2 = 0 OR Reserved2 = 1)")
    local dfs_ip=$(get_node_backnet_ip "${dfs_nid}")

    echo $dfs_ip
    return 0
}

#Զ˷أ[ERR]ʶ
handle_remote_result()
{
    local line=$1
    echo "$line" |grep "\[ERR\]" > /dev/null
    if [ $? -eq 0 ]; then
        echo "$line" | awk -F] '{print $2}'
        return 1
    fi

    echo "$line"
    return 0
}

#ȡָڵһIP
function get_node_backnet_ip
{
    local nid=$1
    local temp=1
    local iRet=0
    local IpNum=0
    local BackendIp=""
    IpNum=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select COUNT(*) from (select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID);"`
    if [ "$IpNum" -eq 0 ]; then
        LOG "[$FUNCNAME][${LINENO}]There is no back subnet IP of $nid in db"
        return 1
    fi

    while [ "$temp" -le "$IpNum" ];
    do
        BackendIp=`sqlite3 /opt/huawei/snas/etc/cm_conf.db "select IP_ADDR from CM_NODE_IP_T where NID=$nid and SUBNET_ID=1 order by NID limit $((temp - 1)), $temp;"`
        if [ "$BackendIp" = "" ]; then
            LOG "[$FUNCNAME][${LINENO}] Get back ip of $nid failed"
            temp=$((temp + 1))
            continue
        else
            #try ping
            ping "${BackendIp}" -f -c 2 -w 2 >/dev/null 2>&1
            if [ $? -ne 0 ]; then
                temp=$((temp + 1))
                continue
            else
                break
            fi
        fi
    done
    echo ${BackendIp}
}

function get_valid_back_ip_by_dsid()
{
    local ds_id=$1
    local back_ip=""
    local back_ips=""
    local i=1
    local cnt=0

    back_ip=`grep "DS $ds_id " /proc/monc_dsmap|awk '{print $14}'`
    back_ips=`sqlite3 ${CM_DB} "select IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 and NID=(select NID from CM_NODE_IP_T where SUBNET_ID=1 and IP_ADDR=\"$back_ip\" limit 1)"`
    cnt=`echo "$back_ips" | wc -l`
    while [ "$i" -le "$cnt" ]
    do
        back_ip=`echo "$back_ips" | awk NR==$i'{print $1}'`
        #try ping
        for time in ${RepeatTimes[*]};do
            ping_result=`ping -q -c 1 $back_ip  | grep received | awk '{print $4}'`
            local iRet=$?
            if [ $iRet -ne 0 ];then
                sleep 10
            else
                break
            fi
        done

        if [ "$ping_result" != 0 ];then
            echo "$back_ip"
            return
        fi

        i=$((i + 1))
    done
}

#201. ڵ
checkNodeThroughput()
{
    WRITE_XML_SUBCMD_HEADER $1

    local errResult=""
    local isPass=0
    local CmdPort=4016
    local numCnt=1
    local iRet

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="INFO:Can't get back IP."
            LOG "[$FUNCNAME][${LINENO}]:$errResult"
            isPass=1
            break
        fi

        $G_MML_FILE_PATH/ShowInspectMml $back_ip $CmdPort "cm nodeopsinfo"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ "${iRet}" -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME][${LINENO}]mml_result:($Info)"
            errResult="Node:${back_ip}||INFO:Failed to execute command(MmlBatch 4016 'cm nodeopsinfo'). Error(${iRet})."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME

        #
        set_ifs
        nodeCount=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "nodeopsinfo:" | wc -l`
        if [ $nodeCount -le 0 ]; then
            errResult="INFO:Get 'nodeopsinfo' from output(MmlBatch 4016 'cm nodeopsinfo') failed."
            LOG "[$FUNCNAME][${LINENO}]:$errResult"

            isPass=1
            restore_ifs
            break
        fi

        while [ $numCnt -le $nodeCount ]; do

            NID=`cat $G_REMOTE_TMP_FILE$FUNCNAME| grep "nodeopsinfo:" | awk NR==$numCnt |awk '{print $3}'`
            CifsOps=`cat $G_REMOTE_TMP_FILE$FUNCNAME| grep "nodeopsinfo:" | awk NR==$numCnt |awk '{print $6}'`
            NfsOps=`cat $G_REMOTE_TMP_FILE$FUNCNAME| grep "nodeopsinfo:" | awk NR==$numCnt |awk '{print $9}'`

            numCnt=$((numCnt+1))
            Nodeip=`get_node_backnet_ip $NID`

            service_type=$(get_service_type_from_db "${Nodeip}")
            if [ "${service_type}" != "1" ]; then
                LOG "service_type = ${service_type}.skip ${Nodeip}."
                continue
            fi

            if [ "$NID" == "" ] || [ "$CifsOps" == "" ] || [ "$NfsOps" == "" ];then
                if [ -z "${errResult}" ]; then
                    errResult="Node:$Nodeip||INFO:Get 'nodeopsinfo' from output(MmlBatch 4016 'cm nodeopsinfo') failed."
                else
                    errResult="${errResult}||Node:$Nodeip||INFO:Get 'nodeopsinfo' from output(MmlBatch 4016 'cm nodeopsinfo') failed."
                fi
                WRITE_XML_COMMON 0 "Node:${Nodeip:---}||NID:${NID:---}||Cifs_Ops:${CifsOps:---}||Nfs_Ops:${NfsOps:---}"
                LOG "[$FUNCNAME][${LINENO}]:$errResult"
                isPass=1
                continue
            fi

            if [ "$CifsOps" -gt 25000 ] || [ "$NfsOps" -gt 20000 ]; then
                if [ -z "${errResult}" ]; then
                    errResult="Node:$Nodeip||INFO: OPS exceeds threshold."
                else
                    errResult="${errResult}||Node:$Nodeip||INFO: OPS exceeds threshold."
                fi
                isPass=1
            fi

            LOG "[$FUNCNAME][${LINENO}]:Node:$Nodeip||NID:$NID||Cifs_Ops:$CifsOps||Nfs_Ops:$NfsOps"
            WRITE_XML_COMMON 0 "Node:$Nodeip||NID:$NID||Cifs_Ops:$CifsOps||Nfs_Ops:$NfsOps"

        done

        restore_ifs
        break
    done

    if [ "$isPass" != "0" ];then

        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1

        WRITE_XML_ERROR 0 "${errResult}"
        WRITE_XML_JUDGE 1
    else
        WRITE_XML_JUDGE 0
    fi

    WRITE_XML_SUBCMD_TAIL
}

checkIOPerform()
{
    rcount=`cat $G_TMP_FILE$Item |grep '<read count>' |sed "s/[^0-9]//g"`
    wcount=`cat $G_TMP_FILE$Item |grep '<write count>' |sed "s/[^0-9]//g"`
    ccount=`cat $G_TMP_FILE$Item |grep '<cmd count>' |sed "s/[^0-9]//g"`
    rbytes=`cat $G_TMP_FILE$Item |grep '<read bytes>' |sed "s/[^0-9]//g"`
    wbytes=`cat $G_TMP_FILE$Item |grep '<write bytes>' |sed "s/[^0-9]//g"`
    maxcalldelay=`cat $G_TMP_FILE$Item |grep '<max call delay(ms)>' |sed "s/[^0-9]//g"`
    maxreaddelay=`cat $G_TMP_FILE$Item |grep '<max read delay(ms)>' |sed "s/[^0-9]//g"`
    maxwritedelay=`cat $G_TMP_FILE$Item |grep '<max write delay(ms)>' |sed "s/[^0-9]//g"`
    totalcmddelay=`cat $G_TMP_FILE$Item |grep '<total cmd delay(ms)>' |sed "s/[^0-9]//g"`
    totalreaddelay=`cat $G_TMP_FILE$Item |grep '<total read delay(ms)>' |sed "s/[^0-9]//g"`
    totalwritedelay=`cat $G_TMP_FILE$Item |grep '<total write delay(ms)>' |sed "s/[^0-9]//g"`

    result="IP:$2||Protocol:$1||CheckType:IO perform||Read count:${rcount}||Write count:${wcount}||Cmd count:${ccount}"
    result=${result}"||Read bytes:${rbytes}||Write bytes:${wbytes}"
    result=${result}"||max call delay(ms):${maxcalldelay}||max read delay(ms):${maxreaddelay}||max write delay(ms):${maxwritedelay}"
    result=${result}"||total cmd delay(ms):${totalcmddelay}||total read delay(ms):${totalreaddelay}||total write delay(ms):${totalwritedelay}"
    echo $result

    if [[ ${maxreaddelay} -gt 50000 ||  ${maxwritedelay} -gt 50000 || ${maxcalldelay} -gt 50000 ]];then
        LOG "[$FUNCNAME][${LINENO}]$1 $2 maxreaddelay($maxreaddelay) or maxwritedelay($maxwritedelay) or maxcalldelay(${maxcalldelay}) over 50 !"
        return 1
    fi

    return 0
}

#208. license״̬
checkLicenseStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local iRet=0

    while true; do

        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            LOG "[$FUNCNAME][${LINENO}]:INFO: Can't get local ip"
            isPass=1
            WRITE_XML_ERROR 0 "INFO:Can't get local IP."
            break
        fi

        #ִmml cm licensecfg
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm licensecfg"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME][${LINENO}]mml_result:$Info"
            WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:Failed to execute command(MmlBatch 4016 'cm licensecfg'). Error(${iRet})."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1

        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "get license res cfg fail"`
        if [ "$Info" != "" ];then
            #һжǷмlicenseļ
            WRITE_XML_COMMON 0 "INFO:License is not activated."
            break
        fi

        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "acFeatureName"|sed 's/^ *//g'|sed "/^$/d"`

        if [ "$javaID" = "" ];then
            LOG "[$FUNCNAME][${LINENO}]:$line,javaID is null"
            WRITE_XML_COMMON 0 "INFO:No license resource active."
            break
        fi

        set_ifs
        for line in $javaID
        do
            if [ "$line" = "" ];then
                continue
            fi
            #ʽacFeatureName : WiseQuota || acLicRunTime : 1375113600000 || uiResLKVal : 10.
            #ʽacFeatureName : WiseLink || acLicRunTime : 1375113600000 || uiResLKVal : 10.
            #ʽacFeatureName : WiseTier || acLicRunTime : 1375113600000 || uiResLKVal : 10.

            Feature=`echo $line |awk '{print $3}'`
            MaxNumber=`echo $line |awk '{print $11}'|sed 's/\./ /g'`
            Deadline=`echo $line |awk '{print $7}'`
            LOG "[$FUNCNAME][${LINENO}]:Deadline:$Deadline"
            if [ "${Deadline}" == "9999-12-31" ];then
                date1=$(date --date "${Deadline}" +%s)
                Deadline="PERMANENT"
            else
                date1=`expr $Deadline \/ 1000`
                Deadline=`date --date "1970-01-01 UTC $date1 seconds" +"%Y-%m-%d %T %z"`
            fi
            LOG "[$FUNCNAME][${LINENO}]:Deadline:$Deadline"
            date2=`date`

            t1=$date1
            t2=`date --date "$date2" +%s`
            LOG "[$FUNCNAME][${LINENO}]:Deadline:$t1,CurrentTime:$t2"

            LOG "[$FUNCNAME][${LINENO}]:$line"

            if [ $t1 -gt $t2 ]; then
                LOG "[$FUNCNAME][${LINENO}]:$Deadline > $date2"
                Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline"
                LOG "[$FUNCNAME][${LINENO}]:Result($Result)"
                WRITE_XML_COMMON 0 "$Result"
            elif [ $t1 -eq $t2 ]; then
                LOG "[$FUNCNAME][${LINENO}]:$Deadline == $date2"
                Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline"
                LOG "[$FUNCNAME][${LINENO}]:Result($Result)"
                WRITE_XML_COMMON 0 "$Result"
            else
                LOG "[$FUNCNAME][${LINENO}]:$Deadline < $date2"
                isPass=1
                LOG "[$FUNCNAME][${LINENO}]:isPass:$isPass"

                Result="Feature:$Feature||MaxNumber:$MaxNumber||DeadLine:$Deadline"
                LOG "[$FUNCNAME][${LINENO}]:Result($Result)"
                WRITE_XML_COMMON 0 "$Result"
                WRITE_XML_ERROR 0 "INFO: Feature:${Feature} is expired."
            fi
        done
        restore_ifs

        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#һΧڵ
function ProduceRandom()
{
    min=$1
    max=$2-$1
    num=$(date +%s+%N)
    ((retnum=num%max+min))
    echo $retnum
}

#NASЭ    ӵĿͻ    ͻIP/Э            NASЭ
#NASȺ״̬                            CM
#wiselink    ״̬                    NASЭ
#    OPS                            NASЭ

checkNASClient()
{
    local Item=$1
    local res=$(cat $G_TMP_FILE$Item)
    if [ "${res}" == "Does not involve" ];then
        LOG "res:${res}"
        result="$res"
        return 0
    fi

    client_ip=`cat $G_TMP_FILE$Item |grep "ip_clnt"|awk -F">" '{print $2}'| awk -F"<" '{print $1}'`
    client_num=`cat $G_TMP_FILE$Item |grep "ip_clnt"|awk -F">" '{print $2}'| awk -F"<" '{print $1}'|wc -l`
    client_protocal=`cat $G_TMP_FILE$Item |grep "proto_type"| sed 's/[^A-Z]//g'`
    result="LocalIp:$1||client_num:${client_num}||client_type:$2"

    info=`cat $G_TMP_FILE$Item`
    LOG "[$FUNCNAME][${LINENO}] $1 ,info:$info"
    LOG "client_num:$client_num"

    if [ ${client_num} -gt 400 ];then
        LOG "[$FUNCNAME][${LINENO}]$1 ${client_protocal} client num(${client_num}) over 400!"
        echo $result
        return 1
    else
        echo "LocalIp:$1||client_num:$client_num||client_type:$2"
    fi
}

#===================================================
# ƣȡcm_conf.dbнڵӦķ
# ܣ
# 
#===================================================
function get_service_type_from_db()
{
    local temp=1
    local ip=$1
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do

        LOG "[$FUNCNAME][${LINENO}]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    local service_type=$(/usr/bin/sqlite3 ${CM_DB} "select Reserved2 from CM_NODE_T where NID='${nid}'" | tr -d ' ')
    while [[ "${service_type}" == "" ]]
    do

        LOG "[$FUNCNAME][${LINENO}]Failed to get service_type from db ,temp=$temp"
        service_type=$(/usr/bin/sqlite3 ${CM_DB} "select Reserved2 from CM_NODE_T where NID='${nid}'" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done

    echo ${service_type}
}
#===================================================
# ƣȡcm_conf.dbнڵӦIP
# ܣͨڵĺIPݿжϵǰڵIPV4 or IPV6
# 
#===================================================
function get_frontip_type()
{
    local temp=1
    local ip=$1
    local FrontIP=""
    local iret=0
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do

        LOG "[$FUNCNAME][${LINENO}]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    #ȡڵһǰIP
    local FrontIP=$(/usr/bin/sqlite3 ${CM_DB} "select IP_ADDR from CM_NODE_IP_T where NID='${nid}' and SUBNET_ID=2 limit 1" | tr -d ' ')
    while [[ "${FrontIP}" == "" ]]
    do

        LOG "[$FUNCNAME][${LINENO}]Failed to get FrontIP from db ,temp=$temp"
        FrontIP=$(/usr/bin/sqlite3 ${CM_DB} "select IP_ADDR from CM_NODE_IP_T where NID='${nid}' and SUBNET_ID=2 limit 1" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    #IPûðűʾIPV4
    echo $FrontIP|grep -q "\:" > /dev/null
    iret=$?
    echo ${iret}
}

#===================================================
# ƣȡcm_conf.dbнڵӦĽڵ
# ܣͨڵĺIPݿȡڵ
# 
#===================================================
function get_node_hostname_from_db()
{
    local temp=1
    local ip=$1
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do

        LOG "[$FUNCNAME][${LINENO}]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    local hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
    while [[ "${hostname}" == "" ]]
    do

        LOG "[$FUNCNAME][${LINENO}]Failed to get node hostname from db ,temp=$temp"
        hostname=$(/usr/bin/sqlite3 ${CM_DB} "select HOSTNAME from CM_NODE_T where NID='${nid}'" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done

    echo ${hostname}
}

#212. ̿ռʹ    DSṩ̿ռʹ
checkDSUsage()
{
    WRITE_XML_SUBCMD_HEADER $1
    Result=""
    local isPass=0
    local nodePoolId=0
    local diskPoolAll=""
    local nodeUsedCap=0
    local diskPoolUsedCap=0
    local diskPoolTotalCap=0
    local CalResult=0
    local L_TMP_FILE="/tmp/tmpfile_checkDSUsage"
    local L_LINE_FILE="/tmp/tmplinefile_checkDSUsage"
    local L_TOTALCAP_FILE="/tmp/l_totalcapfile_checkDSUsage"
    local L_TMP_TOTALCAP_FILE="/tmp/tmptotalcapfile_checkDSUsage"
    local L_TMP_INFO_FILE="/tmp/l_tmpinfofile_checkDSUsage"
    local L_IP_NUMBER_FILE="/tmp/l_ipnumberfile_checkDSUsage"
    local L_IP_FILE="/tmp/l_ipfile_checkDSUsage"
    local path_list="${L_TMP_FILE} ${L_LINE_FILE} ${L_TOTALCAP_FILE} ${L_TMP_TOTALCAP_FILE} ${L_TMP_INFO_FILE} $L_IP_NUMBER_FILE ${L_IP_FILE}"
    for tmp_path in ${path_list}
    do
        check_symbolic ${tmp_path}
        if [ $? -eq 0 ];then
            rm -f ${tmp_path}
        fi
    done
    >$L_TOTALCAP_FILE
    >$L_IP_FILE
    cat /proc/monc_dsmap > $L_TMP_FILE 2>&1
    iRet=$?
    if [ $iRet -ne 0 ]; then
        Info=$( cat $L_TMP_FILE )
        Result="INFO:exec(cat /proc/monc_dsmap) failed!errno($iRet)||Error:$Info"
        LOG "[$FUNCNAME]$Item exec(cat /proc/monc_dsmap) failed!errno($iRet),${Info}"
        isPass=1
        WRITE_XML_ERROR 0 "$Result"
    else
        set_ifs
        dos2unix $L_TMP_FILE
        ips=($(cat $L_TMP_FILE | grep -w IpAddr | awk '{print $14}'))
        #IP
        cat $L_TMP_FILE | grep -w "IpAddr" | awk '{print $14}'| awk -F "." '{print $1 $2 $3 $4}' > $L_IP_NUMBER_FILE 2>&1
        ipnumber=($(cat -n $L_IP_NUMBER_FILE | sort -nk 2 | awk '{print $1}'))
        #ȡк
        LineArr1=($(cat $L_TMP_FILE | awk '/IpAddr/{print NR}'))
        LineArr2=($(cat $L_TMP_FILE | grep -n "\-\-\-\-\-\-\-\-\-\-" | awk -F ":" '{print $1}'))
        for i in ${ipnumber[*]}
        do
            i=$((i-1))
            distance=$((${LineArr2[i]}-${LineArr1[i]}-1))
            cat $L_TMP_FILE | grep -A${distance} -w ${ips[i]} > $L_TMP_INFO_FILE
            cat $L_TMP_INFO_FILE | grep TotalCap > $L_TMP_TOTALCAP_FILE
            IPAddress="$( cat $L_TMP_INFO_FILE | grep IpAddr | awk '{print $14}' )"
            nodePoolId="$( cat $L_TMP_INFO_FILE | grep IpAddr | awk '{print $4}' )"
            sed -i 's/$/& '$IPAddress'/g' $L_TMP_TOTALCAP_FILE
            sed -i 's/$/& '$nodePoolId'/g' $L_TMP_TOTALCAP_FILE
            cat $L_TMP_TOTALCAP_FILE | sort -nk 2 >> $L_TOTALCAP_FILE
            echo $IPAddress >> $L_IP_FILE
        done

        diskPoolAll=$( cat $L_TOTALCAP_FILE | sed 's/^ *//g' | sed "/^$/d" | grep DiskPool | awk '{print $6}' | sort -n | uniq )
        for diskPoolId in $diskPoolAll
        do
            diskPoolUsedCap=0
            diskPoolTotalCap=0
            local maxCap=0
            local minCap=0
            local maxCapIp=""
            local minCapIp=""
            local maxRate=0
            local minRate=101
            local maxId=101
            local minId=101
            local maxRateIp=""
            local minRateIp=""
            local nodeTotalCap=0
            local maxNodeTotalCap=0
            local maxNodeTotalCapIP=""
            for ip in $(cat $L_IP_FILE)
            do
                nodeUsedCap=0
                nodeTotalCap=0
                diskinfo=$(cat $L_TOTALCAP_FILE | sed 's/^ *//g' | sed "/^$/d" | grep "DiskPool $diskPoolId" | awk -v vip="$ip" '{if (vip == $(NF - 1)){print $0}}')
                if [ "x" != "x${diskinfo}" ];then
                    for line in $diskinfo
                    do
                        local usedRate=0
                        local id=$( echo $line | awk '{print $2}' )
                        local totalCap=$( echo $line | awk '{print $10}' )
                        local freeCap=$( echo $line | awk '{print $12}' )
                        local usedCap=$( expr $totalCap \- $freeCap )
                        if [ $totalCap -eq 0 ];then
                            usedRate=0
                        else
                            usedRate=$( echo "$usedCap $totalCap" | awk '{printf("%.2f",$1 * 100 / $2)}' )
                        fi
                        #λֽתGB
                        usedCap=$( expr $usedCap / 1073741824 )
                        nodeUsedCap=$( expr $nodeUsedCap \+ $usedCap )
                        totalCap=$( expr $totalCap / 1073741824 )
                        nodeTotalCap=$( expr $nodeTotalCap \+ $totalCap )
                        nodePoolId=$( echo $line | awk '{print $18}' )
                        if [ $(echo "${usedRate} > ${maxRate}"|bc) -eq 1 ]; then
                            maxRate=$usedRate
                            maxId=$id
                            maxRateIp=$ip
                        fi
                        if [ $(echo "${usedRate} < ${minRate}"|bc) -eq 1 ]; then
                            minRate=$usedRate
                            minId=$id
                            minRateIp=$ip
                        fi
                        WRITE_XML_COMMON 0 "IP:$ip||PoolID:${id}||UsedCapacity(GB):$usedCap||UsedRate:${usedRate}%||DiskPool:$diskPoolId||NodePool:--||averageRate:--||maxRate:--||minRate:--"
                    done

                    if [ $nodeUsedCap -gt $maxCap ]; then
                        maxCap=$nodeUsedCap
                        maxCapIp=$ip
                    fi
                    if [ $nodeTotalCap -gt $maxNodeTotalCap ]; then
                        maxNodeTotalCap=$nodeTotalCap
                        maxNodeTotalCapIP=$ip
                    fi
                    if [ $minCap -eq 0 -o $nodeUsedCap -lt $minCap ]; then
                        minCap=$nodeUsedCap
                        minCapIp=$ip
                    fi
                    diskPoolUsedCap=$( expr $diskPoolUsedCap \+ $nodeUsedCap )
                    diskPoolTotalCap=$( expr $diskPoolTotalCap \+ $nodeTotalCap )

                    LOG "[$FUNCNAME]ip:$ip DiskPool:$diskPoolId NodePool:$nodePoolId totalCap:$totalCap freeCap:$freeCap usedCap:$usedCap maxCap:$maxCap minCap:$minCap"
                    WRITE_XML_COMMON 0 "IP:$ip||PoolID:--||UsedCapacity(GB):$nodeUsedCap||UsedRate:--||DiskPool:$diskPoolId||NodePool:$nodePoolId||averageRate:--||maxRate:--||minRate:--"
                fi
            done
            
            if [ $diskPoolTotalCap -eq 0 ];then
                avgRate=0
                continue
            else
                avgRate=$( printf "%.2f\n" $( echo "scale=2;$diskPoolUsedCap * 100 / $diskPoolTotalCap"|bc -l ) )
            fi
            LOG "[$FUNCNAME]DiskPool:$diskPoolId diskPoolTotalCap(GB):$diskPoolTotalCap diskPoolUsedCap(GB):$diskPoolUsedCap avgRate:$avgRate"
            WRITE_XML_COMMON 0 "IP:--||PoolID:--||UsedCapacity(GB):$diskPoolUsedCap||UsedRate:--||DiskPool:$diskPoolId||NodePool:$nodePoolId||averageRate:${avgRate}%||maxRate:${maxRate}%||minRate:${minRate}%"

            #ֵ
            CalResult=$( expr $maxCap \- $minCap )
            local nodeTotalCapPer3=$(echo "$maxNodeTotalCap * 3 / 100" | bc)
            local nodeTotalCapPer5=$(echo "$maxNodeTotalCap * 5 / 100" | bc)
            LOG "[$FUNCNAME]Data capacity difference(GB):$CalResult DiskPool:$diskPoolId NodePool:$nodePoolId maxNodeTotalCapIP:$maxNodeTotalCapIP maxNodeTotalCap:$maxNodeTotalCap nodeTotalCapPer3:$nodeTotalCapPer3 nodeTotalCapPer5:$nodeTotalCapPer5"
            if [ $(echo "${CalResult} > ${nodeTotalCapPer5}"|bc) -eq 1 ]; then
                isPass=$(check_pass ${isPass} 1)
                WRITE_XML_ERROR 0 "Node:--||INFO:Diskpool($diskPoolId) used capacity difference(${CalResult} GB) exceeds 5% of TotalCap($nodeTotalCapPer5). (Node:$maxCapIp,${maxCap}GB; Node:$minCapIp,${minCap}GB)"
            elif [ $(echo "${CalResult} > ${nodeTotalCapPer3}"|bc) -eq 1 ]; then
                isPass=$(check_pass ${isPass} 4)
                WRITE_XML_ERROR 0 "Node:--||INFO:Diskpool($diskPoolId) used capacity difference(${CalResult} GB) exceeds 3% of TotalCap($nodeTotalCapPer3). (Node:$maxCapIp,${maxCap}GB; Node:$minCapIp,${minCap}GB)"
            fi

            local CalRate=$( echo "$maxRate $minRate" | awk '{printf("%.2f",$1 - $2)}' )
            if [ $(echo "$CalRate > 10"|bc) -eq 1 ] || [ $(echo "$maxRate >= 80"|bc) -eq 1 ]; then
                isPass=$(check_pass ${isPass} 4)
                WRITE_XML_ERROR 0 "Node:--||INFO:Single disk usage in Diskpool($diskPoolId) differs by more than 10%, or max usage is more than 80%. (RateDiff:${CalRate}; Node:${maxRateIp},PoolId:${maxId},${maxRate}%; Node:${minRateIp},PoolId:${minId},${minRate}%)"
            fi
        done
        restore_ifs
    fi

    # L_TOTALCAP_FILEļиʽId 4 State Normal DiskPool 2 Type 1 TotalCap 897620639744 FreeCap 896044580864 DiskUtil 0 FaultTime 0 ${IPAddress} 1
    while read backip
    do
        grep -w ${backip} ${L_TOTALCAP_FILE} >${L_TOTALCAP_FILE}.${backip}
        # Type 0 ĴSSDһΪ̵ģȥSSD
        grep "Type 0" ${L_TOTALCAP_FILE}.${backip} >/dev/null 2>&1
        if [ $? -eq 0 ]; then
            DiskPoolId=$( grep "Type 0" ${L_TOTALCAP_FILE}.${backip} | head -1 | awk '{print $6}' )
        fi
        diskpoolCnt=$( cat ${L_TOTALCAP_FILE}.${backip} | awk '{print $6}' | sort | uniq  | wc -l )
        if [ ${diskpoolCnt} -gt 1 ]; then
            # ڵϴdiskpoolôSSD̹ɵĴ̳ģǵֻһdiskpoolType0˵ȫ滷
            egrep -v "(Type 0 |DiskPool ${DiskPoolId} )" ${L_TOTALCAP_FILE}.${backip} >${L_TOTALCAP_FILE}.${backip}.tmp
            if [ ! -s "${L_TOTALCAP_FILE}.${backip}.tmp" ]; then
                rm -f ${L_TOTALCAP_FILE}.${backip} ${L_TOTALCAP_FILE}.${backip}.tmp
                continue
            fi

            mv ${L_TOTALCAP_FILE}.${backip}.tmp ${L_TOTALCAP_FILE}.${backip}
        fi

        # дС̻ĻֱӱŻзͳһ
        diskSizeCnt=$( cat ${L_TOTALCAP_FILE}.${backip} | awk '{print $10}' | sort | uniq | wc -l )
        if [ ${diskSizeCnt} -ne 1 ]; then
            isPass=$(check_pass ${isPass} 4)
            WRITE_XML_ERROR 0 "Node:${backip}||INFO:has ${diskSizeCnt} types of data disks with different capacities."
        fi

        diskSize=$( cat ${L_TOTALCAP_FILE}.${backip} | head -1 | awk '{print $10}' )
        nodeTotalCap=$( cat ${L_TOTALCAP_FILE}.${backip} | awk '{sum+=$10}END{if(NR>0){printf "%d", sum}else{printf "%d",0}}' )
        nodeFreeCap=$( cat ${L_TOTALCAP_FILE}.${backip} | awk '{sum+=$12}END{if(NR>0){printf "%d", sum}else{printf "%d",0}}' )
        nodeUsedCap=$((nodeTotalCap-nodeFreeCap))

        # 1̻ᳬ97.5%Ѳ첻ͨڱȽϣ975 
        damagOneDiskCapPercent=$( echo "scale=4;${nodeUsedCap} * 1000 / (${nodeTotalCap} - ${diskSize})" | bc | awk -F. '{print $1}'  )
        if [ X${damagOneDiskCapPercent} != X"" -a ${damagOneDiskCapPercent} -ge 975 ]; then
            WRITE_XML_ERROR 0 "Node:${backip}||INFO:If a disk is damaged, the node capacity usage will exceed 97.5%."
            isPass=$(check_pass ${isPass} 1)
            continue
        fi

        # 2̻ᳬ97.5%ŻڱȽϣ975 
        damagTwoDiskCapPercent=$( echo "scale=4;${nodeUsedCap} * 1000 / (${nodeTotalCap} - ${diskSize} - ${diskSize})" | bc | awk -F. '{print $1}'  )
        if [ X${damagTwoDiskCapPercent} != X"" -a ${damagTwoDiskCapPercent} -ge 975 ]; then
            WRITE_XML_ERROR 0 "Node:${backip}||INFO:If two disk is damaged, the node capacity usage will exceed 97.5%."
            isPass=$(check_pass ${isPass} 4)
            continue
        fi
    done <${L_IP_FILE}

    rm -rf $L_TMP_FILE $L_LINE_FILE $L_TOTALCAP_FILE $L_TMP_TOTALCAP_FILE $L_TMP_INFO_FILE $L_IP_NUMBER_FILE $L_IP_FILE ${L_TOTALCAP_FILE}*
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

hextoip() {
    hex=$1
    local length=`echo $hex |wc -c`
    if [ $length -lt 8 ] || [ $length -gt 9 ]; then
        printf "0"
        return
    fi
    if [ $length -eq 9 ]; then
        printf "%d." 0x${hex:0:2}
        printf "%d." 0x${hex:2:2}
        printf "%d." 0x${hex:4:2}
        printf "%d"  0x${hex:6:2}
    else
        printf "%d." 0x${hex:0:1}
        printf "%d." 0x${hex:1:2}
        printf "%d." 0x${hex:3:2}
        printf "%d"  0x${hex:5:2}
    fi
}

mdsMasterIP1=""
mdsMasterIP2=""
#ȡLeaderкIP
function getMdsMasterIps()
{

    mdsMasterIP1=""
    mdsMasterIP2=""
    local isPass=0
    local TASK_ID=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local service_type=0
    for Item in ${REMOTE_IP_S}; do
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            continue
        fi
        if [ "${ValidIP}" = "" ]; then
            ValidIP="${Item}"
        else
            ValidIP="${ValidIP} ${Item}"
        fi
    done

    #˵漰ĽڵԶʱļ
    REMOTE_IP_S=${ValidIP}
    excCmd="/opt/product/snas/script/inspect_mml/GetMdsSubtreeInfo"
    remote_exec_async_batch_mml $TASK_ID 30 GetMdsSubtreeInfo $FUNCNAME
    isPass=$?

    sleep 5
    ValidIP=`cat ${VALID_IP_FILE}`
    while [[ ${ValidIP} != "" ]]
    do
        >${VALID_IP_FILE}
        for Item in $ValidIP
        do
            isDfs=1
            remote_exec_checkfini $Item $TASK_ID "${excCmd} ${Item}"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                sleep 1
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=1
                LOG "[$FUNCNAME][${LINENO}]:Node: $Item||INFO: excute check cmd failed."
                continue
            fi

            #Ϊ100%֮ļأн
            remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command(${excCmd} ${Item}). Error(${iRet})."
                isPass=1
                continue
            fi

            sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $G_TMP_FILE$Item >/dev/null 2>&1

            MDSMaster1=`cat $G_TMP_FILE$Item | grep "root mds ip"|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
            if [ "$MDSMaster1" == "" ];then
                isPass=1
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Get 'root mds ip' from output(${excCmd} ${Item}) failed."
                break
            fi

            #16ƵַʽתΪipv4͵ַ
            mdsMastertmp1=$MDSMaster1
            mdsMasterIP1=`hextoip "${mdsMastertmp1}"`
            LOG "[$FUNCNAME][${LINENO}]mdsMasterIP1:$mdsMasterIP1"
            if [ "$mdsMasterIP1" == "" ];then
                LOG "[$FUNCNAME][${LINENO}]:Get 'root mds ip' from output(${excCmd} ${Item}) failed, get masterIp($mdsMastertmp1) err."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Get 'root mds ip' from output(${excCmd} ${Item}) failed."
                isPass=1
                break
            fi

            MDSMaster2=`cat $G_TMP_FILE$Item | grep "root mds 2nd ip"|awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d"`
            if [ "$MDSMaster2" == "" ];then
                isPass=1
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Get 'root mds 2nd ip' from output(${excCmd} ${Item}) failed."
                break
            fi

            #16ƵַʽתΪipv4͵ַ
            mdsMastertmp2=$MDSMaster2
            mdsMasterIP2=`hextoip "${mdsMastertmp2}"`
            LOG "[$FUNCNAME][${LINENO}]mdsMasterIP2:$mdsMasterIP2"
            if [ "${mdsMasterIP2}" == "" ];then
                LOG "[$FUNCNAME][${LINENO}]:Failed to execute command(${excCmd} ${Item}),get masterIp($mdsMastertmp2) err."
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Get 'root mds 2nd ip' from output(${excCmd} ${Item}) failed."
                isPass=1
                break
            fi
            >${VALID_IP_FILE}
            break
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done
}
#216. ϵͳinodeBirth--
checkFileInodeAndBirthCount()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local faildInfo=""
    local MDSMaster=""
    local errResult=""
    local usedCapRate=0
    local exe_result1=""
    local exe_result2=""
    local exe_result3=""
    local exe_result4=""
    local exe_result5=""
    local exe_result6=""
    local exe_result7=""
    local tmpResult=""
    local CurInodeCount=0
    local MaxInodeCount=0
    local FileInodeCount=0
    local SysBirthCount=""
    local inodeRate=0
    local MDSMemory=0
    local ratio=0
    local maxBirthMem=0
    local maxBirthCount=0
    local safeBirthCount=0
    local isArchive=0
    local value1=0
    local value2=0
    local dfsNodeCnt=0
    local iRet
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )

    for Item in $REMOTE_IP_S
    do
        #1.checkڵԼDFSڵĸ
        local service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" == "1" ];then
            dfsNodeCnt=$((dfsNodeCnt+1))
        else
            LOG "[$FUNCNAME][${LINENO}]: $Item is not DFS node."
            continue
        fi
    done
    if [ ${dfsNodeCnt} -eq 0 ];then
        isPass=3
        LOG "[$FUNCNAME][${LINENO}]:There is no DFS node."
        WRITE_XML_COMMON 0 "There is no DFS node. Do not involve to inspect."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    get_cluster_lite_deploy
    if [ $? -eq 0 ]; then
        isPass=3
        LOG "[$FUNCNAME][${LINENO}]:There is lite node, so 'not involve'."
        WRITE_XML_COMMON 0 "This is lite node. Do not involve to inspect."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    while true; do
        back_ip=$( get_backnet_ip )
        if [ "$back_ip" = "" ];then
            isPass=1
            LOG "[FUNCNAME] Can't to get the backIP."
            WRITE_XML_ERROR 0 "Node:(master)||INFO:Can't get back IP."
            break
        fi
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm system" >$G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ "${iRet}" -ne 0 ];then
            Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            LOG "[FUNCNAME] mml_result : $Info"
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to execute command(MmlBatch 4016 'cm system'). Error(${iRet})"
            isPass=1
            break
        else
            dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
            content=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            if [ "$content" == "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Get infomation from output(MmlBatch 4016 'cm system') failed."
                break
            else
                #usedCapRate = Cluster_Used_Capacity / Cluster_Capacity * 100
                Cluster_Capacity=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Capacity"|awk -F: '{print $2}' )
                Cluster_Used_Capacity=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Used_Capacity"|awk -F: '{print $2}' )
                usedCapRate=$(echo ""|awk -v x=${Cluster_Used_Capacity} -v y=${Cluster_Capacity} '{printf("%0.2f",x*100/y)}')
                cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
            fi
        fi
        mdsMasterIP=$( cat /proc/monc_leader | grep Mds | awk '{print $3}' )
        if [ "no" = "${mdsMasterIP}" ]; then
            LOG "[$FUNCNAME][${LINENO}]:There is no mdsMasterIP in the S3 nodes"
            WRITE_XML_COMMON 0 "There is no DFS master."
            break;
        fi
        #DFS ȡLeaderMdsĺIps
        getMdsMasterIps
        #MDS leader
        mdsMasterIP=$mdsMasterIP1
        LOG "[$FUNCNAME][${LINENO}]mdsMasterIP:$mdsMasterIP  dfsNodeCnt:${dfsNodeCnt}"
        if [ "$mdsMasterIP" = "" ];then
            LOG "[$FUNCNAME][${LINENO}]:Failed to execute function getMdsMasterIps,get masterIp err."
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to get MDS master IP."
            isPass=1
            break;
        fi

        #MDSִMMLinode, ִmml "mds info show" 'mds show lru'
        remote_exec $mdsMasterIP 60 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds show lru' > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
        iRet0=$?
        remote_exec $mdsMasterIP 30 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds info show' >> $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
        iRet1=$?
        if [ $iRet0 -ne 0 -o $iRet1 -ne 0 ];then
            #ڵ2Ipִmml
            if [ "$mdsMasterIP2" = "" ]; then
                LOG "[$FUNCNAME][${LINENO}]:return($iRet0)($iRet1)"
                errResult="Node:$mdsMasterIP||INFO:Failed to execute command(MmlBatch 988 'mds show lru';MmlBatch 988 'mds info show'). Error(${iRet0}, ${iRet1})."
                WRITE_XML_ERROR 0 "${errResult}"
                isPass=1
                break
            fi
            mdsMasterIP=$mdsMasterIP2
            remote_exec $mdsMasterIP 60 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds show lru' > $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
            iRet0=$?
            remote_exec $mdsMasterIP 30 "$G_MML_FILE_PATH/ShowInspectMml $mdsMasterIP 988 'mds info show' >> $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
            iRet1=$?
        fi

        if [ $iRet0 -ne 0 -o $iRet1 -ne 0 ]; then
            LOG "[$FUNCNAME][${LINENO}]:return($iRet0)($iRet1) "
            errResult="Node:$mdsMasterIP||INFO:Failed to execute command(MmlBatch 988 'mds show lru';MmlBatch 988 'mds info show'). Error(${iRet0}, ${iRet1})."
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
        fi

        #
        remote_download_sync $mdsMasterIP $G_TMP_FILE $G_REMOTE_TMP_FILE2$FUNCNAME
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME][${LINENO}]download inode infp from $mdsMasterIP fail"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command(MmlBatch 988 'mds info show';MmlBatch 988 'mds show lru'). Error(${iRet})."
            break
        fi

        exe_result1=$( cat $G_TMP_FILE | grep '\(Cur Inode Count in Cluster\)\|\(Sys Inode Count\)' | dos2unix )
        exe_result2=$( cat $G_TMP_FILE | grep '\(Max Inode Count Support by Cluster\)' | dos2unix )
        exe_result3=$( cat $G_TMP_FILE | grep '\(Sys File Inode Count\)' | dos2unix )
        exe_result4=$( cat $G_TMP_FILE | grep '\(Sys Birth Count\)' | dos2unix )
        # 7.1.1ԼԺ汾MDSģʱռõڴֵ
        exe_result5=$( cat $G_TMP_FILE | grep "pstMemStat\->ullContiguousMemSizeWhenStarting"| dos2unix )
        exe_result6=$( cat $G_TMP_FILE | grep "\(Sys Dir Inode Count\)"| dos2unix )
        # MDSģpool[0]ڴشС
        exe_result7=$( cat $G_TMP_FILE | grep "Pool\[0\] Init free  size"| dos2unix )
        LOG "[$FUNCNAME][${LINENO}]exe_result1:$exe_result1"
        LOG "[$FUNCNAME][${LINENO}]exe_result2:$exe_result2"
        LOG "[$FUNCNAME][${LINENO}]exe_result3:$exe_result3"
        LOG "[$FUNCNAME][${LINENO}]exe_result4:$exe_result4"
        LOG "[$FUNCNAME][${LINENO}]exe_result5:$exe_result5"
        LOG "[$FUNCNAME][${LINENO}]exe_result6:$exe_result6"
        LOG "[$FUNCNAME][${LINENO}]exe_result7:$exe_result7"
        if [ "$exe_result1" == "" -o "$exe_result2" == "" -o "$exe_result3" == "" -o "$exe_result4" == "" -o "$exe_result5" == "" -o "$exe_result6" == "" -o "$exe_result7" == "" ];then
           errResult="Node:$mdsMasterIP||INFO:Get Inode information from output(MmlBatch 988 'mds info show';MmlBatch 988 'mds show lru') failed."
           WRITE_XML_ERROR 0 "${errResult}"
           isPass=1

           #
           cat $G_TMP_FILE >> $LOG_FILE 2>&1
           break
        else

            CurInodeCount=$( echo $exe_result1 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            MaxInodeCount=$( echo $exe_result2 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            FileInodeCount=$( echo $exe_result3 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            SysBirthCount=$( echo $exe_result4 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            SysDirInodeCount=$( echo $exe_result6 | awk -F: '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            #inodeRate = Sys Inode Count / Max Inode Count Support by Cluster * 100
            inodeRate=$(echo ""|awk -v x=${CurInodeCount} -v y=${MaxInodeCount} '{printf("%0.2f",x*100/y)}')
            LOG "[$FUNCNAME][${LINENO}],CurInodeCount:$CurInodeCount||MaxInodeCount:$MaxInodeCount||usedCapRate(%):$usedCapRate||inodeRate(%):$inodeRate||SysBirthCount:$SysBirthCount"

            if [ $(echo "$inodeRate > 90" | bc) -eq 1 ] && [ $(echo "$inodeRate > $usedCapRate" | bc) -eq 1 ];then
                isPass=1
                errResult="Node:$mdsMasterIP||INFO:Inode percentage(${inodeRate}) exceeds the threshold(90) and exceeds the used capacity percentage($usedCapRate)."
                WRITE_XML_ERROR 0 "${errResult}"
            fi
            #ȡ7.1.1Լ汾MDSʹõڴֵ
            MdsUsedMemSize=$( echo $exe_result5 | awk -F"=" '{print $2}'|sed 's/^ *//g'|sed "/^$/d")
            # ȡڵMDS pool[0]ڴشС
            MdsPool0MemSize=$( echo $exe_result7 | awk -F"=" '{print $2}'|sed 's/^ *//g'|sed "/^$/d" )
            MdsMemForBirth=$((MdsPool0MemSize-MdsUsedMemSize))
            LOG "[$FUNCNAME][${LINENO}]MdsUsedMemSize:${MdsUsedMemSize} MdsPool0MemSize:${MdsPool0MemSize} MdsMemForBirth:${MdsMemForBirth}."

            # ȡmdsʹֵ
            #ȡȺĲ,ΪСļ(serviceType=archive)Ĭratio=58,ĬΪ 40
            serviceType=$( cat /opt/huawei/snas/etc/snas.ini |grep "serviceType=")
            isArchive=$( cat /opt/huawei/snas/etc/snas.ini |grep "serviceType=archive" | wc -l)
            if [ ${isArchive} -eq 1 ]; then
                ratio=$( grep sys_birth_mem_ratio_for_massive /opt/huawei/snas/static/mds.ini | awk -F= '{print $2}' | grep -o [0-9]* )
                if [ X"${ratio}" == X"" ]; then
                    ratio=58
                fi
            else
                ratio=$( grep sys_birth_mem_ratio_for_others /opt/huawei/snas/static/mds.ini | awk -F= '{print $2}' | grep -o [0-9]* )
                if [ X"${ratio}" == X"" ]; then
                    ratio=40
                fi
            fi

            pool0ratio=$( grep sys_birth_mem_max_ratio_in_pool0 /opt/huawei/snas/static/mds.ini | awk -F= '{print $2}' | grep -o [0-9]* )
            if [ X"${pool0ratio}" == X"" ]; then
                    pool0ratio=75
            fi
            LOG "INFO: ${serviceType} so ratio is ${ratio},pool0ratio is ${pool0ratio}."

            # 㼯ȺBirthЧڴ
            ullBirthTotalMemMax1=$(echo ""|awk -v x=${MdsMemForBirth} -v y=${ratio} -v z=${dfsNodeCnt} '{printf("%0.0f", (x * y + x*y/(z-1)) / 100)}')
            # 㼯ȺBirthЧڴ,MDSڴֵΪ75
            ullBirthTotalMemMax2=$( echo ""|awk -v x=${MdsPool0MemSize} -v y=${pool0ratio} '{printf("%0.0f", x * y / 100)}' )
            # Mdsٿõڴ
            [ ${ullBirthTotalMemMax1} -gt ${ullBirthTotalMemMax2} ] && ullMinMdsBirthMemSize=${ullBirthTotalMemMax2} || ullMinMdsBirthMemSize=${ullBirthTotalMemMax1}
            # 㼯ȺMdsԤڿɲBirth,ݿÿbirthĴСΪ32ֽ
            clsMaxBirthCount=$( echo ""|awk -v x=${ullMinMdsBirthMemSize} -v y=${dfsNodeCnt} '{printf("%0.0f", x/32 * y)}' )
            LOG "[$FUNCNAME][${LINENO}]ullBirthTotalMemMax1:${ullBirthTotalMemMax1} ullBirthTotalMemMax2:${ullBirthTotalMemMax2} ullMinMdsBirthMemSize:${ullMinMdsBirthMemSize}."
            LOG "[$FUNCNAME][${LINENO}]clsMaxBirthCount:${clsMaxBirthCount}."
            # Ԥ⼯Ⱥﵽ90%ʱʹõbirth, ԤƼȺBirthCount=(SysBirthCount)*(90/usedCapRate)
            maybeBirthInodeCnt=$( echo ""|awk -v x=${SysBirthCount} -v y=${usedCapRate} '{printf("%d", 90 * x / y)}' )
            # xΪʹʴﵽ90%birth,(x+x/(nodeCount-1))>=maxBirthMemѲ첻ͨ
            calValue=$( echo ""|awk -v x=${maybeBirthInodeCnt} -v y=${dfsNodeCnt} -v z=${clsMaxBirthCount} '{printf("%d", (x+x/(y-1)) >= z)}' )
            if [ ${calValue} -eq 1 ]; then
                isPass=1
                errResult="Node:$mdsMasterIP||INFO:When the cluster capacity usage reaches 90%, the number of birthInode count may be insufficient."
                WRITE_XML_ERROR 0 "${errResult}"
            fi

            #  maybeBirthInodeCnt >= 10000000000()Ѳ첻ͨ
            if [ ${maybeBirthInodeCnt} -ge 10000000000 ];then
                isPass=1
                errResult="Node:$mdsMasterIP||INFO:may90CapUsedBirthInodeCnt(${maybeBirthInodeCnt}) >= 10000000000."
                WRITE_XML_ERROR 0 "${errResult}"
            fi
	    
	    Result="CurInodeCount:$CurInodeCount||ClsSupportMaxInodeCnt:$MaxInodeCount||usedCapRate(%):$usedCapRate||inodeRate(%):$inodeRate||SysBirthCount:$SysBirthCount || clsMayMaxBirthCount:${clsMaxBirthCount} ||may90CapUsedBirthInodeCnt:${maybeBirthInodeCnt}||SysDirInodeCount:${SysDirInodeCount}"
            local serviceType=$(cat /opt/huawei/snas/etc/snas.ini  | grep "^serviceType=" | awk -F'=' '{print $2}')
            if [ "${serviceType}" = "other" ];then
                serviceType="default"
            fi
            if [ "${serviceType}" = "archive" ];then
                if [ "x${ctnr_policy}" = "x0" ];then
                    isPass=$(check_pass $isPass 1)
                    errResult="Node:$mdsMasterIP||INFO:serviceType=${serviceType}; ctnr_policy=0."
                    WRITE_XML_ERROR 0 "${errResult}"
                fi
            fi
            if [ "${serviceType}" = "media" ] || [ "${serviceType}" = "default" ];then
                local holdLimit=30000000
                if [ "${serviceType}" = "media" ];then
                    holdLimit=20000000
                fi
                if [ ${CurInodeCount} -gt $(echo "${nodeCount}*${holdLimit}"|bc -l) ];then
                    isPass=$(check_pass $isPass 4)
                    errResult="Node:$mdsMasterIP||INFO:serviceType=${serviceType}; Cur Inode Count($CurInodeCount) > nodeNum(${nodeCount}) * ${holdLimit}."
                    WRITE_XML_ERROR 0 "${errResult}"
                fi
            fi
        fi
        break
    done

    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#217 AD״̬
checkADDomain()
{
    WRITE_XML_SUBCMD_HEADER $1
    local join_state="no"
    local Result=""
    local isPass=0
    local checkInfo=""
    local checkResult="--"
    local errResult=""
    local tmpResult=""
    local dfsIP=""
    local iRet=0
    local checkVersion="103"
    local splitWord="7.1.1.SPH"
    local product_version=$( grep "^ExternalVersion" /opt/huawei/deploy/package/version |awk -F"=" '{print $2}' |tr -d " " )

    #SFS û
    if [[ "$product_version" =~ "V100R006C10" ]];then
        isPass=0
        LOG "[$FUNCNAME][${LINENO}]:It's SFS ${product_version}. No need to inspect."
        WRITE_XML_COMMON 0 "It's SFS ${product_version}. No need to inspect."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    if [[ "$product_version" =~ "V100R006C30" ]];then
        checkVersion="902"
        splitWord="V100R006C30SPH"
    fi
    REMOTE_IP_S=$( cat $IP_ROLE_FILE )
    for Item in $REMOTE_IP_S
    do
        #1.checkڵ
        local service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" == "1" ];then
            dfsIP="${Item}"
            break
        else
            LOG "[$FUNCNAME][${LINENO}]: $Item is not DFS node."
            continue
        fi
    done
    if [ "X${dfsIP}" = "X" ];then
        isPass=0
        LOG "[$FUNCNAME][${LINENO}]:There is no DFS node."
        WRITE_XML_COMMON 0 "There is no DFS node. No need to inspect."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    while true; do
        #DFSڵִִ "nas_proto_auth -c show-join" Զִͬ Խڱļ
        /opt/huawei/deploy/script/localexec.py cmd ${dfsIP} 30 false "$G_MML_FILE_PATH/nas_checkADdomainControllerStatus checkADDomain" > $G_TMP_FILE${dfsIP} 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME][${LINENO}]:return($iRet) "
            errResult="Node:${dfsIP}||INFO:Failed to execute command(nas_proto_auth -c show-join). Error(${iRet})."
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
            break
        else
            checkInfo=$( cat $G_TMP_FILE${dfsIP} | grep "join_state:yes" )
            if [ "X$checkInfo" != "X" ];then
                join_state="yes"
                info=$(cat $G_TMP_FILE${dfsIP} | grep "HotPatchCheck:Have no HotPatch")
                if [ "X${info}" = "X" ]; then
                    version=$(cat $G_TMP_FILE${dfsIP} | grep "HotPatchCheck:" | awk -F: '{print $2}')
                    cmpVersion=$(echo $version | awk -F"${splitWord}" '{print $2}')
                    if [ "$cmpVersion" -lt "$checkVersion" ];then
                        #汾Ҫ汾
                        isPass=1
                        checkResult="HotPatch $version version is less than recommended version $splitWord$checkVersion."
                        WRITE_XML_ERROR 0 "Node:${dfsIP}||JOINED_DOMAIN:${join_state}||HotPatchCheck:${checkResult}"
                    else
                        #Ҫ
                        checkResult="HotPatch $version status is confirm ok.Recommended version is ${splitWord}$checkVersion."
                        WRITE_XML_COMMON 0 "Node:${dfsIP}||JOINED_DOMAIN:${join_state}||HotPatchCheck:${checkResult}"
                    fi
                else
                    #ûЧĲ
                    isPass=1
                    checkResult="Have no HotPatch is confirm ok.Recommended version is ${splitWord}$checkVersion or later."
                    WRITE_XML_ERROR 0 "Node:${dfsIP}||JOINED_DOMAIN:${join_state}||HotPatchCheck:${checkResult}"
                fi
            else
                #δAD
                WRITE_XML_COMMON 0 "Node:${dfsIP}||JOINED_DOMAIN:$join_state||HotPatchCheck:${checkResult}"
            fi
        fi
        break
    done
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#219. NIS
checkNIS()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local TASK_ID=0
    local NisInfo=0
    local isExistFlag=0;
    local ypwhichinfo=""
    local errinfo=""
    local nisIp=""
    local pingResult=""
    local pingTag="ping"
    local pingCompare=0
    local masterFlag=0 #ǵһϷNIS server ipִpingΪ1Ϊ1ʾýڵipִйping
    local pline="p"

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "REMOTE_IP_S:$REMOTE_IP_S"

    for Item in $REMOTE_IP_S; do
        #checkڵͣDFSִ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            continue
        fi

        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowNisServer > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?

        remote_download_sync $Item $G_REMOTE_TMP_FILE$FUNCNAME$Item $G_REMOTE_TMP_FILE$FUNCNAME
        downCon=$(cat $G_REMOTE_TMP_FILE$FUNCNAME$Item)
        LOG "[$FUNCNAME][${LINENO}]node:$Item, remote_exec NisServer iRet: $iRet, downCon: ${downCon}"

        if [ $iRet -ne 0 ] || [ "x${downCon}" == "x" ]; then
            continue
        fi

        set_ifs
        while read line; do
            info=`handle_remote_result "$line"`
            if [ $? -ne 0 ]; then
                WRITE_XML_ERROR 0 "Node:$Item||INFO:${info}"
                isPass=1
                continue
            fi

            #жǷnis server
            NisInfo=`echo $info | grep "no nis_server"`
            if [ "$NisInfo" != "" ];then
                isExistFlag=1
            fi

            nisIpArr=$(echo $info|awk -F'(' '{print $2}'|awk -F')' '{print $1}')

        done < $G_REMOTE_TMP_FILE$FUNCNAME$Item
        restore_ifs

        break
    done

    #
    LOG "[$FUNCNAME][${LINENO}]:isPass:$isPass,isExistFlag:$isExistFlag"
    cat $G_REMOTE_TMP_FILE$FUNCNAME$Item >> $LOG_FILE 2>&1

    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        #checkڵͣDFSִ
        local service_type=$(get_service_type_from_db "${Item}")
        if [ "${service_type}" != "1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            WRITE_XML_COMMON 0 "Node:$Item||DFS:No||NisIP:--||nis_server status:--"
            continue
        fi

        if [ "$isExistFlag" -eq 1 -a "${service_type}" == "1" ];then
            Result="Node:$Item||DFS:Yes||NisIP:--||nis_server status:no nis_server"
            WRITE_XML_COMMON 0 "$Result"
        fi

        echo -n "$Item " >> ${VALID_IP_FILE}
    done

    if [ "$isPass" -eq 0 ] && [ "$isExistFlag" -eq 0 ];then

        #Զִypwhich鿴
        ValidIP=$(cat "${VALID_IP_FILE}")

        for Item in $ValidIP
        do

            #鿴ÿڵ
            ypwhichinfo=$(remote_exec $Item 10 "ypwhich")
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME][${LINENO}] $Item Failed to execute(free) command.iRet($iRet)"
                isPass=1

                Result="Node:$Item||DFS:Yes||NisIP:$nisIp||nis_server status:Unknown"
                WRITE_XML_COMMON 0 "$Result"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command(ypwhich). Error(${iRet})."
                continue
            fi

            errinfo=""
            errinfo=$(echo $ypwhichinfo | grep "Can't communicate with ypbind")
            if [ "$errinfo" != "" ]; then

                LOG "[$FUNCNAME][${LINENO}]errinfo:$errinfo"
                Result="Node:$Item||DFS:Yes||NisIP:$nisIp||nis_server status:Can't communicate with ypbind."
                WRITE_XML_COMMON 0 "$Result"
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Can't communicate with ypbind."
                isPass=1
            else
                Result="Node:$Item||DFS:Yes||NisIP:$ypwhichinfo||nis_server status:OK"
                WRITE_XML_COMMON 0 "$Result"
            fi

        done
    fi

    if [ "$isPass" -eq 0 ] && [ "$isExistFlag" -eq 0 ];then

        #Զִping
        for Item in $ValidIP
        do
            remote_exec $Item 30 "> $G_REMOTE_TMP_FILE$FUNCNAME$pingTag  2>&1"
            for nisItem in $nisIpArr; do
                remote_exec $Item 30 "$G_MML_FILE_PATH/ShowPingResult $nisItem >> $G_REMOTE_TMP_FILE$FUNCNAME$pingTag  2>&1; exit 0"
            done
        done

        #Զping
        ValidIPResult=$ValidIP
        LOG "[$FUNCNAME][${LINENO}][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
        fifo_start
        for Item in $ValidIP
        do
            remote_download $Item $G_TMP_FILE$pingTag$Item $G_REMOTE_TMP_FILE$FUNCNAME$pingTag
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command(/opt/product/snas/script/inspect_mml/ShowPingResult $nisItem). Error(${iRet})."
                continue
            fi
        done

        wait
        fifo_finish

        for Item in $ValidIPResult; do
            fifoContext=`cat $G_TMP_FILE$pingTag$Item`
            if [ "$fifoContext" = "" ];then
                continue
            fi

            nisCnt=0
            masterFlag=0
            for nisIp in $nisIpArr
            do
                nisCnt=$((nisCnt+1))

                pingResult=$(sed -n $nisCnt$pline $G_TMP_FILE$pingTag$Item)
                if [ "$pingResult" == "" ];then
                    if [ $masterFlag -eq 0 ]; then
                        isPass=1
                    elif [ $masterFlag -eq 1 -a $isPass -eq 0 ]; then
                        isPass=4
                    fi
                    errResult="Node: $Item||INFO:Ping ${nisIp} fail."
                    WRITE_XML_ERROR 0 "$errResult"
                else
                    pingCompare=$(echo "$pingResult >= 200" | bc)
                    if [ $pingCompare -eq 1 ];then
                        if [ $isPass -eq 0 ]; then
                            isPass=4
                        fi
                        errResult="Node: $Item||INFO:Delay of ping ${nisIp} is too large."
                        WRITE_XML_ERROR 0 "$errResult"
                    fi
                fi

                if [ $masterFlag -eq 0 ]; then
                    masterFlag=1
                fi
            done
        done

    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#220 ⲿDNSǷͨ
checkExtDnsConn()
{
    WRITE_XML_SUBCMD_HEADER $1

    local TASK_ID=0
    local isPass=0
    local dfsFlag=0
    local AllDnsService=""
    local DnsNum=0
    local errResult=""
    local Result=""
    local Item=""
    local ValidIP=""
    local extDnsServe=""
    local serverConn=""
    local pingResult=""
    local numCnt=1
    local pingTag="ping"
    local pingCompare=0
    local DnsCnt=0
    local service_type=0
    local ipflag=0
    local frontiptype=0
    local FLAG=1
    local isOMnetflag=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="INFO:Can't get back IP."
            WRITE_XML_ERROR 0 "$errResult"
            LOG "[$FUNCNAME][${LINENO}]:$errResult"
            isPass=1
            break
        fi
        AllDnsService=`cat /etc/resolv.conf | grep ^nameserver | awk '{print $2}' | grep -E '^[0-9a-fA-F:.]+$'`
        #ȡⲿDNSûΪͨ
        DnsNum=`echo "$AllDnsService" | wc -l`
        #ڵS3ڵ漰

        LOG "[$FUNCNAME][${LINENO}]:AllDnsService:$AllDnsService,DnsNum:$DnsNum"
        if [ "$DnsNum" -le "0" ] || [ "$AllDnsService" == "" ] ;then
            FLAG=0
            Result="Node:--||DFS:--||DNS_server:--||DNS server status:No DNS server"
            WRITE_XML_COMMON 0 "$Result"
            cat /etc/resolv.conf >>  $LOG_FILE
            break
        fi
        local netflag=0 #ǰIPֻIPV4IPV6ַΪ0ͬʱΪ1
        local oldnodeiptype=-1
        for Item in $REMOTE_IP_S; do
            frontiptype=$(get_frontip_type "${Item}")
            if [ "$oldnodeiptype" == -1 ];then
                oldnodeiptype=$frontiptype
            fi
            if [ "$oldnodeiptype" -eq "$frontiptype" ];then
                continue
            else
                LOG "[$FUNCNAME][${LINENO}]:the network is IPV4 and IPV6"
                netflag=1
                break
            fi
            LOG "[$FUNCNAME][${LINENO}]:the network is only IPV4 or IPV6"
        done

        extDnsServe=""
        serverConn=""
        numCnt=1
        while [ $numCnt -le $DnsNum ]; do
            extDnsServe=` echo $AllDnsService | awk '{print $ '$numCnt'}'`

            #״̬
            if [ "$extDnsServe" == "" ];then
                LOG "[$FUNCNAME][${LINENO}]:failed numCnt:$numCnt,NS server is NULL"
                numCnt=$((numCnt+1))
                continue
            fi

            #ڵжdns############################################################################
            >${VALID_IP_FILE}

            #Begin: ip޸Ϊ˽ip 2019/8/26
            #жIPͣV4ͺС::xxxx:͡.ַ::xxxxx:xxxx.xxx.xx.x;ipflag=1ʾIPV40ʾIPV6

            #End: ip޸Ϊ˽ip 2019/8/26

            echo $extDnsServe|grep "::ffff:"|grep "\." > /dev/null
            if [ $? -eq 0 ];then
                extDnsServe=$(echo $extDnsServe|sed 's/::ffff://g')
                ipflag=1
            else
                #ipv6
                ipflag=0
            fi
            #жDNS IPǷڹ,isOMnetflag=1˵DNSǰ
            isOMnet=$(cat /opt/huawei/deploy/script/deploy_source_route.sh |grep -w $extDnsServe |grep om1)
            if [ "$isOMnet" == "" ];then
                isOMnetflag=1
            fi

            TASK_ID=$numCnt
            remote_exec_async_batch $TASK_ID 120 "/usr/bin/host -W 60 test $extDnsServe > $G_REMOTE_TMP_FILE$FUNCNAME$numCnt  2>&1; exit 0"

            ValidIP=`cat ${VALID_IP_FILE}`
            ValidIPResult=$ValidIP

            LOG "[$FUNCNAME][${LINENO}][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"

            fifo_start
            while [ "${ValidIP}" != "" ]; do
                >${VALID_IP_FILE}

                for Item in $ValidIP; do
                    service_type=$(get_service_type_from_db "${Item}")
                    if [ "${service_type}" != "1" ];then
                       LOG "service_type = ${service_type}.skip ${Item}."
                       errResult="Does not involve"
                       WRITE_XML_COMMON 0 "Node:$Item||DFS:No||DNS_server:${extDnsServe}||DNS server status:--"
                       continue
                    fi

                    dfsFlag=1

                    #ѯ
                    remote_exec_checkfini $Item $TASK_ID "/usr/bin/host -W 60 test $extDnsServe"
                    iRet=$?
                    if [ $iRet -eq 0 ];then
                        echo -n "$Item " >> ${VALID_IP_FILE}
                        continue
                    elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                        LOG "[$FUNCNAME][${LINENO}]:Node: $Item||INFO: excute check cmd(/usr/bin/host test $extDnsServe) failed."
                        isPass=1
                        continue
                    fi

                    remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME$numCnt
                    iRet=$?
                    if [ $iRet -ne 0 ];then
                        WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command(/usr/bin/host test ${extDnsServe}). Error(${iRet})."
                        isPass=1
                        continue
                    fi

                done
                ValidIP=`cat ${VALID_IP_FILE}`
            done

            wait
            fifo_finish

            for Item in $ValidIPResult; do
                if [ $dfsFlag = 0 ]; then
                    continue
                fi
                #DNSΪڵʱ򣬹˷ڵļ
                if [ $isOMnetflag = 0 ];then
                    if [ "$Item" != "$back_ip" ];then
                        continue
                    fi
                fi

                service_type=$(get_service_type_from_db "${Item}")
                if [ "${service_type}" != "1" ]; then
                    continue
                fi

                fifoContext=`cat $G_TMP_FILE$Item`
                if [ "$fifoContext" = "" ];then
                    continue
                fi
                frontiptype=$(get_frontip_type "${Item}")
                if [ $netflag -eq 1 ];then
                    if [ $ipflag -ne $frontiptype ];then
                        continue
                    fi
                fi
                #жǷͨ

                serverConn=`cat $G_TMP_FILE$Item|grep "Using domain server"|wc -l`
                if [ $serverConn -eq 0 ]
                then
                    isPass=1
                    WRITE_XML_COMMON 0 "Node:$Item||DFS:Yes||DNS_server: $extDnsServe||DNS server status: DNS server is not connectable."
                    WRITE_XML_ERROR 0 "Node:$Item||INFO:DNS server is not connectable."
                    #
                    LOG "[$FUNCNAME][${LINENO}]:/usr/bin/host test $extDnsServe result:"
                    cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                else
                    WRITE_XML_COMMON 0 "Node:$Item||DFS:Yes||DNS_server: $extDnsServe||DNS server status:DNS server is connectable."
                fi
            done
            DnsCnt=`echo "$AllDnsService" | grep -v "^$" | wc -l`
            if [ "$isPass" -eq 0 ] && [ "$DnsCnt" -gt 0 ];then
                #Զִping
                ValidIP=`cat $IP_ROLE_FILE`

                while [[ ${ValidIP} != "" ]]
                do
                    for Item in $ValidIP
                    do
                        service_type=$(get_service_type_from_db "${Item}")
                        if [ "${service_type}" != "1" ]; then
                            continue
                        fi
                        if [ $ipflag -eq 1 ];then
                            remote_exec_async $Item $TASK_ID 30 "ping $extDnsServe -c 2|grep avg|awk -F= '{print \$2}'|awk -F/ '{print \$2}' > $G_REMOTE_TMP_FILE$FUNCNAME$pingTag$numCnt  2>&1; exit 0"
                        else
                            remote_exec_async $Item $TASK_ID 30 "ping6 $extDnsServe -c 2|grep avg|awk -F= '{print \$2}'|awk -F/ '{print \$2}' > $G_REMOTE_TMP_FILE$FUNCNAME$pingTag$numCnt  2>&1; exit 0"
                        fi
                    done
                    ValidIP=`cat ${VALID_IP_FILE}`
                done

                #ȴping
                sleep 5

                #Զping
                ValidIP=`cat $IP_ROLE_FILE`
                ValidIPResult=$ValidIP
                LOG "[$FUNCNAME][${LINENO}][$LINENO]isPass=$isPass,ValidIPResult=$ValidIPResult"
                fifo_start
                while [[ ${ValidIP} != "" ]]
                do
                    for Item in $ValidIP
                    do
                        #S3ڵ㲻漰
                        service_type=$(get_service_type_from_db "${Item}")
                        if [ "${service_type}" != "1" ];then
                            LOG "service_type = ${service_type}.skip ${Item}."
                            continue
                        fi

                        dfsFlag=1

                        remote_download $Item $G_TMP_FILE$pingTag$Item $G_REMOTE_TMP_FILE$FUNCNAME$pingTag$numCnt
                        iRet=$?
                        if [ $iRet -ne 0 ];then
                            isPass=1
                            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command(ping ${extDnsServe}). Error(${iRet})."
                            continue
                        fi
                    done
                    ValidIP=`cat ${VALID_IP_FILE}`
                done

                wait
                fifo_finish

                for Item in $ValidIPResult; do
                    if [ $dfsFlag = 0 ]; then
                        continue
                    fi
                    #DNSΪڵʱ򣬹˷ڵļ
                    if [ $isOMnetflag = 0 ];then
                        if [ "$Item" != "$back_ip" ];then
                            continue
                        fi
                    fi

                    service_type=$(get_service_type_from_db "${Item}")
                    if [ "${service_type}" != "1" ]; then
                        continue
                    fi

                    pingResult=`cat $G_TMP_FILE$pingTag$Item`
                    if [ "$pingResult" = "" ];then
                        continue
                    fi
                    frontiptype=$(get_frontip_type "${Item}")
                    if [ $netflag -eq 1 ];then
                        if [ $ipflag -ne $frontiptype ];then
                            continue
                        fi
                    fi
                    if [ "$pingResult" == "" ];then
                        isPass=1
                        errResult="Node: $Item||INFO:Failed to execute PING command."
                        WRITE_XML_ERROR 0 "$errResult"
                    else
                        pingCompare=`echo "$pingResult >= 200" | bc`
                        if [ $pingCompare -eq 1 ];then
                            isPass=4
                            errResult="Node: $Item||INFO:Delay of ping is too large."
                            WRITE_XML_ERROR 0 "$errResult"
                        fi
                    fi
                done

            fi

            ######################################################################################

            numCnt=$((numCnt+1))
        done

        #˳while
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

checkOMIPandIPMIinOneNet()
{
    local omip_v4_gw=""
    local ipmi_v4_gw=""
    local omip_mask_v4=""
    local ipmi_mask_v4=""
    local omip_v6_gw=""
    local ipmi_v6_gw=""
    local omip_mask_v6=""
    local ipmi_mask_v6=""
    local ipmi_ip_v6_prefix_tmp=""
    local ret=0

    $G_MML_FILE_PATH/GetIPMIAddress >/etc/null 2>&1

    omip_v4_gw=`cat /opt/huawei/snas/etc/cm.ini|grep -w omGateway|awk -F= '{print $2}' |tr -d ' '`
    ipmi_v4_gw=`cat /tmp/tmpfilecheckIPMI|grep -w "Default Gateway IP"|awk -F: '{print $2}' | tr -d ' '`
    omip_mask_v4=`cat /opt/huawei/snas/etc/cm.ini |grep -w omNetMask|awk -F= '{print $2}' | tr -d ' '`
    ipmi_mask_v4=`cat /tmp/tmpfilecheckIPMI|grep -w "Subnet Mask"|awk -F: '{print $2}' |tr -d ' '`
    LOG "[$FUNCNAME][${LINENO}]omip_v4_gw: $omip_v4_gw,ipmi_v4_gw: $ipmi_v4_gw,omip_mask_v4: $omip_mask_v4,ipmi_mask_v4: $ipmi_mask_v4"
    omip_v6_gw=`cat /opt/huawei/snas/etc/cm.ini|grep -w omGateway_v6|awk -F= '{print $2}' |tr -d ' '`
    ipmi_v6_gw=`cat /tmp/tmpfilecheckIPMI | grep -w "ipmi_ipv6_gateway" | awk -F: '{print $2}'| tr -d ' '`
    omip_mask_v6=`cat /opt/huawei/snas/etc/cm.ini |grep -w omNetMask_v6|awk -F= '{print $2}' | tr -d ' '`
    ipmi_ip_v6_prefix_tmp=`cat /tmp/tmpfilecheckIPMI | grep -w "ipmi_ipv6_prefix" | awk -F: '{print $2} ' `
    ipmi_mask_v6="`printf %d 0x0$ipmi_ip_v6_prefix_tmp`"
    LOG "[$FUNCNAME][${LINENO}]omip_v6_gw: $omip_v6_gw,ipmi_v6_gw: $ipmi_v6_gw,omip_mask_v6: $omip_mask_v6,ipmi_mask_v6: $ipmi_mask_v6"
    if [ "$omip_v4_gw" == "$ipmi_v4_gw" -a "$omip_mask_v4" == "$ipmi_mask_v4" ];then
        ret=1;
    fi
    if [ "$omip_v6_gw" == "$ipmi_v6_gw" -a "$omip_mask_v6" == "$ipmi_mask_v6" -a "$ipmi_mask_v6" != "0" ];then
        ret=1;
    fi

    return $ret
}

#DiskPoolֵ
Checkdiskpoolcap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local PoolType=""
    local PoolTypeindex=0
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local Result1="nodepool_id:--||nodePool_name:--||CapThreshold:--||ReadOnlyThreshold:--||RecoverValue:--||RecoverReadOnlyValue:--||node_count:--||node:--"
    local isok=0

    dos2unix $G_TMP_FILE$Item

    TierInfoCount=$( cat $G_TMP_FILE$Item | grep "DiskPool"|wc -l )
    LOG "[$FUNCNAME][${LINENO}]TierInfoCount:$TierInfoCount"

    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=$( cat $G_TMP_FILE$Item | grep DiskPool | sed -n "$index"p )
        PoolTypeindex=$( cat $G_TMP_FILE$Item | grep -A12 -E "${HeadInfo}"$ | grep PoolType | awk -F: '{print $2}' )
        PoolType="SSD"
        if [ "$PoolTypeindex" == "1" ]; then
            PoolType="HDD"
        fi

        TotalCap=$( cat $G_TMP_FILE$Item | grep -A12 -E "${HeadInfo}"$ | grep TotalCap | awk -F: '{print $2}' )
        LeftCap=$( cat $G_TMP_FILE$Item | grep -A12 -E "${HeadInfo}"$ | grep LeftCap | awk -F: '{print $2}' )

        UsedCap=$( echo $TotalCap-$LeftCap|bc -l )
        if [ "$TotalCap" == "0" ]; then
            Percentage=0
        else
            Percentage=$(echo "$UsedCap/$TotalCap*100"|bc -l| awk '{printf "%.2f", $0}')
        fi
        LOG "[$FUNCNAME][${LINENO}]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:"$PoolType" "$HeadInfo"||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "${Result}||${Result1}"

        if [  $( echo "$Percentage > 75.0" | bc ) -eq 1 ]; then
            LOG "[$FUNCNAME][${LINENO}]:$isok"
            isok=1
            WRITE_XML_ERROR 0 "MonMaster:$Item||INFO:DiskPool Tier_info($HeadInfo) current Percentage($Percentage) exceeds the threshold Percentage(75)"
        fi

        index=$((index + 1 ))
    done

    return $isok
}

#NodePoolֵ
CheckNodePoolCap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local Result1="nodepool_id:--||nodePool_name:--||CapThreshold:--||ReadOnlyThreshold:--||RecoverValue:--||RecoverReadOnlyValue:--||node_count:--||node:--"
    local isok=0

    dos2unix $G_TMP_FILE$Item

    TierInfoCount=$( cat $G_TMP_FILE$Item | grep "NodePool"|wc -l )
    LOG "[$FUNCNAME][${LINENO}]TierInfoCount:$TierInfoCount"

    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=$( cat $G_TMP_FILE$Item | grep NodePool | awk NR==$index )

        TotalCap=$( cat $G_TMP_FILE$Item | grep -A4 -E "${HeadInfo}"$ | grep TotalCap | awk -F: '{print $2}' )
        LeftCap=$( cat $G_TMP_FILE$Item | grep -A4 -E "${HeadInfo}"$ | grep LeftCap | awk -F: '{print $2}' )

        UsedCap=$( echo $TotalCap-$LeftCap|bc -l )
        if [ "$TotalCap" == "0" ]; then
            Percentage=0
        else
            Percentage=$(echo "$UsedCap/$TotalCap*100"|bc -l| awk '{printf "%.2f", $0}')
        fi

        LOG "[$FUNCNAME][${LINENO}]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:$HeadInfo||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "${Result}||${Result1}"

        if [ $( echo "$Percentage > 75.0" | bc ) -eq 1 ];then
            LOG "[$FUNCNAME][${LINENO}]:$isok"
            isok=1
            WRITE_XML_ERROR 0 "MonMaster:$Item||INFO:NodePool Tier_info($HeadInfo) current Percentage($Percentage) exceeds the threshold Percentage(75)."
        fi

        index=$((index + 1 ))
    done

    return $isok
}

#Tiercapֵ
CheckTierCap()
{
    local TierInfoCount=0
    local HeadInfo=""
    local TotalCap=""
    local LeftCap=""
    local Percentage=""
    local Result=""
    local isok=0
    local Result1="nodepool_id:--||nodePool_name:--||CapThreshold:--||ReadOnlyThreshold:--||RecoverValue:--||RecoverReadOnlyValue:--||node_count:--||node:--"
    dos2unix $G_TMP_FILE$Item

    TierInfoCount=$( cat $G_TMP_FILE$Item | grep "Tier"|wc -l )
    LOG "[$FUNCNAME][${LINENO}]TierInfoCount:$TierInfoCount"
    index=1
    while [ "$index" -le "$TierInfoCount" ]
    do
        HeadInfo=$( cat $G_TMP_FILE$Item | grep Tier | awk NR==$index )

        TotalCap=$( cat $G_TMP_FILE$Item | grep -A4 -E "${HeadInfo}"$ | grep TotalCap | awk -F: '{print $2}' )
        LeftCap=$( cat $G_TMP_FILE$Item | grep -A4 -E "${HeadInfo}"$ | grep LeftCap | awk -F: '{print $2}' )

        UsedCap=$( echo $TotalCap-$LeftCap|bc -l )
        if [ "$TotalCap" == "0" ]; then
            Percentage=0
        else
            Percentage=$(echo "$UsedCap/$TotalCap*100"|bc -l| awk '{printf "%.2f", $0}')
        fi

        LOG "[$FUNCNAME][${LINENO}]Tier_info:$HeadInfo:TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        Result="Tier_info:$HeadInfo||TotalCap(BYTE):$TotalCap||UsedCap(BYTE):$UsedCap||Percentage(%):$Percentage"
        WRITE_XML_COMMON 0 "${Result}||${Result1}"

        if [ $( echo "$Percentage > 75.0" | bc ) -eq 1 ];then
            LOG "[$FUNCNAME][${LINENO}]:$isok"
            isok=1
            WRITE_XML_ERROR 0 "MonMaster:$Item||INFO: Tier Tier_info($HeadInfo) current Percentage($Percentage) exceeds the threshold Percentage(75)."
        fi

        index=$((index + 1 ))
    done

    return $isok
}

#TierMap
CheckTierMap()
{
    local PoolInfoCount=0
    local Result1="Tier_info:--||TotalCap(BYTE):--||UsedCap(BYTE):--||Percentage(%):--"
    local isok=0

    dos2unix $G_TMP_FILE$Item

    PoolInfoCount=$( cat $G_TMP_FILE$Item | grep "nodepool id"|wc -l )
    LOG "[$FUNCNAME][${LINENO}]PoolInfoCount:$PoolInfoCount"
    index=1
    while [ "$index" -le "$PoolInfoCount" ]
    do
        local HeadInfo=$( cat $G_TMP_FILE$Item | grep "nodepool id" | awk NR==$index )
        local tmpinfo=$( cat $G_TMP_FILE$Item | grep -A13 -E "${HeadInfo}"$ )
        local nodePoolId=$( echo "${tmpinfo}" | grep "nodepool id" | awk -F: '{print $2}' )
        local nodePoolName=$( echo "${tmpinfo}" | grep "nodepool name" | awk -F: '{print $2}' )
        local nodeCount=$( echo "${tmpinfo}" | grep "node count" | awk -F: '{print $2}' )
        local nodeList=$( echo "${tmpinfo}" | grep "node :" | awk -F: '{print $2}' )
        local CapThreshold=$( echo "${tmpinfo}" | grep "CapThreshold" | awk -F: '{print $2}' )
        local ReadOnlyThreshold=$( echo "${tmpinfo}" | grep "ReadOnlyThreshold" | awk -F: '{print $2}' )
        local RecoverValue=$( echo "${tmpinfo}" | grep "RecoverValue" | awk -F: '{print $2}' )
        local RecoverReadOnlyValue=$( echo "${tmpinfo}" | grep "RecoverReadOnlyValue" | awk -F: '{print $2}' )

        local Result2="nodepool_id:${nodePoolId}||nodePool_name:${nodePoolName}||CapThreshold:${CapThreshold}||ReadOnlyThreshold:${ReadOnlyThreshold}"
        local Result3="RecoverValue:${RecoverValue}||RecoverReadOnlyValue:${RecoverReadOnlyValue}||node_count:${nodeCount}||node:${nodeList}"
        WRITE_XML_COMMON 0 "${Result1}||${Result2}||${Result3}"
        index=$((index + 1 ))
    done

    return $isok
}

#223.ּ
checkTier()
{
    WRITE_XML_SUBCMD_HEADER $1
    local count=0
    local Result=""
    local isPass=0
    local Item=""

    while true; do
        #ȡmonĵַ
        set_ifs

        AllItem=$( cat /proc/monc_monmap | grep ipaddr_ | awk -F "=" '{print $2}' )
        for Item in $AllItem
        do
            remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon' > $G_REMOTE_TMP_FILE$FUNCNAME[Tier] 2>&1"
            iRet=$?
            if [ $iRet -ne 0 ];then
                LOG "[$FUNCNAME][${LINENO}]can't get mon info"
            else
                LOG "[$FUNCNAME][${LINENO}]:MonIP:$Item"
                break
            fi
        done

        #ִmon tiercap 0
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon tiercap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[Tier] 2>&1"
        remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[Tier]
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME][${LINENO}]can't get TierCap info"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command(MmlBatch 4004 'mon tiercap 0'), Error(${iRet})."
        else
            #
            CheckTierCap
            if [ $? -ne 0 ]; then
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi
        fi

        #ִmon nodepoolcap 0
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon nodepoolcap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[NODE] 2>&1"
        remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[NODE]
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME][${LINENO}]can't get nodepoolcap info"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command(MmlBatch 4004 'mon nodepoolcap 0'). Error(${iRet})."
        else
            #
            CheckNodePoolCap
            if [ $? -ne 0 ]; then

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi
        fi

        #ִmon diskpoolcap 0
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon diskpoolcap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[DISK] 2>&1"
        remote_download_sync $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME[DISK]
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME][${LINENO}]can't get diskpoolcap info"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command(MmlBatch 4004 'mon diskpoolcap 0'). Error(${iRet})."
        else
            #
            Checkdiskpoolcap
            if [ $? -ne 0 ]; then

                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi
        fi

        #ִcat /proc/monc_tiermap
        cat /proc/monc_tiermap > $G_TMP_FILE$Item 2>&1
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME][${LINENO}]can't get diskpoolcap info"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to execute command(cat /proc/monc_tiermap). Error(${iRet})."
        else
            #
            CheckTierMap
            if [ $? -ne 0 ]; then
                #
                cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1
                isPass=1
            fi
        fi

        restore_ifs
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#224Ƿδĸ澯
checkLeftAlarm_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local value
    local iRet=0

    set_ifs
    #ѯδĸ澯δδָδѻָ2״̬
    for((i=0;i<3;++i));do
        sqlite3 /opt/huawei/snas/etc/cm_alarm_record.db 'select ALMID,ALMOCCURTIME from CM_ALARM_RECORD_T where ALMTYPE=0 and (ALMSTATUS=1 or ALMSTATUS=3);' >$G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -eq 0 ]; then
            LOG "[$FUNCNAME][${LINENO}]times=$i,iRet=$iRet:get alarm information success!"
            break;
        else
            LOG "[$FUNCNAME][${LINENO}]times=$i,iRet=$iRet:can't get alarm information!"
            sleep 5
        fi
    done
    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "INFO:Failed to execute command(sqlite3 /opt/product/snas/etc/cm_alarm_record.db 'select ALMID from CM_ALARM_RECORD_T where ALMTYPE=0 and (ALMSTATUS=1 or ALMSTATUS=3);'). Error(${iRet})."
        LOG "[$FUNCNAME][${LINENO}]$IPAddress:can't get alarm information!"
        isPass=1
    else
        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        alarmInfo=$(cat $G_REMOTE_TMP_FILE$FUNCNAME)
        if [ ! -z "${alarmInfo}" ]; then
            while read line
            do
                alarmid=$( echo "${line}" | awk -F '|' '{print $1}' )
                alarmidHex=$( echo "obase=16;$alarmid"|bc )
                alarm_occur_time=$( echo "${line}" | awk -F '|' '{print $2}' )
                alarm_occur_time=$( date -d @${alarm_occur_time} )
                alarm_name=$( sqlite3 /opt/huawei/snas/static/alarmdef.db "select AlmName from alarmdefine_en where AlmID=${alarmid};" )
                WRITE_XML_COMMON 0 "Uncleared alarm ID:0x$alarmidHex||Alarm occur time:${alarm_occur_time}||Alarm name:${alarm_name}"
                LOG "[$FUNCNAME][${LINENO}]:Uncleared alarm ID:0x$alarmidHex||Alarm occur time:${alarm_occur_time}||Alarm name:${alarm_name}"
            done < $G_REMOTE_TMP_FILE$FUNCNAME
            isPass=1
            WRITE_XML_ERROR 0 "INFO:There are uncleared alarms in the system."
        else
            WRITE_XML_COMMON 0 "There are no uncleared alarms in the system."
            LOG "[$FUNCNAME][${LINENO}]:There are no uncleared alarms in the system."
        fi
    fi
    restore_ifs

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#λȡpoolname
NvdimmPool_GetPollName()
{
    case $1 in
        5)
            echo "Pool[nvcache.0]"
            ;;
        6)
            echo "Pool[trns.0]"
            ;;
        7)
            echo "Pool[ds.0]"
            ;;
        8)
            echo "Pool[quota.0]"
            ;;
        *)
            echo "Pool[UNKNOWN]"
            ;;
    esac
}

#228/405 DAB̨״̬
checkDabTask()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local checkScenario=$2
    local dailyScenario=2
    local upgradeScenario=4
    local isNeedCheck="yes"
    local tmpfile=/tmp/tmpfilecheckDabTask
    local totalcount=0
    local back_ip=""
    local lunflag=0
    local TASK_ID=0
    local connectCount=0
    local tmpStr=""
    local Result=""
    local checkpass=0

    # 
    # ع״̬ 
    #  
    back_ip=$(get_backnet_ip)
    if [ "$back_ip" = "" ]; then
        LOG "[$FUNCNAME]:INFO:Can't get back-end IP."
        isPass=$(check_pass ${isPass} 1)
        WRITE_XML_ERROR 0 "INFO:Can't get back-end IP."
    fi

    recovery_task_count=$( cat /proc/monc_recoverymap | grep TaskCnt | awk '{print $2}' )
    LOG "[$FUNCNAME][${LINENO}]recovery task count:$recovery_task_count"
    WRITE_XML_COMMON 0 "INFO:recovery task count:$recovery_task_count"
    balance_task_count=$( cat /proc/monc_balancemap | grep TaskCnt | awk '{print $4}' )
    LOG "[$FUNCNAME][${LINENO}]balance task count:$balance_task_count"
    WRITE_XML_COMMON 0 "INFO:balance task count:$balance_task_count"
    handoff_task_count=$( cat /proc/monc_handoffmap | grep TaskCnt | awk '{print $4}' )
    LOG "[$FUNCNAME][${LINENO}]handoff task count:$handoff_task_count"
    WRITE_XML_COMMON 0 "INFO:handoff task count:$handoff_task_count"
    #1cm_task.db
    if [ -f /opt/huawei/snas/etc/cm_task.db ];then
        #ʱmsdateȡʱ룬Ҫת
        taskInfo=$(sqlite3 /opt/huawei/snas/etc/cm_task.db "select ID,RUNSTATE,STARTTIME,USEDTIME from CM_TASK_T  where (OPTID=4 and FINISHTIME=0 and DELETED!=1);")
        currTime=$(date +%s)

        if [ "$recovery_task_count" != "0" ]; then
            WRITE_XML_COMMON 0 "INFO:"
            WRITE_XML_COMMON 0 "INFO:Reconstruction Detail"
        fi
        for item in $taskInfo
        do
            local taskid=$(echo $item | awk -F "|" '{ print $1}')
            local runstate=$(echo $item | awk -F "|" '{ print $2}')
            local starttime=$(echo $item | awk -F "|" '{ print $3}')
            local usedtime=$(echo $item | awk -F "|" '{ print $4}')
            starttime=$(expr $starttime \/ 1000)
            local runningStatus=$(MapRunningStatus $runstate)
            if [ "$runningStatus" == "RUNNING" ];then
                usedtime=$(expr $currTime - $starttime)
            fi
            local strdate=$(date -d @$starttime)
            if [ ${checkScenario} -eq ${dailyScenario} ] && [ ${usedtime} -gt 172800 ]; then
                isPass=$(check_pass ${isPass} 1)
                isNeedCheck="no"
                WRITE_XML_ERROR 0 "INFO:Node:${back_ip} The reconstruction task ${taskid} has been executed for more than 48 hours."
            fi
            let totalcount++
            WRITE_XML_COMMON 0 "INFO:TaskId:${taskid} TaskName:data_reconstruction RunState:${runningStatus} StartTime:$strdate UsedTime:$usedtime"
        done

        if [ $totalcount -ne 0 ] && [ ${checkScenario} -eq ${upgradeScenario} ];then
            isNeedCheck="no"
            isPass=$(check_pass ${isPass} 1)
            WRITE_XML_ERROR 0 "INFO:Node:${back_ip} The cluster currently has reconfiguration tasks not completed."
        fi
    fi
    #2MmlBatch 4016 "cm task show"
    if [ "${isNeedCheck}" == "yes" ];then
        /usr/local/bin/MmlBatch 4016 "cm task show" > $tmpfile 2>&1
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=$(check_pass ${isPass} 1)
            WRITE_XML_ERROR 0 "INFO:Node:${back_ip} Can not get task info (MmlBatch 4016 'cm task show'),Error(${iRet})!"
            LOG "iRet=$iRet,can not get task info:$(cat $tmpfile)"
        else
            dos2unix $tmpfile > /dev/null 2>&1
            sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $tmpfile >/dev/null 2>&1

            local Tasks=$(cat $tmpfile | grep "task_id" | grep "task_type:4" | sed 's/^ *//g' | sed "/^$/d" | tr -d "\r")
            set_ifs
            for Task in $Tasks
            do
            {
                local TaskId=$(echo $Task |awk -F "task_id:" '{printf $2}'|awk -F "task_name" '{printf $1}' |tr -d " |")
                local TaskName=$(echo $Task |awk -F "task_name:" '{printf $2}'|awk -F "task_type" '{printf $1}' |tr -d " |")
                local TaskType=$(echo $Task |awk -F "task_type:" '{printf $2}'|awk -F "runningStatus" '{printf $1}' |tr -d " |")
                local runStatus=$(echo $Task |awk -F "runningStatus:" '{printf $2}')
                if [ "$TaskType" = "" ] || [ "$runStatus" = "" ] || [ "$TaskId" = "" ];then
                    continue;
                fi
                if [ "$TaskName" = "" ];then
                    break;
                fi

                local runningStatus=$(MapRunningStatus $runStatus)
                if [ "$runStatus" != "38" ] && [ "$runStatus" != "40" ];then
                    LOG "Task:$Task"
                    isNeedCheck="no"
                    isPass=$(check_pass ${isPass} 1)
                    WRITE_XML_ERROR 0 "INFO:Node:${back_ip} Refactoring task ${TaskId} status (${runningStatus}) is not STOP or COMPLETED."
                fi
                let totalcount++

                WRITE_XML_COMMON 0 "INFO:TaskId:$TaskId TaskName:$TaskName RunState:$runningStatus StartTime:-- UsedTime:--"
            }
            done
            restore_ifs
        fi
    fi

    if [ "${isNeedCheck}" == "yes" ] && [ ${checkScenario} -eq ${upgradeScenario} ];then
        [ -f $tmpfile ]&& rm $tmpfile
        local mon_leader=$(grep "Mon" /proc/monc_leader | awk -F':' '{print $2}' | tr -d ' ')
        remote_exec $mon_leader 30 "$G_MML_FILE_PATH/ShowDataRestore $mon_leader > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        remote_download $mon_leader $tmpfile $G_REMOTE_TMP_FILE$FUNCNAME
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=$(check_pass ${isPass} 1)
            WRITE_XML_ERROR 0 "INFO:Node:${mon_leader} Can not get hln info (MmlBatch 988 'show hln'),Error(${iRet})!"
            LOG "iRet=$iRet,can not get hln info:$(cat $tmpfile)"
        else
            #mmlĽ
            Recover_Info=$(cat $tmpfile | grep 'uiPrintNlunCount' 2>&1)

            PrintNlunCount=$(echo $Recover_Info | awk -F"("  '{print $2}' | awk -F")"  '{print $1}')
            var=$(echo "$PrintNlunCount" | bc 2>/dev/null)
            if [ "$PrintNlunCount" == "" ] || [ "$var" != "$PrintNlunCount" ];then
                isPass=$(check_pass ${isPass} 1)
                LOG "The cluster currently has reconstruction tasks.(show hln running)!"
                WRITE_XML_ERROR 0 "INFO:Node:${mon_leader} The cluster currently has reconstruction tasks.(show hln running)"
            elif [ "$PrintNlunCount" -ne "0" ];then
                local lunlist=$(cat $tmpfile | grep "Index([0-9+])NLUN" | awk '{print $2}' |sed ':jix;N;s/\n/,/g;b jix')
                if [ ${#lunlist} -gt 60 ];then
                    lunlist="${lunlist:0:60}......"
                fi
                isPass=$(check_pass ${isPass} 1)
                WRITE_XML_ERROR 0 "INFO:Node:${mon_leader} The cluster has $PrintNlunCount luns of data to be restored.(${lunlist})"
            else
                lunflag=1
            fi
        fi
    fi

    #
    # Ǩ״̬
    #
    REMOTE_IP_S=$(cat /proc/monc_jmmap | grep 'active manager ip' | awk -F'(' '{print $2}' | awk -F')' '{print $1}')

    >${VALID_IP_FILE}

    if [ "$balance_task_count" != "0" ];then
        WRITE_XML_COMMON 0 "INFO:"
        WRITE_XML_COMMON 0 "INFO:Balance Detail"
    fi
    for Item in $REMOTE_IP_S; do
        for time in ${RepeatTimes[*]}; do
        pingResult=$(ping -q -c 1 $Item |grep "1 received" |wc -l)
            local iRet=$?
            if [ $iRet -ne 0 ]; then
                sleep 10
            else
                break
            fi
        done
        if [ "1" == "$pingResult" ];then
            connectCount=1
            #manager get job 100 1100ʾǨ1ʾǰе
            #manager get job 109 1109ʾһǨ1ʾǰе
            remote_exec_async $Item $TASK_ID 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4100 'manager get job 100 1' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1;sleep 3;$G_MML_FILE_PATH/ShowInspectMml $Item 4100 'manager get job 109 1' >> $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
            iRet=$?
            if [ $iRet -ne 0 ]; then
                LOG "[$FUNCNAME][${LINENO}] Node: $Item||Error: ${iRet}"
                WRITE_XML_ERROR 0 "INFO:Node:$Item Failed to execute command."
                isPass=1
            else
                echo -n "$Item " >> ${VALID_IP_FILE}
            fi

            break
        fi
    done

    ValidIP=`cat ${VALID_IP_FILE}`

    if [ "${connectCount}" == "0" ];then
        LOG "[$FUNCNAME][${LINENO}] Node: $Item||Error:Failed to connect bjm master."
        WRITE_XML_ERROR 0 "INFO:Node:$Item Failed to connect bjm master."
        isPass=$(check_pass ${isPass} 1)
    fi

    ValidIPResult=$ValidIP
    LOG "[$FUNCNAME][${LINENO}]isPass=$isPass,ValidIPResult=$ValidIPResult"
    fifo_start
    while [ "${ValidIP}" != "" ]; do
        >${VALID_IP_FILE}

        for Item in $ValidIP; do
            #Ϊ100%֮ļأн
            remote_exec_checkfini $Item $TASK_ID "MmlBatch 4100 'manager get job 100 1';sleep 3;MmlBatch 4100 'manager get job 109 1'"
            iRet=$?

            if [ $iRet -eq 0 ];then
                echo -n "$Item " >> ${VALID_IP_FILE}
                continue
            elif [ $iRet -ne 2 -a $iRet -ne 5 ];then
                isPass=$(check_pass ${isPass} 1)
                continue
            fi

            remote_download $Item $G_TMP_FILE$Item $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=$(check_pass ${isPass} 1)
                echo "FlagDownfail" >> $G_TMP_FILE$Item 2>&1
                continue
            fi
        done
        ValidIP=`cat ${VALID_IP_FILE}`
    done

    wait
    fifo_finish

    for Item in $ValidIPResult; do
        FlagDownfail=`cat $G_TMP_FILE$Item |grep FlagDownfail`
        if [ "$FlagDownfail" != "" ];then
            LOG "[$FUNCNAME][${LINENO}]:IP:$Item,Down file fail"
            continue
        fi

        dos2unix $G_TMP_FILE$Item

        cat $G_TMP_FILE$Item >> $LOG_FILE 2>&1

        cat $G_TMP_FILE$Item |grep "data_migration"
        iRet=$?
        if [ $iRet -ne 0 ];then
            LOG "[$FUNCNAME][${LINENO}]: There is no data-migration task running in cluster system."
        elif [ ${checkScenario} -eq ${upgradeScenario} ];then
            isPass=$(check_pass ${isPass} 1)
            WRITE_XML_ERROR 0 "INFO:Node:$Item balance tasks exist."
        fi

        while read line; do
            echo "$line" |grep "data_migration"
            if [ $? -ne 0 ]; then
                continue
            fi
            local task_id=$(echo "$line"|awk -F " " '{print $1}' | awk -F "(" '{print $2}' |awk -F ")" '{print $1}')
            local task_name=$(echo "$line"|awk -F " " '{print $2}' | awk -F "(" '{print $2}' |awk -F ")" '{print $1}')
            local startTime=$(echo "$line"|awk -F " " '{print $6}' | awk -F "(" '{print $2}' |awk -F ")" '{print $1}')
            local tmpstartTime=`date -d @${startTime} "+%Y-%m-%d %H:%M:%S"`
            local endTime=$(echo "$line"|awk -F " " '{print $7}' | awk -F "(" '{print $2}' |awk -F ")" '{print $1}')
            if [ "$endTime" = "0" ];then
                tmpendTime="--"
            else
                tmpendTime=`date -d @${endTime} "+%Y-%m-%d %H:%M:%S"`
            fi
            local usedTime=$(echo "$line"|awk -F " " '{print $8}')
            local usedTime2=$(echo "$usedTime"|awk -F "(" '{print $2}'|awk -F ")" '{print $1}')
            if [ ${checkScenario} -ne ${upgradeScenario} -a $usedTime2 -ge 604800 ]; then
                isPass=$(check_pass ${isPass} 1)
                WRITE_XML_ERROR 0 "INFO:Node:$Item $task_name(TaskID:$task_id) has been executed for more than 7 days."
            fi
            WRITE_XML_COMMON 0 "INFO:Active_Manager:$Item TaskID:$task_id Task_Name:$task_name Start_Time:${tmpstartTime} Finish_Time:${tmpendTime} Used_Time:$usedTime2"
        done < $G_TMP_FILE$Item

    done

    #
    # handoff״̬
    #
    Result=""
    TASK_ID="getinfo"
    
    AllItem=$(cat /proc/monc_monmap | grep ipaddr_ | awk -F "=" '{print $2}')
    for Item in $AllItem
    do
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon' > $G_REMOTE_TMP_FILE$FUNCNAME[Tier] 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ];then
            LOG "[$FUNCNAME]can't get mon info"
        else
            LOG "[$FUNCNAME]:MonIP:$Item"
            break
        fi
    done

    # Ϊ˷ֹhandoffmapcatʧܣmapдļУٽмǷǨ
    #ִmon handoffmap 0
    cat /proc/monc_handoffmap > $G_TMP_FILE$Item
    cat $G_TMP_FILE$Item | grep epoch 2>&1
    iRet=$?
    if [ $iRet -ne 0 ]; then
        LOG "[$FUNCNAME]handoffmap: cm master cat /proc/monc_handoffmap exec fail."
        remote_exec $Item 30 "$G_MML_FILE_PATH/ShowInspectMml $Item 4004 'mon handoffmap 0' > $G_REMOTE_TMP_FILE$FUNCNAME[HandoffTask] 2>&1"
        remote_download $Item $G_TMP_FILE$Item /var/log/handoffmap.log
        iRet=$?
    fi
    if [ $iRet -ne 0 ]; then
        LOG "[$FUNCNAME]mml_result:mon handoffmap 0 exec fail"
        WRITE_XML_ERROR 0 "INFO:Failed to execute command(MmlBatch 4004 'mon handoffmap 0')."
        isPass=$(check_pass ${isPass} 1)
    else
        #mapǷǨ TaskCntǰTotalCntʷܹDoneCntTaskCnt+DoneCnt = TotalCnt
        #RTask0~RTaskXÿʾ
        handoff_task_num=$(cat $G_TMP_FILE$Item | egrep "RTask|epoch" | wc -l)
        if [ "$handoff_task_num" -ne 1 ]; then
            LOG "[$FUNCNAME]the number of handoff task:$handoff_task_num"
            let handoff_task_num=$handoff_task_num-1
            if [ ${checkScenario} -eq ${upgradeScenario} ];then
                isPass=$(check_pass ${isPass} 1)
                WRITE_XML_ERROR 0 "INFO:The cluster handoff task is not 0.($handoff_task_num)."
            fi
        else
            isPass=$(check_pass ${isPass} 0)
        fi
    fi
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#229 Ⱥֻˮλ
checkReadOnlyThreshold()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local info=""
    local back_ip=""
    local errResult=""
    local nodepool_name=""
    local thresholdValue=""
    local allNodePool=""
    local productName=""
    local productVersion=$(cat /opt/huawei/deploy/package/version | grep -w "ProductVersion" | awk -F= '{print $2}')
    if [[ "$productVersion" =~ "V100R006C30SPC" ]] || [[ "$productVersion" =~ "V100R006C10SPC" ]];then
        isPass=3
        WRITE_XML_COMMON 0 "ReadOnlyThreshold:No need checking $productVersion."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    info=$(cat /proc/monc_tiermap)
    if [ "X$info" = "X" ];then
        isPass=1
        errResult="INFO:The file /proc/monc_tiermap is empty in node $(hostname)."
        WRITE_XML_ERROR 0 "${errResult}"
    else
        allNodePool=$(echo "$info" | grep -w "nodepool id " | awk -F: '{print $2}')
        for tmpNodePool in $allNodePool
        do
            local highValue=95
            local lowValue=90
            tmpNodeIp=$(echo "$info" | grep -wA15 "nodepool id :$tmpNodePool" | grep -w "node :" | awk '{print $NF}')
            if [ X"${tmpNodeIp}" != X"" ]; then
                productName=$(/opt/huawei/deploy/script/localexec.py cmd ${tmpNodeIp} 30 false "ipmitool fru" |grep "Product Name" | awk -F: '{print $2}')
            else
                productName=$(ipmitool fru |grep "Product Name" | awk -F: '{print $2}')
            fi
            if [[ "${productName}" =~ "P12" ]] || [[ "${productName}" =~ "S12" ]] || [[ "${productName}" =~ " M " ]];then
                highValue=90
                lowValue=85
            fi
            nodepool_name=$(echo "$info" | grep -wA15 "nodepool id :$tmpNodePool" | grep -w "nodepool name " | awk -F: '{print $2}' | head -1 )
            thresholdValue=$(echo "$info" | grep -wA15 "nodepool id :$tmpNodePool" | grep -w "ReadOnlyThreshold " | awk -F: '{print $2}' | head -1 )
            if [ $? -eq 0 ]; then
                if [ "${thresholdValue}" -gt ${highValue} ];then
                    isPass=$(check_pass $isPass 1)
                elif [ "${thresholdValue}" -gt ${lowValue} ];then
                    isPass=$(check_pass $isPass 4)
                fi
                WRITE_XML_COMMON 0 "NodePool:${tmpNodePool}||NodePoolName:${nodepool_name}||ProductName:${productName}||ReadOnlyThreshold:${thresholdValue}"
            else
                isPass=$(check_pass $isPass 1)
                errResult="INFO:The file /proc/monc_tiermap is error.(NO ReadOnlyThreshold value in ${tmpNodePool})"
                WRITE_XML_ERROR 0 "${errResult}"
            fi
        done
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#ds mapȡ״̬쳣pool
getAbnormalPool()
{
    dsid=0
    poolid=0
    cat /proc/monc_dsmap > /var/dsmap
    > /var/abnormalpool;
    while read line
    do
        echo "$line" |grep "^Pools" &> /dev/null
        if [ $? -eq 0 ]; then
            dsid=`echo $line |awk -F" " '{print $4}' |awk -F":" '{print $1}'`
            continue;
        fi
        echo "$line" |grep "^Id" &> /dev/null
        if [ $? -eq 0 ]; then
            echo "$line" |grep "Abnormal" &> /dev/null
            if [ $? -ne 0 ]; then
                continue;
            fi
            #abnormal pool
            poolid=`echo $line |awk -F" " '{print $2}'`
            echo "($dsid $poolid)" >> /var/abnormalpool
        fi
    done < /var/dsmap
}

getDiskStatInNlun()
{
    bitmap=`printf %d 0x$1`
    cnt=$2
    index=$3
    cnt=$(($cnt-$index))
    cnt=$(($cnt-1))
    cnt=$((3*$cnt))
    bitmap=$(($bitmap>>$cnt))
    bitmap=$(($bitmap&7))
    return $bitmap;
}

addPoolInBadList()
{
    echo "$1" >> /var/nlun_pool_result
}

#nlun mapds mapеpool statǷһ
checkDiskStat()
{
    nlundiskstat=$1
    poolcnt=$2
    idx=$3
    pname=$4
    #ȡnlun disk statӦbitλ
    getDiskStatInNlun $nlundiskstat $poolcnt $idx
    if [ $? -eq 0 ]; then
        return
    fi
    #쳣poolǷѾ¼/var/nlun_pool_result
    grep "$pname" /var/nlun_pool_result &> /dev/null
    if [ $? -eq 0 ]; then
        return
    fi
    #ӹpool
    addPoolInBadList "($pname)"
}

#nlunгԱpool״̬״̬쳣DS map״̬һ¶ӡ$G_TMP_FILE2$Item
checkNlunPoolStatus()
{
    local result_log=/var/log/nluninfo.log

    > /var/nlun_pool_result
    #$result_logÿһ
    neednext=0
    while read line
    do
        if [[ "$line" == NLUN*NewPt* ]]; then
            diskstat=`echo $line |awk -F" " '{print $23}'`
            neednext=1
            continue;
        fi
        if [ $neednext -eq 1 ]; then
            neednext=0
            #ȡnlunԱ
            if [ $diskstat -ne 0 ]; then
                pools=`echo $line |awk 'BEGIN{FS="[()]"}{for(i=2;i<NF;i++) if($i!=" ")print $i}'`
                poolcnt=0
                for pool in $pools
                do
                    poolcnt=$(($poolcnt+1))
                done
                index=0
                for pool in $pools
                do
                    checkDiskStat $diskstat $poolcnt $index $pool
                    index=$(($index+1))
                done
            fi
        fi
    done < $result_log
    #/var/abnormalpoolе쳣̼/var/nlun_pool_result
    while read line
    do
        #쳣poolǷѾ¼/var/nlun_pool_result
        grep "$line" /var/nlun_pool_result &> /dev/null
        if [ $? -eq 0 ]; then
            continue;
        fi
        addPoolInBadList "$line"
    done < /var/abnormalpool
}

#230 nlun״̬
getNlunStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local TASK_ID=0
    local result_log=/var/log/nluninfo.log

    while true;do
        get_nlunmap
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            break
        fi

        set_ifs

        cat $result_log | grep -w State  | grep -wv 'State 0' > $G_TMP_FILE2$FUNCNAME
        lineNum=`cat $G_TMP_FILE2$FUNCNAME|wc -l`
        if [ $lineNum -eq 0 ];then
            Result="Nlun State:--------------------------------------------------||Nlun State:All State is 0"
            WRITE_XML_COMMON 0 "$Result"
            LOG "$Result"
        else
            isPass=1
            Result="Nlun State:--------------------------------------------------||Nlun State:The number of error State is $lineNum"
            WRITE_XML_COMMON 0 "$Result"
            LOG "$Result"

            top_20=`cat $G_TMP_FILE2$FUNCNAME | head -20| sed 's/</(lt)/g'`
            Result=""
            for line in "$top_20"; do
                if [ "" != "${Result}" ];then
                    Result="$Result||Nlun State:$line"
                else
                    Result="Nlun State:$line"
                fi
            done

            Result="Nlun State:--------------detail--------------||${Result}"
            WRITE_XML_COMMON 0 "$Result"
            WRITE_XML_ERROR 0 "INFO:The number of error State is $lineNum."
        fi
        restore_ifs
        break;
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#238 BJM̼
checkBJM()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local iRet=0
    local IPNotOk=""
    local workCheck=0

    while true; do
        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            LOG "[$FUNCNAME][${LINENO}]:INFO: Can't get local ip"
            isPass=1
            WRITE_XML_ERROR 0 "INFO:Can't get back IP."
            break
        fi

        #ִmml bjm map 0
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4104 "bjm map 0"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME][${LINENO}]mml_result:$Info"
            WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:Failed to execute command(MmlBatch 4104 'bjm map 0'). Error(${iRet})."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        #
        cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1

        #ȼ̸
        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Manager" |wc -l`
        if [ "$Info" -ne 1 ];then
            Result="INFO:'active Manager' number($info) is not ok."
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        fi

        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Server" |wc -l`
        if [ "$Info" -ne 1 ];then
            Result="INFO:'active Server' number($info) is not ok."
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        fi

        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Worker" |wc -l`
        if [ "$Info" -lt 1 ];then
            Result="INFO:'active Worker' number($info) is not ok."
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        fi

        if [ $isPass -eq 1 ];then
            break
        fi

        #ip
        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Manager" | cut -d '(' -f 3 | cut -d ')' -f 1`
        if [ "$Info" == "" ] || [ "$Info" == "0.0.0.0" ];then
            Result="Node:null||INFO:'active Manager' status is not ok."
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        else
            Result="Node:${Info}||INFO:'active Manager' status is ok."
            WRITE_XML_COMMON 0 "$Result"
        fi


        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Server" | cut -d '(' -f 3 | cut -d ')' -f 1`
        if [ "$Info" == "" ] || [ "$Info" == "0.0.0.0" ];then
            Result="Node:null||INFO:'active Server' status is not ok."
            WRITE_XML_ERROR 0 "$Result"
            isPass=1
        else
            Result="Node:${Info}||INFO:'active Server' status is ok."
            WRITE_XML_COMMON 0 "$Result"
        fi

        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "active Worker" | cut -d '(' -f 3 | cut -d ')' -f 1`
        for i in $Info; do
            if [ "$i" == "" ] || [ "$i" == "0.0.0.0" ];then
                IPNotOk=$IPNotOk" $i"
                isPass=1
                workCheck=1
            else
                Result="Node:${i}||INFO:'active Worker' status is ok."
                WRITE_XML_COMMON 0 "$Result"
            fi
        done

        if [ "$workCheck" -eq 1 ]; then
            Result="Node:${IPNotOk}||INFO:'active Worker' status is not ok."
            WRITE_XML_ERROR 0 "$Result"
        fi
        
	    # ʬ̼
        cat /dev/null > $G_REMOTE_TMP_FILE$FUNCNAME
        REMOTE_IP_S=`cat $IP_ROLE_FILE`
        for Item in $REMOTE_IP_S; do
            set_ifs
            remote_exec $Item 30 "ps -ef | grep -a bjm | grep -a defunct | grep -v 'ps -ef' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
            remote_download_sync $Item $G_REMOTE_TMP_FILE$FUNCNAME$Item $G_REMOTE_TMP_FILE$FUNCNAME
            downCon=$(cat $G_REMOTE_TMP_FILE$FUNCNAME$Item)
            LOG "[$FUNCNAME][${LINENO}]node:$Item, BJMZombieProcess: ${downCon}"

            if [ "x${downCon}" != "x" ]; then
                isPass=$(check_pass ${isPass} 1)
                WRITE_XML_ERROR 0 "Node:$Item||INFO:Zombie processes exist."
            else
                isPass=$(check_pass ${isPass} 0)
                WRITE_XML_COMMON 0 "Node:$Item||INFO:No zombie process exists."
            fi
            restore_ifs
        done
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}
#239. 鼯Ⱥ״̬
checkSystemInfo_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local servertype=$(cat /opt/huawei/snas/etc/snas.ini |grep ^serviceType |awk -F= '{print $2}')
    local ret
    #ӳƵIDSͰѡservertypeĳɡsurveillanceIDS
    #鵼licenseeкInfoStreamDS  /opt/huawei/snas/license/license_active.dat
    #𳡾Ƶֱ泡 /opt/huawei/snas/etc/snas.ini [VM_CFG] streamStoreMode=ds VM_NUM=2 VM_MEM=16/24
    #9000ڵ/etc/ssh/sshd_configļPermitRootLogin Ϊyes
    #9000ڵڴΪ16GB24GB /var/vmms/conf/vm_conf.dbвѯVM_DOMAININFO_T  ֶuiVmId ullVmMemKBs
    local snasiniFile="/opt/huawei/snas/etc/snas.ini"
    if [ "$(cat /opt/huawei/snas/license/license_active.dat | grep -w "InfoStreamDS")" != "" ];then
        if [ "$(cat ${snasiniFile} |grep "\[VM_CFG\]")" != "" ] && [ "$(cat ${snasiniFile} |grep -w VM_NUM=[1-2])" != "" ] && [ "$(cat ${snasiniFile} |grep -w streamStoreMode=ds)" != "" ];then
            if [ "$(cat /etc/ssh/sshd_config | grep -w "^PermitRootLogin" |grep -w "yes")" != "" ];then
                local isIDS="IDS"
                allVmId=$(MmlBatch 4016 "cm vmms show" | grep VmId: | awk -F"|" '{print $1}' | awk '{print $2}')
                for vmId in $allVmId;do
                    if [ "$vmId" = "--" ];then
                        isIDS=""
                        break
                    fi
                    VmMem=`sqlite3 /var/vmms/conf/vm_conf.db "select ullVmMemKBs from VM_DOMAININFO_T where uiVmId=${vmId}"`
                    VmMem=$(expr $VmMem / 1000000)
                    if [ "$VmMem" != "16" ] && [ "$VmMem" != "24" ];then
                        isIDS=""
                        break
                    fi
                done
                servertype="surveillance${isIDS}"
            fi
        fi
    fi
    while true; do

        local back_ip=`get_backnet_ip`
        if [ "$back_ip" = "" ]; then
            errResult="INFO:Can't get back IP."
            LOG "[$FUNCNAME][${LINENO}]:$errResult"
            isPass=1
            WRITE_XML_ERROR 0 "$errResult"
            break
        fi

        #ע
        set_ifs

        #ִmml cm system
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm system"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        ret=$?

        if [ "${ret}" -ne 0 ]; then
            Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
            LOG "[$FUNCNAME][${LINENO}]:mml_result:${Info}"
            WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:Failed to execute command(MmlBatch 4016 'cm system'). Error(${ret})."
            isPass=1
        else
            dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
            content=`cat $G_REMOTE_TMP_FILE$FUNCNAME`

            if [ "$content" == "" ];then
                WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:Get information from output(MmlBatch 4016 'cm system') failed."
                isPass=1
            else
                ID=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_ID"|awk -F: '{print $2}'`
                Name=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Name"|awk -F: '{print $2}'`
                Health_Status=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Health_Status"|awk -F: '{print $2}'|awk 'gsub(/^ *| *$/,"")'`
                Running_Status=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Running_Status"|awk -F: '{print $2}'|awk 'gsub(/^ *| *$/,"")'`
                version=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Version"|awk -F: '{print $2}'`

                totalCap=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Capacity"|awk -F: '{print $2}'|egrep -o "[0-9]+"`
                usedCap=`cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "Cluster_Used_Capacity"|awk -F: '{print $2}'|egrep -o "[0-9]+"`
                Percentage=`expr 100 \* $usedCap`
                Percentage=`expr $Percentage / $totalCap`

                echo $Health_Status
                echo $Running_Status
                echo "$Health_Status"|dos2unix>/var/log/health_tmp
                echo "$Running_Status"|dos2unix>/var/log/run_tmp
                dos2unix /var/log/health_tmp
                dos2unix /var/log/run_tmp
                Health_Status=`cat /var/log/health_tmp`
                Running_Status=`cat /var/log/run_tmp`
                rm /var/log/health_tmp
                rm /var/log/run_tmp
                Health_Status=`MapHealthStatus $Health_Status`
                Running_Status=`MapRunningStatus $Running_Status`
                Result="ID:$ID||Name:$Name||Health_Status:$Health_Status||Running_Status:$Running_Status||Version:$version||TotalCapacity(MB):$totalCap||UsedCapacity(MB):$usedCap||Percentage(%):$Percentage||Server_Type:$servertype"

                Running_Status=$(echo ${Running_Status})

                if [ "$Running_Status" == "RUNNING" ] && [ "$Health_Status" == "NORMAL" ];then
                    LOG "[$FUNCNAME][${LINENO}]Running_Status($Running_Status);Health_Status($Health_Status) check ok"
                else
                    isPass=1

                    #
                    cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
                    LOG "[$FUNCNAME][${LINENO}]Running_Status($Running_Status);Health_Status($Health_Status) check failed"
                    WRITE_XML_COMMON 0 "$Result"
                    WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:The system(Cluster_ID:${ID}) is not running correctly."
                    break
                fi
                #Ƶسֵȡ95,ֵ75
                if [ "$servertype" == "surveillance" ];then
                    if [ $Percentage -ge 95 ];then
                       isPass=1
                       LOG "[$FUNCNAME][${LINENO}]servertype=$servertype Percentage=$Percentage"
                       WRITE_XML_COMMON 0 "$Result"
                       WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:The space usage of system(Cluster_ID:${ID}) is not lower than 95% in video surveillance scenarios."
                    else
                        WRITE_XML_COMMON 0 "$Result"
                    fi
                else
                    if [ $Percentage -ge 75 ];then
                       isPass=1
                       LOG "[$FUNCNAME][${LINENO}]servertype=$servertype Percentage=$Percentage"
                       WRITE_XML_COMMON 0 "$Result"
                       WRITE_XML_ERROR 0 "Node:${back_ip}||INFO:The space usage of system(Cluster_ID:${ID}) is not lower than 75%."
                    else
                       WRITE_XML_COMMON 0 "$Result"
                    fi
                fi
            fi
        fi

        restore_ifs
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#240 poor״̬
checkNodePoolStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local iRet=0
    local isPass=0
    local iFail=0
    local iOptimize=0
    local iOpCnt=0
    cat /proc/monc_dsmap > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
    iRet=$?
    if [ $iRet -ne 0 ]; then
        Info=`cat $G_REMOTE_TMP_FILE$FUNCNAME`
        Result="INFO:Failed to execute command(cat /proc/monc_dsmap). Error(${iRet})."
        LOG "[$FUNCNAME][${LINENO}]$Item exec(cat /proc/monc_dsmap) failed!errno($iRet),${Info}"
        isPass=1
        WRITE_XML_ERROR 0 "$Result"
    else
        set_ifs
        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
        ips=($(grep -w "IpAddr"  $G_REMOTE_TMP_FILE$FUNCNAME| awk -F " " '{print $14}'))
        #IP
        grep -w "IpAddr"  $G_REMOTE_TMP_FILE$FUNCNAME| awk -F " " '{print $14}'|awk -F "." '{print $1 $2 $3 $4}' > "${G_REMOTE_TMP_FILE}ipinfo" 2>&1
        ipnumber=($(cat -n "${G_REMOTE_TMP_FILE}ipinfo"|sort -nk 2|awk '{print $1}'))
        NumArr1=($(grep -n -w "IpAddr"  $G_REMOTE_TMP_FILE$FUNCNAME|awk -F ":" '{print $1}'))
        NumArr2=($(grep -n "\-\-\-\-\-\-\-\-\-\-" $G_REMOTE_TMP_FILE$FUNCNAME|awk -F ":" '{print $1}'))
        for i in ${ipnumber[*]}
        do
            i=$((i-1))
            iOpCnt=0
            distance=$((${NumArr2[i]}-${NumArr1[i]}-1))
            grep -A${distance} -w ${ips[i]} $G_REMOTE_TMP_FILE$FUNCNAME|grep -v ${ips[i]}|grep -v "Pools in Ds" > $G_TMP_FILE$FUNCNAME
            cat $G_TMP_FILE$FUNCNAME |grep "State" |sort -nk 2 > $G_TMP_FILE2$FUNCNAME
            while read line
            do
                ID=$(echo $line |awk -F " " '{print $2}')
                states=$(echo $line |awk -F " " '{print $4}')
                Result="Node:${ips[i]}||ID:$ID||States:${states}"
                WRITE_XML_COMMON 0 "$Result"
                if [ ${states} = "Abnormal(5)" ]; then
                    iOpCnt=$(($iOpCnt + 1))
                elif [ ${states} != "Normal" ]; then
                    iFail=1
                    WRITE_XML_ERROR 0 "Node:${ips[i]}||INFO:ID($ID) States(${states}) is not Normal."
                fi
            done < $G_TMP_FILE2$FUNCNAME
            if [ $iOpCnt -ne 0 ] && [ $iOpCnt -le 2 ]; then
                iOptimize=1
                WRITE_XML_ERROR 0 "Node:${ips[i]}||INFO:The number(${iOpCnt}) of disks with status Abnormal(5) is less than 3."
            elif [ $iOpCnt -gt 2 ]; then
                iFail=1
                WRITE_XML_ERROR 0 "Node:${ips[i]}||INFO:The number(${iOpCnt}) of disks with status Abnormal(5) is greater than 2."
            fi
        done
        if [ $iFail -eq 1 ]; then
            isPass=1
        elif [ $iOptimize -eq 1 ]; then
            isPass=4
        else
            isPass=0
        fi
        restore_ifs
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#243. ϵͳ--
checkQuotaServe()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=1
    local iRet=0
    local quotaServer=""
    local quotaServiceState="--"
    local firstEpoch="--"
    local currentEpoch="--"
    local settingEpoch="--"
    while true; do
        back_ip=$( get_backnet_ip )
        if [ "$back_ip" = "" ];then
            isPass=1
            LOG "[FUNCNAME] Can't to get the backIP."
            WRITE_XML_ERROR 0 "Node:(master)||INFO:Can't get back IP."
            break
        fi
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 988 "mds info show" >$G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ "${iRet}" -ne 0 ];then
            Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            LOG "[FUNCNAME] mml_result : $Info"
            WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Failed to execute command(MmlBatch 988 'mds info show'). Error(${iRet})"
            isPass=1
            break
        else
            dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
            content=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            if [ "$content" == "" ];then
                isPass=1
                WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Get infomation from output(MmlBatch 988 'mds info show') failed."
            else
                #ȡеqml mdsidquota serverڽڵmdsid;
                mdsid=$( cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "qml mdsid" | awk -F: '{print $2}' |tr -d " "| dos2unix)
                quotaServer=$( cat /proc/monc_mdsmap|grep -w "CtrlRank $mdsid"|grep -Poa '(?<= IpAddr ).*' | awk '{print $1}' |tr -d " " | dos2unix )
                local cnt=30
                while [ $cnt -gt 0 ]; do
                    /opt/huawei/deploy/script/localexec.py cmd $quotaServer 30 false "$G_MML_FILE_PATH/ShowInspectMml $quotaServer 988 'mds qm srvinfo'" | grep -E "Quota Service State|Current Epoch|Setting Epoch"  >$G_REMOTE_TMP_FILE$FUNCNAME 2>&1
                    iRet=$?
                    if [ "${iRet}" -ne 0 ];then
                        isPass=1
                        WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Get infomation by exec(MmlBatch 988 'mds qm srvinfo') from $quotaServer failed."
                        LOG "[FUNCNAME] mml_result : /opt/huawei/deploy/script/localexec.py cmd $quotaServer 30 false \"MmlBatch 988 'mds qm srvinfo'\" ret=$iret"
                        break
                    fi
                    dos2unix $G_REMOTE_TMP_FILE$FUNCNAME
                    content=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
                    if [ "$content" == "" ];then
                        isPass=1
                        WRITE_XML_ERROR 0 "Node:$back_ip(master)||INFO:Get infomation by exec(MmlBatch 988 'mds qm srvinfo') from $quotaServer failed.mml_result is NULL!"
                        break
                    fi
                    cat $G_REMOTE_TMP_FILE$FUNCNAME >> $LOG_FILE 2>&1
                    quotaServiceState=$(cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "Quota Service State" | awk -F"=" '{print $2}' |tr -d " "| dos2unix)
                    currentEpoch=$(cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "Current Epoch" | awk -F"=" '{print $2}' |tr -d " "| dos2unix)
                    settingEpoch=$(cat $G_REMOTE_TMP_FILE$FUNCNAME | grep "Setting Epoch" | awk -F"=" '{print $2}' |tr -d " "| dos2unix)
                    if [ "X${firstEpoch}" = "X--" ];then
                        firstEpoch=$currentEpoch
                    else
                        if [[ "X${quotaServiceState}" =~ "X2" ]];then
                            if [ "X${firstEpoch}" != "X${currentEpoch}" ] || [[ ! "X${settingEpoch}" =~ "X1" ]];then
                                isPass=0
                                break
                            fi
                        else
                            isPass=1
                            WRITE_XML_ERROR 0 "Node:$quotaServer||INFO:The quotaServer node has changed! Please inspect again later."
                            break
                        fi
                    fi
                    let "cnt=${cnt}-1"
                    sleep 3
                done
            fi
        fi
        break
    done
    Result="quotaServer:${quotaServer}||quotaServiceState:${quotaServiceState}||firstEpoch:${firstEpoch}||currentEpoch:${currentEpoch}||settingEpoch:${settingEpoch}"
    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#257. ssdc mpool_memsizeü飬ӵǰ
checkSSDCMpoolMemsize()
{
    WRITE_XML_SUBCMD_HEADER $1
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local isPass=0

    for Item in $REMOTE_IP_S; do
        local mpool_memsize_result=$( remote_exec $Item 30 "cat /opt/huawei/snas/etc/ssdc.ini|grep mpool_memsize " )
        local memValue=$( echo "${mpool_memsize_result}" | awk -F"=" '{print $NF}')

        if [ "${memValue:-0}" -eq 800 ]; then
            WRITE_XML_COMMON 0 "Node:$Item||mpool_memsize:${memValue}"
        else
            isPass=1
            WRITE_XML_ERROR 0 "Node:$Item||mpool_memsize:${memValue}"
        fi
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#256.״̬
checkAvServerStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local totalline=0
    local numCnt=1
    local switch=0
    local avstatus=""
    local avtmpstatus=""
    local isDfs=0
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    for Item in $REMOTE_IP_S
    do
        #1.checkڵ
        local service_type=$(get_service_type_from_db "${Item}")
        if [ "X${service_type}" != "X1" ];then
            LOG "[$FUNCNAME]: $Item is not DFS node."
            continue
        fi
        isDfs=1
        break
    done

    if [ $isDfs -ne 0 ];then
        set_ifs
        while true; do
            local back_ip=`get_backnet_ip`
            if [ "X$back_ip" == "X" ]; then
                LOG "[$FUNCNAME]:INFO: Can't get node's back-end ip"
                isPass=1
                WRITE_XML_ERROR 0 "INFO: Can't get node's back-end ip."
                break
            fi
            #1.ѯ״̬
            $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm avconfig show"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "[$FUNCNAME] get antivirus config info failed."
                WRITE_XML_ERROR 0 "INFO: Failed to execute command(MmlBatch 4016 'cm avconfig show') on node ${back_ip}. Error(${iRet})."
                break
            else
                #2.жϷ״̬رգѲɹ
                switch=$( cat $G_REMOTE_TMP_FILE$FUNCNAME | grep 'enableScan' | awk -F ':' '{print $2}' | awk 'gsub(/\r/,"")1' | awk 'gsub(/ /,"")1' )
                if [ "X$switch" == "X1" ]; then
                    #3.ش򿪣ȡ״̬
                    $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm avserver show" >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
                    iRet=$?
                    if [ $iRet -ne 0 ];then
                        isPass=1
                        LOG "[$FUNCNAME] get antivirus server info failed."
                        WRITE_XML_ERROR 0 "INFO: Failed to get antivirus server info on node ${back_ip}. Error(${iRet})."
                        break
                    else
                        cat /var/log/antivirus_servers  | grep -E 'runningStatus|serverIPAddr' > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
                        #4.û÷Ѳʧ
                        iRet=$?
                        if [ $iRet -ne 0 ]; then
                            isPass=1
                            LOG "[$FUNCNAME] antivirus server is not configed."
                            WRITE_XML_ERROR 0 "INFO: Failed to execute command(cat /var/log/antivirus_servers | grep -E 'runningStatus|serverIPAddr'). Error(${iRet})."
                            break
                        else
                            totalline=`cat $G_REMOTE_TMP_FILE$FUNCNAME | wc -l`
                        fi
                    fi
                    #5.״̬йϣѲʧ
                    #6.״̬Ѳɹ
                    while [ $numCnt -le $totalline ]; do
                        avtmpstatus=$( sed -n "${numCnt}p" $G_REMOTE_TMP_FILE$FUNCNAME | awk -F ':' '{print $2}' | awk 'gsub(/\r/,"")1' | awk 'gsub(/ /,"")1' )
                        if [ "X$avtmpstatus" == "X35" ]; then
                            isPass=1
                            LOG "[$FUNCNAME]antivirus server fault."
                        fi
                        serverIp=$( sed -n "$((numCnt+1))p" $G_REMOTE_TMP_FILE$FUNCNAME | awk '{print $2}' | awk 'gsub(/\r/,"")1' | awk 'gsub(/ /,"")1' )
                        avstatus=$( sed -n "${numCnt}p" $G_REMOTE_TMP_FILE$FUNCNAME | awk -F ':' '{print $2}' | awk 'gsub(/\r/,"")1' | awk 'gsub(/ /,"")1' )
                        if [ "X$avstatus" == "X35" ]; then
                            avstatus="AV_SERVER_STATUS_FAULT"
                            WRITE_XML_ERROR 0 "INFO: Antivirus servers status is ${avstatus} on node:${serverIp}"
                        elif  [ "X$avstatus" == "X1" ]; then
                            avstatus="AV_SERVER_STATUS_NORMAL"
                            WRITE_XML_COMMON 0 "INFO: Antivirus servers status is ${avstatus} on node:${serverIp}"
                        else [ "X$avstatus" == "X89" ]
                            avstatus="AV_SERVER_STATUS_BUSY"
                            WRITE_XML_COMMON 0 "INFO: Antivirus servers status is ${avstatus} on node:${serverIp}"
                        fi

                        LOG "AntivirusServer:${serverIp}||Status:${avstatus}"
                        numCnt=$((numCnt+2))
                    done
                    break
                else

                    WRITE_XML_COMMON 0 "INFO: The antivirus service is closed.Do not involve to inspect."
                    break
                fi
            fi
        done
        restore_ifs
    else
        WRITE_XML_COMMON 0 "INFO: Do not involve to inspect.Node service_type is:${service_type}"
        isPass=3
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}


#258.rpcǷȷ
checkRpcBindCore()
{
    WRITE_XML_SUBCMD_HEADER $1
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    local isPass=0

    for Item in $REMOTE_IP_S; do

        set_ifs
        # 쳣˳ǵõexitûдֵ
        local log_result=$( remote_exec $Item 30 "$G_MML_FILE_PATH/CheckRpcBindCore" )

        # ڵú˸룬ҽRPCָ̰߳ĸ
        local is_correct=$( echo "${log_result}" |grep '^ *pass! *$' )
        # ڵûú˸룬RPC̺߳˰󶨼ʧ
        local is_failed=$( echo "${log_result}" |grep '^ *failed! *$' )

        if [ -n "${is_failed}" ]
        then
            isPass=1
            WRITE_XML_ERROR 0 "INFO: Node:$Item,get rpc bind core status is:${log_result} by invoke CheckRpcBindCore."
        elif [ -n "${is_correct}" ]
        then
            WRITE_XML_COMMON 0 "INFO: Node:$Item,rpc bind core status is ${log_result}."
        else
            # зRPCָ̰߳ĸ
            isPass=1
            WRITE_XML_ERROR 0 "INFO: Node:$Item,non-RPC threads(${log_result}) are bound to the specified core."
        fi
        restore_ifs
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#262. license
checkExpandLicense()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local isPass=0
    local iRet=0

    while true; do
        local back_ip=$( get_backnet_ip )
        if [ "X$back_ip" == "X" ]; then
            LOG "[$FUNCNAME][$LINENO]Can't get node's back-end ip"
            isPass=1
            WRITE_XML_ERROR 0 "INFO: Can't get node's back-end ip."
            break
        fi

        #ִmml cm licensecfg
        $G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm licensecfg"  >  $G_REMOTE_TMP_FILE$FUNCNAME 2>&1
        iRet=$?
        if [ $iRet -ne 0 ]; then
            Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME )
            LOG "[$FUNCNAME][$LINENO]mml_result:$Info"
            WRITE_XML_ERROR 0 "INFO: Failed to execute command(MmlBatch 4016 'cm licensecfg') on node:${back_ip}. Error(${iRet})."
            isPass=1
            break
        fi

        dos2unix $G_REMOTE_TMP_FILE$FUNCNAME

        Info=$( cat $G_REMOTE_TMP_FILE$FUNCNAME|grep "get license res cfg fail" )
        if [ "X$Info" != "X" ];then
            # ϵͳδlicenseѲͨ
            WRITE_XML_COMMON 0 "INFO: Do not involve to inspect,the system did not import any license."
            break
        fi

        javaID=`cat $G_REMOTE_TMP_FILE$FUNCNAME |grep "acFeatureName"|sed 's/^ *//g'|sed "/^$/d"`

        if [ "X$javaID" == "X" ];then
            LOG "[$FUNCNAME][$LINENO]$line,javaID is null"
            WRITE_XML_COMMON 0 "INFO: Do not involve to inspect,No license resource active."
            break
        fi

        set_ifs
        for line in $javaID
        do
            if [ "X$line" == "X" ];then
                continue
            fi
            Feature=$( echo $line |awk '{print $3}' )
            MaxNumber=$( echo $line |awk '{print $11}'|sed 's/\./ /g' )
            Deadline=$( echo $line |awk '{print $7}' )
            # Only need digit
            ServiceType=$( echo $line |awk '{print $15}'|tr -c [:digit:] ' '|tr -d ' ' )
            ServiceNodeNum=$( sqlite3 /opt/huawei/snas/etc/cm_conf.db "select count(*) from CM_NODE_T where Reserved2=$ServiceType" )
            iRet=$?
            if [ $iRet -ne 0 ]; then
                sleep 1
                ServiceNodeNum=$( sqlite3 /opt/huawei/snas/etc/cm_conf.db "select count(*) from CM_NODE_T where Reserved2=$ServiceType" )
                iRet=$?
                if [ $iRet -ne 0 ]; then
                    LOG "[$FUNCNAME][$LINENO]Can't get ServiceNodeNum by sqlite3,iRet=$iRet"
                    WRITE_XML_ERROR 0 "INFO:Can't get the ServiceNodeNum($Feature) of nodes in system."
                    isPass=1
                fi
            fi
            ServiceTypeReal=$( MapNodeServiceType $ServiceType )

        LOG "[$FUNCNAME][$LINENO]Deadline:$Deadline,Feature:$Feature,ServiceNodeNum:$ServiceNodeNum,MaxNumber:$MaxNumber"
            if [ "${Deadline}" == "9999-12-31" ];then
                date1=$(date --date "${Deadline}" +%s)
                Deadline="PERMANENT"
            else
                date1=`expr $Deadline \/ 1000`
                Deadline=`date --date "1970-01-01 UTC $date1 seconds" +"%Y-%m-%d %T %z"`
            fi
            LOG "[$FUNCNAME][$LINENO]Deadline:$Deadline"
            date2=`date`

            t1=$date1
            t2=`date --date "$date2" +%s`
            LOG "[$FUNCNAME][$LINENO]Deadline:$t1,CurrentTime:$t2"
            Result="INFO: Feature:$Feature  MaxNumber:$MaxNumber  DeadLine:$Deadline  ServiceType:$ServiceTypeReal  ServiceNodeNum:$ServiceNodeNum"
            if [ $t1 -lt $t2 ]; then
                isPass=1
                WRITE_XML_ERROR 0 "INFO: Licence is not in the validity period,$Result"
            elif [ $MaxNumber -le $ServiceNodeNum ]; then
                isPass=1
                WRITE_XML_ERROR 0 "INFO: The number of nodes currently supported by license can no longer be expanded, please purchase and import a new license,$Result"
            else
                WRITE_XML_COMMON 0 "$Result"
            fi

            LOG "[$FUNCNAME][$LINENO]Result($Result),isPass=$isPass"
        done
        restore_ifs

        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#263. CMڵdeploy̼
checkCMMasterDeploy()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local deployFile="/opt/huawei/deploy/bin/snas_deploy"
    local deployProduct="/opt/product/deploy/bin/snas_deploy"

    LOG "[$FUNCNAME][$LINENO]start!"

    while true; do
        deployProcess=$(ps -C snas_deploy |grep snas_deploy )
        if [ "X$deployProcess" == "X" ]; then
            WRITE_XML_ERROR 0 "INFO:$deployProduct is not running"
            isPass=1
        else
            WRITE_XML_COMMON 0 "INFO: $deployProduct is running"
        fi

        break
    done

    LOG "[$FUNCNAME][$LINENO]finish!"

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#265 nlun
CheckNlunCount()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local ret=0
    /usr/local/bin/MmlBatch 988 "monc nluninfo 0"
    ret=$?
    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "INFO: Failed to execute command(MmlBatch 988 'monc nluninfo 0')"
        isPass=1
        return
    fi
    count=$(cat /var/log/nluninfo.log | grep -a NewPt | wc -l)
    if [ $iRet -ne 0 ]; then
        WRITE_XML_ERROR 0 "INFO: Can not get nluninfo"
        isPass=1
        return
    fi
    if [ $count -gt 50000 ]; then
        isPass=1
        WRITE_XML_ERROR 0 "INFO:Nlun total count:$count"
    else
        WRITE_XML_COMMON 0 "INFO:Nlun total count:$count"
    fi
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#273/406 ݾ⿪
function checkBalanceStatus()
{
    WRITE_XML_SUBCMD_HEADER $1
    local tmpStr=""
    local isPass=0
    local checkScenario=$2
    local upgradeScenario=4
    local tmpfile="/tmp/tmpfilecheckBalanceStatus"

    [ -f $tmpfile ] && rm -f $tmpfile

    /usr/local/bin/MmlBatch 4016 "cm balance show" > $tmpfile 2>&1
    iRet=$?
    if [ $iRet -ne 0 ];then
        isPass=1
        WRITE_XML_ERROR 0 "INFO: BalanceStatus:can not get balance status info!(MmlBatch 4016 'cm balance show')"
        LOG "iRet=$iRet, can not get balance status info!"
    else
        dos2unix -f $tmpfile >/dev/null 2>&1
        sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' $tmpfile 2>&1
        tmpStr=$(cat $tmpfile |grep "BalanceStatus"|sed 's/^ *//g'|sed "/^$/d"|awk -F ":" '{print $2}' | tr -d ' ')
        if [ ${checkScenario} -eq ${upgradeScenario} ];then
            if [ "${tmpStr}" == "ON" ];then
                isPass=1
                WRITE_XML_ERROR 0 "INFO:Data balance status is not off."
            fi
        else
            if [ "${tmpStr}" == "OFF" ] ;then
                isPass=1
                WRITE_XML_ERROR 0 "INFO:Data balance status is not on."
            fi
        fi
        LOG "BalanceStatus:$tmpStr,tmpStr=$tmpStr"
    fi
    [ -f $tmpfile ] && rm -f $tmpfile
    WRITE_DIR_XML_COMMON 0 "BalanceStatus:$tmpStr"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL

}
#283.鹲Ŀ¼
checkRedundantRatio()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local dfsip=""

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "REMOTE_IP_S:$REMOTE_IP_S"

    for Item in $REMOTE_IP_S; do
        #checkڵͣDFSִ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "X${service_type}" != "X1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            continue
        fi
        #ǣ˵ȺкDFSڵ
        dfsip=$Item
        break
    done

    if [ "X${dfsip}" != "X" ];then
        #dfsڵ
        remote_exec $dfsip 300 "$G_MML_FILE_PATH/GetRedundantRatio > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ];then
            LOG "$[FUNCNAME][$LINENO] failed to get info  from GetRedundantRatio,iRet=$iRet,dfsip=$dfsip"
            WRITE_XML_ERROR 0 "INFO: Failed to execute command(GetRedundantRatio) on node ${dfsip}. Error(${iRet})."
            isPass=1
        else
            remote_download $dfsip $G_TMP_FILE$dfsip $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                LOG "$[FUNCNAME][$LINENO]item=$Item, download file fail!"
                WRITE_XML_ERROR 0 "INFO:Failed to download file generated by command(GetRedundantRatio) on node ${$dfsip}. Error(${iRet})."
            fi
            set_ifs
            for tmpline in $(cat $G_TMP_FILE$dfsip)
            do
                Share_Type=$(echo "$tmpline" |grep "Share_Type=" |awk -F'//' '{print $1}' |awk -F= '{print $2}' |tr -d ' ')
                Share_Dir=$(echo "$tmpline" |grep "Share_Dir=" |awk -F'//' '{print $3}' |sed 's/^Share_Dir=//g')
                RedundantRatio=$(echo "$tmpline" |grep "RedundantRatio=" |awk -F'//' '{print $2}' |awk -F= '{print $2}' |tr -d ' ')
                LOG "[$FUNCNAME][$LINENO] Share_Type=$Share_Type Share_Dir=$Share_Dir RedundantRatio=$RedundantRatio"

                if [ "X$Share_Type" == "X" ] && [ "X$Share_Dir" == "X" ] && [ "X$RedundantRatio" == "X" ];then
                    # н壬ǿлӡϢ
                    continue
                fi

                if [ "X$Share_Dir" == "X--" ] && [ "X$RedundantRatio" == "X--" ];then
                    #ûЭ鹲Ŀ¼
                    WRITE_XML_COMMON 0 "INFO: Shared directory does not exist on node ${dfsip}"
                    continue
                fi
                #/mnt/fs/share ʾڽ,ݹߵҪҪxmlĿ¼ֵ&apos;תΪ&#39;
                Share_Dir=$(echo "${Share_Dir}" |sed 's/\/mnt\/fs\/share//g' |sed 's/&apos;/\&#39;/g' |sed 's/|/\&#x7c;/g')
                if [ "$RedundantRatio" == "no" ];then
                    #Ŀ¼ڣ
                    if [ $isPass -eq 0 ];then
                        isPass=4
                    fi
                    WRITE_XML_ERROR 0 "INFO: Share_Type:$Share_Type exists, but shared directory:${Share_Dir} does not exist."
                    continue
                fi
                if [ "${RedundantRatio}" == "+1" ] ;then
                    #Ϊ+1
                    isPass=1
                    WRITE_XML_ERROR 0 "INFO: Share Directory:${Share_Dir} with share type:${Share_Type}, incorrect redundant ratio:$RedundantRatio."
                else
                WRITE_DIR_XML_COMMON 0 "INFO: Share Directory:${Share_Dir} with share type:${Share_Type}, redundant ratio:$RedundantRatio."
                fi
                LOG "[$FUNCNAME][$LINENO] Share_Type=$Share_Type Share_Dir=<![CDATA[$Share_Dir]] RedundantRatio=$RedundantRatio"
            done
            restore_ifs
        fi
    else
        Result="INFO: Do not involve to inspect,There are no DFS nodes in the cluster"
        WRITE_XML_COMMON 0 "$Result"
        isPass=3
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#284.Эɾ־Ŀ¼
checkNasLogDir()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local DelFlag="8"
    local Del_Result=""
    local dfs_ip=""
    local ishavedfsnode=""
    local isPass=0
    local iRet=0
    local remotefile=""
    local isopen=0
    local issetdir=""
    local dirpath=""

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "REMOTE_IP_S:$REMOTE_IP_S"

    for Item in $REMOTE_IP_S; do
        local node_service_type=$(get_service_type_from_db "${Item}")
        if [ "X${node_service_type}" != "X1" ]; then
            LOG "service_type = ${service_type}.skip ${Item}."
            continue
        fi
        #ΪǼȺϢֻҪҵһdfsڵ㼴
        dfs_ip=$Item
        break
    done
    if [ "X${dfs_ip}" != "X" ];then
        #dfsڵ
        remotefile=`remote_exec $dfs_ip 120 "$G_MML_FILE_PATH/checkNasLogDirMml"`
        iRet=$?
        if [ $iRet -ne 0 ];then
            LOG "$[FUNCNAME] failed to get info from checkNasLogDirMml,iRet=$iRet.dfs_ip=$dfs_ip"
            WRITE_XML_ERROR 0 "INFO:Failed to get info from checkNasLogDirMml nde node:${dfs_ip},iRet=$iRet."
            isPass=1
        else
            #
            isPass=$(echo $remotefile | cut -d ":" -f 2 | cut -d ";" -f 1)
            isopen=$(echo $remotefile | cut -d ":" -f 3 | cut -d ";" -f 1)
            issetdir=$(echo $remotefile | cut -d ":" -f 4 | cut -d ";" -f 1)
            dirpath=$(echo $remotefile | cut -d ":" -f 5 | cut -d ";" -f 1)
            if [ "X$isopen" == "X0" ];then
                Result="INFO: The naslogdir is not open."
                WRITE_XML_COMMON 0 "$Result"
            else
                DelValue=$((${isopen}&${DelFlag}))
                if [ "X0" == "X${DelValue}" ];then
                    isPass=1
                    Del_Result="INFO:The delete switch is not on node:${dfs_ip},please open it"
                    WRITE_XML_ERROR 0 "${Del_Result}"
                fi
                if [ $issetdir -eq 0 ];then
                    Result="INFO:The naslogdir delte switch is open,but not set to the real directory path."
                    WRITE_XML_COMMON 0 "$Result"
                else
                    Result="INFO:The naslogdir path is $dirpath"
                    WRITE_XML_COMMON 0 "$Result"
                fi
            fi
        fi
    else
        Result="INFO: Do not involve to inspect,There are no DFS nodes in the cluster"
        WRITE_XML_COMMON 0 "$Result"
        isPass=3
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#293 ǷڵڵЭ
checkProtoSubdomain()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local dfsFlag=0
    local TASK_ID=0
    local iRet=0
    local dfsip=""
    local result=""

    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    LOG "REMOTE_IP_S:$REMOTE_IP_S"
    >${VALID_IP_FILE}
    for Item in $REMOTE_IP_S; do
        #checkڵͣDFSִ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "X${service_type}" != "X1" ];then
            LOG "service_type = ${service_type}.skip ${Item}."
            continue
        fi

        #ǣ˵ȺкDFSڵ
        dfsip=$Item
        break
    done
    if [ "X${dfsip}" != "X" ];then
        #dfsڵ
        remote_exec $dfsip 60 "$G_MML_FILE_PATH/checkProtoSubdomain.sh > $G_REMOTE_TMP_FILE$FUNCNAME 2>&1"
        iRet=$?
        if [ $iRet -ne 0 ];then
            LOG "$[FUNCNAME] failed to get info from checkProtoSubdomain.s,iRet=$iRet.dfsip=$dfsip"
            WRITE_XML_ERROR 0 "INFO: Failed to execute command(checkProtoSubdomain.sh) on node:${dfsip}. Error(${iRet})."
            isPass=1
        else
            remote_download $dfsip $G_TMP_FILE$dfsip $G_REMOTE_TMP_FILE$FUNCNAME
            iRet=$?
            if [ $iRet -ne 0 ];then
                isPass=1
                WRITE_XML_ERROR 0 "INFO: Failed to download file generated by command(checkProtoSubdomain.sh). Error(${iRet})."
                LOG "item=$Item, download file fail!"
            else
                #Զ̽
                status=$(cat $G_TMP_FILE$dfsip |grep status|awk -F: '{print $2}'|tr -d ' ')
                if [ $status -ne 0 ];then
                    isPass=1
                    LOG "status=$status, dfsip=$dfsip"
                    WRITE_XML_ERROR 0 "INFO: Failed to execute command(nas_proto_cluster -c get_zone) on node:${dfsip}."
                else
                    #ضϢ
                    cat $G_TMP_FILE$dfsip |grep -w "ZoneName" > /tmp/tmpfilenaszone
                    while read line; do
                        subnetname=$(echo $line |awk '{print $1}'|awk -F: '{print $2}')
                        subnetnodecount=$(echo $line |awk '{print $2}'|tr -d ' ')
                        subnetnodelist=$(echo $line |awk '{print $3}'|tr -d ' ')
                        if [ $subnetnodecount -eq 1 ];then
                            isPass=4
                            WRITE_XML_ERROR 0 "INFO: The number of protocol subdomains count is:${subnetnodecount} in zone:${subnetname}"
                            LOG "isPass=$isPass, subnetnodecount=$subnetnodecount"
                        else
                            WRITE_XML_COMMON 0 "INFO: Zone:${subnetname} has ${subnetnodecount} protocol subdomains,which are:${subnetnodelist}"
                        fi
                    done < /tmp/tmpfilenaszone
                fi
            fi
        fi
    else
        Result="INFO: Do not involve to inspect,There are no DFS nodes in the cluster"
        WRITE_XML_COMMON 0 "$Result"
        isPass=3
    fi

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#297/403 Ƿnlunдڷcomplete
checkNlunCompletePoolState()
{
    WRITE_XML_SUBCMD_HEADER $1
    local noPassRet=""
    local Result=""
    local isPass=0
    local TASK_ID=0
    local result_log=/var/log/nluninfo.log
    local checkScenario=$2
    local upgradeScenario=4

    #ͨճŻ
    if [ ${checkScenario} -eq ${upgradeScenario} ];then
        noPassRet=1
    else
        noPassRet=4
    fi
    while true;do
        get_nlunmap
        iRet=$?
        if [ $iRet -eq 1 ];then
            isPass=1
            break
        fi

        cat $result_log | grep -a DiskStates  | grep -v 'DiskStates 0' > $G_TMP_FILE2$FUNCNAME
        lineNum=`cat $G_TMP_FILE2$FUNCNAME|wc -l`
        if [ $lineNum -eq 0 ];then
            WRITE_XML_COMMON 0 "Node:master||unCompletePool Nlun: 0"
        else
            isPass=$noPassRet
            WRITE_XML_ERROR 0 "INFO:There are $lineNum non-complete disks in nlun."
            local index=0
            while read line;do
                WRITE_XML_COMMON 0 "Node:master||unCompletePool Nlun:$line"
                let index++
                if [ $index -ge 20 ];then
                    break
                fi
            done < $G_TMP_FILE2$FUNCNAME

        fi
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#241.ȲƼ汾
checkHpatchOperation()
{
    local ProductName=""
    local ProductVersion=""
    local patchVersion=""
    local Version=""
    local Result=""
    local back_ip=""
    local patchPath="/tmp/InfoInspect/productHotPatch.xml"

    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0

    #ƻ漰Ѳ
    local IsOem=$(ls /opt/huawei/deploy/package/oem)
    if [ ! -z "$IsOem" ];then
        WRITE_XML_COMMON 0 "INFO: The current system does not support the appointed inspect item!"
        WRITE_XML_JUDGE 3
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    if [ ! -f ${patchPath} ];then
        isPass=$(check_pass ${isPass} 4)
        WRITE_XML_ERROR 0 "INFO:Please update or download new tools.${patchPath} is nonexist."
    else
        back_ip=$(get_backnet_ip)
        if [ "X${back_ip}" == "X" ];then
            LOG "[$FUNCNAME]:Failed to get back ip"
            isPass=$(check_pass ${isPass} 1)
            WRITE_XML_ERROR 0 "INFO:Can't get back IP."
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return
        fi
        ProductName=$(grep ProductName /opt/huawei/deploy/package/version |awk -F= '{print $2}')
        ProductVersion=$(grep ExternalVersion /opt/huawei/deploy/package/version |awk -F= '{print $2}')
        # productHotPatch.xml ļʱ,1.productVersion patchVersion Ҫ4,2.productVersionproductModel</Ҫո
        patchVersion=$(grep -A4 "${ProductVersion}</productVersion>" ${patchPath} | grep -A2 "${ProductName}</productModel>" |grep "patchVersion" |awk -F '>' '{print $2}' |awk -F '<' '{print $1}')
        Version=$(/opt/huawei/snas/upd/patch_script/cluster_patch.sh "$back_ip" show| grep "Version:" |awk -F, '{print $3}' | awk -F: '{print $2}' 2>/dev/dull)
        Version=${Version:-null}

        LOG "[$FUNCNAME]:ProductName=$ProductName ProductVersion=$ProductVersion"
        Result="Product Version:$ProductVersion||Local Patch Version:$Version"

        #Ƽûеǰ汾ȲҪװ
        if [[ "X${patchVersion}" == "X" ]] ;then
            Result="$Result || Recommended Patch Version:There is no recommended hot patch for the current version in productHotPatch.xml."
            WRITE_XML_COMMON 0 "$Result"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return
        fi

        #δװȲߵƼĲ汾
        if [[ "X$Version" == "Xnull" ]] ;then
            isPass=$(check_pass ${isPass} 4)
        else
            local ver1=$(echo "${patchVersion}" | grep -Po '(?<=SPH)[0-9]+')
            local ver2=$(echo "${Version}" | grep -Po '(?<=SPH)[0-9]+')

            if [[ "$ver1" == "" ]] || [[ "$ver2" == "" ]] ;then
                isPass=$(check_pass ${isPass} 4)
                WRITE_XML_ERROR 0 "INFO:Malformed patch name format error!"
            elif [ $ver1 -gt $ver2 ];then
                isPass=$(check_pass ${isPass} 4)
            fi
        fi
        Result="$Result || Recommended Patch Version:$patchVersion or later "

    fi

    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL

}
#333. xattrxinfoü
checkXinfoXattr()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local back_ip=""
    local allPath=""
    local result="Pass"
    local Xattr=""
    local Xinfo=""
    local checkDir="/mnt/fs/share/"
    local tmpdir="/tmp/CheckXinfoPos"
    local tmpfile="/tmp/CheckXinfoPos/fidInfo"
    local isDfs=0
    local service_type=""
    local spcversion=""
    local sphversion=""
    local goon=1
    local sph_num=""
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    for Item in $REMOTE_IP_S
    do
        #1.checkڵ
        service_type=$(get_service_type_from_db "${Item}")
        if [ "X${service_type}" != "X1" ];then
            LOG "[$FUNCNAME]: $Item is not DFS node."
            continue
        fi
        isDfs=1
        break
    done
    # V3R6C00V3R6C20漰
    spcversion=$( cat /opt/huawei/deploy/package/version | grep ProductVersion | awk -F= '{print $2}' | sed -e "s/^ *//g" -e "s/ *$//g" )
    sphversion=$( ls /var/huawei/patch/cur/sph 2>/dev/null| grep -e "OceanStor*" -e "FusionStorage*" | awk -F'_' '{print $NF}' ) 
    # 7.1.1.SPH110 ֮漰
    # 7.1.1.SPC600 ֮漰
    # 7.1.1.SPH501 ֮漰
    # ںϰ汾FusionStorage V100R006C30SPH906B001 ֮漰
    if [ X"${spcversion}" == X"V500R007C10SPC800" ]; then
        goon=0

    elif [ X"${sphversion}" != X"" ]; then
        sph_num=$( echo $sphversion | awk -F "SPH" '{print $2}' | sed "s/ *$//g" )
        if [ X"${spcversion}" == X"V500R007C10SPC400" -a X"${sph_num}" != X"" -a ${sph_num} -ge 110 ]; then
            goon=0

        elif [ X"${spcversion}" == X"V500R007C10SPC700" -a X"${sph_num}" != X"" -a ${sph_num} -ge 501 ]; then
            goon=0
            
        elif [ X"${spcversion}" == X"V100R006C30SPC600" -a X"${sph_num}" != X"" -a ${sph_num} -ge 906 ]; then
            goon=0
        fi
    fi


    if [ $isDfs -ne 0 ];then
        back_ip=`get_backnet_ip`
        if [ "X$back_ip" == "X" ]; then
            isPass=1
            LOG "[$FUNCNAME]:INFO: Can't get node's back-end ip"
            WRITE_XML_ERROR 0 "INFO: Can't get node's back-end ip."
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return
        fi
        [ -d ${tmpdir} ] && rm -rf ${tmpdir}
        mkdir -p ${tmpdir}
        nas="${tmpdir}/nas.sh"
        echo "#!/bin/bash" > $nas
        echo "\$*" >> $nas
        echo " " >> $nas
        chmod +x $nas
        >${tmpfile}
        local startTime=$(date +%s)
        local timeLimit=$((startTime + 60*8))  #һĿ¼Ѳ쳬ʱ޶8ӣΪľͲ
        local unCheckPath=""
        $nas ls ${checkDir} -lhi | grep -v "fs_sysoplog" |grep -v "^total" > ${tmpfile}
        while read line; do
            path=$(echo $line | awk '{print $NF}')
            $nas [ -f ${checkDir}$path ] && continue
            endTime=$(date +%s)
            if [ ${endTime} -gt ${timeLimit} ];then
                unCheckPath="/${path} ${unCheckPath}"
                continue
            fi
            Inode=$(echo $line | awk '{print $1}')
            [ "X${Inode}" = "X" ] && continue
            /usr/local/bin/MmlBatch 988 "mds inode show  ${Inode}" > ${tmpdir}/tmpinfo
            XinfoPos=$(cat ${tmpdir}/tmpinfo | grep -Poa '(?<=XinfoPos\()[0-9]+')   # Ϊ3ʾ
            XattrPos=$(cat ${tmpdir}/tmpinfo | grep -Poa '(?<=HaveFragOrChunk\()[0-9]+')  # Ϊ2ʾ
            if [ X"${XinfoPos}" = "X3" ];then
                isPass=$(check_pass ${isPass} 4)
                Xinfo="/${path} ${Xinfo}"
            fi
            if [ X"${XattrPos}" = "X2" ];then
                isPass=$(check_pass ${isPass} 4)
                Xattr="/${path} ${Xattr}"
            fi
            allPath="/${path} ${allPath}"
            LOG "[$FUNCNAME] /${path} XinfoPos(${XinfoPos}) HaveFragOrChunk(${XattrPos})"
        done <${tmpfile}

        if [ ${isPass} -ne 0 ];then
            result="Fail"
            WRITE_XML_ERROR 0 "Node:$back_ip||INFO: The directory is external. Xattr(${Xattr}) Xinfo(${Xinfo})"
        fi
        if [ "x${unCheckPath}" != "x" ];then
            isPass=4
            result="Fail"
            WRITE_XML_ERROR 0 "Node:$back_ip||INFO: The directory check is not complete.(${unCheckPath})"
        fi
        rm -rf ${tmpdir}
    else
        result="Do not involve to inspect.Node service_type is:${service_type}"
        isPass=3
    fi

    if [ ${goon} -eq 0 ]; then
        result="this issue has been resolved in the current patch version(${sphversion}) and is not involved."
        isPass=0
    fi
    WRITE_XML_COMMON 0 "Node:$back_ip||Result:${result}"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

# 345 ˺ĬϿ
checkAccountDefaultPassword()
{
    WRITE_XML_SUBCMD_HEADER $1

    local isPass=0
    local key="storage"
    local passwd_suffix=""
    local user_list=("omuser" "omsftp" "root" "admin" "securityAdmin")
    local result=""
    local expect_log="${G_TMP_INSPECT_PATH}exeLogin.log"
    local defaultPwdCfg="/opt/huawei/snas/script/inspect_mml/default_passwd.ini"
    >${expect_log}

    LOG "[$FUNCNAME] start to check account default password"


    for ((i=0; i<${#user_list[@]}; i++))
    do
        account=${user_list[$i]}
        default_passwd=$(cat ${defaultPwdCfg} | grep ${account} | awk -F= '{print $2}' | tr -d "\r")
        if [ -z "${default_passwd}" ]; then
            isPass=$(check_pass $isPass 1)
            LOG "[$FUNCNAME] account:${account} failed to obtain the default password from config file(${defaultPwdCfg})"
            WRITE_XML_ERROR 0 "Node:(master)||INFO:The ${account} account check failed."
            WRITE_XML_COMMON 0 "Node:(master)||Account:${account}||Result:no pass."
            continue
        fi

        LOG "[$FUNCNAME] start to check account ${account}"
        if [ ${account} = "admin" -o ${account} = "securityAdmin" ]; then
            expect $G_MML_FILE_PATH/exeLogin.ex ${account} ${default_passwd} >> ${expect_log}
            iRet=$?
        else
            passwd_crypt=$( cat /etc/shadow | grep ${account} | awk -F: '{print $2}' )
            crypt_key=$( echo ${passwd_crypt} | awk -F '$' '{print "$"$2"$"$3"$"}' )
            default_passwd_crypt=$( python -c "import crypt; print crypt.crypt('${default_passwd}', '${crypt_key}')" )
            if [ ${default_passwd_crypt} = ${passwd_crypt} ]; then
                iRet=0
            else
                iRet=121
            fi
        fi

        [ ${iRet} -eq 121 ] && result="pass" || result="no pass"
        LOG "[$FUNCNAME] account:${account} check result is ${result}(${iRet})"

        if [ ${iRet} -ne 121 ]; then
            isPass=$(check_pass $isPass 4)
            if [ ${iRet} -eq 0 ];
            then
                WRITE_XML_ERROR 0 "Node:(master)||INFO:The ${account} account uses the default password."
            else
                isPass=$(check_pass $isPass 1)
                WRITE_XML_ERROR 0 "Node:(master)||INFO:The ${account} account check failed."
            fi
        fi
        WRITE_XML_COMMON 0 "Node:(master)||Account:${account}||Result:${result}."
    done

    LOG "[$FUNCNAME][$LINENO]isPass=$isPass"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#363 ǰ汾
function checkClusterVerBeforeExpansion()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local mml_output=""
    local cluster_ver=""
    local iRet=0
    #ȡIP
    local back_ip=$(get_backnet_ip)
    if [[ -z "$back_ip" ]]; then
        isPass=1
        errResult="INFO: Can't get local ip"
        LOG "[$FUNCNAME]:$errResult"
        WRITE_XML_ERROR 0 "INFO:Failed to get local ip."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    waitcount=0
    while [[ $waitcount -lt 4 ]]
    do
        mml_output=$($G_MML_FILE_PATH/ShowInspectMml $back_ip 4016 "cm system")
        iRet=$?
        if [[ $iRet -ne 0 ]]; then
            waitcount=$[waitcount+1]
            continue
        else
            break
        fi
    done
    if [[ $iRet -ne 0 ]]; then
        isPass=1
        LOG "[$FUNCNAME]mml_result:${mml_output}"
        WRITE_XML_ERROR 0 "INFO:Failed to execute MML command(cm system)."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    cluster_ver=$(echo "$mml_output" | grep Cluster_Version | cut -d : -f 2 | sed 's/^[ \t]*//;s/[ \t]*$//')
    if [[ $cluster_ver == 7.1.1.SPC600 ]]; then
        WRITE_XML_COMMON 0 "INFO:The cluster version is ${cluster_ver}. The expansion is not affected."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
    elif [[ $cluster_ver == 7.1.0 ]] || [[ $cluster_ver == 7.1.1 ]] || [[ $cluster_ver == 7.1.1.SPC1 ]] || [[ $cluster_ver == 7.1.1.SPC2 ]] || [[ $cluster_ver == 7.1.1.SPC500 ]]; then
        isPass=4
        WRITE_XML_ERROR 0 "INFO:The cluster version is ${cluster_ver}. Check the NVDIMM vendor of the node to be expanded. If the vendor is Unigen, upgrade the cluster to 7.1.1.SPC600 or later before capacity expansion. Otherwise, capacity expansion will fail."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
    else
        isPass=1
        WRITE_XML_ERROR 0 "INFO:Unrecognized Cluster Version(${cluster_ver})"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
    fi
    return
}

#364 ABE ⵥDTS2024032509315 cifsĿ¼оļȫrdEIO
function checkABESwitch()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local switch="disable"
    local tmpdir="/tmp/CheckABESwitch"
    local tmpfile="${tmpdir}/tmpfileCheckABESwitch"
    local nas="${tmpdir}/nas.sh"
    local totalnum=0
    local offset=0
    local spcversion="--"
    local sphversion="--"
    local sph_num=0
    local enable_num=0
    local enable_share=""
    # Ѳ챨ʾABEع
    local MAX_SHOW_PATH_COUNT=50
    local checkAllFlag=0

    [ -d ${tmpdir} ] && rm -rf ${tmpdir}
    mkdir -p ${tmpdir}
    echo "#!/bin/bash" > $nas
    echo "\$*" >> $nas
    echo " " >> $nas
    chmod +x $nas
    > ${tmpfile}

    totalnum=$($nas /usr/local/bin/nas_proto_cifs -c show-totalnum | grep "<totalnum>" | awk -F '[<>]' '{print $3}' | sed 's/[^0-9]//g')
    LOG "[$FUNCNAME][$LINENO] totalnum:${totalnum}"
    if [ -z "${totalnum}" ]; then
        isPass=1
        switch="--"
        WRITE_XML_ERROR 0 "INFO:Failed to obtain the total number of CIFS shares."
    else
        while true
        do
            # Ʒ CIFSĿ¼Ϊ8192
            if [ ${offset} -ge ${totalnum} -o ${offset} -ge 8192 ]; then
                checkAllFlag=1
                break
            fi
            # ҳѯCIFSãÿβѯ100ABEصĹ·ʱļ
            $nas /usr/local/bin/nas_proto_cifs -c show-page -f ${offset} -t 100 | grep "<abe>enable</abe>" -B5 | grep "<path>.*</path>" >> ${tmpfile}
            enable_num=$(wc -l ${tmpfile} | awk '{print $1}')
            # ﵽȡABEعټѯ
            if [ ${enable_num} -ge ${MAX_SHOW_PATH_COUNT} ]; then
                break
            fi
            let offset+=100
        done

        # CIFSABE
        if [ ${enable_num} -gt 0 ]; then
            switch="enable"
            enable_share=$(head -${MAX_SHOW_PATH_COUNT} ${tmpfile} | awk -F "<path>/localfs/share" '{print $2}' | awk -F "</path>" '{print $1}' | tr "\n" " ")
            [ ${checkAllFlag} -eq 0 ] && enable_share="${enable_share} ..."
            isPass=1
            spcversion=$( cat /opt/huawei/deploy/package/version | grep ProductVersion | awk -F= '{print $2}' | sed -e "s/^ *//g" -e "s/ *$//g" )
            sphversion=$( ls /var/huawei/patch/cur/sph 2>/dev/null| grep -e "OceanStor*" -e "FusionStorage*" | awk -F'_' '{print $NF}' )
            sph_num=$( echo $sphversion | awk -F "SPH" '{print $2}' | sed "s/ *$//g" )
            [ X"${sphversion}" == "X" ] && sphversion="null"
            # 7.1.1.SPC1汾7.1.1.SPH123֮ȲѲͨ
            if [ X"${spcversion}" == X"V500R007C10SPC400" ]; then
                if [ X"${sph_num}" != X"" -a ${sph_num} -ge 123 ]; then
                    isPass=0
                else
                    WRITE_XML_ERROR 0 "INFO:The ABE function is enable and the current patch version(${sphversion}) is too old. The recommended hot patch version is 7.1.1.SPH123 or later."
                fi
            fi
            # ںϰ汾FusionStorage V100R006C30SPC900汾V100R006C30SPH912֮ȲѲͨ
            if [ X"${spcversion}" == X"V100R006C30SPC900" ]; then
                if [ X"${sph_num}" != X"" -a ${sph_num} -ge 912 ]; then
                    isPass=0
                else
                    WRITE_XML_ERROR 0 "INFO:The ABE function is enable and the current patch version(${sphversion}) is too old. The recommended hot patch version is V100R006C30SPH912 or later."
                fi
            fi
        fi
    fi
    
    WRITE_XML_COMMON 0 "ABE Switch:${switch}||Enable ABE share path:${enable_share:---}"
    LOG "[$FUNCNAME][$LINENO]ABE Switch=${switch} sphversion=${sphversion} isPass=$isPass"
    rm -rf ${tmpdir}
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return
}

# 298 ļĿ¼;ۺϲԼ
function checkFileDirRatioAndAggrePolicy()
{
    WRITE_XML_SUBCMD_HEADER $1
    local Result=""
    local serviceType=""
    local MdsLeaderIp1=""
    local MdsLeaderIp2=""
    local MdsNid=""
    local CmConfDb="/opt/huawei/snas/etc/cm_conf.db"
    local isPass=0
    
    # Ƶس漰
    serviceType=$( grep ^serviceType /opt/huawei/snas/etc/snas.ini | awk -F= '{print $2}' )
    if [ X"${serviceType}" != X"surveillance" ]; then
        isPass=3
        LOG "[$FUNCNAME][$LINENO]cluster is not surveillance,does not invoke."
        WRITE_XML_COMMON 0 "This cluster is not surveillance,does not invoke."
        WRITE_XML_JUDGE $isPass > /dev/null
        WRITE_XML_SUBCMD_TAIL
        return
    fi

    # ۺϲԷĿ¼ۺϣ漰ֱ˳
    Policy=$( cat /opt/huawei/snas/etc/ca_d.ini | grep ctnr_policy | awk -F= '{print $2}' )
    if [ X"${Policy}" != X"1" ]; then
        isPass=3
        LOG "[$FUNCNAME][$LINENO]Aggregation policy not firectory aggregation,does not invoke."
        WRITE_XML_COMMON 0 "Aggregation policy(${Policy}) is not directory aggregation,does not invoke."
        WRITE_XML_JUDGE $isPass > /dev/null
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    
    while true
    do
        # ȡmdsڵIP
        MdsLeaderIp1=$( cat /proc/monc_leader | grep "Mds leader" | awk '{print $3}' )
        if [ X"${MdsLeaderIp1}" == X"" -o X"${MdsLeaderIp1}" != X"$( echo ${MdsLeaderIp1} | grep -o '[0-9.]*')" ]; then
            isPass=1
            LOG "[$FUNCNAME][$LINENO]Failed to get MdsLeaderIp:(${MdsLeaderIp1}) from /proc/monc_leader."
            cat /proc/monc_leader >> $LOG_FILE 2>&1
            WRITE_XML_ERROR 0 "Node:(MdsLeader)||INFO:Can't get Mds Leader IP from /proc/monc_leader."
            break
            
        fi
    
        mdsMasterIP=${MdsLeaderIp1}
        MdsNid=$( /usr/bin/sqlite3 ${CmConfDb} "select NID from CM_NODE_IP_T where IP_ADDR='${MdsLeaderIp1}';"| tr -d ' ' )
        if [ X"${MdsNid}" != X"" -a X"${MdsNid}" == X"$( echo ${MdsNid} | grep -o '[0-9]*' )" ]; then
            MdsLeaderIp2=$( /usr/bin/sqlite3 ${CmConfDb} "select IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 and NID=${MdsNid};" | grep -vw ${MdsLeaderIp1} )
            if [ X"${MdsLeaderIp2}" == X"" -o X"${MdsLeaderIp2}" != X"$( echo ${MdsLeaderIp2} | grep -o '[0-9.]*' )" ]; then
                MdsLeaderIp2=""
                LOG "[$FUNCNAME][$LINENO]Failed to get MdsLeaderIp2 from ${CmConfDb}."
            fi
        fi
    
        # MdsִMMLļĿ¼, ִmml "mds info show"
        remote_exec $MdsLeaderIp1 30 "$G_MML_FILE_PATH/ShowInspectMml $MdsLeaderIp1 988 'mds info show' >> $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
        iRet=$?
        #ڵ2Ipִmml
        if [ $iRet -ne 0 -a X"${MdsLeaderIp2}" != X"" ];then
            mdsMasterIP=${MdsLeaderIp2}
            remote_exec $MdsLeaderIp2 30 "$G_MML_FILE_PATH/ShowInspectMml $MdsLeaderIp2 988 'mds info show' >> $G_REMOTE_TMP_FILE2$FUNCNAME 2>&1"
            iRet=$?
        fi

        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME][${LINENO}]:failed to excute mml cmd mds info show on MdsNode:(${MdsLeaderIp1}:${MdsLeaderIp2})."
            errResult="Node:$mdsMasterIP||INFO:Failed to execute command(MmlBatch 988 'mds info show'). Error(${iRet})."
            WRITE_XML_ERROR 0 "${errResult}"
            isPass=1
            break
        fi

        #
        remote_download_sync $mdsMasterIP $G_TMP_FILE $G_REMOTE_TMP_FILE2$FUNCNAME
        iRet=$?
        if [ $iRet -ne 0 ];then
            isPass=1
            LOG "[$FUNCNAME][${LINENO}]download inode infp from $mdsMasterIP fail"
            WRITE_XML_ERROR 0 "Node:$Item||INFO:Failed to download file generated by command(MmlBatch 988 'mds info show'). Error(${iRet})."
            break
        fi

        dirInodeCnt=$( cat $G_TMP_FILE | grep "Sys Dir Inode Count" | dos2unix | awk '{print $NF}' | grep -o '[0-9]*' )
        fileInodeCnt=$( cat $G_TMP_FILE | grep 'Sys File Inode Count' | dos2unix | awk '{print $NF}' | grep -o '[0-9]*' )

        LOG "[$FUNCNAME][${LINENO}]dirInodeCnt:$dirInodeCnt"
        LOG "[$FUNCNAME][${LINENO}]fileInodeCnt:$fileInodeCnt"
        if [ X"${dirInodeCnt}" == X"" -o X"${dirInodeCnt}" == X"0" -o X"${dirInodeCnt}" != X"$( echo ${dirInodeCnt} | grep -o '[0-9]*' )" -o \
             X"${fileInodeCnt}" == X"" -o X"${fileInodeCnt}" != X"$( echo ${fileInodeCnt} | grep -o '[0-9]*' )" ];then
           errResult="Node:$mdsMasterIP||INFO:Get Inode information from output(MmlBatch 988 'mds info show') failed."
           WRITE_XML_ERROR 0 "${errResult}"
           isPass=1
           #
           cat $G_TMP_FILE >> $LOG_FILE 2>&1
           break
        fi
        
        # ļ/Ŀ¼50Ŀ¼ۺϲԣĿ¼ļӡʾŻ
        fileDirRatio=$((fileInodeCnt/dirInodeCnt))
        if [ ${fileDirRatio} -lt 50 ]; then
            Result="CurFileInodeCount:${fileInodeCnt}||CurDirInodeCount:${dirInodeCnt}||FileInodeDirInodeRatio:${fileDirRatio}"
            isPass=4
        fi
        
        Result="CurFileInodeCount:${fileInodeCnt}||CurDirInodeCount:${dirInodeCnt}||FileInodeDirInodeRatio:${fileDirRatio}"
        WRITE_XML_COMMON 0 "$Result"
        
        break
    done

    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#ûдѲΪ
noInspectItem()
{
    WRITE_XML_SUBCMD_HEADER $1
    WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
    WRITE_XML_JUDGE 3
    WRITE_XML_SUBCMD_TAIL
    LOG "[$FUNCNAME][$LINENO]The current system does not support the appointed inspect item!"
}

# **************************************************************************** #
# Function Name: checkSoftwareStatus
# Description: Software м.
# Parameter: $1 cmditemID ; $2 2ճ3 4
# Return:
# **************************************************************************** #
checkSoftwareStatus()
{
    local checkid=$1
    local startTime=0
    local endTime=0
    touch /tmp/check_thread_count$$
    startTime=$(date +%s)
    LOG "[${FUNCNAME}]Enter ${REMOTE_IP} inspect item ${checkid}, result file $G_CHECK_RESULT_FILE"


    rm -rf $G_SCRIPT_PATH/tmpfile$$*
    rm -rf $G_SCRIPT_PATH/tmpfilex$$*
    rm -rf /tmp/tmpfile$$*

    LOG "[$FUNCNAME] param = ($1)"
    case $1 in
        201)#ڵ
            #3.Check Node Throughput
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkNodeThroughput 0"
            ;;
        208)
            #9.Check License status
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkLicenseStatus_MML 0"
            ;;
        212)
            #13.Check DS Usage
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkDSUsage 0"
            ;;
        216)
            #Check System inode(ϵͳinodeBirth)
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkFileInodeAndBirthCount 0"
            ;;
        217)
            #Check AD ״̬
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkADDomain 0"
            ;;
        219)
            #Check NIS ط״̬
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkNIS 0"
            ;;
        220)
            #Check external DNS
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkExtDnsConn 0"
            ;;
        223)
            #Check Tierּ
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkTier 0"
            ;;
        224)
            #Ƿδĸ澯
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkLeftAlarm_MML 0"
            ;;
        228)
            #DAB̨״̬
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkDabTask 0 2"
            ;;
        229)
            #Ⱥֻˮλ
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkReadOnlyThreshold 0"
            ;;
        230)
            #nlun״̬
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "getNlunStatus 0"
            ;;
        238)
            #bjm̼
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkBJM 0"
            ;;
        239)
            #1.Check System Information
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkSystemInfo_MML 0"
            ;;
        240)
            #1.Check pool status
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkNodePoolStatus 0"
            ;;
        241)
            #Ȳ汾
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkHpatchOperation 0"
            ;;
        243)
            #
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkQuotaServe 0"
            ;;
        257)
            #ssdc mpool_memsizeü
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkSSDCMpoolMemsize 0"
            ;;
        256)
            #AV Server״̬
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkAvServerStatus 0"
            ;;
        262)
            #license
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkExpandLicense 0"
            ;;
        263)
            #CMڵdeploy̼
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkCMMasterDeploy 0"
            ;;
        265)
            #Nlun
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "CheckNlunCount 0 4"
            ;;
        273)
            #ݾ ճѲ
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkBalanceStatus 0 2"
            ;;
        283)
            #鹲Ŀ¼
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkRedundantRatio 0"
            ;;
        284)
            #Эɾ־Ŀ¼
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkNasLogDir 0"
            ;;
        293)
            #ǷڵڵЭ
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkProtoSubdomain 0"
            ;;
        297)
           #nluncomplete״̬ ճѲ
           WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkNlunCompletePoolState 0 2"
            ;;
        298)
           #ļĿ¼;ۺϲԼ ճѲ
           WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkFileDirRatioAndAggrePolicy 0"
            ;;
        333)
           #xattrxinfoü
           WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkXinfoXattr 0"
            ;;
        345)
           #˺ĬϿ
           WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkAccountDefaultPassword 0"
            ;;
        363)
            #ǰļȺ汾
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkClusterVerBeforeExpansion 0"
            ;;
        364)
            #ABE
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkABESwitch 0"
            ;;
        403)
           #nluncomplete״̬ Ѳ
           WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkNlunCompletePoolState 0 4"
            ;;
        405)
            #DAB̨״̬
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkDabTask 0 4"
            ;;
        406)
            #ݾ Ѳ
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "checkBalanceStatus 0 4"
            ;;
        *)
            WRITE_XML_HD_AND_TL_ON_MASTER "$1" "noInspectItem 0"
            ;;
        esac
    chmod 640 $LOG_FILE

    endTime=$(date +%s)
    LOG "[${FUNCNAME}]Exit ${REMOTE_IP} inspect item ${checkid}, elapsed time $((endTime-startTime))"
    rm -f /tmp/check_thread_count$$
}

###add Ѳ¿ܣѲ270-275#################

local_exec_cmd()
{
    taskids=$1
    params=$2
    ${G_MML_FILE_PATH}/CheckItems "$taskids"> $G_DOWNLOAD_FILE$3 2>&1
    iRet=$?
    if [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME]||INFO:cmd failed taskids:($taskids)"
    fi
}

CheckLocalMsgParse()
{
    local CheckMsg=$1
    local PassCode=$2
    set_ifs
    for line in ${CheckMsg}
    do
        if [ "${line}" != "" ]; then
            info=`handle_remote_result "$line"`
            if [ $? -ne 0 ]; then
                WRITE_XML_ERROR 0 "${info}" >/dev/null
                LOG "[$FUNCNAME]:INFO:inspect error ${info}"
            else
                WRITE_XML_COMMON 0 "${info}" >/dev/null
            fi
        fi
    done
    restore_ifs
}

#Ѳ
CheckLocalPassStatus()
{
    local PassCode=1
    local fun=$1
    local RemoteIp=$2
    local process=$3
    local fun_end=${fun}_End
    local strGrep=""
    if [ "x${process}" != "x" ];then
        strGrep=${fun}_${process}_Pass
    else
        strGrep=${fun}_Pass
    fi
    local CheckMsgFile="/tmp/CheckMsgFile${fun}$$"
    cat $G_DOWNLOAD_FILE$RemoteIp |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' >${CheckMsgFile}
    local PassStatus=$(cat ${CheckMsgFile} |eval grep '${strGrep}' |awk '{print $NF}')
    if [[ "${PassStatus}" =~ ^[0-9]+$ ]];then
        PassCode=${PassStatus}
    else
        LOG "[$FUNCNAME]||$fun get Passcode failed from $RemoteIp : PassStatus is ${PassStatus}"
    fi
    #ӽڵѲϢ
    local CheckMsg=""
    if [ "x${process}" != "x" ];then
        CheckMsg=$(cat ${CheckMsgFile} | grep -v ${fun}_[0-9]*_Pass)
    else
        CheckMsg=$(cat ${CheckMsgFile} | grep -v ${strGrep})
    fi
    if [ "$CheckMsg" = "" ]; then
        WRITE_XML_ERROR 0 "$fun Get CheckMsg failed from $RemoteIp"
    else
        CheckLocalMsgParse "${CheckMsg}" "$PassCode"
    fi
    rm -rf $CheckMsgFile

    WRITE_XML_JUDGE $PassCode >/dev/null
}

analyse_local_result()
{
    #Զؽһ£xmlд뷽ʽֻܴС
    MainNodeIp=$2
    for taskid in $1
    do
        InspectFun=`GetInspectType $taskid`
        G_CHECK_RESULT_FILE="/tmp/check_result_file"$taskid
        > $G_CHECK_RESULT_FILE
        WRITE_XML_HEADER >/dev/null
        WRITE_XML_CMD_HEADER $taskid >/dev/null
        WRITE_XML_SUBCMD_HEADER "0" >/dev/null
        if [ "$InspectFun" != "" ];then
            CheckLocalPassStatus "$InspectFun" "$MainNodeIp"
        else
            LOG "[$FUNCNAME]||INFO:The current system does not support the appointed inspect item($taskid)!"
            WRITE_XML_COMMON 0 "The current system does not support the appointed inspect item!"
        fi
        WRITE_XML_SUBCMD_TAIL >/dev/null
        WRITE_XML_CMD_TAIL >/dev/null
        WRITE_XML_TAIL $taskid >/dev/null
    done
}

#ִ
exec_cmd()
{
    remoteIp=$1
    taskids=$2
    params=$3
    exec_taskid="CheckItems"
    command="${G_MML_FILE_PATH}/CheckItems '$taskids'> $G_REMOTE_EXEX_RESULT${params} 2>&1"
    remote_exec_async $remoteIp $exec_taskid 600 "$command"
    iRet=$?
    if [ $iRet -ne 0 ]; then
        LOG "[$FUNCNAME][$LINENO]Node:$remoteIp||INFO:Failed to exec_cmd command.item ${taskids}"
    fi
}

function download_result()
{
    remoteIp=$1
    params=$2
    TASK_ID="CheckItems"
    local iRet=0
    #ѭֱسɹʧܺ˳ѭ
    while [[ ${remoteIp} != "" ]]
    do
    {
        remote_exec_checkfini $remoteIp $TASK_ID "download ($remoteIp) exec result failed"
        iFunRet=$?
        if [ $iFunRet -eq 0 ];then
            continue
        elif [ $iFunRet -eq 2 -o $iFunRet -eq 5 ];then
            iRet=0
        elif [ $iFunRet -eq 125 ];then # timeout=125
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO: remote_exec_checkfini return ($iFunRet)download_result checkfini failed."
            iRet=125
        else
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO: remote_exec_checkfini return ($iFunRet)download_result checkfini failed."
            iRet=1
        fi

        #Ϊ100%֮ļؽнcheckfiniɹִزԶʱļ
        remote_download_sync $remoteIp $G_DOWNLOAD_FILE$remoteIp $G_REMOTE_EXEX_RESULT$params
        iFunRet=$?
        if [ $iFunRet -ne 0 ];then
            LOG "[$FUNCNAME]:Node: $remoteIp||INFO:remote_download_sync return ($iFunRet) download_result download file failed."
            [ ${iRet} -eq 0 ] && iRet=126 # checkfini succuss, download fail=126
        fi
        break
    }
    done
    return $iRet
}

CheckMsgParse()
{
    Remote_ip=$1
    CheckMsgFile=$2
    PassCode=$3
    dos2unix $CheckMsgFile > /dev/null 2>&1
    index=0
    while read var
    do
        if [ "$var" != "" ]; then
            if [ "$PassCode" = "1" ];then
                WRITE_XML_ERROR 0 "Node: $Remote_ip||${var}" >/dev/null
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:inspect error ${var}"
            else
                WRITE_XML_COMMON 0 "Node: $Remote_ip||${var}" >/dev/null
            fi
        fi
    done < "$CheckMsgFile"
}

CheckPassStatus()
{
    isPass=0
    fun=$1
    fun_end=${fun}_End
    strGrep=${fun}_Pass
    REMOTE_IP_S=`cat $IP_ROLE_FILE`
    CheckMsgFile="/tmp/CheckMsgFile${fun}$$"

    for Remote_ip in $REMOTE_IP_S
    do
    {
        PassStatus=$(cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$fun/d' |eval sed '/$fun_end/,\$\d' |eval grep '${strGrep}' |awk '{print $2}')
        if [ "$PassStatus" = "" ];then
            LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:($fun) get PassStatus failed"
            WRITE_XML_ERROR 0 "Node:$Remote_ip||INFO:($fun) get PassStatus failed!"
            isPass=1
        else
            #ӽڵѲϢ
            cat $G_DOWNLOAD_FILE$Remote_ip |eval sed '0,/$fun/d' |eval sed '/$strGrep/,\$\d' >$CheckMsgFile
            #дѲXML
            CheckMsg=$(cat $CheckMsgFile)
            if [ "$CheckMsg" = "" ];then
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:($fun) get CheckMsg failed"
                WRITE_XML_ERROR 0 "Node:$Remote_ip||INFO:($fun) get CheckMsg failed!"
            else
                CheckMsgParse "$Remote_ip" "$CheckMsgFile" "$PassStatus"
                rm -rf $CheckMsgFile
            fi
            if [ "$PassStatus" !=  "0" ]; then
                LOG "[$FUNCNAME]:Node: $Remote_ip||INFO: ${fun} check result:$PassStatus."
                isPass=$PassStatus
            fi
        fi
    }
    done
    WRITE_XML_JUDGE $isPass >/dev/null
}

analyse_result()
{
    #xmlдļG_CHECK_RESULT_FILE У̴ᵼд󣬹ʴС
    #ڿɸıдxmlʽŻΪС
    taskids=$1
    for taskid in $taskids
    do
        InspectFun=`GetInspectType $taskid`

        G_CHECK_RESULT_FILE="/tmp/check_result_file"$taskid
        > $G_CHECK_RESULT_FILE
        WRITE_XML_HEADER >/dev/null
        WRITE_XML_CMD_HEADER $taskid >/dev/null
        WRITE_XML_SUBCMD_HEADER "0" >/dev/null
        if [ "$InspectFun" != "" ];then
            CheckPassStatus $InspectFun
        else
            LOG "[$FUNCNAME]:Node: $Remote_ip||INFO:The current system does not support the appointed inspect item(taskid:$taskid)!"
            WRITE_XML_COMMON 0 "INFO:The current system does not support the appointed inspect item(taskid:$taskid)!"
        fi
        WRITE_XML_SUBCMD_TAIL >/dev/null
        WRITE_XML_CMD_TAIL >/dev/null
        WRITE_XML_TAIL $taskid >/dev/null
    done
}

# **************************************************************************** #
# Function Name: checkSoftwareStatusEx
# Description: Software мչ.
# Parameter: $1 cmditemID
# Return:
# **************************************************************************** #
checkSoftwareStatusEx()
{
    touch /tmp/check_thread_count$$
    local check_id=$1
    #ȡеĺIPִ
    REMOTE_IP_S=`cat $IP_ROLE_FILE`

    #ȡǰڵipַ
    local MainNodeIP=`get_backnet_ip`
    local Num=0

    local local_taskids="${check_id} ${onlyInspectOnOneNode#*${check_id}}"
    local end_taskid=$(echo ${local_taskids} | awk '{print $6}')
    #ѲܿݲƸ local_taskids=${local_taskids%${end_taskid}*} #ȡ5Ѳ
    local remote_taskids=""
    local Params=$(echo ${check_id}|tr '[0-9]' '[A-J]')
    local startTime=0
    local endTime=0
    local diffTime=0
    local iRet=0
    startTime=$(date +%s)
    LOG "[${FUNCNAME}][$LINENO]Enter inspect item ${alltask}"
    for REMOTE_IP in $REMOTE_IP_S
    do
        if [ "$REMOTE_IP" = "$MainNodeIP" ]; then
            alltask="$local_taskids $remote_taskids"
            if [ -n "${alltask}" ]; then
            G_CHECK_IDLIST="${alltask}"
            local_exec_cmd "${alltask}" "$Params" "$MainNodeIP"
            fi
        else
            alltask="${remote_taskids}"
            if [ -n "${alltask}" ]; then
            G_CHECK_IDLIST="${alltask}"
            exec_cmd "${REMOTE_IP}" "${alltask}" "$Params"
            fi
        fi

    done

    for REMOTE_IP in $REMOTE_IP_S
    do
        if [ "$REMOTE_IP" = "$MainNodeIP" ]; then
            continue
        else
          alltask="${remote_taskids}"
          if [ -n "${alltask}" ]; then
            download_result "${REMOTE_IP}" "$Params"
            iRet=$?
            #ʧ
            if [ ${iRet} -eq 126 ]; then
                download_result "${REMOTE_IP}" "$Params"
            fi
          fi
        fi
    done
    endTime=$(date +%s)
    diffTime=$((endTime - startTime))
    LOG "[${FUNCNAME}][$LINENO]Exit inspect item ${alltask}, elapsed time:${diffTime}s"

    analyse_local_result "${local_taskids}" "$MainNodeIP"
    analyse_result "${remote_taskids}"
    rm -f /tmp/check_thread_count$$
}
##end add

