#!/bin/sh

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh

function usage()
{
    echo "$ScriptHardwareFname <product_name> <version> <output_file> <begin_time> <end_time> [log_size]"
    echo "product_name          collect product name"
    echo "version               collect product version"
    echo "output_file           collect file to save the log, eg: *.tar.gz"
    echo "begin_time            collect start time, the default value is null"
    echo "end_time              collect end time, the default value is null"
    echo "log_size              collect size of file"
    return 0
}

#ʱΪʱմСȡ־
function Hardware_collectBySize()
{
    local size=$1
    local need_size="${size}"
    local is_T3000=0
    local is_RHNode=0
    local HWtarFile=""
    local HWpath=""
    log "start collect Hardware,size=${size}"
    local sub_path="${MessageDir}/Hardware/"
    rm -rf ${sub_path}
    mkdir -p ${sub_path}

    #жǷΪT3000
    IsT3000Node
    is_T3000=$?
    #жǷΪRH,RH2288 5288
    IsRHNode
    is_RHNode=$?
	
    #Ǹܿڵִcollect_t3000_log.sh
    if [ ${is_T3000} -eq 0 ]; then
        dmidecode -t 4 | grep -q "Family: Atom"
        if [ $? -ne 0 ]; then  
            cd /opt/huawei/snas/bin/
            HWtarFile=`ls t3000infor_* | grep "tar.gz$"`
            tar -zxf  ${HWtarFile}
            HWpath=`ls -d t3000infor_* | grep -v "tar.gz"`
            cd  ${HWpath}
            #ִCollectBmcLog.shᵼ¹߽ղԣռʱݲִ
            #./CollectBmcLog.sh ${sub_path} > /dev/null 2>&1
            sh T3000GetLog.sh ${sub_path}  > /dev/null 2>&1
            cd /opt/huawei/snas/bin/
            rm -rf ${HWpath}
        fi
    fi
    
    #T3000RHִ־ռ
    if [ ${is_T3000} -eq 0 ] || [ ${is_RHNode} -eq 0 ];then
        /opt/huawei/snas/bin/pangea_log_eth.sh ${sub_path}
        /opt/huawei/snas/bin/pangea_log_ib.sh ${sub_path}
        cp /var/log/sel.log ${sub_path}
        cp /var/log/sel.log.bak ${sub_path}
    fi

    #RHִ־ռ
    if [ ${is_RHNode} -eq 0 ];then
        /opt/huawei/snas/bin/pangea_log_sas.sh ${sub_path}
        /opt/huawei/snas/bin/pangea_log_ses.sh ${sub_path}
    fi
    
    #жǷIB
    IsIBNode
    is_IBNode=$?
    if [ ${is_IBNode} -eq 0 ];then
        /opt/huawei/snas/bin/pangea_log_ib.sh ${sub_path}
    fi
    
    #
    cd ${sub_path}
    tar zcf ${output_file} ./*
    if [ -d ${sub_path} ];then
        rm -rf ${sub_path}/*
    fi
    log "end collect Hardware"
}

function Hardware_collectByTime()
{
    log "collect Hardware by time,from [${begin_time}] to [${end_time}]"
    local sub_path="${MessageDir}/Hardware/"
    local HWtarFile=""
    local HWpath=""
    rm -rf ${sub_path}
    mkdir -p ${sub_path}
	
    #жǷΪT3000
    IsT3000Node
    is_T3000=$?
    #жǷΪRH,RH2288 5288
    IsRHNode
    is_RHNode=$?
	
    #Ǹܿڵִcollect_t3000_log.sh
    if [ ${is_T3000} -eq 0 ]; then
        dmidecode -t 4 | grep -q "Family: Atom"
        if [ $? -ne 0 ]; then  
            cd /opt/huawei/snas/bin/
            HWtarFile=`ls t3000infor_* | grep "tar.gz$"`
            tar -zxf  ${HWtarFile}
            HWpath=`ls -d t3000infor_* | grep -v "tar.gz"`
            cd  ${HWpath}
            #./CollectBmcLog.sh ${sub_path} > /dev/null 2>&1
            sh T3000GetLog.sh ${sub_path}  > /dev/null 2>&1
            cd /opt/huawei/snas/bin/
            rm -rf ${HWpath}
        fi
    fi
    
    #T3000RHִ־ռ
    if [ ${is_T3000} -eq 0 ] || [ ${is_RHNode} -eq 0 ];then
        /opt/huawei/snas/bin/pangea_log_eth.sh ${sub_path}
        /opt/huawei/snas/bin/pangea_log_ib.sh ${sub_path}
        cp /var/log/sel.log ${sub_path}
        cp /var/log/sel.log.bak ${sub_path}
    fi

    #RHִ־ռ
    if [ ${is_RHNode} -eq 0 ];then
        /opt/huawei/snas/bin/pangea_log_sas.sh ${sub_path}
        /opt/huawei/snas/bin/pangea_log_ses.sh ${sub_path}
    fi

    #
    cd ${sub_path}
    tar zcf ${output_file} ./*
    if [ -d ${sub_path} ];then
        rm -rf ${sub_path}/*
    fi
    log "end collect Hardware"
}

#ռӲϢ
function collectSSDInfo()
{
    local DevSsd=""
    local max_loginfonum=6;
    local log_head_info=""
    local get_log_cmd=""
    local cnt=0;
    local CmdPort=4016;
    log "start collect ssd log"

    head_info=("Useful information of disk"
    "smart value"
    "smart threshold" 
    "The NV log of HSSD SAS" 
    "The Flash Log of HSSD SATA "
    "The Flash of HSSD SAS "
    "The current log of HSSD SAS")
    cmd_info=("disktool -f a"
    "disktool -A o -z smartval"
    "disktool -A o -z smartthr"
    "disktool -A o -z log"
    "disktool -A o -z log2"
    "disktool -A o -z log3"
    "disktool -A o -z log4")

    DevSsd=`lsscsi | grep "/dev/sd" | grep HSSD | awk {'print $NF'}`
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "cm showdiskname" >/tmp/collectSSDInfo 2>&1
    dos2unix /tmp/collectSSDInfo
    sed -i -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g' /tmp/collectSSDInfo 2>&1
    DevSsd=`cat /tmp/collectSSDInfo |grep Disk_Type:3 |awk '{print $3}'`
    for cnt in `seq 0 $max_loginfonum`; do

        log_head_info="${head_info[$cnt]}"
        get_log_cmd="${cmd_info[$cnt]}"
        log "***********************$log_head_info**********************" >>$SSD_LOG_FILE
        log "$get_log_cmd"
        for line in $DevSsd
        do
            log "**********$line info**********" >>$SSD_LOG_FILE

            $get_log_cmd $line >>$SSD_LOG_FILE
            if [ $? -ne 0 ];then
                $get_log_cmd $line >>$SSD_LOG_FILE
            fi
        done
    done

    #Ϣ
    cat /proc/mpt2sas/mpt2sas0-drives > "$CMLogDir"Other/disk_info
    disktool -f A >> "$CMLogDir"Other/disk_info
    log "$Item: Get mpt2sas0-drives info.ret($?)"
   
    cp -f /proc/interrupts "$CMLogDir"/Other/interrupts
    log "$Item: Get interrupts file,ret($?)"
    
    #ռdisktool־
    cp -rf /tmp/disktool_log* "$CMLogDir"/Other/ >/dev/null 2>&1
    log "$Item: Get disktool_log* file,ret($?)"
    
    adjustSize
    log "end collect ssd log"

    return 0
}

function main()
{

    if [ "X${type}" == "Xconfig" ];then
        collectSSDInfo
    elif [ "X${type}" == "Xlog" ];then
        if [ "X$begin_time" == "Xnull" -a "X$end_time" == "Xnull"  -a "X${log_size}" != "X" ];then
            Hardware_collectBySize ${log_size}
        elif [ "X$begin_time" != "Xnull" -o "X$end_time" != "Xnull" ];then
            Hardware_collectByTime
        fi
    else
        usage
        return 1
    fi
    return 1
}

type=$1
product_name=$2
version=$3
output_file=$4
begin_time=$5
end_time=$6
log_size=$7

#жϲƷ
judge_product_type
prepare

main
exit $?