#!/bin/sh

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh

TMP_OSS_BASE_PATH="${CMLogDir}../tmp_OSS"
TMP_OSS_MSG_PATH="${TMP_OSS_BASE_PATH}/Messages"
g_OSS_collect_bysize=1
SUBNAME="OSS"
#ļ, snas.log
function usage()
{
    echo "$ScriptOSSFname <product_name> <version> <output_file> <begin_time> <end_time> [log_size]"
    echo "product_name          collect product name"
    echo "version               collect product version"
    echo "output_file           collect file to save the log, eg: *.tar.gz"
    echo "begin_time            collect start time, the default value is null"
    echo "end_time              collect end time, the default value is null"
    echo "log_size              collect size of file"
    return 0
}

#Ҫռ־ȷЩ־ļռ
function get_cfglog_seconds()
{
    local rc=0
    local cur_sec=0
    
    if [ 1 -eq ${g_OSS_collect_bysize} ];then
        cur_sec=$(date +%s)
        rc=$?
        ret_seconds ${cur_sec}
        return ${rc}
    else
        endtime_s=$( getSeconds "${end_time}" )
        let "cur_sec=endtime_s - 1"
        ret_seconds ${cur_sec}
        return $?
    fi
}

function getUtcSecondsFromOSSFileName()
{
    local fname=$1
    local sname=$(basename ${fname})
    local tmp=""
    local cuttail=""
    local cur_sec=$(get_cfglog_seconds)
    local sec=0
    local rc=0
    
    echo ${sname} | grep "s3.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #s3.log.2018-11-29_21.tar.gz  
        tmp=${sname##*s3.log.}
        cuttail=$(echo ${tmp%.tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "s3.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #s3.log.2019-01-08_04_1.tar.gz   
        tmp=${sname##*s3.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    ##/var/log/ S3/servicelog/ s3/scriptLog/ ޺׺ʱ
    ret_seconds ${cur_sec}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
    fi
    return ${rc}
}
 function OSSGetLoglist()
{
    local out_file=${1}
    local sub_paths="/var/log/s3 /var/log/backup/s3 /var/log/backup/OSS"
    local in_rec_file=""
    local des_path="${MessageDir}OSS"
    local loc_cur_logs="s3/servicelog/ s3/scriptlog/"
    local loc_tar_logs="s3.log"
    local loc_file=""
    local out_basedir=$(dirname ${out_file})
    
    if [ $# -gt 1 ];then
        in_rec_file=${2}
        if [ ! -f ${in_rec_file} ];then
            log [$FUNCNAME][$LINENO]"ERROR, ${in_rec_file} is not exist!"
            return 1
        fi 
        #files in FileSystem 
        for file in ${loc_tar_logs}
        do
            grep "${file}.*.tar.gz" ${in_rec_file} | awk -v dpath=${des_path} '{print $NF" file " $5 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get ${file}.*.tar.gz from ${rec_file} and redirect to ${out_file} fail"
        done
        return 0
    else
        
        for file in ${loc_cur_logs}
        do
            #˴ļļ,һƹȥ,β?
            echo "/var/log/${file} dir -1 ${des_path} 1 0" >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, echo /var/log/${file} dir -1 ${des_path} 0 0 >> ${out_file} fail"
            #ls -l /var/log/${file}* 2> /dev/null | grep -v ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/${file} >> ${out_file} fail"
        done
       
        #ѹļs3.log.2018-11-29_21.tar.gz 
        for path in ${sub_paths}
        do
            for file in ${loc_tar_logs}
            do
                if [ -d "${path}" ];then
                    ls -l ${path}/${file}* 2> /dev/null | grep ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/${file}* >> ${out_file} fail"
                fi 
            done
        
        done
        return 0
    fi

}

function OSS_collect()
{
    log [$SUBNAME]"start collect OSS,size:${log_size},begin_time:${begin_time},end_time:${end_time}"
    local collect_sub=$1
    local begin_time=$2
    local end_time=$3
    local size=$4
    local need_size="${size}"
    local rc=0
    local sub_path="${MessageDir}OSS"
    available_size=$(getAvailableSize)
    log "available size is:${available_size}"
    if [ $(echo "${MIN_VALUE} > ${available_size}" | bc) -eq 1  ];then
        echo "collect size will over 90%, exit collect"
        log [$SUBNAME]"collect size will over 90%, exit collect."
        clean
        exit 1
    fi
    
    rm -rf ${sub_path}
    mkdir -p ${sub_path}
    
    collect_compressed_logs "${collect_sub}" "${size}" "${begin_time}" "${end_time}" OSSGetLoglist getUtcSecondsFromOSSFileName dfs_s3_cp
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect_compressed_logs ${collect_sub} ${collect_size} ${begin_time} ${end_time} OSSGetLoglist getUtcSecondsFromOSSFileName dfs_s3_cp fail with ${rc}"
    fi
    
    #delete tempory path.
    if [ -d ${TMP_OSS_BASE_PATH} ] ;then
        rm -rf ${TMP_OSS_BASE_PATH} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm ${TMP_OSS_BASE_PATH} fail"
    fi
    #ʹÿռ
    adjustSize
    real_size=$(du "${sub_path}" | tail -n1 | cut -f1)
    
    #
    cd ${sub_path}
    #tar zcvf ${output_file} ./* >/dev/null 2>&1
    tar cvf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1 
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, tar cvf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1  fail with ${rc}"
    fi
    if [ -d ${sub_path} ] ; then
        rm -rf ${sub_path}/* || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm -rf ${sub_path}/* fail"
    fi
    
    log [$SUBNAME]"end collect ${collect_sub},real size is ${real_size},"
    return 0
}

#S3Ϣռ
function collectOSSInfo()
{
    local ConfigDir="${CMLogDir}/Config/s3"
    local OldUdsFile="${ConfigDir}/ErasureCodeDecodingMat"
    mkdir -p "${ConfigDir}"
    log "start collect s3 config information."
    cp -fpr /opt/obs/dns/conf/* "${ConfigDir}"
    cp -fpr /opt/obs/obsconf/* "${ConfigDir}"
    #ɾUDSļ
    if [ -f $OldUdsFile ];then
        rm -rf $OldUdsFile
    fi
    #ɾռظSwiftϢ
    rm -rf  "${ConfigDir}/swift"    
    if [ $ServiceType -eq 0 ];then
    #SwiftϢ
    local SwiftConfigDir="${CMLogDir}/Config/swift"
    mkdir -p "${SwiftConfigDir}"
    log [$SUBNAME]"start collect swift config information."

    cp -fpr /opt/obs/obsconf/swift* "${SwiftConfigDir}"
    if [ "$SERVICE_TYPE" == "vm" ]; then
        local vmmsConfigDir="${CMLogDir}/Config/vmms/conf"
        mkdir -p "${vmmsConfigDir}"
        log [$SUBNAME]"start collect swift config information."
        cp -fpr /var/vmms/conf/* "${vmmsConfigDir}" 
    else
        log [$SUBNAME]"SERVICE_TYPE($SERVICE_TYPE) is not vm"
        fi
    fi
}

function main()
{
    if [ "X${type}" == "Xconfig" ];then
        log [$SUBNAME]"start collect config"
        collectOSSInfo
        log [$SUBNAME]"end collect config"
        return 0
    elif [ "X${type}" == "Xlog" ];then
        if [ "X$begin_time" != "Xnull" -o "X$end_time" != "Xnull" ];then
            g_OSS_collect_bysize=0
            log_size="0" 
        fi
        OSS_collect "OSS" "${begin_time}" "${end_time}" "${log_size}"
        return $?
    else
        usage
        return 1
    fi
    return 1
}

type=$1
product_name=$2
version=$3
output_file=$4
begin_time=$5
end_time=$6
log_size=$7

#жϲƷ
judge_product_type
prepare

main
exit $?
