#!/bin/bash

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh

type=$1
product_name=$2
version=$3
output_file=$4

sub_path=${MessageDir}Diskinfo/
rm -rf ${sub_path}
mkdir -p ${sub_path}

smart="${sub_path}smart0.txt"
summary="${sub_path}summary.ini"
tmp_nodename="${sub_path}tmp_nodename.txt"
>$tmp_nodename
>$smart
>$summary

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}
MapDiskType()
{
    case $1 in
        0)
            echo "FC"
            ;;
        1)
            echo "SAS"
            ;;
        2)
            echo "SATA"
            ;;
        3)
            echo "SSD"
            ;;
        4)
            echo "NL_SAS"
            ;;
        5)
            echo "SLC_SSD"
            ;;
        6)
            echo "MLC_SSD"
            ;;
        *)
            echo "No this type"
            ;;
    esac
}

/usr/local/bin/MmlBatch 4016 "cm node show" > $tmp_nodename  2>&1

basicinfo="${sub_path}basicinfo.txt"
>$basicinfo

DiskinfoAll=`/usr/local/bin/MmlBatch 4016 "cm localdiskinfo show"`
sleep 15
set_ifs
#判断是否mml回显过长，生成临时文件
echo "$DiskinfoAll" | grep "/tmp/tmpfilelocaldiskinfo" |awk -F" " '{print $4}' >/dev/null
if [ $? -eq 0 ];then
    DiskinfoAll=`cat /tmp/tmpfilelocaldiskinfo`
fi

for line in $DiskinfoAll;do
    if [ $line = "" ];then
        continue
    fi
    runningStatus=$(echo "${line}" | awk -F'\\|\\|' '{print $5}' | awk -F':' '{print $2}' | tr -d ' ')
    if [ "$runningStatus" = "" ];then
        continue
    else
        if [ $runningStatus -eq 27 ];then
            parentID=$(echo "${line}" | awk -F'\\|\\|' '{print $2}' | awk -F':' '{print $2}' | tr -d ' ')
            ID_hostname=$(cat $tmp_nodename | grep "Node_ID: $parentID " | awk -F'\\|\\|' '{print $2}' | awk -F':' '{print $2}' | tr -d ' ')
            slot=$(echo "${line}" | awk -F'\\|\\|' '{print $3}' | awk -F':' '{print $2}' | tr -d ' ')
            ID="$ID_hostname.$slot"
            
            diskType=$(echo "${line}" | awk -F'\\|\\|' '{print $6}' | awk -F':' '{print $2}' | tr -d ' ')
            diskType=$(MapDiskType $diskType)

            manu=$(echo "${line}" | awk -F'\\|\\|' '{print $12}' | awk -F':' '{print $2}' | tr -d ' ')
              
            SN=$(echo "${line}" | awk -F'\\|\\|' '{print $13}' | awk -F':' '{print $2}' | tr -d ' ')  
            echo "$ID $diskType $manu $SN" >> $basicinfo
        fi
    fi
done
restore_ifs

#判断是否为服务器节点
function IsRHNode()
{
    local name=''
    name=$(dmidecode -t 1 | grep "Product Name:" | awk '{print $3}')
    if [ "$name" = "RH2288" -o "$name" = "5288" -o "$name" = "RH2288H" ]; then
        return 0
    else
        return 1
    fi
}
set_ifs

IsRHNode
if [ $? -eq 0 ];then
    #服务器环境查询smart0信息。
    disknumber=0
    successnumber=0
    diskDevice=$(lsscsi|grep -v "Logical Volume")
   
    for line in $diskDevice;do
        diskname=$(echo $line | awk '{print $(NF-0)}')
        disktype=$(echo $line | awk '{printf $2}')
        
        if [ "X${diskname}" != "X-" ] && [ "X${disktype}" == "Xdisk" ] ;then
            #查询出盘符，则认为盘存在
            disknumber=$((disknumber+1))
            diskinfo=$(/usr/local/bin/disktool -f a $diskname)
            echo "$diskinfo" |grep "Serial Number" >/dev/null 2>&1
            if [ $? -eq 0 ];then
                successnumber=$((successnumber+1))
                echo "$diskinfo" >> $smart
            else
                echo "baddisk:$diskname,$diskinfo" >> $smart
            fi
        fi
    done
    echo "total=$disknumber" >> $summary
    echo "success=$successnumber" >> $summary
else
    #普通设备查询smart0的信息，所有节点都需要执行
    disknumber=0
    successnumber=0
    diskDevice=$(/usr/local/bin/disktool -s)

    for line in $diskDevice;do
        diskname=$(echo $line | awk '{printf $1}')
        if [ "$diskname" != "Device" ];then
            #查询出盘符，则认为盘存在
            disknumber=$((disknumber+1))
            diskinfo=$(/usr/local/bin/disktool -f a $diskname)
            echo "$diskinfo" |grep "Serial Number" >/dev/null 2>&1
            if [ $? -eq 0 ];then
                #使用disktool -f a name获取的内容不为空，切SN不为空，则认为获取成功
                successnumber=$((successnumber+1))
                echo "$diskinfo" >> $smart
            else
                echo "baddisk:$diskname,$diskinfo" >> $smart
            fi
        fi
    done
    echo "total=$disknumber" >> $summary
    echo "success=$successnumber" >> $summary
fi
restore_ifs
rm $tmp_nodename

cd $sub_path
tar zcvf ${output_file} ./* >/dev/null 2>&1
if [ -d ${sub_path} ];then
    rm -rf  ${sub_path}
fi

