#!/bin/bash

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh
sub_path="${MessageDir}Disklog/"
normal_path="${sub_path}Normal/"
abnormal_path="${sub_path}Abnormal/"
rm -rf $sub_path
mkdir -p $normal_path
mkdir -p $abnormal_path
G_DISK_NAMESN=${sub_path}diskname_sn
G_DISK_MML_NAMESN=${sub_path}diskname_mml_sn

#判断是否为服务器节点
function IsRHNode()
{
    local name=''
    name=$(dmidecode -t 1 | grep "Product Name:" | awk '{print $3}')
    if [ "$name" = "RH2288" -o "$name" = "5288" -o "$name" = "RH2288H" ]; then
        return 0
    else
        return 1
    fi
}

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

#获取盘符和SN号，T3000用disktool，服务器用lsscsi和disktool组合
function Get_DISKMap()
{
    set_ifs
    IsRHNode
    if [ $? -eq 0 ];then
        diskNum=$(lsscsi |grep -v "Logical Volume" |awk '{if($NF!="-") print $NF}'|wc -l)
        if [ $diskNum -eq 0 ];then
            #对于SMR环境，通过disktool命令获取
            diskDevice=$(/usr/local/bin/disktool -f A |grep "System Device" | awk '{print $3}')
            for line in $diskDevice;do
                disk_SN=$(/usr/local/bin/disktool -f a $line | grep "Serial Number" | tr -d " " | awk -F":" '{print $2}')
                echo "$line $disk_SN" >>$G_DISK_NAMESN
            done
        else
            is3008SasCard
            if [ $? -ne 0 ];then
                diskDevice=$(lsscsi -g | grep -v 'Logical Volume' |grep -F $(lsscsi|grep enclosu|head -1 |awk '{print $1}'|awk -F: '{print $1":"$2""}') | awk '{if (($2=="disk" && $6!="-") || $2=="(0x14)") print $0}')
            else
                diskDevice=$(lsscsi|grep -v "Logical Volume")
            fi

            for line in $diskDevice;do
                diskname=$(echo $line | awk '{print $(NF-0)}')
                disktype=$(echo $line | awk '{printf $2}')
                if [ "X${diskname}" != "X-" ] && [ "X${disktype}" == "Xdisk" ] ;then
                    disk_SN=$(/usr/local/bin/disktool -f a $diskname | grep "Serial Number" | tr -d " " | awk -F":" '{print $2}')
                    echo "$diskname $disk_SN" >>$G_DISK_NAMESN
                fi
            done
        fi
    else
        diskDevice=$(/usr/local/bin/disktool -s)
        for line in $diskDevice;do
            diskname=$(echo $line | awk '{printf $1}')
	    #排除sda，sdb的系统盘
            echo "$diskname" | grep "/dev/sd-" >/dev/null 2>&1
            if [ $? -eq 0 ];then
                if [ "$diskname" != "Device" ];then
                    disk_SN=$(/usr/local/bin/disktool -f a $diskname | grep "Serial Number" | tr -d " " | awk -F":" '{print $2}')
                    echo "$diskname $disk_SN" >>$G_DISK_NAMESN
                fi
            else
                log "[$FUNCNAME][$LINENO]$diskname is system disk ,no need to collect."
            fi
        done
    fi
    restore_ifs
}
#通过cm localdiskinfo show来查询本节点所以正常磁盘的信息
function Get_DISK_MML_MAP()
{
    rm -f /tmp/tmpfilelocaldiskinfo
    /usr/local/bin/MmlBatch 4016 "cm localdiskinfo show" >/dev/null 2>&1
    for i in $(seq 1 15)
    do
        sleep 10
        if [ -f "/tmp/tmpfilelocaldiskinfo" ];then
            break
        else
            log "[$FUNCNAME][$LINENO]times($i) no file(/tmp/tmpfilelocaldiskinfo)."
        fi
    done
    #除了状态为0(未知) 和4(不在位)，其余都显示 (与C代码一致)
    grep -v "Running_Status: 4" /tmp/tmpfilelocaldiskinfo | grep -v "Running_Status: 0"  >$G_DISK_MML_NAMESN
}

get_disk_MANUFACT()
{
    diskManu=$1
    #首先匹配厂商字段
    if [ -n "$(echo "$diskManu" | grep -i "Toshiba")" ]; then
        echo "TB"
        return
    elif [ -n "$(echo "$diskManu" | grep -i "Seagate")" ]; then
        echo "ST"
        return
    elif [ -n "$(echo "$diskManu" | grep -iw "WD")" ]; then
        echo "WD"
        return
    elif [ -n "$(echo "$diskManu" | grep -i "HUASY")" -o -n "$(echo "$diskManu" | grep -i "HUASAI")" -o -n "$(echo "$diskManu" | grep -i "HUAWEI")" ]; then
        echo "HW"
        return
    elif [ -n "$(echo "$diskManu" | grep -i "Hitachi")" -o -n "$(echo "$diskManu" | grep -i "HGST")" -o -n "$(echo "$MANUFACT" | grep -iw "WDC")" ]; then
        echo "HG"
        return
    elif [ -n "$(echo "$diskManu" | grep -i "SanDisk")" ]; then
        echo "SD"
        return
    fi

    echo "UNKNOWN"
    return
}

function collect_HDD()
{
    local diskManu=$1
    local diskname=$2
    local diskType=$3
    local disksn=$4

    log "[$FUNCNAME][$LINENO]:$diskManu,$diskname,$diskType,$disksn"
    mkdir ${normal_path}${disksn}
    cd ${normal_path}${disksn}
    diskManu=$(get_disk_MANUFACT "$diskManu")
    if [ "$diskManu" = "ST" ];then
        if [ "$diskType" = "SATA" -o "$diskType" = "SMR_SATA" ];then
            /usr/local/bin/disktool -D ${normal_path}${disksn} -S M $diskname >/dev/null 2>&1
            /usr/local/bin/disktool -D ${normal_path}${disksn} -S U $diskname >/dev/null 2>&1
        else
            /usr/local/bin/disktool -D ${normal_path}${disksn} -A m $diskname >/dev/null 2>&1
            /usr/local/bin/disktool -D ${normal_path}${disksn} -A u $diskname >/dev/null 2>&1
        fi
    elif [ "$diskManu" = "HG" ];then
        if [ "$diskType" = "SATA" -o "$diskType" = "SMR_SATA" ];then
            /usr/local/bin/disktool -D ${normal_path}${disksn} -S H $diskname >/dev/null 2>&1
        else
            /usr/local/bin/disktool -D ${normal_path}${disksn} -A E $diskname >/dev/null 2>&1
        fi
    elif [ "$diskManu" = "WD" ];then
            /usr/local/bin/disktool -D ${normal_path}${disksn} -S R $diskname >/dev/null 2>&1
    elif [ "$diskManu" = "TB" ];then
        if [ "$diskType" = "SATA" -o "$diskType" = "SMR_SATA" ];then
            /usr/local/bin/disktool -D ${normal_path}${disksn} -A T $diskname >/dev/null 2>&1
        else
            /usr/local/bin/disktool -D ${normal_path}${disksn} -A F $diskname >/dev/null 2>&1
        fi
    else
        log "[$FUNCNAME][$LINENO]no this type.diskManu=${diskManu}"
    fi
}

function collect_SSD()
{
    local diskManu=$1
    local diskModel=$2
    local diskname=$3
    local disksn=$4

    diskManu=$(get_disk_MANUFACT "$diskManu")
    log "[$FUNCNAME][$LINENO]$diskManu,$diskModel,$diskname,$disksn"
    mkdir ${normal_path}${disksn}
    cd ${normal_path}${disksn}
    if [ "$diskManu" = "HW" ];then
        /usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn}_log.txt -A o -z log $diskname >/dev/null 2>&1
        /usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn}_log2.txt -A o -z log2 $diskname >/dev/null 2>&1
        /usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn}_log3.txt -A o -z log3 $diskname >/dev/null 2>&1
        /usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn}_log4.txt -A o -z log4 $diskname >/dev/null 2>&1
        echo "$diskModel" |grep "HSSD-D5"  >/dev/null 2>&1
        if [ $? -eq 0 ];then
            /usr/local/bin/disktool -D ${normal_path}${disksn} -t ${disksn}_ExtendLog.txt  -A o -z getExtendLog $diskname >/dev/null 2>&1
        fi
    elif [ "$diskManu" = "HG" ];then
        #日立SSD
        /usr/local/bin/disktool -D ${normal_path}${disksn} -A E $diskname >/dev/null 2>&1
    elif [ "$diskManu" = "SD" ];then
        #sandisk SSD
        /usr/local/bin/disktool -D ${normal_path}${disksn} -A D $diskname >/dev/null 2>&1
    else
        log "[$FUNCNAME][$LINENO]no this SSD,diskManu=${diskManu}"
    fi
}
#SATA盘1块收集需要大概3分钟，如果满盘很有可能超时，所以将收集放在后台执行
function collect_log()
{
    log "[$FUNCNAME][$LINENO]start collect Disklog"
    Get_DISKMap
    Get_DISK_MML_MAP
    set_ifs
    diskinfo=$(cat ${G_DISK_NAMESN})
    local DataCollectFile="datacollect_DiskLog$$"
    #生成一个空的临时文件
    >/tmp/$DataCollectFile
    for line in $diskinfo
    do
        while [ 1 ];do
            thread_count=$(grep "begin" /tmp/$DataCollectFile |wc -l)
            if [ $thread_count -ge 5 ];then
                sleep 5
                continue
            else
                {
                    diskname=$(echo $line |awk -F" " '{print $1}')
                    disksn=$(echo $line |awk -F" " '{print $2}')
                    disktype=$(cat $G_DISK_MML_NAMESN | grep $disksn | awk -F'\\|\\|' '{print $6}' | awk -F':' '{print $2}' | tr -d ' ')
                    diskType=$(MapDiskType $disktype)
                    diskModel=$(cat $G_DISK_MML_NAMESN | grep $disksn | awk -F'\\|\\|' '{print $10}' | awk -F':' '{print $2}')
                    diskManu=$(cat $G_DISK_MML_NAMESN | grep $disksn | awk -F'\\|\\|' '{print $12}' | awk -F':' '{print $2}' | tr -d ' ')
                    echo "$disksn begin" >>/tmp/${DataCollectFile}
                    echo "$diskType" |grep "SSD" >/dev/null 2>&1
                    if [ $? -eq 0 ];then
                        collect_SSD "$diskManu" "$diskModel" "$diskname" "$disksn"
                    else
                        collect_HDD "$diskManu" "$diskname" "$diskType" "$disksn"
                    fi
                    move_line=$(cat /tmp/${DataCollectFile} |grep $disksn)
                    log "collect $disksn end."
                    sed -i s/"${move_line}"//g /tmp/${DataCollectFile}
                }&
                sleep 1
                break
            fi
        done
    done
    wait
    restore_ifs

    rm -rf /tmp/${DataCollectFile}
    rm -rf $G_DISK_MML_NAMESN
    rm -rf $G_DISK_NAMESN

    #收集故障盘的日志
    cd $sub_path
    cp -fr /OSM/coffer_data/fault_disklog/* $abnormal_path >/dev/null 2>&1
    tar zcf ${output_file} ./* >/dev/null 2>&1
    if [ -d ${sub_path} ];then
        rm -rf  ${sub_path}
    fi
    log "[$FUNCNAME][$LINENO]end collect Disklog"
}

type=$1
product_name=$2
version=$3
output_file=$4

collect_log