#!/bin/bash
OMGROUP="omgroup"
#收集的其他节点ip保存文件
VALID_IP_FILE="/tmp/tmp_datacollect_ip"
IP_ROLE_FILE="/tmp/tmp_ip_role"
LOG_FILE="/var/log/collect/master.log"
RepeatTimes=(1 2 3 4 5 6 7 8 9)

ProductName=$(ipmitool fru |grep "Product Name" |awk -F: '{print $2}' |awk -F " " '{print $1" "$2}')
if [ "$ProductName" == "FusionStorage File/Object" ];then
    ZipFileName="DataCollect_FusionStorageSFS.zip"
elif [ "$ProductName" == "OceanStor 9000" ];then
    ZipFileName="DataCollect_OceanStor9000.zip"
fi
log()
{
    echo -e "[$(date "+%F %T")] ${@:1}" >> "${LOG_FILE}"
    return 0
}
#获得所有节点的后端IP
#远程同步执行，输入ip/timeout/cmd
function remote_exec
{
    local remote_ip=$1
    local time_out=$2
    local cmd=$3
    for time in ${RepeatTimes[*]}; do
    /opt/huawei/deploy/script/localexec.py cmd $remote_ip $time_out false "$cmd"
        local iRet=$?
        log "[$FUNCNAME]:IP:$remote_ip,return:$iRet,time:$time"
        if [ $iRet -eq 101 ]; then
            sleep 10
        else
            break
        fi
    done
    return $iRet
}

function GetIPAndRoleFromDB()
{
    local lineinfo=""
    local numCnt=1
    local tempnumCnt=1
    local lastNID=""
    local localNID=""
    local templocalNID=""
    local totalline=0
    local count=1

    > $IP_ROLE_FILE
    #从数据库中取得所有节点的后端IP
    log "[$FUNCNAME]start get all nid from cm_conf.db"
    JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
    while [[ "${JavaId}" == "" ]]
    do
        sleep 2
        log "[$FUNCNAME]Failed to get all nid from db ,count=$count"
        JavaId=`sqlite3 /opt/huawei/snas/etc/cm_conf.db 'select NID,IP_ADDR from CM_NODE_IP_T where SUBNET_ID=1 order by NID;'`
        count=$((count + 1))
        if [ $count -gt 5 ];then
            break
        fi
    done
    totalline=`echo "$JavaId" | wc -l`

    while [ $numCnt -le $totalline ]; do

        lineinfo=`echo $JavaId | awk '{print $'$numCnt'}'`

        ItemIp=`echo $lineinfo | awk -F'|' '{print $2}'`
        localNID=`echo $lineinfo | awk -F'|' '{print $1}'`

        if [ "$localNID" == "$lastNID" ];then
            #是同一个节点，继续下一个循环
            numCnt=$((numCnt+1))

            continue
        fi

        #尝试ping一下检查是否通
        for time in ${RepeatTimes[*]};do
            tempStr_ping=`ping -q -c 1 $ItemIp  | grep received | awk '{print $4}'`
            local iRet=$?
            if [ $iRet -ne 0 ]; then
                sleep 10
            else
                break
            fi
        done

        #更新数据
        numCnt=$((numCnt+1))
        lastNID=$localNID

        if [ "$tempStr_ping" -le 0 ];then

            log "[$FUNCNAME] try another ip: numCnt:$numCnt,$localNID,$ItemIp,tempStr_ping:$tempStr_ping"

            #尝试第二个后端ip
            templocalNID=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $1}'`

            #判断是否是同一个节点
            if [ "$localNID" == "$templocalNID" ];then
                ItemIp=`echo $JavaId | awk '{print $'$numCnt'}'| awk -F'|' '{print $2}'`
                for time in ${RepeatTimes[*]};do
                    tempStr_ping=`ping -q -c 2 $ItemIp  | grep received | awk '{print $4}'`
                    local iRet=$?
                    if [ $iRet -ne 0 ]; then
                        sleep 10
                    else
                        break
                    fi
                done

                log "[$FUNCNAME]numCnt:$numCnt,$templocalNID,$ItemIp ,tempStr_ping:$tempStr_ping"

                #更新数据
                numCnt=$((numCnt+1))
                lastNID=$localNID

                if [ "$tempStr_ping" -le 0 ];then
                    #第二个网口也不通，进行下一个循环
                    log "[$FUNCNAME]Node:$localNID,$ItemIp ping fail"
                    continue
                fi
            else
               #不是同一个节点，继续下一个循环
               continue
            fi
        fi

        #判断节点是否禁用和冻结
        Status_info=`remote_exec $ItemIp 30 "cat /opt/huawei/snas/etc/snas.ini | grep "status=""`
        iRet=$?
        log "[$FUNCNAME]node:$ItemIp,Status_info:$Status_info,iRet:$iRet."
        if [ "$iRet" -eq "0" ] && [ "$Status_info" != "" ];then
            Status_values=`echo $Status_info | awk -F= '{print $2}'`
            Status_value=`echo $Status_values | awk '{print $1}'`
            if [ "$Status_value" == "0" ];then
                echo -n "$ItemIp " >> $IP_ROLE_FILE
                log "[$FUNCNAME]add $ItemIp"
            fi
        fi
    done
}

function DiskInfoCollect()
{
    #创建收集目录和收集文件
    rm -rf /var/log/cm/*
    mkdir -p /var/log/cm

    #远程执行硬盘数据收集
    ALLIp=`cat $IP_ROLE_FILE`
    log "[$FUNCNAME]Start to collect DiskInfo from ${ALLIp}."
    > ${VALID_IP_FILE}
    for Item in $ALLIp;do
        for time in ${RepeatTimes[*]};do
            /opt/huawei/deploy/script/localexec.py async $Item getdatacollect 1800 true "/opt/huawei/snas/bin/datacollect_diskinfo.sh"
            iRet=$?
            log "[$FUNCNAME] IP:$Item;iRet:$iRet,times:$time"
            if [ $iRet -eq 101 ];then
                sleep 10
            else
                break
            fi
        done
        log "[$FUNCNAME]:remote_exec datacollect_diskinfo.sh result:$iRet from IP:$Item."
        if [ $iRet -eq 0 ];then
            echo "$Item" >> $VALID_IP_FILE
        fi
    done
    ValidIP=`cat $VALID_IP_FILE`
    while [[ "$ValidIP" != "" ]]
    do
        >$VALID_IP_FILE
        for Item in $ValidIP;do
            sleep 5
            #检查是否执行完成
            for time in ${RepeatTimes[*]};do
                proresult=`/opt/huawei/deploy/script/localexec.py progress $Item getdatacollect`
                iRet=$?
                if [ $iRet -eq 101 ];then
                    sleep 10
                else
                    break
                fi
            done
            log "[$FUNCNAME]: get data from IP:$Item,proresult=$proresult."
            process=`echo $proresult|awk '{print $1}'`
            errno=`echo $proresult|awk '{print $4}'`
            log "process:$process,errno:$errno,iRet:$iRet"
            if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
                echo "$Item" >> ${VALID_IP_FILE}
                continue;
            elif [ $iRet -ne 0 ] || [ $errno -ne 0 ] || [ "$process" == "" ];then
                log "get data from $Item fail"
                continue;
            fi
            #下载数据到本地
            for time in ${RepeatTimes[*]};do
                /opt/huawei/deploy/script/localexec.py download $Item /var/log/cm/DiskInfo$Item.zip /var/log/cm/DiskInfo.zip
                iRet=$?
                log "[$FUNCNAME]remote_download from IP:$Item,iRet:$iRet,times:$time"
                if [ $iRet -eq 101 ];then
                    sleep 10
                else
                    break
                fi
            done
            log "[$FUNCNAME]:start to uzip file after download."
            cd /var/log/cm
            unzip DiskInfo$Item.zip -d DiskInfo$Item
            rm DiskInfo$Item.zip
        done
        ValidIP=`cat $VALID_IP_FILE`
    done
}
function DiskInfoSort()
{
    >/var/log/cm/smart0.txt
    >/var/log/cm/summary.ini
    if [ -f /var/log/cm/basicinfo.txt ];then
        rm /var/log/cm/basicinfo.txt
    fi
    successnumber=0
    totalmumber=0
    ValidIP=`cat $IP_ROLE_FILE`
    log "all ip is $ValidIP"
    for Item in $ValidIP;do
        cd /var/log/cm/DiskInfo$Item
        if [ -f basicinfo.txt ];then
            cp basicinfo.txt /var/log/cm/basicinfo.txt
        fi
        cat smart0.txt >> /var/log/cm/smart0.txt
        tmpsuccnum=$(grep -w success summary.ini|cut -d "=" -f 2)
        tmptotalnum=$(grep -w total summary.ini|cut -d "=" -f 2)
        successnumber=$((successnumber+$tmpsuccnum))
        totalmumber=$((totalmumber+$tmptotalnum))
        log "[$FUNCNAME]:get the disk summary is total:$totalmumber,success:$successnumber,date=$(date)."
    done
    rm -rf /var/log/cm/DiskInfo*
    echo "total=$totalmumber" >> /var/log/cm/summary.ini
    echo "success=$successnumber" >> /var/log/cm/summary.ini
    Time=$(date "+%Y-%m-%d %H:%M:%S")
    echo "date=${Time}" >> /var/log/cm/summary.ini
    log "begin to zip file"
    cd /var/log/cm/
    if [ -f basicinfo.txt ];then
        log "get basicinfo.txt success."
    else
        log "get basicinfo.txt failed!"
        exit 1
    fi
    sed -i'' "s/$/\r/" basicinfo.txt

    sed -i '/smart/s#\r##g' basicinfo.txt
    sed -i '/admin/s#\r##g' basicinfo.txt
    sed -i '2s#\r##g' basicinfo.txt
    sed -i '10s#\r##g' basicinfo.txt
    linenum=$(cat basicinfo.txt|wc -l)
    comd="sed -i '${linenum}s#\r##g' basicinfo.txt"
    eval $comd
    mkdir -p /var/log/cm/DataCollect/disksmartinfo/
    mv summary.ini basicinfo.txt smart0.txt /var/log/cm/DataCollect/disksmartinfo/
    zip -qr "$ZipFileName" ./* >/dev/null 2>&1
    chown omuser:$OMGROUP -R /var/log/cm
    rm -rf /var/log/cm/DataCollect/
    log "collect Diskinfo success."
}
GetIPAndRoleFromDB
DiskInfoCollect
DiskInfoSort