#!/bin/bash

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh

SUB_PATH="${MessageDir}DiskFaultInfo/"
FAULT_PATH="${SUB_PATH}FaultLog/"
OM_PATH="${SUB_PATH}OM/"
OBS_PATH="${SUB_PATH}DFS_OBS/"
OS_PATH="${SUB_PATH}OS/"
SUBNAME="FAULT_DISK"
OM_NAME="FAULT_OM"
DFS_OBS_NAME="FAULT_DFS_OBS"
OS_NAME="FAULT_OS"

CM_DISKKICK_DB=/opt/huawei/snas/etc/cm_diskkick.db
CM_DISKMGMT_DB=/opt/huawei/snas/etc/cm_diskmgmt.db
CM_ALARM_RECORD_DB=/opt/huawei/snas/etc/cm_alarm_record.db
FAULT_DISK_PATH=/OSM/coffer_data/fault_disklog/cm_fault_disklog

G_DISK_NAMESN=${SUB_PATH}diskname_sn
G_DISK_MML_NAMESN=${SUB_PATH}diskname_mml_sn

TMP_OM_BASE_PATH="${CMLogDir}../tmp_${OM_NAME}"
TMP_DFS_OBS_BASE_PATH="${CMLogDir}../tmp_${DFS_OBS_NAME}"
TMP_OS_BASE_PATH="${CMLogDir}../tmp_${OS_NAME}"

collect_by_size=0

#===================================================
# ExecSqliteCmd
# 函数功能：执行sqlite3命令, 具有失败后的重试操作
# 描述：
#===================================================
function ExecSqliteCmd()
{
    retry_times=3
    retry_sleep=3
    db_name=$1
    cmd=$2

    for((i=0;i<${retry_times};i++))
    do
        /usr/bin/sqlite3 ${db_name} "${cmd}"
        rc=$?
        if [ 0 -eq ${rc} ];then
            break
        fi
        log "excute command: sqlite3 ${db_name} \"${cmd}\" failed"
        sleep ${retry_sleep}
    done

    return ${rc}
}

#返回需要收集的日志秒数，确保这些日志文件优先收集
function get_cfglog_seconds()
{
    local rc=0
    local cur_sec=0

    if [ 1 -eq ${collect_by_size} ];then
        cur_sec=$(date +%s)
        rc=$?
        ret_seconds ${cur_sec}
        return ${rc}
    else
        endtime_s=$( getSeconds "${cur_time}" )
        let "cur_sec=endtime_s - 1"
        ret_seconds ${cur_sec}
        return $?
    fi
}

#parameter: out_file [in_rec_file]
#search COLLECT_RECORD_FORMAT in this file, to see detail.
#如果从本地生成记录格式为: full_name(in DFS/S3, is short name) ("file"|"dir") size(unit: byte) des_path should_compress utc_seconds
#注意需要保持记录格式。两种情况下都需要保证
#paras: out_file=/var/log/cm/LocalDataCollect/../tmp/tmp.OM.dfs.and.local.info
function GetOMLogList()
{
    local out_file=${1}
    local paths="/var/log /var/log/snas /var/log/backup/OM"
    local path=""
    local in_rec_file=""
    local des_om_path="${MessageDir}${OM_NAME}"
    local loc_om_logs="snas_CM"
    local loc_file=""
    local snmpagentLog="/cf_data/root/usr/local/agent/snmp/log/snmpagent.log"
    local cliDir="${MessageDir}${OM_NAME}/CLI"
     
    #snmpagent.log.2019-05-17_23.tar.gz ,/var/log/backup/OM/ 下有这个包,有收进去吗
    if [ $# -gt 1 ];then
        #get my log files from input record file. rec_file中的格式就是ls -l的结果。
        in_rec_file=${2}
        if [ ! -f ${in_rec_file} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"ERROR, ${in_rec_file} is not exist!"
            return 1
        fi
        
        grep "snas.log" ${in_rec_file} | awk -v dpath=${des_om_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get snas.log from ${rec_file} and redirect to ${out_file} fail"
        grep "snas_CM.log" ${in_rec_file} |  grep -v ".tar.gz" | grep -vw "/var/log/snas_CM.log" | awk -v dpath=${des_om_path} '{print $NF" file "$1" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get snas_CM.log uncompressed fail and redirect to ${out_file} fail"
        grep "snas_CM.log" ${in_rec_file} |  grep ".tar.gz" | awk -v dpath=${des_om_path} '{print $NF" file "$1" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get snas_CM.log compressed fail and redirect to ${out_file} fail"
    else
        #get my log files from local fs.
        # 收集OM log
        for loc_file in ${loc_om_logs}
        do
            ls -l /var/log/${loc_file}* 2> /dev/null | awk -v dpath=${des_om_path} '{print $NF" file -1 "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect /var/log/${loc_file}* to ${out_file} fail."            
        done
        # 搜集snmpagent日志，只搜集snmpagent.log
        echo "${snmpagentLog} file -1 ${des_om_path}/snmpagent 1 0" >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"record ${snmpagentLog} file -1 ${MessageDir}${OM_NAME}/snmpagent 1 0 >> ${out_file} fail"
        # 搜集CLI日志
        echo "/var/log/CLI/* dir -1 ${cliDir} 1 0"  >> ${out_file} || log [$FUNCNAME][$LINENO]"Warning, record: /var/log/CLI/* dir -1 ${cliDir} 1 0 >> ${out_file} fail"
        # 收集OM子系统下的所有日志
        ls -l /var/log/snas/snas.log* 2> /dev/null | egrep ".tar.gz$" | awk -v dpath=${des_om_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snas.log* > ${out_file} fail."            
        ls -l /var/log/backup/OM/snas.log* 2> /dev/null | awk -v dpath=${des_om_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snas.log* > ${out_file} fail."            
        ls -l /var/log/snas_CM.log* 2> /dev/null | grep -v ".tar.gz" | awk -v dpath=${des_om_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snas_CM* >> ${out_file} fail."
        ls -l /var/log/snas/snas_CM.log* 2> /dev/null | grep -v ".tar.gz" | awk -v dpath=${des_om_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snas_CM* >> ${out_file} fail."
        ls -l /var/log/snas_CM.log*.tar.gz 2> /dev/null | awk -v dpath=${des_om_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snas_CM* >> ${out_file} fail."
        ls -l /var/log/backup/OM/snas_CM.log*.tar.gz 2> /dev/null | awk -v dpath=${des_om_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/snas_CM* >> ${out_file} fail."
    fi
    
    return 0    
}

#
#本地文件系统中的是全路径，DFS/S3中的只有文件名
#snas_CM.log_2018-10-15-23.00.00.234996.tar.gz
#/var/log/snas_CM.log
#/var/log/snas_CM.log_2018-10-23-15:00:00.429925
#/var/log/backup/OM/snas.log.2018-10-22_11.tar.gz
#/var/log/startnas.log
#parameters: fname
function getUtcSecondsFromOMFileName()
{
    local fname=$1
    local sname=$(basename ${fname})
    local tmp=""
    local cuttail=""
    local sec=0
    local cur_sec=$(get_cfglog_seconds)
    local rc=0
       
    echo ${sname} | grep snas.log > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #sname: snas.log.2018-10-22_11.tar.gz
        tmp=${sname##*snas.log.}
        cuttail=${tmp%.tar.gz*}
        #cuttail: 2018-10-22_11
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    echo ${sname} | grep snas_CM.log > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas_CM.log_2018-10-15-23.00.00.234996.tar.gz or snas_CM.log or snas_CM.log_2018-10-23-15:00:00.429925
        tmp=${sname##*snas_CM.log}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            #/var/log/snas_CM.log
            sec=${cur_sec}
        elif [ "${tmp}" == "${cuttail}" ];then
            #snas_CM.log_2018-10-23-15:00:00.429925 
            #tmp: _2018-10-23-15:00:00.429925
            sec=$(GetSecondForC01 ${tmp#*_})
        else
            #snas_CM.log_2018-10-15-23.00.00.234996.tar.gz
            #cuttail: _2018-10-15-23.00.00.234996
            sec=$(GetSecondForC01 ${cuttail#*_})
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    #/var/log/startnas.log
    ret_seconds ${cur_sec}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
    fi
    return ${rc}
}

function CollectOM()
{
    local collect_sub="${OM_NAME}"
    local begin_time=$1
    local end_time=$2
    local size=$3
    local out_file=$4
    local rc=0
    local sub_path="${MessageDir}${OM_NAME}"
    local available_size=$(getAvailableSize)
    
    log [$SUBNAME][$FUNCNAME][$LINENO]"begin_time:${begin_time} ,end_time:${end_time}, available size is:${available_size}"
    
    if [ $(echo "${MIN_VALUE} > ${available_size}" | bc) -eq 1 ]; then
        echo "collect size will over 90%, exit collect"
        log [$SUBNAME]"collect size will over 90%, exit collect."
        clean
        exit 1
    fi
    
    collect_compressed_logs "${collect_sub}" ${size} "${begin_time}" "${end_time}" GetOMLogList getUtcSecondsFromOMFileName dfs_s3_cp
    rc=$?
    if [ 0 -ne ${rc} ]; then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect_compressed_logs ${collect_sub} ${size} ${begin_time} ${end_time} GetOMLog GetSecondsFromFileName dfs_s3_cp fail with ${rc}"
    fi
    
    #delete tempory path.
    if [ -d ${TMP_OM_BASE_PATH} ] ;then
        rm -rf ${TMP_OM_BASE_PATH} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm ${TMP_OM_BASE_PATH} fail"
    fi
    
    #更新使用空间
    adjustSize
    
    tar cf ${out_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1 
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, tar cvf ${out_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1  fail with ${rc}"
    fi

    return 0
}

function CollectDiskLog()
{
    local fault_sn=$1
    
    # 存在表示已经收集，直接返回
    if [ -d ${FAULT_DISK_PATH}/${fault_sn} ];then
        return
    fi

    # 启动收集
    mkdir -p ${FAULT_DISK_PATH}/${fault_sn}
    
    # diskinfo在PrepareCollectDisk函数中获取
    set_ifs
    for line in $diskinfo
    do
        disksn=$(echo $line |awk -F" " '{print $2}')
        if [ ${disksn} != ${fault_sn} ]; then
            continue
        fi
        
        diskname=$(echo $line |awk -F" " '{print $1}')
        disktype=$(cat $G_DISK_MML_NAMESN | grep $disksn | awk -F'\\|\\|' '{print $6}' | awk -F':' '{print $2}' | tr -d ' ')
        diskType=$(MapDiskType $disktype)
        diskModel=$(cat $G_DISK_MML_NAMESN | grep $disksn | awk -F'\\|\\|' '{print $10}' | awk -F':' '{print $2}' | tr -d ' ')
        diskManu=$(cat $G_DISK_MML_NAMESN | grep $disksn | awk -F'\\|\\|' '{print $12}' | awk -F':' '{print $2}' | tr -d ' ')
        
        ${ScriptDir}/cm_fault_disk_log_collect.sh ${disktype} ${disksn} ${diskname} ${diskManu} ${diskModel}
        break
    done
    restore_ifs
    
    return
}

#获取盘符和SN号，T3000用disktool，服务器用lsscsi和disktool组合
function Get_DISKMap()
{
    set_ifs
    IsRHNode
    if [ $? -eq 0 ];then
        diskNum=$(lsscsi |grep -v "Logical Volume" |awk '{if($NF!="-") print $NF}'|wc -l)
        if [ $diskNum -eq 0 ];then
            #对于SMR环境，通过disktool命令获取
            diskDevice=$(/usr/local/bin/disktool -f A |grep "System Device" | awk '{print $3}')
            for line in $diskDevice;do
                disk_SN=$(/usr/local/bin/disktool -f a $line | grep "Serial Number" | tr -d " " | awk -F":" '{print $2}')
                echo "$line $disk_SN" >>$G_DISK_NAMESN
            done
        else
            diskDevice=$(lsscsi|grep -v "Logical Volume")
            for line in $diskDevice;do
                diskname=$(echo $line | awk '{print $(NF-0)}')
                disktype=$(echo $line | awk '{printf $2}')
                if [ "X${diskname}" != "X-" ] && [ "X${disktype}" == "Xdisk" ] ;then
                    disk_SN=$(/usr/local/bin/disktool -f a $diskname | grep "Serial Number" | tr -d " " | awk -F":" '{print $2}')
                    echo "$diskname $disk_SN" >>$G_DISK_NAMESN
                fi
            done
        fi
    else
        diskDevice=$(/usr/local/bin/disktool -s)
        for line in $diskDevice;do
            diskname=$(echo $line | awk '{printf $1}')
	    #排除sda，sdb的系统盘
            echo "$diskname" | grep "/dev/sd-" >/dev/null 2>&1
            if [ $? -eq 0 ];then
                if [ "$diskname" != "Device" ];then
                    disk_SN=$(/usr/local/bin/disktool -f a $diskname | grep "Serial Number" | tr -d " " | awk -F":" '{print $2}')
                    echo "$diskname $disk_SN" >>$G_DISK_NAMESN
                fi
            else
                log "$diskname is system disk ,no need to collect."
            fi
        done
    fi
    restore_ifs
}

#通过cm localdiskinfo show来查询本节点所以正常磁盘的信息
function Get_DISK_MML_MAP()
{
    rm -f /tmp/tmpfilelocaldiskinfo
    /usr/local/bin/MmlBatch 4016 "cm localdiskinfo show" >/dev/null 2>&1
    sleep 15
    grep "Running_Status: 27" /tmp/tmpfilelocaldiskinfo >$G_DISK_MML_NAMESN
}

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}

function PrepareCollectDisk()
{
    Get_DISKMap
    Get_DISK_MML_MAP        
    set_ifs
    diskinfo=$(cat $G_DISK_NAMESN)
    restore_ifs
}

function RecoverCollectDisk()
{
    rm -rf $G_DISK_MML_NAMESN
    rm -rf $G_DISK_NAMESN       
}

function GetDFSOBSLogList()
{
    local out_file=${1}
    local sub_paths="/var/log/snas /var/log/backup/DFS_OBS /var/log/backup/obs"
    local in_rec_file=""
    local des_path="${MessageDir}${DFS_OBS_NAME}"
    local loc_cur_logs="snasmessages snas_obs snas_BASE sysmonitor.log"
    local loc_tar_logs="DFS_OBS.log obs.log"
    local loc_file=""
    
    if [ $# -gt 1 ];then
        in_rec_file=${2}
        if [ ! -f ${in_rec_file} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"ERROR, ${in_rec_file} is not exist!"
            return 1
        fi 
        
        #files in FileSystem ,是不是要兼容低版本C01,把snas给收了? ,个数上限12个
        for file in ${loc_tar_logs}
        do
            grep "${file}.*.tar.gz" ${in_rec_file} | awk -v dpath=${des_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get ${file}.*.tar.gz from ${rec_file} and redirect to ${out_file} fail"
        done
        #grep "snas.log.*.tar.gz" ${in_rec_file} | awk -v dpath=${des_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get snas.log.*.tar.gz from ${rec_file} and redirect to ${out_file} fail"
    else
        #未压缩文件
        for file in ${loc_cur_logs}
        do
            ls -l /var/log/${file}* 2> /dev/null | grep -v ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/${file} >> ${out_file} fail"
        done
       
        #压缩文件DFS_OBS.log.2018-11-29_21.tar.gz DFS_OBS.log.2018-11-27_01_1.tar.gz obs.log.2018-12-20_23.tar.gz obs.log.2018-12-20_23_1.tar.gz
        for path in ${sub_paths}
        do
            for file in ${loc_tar_logs}
            do
                if [ -d "${path}" ];then
                    ls -l ${path}/${file}* 2> /dev/null | grep ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/${file}* >> ${out_file} fail"
                fi 
            done        
        done
    fi
        
    return 0
}

function getUtcSecondsFromDFSOBSFileName()
{
    local fname=$1
    local sname=$(basename ${fname})
    local tmp=""
    local cuttail=""
    local cur_sec=$(get_cfglog_seconds)
    local sec=0
    local rc=0
    
    echo ${sname} | grep "DFS_OBS.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #MON_BJM.log.2019-01-20_21.tar.gz  
        tmp=${sname##*DFS_OBS.log.}
        cuttail=$(echo ${tmp%.tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "DFS_OBS.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #platform.log.2019-01-08_04_1.tar.gz or platform.log.2019-01-08_04_2.tar.gz  
        tmp=${sname##*DFS_OBS.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    echo ${sname} | grep "obs.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #MON_BJM.log.2019-01-20_21.tar.gz  
        tmp=${sname##*obs.log.}
        cuttail=$(echo ${tmp%.tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "obs.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #platform.log.2019-01-08_04_1.tar.gz or platform.log.2019-01-08_04_2.tar.gz  
        tmp=${sname##*obs.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "snasmessages" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snasmessages_2019-01-21-00:00:00.073548 or snasmessages
        tmp=${sname##*snasmessages}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            #snasmessages
            sec=${cur_sec}
        else 
            #snasmessages_2019-01-21-00:00:00.073548 
            #tmp:_2019-01-21-00:00:00.073548
            sec=$(GetSecondForC01 ${tmp#*_})
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "snas_BASE.log" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas_BASE.log_2019-01-21-00:00:28.431003 or snas_BASE.log
        tmp=${sname##*snas_BASE.log}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            #snas_BASE.log
            sec=${cur_sec}
        else 
            #snas_BASE.log_2019-01-21-00:00:28.431003 
            #tmp: _2019-01-21-00:00:28.431003
            sec=$(GetSecondForC01 ${tmp#*_})
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    #低版本snas.log
    echo ${sname} | grep snas.log  | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas.log_2018-10-15-23.00.00.234996.tar.gz
        #snas.log.2019-04-02_21.tar.gz 
        tmp=${sname##*snas.log.}
        cuttail=$(echo ${tmp%.tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep snas.log  | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas.log_2018-10-15-23.00.00.234996.tar.gz
        #snas.log.2019-04-02_21.tar.gz 
        tmp=${sname##*snas.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    ##/var/log/下snas_mon_crit.log snas_fault.log无后缀时间的
    ret_seconds ${cur_sec}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
    fi
    return ${rc}
}

function CollectDFSOBS()
{
    local collect_sub="${DFS_OBS_NAME}"
    local begin_time=$1
    local end_time=$2
    local size=$3
    local out_file=$4
    local need_size="${size}"
    local rc=0
    local sub_path="${MessageDir}${DFS_OBS_NAME}"
    local available_size=$(getAvailableSize)

    log [$SUBNAME][$FUNCNAME][$LINENO]"begin_time:${begin_time} ,end_time:${end_time}, available size is:${available_size}"
    
    if [ $(echo "${MIN_VALUE} > ${available_size}" | bc) -eq 1  ];then
        echo "collect size will over 90%, exit collect"
        log [$SUBNAME]"collect size will over 90%, exit collect."
        clean
        exit 1
    fi
        
    collect_compressed_logs "${collect_sub}" "${size}" "${begin_time}" "${end_time}" GetDFSOBSLogList getUtcSecondsFromDFSOBSFileName dfs_s3_cp
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect_compressed_logs ${collect_sub} ${size} ${begin_time} ${end_time} GetDFSOBSLogList getUtcSecondsFromDFSOBSFileName dfs_s3_cp fail with ${rc}"
    fi
    
    #delete tempory path.
    if [ -d ${TMP_DFS_OBS_BASE_PATH} ] ;then
        rm -rf ${TMP_DFS_OBS_BASE_PATH} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm ${TMP_DFS_OBS_BASE_PATH} fail"
    fi
    
    #更新使用空间
    adjustSize
    
    #打包
    tar cf ${out_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1 
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, tar cvf ${out_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1  fail with ${rc}"
    fi
    
    return 0
}

function GetOSLoglist()
{
    local out_file=${1}
    local sub_paths="/var/log/message /var/log/backup/message /var/log/backup/OS"
    local in_rec_file=""
    local des_path="${MessageDir}${OS_NAME}"
    local loc_cur_logs="message/message.log"
    local loc_tar_logs="message.log"
    local loc_file=""
    
    if [ $# -gt 1 ];then
        in_rec_file=${2}
        if [ ! -f ${in_rec_file} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"ERROR, ${in_rec_file} is not exist!"
            return 1
        fi 
        #files in FileSystem 个数上限12个
        for file in ${loc_tar_logs}
        do
            grep "${file}.*.tar.gz" ${in_rec_file} | awk -v dpath=${des_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get ${file}.*.tar.gz from ${rec_file} and redirect to ${out_file} fail"
        done
    else
        #未压缩文件无时间戳的各种文件
        for file in ${loc_cur_logs}
        do
            ls -l /var/log/${file}* 2> /dev/null | grep -v ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/${file} >> ${out_file} fail"
        done
       
        #压缩文件MON_BJM.log.2018-11-29_21.tar.gz MON_BJM.log.2018-11-27_01_1.tar.gz 
        for path in ${sub_paths}
        do
            for file in ${loc_tar_logs}
            do
                if [ -d "${path}" ];then
                    ls -l ${path}/${file}* 2> /dev/null | grep ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/${file}* >> ${out_file} fail"
                fi 
            done
        
        done        
    fi
    
    return 0
}

function getUtcSecondsFromOSFileName()
{
    local fname=$1
    local sname=$(basename ${fname})
    local tmp=""
    local cuttail=""
    local cur_sec=$(get_cfglog_seconds)
    local sec=0
    local rc=0
       
    echo ${sname} | grep "message.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #message.log.2019-01-10_23.tar.gz  or message.log
        tmp=${sname##*message.log}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            sec=${cur_sec}
        else
            #cuttail:.2019-01-10_23
            sec=$(getSeconds "$(echo ${cuttail##*.} | sed 's/_/ /g')" )
        fi
        # message log backup one day once
        if [ $sec -gt $cur_sec ]; then
            log [$SUBNAME][$FUNCNAME][$LINENO]"${fname} time: sec=${sec},cur_sec=${cur_sec}" 
            local diff_sec=0
            let "diff_sec=sec - cur_sec"
            # 86400 is 24*3600s
            if [ $diff_sec -lt "86400" ]; then
                sec=$cur_sec
            fi
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    echo ${sname} | grep "message.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #message.log.2019-01-08_04_1.tar.gz or message.log.2019-01-08_04_2.tar.gz  
        tmp=${sname##*message.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        # message log backup one day once
        if [ $sec -gt $cur_sec ]; then
            log [$SUBNAME][$FUNCNAME][$LINENO]"${fname} time: sec=${sec},cur_sec=${cur_sec}" 
            local diff_sec=0
            let "diff_sec=sec - cur_sec"
            # 86400 is 24*3600s
            if [ $diff_sec -lt "86400" ]; then
                sec=$cur_sec
            fi
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    ##/var/log/下日志均无后缀时间
    ret_seconds ${cur_sec}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
    fi
    return ${rc}
}

function CollectOS()
{
    local collect_sub="${OS_NAME}"
    local begin_time=$1
    local end_time=$2
    local size=$3
    local out_file=$4
    local need_size="${size}"
    local rc=0
    local sub_path="${MessageDir}${OS_NAME}"
    local available_size=$(getAvailableSize)
    
    log [$SUBNAME][$FUNCNAME][$LINENO]"begin_time:${begin_time} ,end_time:${end_time}, available size is:${available_size}"
    
    if [ $(echo "${MIN_VALUE} > ${available_size}" | bc) -eq 1  ];then
        echo "collect size will over 90%, exit collect"
        log [$SUBNAME]"collect size will over 90%, exit collect."
        clean
        exit 1
    fi
        
    collect_compressed_logs "${collect_sub}" "${size}" "${begin_time}" "${end_time}" GetOSLoglist getUtcSecondsFromOSFileName dfs_s3_cp
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect_compressed_logs ${collect_sub} ${size} ${begin_time} ${end_time} GetOSLoglist getUtcSecondsFromOSFileName dfs_s3_cp fail with ${rc}"
    fi
    
    #delete tempory path.
    if [ -d ${TMP_OS_BASE_PATH} ] ;then
        rm -rf ${TMP_OS_BASE_PATH} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm ${TMP_OS_BASE_PATH} fail"
    fi
    
    #更新使用空间
    adjustSize
        
    #打包
    tar cf ${out_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1 
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, tar cvf ${out_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1  fail with ${rc}"
    fi
    
    return 0
}

function CollectLog()
{   
    local obs_tmp_path="${MessageDir}${DFS_OBS_NAME}"
    local om_tmp_path="${MessageDir}${OM_NAME}"
    local os_tmp_path="${MessageDir}${OS_NAME}" 
    local almDiskFaultID=73015099398 #故障告警ID
    
    # 收集cm_diskkick.db和cm_diskmgmt.db
    cp -f ${CM_DISKKICK_DB} ${SUB_PATH}
    cp -f ${CM_DISKMGMT_DB} ${SUB_PATH}
        
    # 当前节点的id
    local local_nid=$(cat /opt/huawei/snas/etc/cm.ini  | grep "NID=" | awk -F= '{print $2}')

    # 读取数据库cm_diskkick.db收集坏盘信息
    if [ "${begin_time}" == "null" ] || [ "${end_time}" == "null" ]; then
        # 全部查询
        disk_list=$(ExecSqliteCmd ${CM_ALARM_RECORD_DB} "select ALMPARAM,ALMOCCURTIME from CM_ALARM_RECORD_T where ALMID=${almDiskFaultID} and ALMOBJID=${local_nid}")
    else
        # 按照时间查询
        local min_time=$(date -d "${begin_time}" +"%s")
        local max_time=$(date -d "${end_time}" +"%s")
        disk_list=$(ExecSqliteCmd ${CM_ALARM_RECORD_DB} "select ALMPARAM,ALMOCCURTIME from CM_ALARM_RECORD_T where ALMID=${almDiskFaultID} and ALMOBJID=${local_nid} and ALMOCCURTIME>=${min_time} and ALMOCCURTIME<=${max_time}")
    fi
    
    if [ "X${disk_list}" == "X" ]; then
        log "[CollectLog]Failed to get info from DB(${CM_ALARM_RECORD_DB})"
        return
    fi
    
    PrepareCollectDisk
    
    log "[CollectLog]disk info: ${disk_list}"
    # 收集磁盘
    for line in ${disk_list}
    do
        local alarm_info=$(echo "${line}" | awk -F'|' '{print $1}')
        local sn=$(echo "${alarm_info}" | awk -F',' '{print $7}')        
        local fault_time=$(echo "${line}" | awk -F'|' '{print $2}') # 故障时间
        local min_time=$[${fault_time}-7200] #前2小时，故障一小时，后一小时
        local max_time=$[${fault_time}+3600]
        local start_time=$(date -d@${min_time} +"%Y-%m-%d %H:%M:%S")
        local end_time=$(date -d@${max_time} +"%Y-%m-%d %H:%M:%S")
        cur_time="${end_time}"
        
        if [ "X${sn}" == "X" ] || [ "fault_time" == "0" ]; then
            continue
        fi
        
        num=$[${num}+1]

        # 收集磁盘日志：没有收集则检查是否在线，在线则重启收集
        CollectDiskLog ${sn}            
        
        # 按照磁盘sn号创建目录
        local sn_path="${SUB_PATH}${sn}_${fault_time}/"
        mkdir -p ${sn_path}
        
        # 收集DFS_OBS: 日志
        local out_file="${sn_path}""DFS_OBS.tar.gz"
        #mkdir -p ${OBS_PATH}
        rm -rf ${obs_tmp_path}
        mkdir -p ${obs_tmp_path}    
        CollectDFSOBS "${start_time}" "${end_time}" "${sub_size}" "${out_file}"
        if [ -d ${obs_tmp_path} ] ; then
            rm -rf ${obs_tmp_path} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm -rf ${obs_tmp_path} fail"
        fi
        
        # 收集OM日志
        out_file="${sn_path}""OM.tar.gz"
        #mkdir -p ${OM_PATH}
        rm -rf ${om_tmp_path}
        mkdir -p ${om_tmp_path}            
        CollectOM "${start_time}" "${end_time}" "${sub_size}" "${out_file}"
        if [ -d ${om_tmp_path} ] ; then
            rm -rf ${om_tmp_path} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm -rf ${om_tmp_path} fail"
        fi
                
        # 收集OS: message日志
        min_time=$[${fault_time}-86400] #前后一天
        max_time=$[${fault_time}+86400]
        start_time=$(date -d@${min_time} +"%Y-%m-%d %H:%M:%S")
        end_time=$(date -d@${max_time} +"%Y-%m-%d %H:%M:%S")
        out_file="${sn_path}""OS.tar.gz"
        #mkdir -p ${OS_PATH}
        rm -rf ${os_tmp_path}
        mkdir -p ${os_tmp_path}            
        CollectOS "${start_time}" "${end_time}" "${sub_size}" "${out_file}"
        if [ -d ${os_tmp_path} ] ; then
            rm -rf ${os_tmp_path} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm -rf ${os_tmp_path} fail"
        fi
    done
    
    # 收集故障盘的日志
    RecoverCollectDisk       
    mkdir -p ${FAULT_PATH}
    cp -fr /OSM/coffer_data/fault_disklog/* ${FAULT_PATH} >/dev/null 2>&1
    
    return
}

function main()
{
    rm -rf ${SUB_PATH}
    mkdir -p ${SUB_PATH}
    
    sub_size="0" 
    
    CollectLog
    cd ${SUB_PATH}
    tar cf ${output_file} ./* >/dev/null 2>&1
    if [ -d ${SUB_PATH} ];then
        rm -rf  ${SUB_PATH}
    fi
}

type=$1
product_name=$2
version=$3
output_file=$4
begin_time=$5
end_time=$6
sub_size=$7

#判断产品类型
judge_product_type
product_type
prepare

main
exit $?
