#!/bin/bash

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh
. /opt/node_type_recognize.sh

#0 没有SMR磁盘    1 有SMR磁盘
SMR_FLAG=0
successnumber=0
snas_ini="/opt/huawei/snas/etc/snas.ini"
disksmartfile="/var/log/snas_DiskStatus.log"
disksmarthistoryfile="/var/log/snas_DiskStatus_History.log"

type=$1
product_name=$2
version=$3
output_file=$4

sub_path=${MessageDir}Diskinfo/
rm -rf ${sub_path}
mkdir -p ${sub_path}
#创建history_smart目录
mkdir -p ${sub_path}history_smart

smarthistory=${sub_path}history_smart/smart0_history.txt
smart="${sub_path}smart0.txt"
summary="${sub_path}summary.ini"
tmp_nodename="${sub_path}tmp_nodename.txt"
disk_kmm_info="${sub_path}disk_kmm_info.txt"
basicinfo="${sub_path}basicinfo.txt"
diskStartInfo="Disk_Info_Flag_Start:"
diskEndInfo="Disk_Info_Flag_End:"
>$basicinfo
>$tmp_nodename
>$smart
>$summary
>$disk_kmm_info

function set_ifs
{
    IFS_OLD=$IFS
    IFS=$'\n'
}

function restore_ifs
{
    IFS=$IFS_OLD
}


#如果smart0.txt文件中存在磁盘信息，但是basicinfo.txt文件中不存，则磁盘信息需要从smart0.txt文件中删除
function DelCurNoExistDiskInfo()
{
    local SnList=""
    SnList=$(cat ${smart} | grep -w "^Serial Number" | awk -F':' '{print $2}' |tr -d ' ' | sort -u)
    for item in ${SnList[*]};do
        grep -wq "${item}" ${basicinfo} >/dev/null
        if [ $? -ne 0 ];then
            sed -i "/^${diskStartInfo}${item}/,/^${diskEndInfo}${item}/d" ${smart}
            log "[$FUNCNAME][$LINENO]disk:${item} no find at basicinfo.txt"
        fi
    done
    #删除start和end标志
    sed -i -e "/^${diskStartInfo}/d" -e "/^${diskEndInfo}/d" ${smart}
}

log "start collect Diskinfo"
/usr/local/bin/MmlBatch 4016 "cm node show" > $tmp_nodename  2>&1
sleep 20

DiskinfoAll=`/usr/local/bin/MmlBatch 4016 "cm localdiskinfo show"`
for i in $(seq 1 15)
do
    sleep 10
    if [ -f "/tmp/tmpfilelocaldiskinfo" ];then
        break
    else
        log "[$LINENO]times($i) no file(/tmp/tmpfilelocaldiskinfo)."
    fi
done

set_ifs
#判断是否mml回显过长，生成临时文件
ProductName=$(cat "/opt/huawei/deploy/package/version"|grep ProductName|awk -F= '{print $2}')
echo "$DiskinfoAll" | grep "/tmp/tmpfilelocaldiskinfo" |awk -F" " '{print $4}' >/dev/null
if [ $? -eq 0 ];then
    DiskinfoAll=`cat /tmp/tmpfilelocaldiskinfo`
fi

#生成smart0.txt文件
if [ -f "${disksmartfile}" ];then
    #从/var/log/snas_DiskStatus.log 历史数据和 新数据分开采集  需要取的开始位置在匹配行上一行
    # 匹配行格式 Thu Aug 13 01:05:21 CST 2020
    disk_info=($(cat $disksmartfile | grep -nE "^([A-Z][a-z]{2} ){2} ?[0-9]{1,2} [0-9]{2}(:[0-9]{2}){2} [A-Z]{3} [0-9]{4}"| awk -F: '{print $1-1}'|awk '{print }'))
    #snas_DiskStatus.log中不存在历史数据 就直接拷贝文件
    if [ ${#disk_info[*]} -gt 1 ];then
        totalLine=$(wc -l $disksmartfile | awk '{print $1}') #文件行数
        hisDiskinfoEndLine=${disk_info[${#disk_info[*]}-1]}                     # 历史磁盘数据结束行
        curDiskinfoLineCnt=$[$totalLine-${disk_info[${#disk_info[*]}-1]}+1]     #最近一次更新磁盘数据 总行数
        head -n{hisDiskinfoEndLine} $disksmartfile > ${smarthistory}            #从文件首行提取历史
        tail -n${curDiskinfoLineCnt} $disksmartfile > ${smart}                  #提取最新数据
    else
        cp "${disksmartfile}" "${smart}"
    fi
else
    log "get smart file fail,disksmartfile=[${disksmartfile}]"
fi

for line in $DiskinfoAll;do
    if [ $line = "" ];then
        continue
    fi
    runningStatus=$(echo "${line}" | awk -F'\\|\\|' '{print $5}' | awk -F':' '{print $2}' | tr -d ' ')
    if [ "$runningStatus" = "" ];then
        continue
    else
        if [ $runningStatus -eq 27 ];then
            parentID=$(echo "${line}" | awk -F'\\|\\|' '{print $2}' | awk -F':' '{print $2}' | tr -d ' ')
            ID_hostname=$(cat $tmp_nodename | grep "Node_ID: $parentID " | awk -F'\\|\\|' '{print $2}' | awk -F':' '{print $2}' | tr -d ' ')
            slot=$(echo "${line}" | awk -F'\\|\\|' '{print $3}' | awk -F':' '{print $2}' | tr -d ' ')
            ID="$ID_hostname.$slot"

            diskType=$(echo "${line}" | awk -F'\\|\\|' '{print $6}' | awk -F':' '{print $2}' | tr -d ' ')
            diskType=$(MapDiskType $diskType)

            manu=$(echo "${line}" | awk -F'\\|\\|' '{print $12}' | awk -F':' '{print $2}' | tr -d ' ')

            SN=$(echo "${line}" | awk -F'\\|\\|' '{print $13}' | awk -F':' '{print $2}' | tr -d ' ')
            if [ "9000" == "$ProductName" ];then
                /usr/local/bin/MmlBatch 4092 "kmms show key $SN" |grep Sv_compid >> $disk_kmm_info  2>&1
            fi
            echo "$ID $diskType $manu $SN" >> $basicinfo
            #判断收集smart信息成功的磁盘个数
            cat ${smart} | grep "Serial Number:" | grep -qw "$SN"  >/dev/null
            if [ $? -eq 0 ];then
                let successnumber++
            else
                log "[$LINENO]get smart info fail for SN:${SN}"
            fi
        fi
    fi
done
restore_ifs

#删除一些历史的磁盘信息
DelCurNoExistDiskInfo
#拷贝历史smart信息到目录history_smart
if [ -f ${disksmarthistoryfile} ];then
    cp ${disksmarthistoryfile} ${smarthistory}
fi

#普通设备查询smart0的信息，所有节点都需要执行
disknumber=$(cat ${basicinfo} | wc -l)
#统计收集成功的磁盘个数
echo "total=$disknumber" >> $summary
echo "success=$successnumber" >> $summary

cd $sub_path
tar zcf ${output_file} ./* >/dev/null 2>&1
if [ -d ${sub_path} ];then
    rm -rf  ${sub_path}
fi

log "end collect Diskinfo"　
