#!/bin/sh

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh
TMP_snas_CA_BASE_PATH="${CMLogDir}../tmp_snas_CA"
TMP_snas_CA_MSG_PATH="${TMP_snas_CA_BASE_PATH}/Messages"
g_snas_CA_collect_bysize=1
SUBNAME="snas_CA"

function usage()
{
    echo "$ScriptCAFname <product_name> <version> <output_file> <begin_time> <end_time> [log_size]"
    echo "product_name          collect product name"
    echo "version               collect product version"
    echo "output_file           collect file to save the log, eg: *.tar.gz"
    echo "begin_time            collect start time, the default value is null"
    echo "end_time              collect end time, the default value is null"
    echo "log_size              collect size of file"
    return 0
}

#Ҫռ־ȷЩ־ļռ
function get_cfglog_seconds()
{
    local rc=0
    local cur_sec=0
    
    if [ 1 -eq ${g_snas_CA_collect_bysize} ];then
        cur_sec=$(date +%s)
        rc=$?
        ret_seconds ${cur_sec}
        return ${rc}
    else
        endtime_s=$( getSeconds "${end_time}" )
        let "cur_sec=endtime_s - 1"
        ret_seconds ${cur_sec}
        return $?
    fi
}
function getUtcSecondsFromsnas_CAFileName()
{
    local fname=$1
    local sname=$(basename ${fname})
    local tmp=""
    local cuttail=""
    local cur_sec=$(get_cfglog_seconds)
    local sec=0
    local rc=0
    
    echo ${sname} | grep "snas_CA.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas_CA.log.2019-01-20_21.tar.gz or snas_CA.log or snas_CA.log_2019-05-23-15:07:45.376721
        tmp=${sname##*snas_CA.log}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            #snas_CA.log
            sec=${cur_sec}
        elif [ "${tmp}" == "${cuttail}" ];then
            #snas_CA.log_2019-05-23-15:07:45.376721
            #tmp: _2019-05-23-15:07:45.376721
            sec=$(GetSecondForC01 ${tmp#*_})    
        else
            #cuttail:.2019-01-20_21
            sec=$(getSeconds "$(echo ${cuttail} | sed 's/.//;s/_/ /g')" )
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    #ظ־׺_1ʱ
    echo ${sname} | grep "snas_CA.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas_CA.log.2019-01-08_04_1.tar.gz or snas_CA.log.2019-01-08_04_2.tar.gz  
        tmp=${sname##*snas_CA.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    ##/var/log/δѹļ޺׺ʱ
    ret_seconds ${cur_sec}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
    fi
    return ${rc}
}

 function snas_CAGetLoglist()
{
    local out_file=${1}
    local sub_paths="/var/log/snas /var/log/backup/snas_CA"
    local in_rec_file=""
    local des_path="${MessageDir}snas_CA"
    local loc_cur_logs="${Collect_CA_Log}"
    local loc_tar_logs="snas_CA.log"
    local loc_file=""
    local out_basedir=$(dirname ${out_file})
    
    if [ $# -gt 1 ];then
        in_rec_file=${2}
        if [ ! -f ${in_rec_file} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"ERROR, ${in_rec_file} is not exist!"
            return 1
        fi 
        #files in FileSystem ,12
        for file in ${loc_tar_logs}
        do
            grep "${file}.*.tar.gz" ${in_rec_file} | awk -v dpath=${des_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get ${file}.*.tar.gz from ${rec_file} and redirect to ${out_file} fail"
        done
        
        return 0
    else
        #δѹļ
        for file in ${loc_cur_logs}
        do
            ls -l /var/log/${file}* 2> /dev/null | grep -v ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/${file} >> ${out_file} fail"
        done
       
        #ѹļsnas_CA.log.2019-05-14_03.tar.gz snas_CA.log.2019-05-14_03_1.tar.gz 
        for path in ${sub_paths}
        do
            for file in ${loc_tar_logs}
            do
                if [ -d "${path}" ];then
                    ls -l ${path}/${file}* 2> /dev/null | grep ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/${file}* >> ${out_file} fail"
                fi 
            done
        
        done

        return 0
    fi

}


function CA_collect()
{
    log [$SUBNAME]"start collect snas_CA,size:${log_size},begin_time:${begin_time},end_time:${end_time}"
    local collect_sub=$1
    local begin_time=$2
    local end_time=$3
    local size=$4
    local need_size="${size}"
    local rc=0
    local sub_path="${MessageDir}snas_CA"
    available_size=$(getAvailableSize)
    log "available size is:${available_size}"
    if [ $(echo "${MIN_VALUE} > ${available_size}" | bc) -eq 1  ];then
        echo "collect size will over 90%, exit collect"
        log [$SUBNAME]"collect size will over 90%, exit collect."
        clean
        exit 1
    fi
    
    rm -rf ${sub_path}
    mkdir -p ${sub_path}
    
    collect_compressed_logs "${collect_sub}" "${size}" "${begin_time}" "${end_time}" snas_CAGetLoglist getUtcSecondsFromsnas_CAFileName dfs_s3_cp
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect_compressed_logs ${collect_sub} ${collect_size} ${begin_time} ${end_time} snas_CAGetLoglist getUtcSecondsFromsnas_CAFileName dfs_s3_cp fail with ${rc}"
    fi
    
    #delete tempory path.
    if [ -d ${TMP_snas_CA_BASE_PATH} ] ;then
        rm -rf ${TMP_snas_CA_BASE_PATH} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm ${TMP_snas_CA_BASE_PATH} fail"
    fi
    #ʹÿռ
    adjustSize
    real_size=$(du "${sub_path}" | tail -n1 | cut -f1)
    
    #
    cd ${sub_path}
    #tar zcvf ${output_file} ./* >/dev/null 2>&1
    tar cf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1 
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, tar cvf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1  fail with ${rc}"
    fi
    if [ -d ${sub_path} ] ; then
        rm -rf ${sub_path}/* || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm -rf ${sub_path}/* fail"
    fi
    
    log [$SUBNAME]"end collect ${collect_sub},real size is ${real_size},"
    return 0
}

#ռCAϢ
function collectCAInfo()
{
    return
}

function main()
{
    if [ "X${type}" == "Xconfig" ];then
        log "[$FUNCNAME][$LINENO]start collect CA config"
        collectCAInfo
        log "[$FUNCNAME][$LINENO]end collect CA config"
    elif [ "X${type}" == "Xlog" ];then
        if [ "X$begin_time" != "Xnull" -o "X$end_time" != "Xnull" ];then
            g_snas_CA_collect_bysize=0
            log_size="0" 
        fi
        CA_collect "snas_CA" "${begin_time}" "${end_time}" "${log_size}"
        return $?
        
    else
        usage
        return 1
    fi
    return 1
}

type=$1
product_name=$2
version=$3
output_file=$4
begin_time=$5
end_time=$6
log_size=$7

#жϲƷ
judge_product_type
prepare

main
exit $?
