#!/bin/sh

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh
TMP_MONBJM_BASE_PATH="${CMLogDir}../tmp_MON_BJM"
TMP_MONBJM_MSG_PATH="${TMP_MONBJM_BASE_PATH}/Messages"
g_MON_BJM_collect_bysize=1
SUBNAME="MON_BJM"
#ļ12
function usage()
{
    echo "$ScriptMONandBJMFname <product_name> <version> <output_file> <begin_time> <end_time> [log_size]"
    echo "product_name          collect product name"
    echo "version               collect product version"
    echo "output_file           collect file to save the log, eg: *.tar.gz"
    echo "begin_time            collect start time, the default value is null"
    echo "end_time              collect end time, the default value is null"
    echo "log_size              collect size of file"
    return 0
}

#Ҫռ־ȷЩ־ļռ
function get_cfglog_seconds()
{
    local rc=0
    local cur_sec=0
    
    if [ 1 -eq ${g_MON_BJM_collect_bysize} ];then
        cur_sec=$(date +%s)
        rc=$?
        ret_seconds ${cur_sec}
        return ${rc}
    else
        endtime_s=$( getSeconds "${end_time}" )
        let "cur_sec=endtime_s - 1"
        ret_seconds ${cur_sec}
        return $?
    fi
}

function getUtcSecondsFromMONBJMFileName()
{
    local fname=$1
    local sname=$(basename ${fname})
    local tmp=""
    local cuttail=""
    local cur_sec=$(get_cfglog_seconds)
    local sec=0
    local rc=0
    
    echo ${sname} | grep "MON_BJM.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #MON_BJM.log.2019-01-20_21.tar.gz  
        tmp=${sname##*MON_BJM.log.}
        cuttail=$(echo ${tmp%.tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "MON_BJM.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #platform.log.2019-01-08_04_1.tar.gz or platform.log.2019-01-08_04_2.tar.gz  
        tmp=${sname##*MON_BJM.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep snas_MON.log > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas_MON.log_2019-01-18-15:00:00.862422 or snas_MON.log
        tmp=${sname##*snas_MON.log}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            #snas_MON.log
            sec=${cur_sec}
        else 
            #snas_MON.log_2019-01-18-15:00:00.862422 
            #tmp: _2019-01-18-15:00:00.862422
            sec=$(GetSecondForC01 ${tmp#*_})
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep snas_BJM.log > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas_BJM.log_2019-01-18-15:00:00.862422 or snas_BJM.log 
        tmp=${sname##*snas_BJM.log}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            #snas_BJM.log
            sec=${cur_sec}
        else 
            #snas_BJM.log_2019-01-18-15:00:00.862422 
            #tmp: _2019-01-18-15:00:00.862422
            sec=$(GetSecondForC01 ${tmp#*_})
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    ##Ͱ汾snas.log
    echo ${sname} | grep "snas.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas_CM.log_2018-10-15-23.00.00.234996.tar.gz
        #snas.log.2019-04-02_21.tar.gz 
        tmp=${sname##*snas.log.}
        cuttail=$(echo ${tmp%.tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "snas.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #snas.log.2019-01-08_04_1.tar.gz  
        tmp=${sname##*snas.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    ##/var/log/snas_mon_crit.log snas_fault.log޺׺ʱ
    ret_seconds ${cur_sec}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
    fi
    return ${rc}
}
 function MONBJMGetLoglist()
{
    local out_file=${1}
    local sub_paths="/var/log/snas /var/log/backup/MON_BJM"
    local in_rec_file=""
    local des_path="${MessageDir}MON_BJM"
    local loc_cur_logs="${Collect_MON_BJM_Other_Log} ${Collect_MON_BJM_Log}"
    local loc_tar_logs="MON_BJM.log"
    #֮ǰĴ߼ﶼsnas.log־, C01汾snas_CM.log.*.tar.gz,Ͱ汾ǲһ
    local C01_file_paths="/var/log/snas /var/log/backup/snas"
    local loc_C01_logs="snas.log"
    local loc_file=""
    local out_basedir=$(dirname ${out_file})
    
    if [ $# -gt 1 ];then
        in_rec_file=${2}
        if [ ! -f ${in_rec_file} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"ERROR, ${in_rec_file} is not exist!"
            return 1
        fi 
        #files in FileSystem ,ǲҪݵͰ汾C01,snas? ,12
        for file in ${loc_tar_logs}
        do
            grep "${file}.*.tar.gz" ${in_rec_file} | awk -v dpath=${des_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get ${file}.*.tar.gz from ${rec_file} and redirect to ${out_file} fail"
        done
        grep "snas.log.*.tar.gz" ${in_rec_file} | awk -v dpath=${des_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get snas.log.*.tar.gz from ${rec_file} and redirect to ${out_file} fail"
        return 0
    else
        #δѹļʱĸļ,кܶ,cmr_auth.log,cmr_auth.log.1ʽ,Ҫע.1ʽ־
        for file in ${loc_cur_logs}
        do
            ls -l /var/log/${file}* 2> /dev/null | grep -v ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/${file} >> ${out_file} fail"
        done
       
        #ѹļMON_BJM.log.2018-11-29_21.tar.gz MON_BJM.log.2018-11-27_01_1.tar.gz 
        for path in ${sub_paths}
        do
            for file in ${loc_tar_logs}
            do
                if [ -d "${path}" ];then
                    ls -l ${path}/${file}* 2> /dev/null | grep ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/${file}* >> ${out_file} fail"
                fi 
            done
        
        done
        #C01Ͱ汾־ 
        #(C01汾ֻ/var/logsnas_CM.log,û/var/log/snas ,/var/log/backup/Ŀ¼, ֮C01汾־ȥ?)
        #Ͱ汾Ҫ:/var/log/snas/snas.log.*.tar.gz ,/var/log/backup/snas.log.*.tar.gz,/mnt/.../snas.log.*.tar.gz ,ڱģ־ûյ12ʱȥռsnas.log.*.tar.gz
        for C01path in ${C01_file_paths}
        do
            if [ -d ${C01path} ];then
                ls -l ${C01path}/${loc_C01_logs}* 2> /dev/null | grep ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/backup/ISM/ibase.log* >> ${out_file} fail"
            fi
        done
        return 0
    fi

}

function MON_BJM_collect()
{
    log "[$SUBNAME]start collect MON_BJM,size:${log_size},begin_time:${begin_time},end_time:${end_time}"
    local collect_sub=$1
    local begin_time=$2
    local end_time=$3
    local size=$4
    local need_size="${size}"
    local rc=0
    local sub_path="${MessageDir}MON_BJM"
    available_size=$(getAvailableSize)
    log "available size is:${available_size}"
    if [ $(echo "${MIN_VALUE} > ${available_size}" | bc) -eq 1  ];then
        echo "collect size will over 90%, exit collect"
        log "[$SUBNAME]collect size will over 90%, exit collect."
        clean
        exit 1
    fi
    
    rm -rf ${sub_path}
    mkdir -p ${sub_path}
    
    collect_compressed_logs "${collect_sub}" "${size}" "${begin_time}" "${end_time}" MONBJMGetLoglist getUtcSecondsFromMONBJMFileName dfs_s3_cp
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect_compressed_logs ${collect_sub} ${collect_size} ${begin_time} ${end_time} MONBJMGetLoglist getUtcSecondsFromMONBJMFileName dfs_s3_cp fail with ${rc}"
    fi
    
    #delete tempory path.
    if [ -d ${TMP_MONBJM_BASE_PATH} ] ;then
        rm -rf ${TMP_MONBJM_BASE_PATH} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm ${TMP_MONBJM_BASE_PATH} fail"
    fi
    #ʹÿռ
    adjustSize
    real_size=$(du "${sub_path}" | tail -n1 | cut -f1)
    
    #
    cd ${sub_path}
    #tar zcvf ${output_file} ./* >/dev/null 2>&1
    tar cf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1 
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, tar cvf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1  fail with ${rc}"
    fi
    if [ -d ${sub_path} ] ; then
        rm -rf ${sub_path}/* || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm -rf ${sub_path}/* fail"
    fi
    
    log "[$SUBNAME]end collect ${collect_sub},real size is ${real_size},"
    return 0
}

#ռMonϢ
function collectMonInfo()
{
    log "[$SUBNAME]start get MonInfo,ret($?)"
    local CmdPort4=4004
    local CmdPort=988

    #ռеmapϢ
    cp -f /proc/monc_* "$CMLogDir"Other/
    log "[$SUBNAME]start get map info,ret($?)"

    cp -f "$CONFIG_DEPLOY"monc.ini  "$CMLogDir""Config/"
    cp -f "$CONFIG_DEPLOY"mons.ini  "$CMLogDir""Config/"

    ##################ȡmml_4004Ϣ#########################
    log "[$SUBNAME]start collect Mon mml_4004 info"

    #ӡmonitorؼȫֱ/ӡmonitor activeϢ/ӡڵmonsϱmonmap
    cat /proc/monc_monmap > $G_MON_MML_4004_FILE 2>&1
    log "[$SUBNAME]cat /proc/monc_monmap > $G_MON_MML_4004_FILE"

    #ӡmonitor mapϢ
    #ֻmonڵִ
    MasterIp=`cat /proc/monc_leader | grep "Mon leader" | awk -F":" '{print $2}' | tr -d " "`
    ip addr show | grep ${MasterIp}
    if [ $? -eq 0 ];then
        $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc nluninfo 0"
        cat /var/log/nluninfo.log >> $G_MON_MML_4004_FILE 2>&1
        log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc nluninfo 0" ; cat /var/log/nluninfo.log >> $G_MON_MML_4004_FILE"
        cp -f /var/log/nlunmap.log   "$CMLogDir"Other/
        cat /proc/monc_balancemap >> $G_MON_MML_4004_FILE 2>&1
        log "[$SUBNAME]cat /proc/monc_balancemap >> $G_MON_MML_4004_FILE"
        cp -f /var/log/balancemap.log   "$CMLogDir"Other/
        cat /proc/monc_recoverymap >> $G_MON_MML_4004_FILE 2>&1
        log "[$SUBNAME]cat /proc/monc_recoverymap >> $G_MON_MML_4004_FILE"
        cp -f /var/log/recoverymap.log   "$CMLogDir"Other/
    fi

    #ӡmonitorϢͳϢ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort4 "mon msg 0" >> $G_MON_MML_4004_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort4 "mon msg 0" >> $G_MON_MML_4004_FILE"

    #ӡڵmonsϱdsmap
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort4 "mon dsmap 0" >> $G_MON_MML_4004_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort4 "mon dsmap 0" >> $G_MON_MML_4004_FILE"    

    #ӡڵmonsϱdscapmap
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc dscapmap 0" >> $G_MON_MML_4004_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc dscapmap 0" >> $G_MON_MML_4004_FILE"    

    #ӡڵmonsϱrecoveryMap
    cat /proc/monc_recoverymap >> $G_MON_MML_4004_FILE 2>&1
    cat /var/log/recoverymap.log >>  $G_MON_MML_4004_FILE 
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort4 "mon recovmap  0" >> $G_MON_MML_4004_FILE"

    #ӡڵmonsϱmdsmapеıݽڵ/ӡڵmonsϱmdsmapеĻԾڵ
    cat /proc/monc_mdsmap >> $G_MON_MML_4004_FILE 2>&1
    log "[$SUBNAME]cat /proc/monc_mdsmap >> $G_MON_MML_4004_FILE"

    #ӡڵmonsϱdlmmap
    cat /proc/monc_dlmmap >> $G_MON_MML_4004_FILE 2>&1
    log "[$SUBNAME]cat /proc/monc_dlmmap >> $G_MON_MML_4004_FILE"

    #ּʾǰmonsбϢ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc tscapmap 0" >> $G_MON_MML_4004_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc tscapmap 0" >> $G_MON_MML_4004_FILE"

    #diskPoolʾǰmonsбϢ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort4 "mon diskpoolcap 0" >> $G_MON_MML_4004_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort4 "mon diskpoolcap 0" >> $G_MON_MML_4004_FILE"    

    #ӡڵmonsϱtscfgmap
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc tsconf 0" >> $G_MON_MML_4004_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc tsconf 0" >> $G_MON_MML_4004_FILE"

    #ӡڵmonsϱtspmap
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc tsp 0" >> $G_MON_MML_4004_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc tsp 0" >> $G_MON_MML_4004_FILE"

    #ӡڵmonsϱnodemap
    cat /proc/monc_nodemap >> $G_MON_MML_4004_FILE 2>&1
    log "[$SUBNAME]cat /proc/monc_nodemap >> $G_MON_MML_4004_FILE"

    #ӡڵmonsϱcamap
    cat /proc/monc_camap >> $G_MON_MML_4004_FILE 2>&1
    log "[$SUBNAME]cat /proc/monc_camap >> $G_MON_MML_4004_FILE"

    #ӡ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort4 "mon health 0" >> $G_MON_MML_4004_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort4 "mon health 0" >> $G_MON_MML_4004_FILE"

    ##################ȡmml_988Ϣ#########################
    log "[$SUBNAME]start collect Mon mml_988 info"

    #ӡڵmoncеĹؼ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc cfg 0" > $G_MON_MML_988_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc cfg 0" > $G_MON_MML_988_FILE"

    #ӡڵmoncеĹؼ¼
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc dbg 0" >> $G_MON_MML_988_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc dbg 0" >> $G_MON_MML_988_FILE"

    #ӡڵmoncmonmap
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc monmap 0" >> $G_MON_MML_988_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc monmap 0" >> $G_MON_MML_988_FILE"

    #ӡڵmoncdsmap
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc dsmap 0" >> $G_MON_MML_988_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc dsmap 0" >> $G_MON_MML_988_FILE"

    #ӡڵmoncnlunmap
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc nlunmap 0" >> $G_MON_MML_988_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc nlunmap 0" >> $G_MON_MML_988_FILE"

    #ӡڵmonctscapmap
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc tscapmap 0" >> $G_MON_MML_988_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc tscapmap 0" >> $G_MON_MML_988_FILE"

    #ӡڵmoncnodemap
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc nodemap 0" >> $G_MON_MML_988_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc nodemap 0" >> $G_MON_MML_988_FILE"

    #ӡڵmonctscfgmap
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc tsconf 0" >> $G_MON_MML_988_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc tsconf 0" >> $G_MON_MML_988_FILE"

    #ӡڵmonctspmap
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc tsp 0" >> $G_MON_MML_988_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc 0" >> $G_MON_MML_988_FILE"

    #ӡڵmoncdscapmap
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc dscapmap 0" >> $G_MON_MML_988_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc dscapmap 0" >> $G_MON_MML_988_FILE"

    #ӡcfgmapݣƵϢ
    $G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc cfgmap show" >> $G_MON_MML_988_FILE 2>&1
    log "[$SUBNAME]$G_MML_PATH/CollectDataMml $LOCAL_IP $CmdPort "monc cfgmap show" >> $G_MON_MML_988_FILE"

    ##################ȡMONϢ#########################
    log "[$SUBNAME]start collect Mon other info"

    #ݹʾmonstoreĿ¼ļ޸ʱ
    ls -l -R  /opt/huawei/snas/etc/monstore/ > $G_MON_MONSTORE_FILE 2>&1
    log "[$SUBNAME]ls -l -R  /opt/huawei/snas/etc/monstore/ > $G_MON_MONSTORE_FILE"
    #home
    ls -l /home/ > $G_MON_HOME_FILE 2>&1
    log "[$SUBNAME]ls -l /home/ > $G_MON_HOME_FILE"
    
    #monһЩϢmonitor_mapĿ¼
    if [ -d $MonDir ];then
        rm -rf $MonDir
    fi
    mkdir -p $MonDir 
    cp -rf /opt/huawei/snas/etc/monstore $MonDir >/dev/null 2>&1 
    cp -rf /opt/huawei/snas/etc/monstorebase $MonDir >/dev/null 2>&1 
    cp -rf /opt/huawei/snas/map_rollback $MonDir >/dev/null 2>&1 
    cp -rf /opt/huawei/snas/monstore_bakup $MonDir >/dev/null 2>&1 
    #ȡCCDBϢ
    ps aux |grep ccdb >$G_CCDB_PROCESS_FILE >/dev/null 2>&1
    log "[$SUBNAME]ps aux |grep ccdb >$G_CCDB_PROCESS_FILE"
    history >$G_HISTORY_FILE >/dev/null 2>&1
    log "[$SUBNAME]ps aux |grep ccdb >$G_CCDB_PROCESS_FILE"
     
}

function main()
{
    if [ "X${type}" == "Xconfig" ];then
        collectMonInfo
        log "[$SUBNAME]collect config end"
        return 0
    elif [ "X${type}" == "Xlog" ];then
        if [ "X$begin_time" != "Xnull" -o "X$end_time" != "Xnull" ];then
            g_MON_BJM_collect_bysize=0
            log_size="0" 
        fi
        MON_BJM_collect "MON_BJM" "${begin_time}" "${end_time}" "${log_size}"
        return $?
    else
        usage
        return 1
    fi
    return 1
}

type=$1
product_name=$2
version=$3
output_file=$4
begin_time=$5
end_time=$6
log_size=$7

#жϲƷ
judge_product_type
product_type
prepare

main
exit $?
