#!/bin/sh

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh

TMP_OS_BASE_PATH="${CMLogDir}../tmp_OS"
TMP_OS_MSG_PATH="${TMP_OS_BASE_PATH}/Messages"

g_OS_collect_bysize=1
SUBNAME="OS"
#ļ12
function usage()
{
    echo "$ScriptOSFname <product_name> <version> <output_file> <begin_time> <end_time> [log_size]"
    echo "product_name          collect product name"
    echo "version               collect product version"
    echo "output_file           collect file to save the log, eg: *.tar.gz"
    echo "begin_time            collect start time, the default value is null"
    echo "end_time              collect end time, the default value is null"
    echo "log_size              collect size of file"
    return 0
}

 
#Ҫռ־ȷЩ־ļռ
function get_cfglog_seconds()
{
    local rc=0
    local cur_sec=0
    
    if [ 1 -eq ${g_OS_collect_bysize} ];then
        cur_sec=$(date +%s)
        rc=$?
        ret_seconds ${cur_sec}
        return ${rc}
    else
        endtime_s=$( getSeconds "${end_time}" )
        let "cur_sec=endtime_s - 1"
        ret_seconds ${cur_sec}
        return $?
    fi
}

function getUtcSecondsFromOSFileName()
{
    local fname=$1
    local sname=$(basename ${fname})
    local tmp=""
    local cuttail=""
    local cur_sec=$(get_cfglog_seconds)
    local sec=0
    local rc=0
    local diff_sec=0

    echo ${sname} | grep "message.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #message.log.2019-01-10_23.tar.gz  or message.log
        tmp=${sname##*message.log}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            sec=${cur_sec}
        else
            #cuttail:.2019-01-10_23
            sec=$(getSeconds "$(echo ${cuttail##*.} | sed 's/_/ /g')" )
        fi
        # message log backup one day once
        if [ $sec -gt $cur_sec ]; then
            log [$SUBNAME][$FUNCNAME][$LINENO]"${fname} time: sec=${sec},cur_sec=${cur_sec}" 
            let "diff_sec=sec - cur_sec"
            # 86400 is 24*3600s
            if [ $diff_sec -lt "86400" ]; then
                sec=$cur_sec
            fi
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    echo ${sname} | grep "message.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #message.log.2019-01-08_04_1.tar.gz or message.log.2019-01-08_04_2.tar.gz  
        tmp=${sname##*message.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        # message log backup one day once
        if [ $sec -gt $cur_sec ]; then
            log [$SUBNAME][$FUNCNAME][$LINENO]"${fname} time: sec=${sec},cur_sec=${cur_sec}" 
            let "diff_sec=sec - cur_sec"
            # 86400 is 24*3600s
            if [ $diff_sec -lt "86400" ]; then
                sec=$cur_sec
            fi
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    echo ${sname} | grep "audit.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #audit.log.2019-01-10_23.tar.gz  
        tmp=${sname##*audit.log}
        cuttail=$(echo ${tmp%.tar.gz*})
        if [ "X" == "X${tmp}" ];then
            sec=${cur_sec}
        else
            #cuttail:.2019-01-10_23
            sec=$(getSeconds "$(echo ${cuttail##*.} | sed 's/_/ /g')" )
        fi
        if [ $sec -gt $cur_sec ]; then
            log [$SUBNAME][$FUNCNAME][$LINENO]"${fname} time: sec=${sec},cur_sec=${cur_sec}" 
            let "diff_sec=sec - cur_sec"
            # 86400 is 24*3600s
            if [ $diff_sec -lt "86400" ]; then
                sec=$cur_sec
            fi
        fi
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    echo ${sname} | grep "audit.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #audit.log.2019-01-08_04_1.tar.gz or message.log.2019-01-08_04_2.tar.gz  
        tmp=${sname##*audit.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        if [ $sec -gt $cur_sec ]; then
            log [$SUBNAME][$FUNCNAME][$LINENO]"${fname} time: sec=${sec},cur_sec=${cur_sec}" 
            let "diff_sec=sec - cur_sec"
            # 86400 is 24*3600s
            if [ $diff_sec -lt "86400" ]; then
                sec=$cur_sec
            fi
        fi
        return ${rc}
    fi  
    
    ##/var/log/־޺׺ʱ
    ret_seconds ${cur_sec}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
    fi
    return ${rc}
}
 function OSGetLoglist()
{
    local out_file=${1}
    local sub_paths="/var/log/audit /var/log/message /var/log/backup/message /var/log/backup/audit /var/log/backup/OS"
    local in_rec_file=""
    local des_path="${MessageDir}OS"
    local loc_cur_logs="${Collect_OS_Other_Log} ${Collect_OS_Log}"
    local loc_tar_logs="message.log audit.log"
    #ģͰ汾Ҳsnas.log־,Ͱ汾·/var/log/backup/message,/var/log/backup/audit
    local loc_file=""
    local out_basedir=$(dirname ${out_file})
    
    if [ $# -gt 1 ];then
        in_rec_file=${2}
        if [ ! -f ${in_rec_file} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"ERROR, ${in_rec_file} is not exist!"
            return 1
        fi 
        #files in FileSystem 12
        for file in ${loc_tar_logs}
        do
            grep "${file}.*.tar.gz" ${in_rec_file} | awk -v dpath=${des_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get ${file}.*.tar.gz from ${rec_file} and redirect to ${out_file} fail"
        done
        #Ͱ汾
        #grep "snas.log.*.tar.gz" ${in_rec_file} | awk -v dpath=${des_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$FUNCNAME][$LINENO]"Warning, get snas.log.*.tar.gz from ${rec_file} and redirect to ${out_file} fail"
        return 0
    else
        #δѹļʱĸļ
        for file in ${loc_cur_logs}
        do
            ls -l /var/log/${file}* 2> /dev/null | grep -v ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/${file} >> ${out_file} fail"
        done
       
        #ѹļMON_BJM.log.2018-11-29_21.tar.gz MON_BJM.log.2018-11-27_01_1.tar.gz 
        for path in ${sub_paths}
        do
            for file in ${loc_tar_logs}
            do
                if [ -d "${path}" ];then
                    ls -l ${path}/${file}* 2> /dev/null | grep ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/${file}* >> ${out_file} fail"
                fi 
            done
        
        done
        return 0
    fi

}

function OS_collect()
{
    log [$SUBNAME]"start collect OS,size:${log_size},begin_time:${begin_time},end_time:${end_time}"
    local collect_sub=$1
    local begin_time=$2
    local end_time=$3
    local size=$4
    local need_size="${size}"
    local rc=0
    local sub_path="${MessageDir}OS"
    local FilePreLists="snas_audit.log"
    local zipfiletype="audit.log"
    available_size=$(getAvailableSize)
    log "available size is:${available_size}"
    if [ $(echo "${MIN_VALUE} > ${available_size}" | bc) -eq 1  ];then
        echo "collect size will over 90%, exit collect"
        log [$SUBNAME]"collect size will over 90%, exit collect."
        clean
        exit 1
    fi

    #dlm os, dlm_info other.
    ${ScriptDir_DLM}/${ScriptDLMFname} "$CMLogDir"Other

    rm -rf ${sub_path}
    mkdir -p ${sub_path}
    
    collect_compressed_logs "${collect_sub}" "${size}" "${begin_time}" "${end_time}" OSGetLoglist getUtcSecondsFromOSFileName dfs_s3_cp
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect_compressed_logs ${collect_sub} ${collect_size} ${begin_time} ${end_time} OSGetLoglist getUtcSecondsFromOSFileName dfs_s3_cp fail with ${rc}"
    fi
    
    #delete tempory path.
    if [ -d ${TMP_OS_BASE_PATH} ] ;then
        rm -rf ${TMP_OS_BASE_PATH} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm ${TMP_OS_BASE_PATH} fail"
    fi
    #ʹÿռ
    adjustSize
    real_size=$(du "${sub_path}" | tail -n1 | cut -f1)
    
    #OSģ
    OSpath="${MessageDir}OS/"
    DelSensitiveInfoForEmailAndPhtone "${OSpath}" "${FilePreLists}" "${zipfiletype}"
    #
    cd ${sub_path}
    #tar zcvf ${output_file} ./* >/dev/null 2>&1
    tar cf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1 
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, tar cvf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1  fail with ${rc}"
    fi
    if [ -d ${sub_path} ] ; then
        rm -rf ${sub_path}/* || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm -rf ${sub_path}/* fail"
    fi
    
    log [$SUBNAME]"end collect ${collect_sub},real size is ${real_size},"
    return 0
}
#ռ
function collectMiscInfo()
{
    #Ѽ/var/log/stack.log
    if [ -f /var/log/stack.log ];then
        cp -f /var/log/stack.log   "${MessageDir}"  >/dev/null 2>&1  
    fi

    #Ѽ/home/inconsfile
    if [ -f /home/inconsfile ];then
        cp -f /home/inconsfile   "${MessageDir}"  >/dev/null 2>&1  
    fi
    
    #Ѽ/var/log/statisµļ
    if [ -d /var/log/statis/ ]; then
        local currenttime=$(date +%Y-%m-%d-%T)
        cp -f /var/log/statis/statis_acc_statis  "${MessageDir}"statis_acc_statis_"${currenttime}" >/dev/null 2>&1  
    fi
    
    ipmitool sdr > "$CMLogDir"Other/ipmitool_sdr_info 2>&1
    log [$SUBNAME]"ipmitool sdr > "$CMLogDir"Other/ipmitool_sdr_info"

    free -m > "$CMLogDir"Other/free_m_info 2>&1
    log [$SUBNAME]"free -m > "$CMLogDir"Other/free_m_info"

    cp -f /proc/slabinfo  "$CMLogDir"Other/slabinfo_info 2>&1
    log [$SUBNAME]"free -m > "$CMLogDir"Other/slabinfo_info"

    free -m > "$CMLogDir"Other/free_m_info 2>&1
    log [$SUBNAME]"free -m > "$CMLogDir"Other/free_m_info"

    #Ϣ    
    ifconfig > "$CMLogDir"Other/ifconfig_info 2>&1
    log [$SUBNAME]"ifconfig > "$CMLogDir"Other/ifconfig_info,ret($?)"

    arp -n > "$CMLogDir"Other/arp_n_info 2>&1
    log [$SUBNAME]"arp -n > "$CMLogDir"Other/arp_n_info,ret($?)"

    netstat -anpt > "$CMLogDir"Other/netstat_anpt_info 2>&1
    log [$SUBNAME]"netstat -anpt > "$CMLogDir"Other/netstat_anpt_info,ret($?)"

    #cpu
    ps H -eo user,pid,ppid,tid,time,%cpu,%mem,cmd --sort=%cpu > "$CMLogDir"Other/cpu_info 2>&1
    log [$SUBNAME]"ps H -eo user,pid,ppid,tid,time,%cpu,%mem,cmd --sort=%cpu > "$CMLogDir"Other/cpu_info,ret($?)" 
    
    #collcet mmap_service.log 
    if [ -f /var/log/mmap_service.log ];then
        cp -f /var/log/mmap_service.log  "$CMLogDir"Other >/dev/null 2>&1
    fi
    
    sysctl -p > "$CMLogDir"Other/sysctl 2>&1
    cat /proc/cpuinfo > "$CMLogDir"Other/cpuinfo 2>&1
    cat /proc/meminfo > "$CMLogDir"Other/meminfo 2>&1
    cp  /etc/ntp.conf "$CMLogDir"Other/ >/dev/null 2>&1
    cp -r /opt/huawei/snas/map_backup "$CMLogDir""Config/"
    
    #ϵͳλ¼
    last > "$CMLogDir"Other/system_reboot
    log [$SUBNAME]"$Item: Get system last info ,ret($?)." 
    #ϵͳ״̬Ϣ
    ipmitool fru > "$CMLogDir"Other/ipmitool_fru_info
    log [$SUBNAME]"$Item: Get ipmitool fru info,ret($?)." 

    #Ѽ/home/inconsfile
    if [ -f /home/inconsfile ];then
        cp -f /home/inconsfile   "${MessageDir}"  >/dev/null 2>&1  
    fi
    
    return 0
}

function main()
{
    if [ "X${type}" == "Xconfig" ];then
        log [$SUBNAME]"start collect config"
        collectMiscInfo
        log [$SUBNAME]"end collect config"
        return 0
    elif [ "X${type}" == "Xlog" ];then
        if [ "X$begin_time" != "Xnull" -o "X$end_time" != "Xnull" ];then
            g_OS_collect_bysize=0
            log_size="0" 
        fi
        OS_collect "OS" "${begin_time}" "${end_time}" "${log_size}"
        return $?
    else
        usage
        return 1
    fi
    return 1
}

type=$1
product_name=$2
version=$3
output_file=$4
begin_time=$5
end_time=$6
log_size=$7

#жϲƷ
judge_product_type
product_type
prepare

main
exit $?