#!/bin/sh

ScriptDir=`dirname $0`
. $ScriptDir/collect_comm.sh

TMP_OSS_BASE_PATH="${CMLogDir}../tmp_OSS"
TMP_OSS_MSG_PATH="${TMP_OSS_BASE_PATH}/Messages"
g_OSS_collect_bysize=1
SUBNAME="OSS"
#ļ, snas.log
function usage()
{
    echo "$ScriptOSSFname <product_name> <version> <output_file> <begin_time> <end_time> [log_size]"
    echo "product_name          collect product name"
    echo "version               collect product version"
    echo "output_file           collect file to save the log, eg: *.tar.gz"
    echo "begin_time            collect start time, the default value is null"
    echo "end_time              collect end time, the default value is null"
    echo "log_size              collect size of file"
    return 0
}

#Ҫռ־ȷЩ־ļռ
function get_cfglog_seconds()
{
    local rc=0
    local cur_sec=0
    
    if [ 1 -eq ${g_OSS_collect_bysize} ];then
        cur_sec=$(date +%s)
        rc=$?
        ret_seconds ${cur_sec}
        return ${rc}
    else
        endtime_s=$( getSeconds "${end_time}" )
        let "cur_sec=endtime_s - 1"
        ret_seconds ${cur_sec}
        return $?
    fi
}

function getUtcSecondsFromOSSFileName()
{
    local fname=$1
    local sname=$(basename ${fname})
    local tmp=""
    local cuttail=""
    local cur_sec=$(get_cfglog_seconds)
    local sec=0
    local rc=0
    
    echo ${sname} | grep "s3.log" | grep -v "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #s3.log.2018-11-29_21.tar.gz  
        tmp=${sname##*s3.log.}
        cuttail=$(echo ${tmp%.tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    echo ${sname} | grep "s3.log" | grep "_[1-9].tar.gz" > /dev/null 2>&1
    if [ 0 -eq $? ];then
        #s3.log.2019-01-08_04_1.tar.gz   
        tmp=${sname##*s3.log.}
        cuttail=$(echo ${tmp%_[1-9].tar.gz*})
        sec=$(getSeconds "$(echo ${cuttail} | sed 's/_/ /g')" )
        ret_seconds ${sec}
        rc=$?
        if [ 0 -ne ${rc} ];then
            log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
        fi
        return ${rc}
    fi
    
    ##/var/log/ S3/servicelog/ s3/scriptLog/ ޺׺ʱ
    ret_seconds ${cur_sec}
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get second from ${fname} fail"            
    fi
    return ${rc}
}
 function OSSGetLoglist()
{
    local out_file=${1}
    local sub_paths="/var/log/s3 /var/log/backup/s3 /var/log/backup/OSS"
    local in_rec_file=""
    local des_path="${MessageDir}OSS"
    local loc_cur_dir_logs="s3/servicelog s3/scriptlog"
    local loc_cur_logs="${Collect_OSS_Log}"
    local loc_tar_logs="s3.log"
    local loc_file=""
    local out_basedir=$(dirname ${out_file})
    
    if [ $# -gt 1 ];then
        in_rec_file=${2}
        if [ ! -f ${in_rec_file} ];then
            log [$FUNCNAME][$LINENO]"ERROR, ${in_rec_file} is not exist!"
            return 1
        fi 
        #files in FileSystem 
        for file in ${loc_tar_logs}
        do
            grep "${file}.*.tar.gz" ${in_rec_file} | awk -v dpath=${des_path} '{print $NF" file " $1 " "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, get ${file}.*.tar.gz from ${rec_file} and redirect to ${out_file} fail"
        done
        return 0
    else
        #2ļ
        for file in ${loc_cur_dir_logs}
        do
            #˴ļļ,ǰѾռ,ֻǼ¼
            echo "/var/log/${file} dir -1 ${des_path} 0 1" >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, echo /var/log/${file} dir -1 ${des_path} 0 0 >> ${out_file} fail"
        done
        #δѹļ
        for file in ${loc_cur_logs}
        do
            #˴ļļ,һƹȥ,β?
            ls -l /var/log/${file}* 2> /dev/null | grep  -v ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 1 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, /var/log/${file}* >> ${out_file} fail"
        done
        
        #ѹļs3.log.2018-11-29_21.tar.gz 
        for path in ${sub_paths}
        do
            for file in ${loc_tar_logs}
            do
                if [ -d "${path}" ];then
                    ls -l ${path}/${file}* 2> /dev/null | grep ".tar.gz$" | awk -v dpath=${des_path} '{print $NF" file "$5" "dpath" 0 0"}' >> ${out_file} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, ${path}/${file}* >> ${out_file} fail"
                fi 
            done
        
        done
        return 0
    fi

}

function collectRepInfo()
{
    local oss_dir="${MessageDir}/OSS"
    local rep_runinfo_file="$oss_dir/rep_runinfo_file"
    
    echo "BEGIN RepInfo Collect" > $rep_runinfo_file
    curl -X GET -v http://127.0.0.1:9123/maintain/rep?type=repruninfo >> $rep_runinfo_file 2>&1
    echo "END RepInfo Collect" >> $rep_runinfo_file
}


function OSS_collect()
{
    log [$SUBNAME]"start collect OSS,size:${log_size},begin_time:${begin_time},end_time:${end_time}"
    local collect_sub=$1
    local begin_time=$2
    local end_time=$3
    local size=$4
    local need_size="${size}"
    local rc=0
    local sub_path="${MessageDir}OSS"
    available_size=$(getAvailableSize)
    log "available size is:${available_size}"
    if [ $(echo "${MIN_VALUE} > ${available_size}" | bc) -eq 1  ];then
        echo "collect size will over 90%, exit collect"
        log [$SUBNAME]"collect size will over 90%, exit collect."
        clean
        exit 1
    fi
    
    rm -rf ${sub_path}
    mkdir -p ${sub_path}
    
    #ռĿ¼ָ·
    collectCurrentLog "OSS"
    
    collect_compressed_logs "${collect_sub}" "${size}" "${begin_time}" "${end_time}" OSSGetLoglist getUtcSecondsFromOSSFileName dfs_s3_cp
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, collect_compressed_logs ${collect_sub} ${collect_size} ${begin_time} ${end_time} OSSGetLoglist getUtcSecondsFromOSSFileName dfs_s3_cp fail with ${rc}"
    fi
    
    #delete tempory path.
    if [ -d ${TMP_OSS_BASE_PATH} ] ;then
        rm -rf ${TMP_OSS_BASE_PATH} || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm ${TMP_OSS_BASE_PATH} fail"
    fi
    #ʹÿռ
    adjustSize
    real_size=$(du "${sub_path}" | tail -n1 | cut -f1)
    
    #Ϣռ
    collectRepInfo
    
    #
    cd ${sub_path}
    #tar zcvf ${output_file} ./* >/dev/null 2>&1
    tar czf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1 
    rc=$?
    if [ 0 -ne ${rc} ];then
        log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, tar cvf ${output_file} -C ${sub_path}/../ ${collect_sub} >/dev/null 2>&1  fail with ${rc}"
    fi
    if [ -d ${sub_path} ] ; then
        rm -rf ${sub_path}/* || log [$SUBNAME][$FUNCNAME][$LINENO]"Warning, rm -rf ${sub_path}/* fail"
    fi
     log [$SUBNAME]"end collect ${collect_sub},real size is ${real_size},"
     return 0
}

#regionϢregionϵ
function getRegionInfo()
{
    log "start collect region info..."
    #ɻ򸲸regionInformation_containsRegionRelations.txt
    regionInforFile="${CMLogDir}/Config/s3/regionInformation_containsRegionRelations.txt"
    echo "**********The Region and Region relations Information**********">$regionInforFile 2>&1
    aksk=`/opt/huawei/snas/script/LsHelper.py ADMIN GET`
    tag=${aksk:0:1}
    #tag == '{'ôakskȡʧ
    if [ "$tag" == '{' ]
    then
        echo "get admin info result is: $aksk, fail to get admin ak">>$regionInforFile 2>&1
        echo "failed to get Region infos, so collect of region info failed">>$regionInforFile 2>&1
        return 0
    fi
    
    i=`expr index $aksk ':'`
    ak=${aksk:0:i-1}
    sk=${aksk:i}
    log "collect region info: index of ':' is $i, ak is $ak"
    
    #ѯregionϢдregionInformation_containsRegionRelations.txt
    echo "Region:">>$regionInforFile 2>&1
    temp=`/opt/huawei/snas/script/LsHelper.py REGION LIST $ak $sk`
    i=`expr index $temp ':'`
    j=`expr index $temp ','`
    rc=${temp:i:j-i-1}
    if [ "$rc" != 0 ]
    then
        log "error:failed to get Region config, get $temp"
        echo "error:failed to get Region config, get $temp">>$regionInforFile 2>&1
    else
        echo $temp>>$regionInforFile 2>&1
    fi
    
    echo "AZ:">>$regionInforFile 2>&1
    temp=`/opt/huawei/snas/script/LsHelper.py AZ LIST $ak $sk`
    i=`expr index $temp ':'`
    j=`expr index $temp ','`
    rc=${temp:i:j-i-1}
    if [ "$rc" != 0 ]
    then
        log "error:failed to get AZ config, get $temp"
        echo "error:failed to get AZ config, get $temp">>$regionInforFile 2>&1
    else
        echo $temp>>$regionInforFile 2>&1
    fi
    
    echo "CLUSTER:">>$regionInforFile 2>&1
    temp=`/opt/huawei/snas/script/LsHelper.py CLUSTER LIST $ak $sk`
    i=`expr index $temp ':'`
    j=`expr index $temp ','`
    rc=${temp:i:j-i-1}
    if [ "$rc" != 0 ]
    then
        log "error:failed to get CLUSTER config, get $temp"
        echo "error:failed to get CLUSTER config, get $temp">>ec$regionInforFile 2>&1
    else
        echo $temp>>$regionInforFile 2>&1
    fi
    
    echo "CLUSTER GROUP:">>$regionInforFile 2>&1
    temp=`/opt/huawei/snas/script/LsHelper.py CG LIST $ak $sk`
    i=`expr index $temp ':'`
    j=`expr index $temp ','`
    rc=${temp:i:j-i-1}
    if [ "$rc" != 0 ]
    then
        log "error:failed to get CG config, get $temp"
        echo "error:failed to get CG config, get $temp">>$regionInforFile 2>&1
    else
        echo $temp>>$regionInforFile 2>&1
    fi
    
    log "collect region infos finished."
}


#ϢռHAڵMDC/UPFĿ¼ռСռļ
function collectMdcUpfDir()
{
    source /opt/obs/scripts/common/s3_config_utility.sh >> /dev/null 2>&1 
    #жǷs3ڵ㣨HAڵ㣩,0ǷS3ڵ㣬1S3ڵ㣬2S3ҵڵ
    is_s3_management_node > /dev/null
    #ռHaڵMDC/UPFĿ¼ռС
    if [ $? -eq 1 ]
    then
        log "start collect mdc/upf dir .."
        
        local config_s3="${CMLogDir}/Config/s3/"
        local mdcdir_spaceinfo="$config_s3/mdcdir_spaceinfo"
        mkdir -p $config_s3/mdcdir_confinfo_dir/
        local upfdir_spaceinfo="$config_s3/upfdir_spaceinfo"
        mkdir -p $config_s3/upfdir_confinfo_dir/
        
        echo "Begin collect /var/uds/user/data_mdc/ space:" > $mdcdir_spaceinfo
        echo "Begin collect /var/uds/user/data_upf/ space:" > $upfdir_spaceinfo
        
        sudo /usr/bin/du -sh  /var/uds/user/data_mdc/ >>  $mdcdir_spaceinfo  2>&1
        cp -rf /var/uds/user/data_mdc/PG_VERSION  /var/uds/user/data_mdc/*.conf $config_s3/mdcdir_confinfo_dir/>/dev/null 2>&1
        if [ $? != 0 ] ;then
            {
                log "collect mdcdir_spaceinfo failed."
                echo "collect mdcdir_spaceinfo failed.."
            }
        fi
        
        sudo /usr/bin/du -sh  /var/uds/user/data_upf/ >>  $upfdir_spaceinfo  2>&1
        cp -rf /var/uds/user/data_upf/PG_VERSION  /var/uds/user/data_upf/*.conf $config_s3/upfdir_confinfo_dir/>/dev/null 2>&1

        if [ $? != 0 ] ;then
            {
                log "collect upfdir_spaceinfo failed."
                echo "collect upfdir_spaceinfo failed.."
            }
        fi
    else
        log "node is not s3 management node"
        echo "node is not s3 management node"
    fi
}

#regionϢregionϵ
function getRegionInfo()
{
    log "start collect region info..."
    #ɻ򸲸regionInformation_containsRegionRelations.txt
    regionInforFile="${CMLogDir}/Config/s3/regionInformation_containsRegionRelations.txt"
    echo "**********The Region and Region relations Information**********">$regionInforFile 2>&1
    aksk=`/opt/huawei/snas/script/LsHelper.py ADMIN GET`
    tag=${aksk:0:1}
    #tag == '{'ôakskȡʧ
    if [ "$tag" == '{' ]
    then
        echo "get admin info result is: $aksk, fail to get admin ak">>$regionInforFile 2>&1
        echo "failed to get Region infos, so collect of region info failed">>$regionInforFile 2>&1
        return 0
    fi
    
    i=`expr index $aksk ':'`
    ak=${aksk:0:i-1}
    sk=${aksk:i}
    log "collect region info: index of ':' is $i, ak is $ak"
    
    #ѯregionϢдregionInformation_containsRegionRelations.txt
    echo "Region:">>$regionInforFile 2>&1
    temp=`/opt/huawei/snas/script/LsHelper.py REGION LIST $ak $sk`
    i=`expr index $temp ':'`
    j=`expr index $temp ','`
    rc=${temp:i:j-i-1}
    if [ "$rc" != 0 ]
    then
        log "error:failed to get Region config, get $temp"
        echo "error:failed to get Region config, get $temp">>$regionInforFile 2>&1
    else
        echo $temp>>$regionInforFile 2>&1
    fi
    
    echo "AZ:">>$regionInforFile 2>&1
    temp=`/opt/huawei/snas/script/LsHelper.py AZ LIST $ak $sk`
    i=`expr index $temp ':'`
    j=`expr index $temp ','`
    rc=${temp:i:j-i-1}
    if [ "$rc" != 0 ]
    then
        log "error:failed to get AZ config, get $temp"
        echo "error:failed to get AZ config, get $temp">>$regionInforFile 2>&1
    else
        echo $temp>>$regionInforFile 2>&1
    fi
    
    echo "CLUSTER:">>$regionInforFile 2>&1
    temp=`/opt/huawei/snas/script/LsHelper.py CLUSTER LIST $ak $sk`
    i=`expr index $temp ':'`
    j=`expr index $temp ','`
    rc=${temp:i:j-i-1}
    if [ "$rc" != 0 ]
    then
        log "error:failed to get CLUSTER config, get $temp"
        echo "error:failed to get CLUSTER config, get $temp">>ec$regionInforFile 2>&1
    else
        echo $temp>>$regionInforFile 2>&1
    fi
    
    echo "CLUSTER GROUP:">>$regionInforFile 2>&1
    temp=`/opt/huawei/snas/script/LsHelper.py CG LIST $ak $sk`
    i=`expr index $temp ':'`
    j=`expr index $temp ','`
    rc=${temp:i:j-i-1}
    if [ "$rc" != 0 ]
    then
        log "error:failed to get CG config, get $temp"
        echo "error:failed to get CG config, get $temp">>$regionInforFile 2>&1
    else
        echo $temp>>$regionInforFile 2>&1
    fi
    
    log "collect region infos finished."
}
#S3Ϣռ
function collectOSSInfo()
{
    local ConfigDir="${CMLogDir}/Config/s3"
    local OldUdsFile="${ConfigDir}/ErasureCodeDecodingMat"
    mkdir -p "${ConfigDir}"
    log "start collect s3 config information."
    cp -fpr /opt/obs/dns/conf/* "${ConfigDir}"
    cp -fpr /opt/obs/obsconf/* "${ConfigDir}"
    cp -fp /opt/obs/service/osc/policy.properties "${ConfigDir}"
    cp -fp /opt/huawei/snas/etc/snas.ini "${ConfigDir}"
    cp -fp /opt/huawei/snas/etc/cm.ini "${ConfigDir}"
    cp -fp /opt/huawei/snas/etc/multiaz.ini "${ConfigDir}"
    #ɾUDSļ
    if [ -f $OldUdsFile ];then
        rm -rf $OldUdsFile
    fi
    getRegionInfo
    #ϢռHAڵMDC/UPFĿ¼ռС
    collectMdcUpfDir

    cp -fp /opt/obs/service/osc/policy.properties "${ConfigDir}"
    cp -fp /opt/huawei/snas/etc/snas.ini "${ConfigDir}"
    cp -fp /opt/huawei/snas/etc/cm.ini "${ConfigDir}"
    cp -fp /opt/huawei/snas/etc/multiaz.ini "${ConfigDir}"
    #ɾռظSwiftϢ
    rm -rf  "${ConfigDir}/swift"    
    if [ $ServiceType -eq 0 ];then
    #SwiftϢ
    local SwiftConfigDir="${CMLogDir}/Config/swift"
    mkdir -p "${SwiftConfigDir}"
    log [$SUBNAME]"start collect swift config information."

    cp -fpr /opt/obs/obsconf/swift* "${SwiftConfigDir}"
    if [ "$SERVICE_TYPE" == "vm" ]; then
        local vmmsConfigDir="${CMLogDir}/Config/vmms/conf"
        mkdir -p "${vmmsConfigDir}"
        log [$SUBNAME]"start collect swift config information."
        cp -fpr /var/vmms/conf/* "${vmmsConfigDir}" 
    else
        log [$SUBNAME]"SERVICE_TYPE($SERVICE_TYPE) is not vm"
        fi
    fi
}

function main()
{
    if [ "X${type}" == "Xconfig" ];then
        log [$SUBNAME]"start collect config"
        collectOSSInfo
        log [$SUBNAME]"end collect config"
        return 0
    elif [ "X${type}" == "Xlog" ];then
        if [ "X$begin_time" != "Xnull" -o "X$end_time" != "Xnull" ];then
            g_OSS_collect_bysize=0
            log_size="0" 
        fi
        OSS_collect "OSS" "${begin_time}" "${end_time}" "${log_size}"
        return $?
    else
        usage
        return 1
    fi
    return 1
}

type=$1
product_name=$2
version=$3
output_file=$4
begin_time=$5
end_time=$6
log_size=$7

#жϲƷ
judge_product_type
#product_type
prepare

main
exit $?