#!/bin/sh
set +x
CM_DB="/opt/huawei/snas/etc/cm_conf.db"
LOG_FILE="/var/log/inspect.log"
G_TMP_INSPECT_PATH="/var/log/inspect/"

function LOG
{
    time=$(date)
    echo [${time}][$$]$@ >> $LOG_FILE
}

#获取后端可以ping通的后端ip
GetLocalIp()
{
    local snas_ini_file="/opt/huawei/snas/etc/snas.ini"
    local IpIndex=1
    local subnetwork_id
    local BackendIp
    local IpNum
    IpNum=`cat ${snas_ini_file} | grep "ipaddr_" | wc -l`

    while [ "$IpIndex" -le "$IpNum" ]; do
        subnetwork_id=`grep "subnetwork_id_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
        if [ -z "${subnetwork_id}" ]; then
            continue
        fi

        if [ ${subnetwork_id} -eq 1 ]; then
            BackendIp=`grep "ipaddr_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
            ping "${BackendIp}" -f -c 2 -w 2 >/dev/null 2>&1
            if [ $? -ne 0 ]; then
                IpIndex=$((IpIndex + 1))
                continue
            else
                echo ${BackendIp}
                break
            fi
        fi

        IpIndex=$((IpIndex + 1))
    done
}

#获取后端ip,但是并不判断ip是否可以ping通
GetLocalIpNoPing()
{
    local snas_ini_file="/opt/huawei/snas/etc/snas.ini"
    local IpIndex=1
    local subnetwork_id
    local BackendIp
    local IpNum
    IpNum=`cat ${snas_ini_file} | grep "ipaddr_" | wc -l`

    while [ "$IpIndex" -le "$IpNum" ]; do
        subnetwork_id=`grep "subnetwork_id_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
        if [ -z "${subnetwork_id}" ]; then
            continue
        fi

        if [ ${subnetwork_id} -eq 1 ]; then
            BackendIp=`grep "ipaddr_${IpIndex}" ${snas_ini_file} 2>/dev/null | awk -F "=" '{print $2}'`
            if [ -z "${BackendIp}" ] || [ "${BackendIp}" == '""' ]; then
                IpIndex=$((IpIndex + 1))
                continue
            else
                echo ${BackendIp}
                break
            fi
        fi

        IpIndex=$((IpIndex + 1))
    done
}

#===================================================
# 函数名称：获取集群是否是单节点lite部署
# 函数功能：
# 描述：
#===================================================
function get_cluster_lite_deploy()
{
    local node_num=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select count(*) from (select * from CM_NODE_T)")
    if [ $node_num -eq 1 ];then
        return 0
    else
        return 1
    fi
}

#===================================================
# 函数名称：获取节点后端口
# 函数功能：
# 描述：
#===================================================
function get_lite_backup_netport()
{
    local backup_port=$(sqlite3 /opt/huawei/snas/etc/cm_conf.db "select CARD_NAME from CM_NODE_NETCARD_T where SUBNET_ID=1")
    echo ${backup_port}
}

#===================================================
# 函数名称：获取cm_conf.db中节点对应的服务类型
# 函数功能：
# 描述：
#===================================================
function get_service_type_from_db()
{
    local temp=1
    local ip=$1
    local nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
    while [[ "${nid}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get nid from db ,temp=$temp"
        nid=$(/usr/bin/sqlite3 ${CM_DB} "select NID from CM_NODE_IP_T where IP_ADDR='${ip}'"| tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done
    temp=1
    local service_type=$(/usr/bin/sqlite3 ${CM_DB} "select Reserved2 from CM_NODE_T where NID='${nid}'" | tr -d ' ')
    while [[ "${service_type}" == "" ]]
    do
        sleep 2
        LOG "[$FUNCNAME]Failed to get service_type from db ,temp=$temp"
        service_type=$(/usr/bin/sqlite3 ${CM_DB} "select Reserved2 from CM_NODE_T where NID='${nid}'" | tr -d ' ')
        temp=$((temp + 1))
        if [ $temp -gt 10 ];then
            temp=1
            break
        fi
    done

    echo ${service_type}
}

#获取OFED版本
function GetOFEDVersion()
{
    local ofedVer="NULL"
    local tmpInfo=""
    local iRet=0
    tmpInfo=$(ofed_info -s)
    iRet=$?
    if [ $? -ne 0 ];then
        LOG "[$FUNCNAME][$LINENO]get ofed info fail,iRet=${iRet},tmpInfo=${tmpInfo}"
        echo ${ofedVer}
        return 0
    fi

    if [[ "${tmpInfo}" =~ "MLNX_OFED_LINUX-3.2" ]];then
        ofedVer="3.2"
    elif [[ "${tmpInfo}" =~ "MLNX_OFED_LINUX-4.2" ]];then
        ofedVer="4.2"
    elif [[ "${tmpInfo}" =~ "OFED-internal-4.4" ]];then
        ofedVer="4.4"
    elif [[ "${tmpInfo}" =~ "OFA-LINUX-4.17" ]];then
        ofedVer="4.17"
    else
        ofedVer="NULL"
        LOG "[$FUNCNAME][$LINENO]no match ofed info,tmpInfo=${tmpInfo}"
    fi

    echo ${ofedVer}
    return 0
}

#判断CM主返回1：CM主  0：非主
function isMaster()
{
    local tmpInfo=""
    local masterNodeName=""
    local localnodeName=$(hostname)
    tmpInfo=$(/usr/local/bin/MmlBatch 4016 "cm master" | grep "Node Name" | sed -e 's/\x1B\[0;[3-4][0-9]m//g' -e 's/\x0D//g' -e 's/\x00//g')
    masterNodeName=$(echo "${tmpInfo}" | sed 's/Node Name: //')
    if [ "${masterNodeName}" = "${localnodeName}" ];then
        return  0
    else
        return  1
    fi
}

#===================================================
# 函数名称：
# 函数功能：获取当前toolkit是否是大陆版本
# 描述：是返回true，不是返回false
#===================================================
function GetAreaKey()
{
    local areaKeyFile="/opt/inspect/toolkit.app.zh.version"
    local resultInfo=""
    if [ -f ${areaKeyFile} ];then
        resultInfo=$(cat ${areaKeyFile})
    fi

    resultInfo=${resultInfo:-false}
    echo ${resultInfo}
}

#===================================================
# 函数名称：
# 函数功能：比较两个版本号的关系(xx.xx.xx.xx)格式的版本号
# 描述：大于返回greater,小于返回less,等于返回equal
#===================================================
function CheckRecommendVerVersion()
{
    local localVer=""
    local recommendVer=""
    local length=$3
    length=${length:-4}

    if [ $length -eq 2 ];then
        localVer=$(echo "$1" |  grep -Po '(?<=)[0-9]+\.[0-9]+')
        recommendVer=$(echo "$2" |  grep -Po '(?<=)[0-9]+\.[0-9]+')
    else
        localVer=$(echo "$1" |  grep -Po '(?<=)[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+')
        recommendVer=$(echo "$2" |  grep -Po '(?<=)[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+')
 
    fi
    if [[ "${localVer}" == "" ]] || [[ "${recommendVer}" == "" ]];then
        #ver格式不对
        echo "Err"
        return
    fi

    for((index=1; index<=${length}; index++))
    do
        local lVer=$(echo "$localVer" | awk -F'.' '{print $'"${index}"'}')
        local rVer=$(echo "$recommendVer" | awk -F'.' '{print $'"${index}"'}')
        if [ $lVer -gt $rVer ];then
            echo "greater"
            return
        elif [ $lVer -lt $rVer ];then
            echo "less"
            return
        fi
    done
    echo "equal"
}

#ERR错误格式打印,只能用于巡检mml的脚本里面
function ErrInfoCommon()
{
    local input="$1"
    local filepath="$2"
    echo "[ERR]${input}" >> ${filepath} 2>&1
}
